const cleanValue = (value, options) => {
  if (Array.isArray(value)) {
    const filtered = value.filter(Boolean);
    return (filtered == null ? undefined : filtered.length) ? filtered : undefined;
  }
  if (typeof value === "object") {
    return [value];
  }
  if (typeof value === "string" || typeof value === "number") {
    const selectedValue = findSelectedValue(value, options);
    if (selectedValue) {
      return [selectedValue];
    }
  }
  return undefined;
};
const findSelectedValue = (value, options) => {
  for (const option of options) {
    if ("options" in option) {
      let found = findSelectedValue(value, option.options);
      if (found) {
        return found;
      }
    } else if ("value" in option && option.value === value) {
      return option;
    }
  }
  return null;
};
const omitDescriptions = (options) => {
  return options.map(({ description, ...rest }) => rest);
};

export { cleanValue, findSelectedValue, omitDescriptions };
//# sourceMappingURL=utils.mjs.map
