import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { InlineList } from '../List/InlineList.mjs';
import { List } from '../List/List.mjs';
import { VizLegendListItem } from './VizLegendListItem.mjs';

const VizLegendList = ({
  items,
  itemRenderer,
  onLabelMouseOver,
  onLabelMouseOut,
  onLabelClick,
  placement,
  className,
  readonly
}) => {
  const styles = useStyles2(getStyles);
  if (!itemRenderer) {
    itemRenderer = (item) => /* @__PURE__ */ jsx(
      VizLegendListItem,
      {
        item,
        onLabelClick,
        onLabelMouseOver,
        onLabelMouseOut,
        readonly
      }
    );
  }
  const getItemKey = (item) => `${item.getItemKey ? item.getItemKey() : item.label}`;
  switch (placement) {
    case "right": {
      const renderItem = (item, index) => {
        return /* @__PURE__ */ jsx("span", { className: styles.itemRight, children: itemRenderer(item, index) });
      };
      return /* @__PURE__ */ jsx("div", { className: cx(styles.rightWrapper, className), children: /* @__PURE__ */ jsx(List, { items, renderItem, getItemKey }) });
    }
    case "bottom":
    default: {
      const leftItems = items.filter((item) => item.yAxis === 1);
      const rightItems = items.filter((item) => item.yAxis !== 1);
      const renderItem = (item, index) => {
        return /* @__PURE__ */ jsx("span", { className: styles.itemBottom, children: itemRenderer(item, index) });
      };
      return /* @__PURE__ */ jsxs("div", { className: cx(styles.bottomWrapper, className), children: [
        leftItems.length > 0 && /* @__PURE__ */ jsx("div", { className: styles.section, children: /* @__PURE__ */ jsx(InlineList, { items: leftItems, renderItem, getItemKey }) }),
        rightItems.length > 0 && /* @__PURE__ */ jsx("div", { className: cx(styles.section, styles.sectionRight), children: /* @__PURE__ */ jsx(InlineList, { items: rightItems, renderItem, getItemKey }) })
      ] });
    }
  }
};
VizLegendList.displayName = "VizLegendList";
const getStyles = (theme) => {
  const itemStyles = css({
    paddingRight: "10px",
    display: "flex",
    fontSize: theme.typography.bodySmall.fontSize,
    whiteSpace: "nowrap"
  });
  return {
    itemBottom: itemStyles,
    itemRight: cx(
      itemStyles,
      css({
        marginBottom: theme.spacing(0.5)
      })
    ),
    rightWrapper: css({
      padding: theme.spacing(0.5)
    }),
    bottomWrapper: css({
      display: "flex",
      flexWrap: "wrap",
      justifyContent: "space-between",
      width: "100%",
      padding: theme.spacing(0.5),
      gap: "15px 25px"
    }),
    section: css({
      display: "flex"
    }),
    sectionRight: css({
      justifyContent: "flex-end",
      flexGrow: 1,
      flexBasis: "50%"
    })
  };
};

export { VizLegendList };
//# sourceMappingURL=VizLegendList.mjs.map
