import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.mjs';

const TimeZoneTitle = ({ title }) => {
  const styles = useStyles2(getStyles);
  if (!title) {
    return null;
  }
  return /* @__PURE__ */ jsx("span", { className: styles.title, children: title });
};
const getStyles = (theme) => {
  return {
    title: css({
      fontWeight: theme.typography.fontWeightRegular,
      textOverflow: "ellipsis"
    })
  };
};

export { TimeZoneTitle };
//# sourceMappingURL=TimeZoneTitle.mjs.map
