import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { Icon } from '../Icon/Icon.mjs';

const Label = ({ children, description, className, category, ...labelProps }) => {
  const styles = useStyles2(getLabelStyles);
  const categories = category == null ? undefined : category.map((c, i) => {
    return /* @__PURE__ */ jsxs("span", { className: styles.categories, children: [
      /* @__PURE__ */ jsx("span", { children: c }),
      /* @__PURE__ */ jsx(Icon, { name: "angle-right", className: styles.chevron })
    ] }, `${c}/${i}`);
  });
  return /* @__PURE__ */ jsx("div", { className: cx(styles.label, className), children: /* @__PURE__ */ jsxs("label", { ...labelProps, children: [
    /* @__PURE__ */ jsxs("div", { className: styles.labelContent, children: [
      categories,
      children
    ] }),
    description && /* @__PURE__ */ jsx("span", { className: styles.description, children: description })
  ] }) });
};
const getLabelStyles = (theme) => ({
  label: css({
    label: "Label",
    fontSize: theme.typography.size.sm,
    fontWeight: theme.typography.fontWeightMedium,
    lineHeight: 1.25,
    marginBottom: theme.spacing(0.5),
    color: theme.colors.text.primary,
    maxWidth: "480px"
  }),
  labelContent: css({
    display: "flex",
    alignItems: "center"
  }),
  description: css({
    label: "Label-description",
    color: theme.colors.text.secondary,
    fontSize: theme.typography.size.sm,
    fontWeight: theme.typography.fontWeightRegular,
    marginTop: theme.spacing(0.25),
    display: "block"
  }),
  categories: css({
    label: "Label-categories",
    display: "inline-flex",
    alignItems: "center"
  }),
  chevron: css({
    margin: theme.spacing(0, 0.25)
  })
});

export { Label, getLabelStyles };
//# sourceMappingURL=Label.mjs.map
