import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { memo, useRef, useState, useEffect } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { useMenuFocus } from './hooks.mjs';
import { isElementOverflowing } from './utils.mjs';

const SubMenu = memo(({ items, isOpen, close, customStyle }) => {
  const styles = useStyles2(getStyles);
  const localRef = useRef(null);
  const [handleKeys] = useMenuFocus({
    localRef,
    isMenuOpen: isOpen,
    close
  });
  const [pushLeft, setPushLeft] = useState(false);
  useEffect(() => {
    if (isOpen && localRef.current) {
      setPushLeft(isElementOverflowing(localRef.current));
    }
  }, [isOpen]);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("div", { className: styles.iconWrapper, "aria-hidden": true, "data-testid": selectors.components.Menu.SubMenu.icon, children: /* @__PURE__ */ jsx(Icon, { name: "angle-right", className: styles.icon }) }),
    isOpen && /* @__PURE__ */ jsx(
      "div",
      {
        ref: localRef,
        className: cx(styles.subMenu, { [styles.pushLeft]: pushLeft }),
        "data-testid": selectors.components.Menu.SubMenu.container,
        style: customStyle,
        children: /* @__PURE__ */ jsx("div", { tabIndex: -1, className: styles.itemsWrapper, role: "menu", onKeyDown: handleKeys, children: items })
      }
    )
  ] });
});
SubMenu.displayName = "SubMenu";
const getStyles = (theme) => {
  return {
    iconWrapper: css({
      display: "flex",
      flex: 1,
      justifyContent: "end"
    }),
    icon: css({
      opacity: 0.7,
      marginLeft: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    itemsWrapper: css({
      background: theme.colors.background.elevated,
      padding: theme.spacing(0.5),
      boxShadow: theme.shadows.z3,
      display: "inline-block",
      borderRadius: theme.shape.radius.default
    }),
    pushLeft: css({
      right: "100%",
      left: "unset"
    }),
    subMenu: css({
      position: "absolute",
      top: 0,
      left: "100%",
      zIndex: theme.zIndex.dropdown
    })
  };
};

export { SubMenu };
//# sourceMappingURL=SubMenu.mjs.map
