import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { memo } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { EditorRows, EditorRow, EditorField, EditorSwitch } from '@grafana/plugin-ui';
import { AutoSizeInput, Space, Input } from '@grafana/ui';
import { PromQueryCodeEditor } from '../querybuilder/components/PromQueryCodeEditor.mjs';

const PLACEHOLDER_TITLE = "{{alertname}}";
const PLACEHOLDER_TEXT = "{{instance}}";
const PLACEHOLDER_TAGS = "label1,label2";
const AnnotationQueryEditor = memo(function AnnotationQueryEditor2(props) {
  var _a, _b, _c, _d, _e;
  const { annotation, onAnnotationChange, onChange, onRunQuery, query } = props;
  if (!annotation || !onAnnotationChange) {
    return /* @__PURE__ */ jsx("h3", { children: "annotation data load error!" });
  }
  const handleMinStepChange = (value) => {
    onChange({ ...query, interval: value });
  };
  const handleTitleChange = (value) => {
    onAnnotationChange({
      ...annotation,
      titleFormat: value
    });
  };
  const handleTagsChange = (value) => {
    onAnnotationChange({
      ...annotation,
      tagKeys: value
    });
  };
  const handleTextChange = (value) => {
    onAnnotationChange({
      ...annotation,
      textFormat: value
    });
  };
  const handleUseValueForTimeChange = (checked) => {
    onAnnotationChange({
      ...annotation,
      useValueForTime: checked
    });
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(EditorRows, { children: [
      /* @__PURE__ */ jsx(PromQueryCodeEditor, { ...props, query, showExplain: false, onRunQuery, onChange }),
      /* @__PURE__ */ jsx(EditorRow, { children: /* @__PURE__ */ jsx(
        EditorField,
        {
          label: "Min step",
          tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
            "An additional lower limit for the step parameter of the Prometheus query and for the",
            " ",
            /* @__PURE__ */ jsx("code", { children: "$__interval" }),
            " and ",
            /* @__PURE__ */ jsx("code", { children: "$__rate_interval" }),
            " variables."
          ] }),
          children: /* @__PURE__ */ jsx(
            AutoSizeInput,
            {
              type: "text",
              "aria-label": "Set lower limit for the step parameter",
              placeholder: "auto",
              minWidth: 10,
              value: (_a = query.interval) != null ? _a : "",
              onChange: (e) => handleMinStepChange(e.currentTarget.value),
              id: selectors.components.DataSource.Prometheus.annotations.minStep
            }
          )
        }
      ) })
    ] }),
    /* @__PURE__ */ jsx(Space, { v: 0.5 }),
    /* @__PURE__ */ jsxs(EditorRow, { children: [
      /* @__PURE__ */ jsx(
        EditorField,
        {
          label: "Title",
          tooltip: "Use either the name or a pattern. For example, {{instance}} is replaced with label value for the label instance.",
          children: /* @__PURE__ */ jsx(
            Input,
            {
              type: "text",
              placeholder: PLACEHOLDER_TITLE,
              value: (_b = annotation.titleFormat) != null ? _b : "",
              onChange: (event) => handleTitleChange(event.currentTarget.value),
              "data-testid": selectors.components.DataSource.Prometheus.annotations.title
            }
          )
        }
      ),
      /* @__PURE__ */ jsx(EditorField, { label: "Tags", children: /* @__PURE__ */ jsx(
        Input,
        {
          type: "text",
          placeholder: PLACEHOLDER_TAGS,
          value: (_c = annotation.tagKeys) != null ? _c : "",
          onChange: (event) => handleTagsChange(event.currentTarget.value),
          "data-testid": selectors.components.DataSource.Prometheus.annotations.tags
        }
      ) }),
      /* @__PURE__ */ jsx(
        EditorField,
        {
          label: "Text",
          tooltip: "Use either the name or a pattern. For example, {{instance}} is replaced with label value for the label instance.",
          children: /* @__PURE__ */ jsx(
            Input,
            {
              type: "text",
              placeholder: PLACEHOLDER_TEXT,
              value: (_d = annotation.textFormat) != null ? _d : "",
              onChange: (event) => handleTextChange(event.currentTarget.value),
              "data-testid": selectors.components.DataSource.Prometheus.annotations.text
            }
          )
        }
      ),
      /* @__PURE__ */ jsx(
        EditorField,
        {
          label: "Series value as timestamp",
          tooltip: "The unit of timestamp is milliseconds. If the unit of the series value is seconds, multiply its range vector by 1000.",
          children: /* @__PURE__ */ jsx(
            EditorSwitch,
            {
              value: (_e = annotation.useValueForTime) != null ? _e : false,
              onChange: (event) => handleUseValueForTimeChange(event.currentTarget.checked),
              "data-testid": selectors.components.DataSource.Prometheus.annotations.seriesValueAsTimestamp
            }
          )
        }
      )
    ] })
  ] });
});

export { AnnotationQueryEditor };
//# sourceMappingURL=AnnotationQueryEditor.mjs.map
