import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useEffect } from 'react';
import { useForm } from 'react-hook-form';

function Form({
  defaultValues,
  onSubmit,
  validateOnMount = false,
  validateFieldsOnMount,
  children,
  validateOn = "onSubmit",
  maxWidth = 600,
  ...htmlProps
}) {
  const { handleSubmit, trigger, formState, ...rest } = useForm({
    mode: validateOn,
    defaultValues
  });
  useEffect(() => {
    if (validateOnMount) {
      trigger(validateFieldsOnMount);
    }
  }, [trigger, validateFieldsOnMount, validateOnMount]);
  return /* @__PURE__ */ jsx(
    "form",
    {
      className: css({
        maxWidth: maxWidth !== "none" ? maxWidth + "px" : maxWidth,
        width: "100%"
      }),
      onSubmit: handleSubmit(onSubmit),
      ...htmlProps,
      children: children({ errors: formState.errors, formState, trigger, ...rest })
    }
  );
}

export { Form };
//# sourceMappingURL=Form.mjs.map
