import { FALLBACK_COLOR } from '../types/fieldColor.mjs';
import { ThresholdsMode } from '../types/thresholds.mjs';

const fallBackThreshold = { value: 0, color: FALLBACK_COLOR };
function getActiveThreshold(value, thresholds) {
  if (!thresholds || thresholds.length === 0) {
    return fallBackThreshold;
  }
  let active = thresholds[0];
  for (const threshold of thresholds) {
    if (value >= threshold.value) {
      active = threshold;
    } else {
      break;
    }
  }
  return active;
}
function getActiveThresholdForValue(field, value, percent) {
  const { thresholds } = field.config;
  if ((thresholds == null ? undefined : thresholds.mode) === ThresholdsMode.Percentage) {
    return getActiveThreshold(percent * 100, thresholds == null ? undefined : thresholds.steps);
  }
  return getActiveThreshold(value, thresholds == null ? undefined : thresholds.steps);
}
function sortThresholds(thresholds) {
  return thresholds.sort((t1, t2) => t1.value - t2.value);
}

export { fallBackThreshold, getActiveThreshold, getActiveThresholdForValue, sortThresholds };
//# sourceMappingURL=thresholds.mjs.map
