import { jsx } from 'react/jsx-runtime';
import { memo } from 'react';
import { CoreApp } from '@grafana/data';
import { PromQueryEditorSelector } from '../querybuilder/components/PromQueryEditorSelector.js';
import { PromQueryEditorForAlerting } from './PromQueryEditorForAlerting.js';

function PromQueryEditorByAppBase(props) {
  const { app } = props;
  switch (app) {
    case CoreApp.CloudAlerting:
      return /* @__PURE__ */ jsx(PromQueryEditorForAlerting, { ...props });
    default:
      return /* @__PURE__ */ jsx(PromQueryEditorSelector, { ...props });
  }
}
const PromQueryEditorByApp = memo(PromQueryEditorByAppBase);

export { PromQueryEditorByApp };
//# sourceMappingURL=PromQueryEditorByApp.js.map
