import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { forwardRef } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { Box } from '../Layout/Box/Box.js';
import { ScrollIndicators } from './ScrollIndicators.js';

const ScrollContainer = forwardRef(
  ({
    children,
    showScrollIndicators = false,
    onScroll,
    overflowX = "auto",
    overflowY = "auto",
    scrollbarWidth = "thin",
    ...rest
  }, ref) => {
    const styles = useStyles2(getStyles, scrollbarWidth, overflowY, overflowX);
    const defaults = {
      maxHeight: "100%",
      minHeight: 0
    };
    const boxProps = { ...defaults, ...rest };
    return /* @__PURE__ */ jsx(Box, { ...boxProps, display: "flex", direction: "column", flex: 1, position: "relative", children: /* @__PURE__ */ jsx("div", { onScroll, className: styles.scroller, ref, children: showScrollIndicators ? /* @__PURE__ */ jsx(ScrollIndicators, { children }) : children }) });
  }
);
ScrollContainer.displayName = "ScrollContainer";
const getStyles = (theme, scrollbarWidth, overflowY, overflowX) => ({
  scroller: css({
    display: "flex",
    flex: 1,
    flexDirection: "column",
    overflowX,
    overflowY,
    scrollbarWidth
  })
});

export { ScrollContainer };
//# sourceMappingURL=ScrollContainer.js.map
