import { jsx } from 'react/jsx-runtime';
import { useRef } from 'react';
import { MonacoQueryFieldLazy } from './MonacoQueryFieldLazy.js';

const MonacoQueryFieldWrapper = (props) => {
  const lastRunValueRef = useRef(null);
  const { onRunQuery, onChange, ...rest } = props;
  const handleRunQuery = (value) => {
    lastRunValueRef.current = value;
    onChange(value);
    onRunQuery();
  };
  const handleBlur = (value) => {
    onChange(value);
  };
  const handleChange = (value) => {
    onChange(value);
  };
  return /* @__PURE__ */ jsx(MonacoQueryFieldLazy, { onChange: handleChange, onRunQuery: handleRunQuery, onBlur: handleBlur, ...rest });
};

export { MonacoQueryFieldWrapper };
//# sourceMappingURL=MonacoQueryFieldWrapper.js.map
