import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import RCCascader from 'rc-cascader';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { Button } from '../Button/Button.js';
import '../Button/ButtonGroup.js';
import { onChangeCascader, onLoadDataCascader } from '../Cascader/optionMappings.js';
import { getCascaderStyles } from '../Cascader/styles.js';
import { Icon } from '../Icon/Icon.js';

const ButtonCascader = (props) => {
  const { onChange, className, loadData, icon, buttonProps, hideDownIcon, variant, disabled, ...rest } = props;
  const styles = useStyles2(getStyles);
  const cascaderStyles = useStyles2(getCascaderStyles);
  let content = props.children;
  if (!hideDownIcon) {
    content = [props.children, /* @__PURE__ */ jsx(Icon, { name: "angle-down", className: styles.icons.right }, "down-icon")];
  }
  return /* @__PURE__ */ jsx(
    RCCascader,
    {
      onChange: onChangeCascader(onChange),
      loadData: onLoadDataCascader(loadData),
      dropdownClassName: cx(cascaderStyles.dropdown, styles.popup),
      ...rest,
      expandIcon: null,
      children: /* @__PURE__ */ jsx(Button, { icon, disabled, variant, ...buttonProps != null ? buttonProps : {}, children: content })
    }
  );
};
ButtonCascader.displayName = "ButtonCascader";
const getStyles = (theme) => {
  return {
    popup: css({
      label: "popup",
      zIndex: theme.zIndex.dropdown
    }),
    icons: {
      right: css({
        margin: "1px 0 0 4px"
      }),
      left: css({
        margin: "-1px 4px 0 0"
      })
    }
  };
};

export { ButtonCascader };
//# sourceMappingURL=ButtonCascader.js.map
