import { FieldType } from '../types/dataFrame.js';
import '@grafana/schema';
import '../datetime/moment_wrapper.js';
import '../types/datasource.js';
import 'lodash';
import '../types/legacyEvents.js';
import { FunctionalVector } from './FunctionalVector.js';

class IndexVector extends FunctionalVector {
  constructor(len) {
    super();
    this.len = len;
  }
  get length() {
    return this.len;
  }
  get(index) {
    return index;
  }
  /**
   * Returns a field representing the range [0 ... length-1]
   */
  static newField(len) {
    return {
      name: "",
      values: new IndexVector(len),
      type: FieldType.number,
      config: {
        min: 0,
        max: len - 1
      }
    };
  }
}

export { IndexVector };
//# sourceMappingURL=IndexVector.js.map
