import { formattedValueToString } from '../valueFormats/valueFormats.js';
import { FunctionalVector } from './FunctionalVector.js';

class FormattedVector extends FunctionalVector {
  constructor(source, formatter) {
    super();
    this.source = source;
    this.formatter = formatter;
  }
  get length() {
    return this.source.length;
  }
  get(index) {
    const v = this.source.get(index);
    return formattedValueToString(this.formatter(v));
  }
}

export { FormattedVector };
//# sourceMappingURL=FormattedVector.js.map
