import { vectorToArray } from './vectorToArray.js';

class BinaryOperationVector {
  constructor(left, right, operation) {
    this.left = left;
    this.right = right;
    this.operation = operation;
  }
  get length() {
    return this.left.length;
  }
  get(index) {
    return this.operation(this.left.get(index), this.right.get(index));
  }
  toArray() {
    return vectorToArray(this);
  }
  toJSON() {
    return vectorToArray(this);
  }
}

export { BinaryOperationVector };
//# sourceMappingURL=BinaryOperationVector.js.map
