import { FieldMatcherID } from '../matchers/ids.js';
import { filterFieldsTransformer } from './filter.js';
import { DataTransformerID } from './ids.js';

const filterFieldsByNameTransformer = {
  id: DataTransformerID.filterFieldsByName,
  name: "Filter fields by name",
  description: "select a subset of fields",
  defaultOptions: {},
  /**
   * Return a modified copy of the series.  If the transform is not or should not
   * be applied, just return the input series
   */
  operator: (options, replace) => (source) => source.pipe(
    filterFieldsTransformer.operator(
      {
        include: getMatcherConfig(options.include),
        exclude: getMatcherConfig(options.exclude)
      },
      replace
    )
  )
};
const getMatcherConfig = (options) => {
  if (!options) {
    return void 0;
  }
  const { names, pattern } = options;
  if ((!Array.isArray(names) || names.length === 0) && !pattern) {
    return void 0;
  }
  if (!pattern) {
    return { id: FieldMatcherID.byNames, options: { names } };
  }
  if (!Array.isArray(names) || names.length === 0) {
    return { id: FieldMatcherID.byRegexp, options: pattern };
  }
  return { id: FieldMatcherID.byRegexpOrNames, options };
};

export { filterFieldsByNameTransformer, getMatcherConfig };
//# sourceMappingURL=filterByName.js.map
