import { FieldType } from '../types/dataFrame.js';
import { getTimeField } from './processDataFrame.js';

function isTimeSeriesFrame(frame) {
  if (frame.fields.length > 2) {
    return false;
  }
  return Boolean(frame.fields.find((field) => field.type === FieldType.time));
}
function isTimeSeriesFrames(data) {
  return !data.find((frame) => !isTimeSeriesFrame(frame));
}
function anySeriesWithTimeField(data) {
  for (let i = 0; i < data.length; i++) {
    const timeField = getTimeField(data[i]);
    if (timeField.timeField !== void 0 && timeField.timeIndex !== void 0) {
      return true;
    }
  }
  return false;
}

export { anySeriesWithTimeField, isTimeSeriesFrame, isTimeSeriesFrames };
//# sourceMappingURL=utils.js.map
