'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var css = require('@emotion/css');
var React = require('react');
var classNames = require('classnames');
var SVG = require('react-inlinesvg');
var data = require('@grafana/data');
var hoistNonReactStatics = require('hoist-non-react-statics');
var memoizeOne = require('memoize-one');
var reactPopperTooltip = require('react-popper-tooltip');
var ReactDOM = require('react-dom');
var react = require('@emotion/react');
var tinycolor = require('tinycolor2');
var lodash = require('lodash');
var slate = require('slate');
var ansicolor = require('ansicolor');
var ReactSelect = require('react-select');
var ReactAsyncSelect = require('react-select/async');
var Creatable = require('react-select/creatable');
var Scrollbars = require('react-custom-scrollbars-2');
var reactTransitionGroup = require('react-transition-group');
var reactPopper = require('react-popper');
var Transition = require('react-transition-group/Transition');
var e2eSelectors = require('@grafana/e2e-selectors');
var i18next = require('i18next');
var reactI18next = require('react-i18next');
var RCCascader = require('rc-cascader');
var useMeasure = require('react-use/lib/useMeasure');
var AsyncCreatable = require('react-select/async-creatable');
var reactWindow = require('react-window');
var focus = require('@react-aria/focus');
var reactColorful = require('react-colorful');
var reactUse = require('react-use');
var formatDuration = require('date-fns/formatDuration');
var button = require('@react-aria/button');
var menu$1 = require('@react-aria/menu');
var menu = require('@react-stately/menu');
var dialog = require('@react-aria/dialog');
var overlays = require('@react-aria/overlays');
var RcTimePicker = require('rc-time-picker');
var Calendar = require('react-calendar');
var reactTable = require('react-table');
var Plain = require('slate-plain-serializer');
var slateReact = require('slate-react');
var uuid = require('uuid');
var isHotkey = require('is-hotkey');
var Prism = require('prismjs');
var immutable = require('immutable');
var calculateSize = require('calculate-size');
var Highlighter = require('react-highlight-words');
var rxjs = require('rxjs');
var operators = require('rxjs/operators');
var schema = require('@grafana/schema');
var uPlot = require('uplot');
var $ = require('jquery');
var useAsync = require('react-use/lib/useAsync');
var usePrevious = require('react-use/lib/usePrevious');
var browser = require('@sentry/browser');
var faroWebSdk = require('@grafana/faro-web-sdk');
var useClickAway = require('react-use/lib/useClickAway');
var RcDrawer = require('rc-drawer');
var SliderComponent = require('rc-slider');
var Tooltip$1 = require('rc-tooltip');
var reactHookForm = require('react-hook-form');
var reactRouterDom = require('react-router-dom');
var reactDropzone = require('react-dropzone');
var WKT = require('ol/format/WKT');
var geom = require('ol/geom');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n["default"] = e;
  return Object.freeze(n);
}

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
var React__namespace = /*#__PURE__*/_interopNamespace(React);
var classNames__default = /*#__PURE__*/_interopDefaultLegacy(classNames);
var SVG__default = /*#__PURE__*/_interopDefaultLegacy(SVG);
var hoistNonReactStatics__default = /*#__PURE__*/_interopDefaultLegacy(hoistNonReactStatics);
var memoizeOne__default = /*#__PURE__*/_interopDefaultLegacy(memoizeOne);
var ReactDOM__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOM);
var tinycolor__default = /*#__PURE__*/_interopDefaultLegacy(tinycolor);
var ansicolor__default = /*#__PURE__*/_interopDefaultLegacy(ansicolor);
var ReactSelect__default = /*#__PURE__*/_interopDefaultLegacy(ReactSelect);
var ReactAsyncSelect__default = /*#__PURE__*/_interopDefaultLegacy(ReactAsyncSelect);
var Creatable__default = /*#__PURE__*/_interopDefaultLegacy(Creatable);
var Scrollbars__default = /*#__PURE__*/_interopDefaultLegacy(Scrollbars);
var Transition__default = /*#__PURE__*/_interopDefaultLegacy(Transition);
var i18next__default = /*#__PURE__*/_interopDefaultLegacy(i18next);
var RCCascader__default = /*#__PURE__*/_interopDefaultLegacy(RCCascader);
var useMeasure__default = /*#__PURE__*/_interopDefaultLegacy(useMeasure);
var AsyncCreatable__default = /*#__PURE__*/_interopDefaultLegacy(AsyncCreatable);
var formatDuration__default = /*#__PURE__*/_interopDefaultLegacy(formatDuration);
var RcTimePicker__default = /*#__PURE__*/_interopDefaultLegacy(RcTimePicker);
var Calendar__default = /*#__PURE__*/_interopDefaultLegacy(Calendar);
var Plain__default = /*#__PURE__*/_interopDefaultLegacy(Plain);
var Prism__default = /*#__PURE__*/_interopDefaultLegacy(Prism);
var calculateSize__default = /*#__PURE__*/_interopDefaultLegacy(calculateSize);
var Highlighter__default = /*#__PURE__*/_interopDefaultLegacy(Highlighter);
var uPlot__default = /*#__PURE__*/_interopDefaultLegacy(uPlot);
var $__default = /*#__PURE__*/_interopDefaultLegacy($);
var useAsync__default = /*#__PURE__*/_interopDefaultLegacy(useAsync);
var usePrevious__default = /*#__PURE__*/_interopDefaultLegacy(usePrevious);
var useClickAway__default = /*#__PURE__*/_interopDefaultLegacy(useClickAway);
var RcDrawer__default = /*#__PURE__*/_interopDefaultLegacy(RcDrawer);
var SliderComponent__default = /*#__PURE__*/_interopDefaultLegacy(SliderComponent);
var Tooltip__default = /*#__PURE__*/_interopDefaultLegacy(Tooltip$1);
var WKT__default = /*#__PURE__*/_interopDefaultLegacy(WKT);

function stylesFactory(stylesCreator) {
  return memoizeOne__default["default"](stylesCreator);
}

var __defProp$2B = Object.defineProperty;
var __defProps$1G = Object.defineProperties;
var __getOwnPropDescs$1G = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2D = Object.getOwnPropertySymbols;
var __hasOwnProp$2D = Object.prototype.hasOwnProperty;
var __propIsEnum$2D = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2B = (obj, key, value) => key in obj ? __defProp$2B(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2B = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2D.call(b, prop))
      __defNormalProp$2B(a, prop, b[prop]);
  if (__getOwnPropSymbols$2D)
    for (var prop of __getOwnPropSymbols$2D(b)) {
      if (__propIsEnum$2D.call(b, prop))
        __defNormalProp$2B(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1G = (a, b) => __defProps$1G(a, __getOwnPropDescs$1G(b));
let ThemeContextMock = null;
const memoizedStyleCreators = /* @__PURE__ */ new WeakMap();
const ThemeContext = React__default["default"].createContext(data.createTheme());
ThemeContext.displayName = "ThemeContext";
const withTheme = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = ThemeContextMock || ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ React__default["default"].createElement(ContextComponent.Consumer, null, (theme) => /* @__PURE__ */ React__default["default"].createElement(Component, __spreadProps$1G(__spreadValues$2B({}, props), { theme: theme.v1 })))
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics__default["default"](WithTheme, Component);
  return WithTheme;
};
const withTheme2 = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = ThemeContextMock || ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ React__default["default"].createElement(ContextComponent.Consumer, null, (theme) => /* @__PURE__ */ React__default["default"].createElement(Component, __spreadProps$1G(__spreadValues$2B({}, props), { theme })))
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics__default["default"](WithTheme, Component);
  return WithTheme;
};
function useTheme() {
  return React.useContext(ThemeContextMock || ThemeContext).v1;
}
function useTheme2() {
  return React.useContext(ThemeContextMock || ThemeContext);
}
function useStyles(getStyles) {
  const theme = useTheme();
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = stylesFactory(getStyles);
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme);
}
function useStyles2(getStyles) {
  const theme = useTheme2();
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = stylesFactory(getStyles);
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme);
}
const mockThemeContext = (theme) => {
  ThemeContextMock = React__default["default"].createContext(theme);
  return () => {
    ThemeContextMock = null;
  };
};

var u1000 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,2a10,10,0,1,0,5,18.66,1,1,0,1,0-1-1.73A8,8,0,1,1,20,12v.75a1.75,1.75,0,0,1-3.5,0V8.5a1,1,0,0,0-1-1,1,1,0,0,0-1,.79A4.45,4.45,0,0,0,12,7.5,4.5,4.5,0,1,0,15.3,15,3.74,3.74,0,0,0,22,12.75V12A10,10,0,0,0,12,2Zm0,12.5A2.5,2.5,0,1,1,14.5,12,2.5,2.5,0,0,1,12,14.5Z\"/></svg>";

var u1001 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M17,7A7.74,7.74,0,1,0,7,17,7.74,7.74,0,1,0,17,7Zm-1.6,1.6a6.12,6.12,0,0,1,.11,1.14,5.92,5.92,0,0,1-.16,1.34L12.91,8.66a5.92,5.92,0,0,1,1.34-.16A6.12,6.12,0,0,1,15.39,8.61ZM14.46,13A6,6,0,0,1,13,14.46L9.54,11A6,6,0,0,1,11,9.54Zm-8,1.46a5.75,5.75,0,1,1,8-8h-.25A7.76,7.76,0,0,0,6.5,14.25C6.5,14.33,6.51,14.42,6.51,14.5Zm2.1.89a6.12,6.12,0,0,1-.11-1.14,5.92,5.92,0,0,1,.16-1.34l2.43,2.43a5.92,5.92,0,0,1-1.34.16A6.12,6.12,0,0,1,8.61,15.39ZM14.25,20A5.77,5.77,0,0,1,9.5,17.49h.25A7.76,7.76,0,0,0,17.5,9.75c0-.08,0-.17,0-.25A5.75,5.75,0,0,1,14.25,20Z\"/></svg>";

var u1002 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M11.29,11.46a1,1,0,0,0,1.42,0l3-3A1,1,0,1,0,14.29,7L12,9.34,9.71,7A1,1,0,1,0,8.29,8.46Zm3,1.08L12,14.84l-2.29-2.3A1,1,0,0,0,8.29,14l3,3a1,1,0,0,0,1.42,0l3-3a1,1,0,0,0-1.42-1.42Z\"/></svg>";

var u1003 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M8.46,8.29A1,1,0,1,0,7,9.71L9.34,12,7,14.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3-3a1,1,0,0,0,0-1.42Zm8.5,3-3-3a1,1,0,0,0-1.42,1.42L14.84,12l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3-3A1,1,0,0,0,17,11.29Z\"/></svg>";

var u1004 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M17,9.17a1,1,0,0,0-1.41,0L12,12.71,8.46,9.17a1,1,0,0,0-1.41,0,1,1,0,0,0,0,1.42l4.24,4.24a1,1,0,0,0,1.42,0L17,10.59A1,1,0,0,0,17,9.17Z\"/></svg>";

var u1005 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M11.29,12l3.54-3.54a1,1,0,0,0,0-1.41,1,1,0,0,0-1.42,0L9.17,11.29a1,1,0,0,0,0,1.42L13.41,17a1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.41Z\"/></svg>";

var u1006 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M14.83,11.29,10.59,7.05a1,1,0,0,0-1.42,0,1,1,0,0,0,0,1.41L12.71,12,9.17,15.54a1,1,0,0,0,0,1.41,1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29l4.24-4.24A1,1,0,0,0,14.83,11.29Z\"/></svg>";

var u1007 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M17,13.41,12.71,9.17a1,1,0,0,0-1.42,0L7.05,13.41a1,1,0,0,0,0,1.42,1,1,0,0,0,1.41,0L12,11.29l3.54,3.54a1,1,0,0,0,.7.29,1,1,0,0,0,.71-.29A1,1,0,0,0,17,13.41Z\"/></svg>";

var u1008 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M10,13H3a1,1,0,0,0-1,1v7a1,1,0,0,0,1,1h7a1,1,0,0,0,1-1V14A1,1,0,0,0,10,13ZM9,20H4V15H9ZM21,2H14a1,1,0,0,0-1,1v7a1,1,0,0,0,1,1h7a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM20,9H15V4h5Zm1,4H14a1,1,0,0,0-1,1v7a1,1,0,0,0,1,1h7a1,1,0,0,0,1-1V14A1,1,0,0,0,21,13Zm-1,7H15V15h5ZM10,2H3A1,1,0,0,0,2,3v7a1,1,0,0,0,1,1h7a1,1,0,0,0,1-1V3A1,1,0,0,0,10,2ZM9,9H4V4H9Z\"/></svg>";

var u1009 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M9.71,6.29a1,1,0,0,0-1.42,0l-5,5a1,1,0,0,0,0,1.42l5,5a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,12l4.3-4.29A1,1,0,0,0,9.71,6.29Zm11,5-5-5a1,1,0,0,0-1.42,1.42L18.59,12l-4.3,4.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l5-5A1,1,0,0,0,20.71,11.29Z\"/></svg>";

var u1010 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M17.71,11.29a1,1,0,0,0-1.42,0L13,14.59V7a1,1,0,0,0-2,0v7.59l-3.29-3.3a1,1,0,0,0-1.42,1.42l5,5a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l5-5A1,1,0,0,0,17.71,11.29Z\"/></svg>";

var u1011 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M3,4A1,1,0,0,0,2,5V19a1,1,0,0,0,2,0V5A1,1,0,0,0,3,4Zm18.92,7.62a1,1,0,0,0-.21-.33l-4-4a1,1,0,1,0-1.42,1.42L18.59,11H7a1,1,0,0,0,0,2H18.59l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33A1,1,0,0,0,21.92,11.62Z\"/></svg>";

var u1012 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M17,11H9.41l3.3-3.29a1,1,0,1,0-1.42-1.42l-5,5a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l5,5a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L9.41,13H17a1,1,0,0,0,0-2Z\"/></svg>";

var u1013 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M8.7,10a1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.41L3.84,2.29A1,1,0,0,0,2.42,3.71ZM21,14a1,1,0,0,0-1,1v3.59L15.44,14A1,1,0,0,0,14,15.44L18.59,20H15a1,1,0,0,0,0,2h6a1,1,0,0,0,.38-.08,1,1,0,0,0,.54-.54A1,1,0,0,0,22,21V15A1,1,0,0,0,21,14Zm.92-11.38a1,1,0,0,0-.54-.54A1,1,0,0,0,21,2H15a1,1,0,0,0,0,2h3.59L2.29,20.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L20,5.41V9a1,1,0,0,0,2,0V3A1,1,0,0,0,21.92,2.62Z\"/></svg>";

var u1014 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M17.92,11.62a1,1,0,0,0-.21-.33l-5-5a1,1,0,0,0-1.42,1.42L14.59,11H7a1,1,0,0,0,0,2h7.59l-3.3,3.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l5-5a1,1,0,0,0,.21-.33A1,1,0,0,0,17.92,11.62Z\"/></svg>";

var u1015 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M17.71,11.29l-4-4a1,1,0,1,0-1.42,1.42L14.59,11H3a1,1,0,0,0,0,2H14.59l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76A1,1,0,0,0,17.71,11.29ZM21,4a1,1,0,0,0-1,1V19a1,1,0,0,0,2,0V5A1,1,0,0,0,21,4Z\"/></svg>";

var u1016 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M17.71,11.29l-5-5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-5,5a1,1,0,0,0,1.42,1.42L11,9.41V17a1,1,0,0,0,2,0V9.41l3.29,3.3a1,1,0,0,0,1.42,0A1,1,0,0,0,17.71,11.29Z\"/></svg>";

var u1017 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21.92,11.62a1,1,0,0,0-.21-.33l-4-4a1,1,0,1,0-1.42,1.42L18.59,11H5.41l2.3-2.29A1,1,0,1,0,6.29,7.29l-4,4a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l4,4a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,13H18.59l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33A1,1,0,0,0,21.92,11.62Z\"/></svg>";

var u1018 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M20.67,5.85a2.63,2.63,0,0,0-2.67,0L14,8.15h0a2.67,2.67,0,0,0-4-2.31L3.33,9.69a2.67,2.67,0,0,0,0,4.62L10,18.16a2.66,2.66,0,0,0,2.67,0A2.65,2.65,0,0,0,14,15.85h0l4,2.31a2.69,2.69,0,0,0,1.33.36,2.61,2.61,0,0,0,1.34-.37A2.63,2.63,0,0,0,22,15.85V8.15A2.63,2.63,0,0,0,20.67,5.85ZM12,15.85a.66.66,0,0,1-.33.58.69.69,0,0,1-.67,0L4.33,12.58a.67.67,0,0,1,0-1.16L11,7.57a.67.67,0,0,1,.67,0,.66.66,0,0,1,.33.58Zm8,0a.67.67,0,0,1-1,.57l-5-2.88V10.46l5-2.88a.67.67,0,0,1,1,.57Z\"/></svg>";

var u1019 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M3,8H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,8Zm18,8H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0-5H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z\"/></svg>";

var u1020 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M18,13.18V10a6,6,0,0,0-5-5.91V3a1,1,0,0,0-2,0V4.09A6,6,0,0,0,6,10v3.18A3,3,0,0,0,4,16v2a1,1,0,0,0,1,1H8.14a4,4,0,0,0,7.72,0H19a1,1,0,0,0,1-1V16A3,3,0,0,0,18,13.18ZM8,10a4,4,0,0,1,8,0v3H8Zm4,10a2,2,0,0,1-1.72-1h3.44A2,2,0,0,1,12,20Zm6-3H6V16a1,1,0,0,1,1-1H17a1,1,0,0,1,1,1Z\"/></svg>";

var u1021 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M11.07,6.12A3.48,3.48,0,0,1,12,6a4,4,0,0,1,4,4v1.34a1,1,0,0,0,2,0V10a6,6,0,0,0-5-5.91V3a1,1,0,0,0-2,0V4.1l-.45.08a1,1,0,0,0,.52,1.94ZM21.71,20.29l-18-18A1,1,0,0,0,2.29,3.71L6.41,7.82A6,6,0,0,0,6,10v3.18A3,3,0,0,0,4,16v2a1,1,0,0,0,1,1H8.14a4,4,0,0,0,7.72,0h1.73l2.7,2.71a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM8,10a3.31,3.31,0,0,1,0-.55L11.59,13H8Zm4,10a2,2,0,0,1-1.72-1h3.44A2,2,0,0,1,12,20ZM6,17V16a1,1,0,0,1,1-1h6.59l2,2Z\"/></svg>";

var u1022 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19.87,8.6A1,1,0,0,0,19,8H14.42l1.27-4.74a1,1,0,0,0-.17-.87A1,1,0,0,0,14.73,2h-7a1,1,0,0,0-1,.74l-2.68,10a1,1,0,0,0,.17.87,1,1,0,0,0,.8.39H8.89L7.08,20.74a1,1,0,0,0,1.71.93l10.9-12A1,1,0,0,0,19.87,8.6Zm-9.79,8.68,1.07-4a1,1,0,0,0-.17-.87,1,1,0,0,0-.79-.39H6.35L8.49,4h4.93L12.15,8.74a1,1,0,0,0,1,1.26h3.57Z\"/></svg>";

var u1023 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M15,6H9A1,1,0,0,0,8,7v4a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V7A1,1,0,0,0,15,6Zm-1,4H10V8h4Zm3-8H5A1,1,0,0,0,4,3V21a1,1,0,0,0,1,1H17a3,3,0,0,0,3-3V5A3,3,0,0,0,17,2Zm1,17a1,1,0,0,1-1,1H6V4H17a1,1,0,0,1,1,1Z\"/></svg>";

var u1024 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21.17,2.06A13.1,13.1,0,0,0,19,1.87a12.94,12.94,0,0,0-7,2.05,12.94,12.94,0,0,0-7-2,13.1,13.1,0,0,0-2.17.19,1,1,0,0,0-.83,1v12a1,1,0,0,0,1.17,1,10.9,10.9,0,0,1,8.25,1.91l.12.07.11,0a.91.91,0,0,0,.7,0l.11,0,.12-.07A10.9,10.9,0,0,1,20.83,16a1,1,0,0,0,1.17-1v-12A1,1,0,0,0,21.17,2.06ZM11,15.35a12.87,12.87,0,0,0-6-1.48c-.33,0-.66,0-1,0v-10a8.69,8.69,0,0,1,1,0,10.86,10.86,0,0,1,6,1.8Zm9-1.44c-.34,0-.67,0-1,0a12.87,12.87,0,0,0-6,1.48V5.67a10.86,10.86,0,0,1,6-1.8,8.69,8.69,0,0,1,1,0Zm1.17,4.15A13.1,13.1,0,0,0,19,17.87a12.94,12.94,0,0,0-7,2.05,12.94,12.94,0,0,0-7-2.05,13.1,13.1,0,0,0-2.17.19A1,1,0,0,0,2,19.21,1,1,0,0,0,3.17,20a10.9,10.9,0,0,1,8.25,1.91,1,1,0,0,0,1.16,0A10.9,10.9,0,0,1,20.83,20,1,1,0,0,0,22,19.21,1,1,0,0,0,21.17,18.06Z\"/></svg>";

var u1025 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M6,6A2,2,0,0,1,8,4,1,1,0,0,0,8,2,4,4,0,0,0,4,6V9a2,2,0,0,1-2,2,1,1,0,0,0,0,2,2,2,0,0,1,2,2v3a4,4,0,0,0,4,4,1,1,0,0,0,0-2,2,2,0,0,1-2-2V15a4,4,0,0,0-1.38-3A4,4,0,0,0,6,9Zm16,5a2,2,0,0,1-2-2V6a4,4,0,0,0-4-4,1,1,0,0,0,0,2,2,2,0,0,1,2,2V9a4,4,0,0,0,1.38,3A4,4,0,0,0,18,15v3a2,2,0,0,1-2,2,1,1,0,0,0,0,2,4,4,0,0,0,4-4V15a2,2,0,0,1,2-2,1,1,0,0,0,0-2Z\"/></svg>";

var u1026 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M19,14h2a1,1,0,0,0,0-2H19V11a5.15,5.15,0,0,0-.21-1.36A5,5,0,0,0,22,5a1,1,0,0,0-2,0,3,3,0,0,1-2.14,2.87A5,5,0,0,0,16,6.4,2.58,2.58,0,0,0,16,6,4,4,0,0,0,8,6a2.58,2.58,0,0,0,0,.4,5,5,0,0,0-1.9,1.47A3,3,0,0,1,4,5,1,1,0,0,0,2,5,5,5,0,0,0,5.21,9.64,5.15,5.15,0,0,0,5,11v1H3a1,1,0,0,0,0,2H5v1a7,7,0,0,0,.14,1.38A5,5,0,0,0,2,21a1,1,0,0,0,2,0,3,3,0,0,1,1.81-2.74,7,7,0,0,0,12.38,0A3,3,0,0,1,20,21a1,1,0,0,0,2,0,5,5,0,0,0-3.14-4.62A7,7,0,0,0,19,15Zm-8,5.9A5,5,0,0,1,7,15V11a3,3,0,0,1,3-3h1ZM10,6a2,2,0,0,1,4,0Zm7,9a5,5,0,0,1-4,4.9V8h1a3,3,0,0,1,3,3Z\"/></svg>";

var u1027 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M14,8h1a1,1,0,0,0,0-2H14a1,1,0,0,0,0,2Zm0,4h1a1,1,0,0,0,0-2H14a1,1,0,0,0,0,2ZM9,8h1a1,1,0,0,0,0-2H9A1,1,0,0,0,9,8Zm0,4h1a1,1,0,0,0,0-2H9a1,1,0,0,0,0,2Zm12,8H20V3a1,1,0,0,0-1-1H5A1,1,0,0,0,4,3V20H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm-8,0H11V16h2Zm5,0H15V15a1,1,0,0,0-1-1H10a1,1,0,0,0-1,1v5H6V4H18Z\"/></svg>";

var u1028 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M5.5,8H6v.5a1,1,0,0,0,2,0V8h.5a1,1,0,0,0,0-2H8V5.5a1,1,0,0,0-2,0V6H5.5a1,1,0,0,0,0,2ZM4.88,19.12a1,1,0,0,0,1.41,0L7,18.41l.71.71a1,1,0,0,0,1.41,0,1,1,0,0,0,0-1.41L8.41,17l.71-.71a1,1,0,0,0-1.41-1.41L7,15.59l-.71-.71a1,1,0,0,0-1.41,1.41l.71.71-.71.71A1,1,0,0,0,4.88,19.12ZM20,1H4A3,3,0,0,0,1,4V20a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V4A3,3,0,0,0,20,1ZM11,21H4a1,1,0,0,1-1-1V13h8Zm0-10H3V4A1,1,0,0,1,4,3h7Zm10,9a1,1,0,0,1-1,1H13V13h8Zm0-9H13V3h7a1,1,0,0,1,1,1Zm-5.5,5.5h3a1,1,0,0,0,0-2h-3a1,1,0,0,0,0,2ZM18.5,6h-3a1,1,0,0,0,0,2h3a1,1,0,0,0,0-2Zm-3,13.5h3a1,1,0,0,0,0-2h-3a1,1,0,0,0,0,2Z\"/></svg>";

var u1029 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M12,19a1,1,0,1,0-1-1A1,1,0,0,0,12,19Zm5,0a1,1,0,1,0-1-1A1,1,0,0,0,17,19Zm0-4a1,1,0,1,0-1-1A1,1,0,0,0,17,15Zm-5,0a1,1,0,1,0-1-1A1,1,0,0,0,12,15ZM19,3H18V2a1,1,0,0,0-2,0V3H8V2A1,1,0,0,0,6,2V3H5A3,3,0,0,0,2,6V20a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V6A3,3,0,0,0,19,3Zm1,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V11H20ZM20,9H4V6A1,1,0,0,1,5,5H6V6A1,1,0,0,0,8,6V5h8V6a1,1,0,0,0,2,0V5h1a1,1,0,0,1,1,1ZM7,15a1,1,0,1,0-1-1A1,1,0,0,0,7,15Zm0,4a1,1,0,1,0-1-1A1,1,0,0,0,7,19Z\"/></svg>";

var u1030 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M11.66,7H15V8a1,1,0,0,0,2,0V7h1a1,1,0,0,1,1,1v3H17.66a1,1,0,0,0,0,2H19v1.34a1,1,0,1,0,2,0V8a3,3,0,0,0-3-3H17V4a1,1,0,0,0-2,0V5H11.66a1,1,0,0,0,0,2ZM21.71,20.29l-1.6-1.6h0L3.71,2.29A1,1,0,0,0,2.29,3.71L4.2,5.61A3,3,0,0,0,3,8V18a3,3,0,0,0,3,3H18a3,3,0,0,0,1.29-.3l1,1a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM5,8a1,1,0,0,1,.66-.93L9.59,11H5ZM6,19a1,1,0,0,1-1-1V13h6.59l6,6Z\"/></svg>";

var u1031 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19,6.5H17.72l-.32-1a3,3,0,0,0-2.84-2H9.44A3,3,0,0,0,6.6,5.55l-.32,1H5a3,3,0,0,0-3,3v8a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3v-8A3,3,0,0,0,19,6.5Zm1,11a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1v-8a1,1,0,0,1,1-1H7a1,1,0,0,0,1-.68l.54-1.64a1,1,0,0,1,.95-.68h5.12a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,17,8.5h2a1,1,0,0,1,1,1Zm-8-9a4,4,0,1,0,4,4A4,4,0,0,0,12,8.5Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,12,14.5Z\"/></svg>";

var u1032 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M18,7h1V8a1,1,0,0,0,2,0V7h1a1,1,0,0,0,0-2H21V4a1,1,0,0,0-2,0V5H18a1,1,0,0,0,0,2Zm2,9a3,3,0,0,0-1.73.56l-2.45-1.45A3.74,3.74,0,0,0,16,14a4,4,0,0,0-3-3.86V7.82a3,3,0,1,0-2,0v2.32A4,4,0,0,0,8,14a3.74,3.74,0,0,0,.18,1.11L5.73,16.56A3,3,0,0,0,4,16a3,3,0,1,0,3,3,3,3,0,0,0-.12-.8l2.3-1.37a4,4,0,0,0,5.64,0l2.3,1.37A3,3,0,1,0,20,16ZM4,20a1,1,0,1,1,1-1A1,1,0,0,1,4,20ZM12,4a1,1,0,1,1-1,1A1,1,0,0,1,12,4Zm0,12a2,2,0,1,1,2-2A2,2,0,0,1,12,16Zm8,4a1,1,0,1,1,1-1A1,1,0,0,1,20,20Z\"/></svg>";

var u1033 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M7,16a1.5,1.5,0,0,0,1.5-1.5.77.77,0,0,0,0-.15l2.79-2.79.23,0,.23,0,1.61,1.61s0,.05,0,.08a1.5,1.5,0,1,0,3,0v-.08L20,9.5h0A1.5,1.5,0,1,0,18.5,8a.77.77,0,0,0,0,.15l-3.61,3.61h-.16L13,10a1.49,1.49,0,0,0-3,0L7,13H7a1.5,1.5,0,0,0,0,3Zm13.5,4H3.5V3a1,1,0,0,0-2,0V21a1,1,0,0,0,1,1h18a1,1,0,0,0,0-2Z\"/></svg>";

var u1034 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M18.71,7.21a1,1,0,0,0-1.42,0L9.84,14.67,6.71,11.53A1,1,0,1,0,5.29,13l3.84,3.84a1,1,0,0,0,1.42,0l8.16-8.16A1,1,0,0,0,18.71,7.21Z\"/></svg>";

var u1035 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M14.72,8.79l-4.29,4.3L8.78,11.44a1,1,0,1,0-1.41,1.41l2.35,2.36a1,1,0,0,0,.71.29,1,1,0,0,0,.7-.29l5-5a1,1,0,0,0,0-1.42A1,1,0,0,0,14.72,8.79ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z\"/></svg>";

var u1036 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Z\"/></svg>";

var u1037 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M15,14H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm0-4H11a1,1,0,0,0,0,2h4a1,1,0,0,0,0-2Zm2-6H15.82A3,3,0,0,0,13,2H11A3,3,0,0,0,8.18,4H7A3,3,0,0,0,4,7V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V7A3,3,0,0,0,17,4ZM10,5a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1V6H10Zm8,14a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V7A1,1,0,0,1,7,6H8V7A1,1,0,0,0,9,8h6a1,1,0,0,0,1-1V6h1a1,1,0,0,1,1,1Z\"/></svg>";

var u1038 = "<svg id=\"Layer_1\" data-name=\"Layer 1\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,6a.99974.99974,0,0,0-1,1v4H9a1,1,0,0,0,0,2h3a.99974.99974,0,0,0,1-1V7A.99974.99974,0,0,0,12,6Zm0-4A10,10,0,1,0,22,12,10.01146,10.01146,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Z\"/></svg>";

var u1039 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M18.42,9.21a7,7,0,0,0-13.36,1.9A4,4,0,0,0,6,19H17a5,5,0,0,0,1.42-9.79ZM17,17H6a2,2,0,0,1,0-4,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.66A3,3,0,0,1,17,17Z\"/></svg>";

var u1040 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M14.29,17.29,13,18.59V13a1,1,0,0,0-2,0v5.59l-1.29-1.3a1,1,0,0,0-1.42,1.42l3,3a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l3-3a1,1,0,0,0-1.42-1.42ZM18.42,6.22A7,7,0,0,0,5.06,8.11,4,4,0,0,0,6,16a1,1,0,0,0,0-2,2,2,0,0,1,0-4A1,1,0,0,0,7,9a5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,.24,5.84,1,1,0,1,0,.5,1.94,5,5,0,0,0,.17-9.62Z\"/></svg>";

var u1041 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M17,6.06a3,3,0,0,0-1.15,5.77A2,2,0,0,1,14,13.06H10a3.91,3.91,0,0,0-2,.56V7.88a3,3,0,1,0-2,0v8.36a3,3,0,1,0,2.16.05A2,2,0,0,1,10,15.06h4a4,4,0,0,0,3.91-3.16A3,3,0,0,0,17,6.06Zm-10-2a1,1,0,1,1-1,1A1,1,0,0,1,7,4.06Zm0,16a1,1,0,1,1,1-1A1,1,0,0,1,7,20.06Zm10-10a1,1,0,1,1,1-1A1,1,0,0,1,17,10.06Z\"/></svg>";

var u1042 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21.32,9.55l-1.89-.63.89-1.78A1,1,0,0,0,20.13,6L18,3.87a1,1,0,0,0-1.15-.19l-1.78.89-.63-1.89A1,1,0,0,0,13.5,2h-3a1,1,0,0,0-.95.68L8.92,4.57,7.14,3.68A1,1,0,0,0,6,3.87L3.87,6a1,1,0,0,0-.19,1.15l.89,1.78-1.89.63A1,1,0,0,0,2,10.5v3a1,1,0,0,0,.68.95l1.89.63-.89,1.78A1,1,0,0,0,3.87,18L6,20.13a1,1,0,0,0,1.15.19l1.78-.89.63,1.89a1,1,0,0,0,.95.68h3a1,1,0,0,0,.95-.68l.63-1.89,1.78.89A1,1,0,0,0,18,20.13L20.13,18a1,1,0,0,0,.19-1.15l-.89-1.78,1.89-.63A1,1,0,0,0,22,13.5v-3A1,1,0,0,0,21.32,9.55ZM20,12.78l-1.2.4A2,2,0,0,0,17.64,16l.57,1.14-1.1,1.1L16,17.64a2,2,0,0,0-2.79,1.16l-.4,1.2H11.22l-.4-1.2A2,2,0,0,0,8,17.64l-1.14.57-1.1-1.1L6.36,16A2,2,0,0,0,5.2,13.18L4,12.78V11.22l1.2-.4A2,2,0,0,0,6.36,8L5.79,6.89l1.1-1.1L8,6.36A2,2,0,0,0,10.82,5.2l.4-1.2h1.56l.4,1.2A2,2,0,0,0,16,6.36l1.14-.57,1.1,1.1L17.64,8a2,2,0,0,0,1.16,2.79l1.2.4ZM12,8a4,4,0,1,0,4,4A4,4,0,0,0,12,8Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,12,14Z\"/></svg>";

var u1043 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM11,20H4V4h7Zm9,0H13V4h7Z\"/></svg>";

var u1044 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19,2H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H16.59l3.7,3.71A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V5A3,3,0,0,0,19,2Zm1,16.59-2.29-2.3A1,1,0,0,0,17,16H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z\"/></svg>";

var u1045 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19.5,6.5h-5a1,1,0,0,0,0,2h5a1,1,0,0,1,1,1v9.72l-1.57-1.45a1,1,0,0,0-.68-.27H9.5a1,1,0,0,1-1-1v-2a1,1,0,0,0-2,0v2a3,3,0,0,0,3,3h8.36l3,2.73a1,1,0,0,0,.68.27,1.1,1.1,0,0,0,.4-.08,1,1,0,0,0,.6-.92V9.5A3,3,0,0,0,19.5,6.5Zm-10,5A2,2,0,1,0,8.32,7.89l-1.75-.8,1.91-.88a2,2,0,0,0,1,.29,2,2,0,1,0-2-2l-1.9.87A2,2,0,0,0,4.5,5a2,2,0,0,0,0,4,2,2,0,0,0,.93-.24l2.09,1A2,2,0,0,0,9.5,11.5Z\"/></svg>";

var u1046 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19,8H18V5a3,3,0,0,0-3-3H5A3,3,0,0,0,2,5V17a1,1,0,0,0,.62.92A.84.84,0,0,0,3,18a1,1,0,0,0,.71-.29l2.81-2.82H8v1.44a3,3,0,0,0,3,3h6.92l2.37,2.38A1,1,0,0,0,21,22a.84.84,0,0,0,.38-.08A1,1,0,0,0,22,21V11A3,3,0,0,0,19,8ZM8,11v1.89H6.11a1,1,0,0,0-.71.29L4,14.59V5A1,1,0,0,1,5,4H15a1,1,0,0,1,1,1V8H11A3,3,0,0,0,8,11Zm12,7.59-1-1a1,1,0,0,0-.71-.3H11a1,1,0,0,1-1-1V11a1,1,0,0,1,1-1h8a1,1,0,0,1,1,1Z\"/></svg>";

var u1047 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm1,17.93V19a1,1,0,0,0-2,0v.93A8,8,0,0,1,4.07,13H5a1,1,0,0,0,0-2H4.07A8,8,0,0,1,11,4.07V5a1,1,0,0,0,2,0V4.07A8,8,0,0,1,19.93,11H19a1,1,0,0,0,0,2h.93A8,8,0,0,1,13,19.93ZM15.14,7.55l-5,2.12a1,1,0,0,0-.52.52l-2.12,5a1,1,0,0,0,.21,1.1,1,1,0,0,0,.7.3.93.93,0,0,0,.4-.09l5-2.12a1,1,0,0,0,.52-.52l2.12-5a1,1,0,0,0-1.31-1.31Zm-2.49,5.1-2.28,1,1-2.28,2.28-1Z\"/></svg>";

var u1048 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,14.05,2H10A3,3,0,0,0,7,5V6H6A3,3,0,0,0,3,9V19a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V18h1a3,3,0,0,0,3-3V9S21,9,21,8.94ZM15,5.41,17.59,8H16a1,1,0,0,1-1-1ZM15,19a1,1,0,0,1-1,1H6a1,1,0,0,1-1-1V9A1,1,0,0,1,6,8H7v7a3,3,0,0,0,3,3h5Zm4-4a1,1,0,0,1-1,1H10a1,1,0,0,1-1-1V5a1,1,0,0,1,1-1h3V7a3,3,0,0,0,3,3h3Z\"/></svg>";

var u1049 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M20.92,12.62a1,1,0,0,0-.21-.33l-3-3a1,1,0,0,0-1.42,1.42L17.59,12H8a1,1,0,0,1-1-1V7A1,1,0,0,0,5,7v4a3,3,0,0,0,3,3h9.59l-1.3,1.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l3-3a1,1,0,0,0,.21-.33A1,1,0,0,0,20.92,12.62Z\"/></svg>";

var u1050 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M20.47,7.37s0,0,0-.08l-.06-.15a.71.71,0,0,0-.07-.09.94.94,0,0,0-.09-.12l-.09-.07L20,6.78l-7.5-4.63a1,1,0,0,0-1.06,0L4,6.78l-.09.08-.09.07a.94.94,0,0,0-.09.12.71.71,0,0,0-.07.09l-.06.15s0,0,0,.08a1.15,1.15,0,0,0,0,.26v8.74a1,1,0,0,0,.47.85l7.5,4.63h0a.47.47,0,0,0,.15.06s.05,0,.08,0a.86.86,0,0,0,.52,0s.05,0,.08,0a.47.47,0,0,0,.15-.06h0L20,17.22a1,1,0,0,0,.47-.85V7.63A1.15,1.15,0,0,0,20.47,7.37ZM11,19.21l-5.5-3.4V9.43L11,12.82Zm1-8.12L6.4,7.63,12,4.18l5.6,3.45Zm6.5,4.72L13,19.21V12.82l5.5-3.39Z\"/></svg>";

var u1051 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M19.088,4.95453c-.00732-.00781-.00952-.01819-.01715-.02582s-.01819-.00995-.02606-.01733a9.97886,9.97886,0,0,0-14.08948,0c-.00787.00738-.01837.00964-.02606.01733s-.00983.018-.01715.02582a10,10,0,1,0,14.1759,0ZM12,20a7.9847,7.9847,0,0,1-6.235-3H9.78027a2.9636,2.9636,0,0,0,4.43946,0h4.01532A7.9847,7.9847,0,0,1,12,20Zm-1-5a1,1,0,1,1,1,1A1.001,1.001,0,0,1,11,15Zm8.41022.00208L19.3999,15H15a2.99507,2.99507,0,0,0-2-2.81573V9a1,1,0,0,0-2,0v3.18427A2.99507,2.99507,0,0,0,9,15H4.6001l-.01032.00208A7.93083,7.93083,0,0,1,4.06946,13H5a1,1,0,0,0,0-2H4.06946A7.95128,7.95128,0,0,1,5.68854,7.10211l.65472.65473A.99989.99989,0,1,0,7.75732,6.34277l-.65466-.65466A7.95231,7.95231,0,0,1,11,4.06946V5a1,1,0,0,0,2,0V4.06946a7.95231,7.95231,0,0,1,3.89734,1.61865l-.65466.65466a.99989.99989,0,1,0,1.41406,1.41407l.65472-.65473A7.95128,7.95128,0,0,1,19.93054,11H19a1,1,0,0,0,0,2h.93054A7.93083,7.93083,0,0,1,19.41022,15.00208Z\"/></svg>";

var u1052 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M8,16.5a1,1,0,1,0,1,1A1,1,0,0,0,8,16.5ZM12,2C8,2,4,3.37,4,6V18c0,2.63,4,4,8,4s8-1.37,8-4V6C20,3.37,16,2,12,2Zm6,16c0,.71-2.28,2-6,2s-6-1.29-6-2V14.73A13.16,13.16,0,0,0,12,16a13.16,13.16,0,0,0,6-1.27Zm0-6c0,.71-2.28,2-6,2s-6-1.29-6-2V8.73A13.16,13.16,0,0,0,12,10a13.16,13.16,0,0,0,6-1.27ZM12,8C8.28,8,6,6.71,6,6s2.28-2,6-2,6,1.29,6,2S15.72,8,12,8ZM8,10.5a1,1,0,1,0,1,1A1,1,0,0,0,8,10.5Z\"/></svg>";

var u1053 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,14a1,1,0,0,0-1,1v2a1,1,0,0,0,2,0V15A1,1,0,0,0,12,14Zm.38-2.92A1,1,0,0,0,11.8,11l-.18.06-.18.09-.15.12A1,1,0,0,0,11,12a1,1,0,0,0,.29.71,1,1,0,0,0,.33.21A.84.84,0,0,0,12,13a1,1,0,0,0,.71-.29A1,1,0,0,0,13,12a1,1,0,0,0-.29-.71A1.15,1.15,0,0,0,12.38,11.08ZM20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.1,0A1.1,1.1,0,0,0,13.06,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Z\"/></svg>";

var u1054 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M8.29,13.29a1,1,0,0,0,0,1.42l3,3a1,1,0,0,0,1.42,0l3-3a1,1,0,0,0-1.42-1.42L13,14.59V3a1,1,0,0,0-2,0V14.59l-1.29-1.3A1,1,0,0,0,8.29,13.29ZM18,9H16a1,1,0,0,0,0,2h2a1,1,0,0,1,1,1v7a1,1,0,0,1-1,1H6a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H8A1,1,0,0,0,8,9H6a3,3,0,0,0-3,3v7a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3V12A3,3,0,0,0,18,9Z\"/></svg>";

var u1055 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M8.5,10a2,2,0,1,0,2,2A2,2,0,0,0,8.5,10Zm0,7a2,2,0,1,0,2,2A2,2,0,0,0,8.5,17Zm7-10a2,2,0,1,0-2-2A2,2,0,0,0,15.5,7Zm-7-4a2,2,0,1,0,2,2A2,2,0,0,0,8.5,3Zm7,14a2,2,0,1,0,2,2A2,2,0,0,0,15.5,17Zm0-7a2,2,0,1,0,2,2A2,2,0,0,0,15.5,10Z\"/></svg>";

var u1056 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21,12a1,1,0,0,0-1,1v6a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5A1,1,0,0,1,5,4h6a1,1,0,0,0,0-2H5A3,3,0,0,0,2,5V19a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V13A1,1,0,0,0,21,12ZM6,12.76V17a1,1,0,0,0,1,1h4.24a1,1,0,0,0,.71-.29l6.92-6.93h0L21.71,8a1,1,0,0,0,0-1.42L17.47,2.29a1,1,0,0,0-1.42,0L13.23,5.12h0L6.29,12.05A1,1,0,0,0,6,12.76ZM16.76,4.41l2.83,2.83L18.17,8.66,15.34,5.83ZM8,13.17l5.93-5.93,2.83,2.83L10.83,16H8Z\"/></svg>";

var u1057 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,7a2,2,0,1,0-2-2A2,2,0,0,0,12,7Zm0,10a2,2,0,1,0,2,2A2,2,0,0,0,12,17Zm0-7a2,2,0,1,0,2,2A2,2,0,0,0,12,10Z\"/></svg>";

var u1058 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,10a2,2,0,1,0,2,2A2,2,0,0,0,12,10ZM5,10a2,2,0,1,0,2,2A2,2,0,0,0,5,10Zm14,0a2,2,0,1,0,2,2A2,2,0,0,0,19,10Z\"/></svg>";

var u1059 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19,4H5A3,3,0,0,0,2,7V17a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V7A3,3,0,0,0,19,4Zm-.41,2-5.88,5.88a1,1,0,0,1-1.42,0L5.41,6ZM20,17a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V7.41l5.88,5.88a3,3,0,0,0,4.24,0L20,7.41Z\"/></svg>";

var u1060 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21.71,9.29l-4-4a1,1,0,0,0-1.42,1.42L18.59,9H7a1,1,0,0,0,0,2H21a1,1,0,0,0,.92-.62A1,1,0,0,0,21.71,9.29ZM17,13H3a1,1,0,0,0-.92.62,1,1,0,0,0,.21,1.09l4,4a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L5.41,15H17a1,1,0,0,0,0-2Z\"/></svg>";

var u1061 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,16a1,1,0,1,0,1,1A1,1,0,0,0,12,16Zm10.67,1.47-8.05-14a3,3,0,0,0-5.24,0l-8,14A3,3,0,0,0,3.94,22H20.06a3,3,0,0,0,2.61-4.53Zm-1.73,2a1,1,0,0,1-.88.51H3.94a1,1,0,0,1-.88-.51,1,1,0,0,1,0-1l8-14a1,1,0,0,1,1.78,0l8.05,14A1,1,0,0,1,20.94,19.49ZM12,8a1,1,0,0,0-1,1v4a1,1,0,0,0,2,0V9A1,1,0,0,0,12,8Z\"/></svg>";

var u1062 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M18,10.82a1,1,0,0,0-1,1V19a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V8A1,1,0,0,1,5,7h7.18a1,1,0,0,0,0-2H5A3,3,0,0,0,2,8V19a3,3,0,0,0,3,3H16a3,3,0,0,0,3-3V11.82A1,1,0,0,0,18,10.82Zm3.92-8.2a1,1,0,0,0-.54-.54A1,1,0,0,0,21,2H15a1,1,0,0,0,0,2h3.59L8.29,14.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L20,5.41V9a1,1,0,0,0,2,0V3A1,1,0,0,0,21.92,2.62Z\"/></svg>";

var u1063 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21.92,11.6C19.9,6.91,16.1,4,12,4S4.1,6.91,2.08,11.6a1,1,0,0,0,0,.8C4.1,17.09,7.9,20,12,20s7.9-2.91,9.92-7.6A1,1,0,0,0,21.92,11.6ZM12,18c-3.17,0-6.17-2.29-7.9-6C5.83,8.29,8.83,6,12,6s6.17,2.29,7.9,6C18.17,15.71,15.17,18,12,18ZM12,8a4,4,0,1,0,4,4A4,4,0,0,0,12,8Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,12,14Z\"/></svg>";

var u1064 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M10.94,6.08A6.93,6.93,0,0,1,12,6c3.18,0,6.17,2.29,7.91,6a15.23,15.23,0,0,1-.9,1.64,1,1,0,0,0-.16.55,1,1,0,0,0,1.86.5,15.77,15.77,0,0,0,1.21-2.3,1,1,0,0,0,0-.79C19.9,6.91,16.1,4,12,4a7.77,7.77,0,0,0-1.4.12,1,1,0,1,0,.34,2ZM3.71,2.29A1,1,0,0,0,2.29,3.71L5.39,6.8a14.62,14.62,0,0,0-3.31,4.8,1,1,0,0,0,0,.8C4.1,17.09,7.9,20,12,20a9.26,9.26,0,0,0,5.05-1.54l3.24,3.25a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Zm6.36,9.19,2.45,2.45A1.81,1.81,0,0,1,12,14a2,2,0,0,1-2-2A1.81,1.81,0,0,1,10.07,11.48ZM12,18c-3.18,0-6.17-2.29-7.9-6A12.09,12.09,0,0,1,6.8,8.21L8.57,10A4,4,0,0,0,14,15.43L15.59,17A7.24,7.24,0,0,1,12,18Z\"/></svg>";

var u1065 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M9,10h1a1,1,0,0,0,0-2H9a1,1,0,0,0,0,2Zm0,2a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2ZM20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Zm-3-3H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Z\"/></svg>";

var u1066 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M20,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19l-.09,0A.88.88,0,0,0,13.05,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V9S20,9,20,8.94ZM14,5.41,16.59,8H15a1,1,0,0,1-1-1ZM18,19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4h5V7a3,3,0,0,0,3,3h3Z\"/></svg>";

var u1067 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19,2H5A3,3,0,0,0,2,5V6.17a3,3,0,0,0,.25,1.2l0,.06a2.81,2.81,0,0,0,.59.86L9,14.41V21a1,1,0,0,0,.47.85A1,1,0,0,0,10,22a1,1,0,0,0,.45-.11l4-2A1,1,0,0,0,15,19V14.41l6.12-6.12a2.81,2.81,0,0,0,.59-.86l0-.06A3,3,0,0,0,22,6.17V5A3,3,0,0,0,19,2ZM13.29,13.29A1,1,0,0,0,13,14v4.38l-2,1V14a1,1,0,0,0-.29-.71L5.41,8H18.59ZM20,6H4V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z\"/></svg>";

var u1068 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19,5.5H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z\"/></svg>";

var u1069 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M22.78,10.37A1,1,0,0,0,22,10H20V9a3,3,0,0,0-3-3H10.72l-.32-1A3,3,0,0,0,7.56,3H4A3,3,0,0,0,1,6V18a3,3,0,0,0,3,3H18.4a3,3,0,0,0,2.92-2.35L23,11.22A1,1,0,0,0,22.78,10.37ZM5.37,18.22a1,1,0,0,1-1,.78H4a1,1,0,0,1-1-1V6A1,1,0,0,1,4,5H7.56a1,1,0,0,1,1,.68l.54,1.64A1,1,0,0,0,10,8h7a1,1,0,0,1,1,1v1H8a1,1,0,0,0-1,.78Zm14,0a1,1,0,0,1-1,.78H7.21a1.42,1.42,0,0,0,.11-.35L8.8,12h12Z\"/></svg>";

var u1070 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M14,12.5H13v-1a1,1,0,0,0-2,0v1H10a1,1,0,0,0,0,2h1v1a1,1,0,0,0,2,0v-1h1a1,1,0,0,0,0-2Zm5-7H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z\"/></svg>";

var u1071 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12.71,10.79a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2,2a1,1,0,0,0,1.42,1.42l.29-.3V16.5a1,1,0,0,0,2,0V13.91l.29.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM19,5.5H12.72l-.32-1a3,3,0,0,0-2.84-2H5a3,3,0,0,0-3,3v13a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8.5A3,3,0,0,0,19,5.5Zm1,13a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V5.5a1,1,0,0,1,1-1H9.56a1,1,0,0,1,.95.68l.54,1.64A1,1,0,0,0,12,7.5h7a1,1,0,0,1,1,1Z\"/></svg>";

var u1072 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M20.67,9.69,14,5.84a2.67,2.67,0,0,0-4,2.31h0L6,5.84A2.67,2.67,0,0,0,2,8.15v7.7a2.63,2.63,0,0,0,1.33,2.3,2.61,2.61,0,0,0,1.34.37A2.69,2.69,0,0,0,6,18.16l4-2.31h0a2.65,2.65,0,0,0,1.33,2.31,2.66,2.66,0,0,0,2.67,0l6.67-3.85a2.67,2.67,0,0,0,0-4.62ZM10,13.54,5,16.42a.67.67,0,0,1-1-.57V8.15a.67.67,0,0,1,1-.57l5,2.88Zm9.67-1L13,16.43a.69.69,0,0,1-.67,0,.66.66,0,0,1-.33-.58V8.15a.66.66,0,0,1,.33-.58.78.78,0,0,1,.34-.09.63.63,0,0,1,.33.09l6.67,3.85a.67.67,0,0,1,0,1.16Z\"/></svg>";

var u1073 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M6,13H2a1,1,0,0,0-1,1v8a1,1,0,0,0,1,1H6a1,1,0,0,0,1-1V14A1,1,0,0,0,6,13ZM5,21H3V15H5ZM22,9H18a1,1,0,0,0-1,1V22a1,1,0,0,0,1,1h4a1,1,0,0,0,1-1V10A1,1,0,0,0,22,9ZM21,21H19V11h2ZM14,1H10A1,1,0,0,0,9,2V22a1,1,0,0,0,1,1h4a1,1,0,0,0,1-1V2A1,1,0,0,0,14,1ZM13,21H11V3h2Z\"/></svg>";

var u1074 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,2A10,10,0,0,0,5.12,4.77V3a1,1,0,0,0-2,0V7.5a1,1,0,0,0,1,1H8.62a1,1,0,0,0,0-2H6.22A8,8,0,1,1,4,12a1,1,0,0,0-2,0A10,10,0,1,0,12,2Zm0,6a1,1,0,0,0-1,1v3a1,1,0,0,0,1,1h2a1,1,0,0,0,0-2H13V9A1,1,0,0,0,12,8Z\"/></svg>";

var u1075 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M20,8h0L14,2.74a3,3,0,0,0-4,0L4,8a3,3,0,0,0-1,2.26V19a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3V10.25A3,3,0,0,0,20,8ZM14,20H10V15a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1Zm5-1a1,1,0,0,1-1,1H16V15a3,3,0,0,0-3-3H11a3,3,0,0,0-3,3v5H6a1,1,0,0,1-1-1V10.25a1,1,0,0,1,.34-.75l6-5.25a1,1,0,0,1,1.32,0l6,5.25a1,1,0,0,1,.34.75Z\"/></svg>";

var u1076 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21,14a1,1,0,0,0-1,1v4a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V15a1,1,0,0,0-2,0v4a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V15A1,1,0,0,0,21,14Zm-9.71,1.71a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l4-4a1,1,0,0,0-1.42-1.42L13,12.59V3a1,1,0,0,0-2,0v9.59l-2.29-2.3a1,1,0,1,0-1.42,1.42Z\"/></svg>";

var u1077 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M12,10a1,1,0,0,0-1,1v6a1,1,0,0,0,2,0V11A1,1,0,0,0,12,10Zm0-4a1.25,1.25,0,1,0,1.25,1.25A1.25,1.25,0,0,0,12,6Z\"/></svg>";

var u1078 = "<svg id=\"Layer_1\" data-name=\"Layer 1\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,2A10,10,0,1,0,22,12,10.01114,10.01114,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8.00917,8.00917,0,0,1,12,20Zm0-8.5a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0v-3A1,1,0,0,0,12,11.5Zm0-4a1.25,1.25,0,1,0,1.25,1.25A1.25,1.25,0,0,0,12,7.5Z\"/></svg>";

var u1079 = "<svg width=\"567\" height=\"567\" viewBox=\"0 0 567 567\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n<path d=\"M441.118 53.8103L542.177 546.75H31.4615L196.718 183.554L290.242 254.396L307.934 267.797L319.661 248.955L441.118 53.8103Z\" stroke=\"currentColor\" stroke-width=\"40.5\" fill=\"none\" />\n<path d=\"M232.072 428.282L265.231 475.2H300.671L261.676 420.785L296.342 372.669L273.347 356.785L263.183 370.157L232.034 414.099V325.79L201 300.477V475.161H232.034V428.244L232.072 428.282Z\" fill=\"currentColor\"/>\n<path d=\"M410.7 404.129C407.994 397.946 403.936 392.419 398.796 387.975C390.178 379.318 378.545 374.332 366.333 373.985H365.405C363.821 373.985 362.197 374.178 360.69 374.642L390.719 330.004L366.796 313.309L355.473 330.004L326.526 374.216C321.541 381.559 317.406 388.013 314.816 392.496C312.15 397.25 309.831 402.197 307.937 407.298C305.773 412.709 304.652 418.506 304.652 424.342C304.575 431.259 305.966 438.139 308.749 444.515C311.493 450.892 315.589 456.573 320.691 461.288C330.7 471.027 344.149 476.477 358.101 476.477L359.222 476.399H360.458C374.526 476.361 388.091 470.95 398.217 461.172C403.434 456.457 407.569 450.699 410.352 444.245C413.134 437.791 414.564 430.834 414.448 423.839C414.68 417.076 413.405 410.351 410.7 404.129V404.129ZM375.569 440.303C371.241 444.593 365.405 446.989 359.299 447.027C353.231 447.066 347.434 444.67 343.144 440.38C338.855 436.09 336.459 430.293 336.459 424.226C336.459 418.158 338.855 412.361 343.144 408.071C347.434 403.781 353.231 401.385 359.299 401.385H359.492C362.507 401.385 365.482 402.004 368.226 403.163C371.009 404.361 373.482 406.062 375.569 408.264C377.772 410.274 379.511 412.709 380.671 415.453C381.869 418.197 382.449 421.134 382.449 424.11C382.371 430.216 379.898 436.013 375.569 440.303V440.303Z\" fill=\"currentColor\"/>\n</svg>\n";

var u1080 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21.71,6.53,20.29,5.12l1.42-1.41a1,1,0,1,0-1.42-1.42L9.75,12.83a5,5,0,1,0,1.42,1.42l4.88-4.89,1.41,1.42a1,1,0,0,0,.71.29,1,1,0,0,0,.71-.29,1,1,0,0,0,0-1.42L17.46,8l1.42-1.42L20.29,8a1,1,0,0,0,.71.29A1,1,0,0,0,21.71,8,1,1,0,0,0,21.71,6.53ZM7,20a3,3,0,1,1,3-3A3,3,0,0,1,7,20Z\"/></svg>";

var u1081 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M6.21,13.29a.93.93,0,0,0-.33-.21,1,1,0,0,0-.76,0,.9.9,0,0,0-.54.54,1,1,0,1,0,1.84,0A1,1,0,0,0,6.21,13.29ZM13.5,11h1a1,1,0,0,0,0-2h-1a1,1,0,0,0,0,2Zm-4,0h1a1,1,0,0,0,0-2h-1a1,1,0,0,0,0,2Zm-3-2h-1a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2ZM20,5H4A3,3,0,0,0,1,8v8a3,3,0,0,0,3,3H20a3,3,0,0,0,3-3V8A3,3,0,0,0,20,5Zm1,11a1,1,0,0,1-1,1H4a1,1,0,0,1-1-1V8A1,1,0,0,1,4,7H20a1,1,0,0,1,1,1Zm-6-3H9a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Zm3.5-4h-1a1,1,0,0,0,0,2h1a1,1,0,0,0,0-2Zm.71,4.29a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,.93.93,0,0,0-.33.21,1,1,0,0,0-.21.33A1,1,0,1,0,19.5,14a.84.84,0,0,0-.08-.38A1,1,0,0,0,19.21,13.29Z\"/></svg>";

var u1082 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M10,17.55,8.23,19.27a2.47,2.47,0,0,1-3.5-3.5l4.54-4.55a2.46,2.46,0,0,1,3.39-.09l.12.1a1,1,0,0,0,1.4-1.43A2.75,2.75,0,0,0,14,9.59a4.46,4.46,0,0,0-6.09.22L3.31,14.36a4.48,4.48,0,0,0,6.33,6.33L11.37,19A1,1,0,0,0,10,17.55ZM20.69,3.31a4.49,4.49,0,0,0-6.33,0L12.63,5A1,1,0,0,0,14,6.45l1.73-1.72a2.47,2.47,0,0,1,3.5,3.5l-4.54,4.55a2.46,2.46,0,0,1-3.39.09l-.12-.1a1,1,0,0,0-1.4,1.43,2.75,2.75,0,0,0,.23.21,4.47,4.47,0,0,0,6.09-.22l4.55-4.55A4.49,4.49,0,0,0,20.69,3.31Z\"/></svg>";

var u1083 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M3.71,16.29a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21,1,1,0,0,0-.21.33,1,1,0,0,0,.21,1.09,1.15,1.15,0,0,0,.33.21.94.94,0,0,0,.76,0,1.15,1.15,0,0,0,.33-.21,1,1,0,0,0,.21-1.09A1,1,0,0,0,3.71,16.29ZM7,8H21a1,1,0,0,0,0-2H7A1,1,0,0,0,7,8ZM3.71,11.29a1,1,0,0,0-1.09-.21,1.15,1.15,0,0,0-.33.21,1,1,0,0,0-.21.33.94.94,0,0,0,0,.76,1.15,1.15,0,0,0,.21.33,1.15,1.15,0,0,0,.33.21.94.94,0,0,0,.76,0,1.15,1.15,0,0,0,.33-.21,1.15,1.15,0,0,0,.21-.33.94.94,0,0,0,0-.76A1,1,0,0,0,3.71,11.29ZM21,11H7a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2ZM3.71,6.29a1,1,0,0,0-.33-.21,1,1,0,0,0-1.09.21,1.15,1.15,0,0,0-.21.33.94.94,0,0,0,0,.76,1.15,1.15,0,0,0,.21.33,1.15,1.15,0,0,0,.33.21,1,1,0,0,0,1.09-.21,1.15,1.15,0,0,0,.21-.33.94.94,0,0,0,0-.76A1.15,1.15,0,0,0,3.71,6.29ZM21,16H7a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z\"/></svg>";

var u1084 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M17,9V7A5,5,0,0,0,7,7V9a3,3,0,0,0-3,3v7a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V12A3,3,0,0,0,17,9ZM9,7a3,3,0,0,1,6,0V9H9Zm9,12a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H17a1,1,0,0,1,1,1Z\"/></svg>";

var u1085 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19,11H5a1,1,0,0,0,0,2H19a1,1,0,0,0,0-2Z\"/></svg>";

var u1086 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Zm4-9H8a1,1,0,0,0,0,2h8a1,1,0,0,0,0-2Z\"/></svg>";

var u1087 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12.71,16.29l-.15-.12a.76.76,0,0,0-.18-.09L12.2,16a1,1,0,0,0-.91.27,1.15,1.15,0,0,0-.21.33,1,1,0,0,0,1.3,1.31,1.46,1.46,0,0,0,.33-.22,1,1,0,0,0,.21-1.09A1,1,0,0,0,12.71,16.29ZM16,2H8A3,3,0,0,0,5,5V19a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V5A3,3,0,0,0,16,2Zm1,17a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V5A1,1,0,0,1,8,4h8a1,1,0,0,1,1,1Z\"/></svg>";

var u1088 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19,2H5A3,3,0,0,0,2,5V15a3,3,0,0,0,3,3H7.64l-.58,1a2,2,0,0,0,0,2,2,2,0,0,0,1.75,1h6.46A2,2,0,0,0,17,21a2,2,0,0,0,0-2l-.59-1H19a3,3,0,0,0,3-3V5A3,3,0,0,0,19,2ZM8.77,20,10,18H14l1.2,2ZM20,15a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V14H20Zm0-3H4V5A1,1,0,0,1,5,4H19a1,1,0,0,1,1,1Z\"/></svg>";

var u1089 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M16,2a3,3,0,0,0-3,3V19a3,3,0,0,0,6,0V5A3,3,0,0,0,16,2Zm1,17a1,1,0,0,1-2,0V5a1,1,0,0,1,2,0ZM8,2A3,3,0,0,0,5,5V19a3,3,0,0,0,6,0V5A3,3,0,0,0,8,2ZM9,19a1,1,0,0,1-2,0V5A1,1,0,0,1,9,5Z\"/></svg>";

var u1090 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M22,7.24a1,1,0,0,0-.29-.71L17.47,2.29A1,1,0,0,0,16.76,2a1,1,0,0,0-.71.29L13.22,5.12h0L2.29,16.05a1,1,0,0,0-.29.71V21a1,1,0,0,0,1,1H7.24A1,1,0,0,0,8,21.71L18.87,10.78h0L21.71,8a1.19,1.19,0,0,0,.22-.33,1,1,0,0,0,0-.24.7.7,0,0,0,0-.14ZM6.83,20H4V17.17l9.93-9.93,2.83,2.83ZM18.17,8.66,15.34,5.83l1.42-1.41,2.82,2.82Z\"/></svg>";

var u1091 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M18.54,9,8.88,3.46a3.42,3.42,0,0,0-5.13,3V17.58A3.42,3.42,0,0,0,7.17,21a3.43,3.43,0,0,0,1.71-.46L18.54,15a3.42,3.42,0,0,0,0-5.92Zm-1,4.19L7.88,18.81a1.44,1.44,0,0,1-1.42,0,1.42,1.42,0,0,1-.71-1.23V6.42a1.42,1.42,0,0,1,.71-1.23A1.51,1.51,0,0,1,7.17,5a1.54,1.54,0,0,1,.71.19l9.66,5.58a1.42,1.42,0,0,1,0,2.46Z\"/></svg>";

var u1092 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M19,6H16V3a1,1,0,0,0-2,0V6H10V3A1,1,0,0,0,8,3V6H5A1,1,0,0,0,5,8H6v5a1,1,0,0,0,.29.71L9,16.41V21a1,1,0,0,0,2,0V17h2v4a1,1,0,0,0,2,0V16.41l2.71-2.7A1,1,0,0,0,18,13V8h1a1,1,0,0,0,0-2Zm-3,6.59L13.59,15H10.41L8,12.59V8h8ZM11,13h2a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Z\"/></svg>";

var u1093 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19,11H13V5a1,1,0,0,0-2,0v6H5a1,1,0,0,0,0,2h6v6a1,1,0,0,0,2,0V13h6a1,1,0,0,0,0-2Z\"/></svg>";

var u1094 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20Zm4-9H13V8a1,1,0,0,0-2,0v3H8a1,1,0,0,0,0,2h3v3a1,1,0,0,0,2,0V13h3a1,1,0,0,0,0-2Z\"/></svg>";

var u1095 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M10.21,6.21l.79-.8V10a1,1,0,0,0,2,0V5.41l.79.8a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-2.5-2.5a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2.5,2.5a1,1,0,0,0,1.42,1.42ZM18,7.56A1,1,0,1,0,16.56,9,6.45,6.45,0,1,1,7.44,9,1,1,0,1,0,6,7.56a8.46,8.46,0,1,0,12,0Z\"/></svg>";

var u1096 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21,14H20V4h1a1,1,0,0,0,0-2H3A1,1,0,0,0,3,4H4V14H3a1,1,0,0,0,0,2h8v1.15l-4.55,3A1,1,0,0,0,7,22a.94.94,0,0,0,.55-.17L11,19.55V21a1,1,0,0,0,2,0V19.55l3.45,2.28A.94.94,0,0,0,17,22a1,1,0,0,0,.55-1.83l-4.55-3V16h8a1,1,0,0,0,0-2Zm-3,0H6V4H18ZM9.61,12.26a1.73,1.73,0,0,0,1.76,0l3-1.74a1.76,1.76,0,0,0,0-3l-3-1.74a1.73,1.73,0,0,0-1.76,0,1.71,1.71,0,0,0-.87,1.52v3.48A1.71,1.71,0,0,0,9.61,12.26Zm1.13-4.58L13,9l-2.28,1.32Z\"/></svg>";

var u1097 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M6.9917,14.502a.99974.99974,0,0,0-1,1v1.78229a7.97243,7.97243,0,0,1-2-5.28229,7.29085,7.29085,0,0,1,.05273-.87988.99992.99992,0,1,0-1.98535-.24023A9.17334,9.17334,0,0,0,1.9917,12.002a9.96434,9.96434,0,0,0,2.41687,6.5H2.9917a1,1,0,1,0,0,2h4a.98173.98173,0,0,0,.79413-.42181c.01166-.01538.02655-.0268.03741-.043.00666-.00995.00684-.02173.01306-.03186a.96576.96576,0,0,0,.106-.2583.95234.95234,0,0,0,.03143-.15589c.00287-.03088.018-.05749.018-.08911v-4A.99974.99974,0,0,0,6.9917,14.502Zm1.5-8.5H6.70923a7.9737,7.9737,0,0,1,5.28247-2,7.07475,7.07475,0,0,1,.87939.05274,1.00046,1.00046,0,0,0,.24121-1.98633A9.22717,9.22717,0,0,0,11.9917,2.002a9.96421,9.96421,0,0,0-6.5,2.41669V3.002a1,1,0,0,0-2,0v4a.95355.95355,0,0,0,.03931.19471l.00024.00122a.96893.96893,0,0,0,.14117.345l.01142.0169a.97291.97291,0,0,0,.2445.24634c.01093.008.01636.02026.02771.02789.01429.00946.03046.01246.04505.02112a.95817.95817,0,0,0,.17932.084.98784.98784,0,0,0,.26184.05285c.01733.00092.03192.01.04944.01h4a1,1,0,0,0,0-2ZM20.45215,16.80609a.96745.96745,0,0,0-.14124-.34509l-.01129-.01679a.97315.97315,0,0,0-.24469-.24646c-.01092-.00793-.01629-.02026-.02759-.02783-.0108-.00714-.02362-.00738-.0346-.0141a1.15354,1.15354,0,0,0-.40973-.13543c-.03162-.003-.0589-.01844-.09131-.01844h-4a1,1,0,0,0,0,2h1.78241a7.97338,7.97338,0,0,1-5.28241,2,7.07446,7.07446,0,0,1-.8794-.05371,1.00046,1.00046,0,0,0-.24121,1.98633,9.36538,9.36538,0,0,0,1.12061.06738,9.96425,9.96425,0,0,0,6.5-2.41668V21.002a1,1,0,0,0,2,0v-4a.95345.95345,0,0,0-.03931-.1947ZM20.9917,5.502a1,1,0,0,0,0-2h-4a.9519.9519,0,0,0-.19183.0387l-.00666.00134a.96837.96837,0,0,0-.3407.13953l-.01959.01324a.974.974,0,0,0-.2453.24378c-.00787.0108-.02.01611-.02746.02728-.00714.01074-.00739.02344-.0141.03436a1.14563,1.14563,0,0,0-.13636.41266c-.00286.03089-.018.0575-.018.08911v4a1,1,0,1,0,2,0V6.71912a7.97527,7.97527,0,0,1,2,5.28283,7.289,7.289,0,0,1-.05274.87989,1.00106,1.00106,0,0,0,.87208,1.11328,1.02916,1.02916,0,0,0,.12207.00683.99971.99971,0,0,0,.99121-.87988A9.17363,9.17363,0,0,0,21.9917,12.002a9.96411,9.96411,0,0,0-2.417-6.5Z\"/></svg>";

var u1098 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M11.29,15.29a1.58,1.58,0,0,0-.12.15.76.76,0,0,0-.09.18.64.64,0,0,0-.06.18,1.36,1.36,0,0,0,0,.2.84.84,0,0,0,.08.38.9.9,0,0,0,.54.54.94.94,0,0,0,.76,0,.9.9,0,0,0,.54-.54A1,1,0,0,0,13,16a1,1,0,0,0-.29-.71A1,1,0,0,0,11.29,15.29ZM12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20ZM12,7A3,3,0,0,0,9.4,8.5a1,1,0,1,0,1.73,1A1,1,0,0,1,12,9a1,1,0,0,1,0,2,1,1,0,0,0-1,1v1a1,1,0,0,0,2,0v-.18A3,3,0,0,0,12,7Z\"/></svg>";

var u1099 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M5.5,17.5H4V6.5h7.8L11,7.29a1,1,0,0,0,1.41,1.42l2.5-2.5a1,1,0,0,0,0-1.42l-2.5-2.5a1,1,0,0,0-1.41,0,1,1,0,0,0,0,1.42l.79.79H3a1,1,0,0,0-1,1v13a1,1,0,0,0,1,1H5.5a1,1,0,0,0,0-2ZM21,4.5H18.5a1,1,0,0,0,0,2H20v11H11.63l.79-.79a1,1,0,0,0,0-1.42,1,1,0,0,0-1.41,0l-2.5,2.5a1,1,0,0,0,0,1.42l2.5,2.5a1,1,0,0,0,1.41-1.42l-.79-.79H21a1,1,0,0,0,1-1V5.5A1,1,0,0,0,21,4.5Z\"/></svg>";

var u1100 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M22.60107,2.062a1.00088,1.00088,0,0,0-.71289-.71289A11.25224,11.25224,0,0,0,10.46924,4.97217L9.35431,6.296l-2.6048-.62848A2.77733,2.77733,0,0,0,3.36279,7.0249L1.1626,10.9248A.99989.99989,0,0,0,1.82422,12.394l3.07275.65869a13.41952,13.41952,0,0,0-.55517,2.43409,1.00031,1.00031,0,0,0,.28466.83642l3.1001,3.1001a.99941.99941,0,0,0,.707.293c.02881,0,.05762-.00147.08692-.00391a12.16892,12.16892,0,0,0,2.49157-.49l.64368,3.00318a1.0003,1.0003,0,0,0,1.46924.66162l3.90527-2.20264a3.03526,3.03526,0,0,0,1.375-3.30371l-.6687-2.759,1.23706-1.13751A11.20387,11.20387,0,0,0,22.60107,2.062ZM3.57227,10.72314,5.12842,7.96338a.82552.82552,0,0,1,1.06982-.37549l1.71741.4162-.65.77179A13.09523,13.09523,0,0,0,5.67633,11.174Zm12.47021,8.22217L13.32666,20.477l-.4295-2.00464a11.33992,11.33992,0,0,0,2.41339-1.61987l.74353-.68366.40344,1.66462A1.041,1.041,0,0,1,16.04248,18.94531ZM17.65674,11.98l-3.68457,3.38623a9.77348,9.77348,0,0,1-5.17041,2.3042l-2.4043-2.4043a10.932,10.932,0,0,1,2.40088-5.206l1.67834-1.99268a.9635.9635,0,0,0,.07813-.09277L11.98975,6.271a9.27757,9.27757,0,0,1,8.80957-3.12012A9.21808,9.21808,0,0,1,17.65674,11.98Zm-.923-6.16376a1.5,1.5,0,1,0,1.5,1.5A1.49992,1.49992,0,0,0,16.7337,5.81622Z\"/></svg>";

var u1101 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M2.88,16.88a3,3,0,0,0,0,4.24,3,3,0,0,0,4.24,0,3,3,0,0,0-4.24-4.24Zm2.83,2.83a1,1,0,0,1-1.42-1.42,1,1,0,0,1,1.42,0A1,1,0,0,1,5.71,19.71ZM5,12a1,1,0,0,0,0,2,5,5,0,0,1,5,5,1,1,0,0,0,2,0,7,7,0,0,0-7-7ZM5,8a1,1,0,0,0,0,2,9,9,0,0,1,9,9,1,1,0,0,0,2,0,11.08,11.08,0,0,0-3.22-7.78A11.08,11.08,0,0,0,5,8Zm10.61.39A15.11,15.11,0,0,0,5,4,1,1,0,0,0,5,6,13,13,0,0,1,18,19a1,1,0,0,0,2,0A15.11,15.11,0,0,0,15.61,8.39Z\"/></svg>";

var u1102 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M20.71,9.29l-6-6a1,1,0,0,0-.32-.21A1.09,1.09,0,0,0,14,3H6A3,3,0,0,0,3,6V18a3,3,0,0,0,3,3H18a3,3,0,0,0,3-3V10A1,1,0,0,0,20.71,9.29ZM9,5h4V7H9Zm6,14H9V16a1,1,0,0,1,1-1h4a1,1,0,0,1,1,1Zm4-1a1,1,0,0,1-1,1H17V16a3,3,0,0,0-3-3H10a3,3,0,0,0-3,3v3H6a1,1,0,0,1-1-1V6A1,1,0,0,1,6,5H7V8A1,1,0,0,0,8,9h6a1,1,0,0,0,1-1V6.41l4,4Z\"/></svg>";

var u1103 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21.71,20.29,18,16.61A9,9,0,1,0,16.61,18l3.68,3.68a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM11,18a7,7,0,1,1,7-7A7,7,0,0,1,11,18Z\"/></svg>";

var u1104 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21.71,20.29,18,16.61A9,9,0,1,0,16.61,18l3.68,3.68a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM11,18a7,7,0,1,1,7-7A7,7,0,0,1,11,18Zm4-8H7a1,1,0,0,0,0,2h8a1,1,0,0,0,0-2Z\"/></svg>";

var u1105 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M15,10H12V7a1,1,0,0,0-2,0v3H7a1,1,0,0,0,0,2h3v3a1,1,0,0,0,2,0V12h3a1,1,0,0,0,0-2Zm6.71,10.29L18,16.61A9,9,0,1,0,16.61,18l3.68,3.68a1,1,0,0,0,1.42,0A1,1,0,0,0,21.71,20.29ZM11,18a7,7,0,1,1,7-7A7,7,0,0,1,11,18Z\"/></svg>";

var u1106 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M18,14a4,4,0,0,0-3.08,1.48l-5.1-2.35a3.64,3.64,0,0,0,0-2.26l5.1-2.35A4,4,0,1,0,14,6a4.17,4.17,0,0,0,.07.71L8.79,9.14a4,4,0,1,0,0,5.72l5.28,2.43A4.17,4.17,0,0,0,14,18a4,4,0,1,0,4-4ZM18,4a2,2,0,1,1-2,2A2,2,0,0,1,18,4ZM6,14a2,2,0,1,1,2-2A2,2,0,0,1,6,14Zm12,6a2,2,0,1,1,2-2A2,2,0,0,1,18,20Z\"/></svg>";

var u1107 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19.63,3.65a1,1,0,0,0-.84-.2,8,8,0,0,1-6.22-1.27,1,1,0,0,0-1.14,0A8,8,0,0,1,5.21,3.45a1,1,0,0,0-.84.2A1,1,0,0,0,4,4.43v7.45a9,9,0,0,0,3.77,7.33l3.65,2.6a1,1,0,0,0,1.16,0l3.65-2.6A9,9,0,0,0,20,11.88V4.43A1,1,0,0,0,19.63,3.65ZM18,11.88a7,7,0,0,1-2.93,5.7L12,19.77,8.93,17.58A7,7,0,0,1,6,11.88V5.58a10,10,0,0,0,6-1.39,10,10,0,0,0,6,1.39Z\"/></svg>";

var u1108 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M6,15a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0V16A1,1,0,0,0,6,15Zm4-3a1,1,0,0,0-1,1v6a1,1,0,0,0,2,0V13A1,1,0,0,0,10,12Zm8-8a1,1,0,0,0-1,1V19a1,1,0,0,0,2,0V5A1,1,0,0,0,18,4ZM14,8a1,1,0,0,0-1,1V19a1,1,0,0,0,2,0V9A1,1,0,0,0,14,8Z\"/></svg>";

var u1109 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M20,12a1,1,0,0,0-1-1H11.41l2.3-2.29a1,1,0,1,0-1.42-1.42l-4,4a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l4,4a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42L11.41,13H19A1,1,0,0,0,20,12ZM17,2H7A3,3,0,0,0,4,5V19a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V16a1,1,0,0,0-2,0v3a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V5A1,1,0,0,1,7,4H17a1,1,0,0,1,1,1V8a1,1,0,0,0,2,0V5A3,3,0,0,0,17,2Z\"/></svg>";

var u1110 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M4,12a1,1,0,0,0,1,1h7.59l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76,1,1,0,0,0-.21-.33l-4-4a1,1,0,1,0-1.42,1.42L12.59,11H5A1,1,0,0,0,4,12ZM17,2H7A3,3,0,0,0,4,5V8A1,1,0,0,0,6,8V5A1,1,0,0,1,7,4H17a1,1,0,0,1,1,1V19a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V16a1,1,0,0,0-2,0v3a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V5A3,3,0,0,0,17,2Z\"/></svg>";

var u1111 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M22,15H20V12a1,1,0,0,0-1-1H13V9h2a1,1,0,0,0,1-1V2a1,1,0,0,0-1-1H9A1,1,0,0,0,8,2V8A1,1,0,0,0,9,9h2v2H5a1,1,0,0,0-1,1v3H2a1,1,0,0,0-1,1v6a1,1,0,0,0,1,1H8a1,1,0,0,0,1-1V16a1,1,0,0,0-1-1H6V13H18v2H16a1,1,0,0,0-1,1v6a1,1,0,0,0,1,1h6a1,1,0,0,0,1-1V16A1,1,0,0,0,22,15ZM7,17v4H3V17ZM10,7V3h4V7ZM21,21H17V17h4Z\"/></svg>";

var u1112 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M2,14.67a2,2,0,1,0,4,0v-2H4A2,2,0,0,0,2,14.67Zm12.64-3.34a2,2,0,0,0,2-2V4a2,2,0,1,0-4,0V9.33A2,2,0,0,0,14.66,11.33Zm7.32-2a2,2,0,1,0-4,0v2h2A2,2,0,0,0,22,9.33ZM9.34,12.67a2,2,0,0,0-2,2V20a2,2,0,1,0,4,0V14.67A2,2,0,0,0,9.34,12.67ZM14.66,18h-2v2a2,2,0,1,0,2-2ZM20,12.67H14.66a2,2,0,0,0,0,4H20a2,2,0,0,0,0-4ZM9.34,7.33H4a2,2,0,1,0,0,4H9.34a2,2,0,0,0,0-4ZM9.34,2a2,2,0,0,0,0,4h2V4A2,2,0,0,0,9.34,2Z\"/></svg>";

var u1113 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M20,8.18V3a1,1,0,0,0-2,0V8.18a3,3,0,0,0,0,5.64V21a1,1,0,0,0,2,0V13.82a3,3,0,0,0,0-5.64ZM19,12a1,1,0,1,1,1-1A1,1,0,0,1,19,12Zm-6,2.18V3a1,1,0,0,0-2,0V14.18a3,3,0,0,0,0,5.64V21a1,1,0,0,0,2,0V19.82a3,3,0,0,0,0-5.64ZM12,18a1,1,0,1,1,1-1A1,1,0,0,1,12,18ZM6,6.18V3A1,1,0,0,0,4,3V6.18a3,3,0,0,0,0,5.64V21a1,1,0,0,0,2,0V11.82A3,3,0,0,0,6,6.18ZM5,10A1,1,0,1,1,6,9,1,1,0,0,1,5,10Z\"/></svg>";

var u1114 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M6.29,14.29l-.29.3V7A1,1,0,0,0,4,7v7.59l-.29-.3a1,1,0,0,0-1.42,1.42l2,2a1,1,0,0,0,.33.21.94.94,0,0,0,.76,0,1,1,0,0,0,.33-.21l2-2a1,1,0,0,0-1.42-1.42ZM11,8H21a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Zm10,3H11a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0,5H11a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z\"/></svg>";

var u1115 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M5.71,6.29a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-2,2A1,1,0,0,0,3.71,9.71L4,9.41V17a1,1,0,0,0,2,0V9.41l.29.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42ZM11,8H21a1,1,0,0,0,0-2H11a1,1,0,0,0,0,2Zm10,8H11a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Zm0-5H11a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z\"/></svg>";

var u1116 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M17,2H7A5,5,0,0,0,2,7V17a5,5,0,0,0,5,5H17a5,5,0,0,0,5-5V7A5,5,0,0,0,17,2Zm3,15a3,3,0,0,1-3,3H7a3,3,0,0,1-3-3V7A3,3,0,0,1,7,4H17a3,3,0,0,1,3,3Z\"/></svg>";

var u1117 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M22,9.67A1,1,0,0,0,21.14,9l-5.69-.83L12.9,3a1,1,0,0,0-1.8,0L8.55,8.16,2.86,9a1,1,0,0,0-.81.68,1,1,0,0,0,.25,1l4.13,4-1,5.68a1,1,0,0,0,.4,1,1,1,0,0,0,1.05.07L12,18.76l5.1,2.68a.93.93,0,0,0,.46.12,1,1,0,0,0,.59-.19,1,1,0,0,0,.4-1l-1-5.68,4.13-4A1,1,0,0,0,22,9.67Zm-6.15,4a1,1,0,0,0-.29.89l.72,4.19-3.76-2a1,1,0,0,0-.94,0l-3.76,2,.72-4.19a1,1,0,0,0-.29-.89l-3-3,4.21-.61a1,1,0,0,0,.76-.55L12,5.7l1.88,3.82a1,1,0,0,0,.76.55l4.21.61Z\"/></svg>";

var u1118 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M20.28,3.43a3.23,3.23,0,0,0-3.29,0L8,8.84V6A3,3,0,0,0,2,6V18a3,3,0,0,0,6,0V15.16l9,5.37a3.28,3.28,0,0,0,1.68.47,3.24,3.24,0,0,0,1.61-.43,3.38,3.38,0,0,0,1.72-3V6.42A3.38,3.38,0,0,0,20.28,3.43ZM6,18a1,1,0,0,1-2,0V6A1,1,0,0,1,6,6Zm14-.42a1.4,1.4,0,0,1-.71,1.25,1.23,1.23,0,0,1-1.28,0L8.68,13.23a1.45,1.45,0,0,1,0-2.46L18,5.19A1.23,1.23,0,0,1,18.67,5a1.29,1.29,0,0,1,.62.17A1.4,1.4,0,0,1,20,6.42Z\"/></svg>";

var u1119 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M19.91,15.51H15.38a1,1,0,0,0,0,2h2.4A8,8,0,0,1,4,12a1,1,0,0,0-2,0,10,10,0,0,0,16.88,7.23V21a1,1,0,0,0,2,0V16.5A1,1,0,0,0,19.91,15.51ZM12,2A10,10,0,0,0,5.12,4.77V3a1,1,0,0,0-2,0V7.5a1,1,0,0,0,1,1h4.5a1,1,0,0,0,0-2H6.22A8,8,0,0,1,20,12a1,1,0,0,0,2,0A10,10,0,0,0,12,2Z\"/></svg>";

var u1120 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM8,20H4V16H8Zm0-6H4V10H8ZM8,8H4V4H8Zm6,12H10V16h4Zm0-6H10V10h4Zm0-6H10V4h4Zm6,12H16V16h4Zm0-6H16V10h4Zm0-6H16V4h4Z\"/></svg>";

var u1121 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M7.5,6A1.5,1.5,0,1,0,9,7.5,1.5,1.5,0,0,0,7.5,6Zm13.62,4.71L12.71,2.29A1,1,0,0,0,12,2H3A1,1,0,0,0,2,3v9a1,1,0,0,0,.29.71l8.42,8.41a3,3,0,0,0,4.24,0L21.12,15a3,3,0,0,0,0-4.24Zm-1.41,2.82h0l-6.18,6.17a1,1,0,0,1-1.41,0L4,11.59V4h7.59l8.12,8.12a1,1,0,0,1,.29.71A1,1,0,0,1,19.71,13.53Z\"/></svg>";

var u1122 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M13.41,12l4.3-4.29a1,1,0,1,0-1.42-1.42L12,10.59,7.71,6.29A1,1,0,0,0,6.29,7.71L10.59,12l-4.3,4.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L12,13.41l4.29,4.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Z\"/></svg>";

var u1123 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M10,18a1,1,0,0,0,1-1V11a1,1,0,0,0-2,0v6A1,1,0,0,0,10,18ZM20,6H16V5a3,3,0,0,0-3-3H11A3,3,0,0,0,8,5V6H4A1,1,0,0,0,4,8H5V19a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V8h1a1,1,0,0,0,0-2ZM10,5a1,1,0,0,1,1-1h2a1,1,0,0,1,1,1V6H10Zm7,14a1,1,0,0,1-1,1H8a1,1,0,0,1-1-1V8H17Zm-3-1a1,1,0,0,0,1-1V11a1,1,0,0,0-2,0v6A1,1,0,0,0,14,18Z\"/></svg>";

var u1124 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M17,9H9V7a3,3,0,0,1,5.12-2.13,3.08,3.08,0,0,1,.78,1.38,1,1,0,1,0,1.94-.5,5.09,5.09,0,0,0-1.31-2.29A5,5,0,0,0,7,7V9a3,3,0,0,0-3,3v7a3,3,0,0,0,3,3H17a3,3,0,0,0,3-3V12A3,3,0,0,0,17,9Zm1,10a1,1,0,0,1-1,1H7a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1H17a1,1,0,0,1,1,1Z\"/></svg>";

var u1125 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M8.71,7.71,11,5.41V15a1,1,0,0,0,2,0V5.41l2.29,2.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-4-4a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-4,4A1,1,0,1,0,8.71,7.71ZM21,12a1,1,0,0,0-1,1v6a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V13a1,1,0,0,0-2,0v6a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V13A1,1,0,0,0,21,12Z\"/></svg>";

var u1126 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M15.71,12.71a6,6,0,1,0-7.42,0,10,10,0,0,0-6.22,8.18,1,1,0,0,0,2,.22,8,8,0,0,1,15.9,0,1,1,0,0,0,1,.89h.11a1,1,0,0,0,.88-1.1A10,10,0,0,0,15.71,12.71ZM12,12a4,4,0,1,1,4-4A4,4,0,0,1,12,12Z\"/></svg>";

var u1127 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12.3,12.22A4.92,4.92,0,0,0,14,8.5a5,5,0,0,0-10,0,4.92,4.92,0,0,0,1.7,3.72A8,8,0,0,0,1,19.5a1,1,0,0,0,2,0,6,6,0,0,1,12,0,1,1,0,0,0,2,0A8,8,0,0,0,12.3,12.22ZM9,11.5a3,3,0,1,1,3-3A3,3,0,0,1,9,11.5Zm9.74.32A5,5,0,0,0,15,3.5a1,1,0,0,0,0,2,3,3,0,0,1,3,3,3,3,0,0,1-1.5,2.59,1,1,0,0,0-.5.84,1,1,0,0,0,.45.86l.39.26.13.07a7,7,0,0,1,4,6.38,1,1,0,0,0,2,0A9,9,0,0,0,18.74,11.82Z\"/></svg>";

var u1128 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M3,7H21a1,1,0,0,0,0-2H3A1,1,0,0,0,3,7Zm6,8H3a1,1,0,0,0,0,2H9a1,1,0,0,0,0-2Zm9.5-5H3a1,1,0,0,0,0,2H18.5a1.5,1.5,0,0,1,0,3H15.41l.3-.29a1,1,0,0,0-1.42-1.42l-2,2a1,1,0,0,0-.21.33,1,1,0,0,0,0,.76,1,1,0,0,0,.21.33l2,2a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42l-.3-.29H18.5a3.5,3.5,0,0,0,0-7Z\"/></svg>";

var u1129 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M18.42,8.22A7,7,0,0,0,5.06,10.11,4,4,0,0,0,6,18a1,1,0,0,0,0-2,2,2,0,0,1,0-4,1,1,0,0,0,1-1,5,5,0,0,1,9.73-1.61,1,1,0,0,0,.78.67,3,3,0,0,1,.24,5.84,1,1,0,0,0,.5,1.94,5,5,0,0,0,.17-9.62Zm-5.71,2.07a1,1,0,0,0-.33-.21,1,1,0,0,0-.76,0,1,1,0,0,0-.33.21l-3,3a1,1,0,0,0,1.42,1.42L11,13.41V19a1,1,0,0,0,2,0V13.41l1.29,1.3a1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.42Z\"/></svg>";

var u1130 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M7,15h3a1,1,0,0,0,0-2H7a1,1,0,0,0,0,2ZM19,5H5A3,3,0,0,0,2,8v9a3,3,0,0,0,3,3H19a3,3,0,0,0,3-3V8A3,3,0,0,0,19,5Zm1,12a1,1,0,0,1-1,1H5a1,1,0,0,1-1-1V11H20Zm0-8H4V8A1,1,0,0,1,5,7H19a1,1,0,0,1,1,1Z\"/></svg>";

var u1131 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M16,20H8a3,3,0,0,1-3-3V7A1,1,0,0,0,3,7V17a5,5,0,0,0,5,5h8a1,1,0,0,0,0-2Zm-6-7a1,1,0,0,0,1,1h5a1,1,0,0,0,0-2H11A1,1,0,0,0,10,13ZM21,8.94a1.31,1.31,0,0,0-.06-.27l0-.09a1.07,1.07,0,0,0-.19-.28h0l-6-6h0a1.07,1.07,0,0,0-.28-.19.32.32,0,0,0-.09,0A.88.88,0,0,0,14.05,2H10A3,3,0,0,0,7,5V15a3,3,0,0,0,3,3h8a3,3,0,0,0,3-3V9S21,9,21,8.94ZM15,5.41,17.59,8H16a1,1,0,0,1-1-1ZM19,15a1,1,0,0,1-1,1H10a1,1,0,0,1-1-1V5a1,1,0,0,1,1-1h3V7a3,3,0,0,0,.18,1H11a1,1,0,0,0,0,2h8Z\"/></svg>";

var u1132 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M8.46777,8.39453l-.00225.00183-.00214.00208ZM18.42188,8.208a1.237,1.237,0,0,0-.23-.17481.99959.99959,0,0,0-1.39941.41114,5.78155,5.78155,0,0,1-1.398,1.77734,8.6636,8.6636,0,0,0,.1333-1.50977,8.71407,8.71407,0,0,0-4.40039-7.582,1.00009,1.00009,0,0,0-1.49121.80567A7.017,7.017,0,0,1,7.165,6.87793l-.23047.1875a8.51269,8.51269,0,0,0-1.9873,1.8623A8.98348,8.98348,0,0,0,8.60254,22.83594.99942.99942,0,0,0,9.98,21.91016a1.04987,1.04987,0,0,0-.0498-.3125,6.977,6.977,0,0,1-.18995-2.58106,9.004,9.004,0,0,0,4.3125,4.0166.997.997,0,0,0,.71534.03809A8.99474,8.99474,0,0,0,18.42188,8.208ZM14.51709,21.03906a6.964,6.964,0,0,1-3.57666-4.40234,8.90781,8.90781,0,0,1-.17969-.96387,1.00025,1.00025,0,0,0-.79931-.84473A.982.982,0,0,0,9.77,14.80957a.99955.99955,0,0,0-.8667.501,8.9586,8.9586,0,0,0-1.20557,4.71777,6.98547,6.98547,0,0,1-1.17529-9.86816,6.55463,6.55463,0,0,1,1.562-1.458.74507.74507,0,0,0,.07422-.05469s.29669-.24548.30683-.2511a8.96766,8.96766,0,0,0,2.89874-4.63269,6.73625,6.73625,0,0,1,1.38623,8.08789,1.00024,1.00024,0,0,0,1.18359,1.418,7.85568,7.85568,0,0,0,3.86231-2.6875,7.00072,7.00072,0,0,1-3.2793,10.457Z\"/></svg>";

var u1133 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M18.9917,21.002h-1V19.335a5.00057,5.00057,0,0,0-.29956-1.67773c-.01093-.02936-.0224-.05658-.03589-.08454a4.97694,4.97694,0,0,0-.66455-1.23675l-1.3999-1.86719a3.01933,3.01933,0,0,1-.6001-1.80078V11.6582a3.02108,3.02108,0,0,1,.87842-2.12109l.65722-.65723A4.94566,4.94566,0,0,0,17.92365,6.0415c.00054-.01391.008-.02551.008-.03955l-.00281-.01373a5.01836,5.01836,0,0,0,.06287-.64349V3.002h1a1,1,0,0,0,0-2h-14a1,1,0,0,0,0,2h1V5.34473a5.01836,5.01836,0,0,0,.06287.64349L6.05176,6.002c0,.014.00744.02564.008.03955a4.94571,4.94571,0,0,0,1.3963,2.83838l.65723.65723A3.02108,3.02108,0,0,1,8.9917,11.6582V12.668a3.02212,3.02212,0,0,1-.59961,1.80078L6.99121,16.33594a4.98221,4.98221,0,0,0-.66437,1.23718c-.0133.02771-.02472.05463-.03552.08368A5.00309,5.00309,0,0,0,5.9917,19.335v1.667h-1a1,1,0,0,0,0,2h14a1,1,0,0,0,0-2Zm-11-16v-2h8v2Zm.87842,2.46387A2.97036,2.97036,0,0,1,8.49323,7.002h6.99694a2.97094,2.97094,0,0,1-.37689.46387l-.65723.65723a4.9603,4.9603,0,0,0-1.42187,2.8789h-2.085A4.96025,4.96025,0,0,0,9.52734,8.123ZM9.99219,15.668a5.03688,5.03688,0,0,0,.98828-2.666h2.02246a5.03332,5.03332,0,0,0,.98877,2.666l1.00012,1.334H8.99133Zm5.99951,5.334h-8V19.335a2.954,2.954,0,0,1,.02722-.333h7.94556a2.954,2.954,0,0,1,.02722.333Z\"/></svg>";

var u1134 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M2.5,8.86l9,5.2a1,1,0,0,0,1,0l9-5.2A1,1,0,0,0,22,8a1,1,0,0,0-.5-.87l-9-5.19a1,1,0,0,0-1,0l-9,5.19A1,1,0,0,0,2,8,1,1,0,0,0,2.5,8.86ZM12,4l7,4-7,4L5,8Zm8.5,7.17L12,16,3.5,11.13a1,1,0,0,0-1.37.37,1,1,0,0,0,.37,1.36l9,5.2a1,1,0,0,0,1,0l9-5.2a1,1,0,0,0,.37-1.36A1,1,0,0,0,20.5,11.13Zm0,4L12,20,3.5,15.13a1,1,0,0,0-1.37.37,1,1,0,0,0,.37,1.36l9,5.2a1,1,0,0,0,1,0l9-5.2a1,1,0,0,0,.37-1.36A1,1,0,0,0,20.5,15.13Z\"/></svg>";

var u1135 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21,2H9A1,1,0,0,0,8,3V7H6A1,1,0,0,0,5,8v4H3a1,1,0,0,0-1,1v8a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V19h4a1,1,0,0,0,1-1V16h4a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM10,20H4V14h6Zm5-3H12V13a1,1,0,0,0-1-1H7V9h8Zm5-3H17V8a1,1,0,0,0-1-1H10V4H20Z\"/></svg>";

var u1136 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M21.71,3.29a1,1,0,0,0-1.42,0l-18,18a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l18-18A1,1,0,0,0,21.71,3.29Z\"/></svg>";

var u1137 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M3.5,6a1,1,0,1,0,1,1A1,1,0,0,0,3.5,6Zm4,2h14a1,1,0,0,0,0-2H7.5a1,1,0,0,0,0,2Zm0,3a1,1,0,1,0,1,1A1,1,0,0,0,7.5,11Zm4,5a1,1,0,1,0,1,1A1,1,0,0,0,11.5,16Zm10-5h-10a1,1,0,0,0,0,2h10a1,1,0,0,0,0-2Zm0,5h-6a1,1,0,0,0,0,2h6a1,1,0,0,0,0-2Z\"/></svg>";

var u1138 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M20.34,9.32l-14-7a3,3,0,0,0-4.08,3.9l2.4,5.37h0a1.06,1.06,0,0,1,0,.82l-2.4,5.37A3,3,0,0,0,5,22a3.14,3.14,0,0,0,1.35-.32l14-7a3,3,0,0,0,0-5.36Zm-.89,3.57-14,7a1,1,0,0,1-1.35-1.3l2.39-5.37A2,2,0,0,0,6.57,13h6.89a1,1,0,0,0,0-2H6.57a2,2,0,0,0-.08-.22L4.1,5.41a1,1,0,0,1,1.35-1.3l14,7a1,1,0,0,1,0,1.78Z\"/></svg>";

var u1139 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M7.42,15.54a1,1,0,0,0,0,1.41,1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.41A1,1,0,0,0,7.42,15.54Zm0-8.49a1,1,0,0,0,0,1.41,1,1,0,0,0,1.42,0,1,1,0,0,0,0-1.41A1,1,0,0,0,7.42,7.05Zm4.95,10a1,1,0,1,0,1,1A1,1,0,0,0,12.37,17Zm-6-6a1,1,0,1,0,1,1A1,1,0,0,0,6.37,11Zm6-6a1,1,0,1,0,1,1A1,1,0,0,0,12.37,5Zm3.54,2.05a1,1,0,1,0,1.41,0A1,1,0,0,0,15.91,7.05Zm6.3,0a11,11,0,1,0-7.85,15.74,3.87,3.87,0,0,0,2.5-1.65A4.2,4.2,0,0,0,17.47,18a5.65,5.65,0,0,1-.1-1,5,5,0,0,1,3-4.56,3.84,3.84,0,0,0,2.06-2.25A4,4,0,0,0,22.21,7.08Zm-1.7,2.44a1.9,1.9,0,0,1-1,1.09A7,7,0,0,0,15.37,17a7.3,7.3,0,0,0,.14,1.4,2.16,2.16,0,0,1-.31,1.65,1.79,1.79,0,0,1-1.21.8,8.72,8.72,0,0,1-1.62.15,9,9,0,0,1-9-9.28A9.05,9.05,0,0,1,11.85,3h.51a9,9,0,0,1,8.06,5A2,2,0,0,1,20.51,9.52ZM12.37,11a1,1,0,1,0,1,1A1,1,0,0,0,12.37,11Z\"/></svg>";

var u1140 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M7.75781,10.75781a3,3,0,1,0-3-3A3.00328,3.00328,0,0,0,7.75781,10.75781Zm0-4a1,1,0,1,1-1,1A1.00067,1.00067,0,0,1,7.75781,6.75781Zm8.48438,6.48438a3,3,0,1,0,3,3A3.00328,3.00328,0,0,0,16.24219,13.24219Zm0,4a1,1,0,1,1,1-1A1.00067,1.00067,0,0,1,16.24219,17.24219ZM19.707,4.293a.99962.99962,0,0,0-1.41406,0l-14,14A.99989.99989,0,1,0,5.707,19.707l14-14A.99962.99962,0,0,0,19.707,4.293Z\"/></svg>";

var u1141 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12.92,15a.56.56,0,0,0-.09-.17l-.12-.15a1,1,0,0,0-1.42,0,.61.61,0,0,0-.12.15.56.56,0,0,0-.09.17.7.7,0,0,0-.06.19,1.23,1.23,0,0,0,0,.19.88.88,0,0,0,.08.39,1,1,0,0,0,1.3.54,1.19,1.19,0,0,0,.33-.22,1,1,0,0,0,.21-.32,1,1,0,0,0,.08-.39,1.23,1.23,0,0,0,0-.19A.7.7,0,0,0,12.92,15ZM12,7.36a1,1,0,0,0-1,1v3a1,1,0,0,0,2,0v-3A1,1,0,0,0,12,7.36Zm7.63-3.71a1,1,0,0,0-.84-.2,8,8,0,0,1-6.22-1.27,1,1,0,0,0-1.14,0A8,8,0,0,1,5.21,3.45a1,1,0,0,0-.84.2A1,1,0,0,0,4,4.43v7.45a9,9,0,0,0,3.77,7.33l3.65,2.6a1,1,0,0,0,1.16,0l3.65-2.6A9,9,0,0,0,20,11.88V4.43A1,1,0,0,0,19.63,3.65ZM18,11.88a7,7,0,0,1-2.93,5.7L12,19.77,8.93,17.58A7,7,0,0,1,6,11.88V5.58a10,10,0,0,0,6-1.39,10,10,0,0,0,6,1.39Z\"/></svg>";

var u1142 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M9,13h2v2a1,1,0,0,0,2,0V13h2a1,1,0,0,0,0-2H13V9a1,1,0,0,0-2,0v2H9a1,1,0,0,0,0,2ZM21,2H3A1,1,0,0,0,2,3V21a1,1,0,0,0,1,1H21a1,1,0,0,0,1-1V3A1,1,0,0,0,21,2ZM20,20H4V4H20Z\"/></svg>";

var u1143 = "<svg xmlns=\"http://www.w3.org/2000/svg\" data-name=\"Layer 1\" viewBox=\"0 0 24 24\"><path d=\"M8,19a3,3,0,0,1-3-3V8A3,3,0,0,1,8,5,1,1,0,0,0,8,3,5,5,0,0,0,3,8v8a5,5,0,0,0,5,5,1,1,0,0,0,0-2Zm7.71-3.29a1,1,0,0,0,0-1.42L13.41,12l2.3-2.29a1,1,0,0,0-1.42-1.42L12,10.59,9.71,8.29A1,1,0,0,0,8.29,9.71L10.59,12l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0L12,13.41l2.29,2.3a1,1,0,0,0,1.42,0ZM16,3a1,1,0,0,0,0,2,3,3,0,0,1,3,3v8a3,3,0,0,1-3,3,1,1,0,0,0,0,2,5,5,0,0,0,5-5V8A5,5,0,0,0,16,3Z\"/></svg>";

var u1144 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M3,9A1,1,0,0,0,4,8V5A1,1,0,0,1,5,4H8A1,1,0,0,0,8,2H5A3,3,0,0,0,2,5V8A1,1,0,0,0,3,9ZM8,20H5a1,1,0,0,1-1-1V16a1,1,0,0,0-2,0v3a3,3,0,0,0,3,3H8a1,1,0,0,0,0-2ZM12,8a4,4,0,1,0,4,4A4,4,0,0,0,12,8Zm0,6a2,2,0,1,1,2-2A2,2,0,0,1,12,14ZM19,2H16a1,1,0,0,0,0,2h3a1,1,0,0,1,1,1V8a1,1,0,0,0,2,0V5A3,3,0,0,0,19,2Zm2,13a1,1,0,0,0-1,1v3a1,1,0,0,1-1,1H16a1,1,0,0,0,0,2h3a3,3,0,0,0,3-3V16A1,1,0,0,0,21,15Z\"/></svg>";

var u1145 = "<svg viewBox=\"0 0 15 15\" fill=\"black\" xmlns=\"http://www.w3.org/2000/svg\">\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.92009 1.43307C1.70105 1.43307 1.4906 1.64169 1.4906 1.86641C1.4906 1.94501 1.46966 2.01873 1.43307 2.08229V13.1331C1.43307 13.3578 1.64353 13.5664 1.86257 13.5664H13.1369C13.356 13.5664 13.5664 13.3578 13.5664 13.1331V1.86641C13.5664 1.64169 13.356 1.43307 13.1369 1.43307H1.92009ZM0.65095 1.60921C0.597816 1.68115 0.566406 1.77011 0.566406 1.86641V13.1331C0.566406 13.8328 1.16126 14.4331 1.86257 14.4331H13.1369C13.8382 14.4331 14.4331 13.8328 14.4331 13.1331V1.86641C14.4331 1.16667 13.8382 0.566406 13.1369 0.566406H1.92009C1.3066 0.566406 0.774569 1.02576 0.65095 1.60921Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M3.10938 3.59935C3.10938 3.36003 3.30338 3.16602 3.54271 3.16602H6.48938C6.7287 3.16602 6.92271 3.36003 6.92271 3.59935V6.54602C6.92271 6.78534 6.7287 6.97935 6.48938 6.97935H3.54271C3.30338 6.97935 3.10938 6.78534 3.10938 6.54602V3.59935ZM3.97604 4.03268V6.11268H6.05604V4.03268H3.97604Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M3.10938 8.51146C3.10938 8.27213 3.30338 8.07812 3.54271 8.07812H6.48938C6.7287 8.07812 6.92271 8.27213 6.92271 8.51146V11.4581C6.92271 11.6974 6.7287 11.8915 6.48938 11.8915H3.54271C3.30338 11.8915 3.10938 11.6974 3.10938 11.4581V8.51146ZM3.97604 8.94479V11.0248H6.05604V8.94479H3.97604Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.13672 3.59935C8.13672 3.36003 8.33073 3.16602 8.57005 3.16602H11.5167C11.756 3.16602 11.9501 3.36003 11.9501 3.59935V6.54602C11.9501 6.78534 11.756 6.97935 11.5167 6.97935H8.57005C8.33073 6.97935 8.13672 6.78534 8.13672 6.54602V3.59935ZM9.00339 4.03268V6.11268H11.0834V4.03268H9.00339Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M8.13672 8.51146C8.13672 8.27213 8.33073 8.07812 8.57005 8.07812H11.5167C11.756 8.07812 11.9501 8.27213 11.9501 8.51146V11.4581C11.9501 11.6974 11.756 11.8915 11.5167 11.8915H8.57005C8.33073 11.8915 8.13672 11.6974 8.13672 11.4581V8.51146ZM9.00339 8.94479V11.0248H11.0834V8.94479H9.00339Z\" fill=\"inherit\"/>\n</svg>\n";

var u1146 = "<svg viewBox=\"0 0 15 12\" fill=\"black\" xmlns=\"http://www.w3.org/2000/svg\">\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2 4.45081C2 3.62394 2.69242 3 3.50281 3C4.27653 3 5.00562 3.53584 5.00562 4.39617C5.00562 5.22304 4.3132 5.84698 3.50281 5.84698C2.80424 5.84698 2 5.32631 2 4.45081ZM3.50281 3.93452C3.16259 3.93452 2.93452 4.18485 2.93452 4.45081C2.93452 4.66815 3.16583 4.91246 3.50281 4.91246C3.84303 4.91246 4.0711 4.66214 4.0711 4.39617C4.0711 4.16367 3.8797 3.93452 3.50281 3.93452Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M7 3.45C7 3.20147 7.20147 3 7.45 3H11.5913C11.8398 3 12.0413 3.20147 12.0413 3.45C12.0413 3.69853 11.8398 3.9 11.5913 3.9H7.45C7.20147 3.9 7 3.69853 7 3.45Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M7 5.25078C7 5.00225 7.20147 4.80078 7.45 4.80078H11.5913C11.8398 4.80078 12.0413 5.00225 12.0413 5.25078C12.0413 5.49931 11.8398 5.70078 11.5913 5.70078H7.45C7.20147 5.70078 7 5.49931 7 5.25078Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M13.2066 6.15027C13.3817 6.33986 13.3699 6.63548 13.1803 6.81055L11.1092 8.72301C11.0733 8.75616 11.0324 8.78347 10.9881 8.80395C10.9706 8.812 10.9541 8.82063 10.93 8.83342C10.9282 8.83443 10.9261 8.83551 10.924 8.83666C10.903 8.84789 10.87 8.86552 10.8358 8.88129C10.7455 8.92296 10.6326 8.95948 10.4876 8.95948C10.2456 8.95948 10.0113 8.85713 9.86606 8.72301L8.88009 7.81256C8.86722 7.80589 8.85576 7.7998 8.84596 7.79458C8.84105 7.79196 8.8367 7.78965 8.83282 7.78759L6.78426 9.67924C6.59466 9.85431 6.29904 9.84254 6.12397 9.65295C5.9489 9.46336 5.96068 9.16774 6.15027 8.99267L8.22137 7.0802C8.36661 6.94609 8.60093 6.84374 8.84293 6.84374C8.98787 6.84374 9.10085 6.88026 9.19109 6.92192C9.22526 6.9377 9.25827 6.95533 9.27928 6.96656C9.28144 6.96771 9.28346 6.96879 9.28535 6.96979C9.30936 6.98259 9.32594 6.99122 9.34337 6.99927C9.38773 7.01975 9.42861 7.04706 9.4645 7.0802L10.4775 8.01563C10.4814 8.01357 10.4857 8.01126 10.4907 8.00864C10.5005 8.00342 10.5119 7.99732 10.5248 7.99066L12.5463 6.12397C12.7359 5.9489 13.0315 5.96068 13.2066 6.15027Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M13.8 1H1.2C1.08954 1 1 1.08954 1 1.2V10.8C1 10.9105 1.08954 11 1.2 11H13.8C13.9105 11 14 10.9105 14 10.8V1.2C14 1.08954 13.9105 1 13.8 1ZM1.2 0C0.537258 0 0 0.537258 0 1.2V10.8C0 11.4627 0.537258 12 1.2 12H13.8C14.4627 12 15 11.4627 15 10.8V1.2C15 0.537258 14.4627 0 13.8 0H1.2Z\" fill=\"inherit\"/>\n</svg>\n";

var u1147 = "<svg fill=\"black\" xmlns=\"http://www.w3.org/2000/svg\">\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.92086 1.43071C1.70007 1.43071 1.48823 1.64074 1.48823 1.86718V1.86937H1.48822L1.43071 13.1338C1.43071 13.1341 1.43071 13.1344 1.43071 13.1347C1.43126 13.3608 1.64284 13.5703 1.86334 13.5703H13.1377C13.3585 13.5703 13.5703 13.3603 13.5703 13.1338V1.86718C13.5703 1.64074 13.3585 1.43071 13.1377 1.43071H1.92086ZM0.627835 1.86596C0.628524 1.16847 1.2217 0.570312 1.92086 0.570312H13.1377C13.8372 0.570312 14.4307 1.16916 14.4307 1.86718V13.1338C14.4307 13.8319 13.8372 14.4307 13.1377 14.4307H1.86334C1.16378 14.4307 0.570312 13.8319 0.570312 13.1338L0.570318 13.1316L0.627835 1.86718C0.627835 1.86677 0.627835 1.86636 0.627835 1.86596Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.59961 2.99961C2.59961 2.7787 2.7787 2.59961 2.99961 2.59961H11.9996C12.2205 2.59961 12.3996 2.7787 12.3996 2.99961V4.59961C12.3996 4.82052 12.2205 4.99961 11.9996 4.99961H2.99961C2.7787 4.99961 2.59961 4.82052 2.59961 4.59961V2.99961ZM3.39961 3.39961V4.19961H11.5996V3.39961H3.39961Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.59961 6.59922C2.59961 6.3783 2.7787 6.19922 2.99961 6.19922H11.9996C12.2205 6.19922 12.3996 6.3783 12.3996 6.59922V8.19922C12.3996 8.42013 12.2205 8.59922 11.9996 8.59922H2.99961C2.7787 8.59922 2.59961 8.42013 2.59961 8.19922V6.59922ZM3.39961 6.99922V7.79922H11.5996V6.99922H3.39961Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M2.59961 10.1988C2.59961 9.97791 2.7787 9.79883 2.99961 9.79883H11.9996C12.2205 9.79883 12.3996 9.97791 12.3996 10.1988V11.7988C12.3996 12.0197 12.2205 12.1988 11.9996 12.1988H2.99961C2.7787 12.1988 2.59961 12.0197 2.59961 11.7988V10.1988ZM3.39961 10.5988V11.3988H11.5996V10.5988H3.39961Z\" fill=\"inherit\"/>\n</svg>\n";

var u1148 = "<svg viewBox=\"0 0 13 15\" fill=\"black\" xmlns=\"http://www.w3.org/2000/svg\">\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M5 3.45081C5 2.62394 5.69242 2 6.50281 2C7.27653 2 8.00562 2.53584 8.00562 3.39617C8.00562 4.22304 7.3132 4.84698 6.50281 4.84698C5.80424 4.84698 5 4.32631 5 3.45081ZM6.50281 2.93452C6.16259 2.93452 5.93452 3.18485 5.93452 3.45081C5.93452 3.66815 6.16583 3.91246 6.50281 3.91246C6.84303 3.91246 7.0711 3.66214 7.0711 3.39617C7.0711 3.16367 6.8797 2.93452 6.50281 2.93452Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M4 6.29766C4 6.04913 4.20147 5.84766 4.45 5.84766H8.59132C8.83985 5.84766 9.04132 6.04913 9.04132 6.29766C9.04132 6.54618 8.83985 6.74766 8.59132 6.74766H4.45C4.20147 6.74766 4 6.54618 4 6.29766Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M4 8.09844C4 7.84991 4.20147 7.64844 4.45 7.64844H8.59132C8.83985 7.64844 9.04132 7.84991 9.04132 8.09844C9.04132 8.34697 8.83985 8.54844 8.59132 8.54844H4.45C4.20147 8.54844 4 8.34697 4 8.09844Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10.2066 9.69714C10.3817 9.88674 10.3699 10.1824 10.1803 10.3574L8.1092 12.2699C8.0733 12.303 8.03243 12.3303 7.98807 12.3508C7.97063 12.3589 7.95406 12.3675 7.93004 12.3803C7.92816 12.3813 7.92613 12.3824 7.92398 12.3835C7.90296 12.3948 7.86996 12.4124 7.83578 12.4282C7.74555 12.4698 7.63256 12.5064 7.48763 12.5064C7.24563 12.5064 7.01131 12.404 6.86606 12.2699L5.88009 11.3594C5.86722 11.3528 5.85576 11.3467 5.84596 11.3415C5.84105 11.3388 5.8367 11.3365 5.83282 11.3345L3.78426 13.2261C3.59466 13.4012 3.29904 13.3894 3.12397 13.1998C2.9489 13.0102 2.96068 12.7146 3.15027 12.5395L5.22137 10.6271C5.36661 10.493 5.60093 10.3906 5.84293 10.3906C5.98787 10.3906 6.10085 10.4271 6.19109 10.4688C6.22526 10.4846 6.25827 10.5022 6.27928 10.5134C6.28144 10.5146 6.28346 10.5157 6.28535 10.5167C6.30936 10.5295 6.32594 10.5381 6.34337 10.5461C6.38773 10.5666 6.42861 10.5939 6.4645 10.6271L7.47752 11.5625C7.4814 11.5604 7.48575 11.5581 7.49066 11.5555C7.50045 11.5503 7.51192 11.5442 7.52479 11.5375L9.54631 9.67085C9.7359 9.49578 10.0315 9.50755 10.2066 9.69714Z\" fill=\"inherit\"/>\n<path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.7419 0.9375H1.25806C1.14226 0.9375 1.04839 1.02145 1.04839 1.125V13.875C1.04839 13.9786 1.14226 14.0625 1.25806 14.0625H11.7419C11.8577 14.0625 11.9516 13.9786 11.9516 13.875V1.125C11.9516 1.02145 11.8577 0.9375 11.7419 0.9375ZM1.25806 0C0.563255 0 0 0.503679 0 1.125V13.875C0 14.4963 0.563255 15 1.25806 15H11.7419C12.4367 15 13 14.4963 13 13.875V1.125C13 0.50368 12.4367 0 11.7419 0H1.25806Z\" fill=\"inherit\"/>\n</svg>\n";

var u1149 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 16 19\">\n    <g transform=\"translate(.5)\">\n        <circle cx=\"2.67\" cy=\"2.67\" r=\"2.67\"/>\n        <path d=\"M13.42 18.08V3.42H3.06v-1.5h11.86v16.16z\"/>\n        <path d=\"M1.92 18.08V2.67h1.5v15.41z\"/>\n    </g>\n</svg>";

var u1150 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 16 19\">\n    <g transform=\"matrix(-1 0 0 1 15.5 0)\">\n        <circle cx=\"2.67\" cy=\"2.67\" r=\"2.67\"/>\n        <path d=\"M13.42 18.08V3.42H3.06v-1.5h11.86v16.16z\"/>\n        <path d=\"M1.92 18.08V2.67h1.5v15.41z\"/>\n    </g>\n</svg>";

var u1151 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 16 19\">\n  <g transform=\"translate(2.5)\">\n    <circle cx=\"6.67\" cy=\"2.67\" r=\"2.67\"/>\n    <path d=\"M11.5 18.16V3.5H0V2h13v16.16z\"/>\n    <path d=\"M0 18.16V2.75h1.5v15.41z\"/>\n  </g>\n</svg>";

var u1152 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 28.5 20\">\n    <circle cx=\"14.17\" cy=\"2.67\" r=\"2.67\" />\n    <circle cx=\"25.83\" cy=\"17.33\" r=\"2.67\" />\n    <rect x=\"19.25\" y=\"-1.21\" width=\"1.5\" height=\"22.42\" transform=\"translate(-1.79 15.03) rotate(-39.57)\" />\n    <circle cx=\"2.67\" cy=\"17.33\" r=\"2.67\" />\n    <rect x=\"-2.71\" y=\"9.25\" width=\"22.42\" height=\"1.5\" transform=\"translate(-4.62 10.18) rotate(-50.44)\" />\n</svg>";

var u1153 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 28.34 20\">\n    <circle cx=\"14.17\" cy=\"2.67\" r=\"2.67\" />\n    <circle cx=\"2.67\" cy=\"17.33\" r=\"2.67\" />\n    <path d=\"M3.42,17.33H1.92c0-6.46,4.39-15.41,12.64-15.41v1.5C7.29,3.42,3.42,11.5,3.42,17.33Z\" />\n    <circle cx=\"25.67\" cy=\"17.33\" r=\"2.67\" />\n    <path d=\"M26.42,17.33h-1.5c0-5.83-3.87-13.91-11.14-13.91V1.92C22,1.92,26.42,10.87,26.42,17.33Z\" />\n</svg>";

var u1154 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 28.34 20\">\n    <circle cx=\"14.17\" cy=\"2.67\" r=\"2.67\" />\n    <circle cx=\"25.67\" cy=\"17.33\" r=\"2.67\" />\n    <circle cx=\"2.67\" cy=\"17.33\" r=\"2.67\" />\n    <polygon points=\"26.42 17.33 24.92 17.33 24.92 3.42 14.56 3.42 14.56 1.92 26.42 1.92 26.42 17.33\" />\n    <polygon points=\"14.92 18.08 2.67 18.08 2.67 16.58 13.42 16.58 13.42 2.67 14.92 2.67 14.92 18.08\" />\n</svg>";

var u1155 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 28.34 20\">\n    <circle cx=\"14.17\" cy=\"2.67\" r=\"2.67\" />\n    <circle cx=\"2.67\" cy=\"17.33\" r=\"2.67\" />\n    <circle cx=\"25.67\" cy=\"17.33\" r=\"2.67\" />\n    <polygon points=\"3.42 17.33 1.92 17.33 1.92 1.92 13.78 1.92 13.78 3.42 3.42 3.42 3.42 17.33\" />\n    <polygon points=\"25.67 18.08 13.42 18.08 13.42 2.67 14.92 2.67 14.92 16.58 25.67 16.58 25.67 18.08\" />\n</svg>";

var u1156 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 16 16\">\n    <path fillRule=\"evenodd\" clipRule=\"evenodd\" d=\"M2.36906 14.2144H8.68657C8.89601 14.2144 9.09687 14.2976 9.24496 14.4457C9.39306 14.5938 9.47626 14.7946 9.47626 15.0041C9.47626 15.2135 9.39306 15.4144 9.24496 15.5625C9.09687 15.7106 8.89601 15.7938 8.68657 15.7938H2.36906C1.74075 15.7938 1.13817 15.5442 0.693883 15.0999C0.249597 14.6556 0 14.053 0 13.4247V2.36906C0 1.74075 0.249597 1.13817 0.693883 0.693883C1.13817 0.249597 1.74075 0 2.36906 0H7.15457L7.37569 0.0789687H7.44676C7.52795 0.116938 7.60259 0.167585 7.66787 0.229009L12.406 4.96714C12.5156 5.07819 12.5898 5.2192 12.6193 5.37239C12.6488 5.52559 12.6323 5.68409 12.5718 5.8279C12.5126 5.97211 12.412 6.09556 12.2827 6.18269C12.1534 6.26982 12.0012 6.31673 11.8453 6.3175H8.68657C8.05825 6.3175 7.45567 6.06791 7.01139 5.62362C6.5671 5.17934 6.3175 4.57675 6.3175 3.94844V1.57938H2.36906C2.15963 1.57938 1.95877 1.66258 1.81067 1.81067C1.66258 1.95877 1.57938 2.15963 1.57938 2.36906V13.4247C1.57938 13.6341 1.66258 13.835 1.81067 13.9831C1.95877 14.1312 2.15963 14.2144 2.36906 14.2144ZM9.94217 4.73813L7.89688 2.69284V3.94844C7.89688 4.15788 7.98008 4.35874 8.12817 4.50683C8.27627 4.65493 8.47713 4.73813 8.68657 4.73813H9.94217ZM3.34761 12.2739C3.31241 12.1914 3.29137 12.1041 3.2854 12.0158L3.2854 8.36528C3.28184 8.18607 3.34961 8.01561 3.47382 7.89141C3.59802 7.76721 3.76848 7.69943 3.94769 7.70299C4.1269 7.70655 4.30019 7.78116 4.42943 7.9104C4.55867 8.03964 4.63327 8.21293 4.63683 8.39214L4.63684 11.2969L5.92266 11.2969C6.01149 11.2983 6.12471 11.3282 6.20753 11.3636C6.27155 11.391 6.31643 11.4391 6.3631 11.4892L6.36311 11.4892C6.37681 11.5039 6.39066 11.5187 6.4052 11.5332C6.46926 11.5973 6.52051 11.6729 6.55597 11.7557C6.59143 11.8386 6.61041 11.9269 6.61181 12.0158C6.61394 12.1046 6.59846 12.1923 6.56626 12.2738C6.53407 12.3553 6.48579 12.4289 6.42422 12.4905C6.36265 12.552 6.289 12.6003 6.20753 12.6325C6.12605 12.6647 6.01151 12.707 5.92266 12.7049H3.97454C3.8858 12.7025 3.79782 12.6813 3.71644 12.6427C3.55164 12.5712 3.41911 12.4387 3.34761 12.2739ZM8.70634 12.793C9.98203 12.793 11.0162 11.6439 11.0162 10.2265C11.0162 8.80904 9.98203 7.65998 8.70634 7.65998C7.43065 7.65998 6.3965 8.80904 6.3965 10.2265C6.3965 11.6439 7.43065 12.793 8.70634 12.793ZM8.73597 11.5453C9.37381 11.5453 9.89089 10.9407 9.89089 10.1949C9.89089 9.44911 9.37381 8.84453 8.73597 8.84453C8.09813 8.84453 7.58105 9.44911 7.58105 10.1949C7.58105 10.9407 8.09813 11.5453 8.73597 11.5453ZM11.3715 10.2265C11.3715 8.80904 12.4056 7.65998 13.6813 7.65998C14.1833 7.65998 14.7779 7.9067 15.0267 8.14005C15.1561 8.2614 15.3112 8.44705 15.3397 8.63063C15.366 8.80006 15.2757 8.96772 15.162 9.08144C15.0708 9.17262 14.938 9.2579 14.8066 9.25912C14.5968 9.26106 14.3907 9.13001 14.3646 9.08144C14.1787 8.93199 13.9535 8.84451 13.7109 8.84451C13.0731 8.84451 12.556 9.44909 12.556 10.1949C12.556 10.9407 13.0731 11.5452 13.7109 11.5452C14.0485 11.5452 14.3522 11.3759 14.5634 11.106L14.6882 10.8582H14.2144C14.1414 10.8571 14.0483 10.8326 13.9802 10.8034C13.9276 10.7809 13.8907 10.7413 13.8523 10.7002C13.8411 10.6882 13.8297 10.676 13.8177 10.664C13.7651 10.6113 13.723 10.5492 13.6938 10.4811C13.6647 10.413 13.6491 10.3404 13.6479 10.2674C13.6462 10.1943 13.6589 10.1222 13.6853 10.0553C13.7118 9.9883 13.7515 9.92777 13.8021 9.87716C13.8527 9.82654 13.9132 9.78686 13.9802 9.7604C14.0472 9.73393 14.1414 9.69913 14.2144 9.70088H15.4247C15.4977 9.70283 15.57 9.72026 15.6369 9.75202C15.7723 9.8108 15.8813 9.91973 15.94 10.0552C15.94 10.0552 15.9629 10.1198 15.9912 10.266C16.0154 10.3912 15.9852 10.5411 15.9549 10.6909C15.9499 10.7159 15.9448 10.741 15.94 10.7659C15.717 11.9243 14.7905 12.793 13.6813 12.793C12.4056 12.793 11.3715 11.6439 11.3715 10.2265Z\" />\n</svg>";

var u1157 = "<svg xmlns=\"http://www.w3.org/2000/svg\" xml:space=\"preserve\" style=\"fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2\" viewBox=\"0 0 24 24\"><path d=\"M21 2H3c-.549 0-1 .451-1 1v18c0 .549.451 1 1 1h18c.549 0 1-.451 1-1V3c0-.549-.451-1-1-1ZM8 20H4V4h4v16Zm12 0H10V4h10v16Z\" style=\"fill-rule:nonzero\"/><path d=\"M 14.4 12 L 17.9 8.5 C 18.3 8.1 18.3 7.5 17.9 7.1 C 17.5 6.7 16.9 6.7 16.5 7.1 L 12.3 11.3 C 11.9 11.7 11.9 12.3 12.3 12.7 L 16.5 16.9 C 16.7 17.1 16.9 17.2 17.2 17.2 C 17.5 17.2 17.7 17.1 17.9 16.9 C 18.3 16.5 18.3 15.9 17.9 15.5 L 14.4 12 Z\" style=\"fill-rule:nonzero\" transform=\"matrix(-1, 0, 0, -1, 30.199999, 24.000001)\"/></svg>";

var u1158 = "<svg xmlns=\"http://www.w3.org/2000/svg\" xml:space=\"preserve\" style=\"fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2\" viewBox=\"0 0 24 24\"><path d=\"M21 2H3c-.549 0-1 .451-1 1v18c0 .549.451 1 1 1h18c.549 0 1-.451 1-1V3c0-.549-.451-1-1-1Zm-7 18H4V4h10v16Zm6 0h-4V4h4v16Z\" style=\"fill-rule:nonzero\"/><path d=\"m11.3 12 3.5-3.5c.4-.4.4-1 0-1.4-.4-.4-1-.4-1.4 0l-4.2 4.2c-.4.4-.4 1 0 1.4l4.2 4.2c.2.2.4.3.7.3.3 0 .5-.1.7-.3.4-.4.4-1 0-1.4L11.3 12Z\" style=\"fill-rule:nonzero\" transform=\"rotate(-180 10.55 12)\"/></svg>";

var u1159 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M17.56 21.56a1 1 0 01-.46-.12L12 18.76l-5.1 2.68a1 1 0 01-1.45-1.05l.98-5.68L2.3 10.7a1 1 0 01.56-1.71l5.7-.83L11.1 3a1.04 1.04 0 011.8 0l2.55 5.16 5.7.83a1 1 0 01.55 1.7l-4.13 4.02.98 5.68a1 1 0 01-.99 1.17z\"/></svg>";

var u1160 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 85.12 92.46\"><defs><linearGradient id=\"a\" gradientUnits=\"userSpaceOnUse\" x1=\"42.56\" y1=\"113.26\" x2=\"42.56\" y2=\"28.78\"><stop offset=\"0\" stop-color=\"#FFF200\"/><stop offset=\"1\" stop-color=\"#F15A29\"/></linearGradient></defs><path fill=\"url(#a)\" d=\"M85.01 40.8a33.05 33.05 0 00-3.32-11.69 34.33 34.33 0 00-6.89-9.42c1.3-5.17-1.59-9.65-1.59-9.65-4.98-.31-8.14 1.54-9.31 2.39l-.59-.25a39.35 39.35 0 00-8.21-2.26l-.51-.07C52.41 2.9 46.18 0 46.18 0c-6.95 4.41-8.27 10.57-8.27 10.57l-.07.36-1.15.34c-.53.16-1.06.36-1.59.55-.53.21-1.06.41-1.58.64a31.81 31.81 0 00-6 3.35l-.24-.11c-9.62-3.68-18.17.75-18.17.75-.78 10.24 3.84 16.68 4.76 17.86a44.72 44.72 0 00-2.34 10.15C2.63 48.84 0 57.84 0 57.84c7.42 8.53 16.07 9.06 16.07 9.06l.02-.02a38.29 38.29 0 005.68 7.68c-2.71 7.74.38 14.18.38 14.18a23.03 23.03 0 0014.83-4.52 37.7 37.7 0 0012.19 1.93h.31l.21-.01.41-.01.4-.02.01.01c3.89 5.55 10.74 6.34 10.74 6.34 4.87-5.13 5.15-10.22 5.15-11.33v-.07-.15l-.01-.23a30.34 30.34 0 008.37-8.86c5.51.32 9.39-3.41 9.39-3.41-.91-5.74-4.18-8.54-4.87-9.07l-.07-.05a.61.61 0 01-.06-.05l-.12-.08.08-1.04c.04-.62.06-1.24.06-1.85v-.81-.16l-.02-.38-.03-.52a7.25 7.25 0 00-.09-.98l-.06-.48-.07-.47a23.94 23.94 0 00-7.83-14.37 23.17 23.17 0 00-15.69-5.81l-.41.01H54.73l-.17.01-.4.03-.45.04a18.4 18.4 0 00-12.4 6.49 18.02 18.02 0 00-4.14 10.35 14.54 14.54 0 00-.02 1.65l.01.35.05.63a13.93 13.93 0 005.97 10.16 13.6 13.6 0 003.76 1.79c1.27.38 2.54.54 3.74.53l.44-.01.24-.01.24-.01.38-.04.11-.01.12-.02.23-.03.43-.08.42-.09a10.46 10.46 0 002.26-.83c.45-.23.87-.5 1.26-.77l.33-.25a.96.96 0 00.15-1.35.94.94 0 00-1.19-.23l-.3.16c-.35.17-.71.32-1.09.45a9.54 9.54 0 01-1.83.37l-.32.02-.32.01-.31-.01-.39-.02h-.05l-.09.02-.17-.02-.35-.04a9.98 9.98 0 01-5.36-2.51 9.71 9.71 0 01-3.21-7.39l.02-.47v-.09l.01-.12.02-.23a12.18 12.18 0 016.94-9.8 12.02 12.02 0 014.87-1.07h.23l.27.01.17.01h.1l.27.02a15.57 15.57 0 016.3 1.89 15.18 15.18 0 016.17 6.4 14.52 14.52 0 011.53 5.45l.02.29.01.29.01.29v.52l-.01.28-.03.67a24.8 24.8 0 01-.31 2.46 19.65 19.65 0 01-11.12 14.22 19.46 19.46 0 01-7.28 1.72l-.15.01h-1.02-.09a25.45 25.45 0 01-6.61-1.02 26.1 26.1 0 01-18.72-23.19l-.02-.32-.01-.08V49.57l-.01-.28v-.37l-.01-.4v-.08-.19l.01-.63a29.56 29.56 0 01.65-5.24 34.3 34.3 0 012.46-7.51 27.12 27.12 0 015.61-8.09 22.83 22.83 0 015.69-4.12c.34-.19.7-.35 1.05-.52l.53-.24.54-.23c.72-.3 1.46-.56 2.21-.8l.56-.17.57-.16c.38-.11.76-.2 1.14-.29l.58-.13.58-.12.58-.11.29-.05.29-.04.59-.09.66-.09.65-.08.41-.04.28-.03.14-.01.16-.01.66-.04.33-.02H51.17l.14-.01.56-.03a30.82 30.82 0 016.58.48 30.5 30.5 0 017.89 2.62 31.8 31.8 0 016.44 4.2l.35.3.34.3.66.61.64.62.61.63a33.4 33.4 0 015.43 7.62l.16.3.15.3.29.6c.09.2.19.39.27.59l.25.58a34.09 34.09 0 011.73 5.16c.09.35.42.58.78.55a.72.72 0 00.66-.71c.04-.95.01-2.05-.09-3.3z\"/></svg>";

var u1161 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12 20.86a2.75 2.75 0 01-1.95-.8l-6.21-6.22A6.27 6.27 0 0112 4.36a6.27 6.27 0 018.16 9.48l-6.21 6.22a2.75 2.75 0 01-1.95.8z\"/></svg>";

var u1162 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M18.17 1.85A6.25 6.25 0 0012.12.23l-2.7 6.33 2.83.71a1 1 0 01.67 1.41l-2 4a1 1 0 01-.9.56 1.13 1.13 0 01-.44-.1 1 1 0 01-.46-1.33l1.4-2.89-2.77-.7a1 1 0 01-.65-.53 1 1 0 010-.83L9.58 1a6.27 6.27 0 00-7.73 9.77l7.45 7.41a1 1 0 001.42 0l7.45-7.46a6.27 6.27 0 000-8.87z\"/></svg>";

var u1163 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 117.8 64\"><linearGradient id=\"a\" gradientUnits=\"userSpaceOnUse\" x1=\"96.44\" y1=\"83.7\" x2=\"96.44\" y2=\"-9.48\"><stop offset=\"0\" stop-color=\"#FFF23A\"/><stop offset=\".04\" stop-color=\"#FEE62D\"/><stop offset=\".12\" stop-color=\"#FED41A\"/><stop offset=\".2\" stop-color=\"#FDC90F\"/><stop offset=\".28\" stop-color=\"#FDC60B\"/><stop offset=\".67\" stop-color=\"#F28F3F\"/><stop offset=\".89\" stop-color=\"#ED693C\"/><stop offset=\"1\" stop-color=\"#E83E39\"/></linearGradient><path d=\"M15.2 22.7H1.9c-1.1 0-1.9.9-1.9 1.9v37.5C0 63.2.9 64 1.9 64h13.3c1.1 0 1.9-.9 1.9-1.9V24.6c0-1.1-.8-1.9-1.9-1.9zM36.3 10.2H23c-1.1 0-1.9.9-1.9 1.9v50c0 1.1.9 1.9 1.9 1.9h13.3c1.1 0 1.9-.9 1.9-1.9v-50c0-1-.9-1.9-1.9-1.9zM57.3 32H44c-1.1 0-1.9.9-1.9 1.9V62c0 1.1.9 1.9 1.9 1.9h13.3c1.1 0 1.9-.9 1.9-1.9V34c0-1.1-.8-2-1.9-2zM70.1 38V26.1c0-3.4 2.7-6.1 6.1-6.1h4.1V2c0-1.1-.9-1.9-1.9-1.9H65.1c-1.1-.1-2 .8-2 1.9v60.1c0 1.1.9 1.9 1.9 1.9h13.3c1.1 0 1.9-.9 1.9-1.9v-18h-4.1c-3.2 0-6-2.8-6-6.1z\"/><path fill=\"url(#a)\" d=\"M116.7 24.9H103.6V11.8c0-.6-.5-1.1-1.1-1.1h-12c-.6 0-1.1.5-1.1 1.1v13.1H76.2c-.6 0-1.1.5-1.1 1.1v12c0 .6.5 1.1 1.1 1.1h13.2v13.2c0 .6.5 1.1 1.1 1.1h11.9c.6 0 1.1-.5 1.1-1.1V39.1h13.1c.6 0 1.1-.5 1.1-1.1V26.1c.1-.6-.4-1.2-1-1.2z\"/></svg>";

var u1164 = "<svg xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M14.3 8.7H9.4a.7.7 0 00-.7.7v4.9a.7.7 0 00.7.7h4.9a.7.7 0 00.7-.7V9.4a.7.7 0 00-.7-.7zm-.7 4.9h-3.5v-3.5h3.5v3.5zM6.6 1H1.7a.7.7 0 00-.7.7v4.9a.7.7 0 00.7.7h4.9a.7.7 0 00.7-.7V1.7a.7.7 0 00-.7-.7zm-.7 4.9H2.4V2.4h3.5v3.5zm8 1.08a.42.42 0 01-.12-.08l-1.63-1.5a.31.31 0 01-.08-.22c0-.08.04-.16.1-.22.06-.06.14-.09.23-.1.09 0 .18.03.24.09l1.03.94V3.62c0-.26-.12-.5-.31-.69a1.1 1.1 0 00-.74-.28H9.35a.36.36 0 01-.25-.1.31.31 0 01-.1-.23c0-.08.04-.16.1-.22.07-.07.16-.1.25-.1h3.28c.46 0 .9.17 1.24.48.33.3.51.71.51 1.14V5.9l1.02-.94a.37.37 0 01.5 0c.03.03.06.06.07.1a.31.31 0 01-.08.35l-1.61 1.5a.35.35 0 01-.12.08.38.38 0 01-.26 0zM2.1 9.02l.12.08 1.63 1.5c.06.06.09.14.08.22 0 .08-.04.16-.1.22a.37.37 0 01-.48.02l-1.02-.95v2.27c0 .26.12.5.31.69.2.18.47.28.74.28h3.27c.1 0 .18.04.25.1.06.06.1.14.1.23s-.04.16-.1.22a.36.36 0 01-.25.1H3.37c-.46 0-.9-.17-1.24-.48s-.5-.71-.5-1.14V10.1l-1.03.94a.37.37 0 01-.5 0 .32.32 0 01-.07-.1.31.31 0 01.08-.35l1.61-1.5a.35.35 0 01.12-.08.38.38 0 01.26 0z\" fill=\"currentColor\"/></svg>";

var u1165 = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24 24\"><path d=\"M12,2A10,10,0,1,0,22,12,10,10,0,0,0,12,2Zm0,18a8,8,0,1,1,8-8A8,8,0,0,1,12,20ZM12,6a6,6,0,1,0,6,6A6,6,0,0,0,12,6Zm0,10a4,4,0,1,1,4-4A4,4,0,0,1,12,16Z\"/></svg>";

let cacheInitialized = false;
let iconRoot = "public/img/icons/";
function cacheItem(content, path) {
  SVG.cacheStore[iconRoot + path] = { content, status: "loaded" };
}
function initIconCache() {
  cacheInitialized = true;
  const grafanaPublicPath = typeof window !== "undefined" && window.__grafana_public_path__;
  if (grafanaPublicPath) {
    iconRoot = grafanaPublicPath + "img/icons/";
  }
  cacheItem(u1000, "unicons/at.svg");
  cacheItem(u1001, "unicons/adjust-circle.svg");
  cacheItem(u1002, "unicons/angle-double-down.svg");
  cacheItem(u1003, "unicons/angle-double-right.svg");
  cacheItem(u1004, "unicons/angle-down.svg");
  cacheItem(u1005, "unicons/angle-left.svg");
  cacheItem(u1006, "unicons/angle-right.svg");
  cacheItem(u1007, "unicons/angle-up.svg");
  cacheItem(u1008, "unicons/apps.svg");
  cacheItem(u1009, "unicons/arrow.svg");
  cacheItem(u1010, "unicons/arrow-down.svg");
  cacheItem(u1011, "unicons/arrow-from-right.svg");
  cacheItem(u1012, "unicons/arrow-left.svg");
  cacheItem(u1013, "unicons/arrow-random.svg");
  cacheItem(u1014, "unicons/arrow-right.svg");
  cacheItem(u1015, "unicons/arrow-to-right.svg");
  cacheItem(u1016, "unicons/arrow-up.svg");
  cacheItem(u1017, "unicons/arrows-h.svg");
  cacheItem(u1018, "unicons/backward.svg");
  cacheItem(u1019, "unicons/bars.svg");
  cacheItem(u1020, "unicons/bell.svg");
  cacheItem(u1021, "unicons/bell-slash.svg");
  cacheItem(u1022, "unicons/bolt.svg");
  cacheItem(u1023, "unicons/book.svg");
  cacheItem(u1024, "unicons/book-open.svg");
  cacheItem(u1025, "unicons/brackets-curly.svg");
  cacheItem(u1026, "unicons/bug.svg");
  cacheItem(u1027, "unicons/building.svg");
  cacheItem(u1028, "unicons/calculator-alt.svg");
  cacheItem(u1029, "unicons/calendar-alt.svg");
  cacheItem(u1030, "unicons/calendar-slash.svg");
  cacheItem(u1031, "unicons/camera.svg");
  cacheItem(u1032, "unicons/channel-add.svg");
  cacheItem(u1033, "unicons/chart-line.svg");
  cacheItem(u1034, "unicons/check.svg");
  cacheItem(u1035, "unicons/check-circle.svg");
  cacheItem(u1036, "unicons/circle.svg");
  cacheItem(u1037, "unicons/clipboard-alt.svg");
  cacheItem(u1038, "unicons/clock-nine.svg");
  cacheItem(u1039, "unicons/cloud.svg");
  cacheItem(u1040, "unicons/cloud-download.svg");
  cacheItem(u1041, "unicons/code-branch.svg");
  cacheItem(u1042, "unicons/cog.svg");
  cacheItem(u1043, "unicons/columns.svg");
  cacheItem(u1044, "unicons/comment-alt.svg");
  cacheItem(u1045, "unicons/comment-alt-share.svg");
  cacheItem(u1046, "unicons/comments-alt.svg");
  cacheItem(u1047, "unicons/compass.svg");
  cacheItem(u1048, "unicons/copy.svg");
  cacheItem(u1049, "unicons/corner-down-right-alt.svg");
  cacheItem(u1050, "unicons/cube.svg");
  cacheItem(u1051, "unicons/dashboard.svg");
  cacheItem(u1052, "unicons/database.svg");
  cacheItem(u1053, "unicons/document-info.svg");
  cacheItem(u1054, "unicons/download-alt.svg");
  cacheItem(u1055, "unicons/draggabledots.svg");
  cacheItem(u1056, "unicons/edit.svg");
  cacheItem(u1057, "unicons/ellipsis-v.svg");
  cacheItem(u1058, "unicons/ellipsis-h.svg");
  cacheItem(u1059, "unicons/envelope.svg");
  cacheItem(u1060, "unicons/exchange-alt.svg");
  cacheItem(u1061, "unicons/exclamation-triangle.svg");
  cacheItem(u1062, "unicons/external-link-alt.svg");
  cacheItem(u1063, "unicons/eye.svg");
  cacheItem(u1064, "unicons/eye-slash.svg");
  cacheItem(u1065, "unicons/file-alt.svg");
  cacheItem(u1066, "unicons/file-blank.svg");
  cacheItem(u1067, "unicons/filter.svg");
  cacheItem(u1068, "unicons/folder.svg");
  cacheItem(u1069, "unicons/folder-open.svg");
  cacheItem(u1070, "unicons/folder-plus.svg");
  cacheItem(u1071, "unicons/folder-upload.svg");
  cacheItem(u1072, "unicons/forward.svg");
  cacheItem(u1073, "unicons/graph-bar.svg");
  cacheItem(u1074, "unicons/history.svg");
  cacheItem(u1075, "unicons/home-alt.svg");
  cacheItem(u1076, "unicons/import.svg");
  cacheItem(u1077, "unicons/info.svg");
  cacheItem(u1078, "unicons/info-circle.svg");
  cacheItem(u1079, "unicons/k6.svg");
  cacheItem(u1080, "unicons/key-skeleton-alt.svg");
  cacheItem(u1081, "unicons/keyboard.svg");
  cacheItem(u1082, "unicons/link.svg");
  cacheItem(u1083, "unicons/list-ul.svg");
  cacheItem(u1084, "unicons/lock.svg");
  cacheItem(u1085, "unicons/minus.svg");
  cacheItem(u1086, "unicons/minus-circle.svg");
  cacheItem(u1087, "unicons/mobile-android.svg");
  cacheItem(u1088, "unicons/monitor.svg");
  cacheItem(u1089, "unicons/pause.svg");
  cacheItem(u1090, "unicons/pen.svg");
  cacheItem(u1091, "unicons/play.svg");
  cacheItem(u1092, "unicons/plug.svg");
  cacheItem(u1093, "unicons/plus.svg");
  cacheItem(u1094, "unicons/plus-circle.svg");
  cacheItem(u1095, "unicons/power.svg");
  cacheItem(u1096, "unicons/presentation-play.svg");
  cacheItem(u1097, "unicons/process.svg");
  cacheItem(u1098, "unicons/question-circle.svg");
  cacheItem(u1099, "unicons/repeat.svg");
  cacheItem(u1100, "unicons/rocket.svg");
  cacheItem(u1101, "unicons/rss.svg");
  cacheItem(u1102, "unicons/save.svg");
  cacheItem(u1103, "unicons/search.svg");
  cacheItem(u1104, "unicons/search-minus.svg");
  cacheItem(u1105, "unicons/search-plus.svg");
  cacheItem(u1106, "unicons/share-alt.svg");
  cacheItem(u1107, "unicons/shield.svg");
  cacheItem(u1108, "unicons/signal.svg");
  cacheItem(u1109, "unicons/signin.svg");
  cacheItem(u1110, "unicons/signout.svg");
  cacheItem(u1111, "unicons/sitemap.svg");
  cacheItem(u1112, "unicons/slack.svg");
  cacheItem(u1113, "unicons/sliders-v-alt.svg");
  cacheItem(u1114, "unicons/sort-amount-down.svg");
  cacheItem(u1115, "unicons/sort-amount-up.svg");
  cacheItem(u1116, "unicons/square-shape.svg");
  cacheItem(u1117, "unicons/star.svg");
  cacheItem(u1118, "unicons/step-backward.svg");
  cacheItem(u1119, "unicons/sync.svg");
  cacheItem(u1120, "unicons/table.svg");
  cacheItem(u1121, "unicons/tag-alt.svg");
  cacheItem(u1122, "unicons/times.svg");
  cacheItem(u1123, "unicons/trash-alt.svg");
  cacheItem(u1124, "unicons/unlock.svg");
  cacheItem(u1125, "unicons/upload.svg");
  cacheItem(u1126, "unicons/user.svg");
  cacheItem(u1127, "unicons/users-alt.svg");
  cacheItem(u1128, "unicons/wrap-text.svg");
  cacheItem(u1129, "unicons/cloud-upload.svg");
  cacheItem(u1130, "unicons/credit-card.svg");
  cacheItem(u1131, "unicons/file-copy-alt.svg");
  cacheItem(u1132, "unicons/fire.svg");
  cacheItem(u1133, "unicons/hourglass.svg");
  cacheItem(u1134, "unicons/layer-group.svg");
  cacheItem(u1135, "unicons/layers-alt.svg");
  cacheItem(u1136, "unicons/line-alt.svg");
  cacheItem(u1137, "unicons/list-ui-alt.svg");
  cacheItem(u1138, "unicons/message.svg");
  cacheItem(u1139, "unicons/palette.svg");
  cacheItem(u1140, "unicons/percentage.svg");
  cacheItem(u1141, "unicons/shield-exclamation.svg");
  cacheItem(u1142, "unicons/plus-square.svg");
  cacheItem(u1143, "unicons/x.svg");
  cacheItem(u1144, "unicons/capture.svg");
  cacheItem(u1145, "custom/gf-grid.svg");
  cacheItem(u1146, "custom/gf-landscape.svg");
  cacheItem(u1147, "custom/gf-layout-simple.svg");
  cacheItem(u1148, "custom/gf-portrait.svg");
  cacheItem(u1149, "custom/gf-bar-alignment-after.svg");
  cacheItem(u1150, "custom/gf-bar-alignment-before.svg");
  cacheItem(u1151, "custom/gf-bar-alignment-center.svg");
  cacheItem(u1152, "custom/gf-interpolation-linear.svg");
  cacheItem(u1153, "custom/gf-interpolation-smooth.svg");
  cacheItem(u1154, "custom/gf-interpolation-step-after.svg");
  cacheItem(u1155, "custom/gf-interpolation-step-before.svg");
  cacheItem(u1156, "custom/gf-logs.svg");
  cacheItem(u1157, "custom/gf-movepane-left.svg");
  cacheItem(u1158, "custom/gf-movepane-right.svg");
  cacheItem(u1159, "mono/favorite.svg");
  cacheItem(u1160, "mono/grafana.svg");
  cacheItem(u1161, "mono/heart.svg");
  cacheItem(u1162, "mono/heart-break.svg");
  cacheItem(u1163, "mono/panel-add.svg");
  cacheItem(u1164, "mono/library-panel.svg");
  cacheItem(u1165, "unicons/record-audio.svg");
}

const alwaysMonoIcons = [
  "grafana",
  "favorite",
  "heart-break",
  "heart",
  "panel-add",
  "library-panel",
  "circle-mono"
];
function getIconSubDir(name, type) {
  if (name == null ? void 0 : name.startsWith("gf-")) {
    return "custom";
  } else if (alwaysMonoIcons.includes(name)) {
    return "mono";
  } else if (type === "default") {
    return "unicons";
  } else if (type === "solid") {
    return "solid";
  } else {
    return "mono";
  }
}
function getSvgSize(size) {
  switch (size) {
    case "xs":
      return 12;
    case "sm":
      return 14;
    case "md":
      return 16;
    case "lg":
      return 18;
    case "xl":
      return 24;
    case "xxl":
      return 36;
    case "xxxl":
      return 48;
  }
}

var __defProp$2A = Object.defineProperty;
var __defProps$1F = Object.defineProperties;
var __getOwnPropDescs$1F = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2C = Object.getOwnPropertySymbols;
var __hasOwnProp$2C = Object.prototype.hasOwnProperty;
var __propIsEnum$2C = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2A = (obj, key, value) => key in obj ? __defProp$2A(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2A = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2C.call(b, prop))
      __defNormalProp$2A(a, prop, b[prop]);
  if (__getOwnPropSymbols$2C)
    for (var prop of __getOwnPropSymbols$2C(b)) {
      if (__propIsEnum$2C.call(b, prop))
        __defNormalProp$2A(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1F = (a, b) => __defProps$1F(a, __getOwnPropDescs$1F(b));
var __objRest$1a = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2C.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2C)
    for (var prop of __getOwnPropSymbols$2C(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2C.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getIconStyles = (theme) => {
  return {
    // line-height: 0; is needed for correct icon alignment in Safari
    container: css.css`
      label: Icon;
      display: inline-block;
      line-height: 0;
    `,
    icon: css.css`
      vertical-align: middle;
      display: inline-block;
      fill: currentColor;
    `,
    orange: css.css`
      fill: ${theme.v1.palette.orange};
    `
  };
};
const Icon = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { size = "md", type = "default", name, className, style, title = "" } = _b, divElementProps = __objRest$1a(_b, ["size", "type", "name", "className", "style", "title"]);
    const styles = useStyles2(getIconStyles);
    if (name == null ? void 0 : name.startsWith("fa fa-")) {
      return /* @__PURE__ */ React__default["default"].createElement("i", __spreadProps$1F(__spreadValues$2A({ className: getFontAwesomeIconStyles(name, className) }, divElementProps), { style }));
    }
    if (!cacheInitialized) {
      initIconCache();
    }
    if (!data.isIconName(name)) {
      console.warn("Icon component passed an invalid icon name", name);
    }
    if (!name || name.includes("..")) {
      return /* @__PURE__ */ React__default["default"].createElement("div", { ref }, "invalid icon name");
    }
    const svgSize = getSvgSize(size);
    const svgHgt = svgSize;
    const svgWid = name.startsWith("gf-bar-align") ? 16 : name.startsWith("gf-interp") ? 30 : svgSize;
    const subDir = getIconSubDir(name, type);
    const svgPath = `${iconRoot}${subDir}/${name}.svg`;
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1F(__spreadValues$2A({ className: styles.container }, divElementProps), { ref }), /* @__PURE__ */ React__default["default"].createElement(
      SVG__default["default"],
      {
        src: svgPath,
        width: svgWid,
        height: svgHgt,
        title,
        className: css.cx(styles.icon, className, type === "mono" ? { [styles.orange]: name === "favorite" } : ""),
        style
      }
    ));
  }
);
Icon.displayName = "Icon";
function getFontAwesomeIconStyles(iconName, className) {
  return css.cx(
    iconName,
    {
      "fa-spin": iconName === "fa fa-spinner"
    },
    className
  );
}

function buildTooltipTheme(theme, tooltipBg, toggletipBorder, tooltipText, tooltipPadding) {
  return {
    arrow: css.css`
      height: 1rem;
      width: 1rem;
      position: absolute;
      pointer-events: none;

      &::before {
        border-style: solid;
        content: '';
        display: block;
        height: 0;
        margin: auto;
        width: 0;
      }

      &::after {
        border-style: solid;
        content: '';
        display: block;
        height: 0;
        margin: auto;
        position: absolute;
        width: 0;
      }
    `,
    container: css.css`
      background-color: ${tooltipBg};
      border-radius: ${theme.shape.radius.default};
      border: 1px solid ${toggletipBorder};
      box-shadow: ${theme.shadows.z2};
      color: ${tooltipText};
      font-size: ${theme.typography.bodySmall.fontSize};
      padding: ${theme.spacing(tooltipPadding.topBottom, tooltipPadding.rightLeft)};
      transition: opacity 0.3s;
      z-index: ${theme.zIndex.tooltip};
      max-width: 400px;
      overflow-wrap: break-word;

      &[data-popper-interactive='false'] {
        pointer-events: none;
      }

      &[data-popper-placement*='bottom'] > div[data-popper-arrow='true'] {
        left: 0;
        margin-top: -7px;
        top: 0;

        &::before {
          border-color: transparent transparent ${toggletipBorder} transparent;
          border-width: 0 8px 7px 8px;
          position: absolute;
          top: -1px;
        }

        &::after {
          border-color: transparent transparent ${tooltipBg} transparent;
          border-width: 0 8px 7px 8px;
        }
      }

      &[data-popper-placement*='top'] > div[data-popper-arrow='true'] {
        bottom: 0;
        left: 0;
        margin-bottom: -14px;

        &::before {
          border-color: ${toggletipBorder} transparent transparent transparent;
          border-width: 7px 8px 0 7px;
          position: absolute;
          top: 1px;
        }

        &::after {
          border-color: ${tooltipBg} transparent transparent transparent;
          border-width: 7px 8px 0 7px;
        }
      }

      &[data-popper-placement*='right'] > div[data-popper-arrow='true'] {
        left: 0;
        margin-left: -10px;

        &::before {
          border-color: transparent ${toggletipBorder} transparent transparent;
          border-width: 7px 6px 7px 0;
        }

        &::after {
          border-color: transparent ${tooltipBg} transparent transparent;
          border-width: 6px 7px 7px 0;
          left: 2px;
          top: 1px;
        }
      }

      &[data-popper-placement*='left'] > div[data-popper-arrow='true'] {
        margin-right: -11px;
        right: 0;

        &::before {
          border-color: transparent transparent transparent ${toggletipBorder};
          border-width: 7px 0 6px 7px;
        }

        &::after {
          border-color: transparent transparent transparent ${tooltipBg};
          border-width: 6px 0 5px 5px;
          left: 1px;
          top: 1px;
        }
      }

      code {
        border: none;
        display: inline;
        background: ${data.colorManipulator.darken(tooltipBg, 0.1)};
        color: ${tooltipText};
      }

      pre {
        background: ${data.colorManipulator.darken(tooltipBg, 0.1)};
        color: ${tooltipText};
      }

      a {
        color: ${tooltipText};
        text-decoration: underline;
      }

      a:hover {
        text-decoration: none;
      }
    `,
    headerClose: css.css`
      color: ${theme.colors.text.secondary};
      position: absolute;
      right: ${theme.spacing(1)};
      top: ${theme.spacing(1.5)};
      background-color: transparent;
      border: 0;
    `,
    header: css.css`
      padding-top: ${theme.spacing(1)};
      padding-bottom: ${theme.spacing(2)};
    `,
    body: css.css`
      padding-top: ${theme.spacing(1)};
      padding-bottom: ${theme.spacing(1)};
    `,
    footer: css.css`
      padding-top: ${theme.spacing(2)};
      padding-bottom: ${theme.spacing(1)};
    `
  };
}

let themeMock;
const getTheme = (mode = "dark") => {
  if (themeMock) {
    return themeMock(mode);
  }
  return data.createTheme({ colors: { mode } }).v1;
};
const mockTheme = (mock) => {
  themeMock = mock;
  return () => {
    themeMock = null;
  };
};

function getAgularPanelStyles(theme) {
  return react.css`
    .panel-options-group {
      border-bottom: 1px solid ${theme.colors.border.weak};
    }

    .panel-options-group__header {
      padding: ${theme.spacing(1, 2, 1, 1)};
      position: relative;
      display: flex;
      align-items: center;
      cursor: pointer;
      font-weight: 500;
      color: ${theme.colors.text.primary};

      &:hover {
        background: ${theme.colors.emphasize(theme.colors.background.primary, 0.03)};
      }
    }

    .panel-options-group__icon {
      color: ${theme.colors.text.secondary};
      margin-right: ${theme.spacing(1)};
      padding: ${theme.spacing(0, 0.9, 0, 0.6)};
    }

    .panel-options-group__title {
      position: relative;
    }

    .panel-options-group__body {
      padding: ${theme.spacing(1, 2, 1, 4)};
    }
  `;
}

function getCardStyles$1(theme) {
  return react.css`
    .card-section {
      margin-bottom: ${theme.spacing(4)};
    }

    .card-list {
      display: flex;
      flex-direction: row;
      flex-wrap: wrap;
      list-style-type: none;
    }

    .card-item {
      display: block;
      height: 100%;
      background: ${theme.colors.background.secondary};
      box-shadow: none;
      padding: ${theme.spacing(2)};
      border-radius: 4px;

      &:hover {
        background: ${theme.colors.emphasize(theme.colors.background.secondary, 0.03)};
      }

      .label-tag {
        margin-left: ${theme.spacing(1)};
        font-size: 11px;
        padding: 2px 6px;
      }
    }

    .card-item-body {
      display: flex;
      overflow: hidden;
    }

    .card-item-details {
      overflow: hidden;
    }

    .card-item-header {
      margin-bottom: ${theme.spacing(2)};
    }

    .card-item-type {
      color: ${theme.colors.text.secondary};
      text-transform: uppercase;
      font-size: ${theme.typography.size.sm};
      font-weight: ${theme.typography.fontWeightMedium};
    }

    .card-item-badge {
      margin: 6px 0;
    }

    .card-item-notice {
      font-size: ${theme.typography.size.sm};
    }

    .card-item-name {
      color: ${theme.colors.text.primary};
      overflow: hidden;
      text-overflow: ellipsis;
      width: 100%;
    }

    .card-item-label {
      margin-left: ${theme.spacing(1)};
    }

    .card-item-sub-name {
      color: ${theme.colors.text.secondary};
      overflow: hidden;
      text-overflow: ellipsis;
      width: 100%;
    }

    .card-item-sub-name--header {
      color: ${theme.colors.text.secondary};
      text-transform: uppercase;
      margin-bottom: ${theme.spacing(2)};
      font-size: ${theme.typography.size.sm};
      font-weight: bold;
    }

    .card-list-layout-grid {
      .card-item-type {
        display: inline-block;
      }

      .card-item-notice {
        font-size: ${theme.typography.size.sm};
        display: inline-block;
        margin-left: ${theme.spacing(2)};
      }

      .card-item-header-action {
        float: right;
      }

      .card-item-wrapper {
        width: 100%;
        padding: ${theme.spacing(0, 2, 2, 0)};
      }

      .card-item-wrapper--clickable {
        cursor: pointer;
      }

      .card-item-figure {
        margin: ${theme.spacing(0, 2, 2, 0)}0;
        height: 80px;

        img {
          width: 80px;
        }
      }

      .card-item-name {
        font-size: ${theme.typography.h3.fontSize};
      }

      ${theme.breakpoints.up("md")} {
        .card-item-wrapper {
          width: 50%;
        }
      }

      ${theme.breakpoints.up("lg")} {
        .card-item-wrapper {
          width: 33.333333%;
        }
      }

      &.card-list-layout-grid--max-2-col {
        ${theme.breakpoints.up("lg")} {
          .card-item-wrapper {
            width: 50%;
          }
        }
      }
    }

    .card-list-layout-list {
      .card-item-wrapper {
        padding: 0;
        width: 100%;
        margin-bottom: ${theme.spacing(1)};
      }

      .card-item-wrapper--clickable {
        cursor: pointer;
      }

      .card-item {
        border-radius: 2px;
      }

      .card-item-header {
        float: right;
        text-align: right;
      }

      .card-item-figure {
        margin: ${theme.spacing(0, 2, 0, 0)};
        img {
          width: 48px;
        }
      }

      .card-item-name {
        font-size: ${theme.typography.h4.fontSize};
      }

      .card-item-sub-name {
        font-size: ${theme.typography.size.sm};
      }

      .layout-selector {
        margin-right: 0;
      }
    }
  `;
}

function cardChrome(theme) {
  return `
    background: ${theme.colors.background.secondary};
    &:hover {
      background: ${hoverColor(theme.colors.background.secondary, theme)};
    }
    box-shadow: ${theme.components.panel.boxShadow};
    border-radius: ${theme.shape.radius.default};
`;
}
function hoverColor(color, theme) {
  return theme.isDark ? tinycolor__default["default"](color).brighten(2).toString() : tinycolor__default["default"](color).darken(2).toString();
}
function listItem(theme) {
  return `
  background: ${theme.colors.background.secondary};
  &:hover {
    background: ${hoverColor(theme.colors.background.secondary, theme)};
  }
  box-shadow: ${theme.components.panel.boxShadow};
  border-radius: ${theme.shape.radius.default};
`;
}
function listItemSelected(theme) {
  return `
    background: ${hoverColor(theme.colors.background.secondary, theme)};
    color: ${theme.colors.text.maxContrast};
`;
}
function mediaUp(breakpoint) {
  return `only screen and (min-width: ${breakpoint})`;
}
const isGrafanaTheme2 = (theme) => theme.hasOwnProperty("v1");
const focusCss = (theme) => {
  const isTheme2 = isGrafanaTheme2(theme);
  const firstColor = isTheme2 ? theme.colors.background.canvas : theme.colors.bodyBg;
  const secondColor = isTheme2 ? theme.colors.primary.main : theme.colors.formFocusOutline;
  return `
  outline: 2px dotted transparent;
  outline-offset: 2px;
  box-shadow: 0 0 0 2px ${firstColor}, 0 0 0px 4px ${secondColor};
  transition-property: outline, outline-offset, box-shadow;
  transition-duration: 0.2s;
  transition-timing-function: cubic-bezier(0.19, 1, 0.22, 1);`;
};
function getMouseFocusStyles(theme) {
  return {
    outline: "none",
    boxShadow: `none`
  };
}
function getFocusStyles(theme) {
  return {
    outline: "2px dotted transparent",
    outlineOffset: "2px",
    boxShadow: `0 0 0 2px ${theme.colors.background.canvas}, 0 0 0px 4px ${theme.colors.primary.main}`,
    transitionTimingFunction: `cubic-bezier(0.19, 1, 0.22, 1)`,
    transitionDuration: "0.2s",
    transitionProperty: "outline, outline-offset, box-shadow"
  };
}
const getTooltipContainerStyles = (theme) => `
  overflow: hidden;
  background: ${theme.colors.background.secondary};
  box-shadow: ${theme.shadows.z2};
  max-width: 800px;
  padding: ${theme.spacing(1)};
  border-radius: ${theme.shape.radius.default};
  z-index: ${theme.zIndex.tooltip};
`;

var mixins = /*#__PURE__*/Object.freeze({
  __proto__: null,
  cardChrome: cardChrome,
  hoverColor: hoverColor,
  listItem: listItem,
  listItemSelected: listItemSelected,
  mediaUp: mediaUp,
  focusCss: focusCss,
  getMouseFocusStyles: getMouseFocusStyles,
  getFocusStyles: getFocusStyles,
  getTooltipContainerStyles: getTooltipContainerStyles
});

function getElementStyles(theme) {
  return react.css`
    html {
      -ms-overflow-style: scrollbar;
      -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
      height: 100%;
      font-size: ${theme.typography.htmlFontSize}px;
      font-family: ${theme.typography.fontFamily};
      line-height: ${theme.typography.body.lineHeight};
      font-kerning: normal;
    }

    :root {
      color-scheme: ${theme.colors.mode};
    }

    body {
      height: 100%;
      width: 100%;
      position: absolute;
      color: ${theme.colors.text.primary};
      background-color: ${theme.colors.background.canvas};
      ${getVariantStyles(theme.typography.body)}
    }

    h1,
    .h1 {
      ${getVariantStyles(theme.typography.h1)}
    }
    h2,
    .h2 {
      ${getVariantStyles(theme.typography.h2)}
    }
    h3,
    .h3 {
      ${getVariantStyles(theme.typography.h3)}
    }
    h4,
    .h4 {
      ${getVariantStyles(theme.typography.h4)}
    }
    h5,
    .h5 {
      ${getVariantStyles(theme.typography.h5)}
    }
    h6,
    .h6 {
      ${getVariantStyles(theme.typography.h6)}
    }

    p {
      margin: 0 0 ${theme.spacing(2)};
    }

    button {
      letter-spacing: ${theme.typography.body.letterSpacing};

      &:focus-visible {
        outline: ${getFocusStyles(theme)};
      }
      &:focus {
        outline: none;
      }
    }

    // Ex: 14px base font * 85% = about 12px
    small {
      font-size: ${theme.typography.bodySmall.fontSize};
    }

    b,
    strong {
      font-weight: ${theme.typography.fontWeightMedium};
    }

    em {
      font-style: italic;
      color: ${theme.colors.text.primary};
    }

    cite {
      font-style: normal;
    }

    // Utility classes
    .muted {
      color: ${theme.colors.text.secondary};
    }

    a.muted:hover,
    a.muted:focus {
      color: ${theme.colors.text.primary};
    }

    .text-warning {
      color: ${theme.colors.warning.text};

      &:hover,
      &:focus {
        color: ${theme.colors.emphasize(theme.colors.warning.text, 0.15)};
      }
    }

    .text-error {
      color: ${theme.colors.error.text};

      &:hover,
      &:focus {
        color: ${theme.colors.emphasize(theme.colors.error.text, 0.15)};
      }
    }

    .text-success {
      color: $success-text-color;

      &:hover,
      &:focus {
        color: ${theme.colors.emphasize(theme.colors.success.text, 0.15)};
      }
    }

    a {
      cursor: pointer;
      color: ${theme.colors.text.primary};
      text-decoration: none;

      &:focus {
        outline: none;
      }

      &:focus-visible {
        ${getFocusStyles(theme)}
      }

      &: [disabled] {
        cursor: default;
        pointer-events: none !important;
      }
    }

    .text-link {
      text-decoration: underline;
    }

    .text-left {
      text-align: left;
    }

    .text-right {
      text-align: right;
    }

    .text-center {
      text-align: center;
    }

    .highlight-search-match {
      background: ${theme.components.textHighlight.background};
      color: ${theme.components.textHighlight.text};
      padding: 0;
    }
  `;
}
function getVariantStyles(variant) {
  return `
    margin: 0;
    font-size: ${variant.fontSize};
    line-height: ${variant.lineHeight};
    font-weight: ${variant.fontWeight};
    letter-spacing: ${variant.letterSpacing};
    font-family: ${variant.fontFamily};
    margin-bottom: 0.45em;
  `;
}

function getFormElementStyles(theme) {
  return react.css`
    input,
    button,
    select,
    textarea {
      font-size: ${theme.typography.body.fontSize};
      font-weight: ${theme.typography.body.fontWeight};
      line-height: ${theme.typography.body.lineHeight};
    }
    input,
    button,
    select,
    textarea {
      font-family: ${theme.typography.body.fontFamily};
    }

    input,
    select {
      background-color: ${theme.components.input.background};
      color: ${theme.components.input.text};
      border: none;
      box-shadow: none;
    }

    textarea {
      height: auto;
    }

    // Reset width of input images, buttons, radios, checkboxes
    input[type='file'],
    input[type='image'],
    input[type='submit'],
    input[type='reset'],
    input[type='button'],
    input[type='radio'],
    input[type='checkbox'] {
      width: auto; // Override of generic input selector
    }
  `;
}

function getMarkdownStyles(theme) {
  return react.css`
    // TODO copy from _utils.scss
  `;
}

function getPageStyles(theme) {
  const maxWidthBreakpoint = theme.breakpoints.values.xxl + theme.spacing.gridSize * 2 + theme.components.sidemenu.width;
  return react.css`
    .grafana-app {
      display: flex;
      align-items: stretch;
      position: absolute;
      width: 100%;
      height: 100%;
      top: 0;
      left: 0;
    }

    .main-view {
      position: relative;
      display: flex;
      flex-direction: column;
      flex-grow: 1;
      height: 100%;
      flex: 1 1 0;
      min-width: 0;
    }

    .page-scrollbar-content {
      display: flex;
      min-height: 100%;
      flex-direction: column;
      width: 100%;
      height: 100%;
    }

    .page-container {
      flex-grow: 1;
      flex-basis: 100%;
      padding-left: ${theme.spacing(2)};
      padding-right: ${theme.spacing(2)};

      ${theme.breakpoints.up("sm")} {
        margin: ${theme.spacing(0, 1)};
      }

      ${theme.breakpoints.up("md")} {
        margin: ${theme.spacing(0, 2)};
      }

      @media (min-width: ${maxWidthBreakpoint}px) {
        max-width: ${theme.breakpoints.values.xxl}px;
        margin-left: auto;
        margin-right: auto;
        width: 100%;
      }
    }

    .page-full {
      margin-left: ${theme.spacing(2)};
      padding-left: ${theme.spacing(2)};
      padding-right: ${theme.spacing(2)};
    }

    .page-body {
      padding: ${theme.spacing(1)};
      background: ${theme.components.panel.background};
      border: 1px solid ${theme.components.panel.borderColor};
      margin-bottom: 32px;

      ${theme.breakpoints.up("md")} {
        padding: ${theme.spacing(2)};
      }

      ${theme.breakpoints.up("lg")} {
        padding: ${theme.spacing(3)};
      }
    }

    .page-heading {
      font-size: ${theme.typography.h4.fontSize};
      margin-top: 0;
      margin-bottom: ${theme.spacing(2)};
    }

    .page-action-bar {
      margin-bottom: ${theme.spacing(2)};
      display: flex;
      align-items: flex-start;

      > a,
      > button,
      > div:nth-child(2) {
        margin-left: ${theme.spacing(2)};
      }
    }

    .page-action-bar--narrow {
      margin-bottom: 0;
    }

    .page-action-bar__spacer {
      width: ${theme.spacing(2)};
      flex-grow: 1;
    }

    .page-sub-heading {
      margin-bottom: ${theme.spacing(2)};
    }

    .page-sub-heading-icon {
      margin-left: ${theme.spacing(1)};
      margin-top: ${theme.spacing(0.5)};
    }

    .page-hidden {
      display: none;
    }
  `;
}

function GlobalStyles() {
  const theme = useTheme2();
  return /* @__PURE__ */ React__default["default"].createElement(
    react.Global,
    {
      styles: [
        getElementStyles(theme),
        getFormElementStyles(theme),
        getPageStyles(theme),
        getCardStyles$1(theme),
        getAgularPanelStyles(theme),
        getMarkdownStyles()
      ]
    }
  );
}

var __defProp$2z = Object.defineProperty;
var __defProps$1E = Object.defineProperties;
var __getOwnPropDescs$1E = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2B = Object.getOwnPropertySymbols;
var __hasOwnProp$2B = Object.prototype.hasOwnProperty;
var __propIsEnum$2B = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2z = (obj, key, value) => key in obj ? __defProp$2z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2z = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2B.call(b, prop))
      __defNormalProp$2z(a, prop, b[prop]);
  if (__getOwnPropSymbols$2B)
    for (var prop of __getOwnPropSymbols$2B(b)) {
      if (__propIsEnum$2B.call(b, prop))
        __defNormalProp$2z(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1E = (a, b) => __defProps$1E(a, __getOwnPropDescs$1E(b));
function Portal$1(props) {
  const { children, className, root, forwardedRef } = props;
  const theme = useTheme2();
  const node = React.useRef(null);
  const portalRoot = root != null ? root : getPortalContainer();
  if (!node.current) {
    node.current = document.createElement("div");
    if (className) {
      node.current.className = className;
    }
    node.current.style.position = "relative";
    node.current.style.zIndex = `${theme.zIndex.portal}`;
  }
  React.useLayoutEffect(() => {
    if (node.current) {
      portalRoot.appendChild(node.current);
    }
    return () => {
      if (node.current) {
        portalRoot.removeChild(node.current);
      }
    };
  }, [portalRoot]);
  return ReactDOM__default["default"].createPortal(/* @__PURE__ */ React__default["default"].createElement("div", { ref: forwardedRef }, children), node.current);
}
function getPortalContainer() {
  var _a;
  return (_a = window.document.getElementById("grafana-portal-container")) != null ? _a : document.body;
}
function PortalContainer() {
  return /* @__PURE__ */ React__default["default"].createElement("div", { id: "grafana-portal-container" });
}
const RefForwardingPortal = React__default["default"].forwardRef((props, ref) => {
  return /* @__PURE__ */ React__default["default"].createElement(Portal$1, __spreadProps$1E(__spreadValues$2z({}, props), { forwardedRef: ref }));
});
RefForwardingPortal.displayName = "RefForwardingPortal";

var __defProp$2y = Object.defineProperty;
var __getOwnPropSymbols$2A = Object.getOwnPropertySymbols;
var __hasOwnProp$2A = Object.prototype.hasOwnProperty;
var __propIsEnum$2A = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2y = (obj, key, value) => key in obj ? __defProp$2y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2y = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2A.call(b, prop))
      __defNormalProp$2y(a, prop, b[prop]);
  if (__getOwnPropSymbols$2A)
    for (var prop of __getOwnPropSymbols$2A(b)) {
      if (__propIsEnum$2A.call(b, prop))
        __defNormalProp$2y(a, prop, b[prop]);
    }
  return a;
};
const Tooltip = React__default["default"].memo(({ children, theme, interactive, show, placement, content }) => {
  const [controlledVisible, setControlledVisible] = React__default["default"].useState(show);
  React.useEffect(() => {
    if (controlledVisible !== false) {
      const handleKeyDown = (enterKey) => {
        if (enterKey.key === "Escape") {
          setControlledVisible(false);
        }
      };
      document.addEventListener("keydown", handleKeyDown);
      return () => {
        document.removeEventListener("keydown", handleKeyDown);
      };
    } else {
      return;
    }
  }, [controlledVisible]);
  const { getArrowProps, getTooltipProps, setTooltipRef, setTriggerRef, visible, update } = reactPopperTooltip.usePopperTooltip({
    visible: controlledVisible,
    placement,
    interactive,
    delayHide: interactive ? 100 : 0,
    delayShow: 150,
    offset: [0, 8],
    trigger: ["hover", "focus"],
    onVisibleChange: setControlledVisible
  });
  const styles = useStyles2(getStyles$1W);
  const style = styles[theme != null ? theme : "info"];
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, React__default["default"].cloneElement(children, {
    ref: setTriggerRef,
    tabIndex: 0
    // tooltip should be keyboard focusable
  }), visible && /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2y({ ref: setTooltipRef }, getTooltipProps({ className: style.container })), /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2y({}, getArrowProps({ className: style.arrow }))), typeof content === "string" && content, React__default["default"].isValidElement(content) && React__default["default"].cloneElement(content), typeof content === "function" && update && content({
    updatePopperPosition: update
  }))));
});
Tooltip.displayName = "Tooltip";
const getStyles$1W = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.components.tooltip.background,
    theme.components.tooltip.background,
    theme.components.tooltip.text,
    { topBottom: 0.5, rightLeft: 1 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 0.5, rightLeft: 1 }
  );
  return {
    info,
    ["info-alt"]: info,
    error
  };
};

class PopoverController extends React.Component {
  constructor() {
    super(...arguments);
    this.hideTimeout = null;
    this.state = { show: false };
    this.showPopper = () => {
      if (this.hideTimeout) {
        clearTimeout(this.hideTimeout);
      }
      this.setState({ show: true });
    };
    this.hidePopper = () => {
      this.hideTimeout = setTimeout(() => {
        this.setState({ show: false });
      }, this.props.hideAfter);
    };
  }
  render() {
    const { children, content, placement = "auto" } = this.props;
    const { show } = this.state;
    return children(this.showPopper, this.hidePopper, {
      show,
      placement,
      content
    });
  }
}

var __defProp$2x = Object.defineProperty;
var __defProps$1D = Object.defineProperties;
var __getOwnPropDescs$1D = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2z = Object.getOwnPropertySymbols;
var __hasOwnProp$2z = Object.prototype.hasOwnProperty;
var __propIsEnum$2z = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2x = (obj, key, value) => key in obj ? __defProp$2x(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2x = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2z.call(b, prop))
      __defNormalProp$2x(a, prop, b[prop]);
  if (__getOwnPropSymbols$2z)
    for (var prop of __getOwnPropSymbols$2z(b)) {
      if (__propIsEnum$2z.call(b, prop))
        __defNormalProp$2x(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1D = (a, b) => __defProps$1D(a, __getOwnPropDescs$1D(b));
var __objRest$19 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2z.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2z)
    for (var prop of __getOwnPropSymbols$2z(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2z.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const FormLabel = (_a) => {
  var _b = _a, {
    children,
    isFocused,
    isInvalid,
    className,
    htmlFor,
    tooltip,
    width,
    interactive
  } = _b, rest = __objRest$19(_b, [
    "children",
    "isFocused",
    "isInvalid",
    "className",
    "htmlFor",
    "tooltip",
    "width",
    "interactive"
  ]);
  const classes = classNames__default["default"](className, `gf-form-label width-${width ? width : "10"}`, {
    "gf-form-label--is-focused": isFocused,
    "gf-form-label--is-invalid": isInvalid
  });
  return /* @__PURE__ */ React__default["default"].createElement("label", __spreadProps$1D(__spreadValues$2x({ className: classes }, rest), { htmlFor }), children, tooltip && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { placement: "top", content: tooltip, theme: "info", interactive }, /* @__PURE__ */ React__default["default"].createElement(Icon, { tabIndex: 0, name: "info-circle", size: "sm", style: { marginLeft: "10px" } })));
};
const InlineFormLabel = FormLabel;

var __defProp$2w = Object.defineProperty;
var __defProps$1C = Object.defineProperties;
var __getOwnPropDescs$1C = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2y = Object.getOwnPropertySymbols;
var __hasOwnProp$2y = Object.prototype.hasOwnProperty;
var __propIsEnum$2y = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2w = (obj, key, value) => key in obj ? __defProp$2w(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2w = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2y.call(b, prop))
      __defNormalProp$2w(a, prop, b[prop]);
  if (__getOwnPropSymbols$2y)
    for (var prop of __getOwnPropSymbols$2y(b)) {
      if (__propIsEnum$2y.call(b, prop))
        __defNormalProp$2w(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1C = (a, b) => __defProps$1C(a, __getOwnPropDescs$1C(b));
var __objRest$18 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2y.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2y)
    for (var prop of __getOwnPropSymbols$2y(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2y.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  labelWidth: 6,
  inputWidth: 12
};
const FormField = (_a) => {
  var _b = _a, {
    label,
    tooltip,
    labelWidth,
    inputWidth,
    inputEl,
    className,
    interactive
  } = _b, inputProps = __objRest$18(_b, [
    "label",
    "tooltip",
    "labelWidth",
    "inputWidth",
    "inputEl",
    "className",
    "interactive"
  ]);
  const styles = getStyles$1V();
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.formField, className) }, /* @__PURE__ */ React__default["default"].createElement(InlineFormLabel, { width: labelWidth, tooltip, interactive }, label), inputEl || /* @__PURE__ */ React__default["default"].createElement(
    "input",
    __spreadProps$1C(__spreadValues$2w({
      type: "text",
      className: `gf-form-input ${inputWidth ? `width-${inputWidth}` : ""}`
    }, inputProps), {
      disabled: inputProps.disabled
    })
  ));
};
FormField.displayName = "FormField";
FormField.defaultProps = defaultProps;
const getStyles$1V = () => {
  return {
    formField: css.css`
      display: flex;
      flex-direction: row;
      align-items: flex-start;
      text-align: left;
      position: relative;
    `
  };
};

if (typeof window !== "undefined" && "Element" in window && !Element.prototype.closest) {
  Element.prototype.closest = function(s) {
    const matches = (this.document || this.ownerDocument).querySelectorAll(s);
    let el = this;
    let i;
    do {
      i = matches.length;
      while (--i >= 0 && matches.item(i) !== el) {
      }
      el = el.parentElement;
    } while (i < 0 && el);
    return el;
  };
}
function getPreviousCousin(node, selector) {
  let sibling = node.parentElement.previousSibling;
  let el;
  while (sibling) {
    el = sibling.querySelector(selector);
    if (el) {
      return el;
    }
    sibling = sibling.previousSibling;
  }
  return void 0;
}
function getNextCharacter(global) {
  const selection = (global || window).getSelection();
  if (!selection || !selection.anchorNode) {
    return null;
  }
  const range = selection.getRangeAt(0);
  const text = selection.anchorNode.textContent;
  const offset = range.startOffset;
  return text.slice(offset, offset + 1);
}

var dom = /*#__PURE__*/Object.freeze({
  __proto__: null,
  getPreviousCousin: getPreviousCousin,
  getNextCharacter: getNextCharacter
});

function getChildId(children) {
  let inputId;
  const child = React__default["default"].Children.only(children);
  if ("id" in (child == null ? void 0 : child.props)) {
    inputId = child.props.id;
  } else if ("inputId" in child.props) {
    inputId = child == null ? void 0 : child.props.inputId;
  }
  return typeof inputId === "string" ? inputId : void 0;
}
function renderOrCallToRender(itemToRender, props) {
  if (React__default["default"].isValidElement(itemToRender) || typeof itemToRender === "string" || typeof itemToRender === "number") {
    return itemToRender;
  }
  if (typeof itemToRender === "function") {
    return itemToRender(props);
  }
  throw new Error(`${itemToRender} is not a React element nor a function that returns React element`);
}

var reactUtils = /*#__PURE__*/Object.freeze({
  __proto__: null,
  getChildId: getChildId,
  renderOrCallToRender: renderOrCallToRender
});

const PALETTE_ROWS = 4;
const DEFAULT_ANNOTATION_COLOR = "rgba(0, 211, 255, 1)";
const OK_COLOR = "rgba(11, 237, 50, 1)";
const ALERTING_COLOR = "rgba(237, 46, 24, 1)";
const NO_DATA_COLOR = "rgba(150, 150, 150, 1)";
const PENDING_COLOR = "rgba(247, 149, 32, 1)";
const REGION_FILL_ALPHA = 0.09;
const colors = [
  "#7EB26D",
  // 0: pale green
  "#EAB839",
  // 1: mustard
  "#6ED0E0",
  // 2: light blue
  "#EF843C",
  // 3: orange
  "#E24D42",
  // 4: red
  "#1F78C1",
  // 5: ocean
  "#BA43A9",
  // 6: purple
  "#705DA0",
  // 7: violet
  "#508642",
  // 8: dark green
  "#CCA300",
  // 9: dark sand
  "#447EBC",
  "#C15C17",
  "#890F02",
  "#0A437C",
  "#6D1F62",
  "#584477",
  "#B7DBAB",
  "#F4D598",
  "#70DBED",
  "#F9BA8F",
  "#F29191",
  "#82B5D8",
  "#E5A8E2",
  "#AEA2E0",
  "#629E51",
  "#E5AC0E",
  "#64B0C8",
  "#E0752D",
  "#BF1B00",
  "#0A50A1",
  "#962D82",
  "#614D93",
  "#9AC48A",
  "#F2C96D",
  "#65C5DB",
  "#F9934E",
  "#EA6460",
  "#5195CE",
  "#D683CE",
  "#806EB7",
  "#3F6833",
  "#967302",
  "#2F575E",
  "#99440A",
  "#58140C",
  "#052B51",
  "#511749",
  "#3F2B5B",
  "#E0F9D7",
  "#FCEACA",
  "#CFFAFF",
  "#F9E2D2",
  "#FCE2DE",
  "#BADFF4",
  "#F9D9F9",
  "#DEDAF7"
];
function sortColorsByHue(hexColors) {
  const hslColors = lodash.map(hexColors, hexToHsl);
  const sortedHSLColors = lodash.sortBy(hslColors, ["h"]);
  const chunkedHSLColors = lodash.chunk(sortedHSLColors, PALETTE_ROWS);
  const sortedChunkedHSLColors = lodash.map(chunkedHSLColors, (chunk2) => {
    return lodash.sortBy(chunk2, "l");
  });
  const flattenedZippedSortedChunkedHSLColors = lodash.flattenDeep(lodash.zip(...sortedChunkedHSLColors));
  return lodash.map(flattenedZippedSortedChunkedHSLColors, hslToHex);
}
function hexToHsl(color) {
  return tinycolor__default["default"](color).toHsl();
}
function hslToHex(color) {
  return tinycolor__default["default"](color).toHexString();
}
function getTextColorForBackground(color) {
  const b = tinycolor__default["default"](color).getBrightness();
  return b > 180 ? "rgb(32, 34, 38)" : "rgb(247, 248, 250)";
}
function getTextColorForAlphaBackground(color, themeIsDark) {
  const tcolor = tinycolor__default["default"](color);
  const b = tcolor.getBrightness();
  const a = tcolor.getAlpha();
  if (a < 0.3) {
    return themeIsDark ? "rgb(247, 248, 250)" : "rgb(32, 34, 38)";
  }
  return b > 180 ? "rgb(32, 34, 38)" : "rgb(247, 248, 250)";
}
let sortedColors = sortColorsByHue(colors);

var EventsWithValidation = /* @__PURE__ */ ((EventsWithValidation2) => {
  EventsWithValidation2["onBlur"] = "onBlur";
  EventsWithValidation2["onFocus"] = "onFocus";
  EventsWithValidation2["onChange"] = "onChange";
  return EventsWithValidation2;
})(EventsWithValidation || {});
const validate = (value, validationRules) => {
  const errors = validationRules.reduce((acc, currRule) => {
    if (!currRule.rule(value)) {
      return acc.concat(currRule.errorMessage);
    }
    return acc;
  }, []);
  return errors.length > 0 ? errors : null;
};
const hasValidationEvent = (event, validationEvents) => {
  return validationEvents && validationEvents[event];
};
const regexValidation = (pattern, errorMessage) => {
  return {
    rule: (valueToValidate) => {
      return !!valueToValidate.match(pattern);
    },
    errorMessage: errorMessage || "Value is not valid"
  };
};

const SCHEMA = {
  document: {
    nodes: [
      {
        match: [{ type: "paragraph" }, { type: "code_block" }, { type: "code_line" }]
      }
    ]
  },
  inlines: {}
};
const makeFragment = (text, syntax) => {
  const lines = text.split("\n").map(
    (line) => slate.Block.create({
      type: "code_line",
      nodes: [slate.Text.create(line)]
    })
  );
  const block = slate.Block.create({
    data: {
      syntax
    },
    type: "code_block",
    nodes: lines
  });
  return slate.Document.create({
    nodes: [block]
  });
};
const makeValue = (text, syntax) => {
  const fragment = makeFragment(text, syntax);
  return slate.Value.create({
    document: fragment
  });
};

const linkModelToContextMenuItems = (links) => {
  return links().map((link) => {
    return {
      label: link.title,
      ariaLabel: link.title,
      // TODO: rename to href
      url: link.href,
      target: link.target,
      icon: `${link.target === "_blank" ? "external-link-alt" : "link"}`,
      onClick: link.onClick
    };
  });
};
const isCompactUrl = (url) => {
  const compactExploreUrlRegex = /\/explore\?.*&(left|right)=\[(.*\,){2,}(.*){1}\]/;
  return compactExploreUrlRegex.test(url);
};

const TAG_COLORS = [
  "#D32D20",
  "#1E72B8",
  "#B240A2",
  "#705DA0",
  "#466803",
  "#497A3C",
  "#3D71AA",
  "#B15415",
  "#890F02",
  "#6E6E6E",
  "#0A437C",
  "#6D1F62",
  "#584477",
  "#4C7A3F",
  "#2F4F4F",
  "#BF1B00",
  "#7662B1",
  "#8A2EB8",
  "#517A00",
  "#000000",
  "#3F6833",
  "#2F575E",
  "#99440A",
  "#AE561A",
  "#0E4AB4",
  "#58140C",
  "#052B51",
  "#511749",
  "#3F2B5B"
];
const TAG_BORDER_COLORS = [
  "#FF7368",
  "#459EE7",
  "#E069CF",
  "#9683C6",
  "#6C8E29",
  "#76AC68",
  "#6AA4E2",
  "#E7823D",
  "#AF3528",
  "#9B9B9B",
  "#3069A2",
  "#934588",
  "#7E6A9D",
  "#88C477",
  "#557575",
  "#E54126",
  "#A694DD",
  "#B054DE",
  "#8FC426",
  "#262626",
  "#658E59",
  "#557D84",
  "#BF6A30",
  "#FF9B53",
  "#3470DA",
  "#7E3A32",
  "#2B5177",
  "#773D6F",
  "#655181"
];
function getTagColorsFromName(name = "") {
  const hash = djb2(name.toLowerCase());
  const index = Math.abs(hash % TAG_COLORS.length);
  return getTagColor(index);
}
function getTagColor(index) {
  return { color: TAG_COLORS[index], borderColor: TAG_BORDER_COLORS[index] };
}
function djb2(str) {
  let hash = 5381;
  for (let i = 0; i < str.length; i++) {
    hash = (hash << 5) + hash + str.charCodeAt(i);
  }
  return hash;
}

let scrollbarWidth = null;
function getScrollbarWidth() {
  if (scrollbarWidth !== null) {
    return scrollbarWidth;
  }
  if (typeof document !== "undefined") {
    const div = document.createElement("div");
    const newStyles = {
      width: "100px",
      height: "100px",
      position: "absolute",
      top: "-9999px",
      overflow: "scroll",
      MsOverflowStyle: "scrollbar"
    };
    Object.keys(newStyles).map((style) => {
      div.style[style] = newStyles[style];
    });
    document.body.appendChild(div);
    scrollbarWidth = div.offsetWidth - div.clientWidth;
    document.body.removeChild(div);
  } else {
    scrollbarWidth = 0;
  }
  return scrollbarWidth || 0;
}

const getCellLinks = (field, row) => {
  let links;
  if (field.getLinks) {
    links = field.getLinks({
      valueRowIndex: row.index
    });
  }
  if (!links) {
    return;
  }
  for (let i = 0; i < (links == null ? void 0 : links.length); i++) {
    if (links[i].onClick) {
      const origOnClick = links[i].onClick;
      links[i].onClick = (event) => {
        if (!(event.ctrlKey || event.metaKey || event.shiftKey)) {
          event.preventDefault();
          origOnClick(event, {
            field,
            rowIndex: row.index
          });
        }
      };
    }
  }
  return links;
};

let _context;
const cache = /* @__PURE__ */ new Map();
const cacheLimit = 500;
let ctxFontStyle = "";
function getCanvasContext() {
  if (!_context) {
    _context = document.createElement("canvas").getContext("2d");
  }
  return _context;
}
function measureText(text, fontSize, fontWeight = 400) {
  const fontStyle = `${fontWeight} ${fontSize}px 'Inter'`;
  const cacheKey = text + fontStyle;
  const fromCache = cache.get(cacheKey);
  if (fromCache) {
    return fromCache;
  }
  const context = getCanvasContext();
  if (ctxFontStyle !== fontStyle) {
    context.font = ctxFontStyle = fontStyle;
  }
  const metrics = context.measureText(text);
  if (cache.size === cacheLimit) {
    cache.clear();
  }
  cache.set(cacheKey, metrics);
  return metrics;
}
function calculateFontSize(text, width, height, lineHeight, maxSize, fontWeight) {
  const textSize = measureText(text, 14, fontWeight);
  const fontSizeBasedOnWidth = width / (textSize.width + 2) * 14;
  const fontSizeBasedOnHeight = height / lineHeight;
  const optimalSize = Math.min(fontSizeBasedOnHeight, fontSizeBasedOnWidth);
  return Math.min(optimalSize, maxSize != null ? maxSize : optimalSize);
}

function useForceUpdate() {
  const [_, setValue] = React.useState(0);
  return () => setValue((prevState) => prevState + 1);
}

function fuzzyMatch(stack, needle) {
  let distance = 0, searchIndex = stack.indexOf(needle);
  needle = needle.replace(/\s/g, "");
  const ranges = [];
  if (searchIndex !== -1) {
    return {
      distance: 0,
      found: true,
      ranges: [{ start: searchIndex, end: searchIndex + needle.length - 1 }]
    };
  }
  for (const letter of needle) {
    const letterIndex = stack.indexOf(letter, searchIndex);
    if (letterIndex === -1) {
      return { distance: Infinity, ranges: [], found: false };
    }
    if (searchIndex !== -1) {
      distance += letterIndex - searchIndex;
    }
    searchIndex = letterIndex + 1;
    if (ranges.length === 0) {
      ranges.push({ start: letterIndex, end: letterIndex });
    } else {
      const lastRange = lodash.last(ranges);
      if (letterIndex === lastRange.end + 1) {
        lastRange.end++;
      } else {
        ranges.push({ start: letterIndex, end: letterIndex });
      }
    }
  }
  return {
    distance,
    ranges,
    found: true
  };
}

var SearchFunctionType = /* @__PURE__ */ ((SearchFunctionType2) => {
  SearchFunctionType2["Word"] = "Word";
  SearchFunctionType2["Prefix"] = "Prefix";
  SearchFunctionType2["Fuzzy"] = "Fuzzy";
  return SearchFunctionType2;
})(SearchFunctionType || {});
const wordSearch = (items, text) => {
  return items.filter((c) => (c.filterText || c.label).includes(text));
};
const prefixSearch = (items, text) => {
  return items.filter((c) => (c.filterText || c.label).startsWith(text));
};
const fuzzySearch = (items, text) => {
  text = text.toLowerCase();
  return items.filter((item) => {
    const { distance, ranges, found } = fuzzyMatch(item.label.toLowerCase(), text);
    if (!found) {
      return false;
    }
    item.sortValue = distance;
    item.highlightParts = ranges;
    return true;
  });
};
const SearchFunctionMap = {
  ["Word" /* Word */]: wordSearch,
  ["Prefix" /* Prefix */]: prefixSearch,
  ["Fuzzy" /* Fuzzy */]: fuzzySearch
};

const throttledLog = lodash.throttle((...t) => {
  console.log(...t);
}, 500);
const createLogger = (name) => {
  let LOGGIN_ENABLED = false;
  return {
    logger: (id, throttle2 = false, ...t) => {
      if (process.env.NODE_ENV === "production" || process.env.NODE_ENV === "test" || !LOGGIN_ENABLED) {
        return;
      }
      const fn = throttle2 ? throttledLog : console.log;
      fn(`[${name}: ${id}]: `, ...t);
    },
    enable: () => LOGGIN_ENABLED = true,
    disable: () => LOGGIN_ENABLED = false,
    isEnabled: () => LOGGIN_ENABLED
  };
};

var __defProp$2v = Object.defineProperty;
var __defProps$1B = Object.defineProperties;
var __getOwnPropDescs$1B = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2x = Object.getOwnPropertySymbols;
var __hasOwnProp$2x = Object.prototype.hasOwnProperty;
var __propIsEnum$2x = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2v = (obj, key, value) => key in obj ? __defProp$2v(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2v = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2x.call(b, prop))
      __defNormalProp$2v(a, prop, b[prop]);
  if (__getOwnPropSymbols$2x)
    for (var prop of __getOwnPropSymbols$2x(b)) {
      if (__propIsEnum$2x.call(b, prop))
        __defNormalProp$2v(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1B = (a, b) => __defProps$1B(a, __getOwnPropDescs$1B(b));
function attachDebugger(key, thebugger, logger) {
  var _a;
  if (process.env.NODE_ENV === "production") {
    return;
  }
  let completeDebugger = thebugger || {};
  if (logger !== void 0) {
    completeDebugger = __spreadProps$1B(__spreadValues$2v({}, completeDebugger), { enable: () => logger.enable(), disable: () => logger.disable() });
  }
  let debugGlobal = (_a = typeof window !== "undefined" && window["_debug"]) != null ? _a : {};
  debugGlobal[key] = completeDebugger;
  if (typeof window !== "undefined") {
    window["_debug"] = debugGlobal;
  }
}

var NodeGraphDataFrameFieldNames = /* @__PURE__ */ ((NodeGraphDataFrameFieldNames2) => {
  NodeGraphDataFrameFieldNames2["id"] = "id";
  NodeGraphDataFrameFieldNames2["title"] = "title";
  NodeGraphDataFrameFieldNames2["subTitle"] = "subTitle";
  NodeGraphDataFrameFieldNames2["mainStat"] = "mainStat";
  NodeGraphDataFrameFieldNames2["secondaryStat"] = "secondaryStat";
  NodeGraphDataFrameFieldNames2["source"] = "source";
  NodeGraphDataFrameFieldNames2["target"] = "target";
  NodeGraphDataFrameFieldNames2["detail"] = "detail__";
  NodeGraphDataFrameFieldNames2["arc"] = "arc__";
  NodeGraphDataFrameFieldNames2["color"] = "color";
  return NodeGraphDataFrameFieldNames2;
})(NodeGraphDataFrameFieldNames || {});

var __defProp$2u = Object.defineProperty;
var __defProps$1A = Object.defineProperties;
var __getOwnPropDescs$1A = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2w = Object.getOwnPropertySymbols;
var __hasOwnProp$2w = Object.prototype.hasOwnProperty;
var __propIsEnum$2w = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2u = (obj, key, value) => key in obj ? __defProp$2u(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2u = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2w.call(b, prop))
      __defNormalProp$2u(a, prop, b[prop]);
  if (__getOwnPropSymbols$2w)
    for (var prop of __getOwnPropSymbols$2w(b)) {
      if (__propIsEnum$2w.call(b, prop))
        __defNormalProp$2u(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1A = (a, b) => __defProps$1A(a, __getOwnPropDescs$1A(b));
var __objRest$17 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2w.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2w)
    for (var prop of __getOwnPropSymbols$2w(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2w.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var LegacyInputStatus = /* @__PURE__ */ ((LegacyInputStatus2) => {
  LegacyInputStatus2["Invalid"] = "invalid";
  LegacyInputStatus2["Valid"] = "valid";
  return LegacyInputStatus2;
})(LegacyInputStatus || {});
class Input$1 extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      error: null
    };
    this.validatorAsync = (validationRules) => {
      return (evt) => {
        const errors = validate(evt.target.value, validationRules);
        this.setState((prevState) => {
          return __spreadProps$1A(__spreadValues$2u({}, prevState), { error: errors ? errors[0] : null });
        });
      };
    };
    this.populateEventPropsWithStatus = (restProps, validationEvents) => {
      const inputElementProps = __spreadValues$2u({}, restProps);
      if (!validationEvents) {
        return inputElementProps;
      }
      Object.keys(EventsWithValidation).forEach((eventName) => {
        if (hasValidationEvent(eventName, validationEvents) || restProps[eventName]) {
          inputElementProps[eventName] = async (evt) => {
            evt.persist();
            if (hasValidationEvent(eventName, validationEvents)) {
              await this.validatorAsync(validationEvents[eventName]).apply(this, [evt]);
            }
            if (restProps[eventName]) {
              restProps[eventName].apply(null, [evt, this.status]);
            }
          };
        }
      });
      return inputElementProps;
    };
  }
  get status() {
    return this.state.error ? "invalid" /* Invalid */ : "valid" /* Valid */;
  }
  get isInvalid() {
    return this.status === "invalid" /* Invalid */;
  }
  render() {
    const _a = this.props, { validationEvents, className, hideErrorMessage, inputRef } = _a, restProps = __objRest$17(_a, ["validationEvents", "className", "hideErrorMessage", "inputRef"]);
    const { error } = this.state;
    const inputClassName = classNames__default["default"]("gf-form-input", { invalid: this.isInvalid }, className);
    const inputElementProps = this.populateEventPropsWithStatus(restProps, validationEvents);
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: { flexGrow: 1 } }, /* @__PURE__ */ React__default["default"].createElement("input", __spreadProps$1A(__spreadValues$2u({}, inputElementProps), { ref: inputRef, className: inputClassName })), error && !hideErrorMessage && /* @__PURE__ */ React__default["default"].createElement("span", null, error));
  }
}
Input$1.defaultProps = {
  className: ""
};

var __defProp$2t = Object.defineProperty;
var __getOwnPropSymbols$2v = Object.getOwnPropertySymbols;
var __hasOwnProp$2v = Object.prototype.hasOwnProperty;
var __propIsEnum$2v = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2t = (obj, key, value) => key in obj ? __defProp$2t(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2t = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2v.call(b, prop))
      __defNormalProp$2t(a, prop, b[prop]);
  if (__getOwnPropSymbols$2v)
    for (var prop of __getOwnPropSymbols$2v(b)) {
      if (__propIsEnum$2v.call(b, prop))
        __defNormalProp$2t(a, prop, b[prop]);
    }
  return a;
};
const IndicatorsContainer$1 = (props) => {
  const isOpen = props.selectProps.menuIsOpen;
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.IndicatorsContainer, __spreadValues$2t({}, props), /* @__PURE__ */ React__default["default"].createElement(Icon, { name: isOpen ? "angle-up" : "angle-down", style: { marginTop: "7px" } }));
};

var __defProp$2s = Object.defineProperty;
var __getOwnPropSymbols$2u = Object.getOwnPropertySymbols;
var __hasOwnProp$2u = Object.prototype.hasOwnProperty;
var __propIsEnum$2u = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2s = (obj, key, value) => key in obj ? __defProp$2s(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2s = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2u.call(b, prop))
      __defNormalProp$2s(a, prop, b[prop]);
  if (__getOwnPropSymbols$2u)
    for (var prop of __getOwnPropSymbols$2u(b)) {
      if (__propIsEnum$2u.call(b, prop))
        __defNormalProp$2s(a, prop, b[prop]);
    }
  return a;
};
const NoOptionsMessage = (props) => {
  const { children } = props;
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.NoOptionsMessage, __spreadValues$2s({}, props), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option__body" }, children)));
};

const ScrollIndicators = ({ children }) => {
  const [showScrollTopIndicator, setShowTopScrollIndicator] = React.useState(false);
  const [showScrollBottomIndicator, setShowBottomScrollIndicator] = React.useState(false);
  const scrollTopMarker = React.useRef(null);
  const scrollBottomMarker = React.useRef(null);
  const styles = useStyles2(getStyles$1U);
  React.useEffect(() => {
    const intersectionObserver = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.target === scrollTopMarker.current) {
          setShowTopScrollIndicator(!entry.isIntersecting);
        } else if (entry.target === scrollBottomMarker.current) {
          setShowBottomScrollIndicator(!entry.isIntersecting);
        }
      });
    });
    [scrollTopMarker, scrollBottomMarker].forEach((ref) => {
      if (ref.current) {
        intersectionObserver.observe(ref.current);
      }
    });
    return () => intersectionObserver.disconnect();
  }, []);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.scrollIndicator, styles.scrollTopIndicator, {
        [styles.scrollIndicatorVisible]: showScrollTopIndicator
      })
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { className: classNames__default["default"](styles.scrollIcon, styles.scrollTopIcon), name: "angle-up" })
  ), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.scrollContent }, /* @__PURE__ */ React__default["default"].createElement("div", { ref: scrollTopMarker }), children, /* @__PURE__ */ React__default["default"].createElement("div", { ref: scrollBottomMarker })), /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.scrollIndicator, styles.scrollBottomIndicator, {
        [styles.scrollIndicatorVisible]: showScrollBottomIndicator
      })
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { className: classNames__default["default"](styles.scrollIcon, styles.scrollBottomIcon), name: "angle-down" })
  ));
};
const getStyles$1U = (theme) => {
  return {
    scrollContent: css.css({
      flex: 1,
      position: "relative"
    }),
    scrollIndicator: css.css({
      height: theme.spacing(6),
      left: 0,
      opacity: 0,
      pointerEvents: "none",
      position: "absolute",
      right: 0,
      transition: theme.transitions.create("opacity"),
      zIndex: 1
    }),
    scrollTopIndicator: css.css({
      background: `linear-gradient(0deg, transparent, ${theme.colors.background.canvas})`,
      top: 0
    }),
    scrollBottomIndicator: css.css({
      background: `linear-gradient(180deg, transparent, ${theme.colors.background.canvas})`,
      bottom: 0
    }),
    scrollIndicatorVisible: css.css({
      opacity: 1
    }),
    scrollIcon: css.css({
      left: "50%",
      position: "absolute",
      transform: "translateX(-50%)"
    }),
    scrollTopIcon: css.css({
      top: 0
    }),
    scrollBottomIcon: css.css({
      bottom: 0
    })
  };
};

var __defProp$2r = Object.defineProperty;
var __defProps$1z = Object.defineProperties;
var __getOwnPropDescs$1z = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2t = Object.getOwnPropertySymbols;
var __hasOwnProp$2t = Object.prototype.hasOwnProperty;
var __propIsEnum$2t = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2r = (obj, key, value) => key in obj ? __defProp$2r(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2r = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2t.call(b, prop))
      __defNormalProp$2r(a, prop, b[prop]);
  if (__getOwnPropSymbols$2t)
    for (var prop of __getOwnPropSymbols$2t(b)) {
      if (__propIsEnum$2t.call(b, prop))
        __defNormalProp$2r(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1z = (a, b) => __defProps$1z(a, __getOwnPropDescs$1z(b));
const CustomScrollbar = ({
  autoHide = false,
  autoHideTimeout = 200,
  setScrollTop,
  className,
  testId,
  autoHeightMin = "0",
  autoHeightMax = "100%",
  hideTracksWhenNotNeeded = false,
  hideHorizontalTrack,
  hideVerticalTrack,
  scrollRefCallback,
  showScrollIndicators = false,
  updateAfterMountMs,
  scrollTop,
  onScroll,
  children
}) => {
  const ref = React.useRef(null);
  const styles = useStyles2(getStyles$1T);
  React.useEffect(() => {
    if (ref.current && scrollRefCallback) {
      scrollRefCallback(ref.current.view);
    }
  }, [ref, scrollRefCallback]);
  React.useEffect(() => {
    if (ref.current && scrollTop != null) {
      ref.current.scrollTop(scrollTop);
    }
  }, [scrollTop]);
  React.useEffect(() => {
    if (!updateAfterMountMs) {
      return;
    }
    setTimeout(() => {
      const scrollbar = ref.current;
      if (scrollbar == null ? void 0 : scrollbar.update) {
        scrollbar.update();
      }
    }, updateAfterMountMs);
  }, [updateAfterMountMs]);
  function renderTrack(className2, hideTrack, passedProps) {
    if (passedProps.style && hideTrack) {
      passedProps.style.display = "none";
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1z(__spreadValues$2r({}, passedProps), { className: className2 }));
  }
  const renderTrackHorizontal = React.useCallback(
    (passedProps) => {
      return renderTrack("track-horizontal", hideHorizontalTrack, passedProps);
    },
    [hideHorizontalTrack]
  );
  const renderTrackVertical = React.useCallback(
    (passedProps) => {
      return renderTrack("track-vertical", hideVerticalTrack, passedProps);
    },
    [hideVerticalTrack]
  );
  const renderThumbHorizontal = React.useCallback((passedProps) => {
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1z(__spreadValues$2r({}, passedProps), { className: "thumb-horizontal" }));
  }, []);
  const renderThumbVertical = React.useCallback((passedProps) => {
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1z(__spreadValues$2r({}, passedProps), { className: "thumb-vertical" }));
  }, []);
  const renderView = React.useCallback((passedProps) => {
    if (passedProps.style && passedProps.style["WebkitOverflowScrolling"] === "touch") {
      passedProps.style["WebkitOverflowScrolling"] = "auto";
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1z(__spreadValues$2r({}, passedProps), { className: "scrollbar-view" }));
  }, []);
  const onScrollStop = React.useCallback(() => {
    ref.current && setScrollTop && setScrollTop(ref.current.getValues());
  }, [setScrollTop]);
  return /* @__PURE__ */ React__default["default"].createElement(
    Scrollbars__default["default"],
    {
      "data-testid": testId,
      ref,
      className: css.cx(styles.customScrollbar, className, {
        [styles.scrollbarWithScrollIndicators]: showScrollIndicators
      }),
      onScrollStop,
      autoHeight: true,
      autoHide,
      autoHideTimeout,
      hideTracksWhenNotNeeded,
      autoHeightMax,
      autoHeightMin,
      renderTrackHorizontal,
      renderTrackVertical,
      renderThumbHorizontal,
      renderThumbVertical,
      renderView,
      onScroll
    },
    showScrollIndicators ? /* @__PURE__ */ React__default["default"].createElement(ScrollIndicators, null, children) : children
  );
};
const getStyles$1T = (theme) => {
  return {
    customScrollbar: css.css`
      // Fix for Firefox. For some reason sometimes .view container gets a height of its content, but in order to
      // make scroll working it should fit outer container size (scroll appears only when inner container size is
      // greater than outer one).
      display: flex;
      flex-grow: 1;
      .scrollbar-view {
        display: flex;
        flex-grow: 1;
        flex-direction: column;
      }
      .track-vertical {
        border-radius: ${theme.shape.borderRadius(2)};
        width: ${theme.spacing(1)} !important;
        right: 0px;
        bottom: ${theme.spacing(0.25)};
        top: ${theme.spacing(0.25)};
      }
      .track-horizontal {
        border-radius: ${theme.shape.borderRadius(2)};
        height: ${theme.spacing(1)} !important;
        right: ${theme.spacing(0.25)};
        bottom: ${theme.spacing(0.25)};
        left: ${theme.spacing(0.25)};
      }
      .thumb-vertical {
        background: ${theme.colors.action.focus};
        border-radius: ${theme.shape.borderRadius(2)};
        opacity: 0;
      }
      .thumb-horizontal {
        background: ${theme.colors.action.focus};
        border-radius: ${theme.shape.borderRadius(2)};
        opacity: 0;
      }
      &:hover {
        .thumb-vertical,
        .thumb-horizontal {
          opacity: 1;
          transition: opacity 0.3s ease-in-out;
        }
      }
    `,
    // override the scroll container position so that the scroll indicators
    // are positioned at the top and bottom correctly.
    // react-custom-scrollbars doesn't provide any way for us to hook in nicely,
    // so we have to override with !important. feelsbad.
    scrollbarWithScrollIndicators: css.css`
      .scrollbar-view {
        position: static !important;
      }
    `
  };
};

const getSelectOptionGroupStyles = stylesFactory((theme) => {
  return {
    header: css.css`
      display: flex;
      align-items: center;
      justify-content: flex-start;
      justify-items: center;
      cursor: pointer;
      padding: 7px 10px;
      width: 100%;
      border-bottom: 1px solid ${theme.colors.background.secondary};

      &:hover {
        color: ${theme.colors.text.maxContrast};
      }
    `,
    label: css.css`
      flex-grow: 1;
    `,
    icon: css.css`
      padding-right: 2px;
    `
  };
});
class UnthemedSelectOptionGroup extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      expanded: false
    };
    this.onToggleChildren = () => {
      this.setState((prevState) => ({
        expanded: !prevState.expanded
      }));
    };
  }
  componentDidMount() {
    if (this.props.data.expanded) {
      this.setState({ expanded: true });
    } else if (this.props.selectProps && this.props.selectProps.value) {
      const { value } = this.props.selectProps.value;
      if (value && this.props.options.some((option) => option.value === value)) {
        this.setState({ expanded: true });
      }
    }
  }
  componentDidUpdate(nextProps) {
    if (nextProps.selectProps.inputValue !== "") {
      this.setState({ expanded: true });
    }
  }
  render() {
    const { children, label, theme } = this.props;
    const { expanded } = this.state;
    const styles = getSelectOptionGroupStyles(theme);
    return /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.header, onClick: this.onToggleChildren }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.label }, label), /* @__PURE__ */ React__default["default"].createElement(Icon, { className: styles.icon, name: expanded ? "angle-up" : "angle-down" }), " "), expanded && children);
  }
}
const SelectOptionGroup = withTheme2(UnthemedSelectOptionGroup);

function useDelayedSwitch(value, options = {}) {
  const { duration = 250, delay = 250 } = options;
  const [delayedValue, setDelayedValue] = React.useState(value);
  const onStartTime = React.useRef();
  React.useEffect(() => {
    let timeout;
    if (value) {
      timeout = setTimeout(() => {
        onStartTime.current = new Date();
        setDelayedValue(value);
      }, delay);
    } else {
      const timeSpent = onStartTime.current ? Date.now() - onStartTime.current.valueOf() : 0;
      const turnOff = () => {
        onStartTime.current = void 0;
        setDelayedValue(value);
      };
      if (timeSpent >= duration) {
        turnOff();
      } else {
        timeout = setTimeout(turnOff, duration - timeSpent);
      }
    }
    return () => {
      if (timeout) {
        clearTimeout(timeout);
        timeout = void 0;
      }
    };
  }, [value, duration, delay]);
  return delayedValue;
}

const getStyles$1S = stylesFactory((size, inline) => {
  return {
    wrapper: css.css`
      font-size: ${size}px;
      ${inline ? css.css`
            display: inline-block;
          ` : ""}
    `
  };
});
const Spinner = ({ className, inline = false, iconClassName, style, size = 16 }) => {
  const styles = getStyles$1S(size, inline);
  return /* @__PURE__ */ React__default["default"].createElement("div", { "data-testid": "Spinner", style, className: css.cx(styles.wrapper, className) }, /* @__PURE__ */ React__default["default"].createElement(Icon, { className: css.cx("fa-spin", iconClassName), name: "fa fa-spinner" }));
};

const getStyles$1R = stylesFactory((duration) => {
  return {
    enter: css.css`
      label: enter;
      opacity: 0;
    `,
    enterActive: css.css`
      label: enterActive;
      opacity: 1;
      transition: opacity ${duration}ms ease-out;
    `,
    exit: css.css`
      label: exit;
      opacity: 1;
    `,
    exitActive: css.css`
      label: exitActive;
      opacity: 0;
      transition: opacity ${duration}ms ease-out;
    `
  };
});
function FadeTransition(props) {
  const { visible, children, duration = 250 } = props;
  const styles = getStyles$1R(duration);
  return /* @__PURE__ */ React__default["default"].createElement(reactTransitionGroup.CSSTransition, { in: visible, mountOnEnter: true, unmountOnExit: true, timeout: duration, classNames: styles }, children);
}

const getStyles$1Q = stylesFactory((duration, measurement, size) => {
  return {
    enter: css.css`
      label: enter;
      ${measurement}: 0;
      opacity: 0;
    `,
    enterActive: css.css`
      label: enterActive;
      ${measurement}: ${size}px;
      opacity: 1;
      transition: opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out;
    `,
    exit: css.css`
      label: exit;
      ${measurement}: ${size}px;
      opacity: 1;
    `,
    exitActive: css.css`
      label: exitActive;
      opacity: 0;
      ${measurement}: 0;
      transition: opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out;
    `
  };
});
function SlideOutTransition(props) {
  const { visible, children, duration = 250, horizontal, size } = props;
  const styles = getStyles$1Q(duration, horizontal ? "width" : "height", size);
  return /* @__PURE__ */ React__default["default"].createElement(reactTransitionGroup.CSSTransition, { in: visible, mountOnEnter: true, unmountOnExit: true, timeout: duration, classNames: styles }, children);
}

var __defProp$2q = Object.defineProperty;
var __defProps$1y = Object.defineProperties;
var __getOwnPropDescs$1y = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2s = Object.getOwnPropertySymbols;
var __hasOwnProp$2s = Object.prototype.hasOwnProperty;
var __propIsEnum$2s = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2q = (obj, key, value) => key in obj ? __defProp$2q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2q = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2s.call(b, prop))
      __defNormalProp$2q(a, prop, b[prop]);
  if (__getOwnPropSymbols$2s)
    for (var prop of __getOwnPropSymbols$2s(b)) {
      if (__propIsEnum$2s.call(b, prop))
        __defNormalProp$2q(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1y = (a, b) => __defProps$1y(a, __getOwnPropDescs$1y(b));
const getStyles$1P = (theme) => {
  return {
    singleValue: css.css`
      label: singleValue;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      box-sizing: border-box;
      max-width: 100%;
      grid-area: 1 / 1 / 2 / 3;
    `,
    spinnerWrapper: css.css`
      width: 16px;
      height: 16px;
      display: inline-block;
      margin-right: 10px;
      position: relative;
      vertical-align: middle;
      overflow: hidden;
    `,
    spinnerIcon: css.css`
      width: 100%;
      height: 100%;
      position: absolute;
    `,
    optionIcon: css.css`
      margin-right: ${theme.spacing(1)};
      color: ${theme.colors.text.secondary};
    `,
    disabled: css.css`
      color: ${theme.colors.text.disabled};
    `,
    isOpen: css.css`
      color: ${theme.colors.text.disabled};
    `
  };
};
const SingleValue = (props) => {
  var _a;
  const { children, data: data$1, isDisabled } = props;
  const styles = useStyles2(getStyles$1P);
  const loading = useDelayedSwitch(data$1.loading || false, { delay: 250, duration: 750 });
  const icon = data$1.icon ? data.toIconName(data$1.icon) : void 0;
  return /* @__PURE__ */ React__default["default"].createElement(
    ReactSelect.components.SingleValue,
    __spreadProps$1y(__spreadValues$2q({}, props), {
      className: css.cx(styles.singleValue, isDisabled && styles.disabled, props.selectProps.menuIsOpen && styles.isOpen)
    }),
    data$1.imgUrl ? /* @__PURE__ */ React__default["default"].createElement(
      FadeWithImage,
      {
        loading,
        imgUrl: data$1.imgUrl,
        styles,
        alt: (_a = data$1.label) != null ? _a : data$1.value
      }
    ) : /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(SlideOutTransition, { horizontal: true, size: 16, visible: loading, duration: 150 }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.spinnerWrapper }, /* @__PURE__ */ React__default["default"].createElement(Spinner, { className: styles.spinnerIcon, inline: true }))), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, role: "img", className: styles.optionIcon })),
    !data$1.hideText && children
  );
};
const FadeWithImage = (props) => {
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: props.styles.spinnerWrapper }, /* @__PURE__ */ React__default["default"].createElement(FadeTransition, { duration: 150, visible: props.loading }, /* @__PURE__ */ React__default["default"].createElement(Spinner, { className: props.styles.spinnerIcon, inline: true })), /* @__PURE__ */ React__default["default"].createElement(FadeTransition, { duration: 150, visible: !props.loading }, /* @__PURE__ */ React__default["default"].createElement("img", { className: props.styles.spinnerIcon, src: props.imgUrl, alt: props.alt })));
};

var __defProp$2p = Object.defineProperty;
var __defProps$1x = Object.defineProperties;
var __getOwnPropDescs$1x = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2r = Object.getOwnPropertySymbols;
var __hasOwnProp$2r = Object.prototype.hasOwnProperty;
var __propIsEnum$2r = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2p = (obj, key, value) => key in obj ? __defProp$2p(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2p = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2r.call(b, prop))
      __defNormalProp$2p(a, prop, b[prop]);
  if (__getOwnPropSymbols$2r)
    for (var prop of __getOwnPropSymbols$2r(b)) {
      if (__propIsEnum$2r.call(b, prop))
        __defNormalProp$2p(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1x = (a, b) => __defProps$1x(a, __getOwnPropDescs$1x(b));
function resetSelectStyles(theme) {
  return {
    clearIndicator: () => ({}),
    container: () => ({}),
    control: () => ({}),
    dropdownIndicator: () => ({}),
    group: () => ({}),
    groupHeading: () => ({}),
    indicatorsContainer: () => ({}),
    indicatorSeparator: () => ({}),
    input: function(originalStyles) {
      return __spreadProps$1x(__spreadValues$2p({}, originalStyles), {
        color: "inherit",
        margin: 0,
        padding: 0,
        // Set an explicit z-index here to ensure this element always overlays the singleValue
        zIndex: 1
      });
    },
    loadingIndicator: () => ({}),
    loadingMessage: () => ({}),
    menu: () => ({}),
    menuList: ({ maxHeight }) => ({
      maxHeight
    }),
    multiValue: () => ({}),
    multiValueLabel: () => ({}),
    multiValueRemove: () => ({}),
    noOptionsMessage: () => ({}),
    option: () => ({}),
    placeholder: (originalStyles) => __spreadProps$1x(__spreadValues$2p({}, originalStyles), {
      color: theme.colors.text.secondary
    }),
    singleValue: () => ({}),
    valueContainer: () => ({})
  };
}
function useCustomSelectStyles(theme, width) {
  return React.useMemo(() => {
    return __spreadProps$1x(__spreadValues$2p({}, resetSelectStyles(theme)), {
      menuPortal: (base) => {
        return __spreadProps$1x(__spreadValues$2p({}, base), {
          zIndex: theme.zIndex.portal
        });
      },
      //These are required for the menu positioning to function
      menu: ({ top, bottom, position }) => {
        return {
          top,
          bottom,
          position,
          minWidth: "100%",
          zIndex: theme.zIndex.dropdown
        };
      },
      container: () => ({
        width: width ? theme.spacing(width) : "100%",
        display: width === "auto" ? "inline-flex" : "flex"
      }),
      option: (provided, state) => __spreadProps$1x(__spreadValues$2p({}, provided), {
        opacity: state.isDisabled ? 0.5 : 1
      })
    });
  }, [theme, width]);
}

var __defProp$2o = Object.defineProperty;
var __getOwnPropSymbols$2q = Object.getOwnPropertySymbols;
var __hasOwnProp$2q = Object.prototype.hasOwnProperty;
var __propIsEnum$2q = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2o = (obj, key, value) => key in obj ? __defProp$2o(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2o = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2q.call(b, prop))
      __defNormalProp$2o(a, prop, b[prop]);
  if (__getOwnPropSymbols$2q)
    for (var prop of __getOwnPropSymbols$2q(b)) {
      if (__propIsEnum$2q.call(b, prop))
        __defNormalProp$2o(a, prop, b[prop]);
    }
  return a;
};
const SelectOption = (props) => {
  const { children, isSelected, data } = props;
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.Option, __spreadValues$2o({}, props), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option" }, data.imgUrl && /* @__PURE__ */ React__default["default"].createElement("img", { className: "gf-form-select-box__desc-option__img", src: data.imgUrl, alt: "" }), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option__body" }, /* @__PURE__ */ React__default["default"].createElement("div", null, children), data.description && /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option__desc" }, data.description)), isSelected && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check", "aria-hidden": "true" })));
};

var __defProp$2n = Object.defineProperty;
var __getOwnPropSymbols$2p = Object.getOwnPropertySymbols;
var __hasOwnProp$2p = Object.prototype.hasOwnProperty;
var __propIsEnum$2p = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2n = (obj, key, value) => key in obj ? __defProp$2n(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2n = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2p.call(b, prop))
      __defNormalProp$2n(a, prop, b[prop]);
  if (__getOwnPropSymbols$2p)
    for (var prop of __getOwnPropSymbols$2p(b)) {
      if (__propIsEnum$2p.call(b, prop))
        __defNormalProp$2n(a, prop, b[prop]);
    }
  return a;
};
const MenuList = (props) => {
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.MenuList, __spreadValues$2n({}, props), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { autoHide: false, autoHeightMax: "inherit" }, props.children));
};
const _Select = class extends React.PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      options,
      placeholder,
      width,
      value,
      className,
      isDisabled,
      isLoading,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      isMulti,
      autoFocus,
      openMenuOnFocus,
      onBlur,
      maxMenuHeight,
      noOptionsMessage,
      isOpen,
      components: components2,
      tooltipContent,
      tabSelectsValue,
      onCloseMenu,
      onOpenMenu,
      allowCustomValue,
      formatCreateLabel,
      "aria-label": ariaLabel
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    let SelectComponent = ReactSelect__default["default"];
    const creatableOptions = {};
    if (allowCustomValue) {
      SelectComponent = Creatable__default["default"];
      creatableOptions.formatCreateLabel = formatCreateLabel != null ? formatCreateLabel : (input) => input;
    }
    const selectClassNames = classNames__default["default"]("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    const selectComponents = __spreadValues$2n(__spreadValues$2n({}, _Select.defaultProps.components), components2);
    return /* @__PURE__ */ React__default["default"].createElement(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen }, (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ React__default["default"].createElement(
        SelectComponent,
        __spreadValues$2n({
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: selectComponents,
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          isSearchable,
          onChange,
          options,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          isDisabled,
          isLoading,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          noOptionsMessage,
          isMulti,
          backspaceRemovesValue,
          menuIsOpen: isOpen,
          onMenuOpen: onOpenMenuInternal,
          onMenuClose: onCloseMenuInternal,
          tabSelectsValue,
          "aria-label": ariaLabel
        }, creatableOptions)
      );
    });
  }
};
let Select$1 = _Select;
Select$1.contextType = ThemeContext;
Select$1.defaultProps = {
  className: "",
  isDisabled: false,
  isSearchable: true,
  isClearable: false,
  isMulti: false,
  openMenuOnFocus: false,
  autoFocus: false,
  isLoading: false,
  backspaceRemovesValue: true,
  maxMenuHeight: 300,
  tabSelectsValue: true,
  allowCustomValue: false,
  components: {
    Option: SelectOption,
    SingleValue,
    IndicatorsContainer: IndicatorsContainer$1,
    MenuList,
    Group: SelectOptionGroup
  }
};
class AsyncSelect$1 extends React.PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      placeholder,
      width,
      value,
      className,
      loadOptions,
      defaultOptions,
      isLoading,
      loadingMessage,
      noOptionsMessage,
      isDisabled,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      autoFocus,
      onBlur,
      openMenuOnFocus,
      maxMenuHeight,
      isMulti,
      tooltipContent,
      onCloseMenu,
      onOpenMenu,
      isOpen
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    const selectClassNames = classNames__default["default"]("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    return /* @__PURE__ */ React__default["default"].createElement(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen }, (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ React__default["default"].createElement(
        ReactAsyncSelect__default["default"],
        {
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: {
            Option: SelectOption,
            SingleValue,
            IndicatorsContainer: IndicatorsContainer$1,
            NoOptionsMessage
          },
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          onChange,
          loadOptions,
          isLoading,
          defaultOptions,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          loadingMessage,
          noOptionsMessage,
          isDisabled,
          isSearchable,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          isMulti,
          backspaceRemovesValue
        }
      );
    });
  }
}
AsyncSelect$1.contextType = ThemeContext;
AsyncSelect$1.defaultProps = {
  className: "",
  components: {},
  loadingMessage: () => "Loading...",
  isDisabled: false,
  isClearable: false,
  isMulti: false,
  isSearchable: true,
  backspaceRemovesValue: true,
  autoFocus: false,
  openMenuOnFocus: false,
  maxMenuHeight: 300
};
class WrapInTooltip extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      isOpenInternal: false
    };
    this.onOpenMenu = () => {
      const { onOpenMenu } = this.props;
      if (onOpenMenu) {
        onOpenMenu();
      }
      this.setState({ isOpenInternal: true });
    };
    this.onCloseMenu = () => {
      const { onCloseMenu } = this.props;
      if (onCloseMenu) {
        onCloseMenu();
      }
      this.setState({ isOpenInternal: false });
    };
  }
  render() {
    const { children, isOpen, tooltipContent } = this.props;
    const { isOpenInternal } = this.state;
    let showTooltip = void 0;
    if (isOpenInternal || isOpen) {
      showTooltip = false;
    }
    if (tooltipContent) {
      return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { show: showTooltip, content: tooltipContent, placement: "bottom" }, /* @__PURE__ */ React__default["default"].createElement("div", null, children(this.onOpenMenu, this.onCloseMenu)));
    } else {
      return /* @__PURE__ */ React__default["default"].createElement("div", null, children(this.onOpenMenu, this.onCloseMenu));
    }
  }
}

class Switch$1 extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      id: lodash.uniqueId()
    };
    this.internalOnChange = (event) => {
      event.stopPropagation();
      this.props.onChange(event);
    };
  }
  render() {
    const {
      labelClass = "",
      switchClass = "",
      label,
      checked,
      disabled,
      transparent,
      className,
      tooltip,
      tooltipPlacement
    } = this.props;
    const labelId = this.state.id;
    const labelClassName = `gf-form-label ${labelClass} ${transparent ? "gf-form-label--transparent" : ""} pointer`;
    const switchClassName = `gf-form-switch ${switchClass} ${transparent ? "gf-form-switch--transparent" : ""}`;
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-switch-container-react" }, /* @__PURE__ */ React__default["default"].createElement("label", { htmlFor: labelId, className: `gf-form gf-form-switch-container ${className || ""}` }, label && /* @__PURE__ */ React__default["default"].createElement("div", { className: labelClassName }, label, tooltip && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { placement: tooltipPlacement ? tooltipPlacement : "auto", content: tooltip, theme: "info" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-help-icon gf-form-help-icon--right-normal" }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "info-circle", size: "sm", style: { marginLeft: "10px" } })))), /* @__PURE__ */ React__default["default"].createElement("div", { className: switchClassName }, /* @__PURE__ */ React__default["default"].createElement(
      "input",
      {
        disabled,
        id: labelId,
        type: "checkbox",
        checked,
        onChange: this.internalOnChange
      }
    ), /* @__PURE__ */ React__default["default"].createElement("span", { className: "gf-form-switch__slider" }))));
  }
}

const getFocusStyle = (theme) => css.css`
  &:focus {
    ${focusCss(theme)}
  }
`;
const sharedInputStyle = (theme, invalid = false) => {
  const borderColor = invalid ? theme.colors.error.border : theme.components.input.borderColor;
  const borderColorHover = invalid ? theme.colors.error.shade : theme.components.input.borderHover;
  const background = theme.components.input.background;
  const textColor = theme.components.input.text;
  const autoFillBorder = theme.isDark ? "#2e2f35" : "#bab4ca";
  return css.cx(
    inputPadding(theme),
    css.css`
      background: ${background};
      line-height: ${theme.typography.body.lineHeight};
      font-size: ${theme.typography.size.md};
      color: ${textColor};
      border: 1px solid ${borderColor};

      &:-webkit-autofill,
      &:-webkit-autofill:hover {
        /* Welcome to 2005. This is a HACK to get rid od Chromes default autofill styling */
        box-shadow: inset 0 0 0 1px rgba(255, 255, 255, 0), inset 0 0 0 100px ${background}!important;
        -webkit-text-fill-color: ${textColor} !important;
        border-color: ${autoFillBorder};
      }

      &:-webkit-autofill:focus {
        /* Welcome to 2005. This is a HACK to get rid od Chromes default autofill styling */
        box-shadow: 0 0 0 2px ${theme.colors.background.primary}, 0 0 0px 4px ${theme.colors.primary.main},
          inset 0 0 0 1px rgba(255, 255, 255, 0), inset 0 0 0 100px ${background}!important;
        -webkit-text-fill-color: ${textColor} !important;
      }

      &:hover {
        border-color: ${borderColorHover};
      }

      &:focus {
        outline: none;
      }

      &:disabled {
        background-color: ${theme.colors.action.disabledBackground};
        color: ${theme.colors.action.disabledText};
        border: 1px solid ${theme.colors.action.disabledBackground};

        &:hover {
          border-color: ${borderColor};
        }
      }

      &::placeholder {
        color: ${theme.colors.text.disabled};
        opacity: 1;
      }
    `
  );
};
const inputPadding = (theme) => {
  return css.css`
    padding: ${theme.spacing(0, 1, 0, 1)};
  `;
};
const inputSizes = () => {
  return {
    sm: css.css`
      width: ${inputSizesPixels("sm")};
    `,
    md: css.css`
      width: ${inputSizesPixels("md")};
    `,
    lg: css.css`
      width: ${inputSizesPixels("lg")};
    `,
    auto: css.css`
      width: ${inputSizesPixels("auto")};
    `
  };
};
const inputSizesPixels = (size) => {
  switch (size) {
    case "sm":
      return "200px";
    case "md":
      return "320px";
    case "lg":
      return "580px";
    case "auto":
    default:
      return "auto";
  }
};
function getPropertiesForButtonSize(size, theme) {
  switch (size) {
    case "sm":
      return {
        padding: 1,
        fontSize: theme.typography.size.sm,
        height: theme.components.height.sm
      };
    case "lg":
      return {
        padding: 3,
        fontSize: theme.typography.size.lg,
        height: theme.components.height.lg
      };
    case "md":
    default:
      return {
        padding: 2,
        fontSize: theme.typography.size.md,
        height: theme.components.height.md
      };
  }
}

var __defProp$2m = Object.defineProperty;
var __defProps$1w = Object.defineProperties;
var __getOwnPropDescs$1w = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2o = Object.getOwnPropertySymbols;
var __hasOwnProp$2o = Object.prototype.hasOwnProperty;
var __propIsEnum$2o = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2m = (obj, key, value) => key in obj ? __defProp$2m(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2m = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2o.call(b, prop))
      __defNormalProp$2m(a, prop, b[prop]);
  if (__getOwnPropSymbols$2o)
    for (var prop of __getOwnPropSymbols$2o(b)) {
      if (__propIsEnum$2o.call(b, prop))
        __defNormalProp$2m(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1w = (a, b) => __defProps$1w(a, __getOwnPropDescs$1w(b));
var __objRest$16 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2o.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2o)
    for (var prop of __getOwnPropSymbols$2o(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2o.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Button = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, {
      variant = "primary",
      size = "md",
      fill = "solid",
      icon,
      fullWidth,
      children,
      className,
      type = "button",
      tooltip,
      tooltipPlacement
    } = _b, otherProps = __objRest$16(_b, [
      "variant",
      "size",
      "fill",
      "icon",
      "fullWidth",
      "children",
      "className",
      "type",
      "tooltip",
      "tooltipPlacement"
    ]);
    const theme = useTheme2();
    const styles = getButtonStyles({
      theme,
      size,
      variant,
      fill,
      fullWidth,
      iconOnly: !children
    });
    const button = /* @__PURE__ */ React__default["default"].createElement("button", __spreadProps$1w(__spreadValues$2m({ className: css.cx(styles.button, className), type }, otherProps), { ref }), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size, className: styles.icon }), children && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.content }, children));
    if (tooltip) {
      return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: tooltip, placement: tooltipPlacement }, button);
    }
    return button;
  }
);
Button.displayName = "Button";
const LinkButton = React__default["default"].forwardRef(
  (_c, ref) => {
    var _d = _c, {
      variant = "primary",
      size = "md",
      fill = "solid",
      icon,
      fullWidth,
      children,
      className,
      onBlur,
      onFocus,
      disabled,
      tooltip,
      tooltipPlacement
    } = _d, otherProps = __objRest$16(_d, [
      "variant",
      "size",
      "fill",
      "icon",
      "fullWidth",
      "children",
      "className",
      "onBlur",
      "onFocus",
      "disabled",
      "tooltip",
      "tooltipPlacement"
    ]);
    const theme = useTheme2();
    const styles = getButtonStyles({
      theme,
      fullWidth,
      size,
      variant,
      fill,
      iconOnly: !children
    });
    const linkButtonStyles = css.cx(
      styles.button,
      {
        [css.css(styles.disabled, {
          pointerEvents: "none"
        })]: disabled
      },
      className
    );
    const button = /* @__PURE__ */ React__default["default"].createElement("a", __spreadProps$1w(__spreadValues$2m({ className: linkButtonStyles }, otherProps), { tabIndex: disabled ? -1 : 0, ref }), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size, className: styles.icon }), children && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.content }, children));
    if (tooltip) {
      return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: tooltip, placement: tooltipPlacement }, button);
    }
    return button;
  }
);
LinkButton.displayName = "LinkButton";
const getButtonStyles = (props) => {
  const { theme, variant, fill = "solid", size, iconOnly, fullWidth } = props;
  const { height, padding, fontSize } = getPropertiesForButtonSize(size, theme);
  const variantStyles = getPropertiesForVariant(theme, variant, fill);
  const disabledStyles = getPropertiesForDisabled(theme, variant, fill);
  const focusStyle = getFocusStyles(theme);
  const paddingMinusBorder = theme.spacing.gridSize * padding - 1;
  return {
    button: css.css(__spreadProps$1w(__spreadValues$2m(__spreadValues$2m({
      label: "button",
      display: "inline-flex",
      alignItems: "center",
      fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      fontFamily: theme.typography.fontFamily,
      padding: `0 ${paddingMinusBorder}px`,
      height: theme.spacing(height),
      // Deduct border from line-height for perfect vertical centering on windows and linux
      lineHeight: `${theme.spacing.gridSize * height - 2}px`,
      verticalAlign: "middle",
      cursor: "pointer",
      borderRadius: theme.shape.borderRadius(1),
      "&:focus": focusStyle,
      "&:focus-visible": focusStyle,
      "&:focus:not(:focus-visible)": getMouseFocusStyles()
    }, fullWidth && {
      flexGrow: 1,
      justifyContent: "center"
    }), variantStyles), {
      ":disabled": disabledStyles,
      "&[disabled]": disabledStyles
    })),
    disabled: css.css(disabledStyles),
    img: css.css`
      width: 16px;
      height: 16px;
      margin: ${theme.spacing(0, 1, 0, 0.5)};
    `,
    icon: iconOnly ? css.css({
      // Important not to set margin bottom here as it would override internal icon bottom margin
      marginRight: theme.spacing(-padding / 2),
      marginLeft: theme.spacing(-padding / 2)
    }) : css.css({
      marginRight: theme.spacing(padding / 2)
    }),
    content: css.css`
      display: flex;
      flex-direction: row;
      align-items: center;
      white-space: nowrap;
      height: 100%;
    `
  };
};
function getButtonVariantStyles(theme, color, fill) {
  if (fill === "outline") {
    return {
      background: "transparent",
      color: color.text,
      border: `1px solid ${color.border}`,
      transition: theme.transitions.create(["background-color", "border-color", "color"], {
        duration: theme.transitions.duration.short
      }),
      "&:hover": {
        background: data.colorManipulator.alpha(color.main, theme.colors.action.hoverOpacity),
        borderColor: theme.colors.emphasize(color.border, 0.25),
        color: color.text
      }
    };
  }
  if (fill === "text") {
    return {
      background: "transparent",
      color: color.text,
      border: "1px solid transparent",
      transition: theme.transitions.create(["background-color", "color"], {
        duration: theme.transitions.duration.short
      }),
      "&:focus": {
        outline: "none",
        textDecoration: "none"
      },
      "&:hover": {
        background: data.colorManipulator.alpha(color.shade, theme.colors.action.hoverOpacity),
        textDecoration: "none"
      }
    };
  }
  return {
    background: color.main,
    color: color.contrastText,
    border: `1px solid transparent`,
    transition: theme.transitions.create(["background-color", "box-shadow", "border-color", "color"], {
      duration: theme.transitions.duration.short
    }),
    "&:hover": {
      background: color.shade,
      color: color.contrastText,
      boxShadow: theme.shadows.z1
    }
  };
}
function getPropertiesForDisabled(theme, variant, fill) {
  const disabledStyles = {
    cursor: "not-allowed",
    boxShadow: "none",
    color: theme.colors.text.disabled,
    transition: "none"
  };
  if (fill === "text") {
    return __spreadProps$1w(__spreadValues$2m({}, disabledStyles), {
      background: "transparent",
      border: `1px solid transparent`
    });
  }
  if (fill === "outline") {
    return __spreadProps$1w(__spreadValues$2m({}, disabledStyles), {
      background: "transparent",
      border: `1px solid ${theme.colors.action.disabledText}`
    });
  }
  return __spreadProps$1w(__spreadValues$2m({}, disabledStyles), {
    background: theme.colors.action.disabledBackground,
    border: `1px solid transparent`
  });
}
function getPropertiesForVariant(theme, variant, fill) {
  switch (variant) {
    case "secondary":
      return getButtonVariantStyles(theme, theme.colors.secondary, fill);
    case "destructive":
      return getButtonVariantStyles(theme, theme.colors.error, fill);
    case "success":
      return getButtonVariantStyles(theme, theme.colors.success, fill);
    case "primary":
    default:
      return getButtonVariantStyles(theme, theme.colors.primary, fill);
  }
}
const clearButtonStyles = (theme) => {
  return css.css`
    background: transparent;
    color: ${theme.colors.text.primary};
    border: none;
    padding: 0;
  `;
};
const clearLinkButtonStyles = (theme) => {
  return css.css`
    background: transparent;
    border: none;
    padding: 0;
    font-family: inherit;
    color: inherit;
    height: 100%;
    &:hover {
      background: transparent;
      color: inherit;
    }
  `;
};

var __defProp$2l = Object.defineProperty;
var __getOwnPropSymbols$2n = Object.getOwnPropertySymbols;
var __hasOwnProp$2n = Object.prototype.hasOwnProperty;
var __propIsEnum$2n = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2l = (obj, key, value) => key in obj ? __defProp$2l(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2l = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2n.call(b, prop))
      __defNormalProp$2l(a, prop, b[prop]);
  if (__getOwnPropSymbols$2n)
    for (var prop of __getOwnPropSymbols$2n(b)) {
      if (__propIsEnum$2n.call(b, prop))
        __defNormalProp$2l(a, prop, b[prop]);
    }
  return a;
};
var __objRest$15 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2n.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2n)
    for (var prop of __getOwnPropSymbols$2n(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2n.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getSecretFormFieldStyles = () => {
  return {
    noRadiusInput: css.css`
      border-bottom-right-radius: 0 !important;
      border-top-right-radius: 0 !important;
    `,
    noRadiusButton: css.css`
      border-bottom-left-radius: 0 !important;
      border-top-left-radius: 0 !important;
    `
  };
};
const SecretFormField = (_a) => {
  var _b = _a, {
    label = "Password",
    labelWidth,
    inputWidth = 12,
    onReset,
    isConfigured,
    tooltip,
    placeholder = "Password",
    interactive
  } = _b, inputProps = __objRest$15(_b, [
    "label",
    "labelWidth",
    "inputWidth",
    "onReset",
    "isConfigured",
    "tooltip",
    "placeholder",
    "interactive"
  ]);
  const styles = getSecretFormFieldStyles();
  return /* @__PURE__ */ React__default["default"].createElement(
    FormField,
    {
      label,
      tooltip,
      interactive,
      labelWidth,
      inputEl: isConfigured ? /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
        "input",
        __spreadValues$2l({
          type: "text",
          className: css.cx(`gf-form-input width-${inputWidth}`, styles.noRadiusInput),
          disabled: true,
          value: "configured"
        }, lodash.omit(inputProps, "value"))
      ), /* @__PURE__ */ React__default["default"].createElement(Button, { onClick: onReset, variant: "secondary", type: "button" }, "Reset")) : /* @__PURE__ */ React__default["default"].createElement(
        "input",
        __spreadValues$2l({
          type: "password",
          className: `gf-form-input width-${inputWidth}`,
          placeholder
        }, inputProps)
      )
    }
  );
};
SecretFormField.displayName = "SecretFormField";

var __defProp$2k = Object.defineProperty;
var __defProps$1v = Object.defineProperties;
var __getOwnPropDescs$1v = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2m = Object.getOwnPropertySymbols;
var __hasOwnProp$2m = Object.prototype.hasOwnProperty;
var __propIsEnum$2m = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2k = (obj, key, value) => key in obj ? __defProp$2k(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2k = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2m.call(b, prop))
      __defNormalProp$2k(a, prop, b[prop]);
  if (__getOwnPropSymbols$2m)
    for (var prop of __getOwnPropSymbols$2m(b)) {
      if (__propIsEnum$2m.call(b, prop))
        __defNormalProp$2k(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1v = (a, b) => __defProps$1v(a, __getOwnPropDescs$1v(b));
var __objRest$14 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2m.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2m)
    for (var prop of __getOwnPropSymbols$2m(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2m.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const IconButton = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, {
      name,
      size = "md",
      iconType,
      tooltip,
      tooltipPlacement,
      ariaLabel,
      className,
      variant = "secondary"
    } = _b, restProps = __objRest$14(_b, [
      "name",
      "size",
      "iconType",
      "tooltip",
      "tooltipPlacement",
      "ariaLabel",
      "className",
      "variant"
    ]);
    const theme = useTheme2();
    const styles = getStyles$1O(theme, size, variant);
    const tooltipString = typeof tooltip === "string" ? tooltip : "";
    const button = /* @__PURE__ */ React__default["default"].createElement("button", __spreadProps$1v(__spreadValues$2k({ ref, "aria-label": ariaLabel || tooltipString }, restProps), { className: css.cx(styles.button, className) }), /* @__PURE__ */ React__default["default"].createElement(Icon, { name, size, className: styles.icon, type: iconType }));
    if (tooltip) {
      return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: tooltip, placement: tooltipPlacement }, button);
    }
    return button;
  }
);
IconButton.displayName = "IconButton";
const getStyles$1O = stylesFactory((theme, size, variant) => {
  const pixelSize = getSvgSize(size);
  const hoverSize = Math.max(pixelSize / 3, 8);
  let iconColor = theme.colors.text.primary;
  if (variant === "primary") {
    iconColor = theme.colors.primary.text;
  } else if (variant === "destructive") {
    iconColor = theme.colors.error.text;
  }
  return {
    button: css.css`
      width: ${pixelSize}px;
      height: ${pixelSize}px;
      background: transparent;
      border: none;
      color: ${iconColor};
      padding: 0;
      margin: 0;
      outline: none;
      box-shadow: none;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      position: relative;
      border-radius: ${theme.shape.borderRadius()};
      z-index: 0;
      margin-right: ${theme.spacing(0.5)};

      &[disabled],
      &:disabled {
        cursor: not-allowed;
        color: ${theme.colors.action.disabledText};
        opacity: 0.65;
        box-shadow: none;
      }

      &:before {
        content: '';
        display: block;
        opacity: 1;
        position: absolute;
        transition-duration: 0.2s;
        transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
        z-index: -1;
        bottom: -${hoverSize}px;
        left: -${hoverSize}px;
        right: -${hoverSize}px;
        top: -${hoverSize}px;
        background: none;
        border-radius: 50%;
        box-sizing: border-box;
        transform: scale(0);
        transition-property: transform, opacity;
      }

      &:focus,
      &:focus-visible {
        ${getFocusStyles(theme)}
      }

      &:focus:not(:focus-visible) {
        ${getMouseFocusStyles()}
      }

      &:hover {
        color: ${iconColor};

        &:before {
          background-color: ${variant === "secondary" ? theme.colors.action.hover : data.colorManipulator.alpha(iconColor, 0.12)};
          border: none;
          box-shadow: none;
          opacity: 1;
          transform: scale(0.8);
        }
      }
    `,
    icon: css.css`
      vertical-align: baseline;
      display: flex;
    `
  };
});

var __defProp$2j = Object.defineProperty;
var __getOwnPropSymbols$2l = Object.getOwnPropertySymbols;
var __hasOwnProp$2l = Object.prototype.hasOwnProperty;
var __propIsEnum$2l = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2j = (obj, key, value) => key in obj ? __defProp$2j(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2j = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2l.call(b, prop))
      __defNormalProp$2j(a, prop, b[prop]);
  if (__getOwnPropSymbols$2l)
    for (var prop of __getOwnPropSymbols$2l(b)) {
      if (__propIsEnum$2l.call(b, prop))
        __defNormalProp$2j(a, prop, b[prop]);
    }
  return a;
};
var __objRest$13 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2l.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2l)
    for (var prop of __getOwnPropSymbols$2l(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2l.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ButtonGroup = React.forwardRef((_a, ref) => {
  var _b = _a, { className, children } = _b, rest = __objRest$13(_b, ["className", "children"]);
  const styles = useStyles2(getStyles$1N);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2j({ ref, className: css.cx("button-group", styles.wrapper, className) }, rest), children);
});
ButtonGroup.displayName = "ButtonGroup";
const getStyles$1N = (theme) => ({
  wrapper: css.css`
    display: flex;

    > .button-group:not(:first-child) > button,
    > button:not(:first-child) {
      border-top-left-radius: 0;
      border-bottom-left-radius: 0;
    }

    > .button-group:not(:last-child) > button,
    > button:not(:last-child) {
      border-top-right-radius: 0;
      border-bottom-right-radius: 0;
      border-right-width: 0;
    }
  `
});

class UnThemedConfirmButton extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.mainButtonRef = React__default["default"].createRef();
    this.confirmButtonRef = React__default["default"].createRef();
    this.state = {
      showConfirm: false
    };
    this.onClickButton = (event) => {
      if (event) {
        event.preventDefault();
      }
      this.setState(
        {
          showConfirm: true
        },
        () => {
          if (this.props.autoFocus && this.confirmButtonRef.current) {
            this.confirmButtonRef.current.focus();
          }
        }
      );
      if (this.props.onClick) {
        this.props.onClick();
      }
    };
    this.onClickCancel = (event) => {
      if (event) {
        event.preventDefault();
      }
      this.setState(
        {
          showConfirm: false
        },
        () => {
          var _a;
          (_a = this.mainButtonRef.current) == null ? void 0 : _a.focus();
        }
      );
      if (this.props.onCancel) {
        this.props.onCancel();
      }
    };
    this.onConfirm = (event) => {
      if (event) {
        event.preventDefault();
      }
      this.props.onConfirm();
      if (this.props.closeOnConfirm) {
        this.setState({
          showConfirm: false
        });
      }
    };
  }
  render() {
    const {
      theme,
      className,
      size,
      disabled,
      confirmText,
      confirmVariant: confirmButtonVariant,
      children
    } = this.props;
    const styles = getStyles$1M(theme);
    const buttonClass = css.cx(
      className,
      this.state.showConfirm ? styles.buttonHide : styles.buttonShow,
      disabled && styles.buttonDisabled
    );
    const confirmButtonClass = css.cx(
      styles.confirmButton,
      this.state.showConfirm ? styles.confirmButtonShow : styles.confirmButtonHide
    );
    const onClick = disabled ? () => {
    } : this.onClickButton;
    return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.buttonContainer }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(disabled && styles.disabled) }, typeof children === "string" ? /* @__PURE__ */ React__default["default"].createElement("span", { className: buttonClass }, /* @__PURE__ */ React__default["default"].createElement(Button, { size, fill: "text", onClick, ref: this.mainButtonRef }, children)) : /* @__PURE__ */ React__default["default"].createElement("span", { className: buttonClass, onClick }, children)), /* @__PURE__ */ React__default["default"].createElement("span", { className: confirmButtonClass }, /* @__PURE__ */ React__default["default"].createElement(Button, { size, variant: confirmButtonVariant, onClick: this.onConfirm, ref: this.confirmButtonRef }, confirmText), /* @__PURE__ */ React__default["default"].createElement(Button, { size, fill: "text", onClick: this.onClickCancel }, "Cancel")));
  }
}
const ConfirmButton = withTheme2(UnThemedConfirmButton);
const getStyles$1M = stylesFactory((theme) => {
  return {
    buttonContainer: css.css`
      display: flex;
      align-items: center;
      justify-content: flex-end;
    `,
    buttonDisabled: css.css`
      text-decoration: none;
      color: ${theme.colors.text.primary};
      opacity: 0.65;
      pointer-events: none;
    `,
    buttonShow: css.css`
      opacity: 1;
      transition: opacity 0.1s ease;
      z-index: 2;
    `,
    buttonHide: css.css`
      opacity: 0;
      transition: opacity 0.1s ease, visibility 0 0.1s;
      visibility: hidden;
      z-index: 0;
    `,
    confirmButton: css.css`
      align-items: flex-start;
      background: ${theme.colors.background.primary};
      display: flex;
      position: absolute;
      pointer-events: none;
    `,
    confirmButtonShow: css.css`
      z-index: 1;
      opacity: 1;
      transition: opacity 0.08s ease-out, transform 0.1s ease-out;
      transform: translateX(0);
      pointer-events: all;
    `,
    confirmButtonHide: css.css`
      opacity: 0;
      visibility: hidden;
      transition: opacity 0.12s ease-in, transform 0.14s ease-in, visibility 0s 0.12s;
      transform: translateX(100px);
    `,
    disabled: css.css`
      cursor: not-allowed;
    `
  };
});
ConfirmButton.defaultProps = {
  size: "md",
  confirmText: "Save",
  disabled: false,
  confirmVariant: "primary"
};
ConfirmButton.displayName = "ConfirmButton";

const DeleteButton = ({ size, disabled, onConfirm, "aria-label": ariaLabel, closeOnConfirm }) => {
  return /* @__PURE__ */ React__default["default"].createElement(
    ConfirmButton,
    {
      confirmText: "Delete",
      confirmVariant: "destructive",
      size: size || "md",
      disabled,
      onConfirm,
      closeOnConfirm
    },
    /* @__PURE__ */ React__default["default"].createElement(Button, { "aria-label": ariaLabel, variant: "destructive", icon: "times", size: size || "sm" })
  );
};

var __defProp$2i = Object.defineProperty;
var __getOwnPropSymbols$2k = Object.getOwnPropertySymbols;
var __hasOwnProp$2k = Object.prototype.hasOwnProperty;
var __propIsEnum$2k = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2i = (obj, key, value) => key in obj ? __defProp$2i(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2i = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2k.call(b, prop))
      __defNormalProp$2i(a, prop, b[prop]);
  if (__getOwnPropSymbols$2k)
    for (var prop of __getOwnPropSymbols$2k(b)) {
      if (__propIsEnum$2k.call(b, prop))
        __defNormalProp$2i(a, prop, b[prop]);
    }
  return a;
};
const defaultTransitionStyles = {
  transitionProperty: "opacity",
  transitionDuration: "200ms",
  transitionTimingFunction: "linear",
  opacity: 0
};
const transitionStyles = {
  exited: { opacity: 0 },
  entering: { opacity: 0 },
  entered: { opacity: 1, transitionDelay: "0s" },
  exiting: { opacity: 0, transitionDelay: "500ms" }
};
class Popover extends React.PureComponent {
  render() {
    const {
      content,
      show,
      placement,
      onMouseEnter,
      onMouseLeave,
      className,
      wrapperClassName,
      renderArrow,
      referenceElement,
      onKeyDown
    } = this.props;
    return /* @__PURE__ */ React__default["default"].createElement(reactPopper.Manager, null, /* @__PURE__ */ React__default["default"].createElement(Transition__default["default"], { in: show, timeout: 100, mountOnEnter: true, unmountOnExit: true }, (transitionState) => {
      return /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(
        reactPopper.Popper,
        {
          placement,
          referenceElement,
          modifiers: [
            { name: "preventOverflow", enabled: true, options: { rootBoundary: "viewport" } },
            {
              name: "eventListeners",
              options: { scroll: true, resize: true }
            }
          ]
        },
        ({ ref, style, placement: placement2, arrowProps, update }) => {
          return /* @__PURE__ */ React__default["default"].createElement(
            "div",
            {
              onMouseEnter,
              onMouseLeave,
              onKeyDown,
              ref,
              style: __spreadValues$2i(__spreadValues$2i(__spreadValues$2i({}, style), defaultTransitionStyles), transitionStyles[transitionState]),
              "data-placement": placement2,
              className: `${wrapperClassName}`
            },
            /* @__PURE__ */ React__default["default"].createElement("div", { className }, typeof content === "string" && content, React__default["default"].isValidElement(content) && React__default["default"].cloneElement(content), typeof content === "function" && content({
              updatePopperPosition: update
            }), renderArrow && renderArrow({
              arrowProps,
              placement: placement2
            }))
          );
        }
      ));
    }));
  }
}

var __defProp$2h = Object.defineProperty;
var __getOwnPropSymbols$2j = Object.getOwnPropertySymbols;
var __hasOwnProp$2j = Object.prototype.hasOwnProperty;
var __propIsEnum$2j = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2h = (obj, key, value) => key in obj ? __defProp$2h(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2h = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2j.call(b, prop))
      __defNormalProp$2h(a, prop, b[prop]);
  if (__getOwnPropSymbols$2j)
    for (var prop of __getOwnPropSymbols$2j(b)) {
      if (__propIsEnum$2j.call(b, prop))
        __defNormalProp$2h(a, prop, b[prop]);
    }
  return a;
};
const Toggletip = React__default["default"].memo(
  ({
    children,
    theme = "info",
    placement = "auto",
    content,
    title,
    closeButton = true,
    onClose,
    footer
  }) => {
    const styles = useStyles2(getStyles$1L);
    const style = styles[theme];
    const contentRef = React.useRef(null);
    const [controlledVisible, setControlledVisible] = React__default["default"].useState(false);
    const closeToggletip = React.useCallback(() => {
      setControlledVisible(false);
      onClose == null ? void 0 : onClose();
    }, [onClose]);
    React.useEffect(() => {
      if (controlledVisible) {
        const handleKeyDown = (enterKey) => {
          if (enterKey.key === "Escape") {
            closeToggletip();
          }
        };
        document.addEventListener("keydown", handleKeyDown);
        return () => {
          document.removeEventListener("keydown", handleKeyDown);
        };
      }
      return;
    }, [controlledVisible, closeToggletip]);
    const { getArrowProps, getTooltipProps, setTooltipRef, setTriggerRef, visible, update } = reactPopperTooltip.usePopperTooltip({
      visible: controlledVisible,
      placement,
      interactive: true,
      offset: [0, 8],
      trigger: "click",
      onVisibleChange: (value) => {
        setControlledVisible(value);
        if (!value) {
          onClose == null ? void 0 : onClose();
        }
      }
    });
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, React__default["default"].cloneElement(children, {
      ref: setTriggerRef,
      tabIndex: 0
    }), visible && /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(
      "div",
      __spreadValues$2h({
        "data-testid": "toggletip-content",
        ref: setTooltipRef
      }, getTooltipProps({ className: style.container })),
      Boolean(title) && /* @__PURE__ */ React__default["default"].createElement("div", { className: style.header }, title),
      closeButton && /* @__PURE__ */ React__default["default"].createElement("div", { className: style.headerClose }, /* @__PURE__ */ React__default["default"].createElement(
        IconButton,
        {
          "aria-label": "Close Toggletip",
          name: "times",
          size: "md",
          "data-testid": "toggletip-header-close",
          onClick: closeToggletip
        }
      )),
      /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2h({ ref: contentRef }, getArrowProps({ className: style.arrow }))),
      /* @__PURE__ */ React__default["default"].createElement("div", { className: style.body }, (typeof content === "string" || React__default["default"].isValidElement(content)) && content, typeof content === "function" && update && content({ update })),
      Boolean(footer) && /* @__PURE__ */ React__default["default"].createElement("div", { className: style.footer }, footer)
    )));
  }
);
Toggletip.displayName = "Toggletip";
const getStyles$1L = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.components.tooltip.background,
    theme.components.tooltip.background,
    theme.components.tooltip.text,
    { topBottom: 3, rightLeft: 3 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 3, rightLeft: 3 }
  );
  return {
    info,
    error
  };
};

const getStyles$1K = stylesFactory((theme) => {
  return {
    container: css.css`
      height: 100%;
    `,
    tabContent: css.css`
      padding: ${theme.spacing(2)};
      background-color: ${theme.colors.background.primary};
      height: calc(100% - ${theme.components.menuTabs.height}px);
    `,
    close: css.css`
      position: absolute;
      right: 16px;
      top: 5px;
      cursor: pointer;
      font-size: ${theme.typography.size.lg};
    `,
    tabs: css.css`
      padding-top: ${theme.spacing(1)};
      border-color: ${theme.colors.border.weak};
      ul {
        margin-left: ${theme.spacing(2)};
      }
    `
  };
});
function TabbedContainer(props) {
  var _a, _b;
  const [activeTab, setActiveTab] = React.useState(
    props.tabs.some((tab) => tab.value === props.defaultTab) ? props.defaultTab : (_a = props.tabs) == null ? void 0 : _a[0].value
  );
  const onSelectTab = (item) => {
    setActiveTab(item.value);
  };
  const { tabs, onClose, closeIconTooltip } = props;
  const theme = useTheme2();
  const styles = getStyles$1K(theme);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement(TabsBar, { className: styles.tabs }, tabs.map((t) => /* @__PURE__ */ React__default["default"].createElement(
    Tab,
    {
      key: t.value,
      label: t.label,
      active: t.value === activeTab,
      onChangeTab: () => onSelectTab(t),
      icon: t.icon
    }
  )), /* @__PURE__ */ React__default["default"].createElement(IconButton, { className: styles.close, onClick: onClose, name: "times", title: closeIconTooltip != null ? closeIconTooltip : "Close" })), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { autoHeightMin: "100%" }, /* @__PURE__ */ React__default["default"].createElement(TabContent, { className: styles.tabContent }, (_b = tabs.find((t) => t.value === activeTab)) == null ? void 0 : _b.content)));
}

var __defProp$2g = Object.defineProperty;
var __getOwnPropSymbols$2i = Object.getOwnPropertySymbols;
var __hasOwnProp$2i = Object.prototype.hasOwnProperty;
var __propIsEnum$2i = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2g = (obj, key, value) => key in obj ? __defProp$2g(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2g = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2i.call(b, prop))
      __defNormalProp$2g(a, prop, b[prop]);
  if (__getOwnPropSymbols$2i)
    for (var prop of __getOwnPropSymbols$2i(b)) {
      if (__propIsEnum$2i.call(b, prop))
        __defNormalProp$2g(a, prop, b[prop]);
    }
  return a;
};
function initI18n() {
  if (!i18next__default["default"].options.lng) {
    i18next__default["default"].use(reactI18next.initReactI18next).init({
      resources: {},
      returnEmptyString: false,
      lng: "en-US"
      // this should be the locale of the phrases in our source JSX
    });
  }
}
const Trans = (props) => {
  initI18n();
  return /* @__PURE__ */ React__default["default"].createElement(reactI18next.Trans, __spreadValues$2g({}, props));
};
const tFunc = i18next__default["default"].t;
const t = (id, defaultMessage, values) => {
  initI18n();
  return tFunc(id, defaultMessage, values);
};

var __defProp$2f = Object.defineProperty;
var __defProps$1u = Object.defineProperties;
var __getOwnPropDescs$1u = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2h = Object.getOwnPropertySymbols;
var __hasOwnProp$2h = Object.prototype.hasOwnProperty;
var __propIsEnum$2h = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2f = (obj, key, value) => key in obj ? __defProp$2f(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2f = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2h.call(b, prop))
      __defNormalProp$2f(a, prop, b[prop]);
  if (__getOwnPropSymbols$2h)
    for (var prop of __getOwnPropSymbols$2h(b)) {
      if (__propIsEnum$2h.call(b, prop))
        __defNormalProp$2f(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1u = (a, b) => __defProps$1u(a, __getOwnPropDescs$1u(b));
function InlineToast({ referenceElement, children, suffixIcon, placement }) {
  const [indicatorElement, setIndicatorElement] = React.useState(null);
  const popper = reactPopper.usePopper(referenceElement, indicatorElement, { placement });
  const styles = useStyles2(getStyles$1J);
  const placementStyles = useStyles2(getPlacementStyles);
  return /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(
    "div",
    __spreadProps$1u(__spreadValues$2f({
      style: __spreadValues$2f({ display: "inline-block" }, popper.styles.popper)
    }, popper.attributes.popper), {
      ref: setIndicatorElement
    }),
    /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx(styles.root, placementStyles[placement]) }, children && /* @__PURE__ */ React__default["default"].createElement("span", null, children), suffixIcon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: suffixIcon }))
  ));
}
const getStyles$1J = (theme) => {
  return {
    root: css.css(__spreadProps$1u(__spreadValues$2f({}, theme.typography.bodySmall), {
      willChange: "transform",
      background: theme.components.tooltip.background,
      color: theme.components.tooltip.text,
      padding: theme.spacing(0.5, 1.5),
      // get's an extra .5 of vertical padding to account for the rounded corners
      borderRadius: 100,
      // just a sufficiently large value to ensure ends are completely rounded
      display: "inline-flex",
      gap: theme.spacing(0.5),
      alignItems: "center"
    }))
  };
};
const createAnimation = (fromX, fromY) => css.keyframes({
  from: {
    opacity: 0,
    transform: `translate(${fromX}, ${fromY})`
  },
  to: {
    opacity: 1,
    transform: "translate(0, 0px)"
  }
});
const getPlacementStyles = (theme) => {
  const gap = 1;
  const placementTopAnimation = createAnimation(0, theme.spacing(gap));
  const placementBottomAnimation = createAnimation(0, theme.spacing(gap * -1));
  const placementLeftAnimation = createAnimation(theme.spacing(gap), 0);
  const placementRightAnimation = createAnimation(theme.spacing(gap * -1), 0);
  return {
    top: css.css({
      marginBottom: theme.spacing(gap),
      animation: `${placementTopAnimation} ease-out 100ms`
    }),
    bottom: css.css({
      marginTop: theme.spacing(gap),
      animation: `${placementBottomAnimation} ease-out 100ms`
    }),
    left: css.css({
      marginRight: theme.spacing(gap),
      animation: `${placementLeftAnimation} ease-out 100ms`
    }),
    right: css.css({
      marginLeft: theme.spacing(gap),
      animation: `${placementRightAnimation} ease-out 100ms`
    })
  };
};

var __defProp$2e = Object.defineProperty;
var __defProps$1t = Object.defineProperties;
var __getOwnPropDescs$1t = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2g = Object.getOwnPropertySymbols;
var __hasOwnProp$2g = Object.prototype.hasOwnProperty;
var __propIsEnum$2g = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2e = (obj, key, value) => key in obj ? __defProp$2e(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2e = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2g.call(b, prop))
      __defNormalProp$2e(a, prop, b[prop]);
  if (__getOwnPropSymbols$2g)
    for (var prop of __getOwnPropSymbols$2g(b)) {
      if (__propIsEnum$2g.call(b, prop))
        __defNormalProp$2e(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1t = (a, b) => __defProps$1t(a, __getOwnPropDescs$1t(b));
var __objRest$12 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2g.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2g)
    for (var prop of __getOwnPropSymbols$2g(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2g.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SHOW_SUCCESS_DURATION = 2 * 1e3;
function ClipboardButton(_a) {
  var _b = _a, {
    onClipboardCopy,
    onClipboardError,
    children,
    getText,
    icon,
    variant
  } = _b, buttonProps = __objRest$12(_b, [
    "onClipboardCopy",
    "onClipboardError",
    "children",
    "getText",
    "icon",
    "variant"
  ]);
  const styles = useStyles2(getStyles$1I);
  const [showCopySuccess, setShowCopySuccess] = React.useState(false);
  React.useEffect(() => {
    let timeoutId;
    if (showCopySuccess) {
      timeoutId = setTimeout(() => {
        setShowCopySuccess(false);
      }, SHOW_SUCCESS_DURATION);
    }
    return () => {
      window.clearTimeout(timeoutId);
    };
  }, [showCopySuccess]);
  const buttonRef = React.useRef(null);
  const copyTextCallback = React.useCallback(async () => {
    const textToCopy = getText();
    try {
      await copyText(textToCopy, buttonRef);
      setShowCopySuccess(true);
      onClipboardCopy == null ? void 0 : onClipboardCopy(textToCopy);
    } catch (e) {
      onClipboardError == null ? void 0 : onClipboardError(textToCopy, e);
    }
  }, [getText, onClipboardCopy, onClipboardError]);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, showCopySuccess && /* @__PURE__ */ React__default["default"].createElement(InlineToast, { placement: "top", referenceElement: buttonRef.current }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "clipboard-button.inline-toast.success" }, "Copied")), /* @__PURE__ */ React__default["default"].createElement(
    Button,
    __spreadProps$1t(__spreadValues$2e({
      onClick: copyTextCallback,
      icon,
      variant: showCopySuccess ? "success" : variant,
      "aria-label": showCopySuccess ? "Copied" : void 0
    }, buttonProps), {
      className: css.cx(styles.button, showCopySuccess && styles.successButton),
      ref: buttonRef
    }),
    children,
    showCopySuccess && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.successOverlay }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check" }))
  ));
}
const copyText = async (text, buttonRef) => {
  var _a;
  if (navigator.clipboard && window.isSecureContext) {
    return navigator.clipboard.writeText(text);
  } else {
    const textarea = document.createElement("textarea");
    (_a = buttonRef.current) == null ? void 0 : _a.appendChild(textarea);
    textarea.value = text;
    textarea.focus();
    textarea.select();
    document.execCommand("copy");
    textarea.remove();
  }
};
const getStyles$1I = (theme) => {
  return {
    button: css.css({
      position: "relative"
    }),
    successButton: css.css({
      "> *": css.css({
        visibility: "hidden"
      })
    }),
    successOverlay: css.css({
      position: "absolute",
      top: 0,
      bottom: 0,
      right: 0,
      left: 0,
      visibility: "visible"
      // re-visible the overlay
    })
  };
};

var __defProp$2d = Object.defineProperty;
var __defProps$1s = Object.defineProperties;
var __getOwnPropDescs$1s = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2f = Object.getOwnPropertySymbols;
var __hasOwnProp$2f = Object.prototype.hasOwnProperty;
var __propIsEnum$2f = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2d = (obj, key, value) => key in obj ? __defProp$2d(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2d = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2f.call(b, prop))
      __defNormalProp$2d(a, prop, b[prop]);
  if (__getOwnPropSymbols$2f)
    for (var prop of __getOwnPropSymbols$2f(b)) {
      if (__propIsEnum$2f.call(b, prop))
        __defNormalProp$2d(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1s = (a, b) => __defProps$1s(a, __getOwnPropDescs$1s(b));
var __objRest$11 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2f.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2f)
    for (var prop of __getOwnPropSymbols$2f(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2f.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Input = React__default["default"].forwardRef((props, ref) => {
  const _a = props, { className, addonAfter, addonBefore, prefix, suffix, invalid, loading, width = 0 } = _a, restProps = __objRest$11(_a, ["className", "addonAfter", "addonBefore", "prefix", "suffix", "invalid", "loading", "width"]);
  const [prefixRef, prefixRect] = useMeasure__default["default"]();
  const [suffixRef, suffixRect] = useMeasure__default["default"]();
  const theme = useTheme2();
  const styles = getInputStyles({ theme, invalid: !!invalid, width });
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.wrapper, className), "data-testid": "input-wrapper" }, !!addonBefore && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.addon }, addonBefore), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.inputWrapper }, prefix && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.prefix, ref: prefixRef }, prefix), /* @__PURE__ */ React__default["default"].createElement(
    "input",
    __spreadProps$1s(__spreadValues$2d({
      ref,
      className: styles.input
    }, restProps), {
      style: {
        paddingLeft: prefix ? prefixRect.width + 12 : void 0,
        paddingRight: suffix || loading ? suffixRect.width + 12 : void 0
      }
    })
  ), (suffix || loading) && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.suffix, ref: suffixRef }, loading && /* @__PURE__ */ React__default["default"].createElement(Spinner, { className: styles.loadingIndicator, inline: true }), suffix)), !!addonAfter && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.addon }, addonAfter));
});
Input.displayName = "Input";
const getInputStyles = stylesFactory(({ theme, invalid = false, width }) => {
  const prefixSuffixStaticWidth = "28px";
  const prefixSuffix = css.css`
    position: absolute;
    top: 0;
    z-index: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-grow: 0;
    flex-shrink: 0;
    font-size: ${theme.typography.size.md};
    height: 100%;
    /* Min width specified for prefix/suffix classes used outside React component*/
    min-width: ${prefixSuffixStaticWidth};
    color: ${theme.colors.text.secondary};
  `;
  return {
    // Wraps inputWrapper and addons
    wrapper: css.cx(
      css.css`
        label: input-wrapper;
        display: flex;
        width: ${width ? `${theme.spacing(width)}` : "100%"};
        height: ${theme.spacing(theme.components.height.md)};
        border-radius: ${theme.shape.borderRadius()};
        &:hover {
          > .prefix,
          .suffix,
          .input {
            border-color: ${invalid ? theme.colors.error.border : theme.colors.primary.border};
          }

          // only show number buttons on hover
          input[type='number'] {
            -moz-appearance: number-input;
            -webkit-appearance: number-input;
            appearance: textfield;
          }

          input[type='number']::-webkit-inner-spin-button,
          input[type='number']::-webkit-outer-spin-button {
            -webkit-appearance: inner-spin-button !important;
            opacity: 1;
          }
        }
      `
    ),
    // Wraps input and prefix/suffix
    inputWrapper: css.css`
      label: input-inputWrapper;
      position: relative;
      flex-grow: 1;
      /* we want input to be above addons, especially for focused state */
      z-index: 1;

      /* when input rendered with addon before only*/
      &:not(:first-child):last-child {
        > input {
          border-left: none;
          border-top-left-radius: 0;
          border-bottom-left-radius: 0;
        }
      }

      /* when input rendered with addon after only*/
      &:first-child:not(:last-child) {
        > input {
          border-right: none;
          border-top-right-radius: 0;
          border-bottom-right-radius: 0;
        }
      }

      /* when rendered with addon before and after */
      &:not(:first-child):not(:last-child) {
        > input {
          border-right: none;
          border-top-right-radius: 0;
          border-bottom-right-radius: 0;
          border-top-left-radius: 0;
          border-bottom-left-radius: 0;
        }
      }

      input {
        /* paddings specified for classes used outside React component */
        &:not(:first-child) {
          padding-left: ${prefixSuffixStaticWidth};
        }
        &:not(:last-child) {
          padding-right: ${prefixSuffixStaticWidth};
        }
        &[readonly] {
          cursor: default;
        }
      }
    `,
    input: css.cx(
      getFocusStyle(theme),
      sharedInputStyle(theme, invalid),
      css.css`
        label: input-input;
        position: relative;
        z-index: 0;
        flex-grow: 1;
        border-radius: ${theme.shape.borderRadius()};
        height: 100%;
        width: 100%;
      `
    ),
    inputDisabled: css.css`
      background-color: ${theme.colors.action.disabledBackground};
      color: ${theme.colors.action.disabledText};
      border: 1px solid ${theme.colors.action.disabledBackground};
      &:focus {
        box-shadow: none;
      }
    `,
    addon: css.css`
      label: input-addon;
      display: flex;
      justify-content: center;
      align-items: center;
      flex-grow: 0;
      flex-shrink: 0;
      position: relative;

      &:first-child {
        border-top-right-radius: 0;
        border-bottom-right-radius: 0;
        > :last-child {
          border-top-right-radius: 0;
          border-bottom-right-radius: 0;
        }
      }

      &:last-child {
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
        > :first-child {
          border-top-left-radius: 0;
          border-bottom-left-radius: 0;
        }
      }
      > *:focus {
        /* we want anything that has focus and is an addon to be above input */
        z-index: 2;
      }
    `,
    prefix: css.cx(
      prefixSuffix,
      css.css`
        label: input-prefix;
        padding-left: ${theme.spacing(1)};
        padding-right: ${theme.spacing(0.5)};
        border-right: none;
        border-top-right-radius: 0;
        border-bottom-right-radius: 0;
      `
    ),
    suffix: css.cx(
      prefixSuffix,
      css.css`
        label: input-suffix;
        padding-left: ${theme.spacing(1)};
        padding-right: ${theme.spacing(1)};
        margin-bottom: -2px;
        border-left: none;
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
        right: 0;
      `
    ),
    loadingIndicator: css.css`
      & + * {
        margin-left: ${theme.spacing(0.5)};
      }
    `
  };
});

const DropdownIndicator = ({ isOpen }) => {
  const icon = isOpen ? "search" : "angle-down";
  const size = isOpen ? "sm" : "md";
  return /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size });
};

const IndicatorsContainer = React__default["default"].forwardRef((props, ref) => {
  const { children } = props;
  const theme = useTheme2();
  const styles = getInputStyles({ theme, invalid: false });
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(
        styles.suffix,
        css.css`
          position: relative;
        `
      ),
      ref
    },
    children
  );
});
IndicatorsContainer.displayName = "IndicatorsContainer";

var __defProp$2c = Object.defineProperty;
var __defProps$1r = Object.defineProperties;
var __getOwnPropDescs$1r = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2e = Object.getOwnPropertySymbols;
var __hasOwnProp$2e = Object.prototype.hasOwnProperty;
var __propIsEnum$2e = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2c = (obj, key, value) => key in obj ? __defProp$2c(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2c = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2e.call(b, prop))
      __defNormalProp$2c(a, prop, b[prop]);
  if (__getOwnPropSymbols$2e)
    for (var prop of __getOwnPropSymbols$2e(b)) {
      if (__propIsEnum$2e.call(b, prop))
        __defNormalProp$2c(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1r = (a, b) => __defProps$1r(a, __getOwnPropDescs$1r(b));
var __objRest$10 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2e.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2e)
    for (var prop of __getOwnPropSymbols$2e(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2e.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getInputControlStyles = stylesFactory((theme, invalid, withPrefix) => {
  const styles = getInputStyles({ theme, invalid });
  return {
    input: css.cx(
      inputPadding(theme),
      css.css`
        width: 100%;
        max-width: 100%;
        display: flex;
        flex-direction: row;
        align-items: center;
        flex-wrap: wrap;
        justify-content: space-between;
        padding-right: 0;
        position: relative;
        box-sizing: border-box;
      `,
      withPrefix && css.css`
          padding-left: 0;
        `
    ),
    prefix: css.cx(
      styles.prefix,
      css.css`
        position: relative;
      `
    )
  };
});
const InputControl$1 = React__default["default"].forwardRef(
  function InputControl2(_a, ref) {
    var _b = _a, { focused, invalid, disabled, children, innerProps, prefix } = _b; __objRest$10(_b, ["focused", "invalid", "disabled", "children", "innerProps", "prefix"]);
    const theme = useTheme2();
    const styles = getInputControlStyles(theme, invalid, !!prefix);
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1r(__spreadValues$2c({ className: styles.input }, innerProps), { ref }), prefix && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.prefix) }, prefix), children);
  }
);

const getSelectStyles = stylesFactory((theme) => {
  return {
    menu: css.css`
      label: grafana-select-menu;
      background: ${theme.components.dropdown.background};
      box-shadow: ${theme.shadows.z3};
      position: relative;
      min-width: 100%;
      z-index: 1;
    `,
    option: css.css`
      label: grafana-select-option;
      padding: 8px;
      display: flex;
      align-items: center;
      flex-direction: row;
      flex-shrink: 0;
      white-space: nowrap;
      cursor: pointer;
      border-left: 2px solid transparent;

      &:hover {
        background: ${theme.colors.action.hover};
      }
    `,
    optionIcon: css.css`
      margin-right: ${theme.spacing(1)};
    `,
    optionImage: css.css`
      label: grafana-select-option-image;
      width: 16px;
      margin-right: 10px;
    `,
    optionDescription: css.css`
      label: grafana-select-option-description;
      font-weight: normal;
      font-size: ${theme.typography.size.sm};
      color: ${theme.colors.text.secondary};
      white-space: normal;
      line-height: ${theme.typography.body.lineHeight};
    `,
    optionBody: css.css`
      label: grafana-select-option-body;
      display: flex;
      font-weight: ${theme.typography.fontWeightMedium};
      flex-direction: column;
      flex-grow: 1;
    `,
    optionFocused: css.css`
      label: grafana-select-option-focused;
      background: ${theme.colors.action.focus};
    `,
    optionSelected: css.css`
      background: ${theme.colors.action.selected};
    `,
    optionDisabled: css.css`
      label: grafana-select-option-disabled;
      background-color: ${theme.colors.action.disabledBackground};
      color: ${theme.colors.action.disabledText};
      cursor: not-allowed;
    `,
    singleValue: css.css`
      label: grafana-select-single-value;
      color: ${theme.components.input.text};
      grid-area: 1 / 1 / 2 / 3;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      box-sizing: border-box;
      max-width: 100%;
    `,
    valueContainer: css.css`
      label: grafana-select-value-container;
      align-items: center;
      display: grid;
      position: relative;
      box-sizing: border-box;
      flex: 1 1 0%;
      outline: none;
      overflow: hidden;
    `,
    valueContainerMulti: css.css`
      label: grafana-select-value-container-multi;
      flex-wrap: wrap;
      display: flex;
    `,
    loadingMessage: css.css`
      label: grafana-select-loading-message;
      padding: ${theme.spacing(1)};
      text-align: center;
      width: 100%;
    `,
    multiValueContainer: css.css`
      label: grafana-select-multi-value-container;
      display: flex;
      align-items: center;
      line-height: 1;
      background: ${theme.colors.background.secondary};
      border-radius: ${theme.shape.borderRadius()};
      margin: ${theme.spacing(0.25, 1, 0.25, 0)};
      padding: ${theme.spacing(0.25, 0, 0.25, 1)};
      color: ${theme.colors.text.primary};
      font-size: ${theme.typography.size.sm};

      &:hover {
        background: ${theme.colors.emphasize(theme.colors.background.secondary)};
      }
    `,
    multiValueRemove: css.css`
      label: grafana-select-multi-value-remove;
      margin: ${theme.spacing(0, 0.5)};
      cursor: pointer;
      svg {
        margin-bottom: 0;
      }
    `,
    singleValueRemove: css.css`
      cursor: pointer;
      &:hover {
        color: ${theme.colors.text.primary};
      }
    `
  };
});

var __defProp$2b = Object.defineProperty;
var __defProps$1q = Object.defineProperties;
var __getOwnPropDescs$1q = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2d = Object.getOwnPropertySymbols;
var __hasOwnProp$2d = Object.prototype.hasOwnProperty;
var __propIsEnum$2d = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2b = (obj, key, value) => key in obj ? __defProp$2b(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2b = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2d.call(b, prop))
      __defNormalProp$2b(a, prop, b[prop]);
  if (__getOwnPropSymbols$2d)
    for (var prop of __getOwnPropSymbols$2d(b)) {
      if (__propIsEnum$2d.call(b, prop))
        __defNormalProp$2b(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1q = (a, b) => __defProps$1q(a, __getOwnPropDescs$1q(b));
const MultiValueContainer = ({ innerProps, children }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1q(__spreadValues$2b({}, innerProps), { className: styles.multiValueContainer }), children);
};
const MultiValueRemove = ({ children, innerProps }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ React__default["default"].createElement(IconButton, __spreadProps$1q(__spreadValues$2b({}, innerProps), { name: "times", size: "sm", className: styles.multiValueRemove }));
};

var __defProp$2a = Object.defineProperty;
var __defProps$1p = Object.defineProperties;
var __getOwnPropDescs$1p = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2c = Object.getOwnPropertySymbols;
var __hasOwnProp$2c = Object.prototype.hasOwnProperty;
var __propIsEnum$2c = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2a = (obj, key, value) => key in obj ? __defProp$2a(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2a = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2c.call(b, prop))
      __defNormalProp$2a(a, prop, b[prop]);
  if (__getOwnPropSymbols$2c)
    for (var prop of __getOwnPropSymbols$2c(b)) {
      if (__propIsEnum$2c.call(b, prop))
        __defNormalProp$2a(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1p = (a, b) => __defProps$1p(a, __getOwnPropDescs$1p(b));
const SelectContainer = (props) => {
  const {
    isDisabled,
    isFocused,
    children,
    selectProps: { invalid = false }
  } = props;
  const theme = useTheme2();
  const styles = getSelectContainerStyles(theme, isFocused, isDisabled, invalid);
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.SelectContainer, __spreadProps$1p(__spreadValues$2a({}, props), { className: css.cx(styles.wrapper, props.className) }), children);
};
const getSelectContainerStyles = stylesFactory(
  (theme, focused, disabled, invalid) => {
    const styles = getInputStyles({ theme, invalid });
    return {
      wrapper: css.cx(
        styles.wrapper,
        sharedInputStyle(theme, invalid),
        focused && css.css`
            ${focusCss(theme.v1)}
          `,
        disabled && styles.inputDisabled,
        css.css`
          position: relative;
          box-sizing: border-box;
          /* The display property is set by the styles prop in SelectBase because it's dependant on the width prop  */
          flex-direction: row;
          flex-wrap: wrap;
          align-items: stretch;
          justify-content: space-between;

          min-height: 32px;
          height: auto;
          max-width: 100%;

          /* Input padding is applied to the InputControl so the menu is aligned correctly */
          padding: 0;
          cursor: ${disabled ? "not-allowed" : "pointer"};
        `
      )
    };
  }
);

var __defProp$29 = Object.defineProperty;
var __defProps$1o = Object.defineProperties;
var __getOwnPropDescs$1o = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2b = Object.getOwnPropertySymbols;
var __hasOwnProp$2b = Object.prototype.hasOwnProperty;
var __propIsEnum$2b = Object.prototype.propertyIsEnumerable;
var __defNormalProp$29 = (obj, key, value) => key in obj ? __defProp$29(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$29 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2b.call(b, prop))
      __defNormalProp$29(a, prop, b[prop]);
  if (__getOwnPropSymbols$2b)
    for (var prop of __getOwnPropSymbols$2b(b)) {
      if (__propIsEnum$2b.call(b, prop))
        __defNormalProp$29(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1o = (a, b) => __defProps$1o(a, __getOwnPropDescs$1o(b));
const SelectMenu = ({ children, maxHeight, innerRef, innerProps }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1o(__spreadValues$29({}, innerProps), { className: styles.menu, style: { maxHeight }, "aria-label": "Select options menu" }), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { scrollRefCallback: innerRef, autoHide: false, autoHeightMax: "inherit", hideHorizontalTrack: true }, children));
};
SelectMenu.displayName = "SelectMenu";
const VIRTUAL_LIST_ITEM_HEIGHT = 37;
const VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER = 7;
const VirtualizedSelectMenu = ({ children, maxHeight, options, getValue }) => {
  var _a;
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const [value] = getValue();
  const valueIndex = value ? options.findIndex((option) => option.value === value.value) : 0;
  const initialOffset = valueIndex * VIRTUAL_LIST_ITEM_HEIGHT;
  if (!Array.isArray(children)) {
    return null;
  }
  const longestOption = (_a = lodash.max(options.map((option) => {
    var _a2;
    return (_a2 = option.label) == null ? void 0 : _a2.length;
  }))) != null ? _a : 0;
  const widthEstimate = longestOption * VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER;
  const heightEstimate = Math.min(options.length * VIRTUAL_LIST_ITEM_HEIGHT, maxHeight);
  return /* @__PURE__ */ React__default["default"].createElement(
    reactWindow.FixedSizeList,
    {
      className: styles.menu,
      height: heightEstimate,
      width: widthEstimate,
      "aria-label": "Select options menu",
      itemCount: children.length,
      itemSize: VIRTUAL_LIST_ITEM_HEIGHT,
      initialScrollOffset: initialOffset
    },
    ({ index, style }) => /* @__PURE__ */ React__default["default"].createElement("div", { style: __spreadProps$1o(__spreadValues$29({}, style), { overflow: "hidden" }) }, children[index])
  );
};
VirtualizedSelectMenu.displayName = "VirtualizedSelectMenu";
const SelectMenuOptions = ({
  children,
  data: data$1,
  innerProps,
  innerRef,
  isFocused,
  isSelected,
  renderOptionLabel
}) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const icon = data$1.icon ? data.toIconName(data$1.icon) : void 0;
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    __spreadProps$1o(__spreadValues$29({
      ref: innerRef,
      className: css.cx(
        styles.option,
        isFocused && styles.optionFocused,
        isSelected && styles.optionSelected,
        data$1.isDisabled && styles.optionDisabled
      )
    }, innerProps), {
      "aria-label": "Select option",
      title: data$1.title
    }),
    icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, className: styles.optionIcon }),
    data$1.imgUrl && /* @__PURE__ */ React__default["default"].createElement("img", { className: styles.optionImage, src: data$1.imgUrl, alt: data$1.label || data$1.value }),
    /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.optionBody }, /* @__PURE__ */ React__default["default"].createElement("span", null, renderOptionLabel ? renderOptionLabel(data$1) : children), data$1.description && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.optionDescription }, data$1.description), data$1.component && /* @__PURE__ */ React__default["default"].createElement(data$1.component, null))
  );
};
SelectMenuOptions.displayName = "SelectMenuOptions";

class UnthemedValueContainer extends React.Component {
  render() {
    const { children } = this.props;
    const { selectProps } = this.props;
    if (selectProps && Array.isArray(children) && Array.isArray(children[0]) && selectProps.maxVisibleValues !== void 0 && !(selectProps.showAllSelectedWhenOpen && selectProps.menuIsOpen)) {
      const [valueChildren, ...otherChildren] = children;
      const truncatedValues = valueChildren.slice(0, selectProps.maxVisibleValues);
      return this.renderContainer([truncatedValues, ...otherChildren]);
    }
    return this.renderContainer(children);
  }
  renderContainer(children) {
    const { isMulti, theme } = this.props;
    const styles = getSelectStyles(theme);
    const className = css.cx(styles.valueContainer, isMulti && styles.valueContainerMulti);
    return /* @__PURE__ */ React__default["default"].createElement("div", { className }, children);
  }
}
const ValueContainer = withTheme2(UnthemedValueContainer);

var __getOwnPropSymbols$2a = Object.getOwnPropertySymbols;
var __hasOwnProp$2a = Object.prototype.hasOwnProperty;
var __propIsEnum$2a = Object.prototype.propertyIsEnumerable;
var __objRest$$ = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2a.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2a)
    for (var prop of __getOwnPropSymbols$2a(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2a.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const cleanValue = (value, options) => {
  if (Array.isArray(value)) {
    const filtered = value.filter(Boolean);
    return (filtered == null ? void 0 : filtered.length) ? filtered : void 0;
  }
  if (typeof value === "object") {
    return [value];
  }
  if (typeof value === "string" || typeof value === "number") {
    const selectedValue = findSelectedValue(value, options);
    if (selectedValue) {
      return [selectedValue];
    }
  }
  return void 0;
};
const findSelectedValue = (value, options) => {
  for (const option of options) {
    if ("options" in option) {
      let found = findSelectedValue(value, option.options);
      if (found) {
        return found;
      }
    } else if ("value" in option && option.value === value) {
      return option;
    }
  }
  return null;
};
const omitDescriptions = (options) => {
  return options.map((_a) => {
    var _b = _a, rest = __objRest$$(_b, ["description"]);
    return rest;
  });
};

var __defProp$28 = Object.defineProperty;
var __defProps$1n = Object.defineProperties;
var __getOwnPropDescs$1n = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$29 = Object.getOwnPropertySymbols;
var __hasOwnProp$29 = Object.prototype.hasOwnProperty;
var __propIsEnum$29 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$28 = (obj, key, value) => key in obj ? __defProp$28(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$28 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$29.call(b, prop))
      __defNormalProp$28(a, prop, b[prop]);
  if (__getOwnPropSymbols$29)
    for (var prop of __getOwnPropSymbols$29(b)) {
      if (__propIsEnum$29.call(b, prop))
        __defNormalProp$28(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1n = (a, b) => __defProps$1n(a, __getOwnPropDescs$1n(b));
const renderExtraValuesIndicator = (props) => {
  const { maxVisibleValues, selectedValuesCount, menuIsOpen, showAllSelectedWhenOpen } = props;
  if (maxVisibleValues !== void 0 && selectedValuesCount > maxVisibleValues && !(showAllSelectedWhenOpen && menuIsOpen)) {
    return /* @__PURE__ */ React__default["default"].createElement("span", { key: "excess-values", id: "excess-values" }, "(+", selectedValuesCount - maxVisibleValues, ")");
  }
  return null;
};
const CustomControl = (props) => {
  const {
    children,
    innerProps,
    selectProps: { menuIsOpen, onMenuClose, onMenuOpen },
    isFocused,
    isMulti,
    getValue,
    innerRef
  } = props;
  const selectProps = props.selectProps;
  if (selectProps.renderControl) {
    return React__default["default"].createElement(selectProps.renderControl, {
      isOpen: menuIsOpen,
      value: isMulti ? getValue() : getValue()[0],
      ref: innerRef,
      onClick: menuIsOpen ? onMenuClose : onMenuOpen,
      onBlur: onMenuClose,
      disabled: !!selectProps.disabled,
      invalid: !!selectProps.invalid
    });
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    InputControl$1,
    {
      ref: innerRef,
      innerProps,
      prefix: selectProps.prefix,
      focused: isFocused,
      invalid: !!selectProps.invalid,
      disabled: !!selectProps.disabled
    },
    children
  );
};
function SelectBase({
  allowCustomValue = false,
  allowCreateWhileLoading = false,
  "aria-label": ariaLabel,
  autoFocus = false,
  backspaceRemovesValue = true,
  cacheOptions,
  className,
  closeMenuOnSelect = true,
  components,
  createOptionPosition = "last",
  defaultOptions,
  defaultValue,
  disabled = false,
  filterOption,
  formatCreateLabel,
  getOptionLabel,
  getOptionValue,
  inputValue,
  invalid,
  isClearable = false,
  id,
  isLoading = false,
  isMulti = false,
  inputId,
  isOpen,
  isOptionDisabled,
  isSearchable = true,
  loadOptions,
  loadingMessage = "Loading options...",
  maxMenuHeight = 300,
  minMenuHeight,
  maxVisibleValues,
  menuPlacement = "auto",
  menuPosition,
  menuShouldPortal = true,
  noOptionsMessage = "No options found",
  onBlur,
  onChange,
  onCloseMenu,
  onCreateOption,
  onInputChange,
  onKeyDown,
  onOpenMenu,
  onFocus,
  openMenuOnFocus = false,
  options = [],
  placeholder = "Choose",
  prefix,
  renderControl,
  showAllSelectedWhenOpen = true,
  tabSelectsValue = true,
  value,
  virtualized = false,
  width,
  isValidNewOption,
  formatOptionLabel
}) {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const reactSelectRef = React.useRef(null);
  const [closeToBottom, setCloseToBottom] = React.useState(false);
  const selectStyles = useCustomSelectStyles(theme, width);
  React.useEffect(() => {
    if (loadOptions && isOpen && reactSelectRef.current && reactSelectRef.current.controlRef && menuPlacement === "auto") {
      const distance = window.innerHeight - reactSelectRef.current.controlRef.getBoundingClientRect().bottom;
      setCloseToBottom(distance < maxMenuHeight);
    }
  }, [maxMenuHeight, menuPlacement, loadOptions, isOpen]);
  const onChangeWithEmpty = React.useCallback(
    (value2, action) => {
      if (isMulti && (value2 === void 0 || value2 === null)) {
        return onChange([], action);
      }
      onChange(value2, action);
    },
    [isMulti, onChange]
  );
  let ReactSelectComponent = ReactSelect__default["default"];
  const creatableProps = {};
  let asyncSelectProps = {};
  let selectedValue;
  if (isMulti && loadOptions) {
    selectedValue = value;
  } else {
    if (isMulti && value && Array.isArray(value) && !loadOptions) {
      selectedValue = value.map((v) => {
        var _a;
        const selectableValue = findSelectedValue((_a = v.value) != null ? _a : v, options);
        if (!allowCustomValue || selectableValue) {
          return selectableValue;
        }
        return typeof v === "string" ? data.toOption(v) : v;
      });
    } else if (loadOptions) {
      const hasValue = defaultValue || value;
      selectedValue = hasValue ? [hasValue] : [];
    } else {
      selectedValue = cleanValue(value, options);
    }
  }
  const commonSelectProps = {
    "aria-label": ariaLabel,
    autoFocus,
    backspaceRemovesValue,
    captureMenuScroll: false,
    closeMenuOnSelect,
    // We don't want to close if we're actually scrolling the menu
    // So only close if none of the parents are the select menu itself
    defaultValue,
    // Also passing disabled, as this is the new Select API, and I want to use this prop instead of react-select's one
    disabled,
    filterOption,
    getOptionLabel,
    getOptionValue,
    inputValue,
    invalid,
    isClearable,
    id,
    // Passing isDisabled as react-select accepts this prop
    isDisabled: disabled,
    isLoading,
    isMulti,
    inputId,
    isOptionDisabled,
    isSearchable,
    maxMenuHeight,
    minMenuHeight,
    maxVisibleValues,
    menuIsOpen: isOpen,
    menuPlacement: menuPlacement === "auto" && closeToBottom ? "top" : menuPlacement,
    menuPosition,
    menuShouldBlockScroll: true,
    menuPortalTarget: menuShouldPortal && typeof document !== "undefined" ? document.body : void 0,
    menuShouldScrollIntoView: false,
    onBlur,
    onChange: onChangeWithEmpty,
    onInputChange,
    onKeyDown,
    onMenuClose: onCloseMenu,
    onMenuOpen: onOpenMenu,
    onFocus,
    formatOptionLabel,
    openMenuOnFocus,
    options: virtualized ? omitDescriptions(options) : options,
    placeholder,
    prefix,
    renderControl,
    showAllSelectedWhenOpen,
    tabSelectsValue,
    value: isMulti ? selectedValue : selectedValue == null ? void 0 : selectedValue[0]
  };
  if (allowCustomValue) {
    ReactSelectComponent = Creatable__default["default"];
    creatableProps.allowCreateWhileLoading = allowCreateWhileLoading;
    creatableProps.formatCreateLabel = formatCreateLabel != null ? formatCreateLabel : defaultFormatCreateLabel;
    creatableProps.onCreateOption = onCreateOption;
    creatableProps.createOptionPosition = createOptionPosition;
    creatableProps.isValidNewOption = isValidNewOption;
  }
  if (loadOptions) {
    ReactSelectComponent = allowCustomValue ? AsyncCreatable__default["default"] : ReactAsyncSelect__default["default"];
    asyncSelectProps = {
      loadOptions,
      cacheOptions,
      defaultOptions
    };
  }
  const SelectMenuComponent = virtualized ? VirtualizedSelectMenu : SelectMenu;
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
    ReactSelectComponent,
    __spreadValues$28(__spreadValues$28(__spreadValues$28({
      ref: reactSelectRef,
      components: __spreadValues$28({
        MenuList: SelectMenuComponent,
        Group: SelectOptionGroup,
        ValueContainer,
        IndicatorsContainer(props) {
          const { selectProps } = props;
          const { value: value2, showAllSelectedWhenOpen: showAllSelectedWhenOpen2, maxVisibleValues: maxVisibleValues2, menuIsOpen } = selectProps;
          if (maxVisibleValues2 !== void 0) {
            const selectedValuesCount = value2.length;
            const indicatorChildren = [...props.children];
            indicatorChildren.splice(
              -1,
              0,
              renderExtraValuesIndicator({
                maxVisibleValues: maxVisibleValues2,
                selectedValuesCount,
                showAllSelectedWhenOpen: showAllSelectedWhenOpen2,
                menuIsOpen
              })
            );
            return /* @__PURE__ */ React__default["default"].createElement(IndicatorsContainer, __spreadValues$28({}, props), indicatorChildren);
          }
          return /* @__PURE__ */ React__default["default"].createElement(IndicatorsContainer, __spreadValues$28({}, props));
        },
        IndicatorSeparator() {
          return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null);
        },
        Control: CustomControl,
        Option: SelectMenuOptions,
        ClearIndicator(props) {
          const { clearValue } = props;
          return /* @__PURE__ */ React__default["default"].createElement(
            Icon,
            {
              name: "times",
              role: "button",
              "aria-label": "select-clear-value",
              className: styles.singleValueRemove,
              onMouseDown: (e) => {
                e.preventDefault();
                e.stopPropagation();
                clearValue();
              }
            }
          );
        },
        LoadingIndicator() {
          return /* @__PURE__ */ React__default["default"].createElement(Spinner, { inline: true });
        },
        LoadingMessage() {
          return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.loadingMessage }, loadingMessage);
        },
        NoOptionsMessage() {
          return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.loadingMessage, "aria-label": "No options provided" }, noOptionsMessage);
        },
        DropdownIndicator(props) {
          return /* @__PURE__ */ React__default["default"].createElement(DropdownIndicator, { isOpen: props.selectProps.menuIsOpen });
        },
        SingleValue(props) {
          return /* @__PURE__ */ React__default["default"].createElement(SingleValue, __spreadProps$1n(__spreadValues$28({}, props), { disabled }));
        },
        SelectContainer,
        MultiValueContainer,
        MultiValueRemove
      }, components),
      styles: selectStyles,
      className
    }, commonSelectProps), creatableProps), asyncSelectProps)
  ));
}
function defaultFormatCreateLabel(input) {
  return /* @__PURE__ */ React__default["default"].createElement("div", { style: { display: "flex", gap: "8px", alignItems: "center" } }, /* @__PURE__ */ React__default["default"].createElement("div", null, input), /* @__PURE__ */ React__default["default"].createElement("div", { style: { flexGrow: 1 } }), /* @__PURE__ */ React__default["default"].createElement("div", { className: "muted small", style: { display: "flex", gap: "8px", alignItems: "center" } }, "Hit enter to add"));
}

var __defProp$27 = Object.defineProperty;
var __defProps$1m = Object.defineProperties;
var __getOwnPropDescs$1m = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$28 = Object.getOwnPropertySymbols;
var __hasOwnProp$28 = Object.prototype.hasOwnProperty;
var __propIsEnum$28 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$27 = (obj, key, value) => key in obj ? __defProp$27(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$27 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$28.call(b, prop))
      __defNormalProp$27(a, prop, b[prop]);
  if (__getOwnPropSymbols$28)
    for (var prop of __getOwnPropSymbols$28(b)) {
      if (__propIsEnum$28.call(b, prop))
        __defNormalProp$27(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1m = (a, b) => __defProps$1m(a, __getOwnPropDescs$1m(b));
function Select(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$27({}, props));
}
function MultiSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadProps$1m(__spreadValues$27({}, props), { isMulti: true }));
}
function AsyncSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$27({}, props));
}
function VirtualizedSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$27({ virtualized: true }, props));
}
function AsyncVirtualizedSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$27({ virtualized: true }, props));
}
function AsyncMultiSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadProps$1m(__spreadValues$27({}, props), { isMulti: true }));
}

const onChangeCascader = (onChanged) => (values, options) => {
  if (onChanged) {
    onChanged(
      values.map((value) => String(value)),
      fromRCOptions(options)
    );
  }
};
const onLoadDataCascader = (onLoadData) => (options) => {
  if (onLoadData) {
    onLoadData(fromRCOptions(options));
  }
};
const fromRCOptions = (options) => {
  return options.map(fromRCOption);
};
const fromRCOption = (option) => {
  var _a;
  return {
    value: (_a = option.value) != null ? _a : "",
    label: option.label
  };
};

const disableDivFocus = css.css(`
&:focus{
  outline: none;
}
`);
const DEFAULT_SEPARATOR = "/";
class Cascader extends React.PureComponent {
  constructor(props) {
    super(props);
    this.flattenOptions = (options, optionPath = []) => {
      let selectOptions = [];
      for (const option of options) {
        const cpy = [...optionPath];
        cpy.push(option);
        if (!option.items) {
          selectOptions.push({
            singleLabel: cpy[cpy.length - 1].label,
            label: cpy.map((o) => o.label).join(this.props.separator || ` ${DEFAULT_SEPARATOR} `),
            value: cpy.map((o) => o.value)
          });
        } else {
          selectOptions = [...selectOptions, ...this.flattenOptions(option.items, cpy)];
        }
      }
      return selectOptions;
    };
    this.getSearchableOptions = memoizeOne__default["default"]((options) => this.flattenOptions(options));
    //For rc-cascader
    this.onChange = (value, selectedOptions) => {
      const activeLabel = this.props.hideActiveLevelLabel ? "" : this.props.displayAllSelectedLevels ? selectedOptions.map((option) => option.label).join(this.props.separator || DEFAULT_SEPARATOR) : selectedOptions[selectedOptions.length - 1].label;
      this.setState({
        rcValue: value,
        focusCascade: true,
        activeLabel
      });
      this.props.onSelect(selectedOptions[selectedOptions.length - 1].value);
    };
    //For select
    this.onSelect = (obj) => {
      const valueArray = obj.value || [];
      this.setState({
        activeLabel: this.props.displayAllSelectedLevels ? obj.label : obj.singleLabel || "",
        rcValue: valueArray,
        isSearching: false
      });
      this.props.onSelect(valueArray[valueArray.length - 1]);
    };
    this.onCreateOption = (value) => {
      this.setState({
        activeLabel: value,
        rcValue: [],
        isSearching: false
      });
      this.props.onSelect(value);
    };
    this.onBlur = () => {
      var _a, _b;
      this.setState({
        isSearching: false,
        focusCascade: false
      });
      if (this.state.activeLabel === "") {
        this.setState({
          rcValue: []
        });
      }
      (_b = (_a = this.props).onBlur) == null ? void 0 : _b.call(_a);
    };
    this.onBlurCascade = () => {
      var _a, _b;
      this.setState({
        focusCascade: false
      });
      (_b = (_a = this.props).onBlur) == null ? void 0 : _b.call(_a);
    };
    this.onInputKeyDown = (e) => {
      if (["ArrowDown", "ArrowUp", "Enter", "ArrowLeft", "ArrowRight", "Backspace"].includes(e.key)) {
        return;
      }
      this.setState({
        focusCascade: false,
        isSearching: true
      });
    };
    this.onSelectInputChange = (value) => {
      if (value === "") {
        this.setState({
          isSearching: false
        });
      }
    };
    const searchableOptions = this.getSearchableOptions(props.options);
    const { rcValue, activeLabel } = this.setInitialValue(searchableOptions, props.initialValue);
    this.state = {
      isSearching: false,
      focusCascade: false,
      rcValue,
      activeLabel
    };
  }
  setInitialValue(searchableOptions, initValue) {
    if (!initValue) {
      return { rcValue: [], activeLabel: "" };
    }
    for (const option of searchableOptions) {
      const optionPath = option.value || [];
      if (optionPath.indexOf(initValue) === optionPath.length - 1) {
        return {
          rcValue: optionPath,
          activeLabel: this.props.displayAllSelectedLevels ? option.label : option.singleLabel || ""
        };
      }
    }
    if (this.props.allowCustomValue) {
      return { rcValue: [], activeLabel: initValue };
    }
    return { rcValue: [], activeLabel: "" };
  }
  render() {
    const { allowCustomValue, formatCreateLabel, placeholder, width, changeOnSelect, options } = this.props;
    const { focusCascade, isSearching, rcValue, activeLabel } = this.state;
    const searchableOptions = this.getSearchableOptions(options);
    return /* @__PURE__ */ React__default["default"].createElement("div", null, isSearching ? /* @__PURE__ */ React__default["default"].createElement(
      Select,
      {
        allowCustomValue,
        placeholder,
        autoFocus: !focusCascade,
        onChange: this.onSelect,
        onBlur: this.onBlur,
        options: searchableOptions,
        onCreateOption: this.onCreateOption,
        formatCreateLabel,
        width,
        onInputChange: this.onSelectInputChange
      }
    ) : /* @__PURE__ */ React__default["default"].createElement(
      RCCascader__default["default"],
      {
        onChange: onChangeCascader(this.onChange),
        options,
        changeOnSelect,
        value: rcValue.value,
        fieldNames: { label: "label", value: "value", children: "items" },
        expandIcon: null,
        open: this.props.alwaysOpen
      },
      /* @__PURE__ */ React__default["default"].createElement("div", { className: disableDivFocus }, /* @__PURE__ */ React__default["default"].createElement(
        Input,
        {
          autoFocus: this.props.autoFocus,
          width,
          placeholder,
          onBlur: this.onBlurCascade,
          value: activeLabel,
          onKeyDown: this.onInputKeyDown,
          onChange: () => {
          },
          suffix: focusCascade ? /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-up" }) : /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-down", style: { marginBottom: 0, marginLeft: "4px" } })
        }
      ))
    ));
  }
}
Cascader.defaultProps = { changeOnSelect: true };

var __defProp$26 = Object.defineProperty;
var __defProps$1l = Object.defineProperties;
var __getOwnPropDescs$1l = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$27 = Object.getOwnPropertySymbols;
var __hasOwnProp$27 = Object.prototype.hasOwnProperty;
var __propIsEnum$27 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$26 = (obj, key, value) => key in obj ? __defProp$26(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$26 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$27.call(b, prop))
      __defNormalProp$26(a, prop, b[prop]);
  if (__getOwnPropSymbols$27)
    for (var prop of __getOwnPropSymbols$27(b)) {
      if (__propIsEnum$27.call(b, prop))
        __defNormalProp$26(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1l = (a, b) => __defProps$1l(a, __getOwnPropDescs$1l(b));
var __objRest$_ = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$27.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$27)
    for (var prop of __getOwnPropSymbols$27(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$27.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getStyles$1H = stylesFactory((theme) => {
  return {
    popup: css.css`
      label: popup;
      z-index: ${theme.zIndex.dropdown};
    `,
    icons: {
      right: css.css`
        margin: 1px 0 0 4px;
      `,
      left: css.css`
        margin: -1px 4px 0 0;
      `
    }
  };
});
const ButtonCascader = (props) => {
  const _a = props, { onChange, className, loadData, icon, buttonProps, hideDownIcon, variant, disabled } = _a, rest = __objRest$_(_a, ["onChange", "className", "loadData", "icon", "buttonProps", "hideDownIcon", "variant", "disabled"]);
  const theme = useTheme2();
  const styles = getStyles$1H(theme);
  let content = props.children;
  if (!hideDownIcon) {
    content = [props.children, /* @__PURE__ */ React__default["default"].createElement(Icon, { key: "down-icon", name: "angle-down", className: styles.icons.right })];
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    RCCascader__default["default"],
    __spreadProps$1l(__spreadValues$26({
      onChange: onChangeCascader(onChange),
      loadData: onLoadDataCascader(loadData),
      dropdownClassName: styles.popup
    }, rest), {
      expandIcon: null
    }),
    /* @__PURE__ */ React__default["default"].createElement(Button, __spreadValues$26({ icon, disabled, variant }, buttonProps != null ? buttonProps : {}), content)
  );
};
ButtonCascader.displayName = "ButtonCascader";

var __defProp$25 = Object.defineProperty;
var __getOwnPropSymbols$26 = Object.getOwnPropertySymbols;
var __hasOwnProp$26 = Object.prototype.hasOwnProperty;
var __propIsEnum$26 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$25 = (obj, key, value) => key in obj ? __defProp$25(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$25 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$26.call(b, prop))
      __defNormalProp$25(a, prop, b[prop]);
  if (__getOwnPropSymbols$26)
    for (var prop of __getOwnPropSymbols$26(b)) {
      if (__propIsEnum$26.call(b, prop))
        __defNormalProp$25(a, prop, b[prop]);
    }
  return a;
};
var __objRest$Z = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$26.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$26)
    for (var prop of __getOwnPropSymbols$26(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$26.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const LoadingPlaceholder = (_a) => {
  var _b = _a, { text, className } = _b, rest = __objRest$Z(_b, ["text", "className"]);
  const styles = useStyles2(getStyles$1G);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$25({ className: css.cx(styles.container, className) }, rest), text, " ", /* @__PURE__ */ React__default["default"].createElement(Spinner, { inline: true }));
};
const getStyles$1G = (theme) => {
  return {
    container: css.css`
      margin-bottom: ${theme.spacing(4)};
    `
  };
};

const MILLISECONDS_PER_PIXEL = 2.4;
const MIN_DURATION_MS = 500;
const MAX_DURATION_MS = 4e3;
function LoadingBar({ width, ariaLabel = "Loading bar" }) {
  const styles = useStyles2(getStyles$1F);
  const durationMs = Math.min(Math.max(Math.round(width * MILLISECONDS_PER_PIXEL), MIN_DURATION_MS), MAX_DURATION_MS);
  const containerStyles = {
    width: "100%",
    animation: `${styles.animation} ${durationMs}ms infinite linear`,
    willChange: "transform"
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { style: containerStyles }, /* @__PURE__ */ React__default["default"].createElement("div", { "aria-label": ariaLabel, className: styles.bar }));
}
const getStyles$1F = () => {
  return {
    animation: css.keyframes({
      "0%": {
        transform: "translateX(-50%)"
      },
      "100%": {
        transform: `translateX(100%)`
      }
    }),
    bar: css.css({
      width: "28%",
      height: 1,
      background: "linear-gradient(90deg, rgba(110, 159, 255, 0) 0%, #6E9FFF 80.75%, rgba(110, 159, 255, 0) 100%)"
    })
  };
};

const closePopover = (event, hidePopper) => {
  if (event.key === "Tab" || event.altKey || event.ctrlKey || event.metaKey) {
    return;
  }
  event.stopPropagation();
  if (event.key === "Escape") {
    hidePopper();
  }
  return;
};

var __defProp$24 = Object.defineProperty;
var __defProps$1k = Object.defineProperties;
var __getOwnPropDescs$1k = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$25 = Object.getOwnPropertySymbols;
var __hasOwnProp$25 = Object.prototype.hasOwnProperty;
var __propIsEnum$25 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$24 = (obj, key, value) => key in obj ? __defProp$24(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$24 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$25.call(b, prop))
      __defNormalProp$24(a, prop, b[prop]);
  if (__getOwnPropSymbols$25)
    for (var prop of __getOwnPropSymbols$25(b)) {
      if (__propIsEnum$25.call(b, prop))
        __defNormalProp$24(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1k = (a, b) => __defProps$1k(a, __getOwnPropDescs$1k(b));
var __objRest$Y = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$25.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$25)
    for (var prop of __getOwnPropSymbols$25(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$25.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var ColorSwatchVariant = /* @__PURE__ */ ((ColorSwatchVariant2) => {
  ColorSwatchVariant2["Small"] = "small";
  ColorSwatchVariant2["Large"] = "large";
  return ColorSwatchVariant2;
})(ColorSwatchVariant || {});
const ColorSwatch = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { color, label, variant = "small" /* Small */, isSelected, "aria-label": ariaLabel } = _b, otherProps = __objRest$Y(_b, ["color", "label", "variant", "isSelected", "aria-label"]);
    const theme = useTheme2();
    const { isFocusVisible, focusProps } = focus.useFocusRing();
    const styles = getStyles$1E(theme, variant, color, isFocusVisible, isSelected);
    const hasLabel = !!label;
    const colorLabel = `${ariaLabel || label} color`;
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$24({ ref, className: styles.wrapper, "data-testid": e2eSelectors.selectors.components.ColorSwatch.name }, otherProps), hasLabel && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.label }, label), /* @__PURE__ */ React__default["default"].createElement("button", __spreadProps$1k(__spreadValues$24({ className: styles.swatch }, focusProps), { "aria-label": colorLabel })));
  }
);
const getStyles$1E = (theme, variant, color, isFocusVisible, isSelected) => {
  const tc = tinycolor__default["default"](color);
  const isSmall = variant === "small" /* Small */;
  const swatchSize = isSmall ? "16px" : "32px";
  let border = "none";
  if (tc.getAlpha() < 0.1) {
    border = `2px solid ${theme.colors.border.medium}`;
  }
  return {
    wrapper: css.css({
      display: "flex",
      alignItems: "center",
      cursor: "pointer"
    }),
    label: css.css({
      marginRight: theme.spacing(1)
    }),
    swatch: css.css({
      width: swatchSize,
      height: swatchSize,
      background: `${color}`,
      border,
      borderRadius: "50%",
      outlineOffset: "1px",
      outline: isFocusVisible ? `2px solid  ${theme.colors.primary.main}` : "none",
      boxShadow: isSelected ? `inset 0 0 0 2px ${color}, inset 0 0 0 4px ${theme.colors.getContrastText(color)}` : "none",
      transition: theme.transitions.create(["transform"], {
        duration: theme.transitions.duration.short
      }),
      "&:hover": {
        transform: "scale(1.1)"
      }
    })
  };
};
ColorSwatch.displayName = "ColorSwatch";

function reverseMap(arr, callbackfn) {
  const reversedAndMapped = new Array(arr.length);
  for (let i = 0; i < arr.length; i++) {
    const reverseIndex = arr.length - 1 - i;
    reversedAndMapped[i] = callbackfn(arr[reverseIndex], reverseIndex, arr);
  }
  return reversedAndMapped;
}

var __defProp$23 = Object.defineProperty;
var __defProps$1j = Object.defineProperties;
var __getOwnPropDescs$1j = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$24 = Object.getOwnPropertySymbols;
var __hasOwnProp$24 = Object.prototype.hasOwnProperty;
var __propIsEnum$24 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$23 = (obj, key, value) => key in obj ? __defProp$23(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$23 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$24.call(b, prop))
      __defNormalProp$23(a, prop, b[prop]);
  if (__getOwnPropSymbols$24)
    for (var prop of __getOwnPropSymbols$24(b)) {
      if (__propIsEnum$24.call(b, prop))
        __defNormalProp$23(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1j = (a, b) => __defProps$1j(a, __getOwnPropDescs$1j(b));
var __objRest$X = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$24.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$24)
    for (var prop of __getOwnPropSymbols$24(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$24.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const NamedColorsGroup = (_a) => {
  var _b = _a, { hue, selectedColor, onColorSelect } = _b, otherProps = __objRest$X(_b, ["hue", "selectedColor", "onColorSelect"]);
  const label = lodash.upperFirst(hue.name);
  const styles = useStyles2(getStyles$1D);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorRow }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorLabel }, label), /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1j(__spreadValues$23({}, otherProps), { className: styles.swatchRow }), reverseMap(hue.shades, (shade) => /* @__PURE__ */ React__default["default"].createElement(
    ColorSwatch,
    {
      key: shade.name,
      "aria-label": shade.name,
      variant: shade.primary ? ColorSwatchVariant.Large : ColorSwatchVariant.Small,
      isSelected: shade.name === selectedColor,
      color: shade.color,
      onClick: () => onColorSelect(shade.name)
    }
  ))));
};
const getStyles$1D = (theme) => {
  return {
    colorRow: css.css`
      display: grid;
      grid-template-columns: 25% 1fr;
      grid-column-gap: ${theme.spacing(2)};
      padding: ${theme.spacing(0.5, 0)};

      &:hover {
        background: ${theme.colors.background.secondary};
      }
    `,
    colorLabel: css.css`
      padding-left: ${theme.spacing(2)};
      display: flex;
      align-items: center;
    `,
    swatchRow: css.css`
      display: flex;
      gap: ${theme.spacing(1)};
      align-items: center;
      justify-content: space-around;
      flex-direction: row;
    `
  };
};

const NamedColorsPalette = ({ color, onChange }) => {
  const theme = useTheme2();
  const styles = useStyles2(getStyles$1C);
  const swatches = [];
  for (const hue of theme.visualization.hues) {
    swatches.push(/* @__PURE__ */ React__default["default"].createElement(NamedColorsGroup, { key: hue.name, selectedColor: color, hue, onColorSelect: onChange }));
  }
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.swatches }, swatches), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.extraColors }, /* @__PURE__ */ React__default["default"].createElement(
    ColorSwatch,
    {
      isSelected: color === "transparent",
      color: "rgba(0,0,0,0)",
      label: "Transparent",
      onClick: () => onChange("transparent")
    }
  ), /* @__PURE__ */ React__default["default"].createElement(
    ColorSwatch,
    {
      isSelected: color === "text",
      color: theme.colors.text.primary,
      label: "Text color",
      onClick: () => onChange("text")
    }
  )));
};
const getStyles$1C = (theme) => {
  return {
    container: css.css`
      display: flex;
      flex-direction: column;
    `,
    extraColors: css.css`
      display: flex;
      align-items: center;
      justify-content: space-around;
      gap: ${theme.spacing(1)};
      padding: ${theme.spacing(1, 0)};
    `,
    swatches: css.css`
      display: grid;
      flex-grow: 1;
    `
  };
};

var __defProp$22 = Object.defineProperty;
var __defProps$1i = Object.defineProperties;
var __getOwnPropDescs$1i = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$23 = Object.getOwnPropertySymbols;
var __hasOwnProp$23 = Object.prototype.hasOwnProperty;
var __propIsEnum$23 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$22 = (obj, key, value) => key in obj ? __defProp$22(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$22 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$23.call(b, prop))
      __defNormalProp$22(a, prop, b[prop]);
  if (__getOwnPropSymbols$23)
    for (var prop of __getOwnPropSymbols$23(b)) {
      if (__propIsEnum$23.call(b, prop))
        __defNormalProp$22(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1i = (a, b) => __defProps$1i(a, __getOwnPropDescs$1i(b));
var __objRest$W = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$23.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$23)
    for (var prop of __getOwnPropSymbols$23(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$23.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ColorInput = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { color, onChange, isClearable = false, onClick, onBlur, disabled, buttonAriaLabel } = _b, inputProps = __objRest$W(_b, ["color", "onChange", "isClearable", "onClick", "onBlur", "disabled", "buttonAriaLabel"]);
    const [value, setValue] = React.useState(color);
    const [previousColor, setPreviousColor] = React.useState(color);
    const updateColor = React.useMemo(() => lodash.debounce(onChange, 100), []);
    React.useEffect(() => {
      const newColor = tinycolor__default["default"](color);
      if (newColor.isValid() && color !== previousColor) {
        setValue(newColor.toString());
        setPreviousColor(color);
      }
    }, [color, previousColor]);
    const onChangeColor = (event) => {
      const { value: colorValue } = event.currentTarget;
      setValue(colorValue);
      if (colorValue === "" && isClearable) {
        updateColor(colorValue);
        return;
      }
      const newColor = tinycolor__default["default"](colorValue);
      if (newColor.isValid()) {
        updateColor(newColor.toString());
      }
    };
    const onBlurInput = (event) => {
      const newColor = tinycolor__default["default"](value);
      if (!newColor.isValid()) {
        setValue(color);
      }
      onBlur == null ? void 0 : onBlur(event);
    };
    return /* @__PURE__ */ React__default["default"].createElement(
      Input,
      __spreadProps$1i(__spreadValues$22({}, inputProps), {
        value,
        onChange: onChangeColor,
        disabled,
        onClick,
        onBlur: onBlurInput,
        addonBefore: /* @__PURE__ */ React__default["default"].createElement(ColorPreview, { onClick, ariaLabel: buttonAriaLabel, disabled, color }),
        ref
      })
    );
  }
);
ColorInput.displayName = "ColorInput";
const ColorPreview = ({ color, onClick, disabled, ariaLabel }) => {
  const styles = useStyles2(getColorPreviewStyles);
  return /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      type: "button",
      onClick,
      "aria-label": ariaLabel,
      disabled: disabled || !onClick,
      className: css.cx(
        styles,
        css.css`
          background-color: ${color};
        `
      )
    }
  );
};
const getColorPreviewStyles = (theme) => css.css`
  height: 100%;
  width: ${theme.spacing.gridSize * 4}px;
  border-radius: ${theme.shape.borderRadius()} 0 0 ${theme.shape.borderRadius()};
  border: 1px solid ${theme.colors.border.medium};
`;

const SpectrumPalette = ({ color, onChange }) => {
  const [currentColor, setColor] = React.useState(color);
  reactUse.useThrottleFn(
    (c) => {
      onChange(data.colorManipulator.asHexString(theme.visualization.getColorByName(c)));
    },
    500,
    [currentColor]
  );
  const theme = useTheme2();
  const styles = useStyles2(getStyles$1B);
  const rgbaString = React.useMemo(() => {
    return currentColor.startsWith("rgba") ? currentColor : tinycolor__default["default"](theme.visualization.getColorByName(color)).toRgbString();
  }, [currentColor, theme, color]);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, /* @__PURE__ */ React__default["default"].createElement(reactColorful.RgbaStringColorPicker, { className: styles.root, color: rgbaString, onChange: setColor }), /* @__PURE__ */ React__default["default"].createElement(ColorInput, { theme, color: rgbaString, onChange: setColor, className: styles.colorInput }));
};
const getStyles$1B = (theme) => ({
  wrapper: css.css`
    flex-grow: 1;
  `,
  root: css.css`
    &.react-colorful {
      width: auto;
    }

    .react-colorful {
      &__saturation {
        border-radius: ${theme.shape.borderRadius(1)} ${theme.shape.borderRadius(1)} 0 0;
      }
      &__alpha {
        border-radius: 0 0 ${theme.shape.borderRadius(1)} ${theme.shape.borderRadius(1)};
      }
      &__alpha,
      &__hue {
        height: ${theme.spacing(2)};
        position: relative;
      }
      &__pointer {
        height: ${theme.spacing(2)};
        width: ${theme.spacing(2)};
      }
    }
  `,
  colorInput: css.css`
    margin-top: ${theme.spacing(2)};
  `
});

class UnThemedColorPickerPopover extends React.Component {
  constructor(props) {
    super(props);
    this.getTabClassName = (tabName) => {
      const { activePicker } = this.state;
      return `ColorPickerPopover__tab ${activePicker === tabName && "ColorPickerPopover__tab--active"}`;
    };
    this.handleChange = (color) => {
      const { onChange, enableNamedColors, theme } = this.props;
      if (enableNamedColors) {
        return onChange(color);
      }
      onChange(data.colorManipulator.asHexString(theme.visualization.getColorByName(color)));
    };
    this.onTabChange = (tab) => {
      return () => this.setState({ activePicker: tab });
    };
    this.renderPicker = () => {
      const { activePicker } = this.state;
      const { color } = this.props;
      switch (activePicker) {
        case "spectrum":
          return /* @__PURE__ */ React__default["default"].createElement(SpectrumPalette, { color, onChange: this.handleChange });
        case "palette":
          return /* @__PURE__ */ React__default["default"].createElement(NamedColorsPalette, { color, onChange: this.handleChange });
        default:
          return this.renderCustomPicker(activePicker);
      }
    };
    this.renderCustomPicker = (tabKey) => {
      const { customPickers, color, theme } = this.props;
      if (!customPickers) {
        return null;
      }
      return React__default["default"].createElement(customPickers[tabKey].tabComponent, {
        color,
        theme,
        onChange: this.handleChange
      });
    };
    this.renderCustomPickerTabs = () => {
      const { customPickers } = this.props;
      if (!customPickers) {
        return null;
      }
      return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, Object.keys(customPickers).map((key) => {
        return /* @__PURE__ */ React__default["default"].createElement("button", { className: this.getTabClassName(key), onClick: this.onTabChange(key), key }, customPickers[key].name);
      }));
    };
    this.state = {
      activePicker: "palette"
    };
  }
  render() {
    const { theme } = this.props;
    const styles = getStyles$1A(theme);
    return /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, restoreFocus: true, autoFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", { tabIndex: -1, className: styles.colorPickerPopover }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorPickerPopoverTabs }, /* @__PURE__ */ React__default["default"].createElement("button", { className: this.getTabClassName("palette"), onClick: this.onTabChange("palette") }, "Colors"), /* @__PURE__ */ React__default["default"].createElement("button", { className: this.getTabClassName("spectrum"), onClick: this.onTabChange("spectrum") }, "Custom"), this.renderCustomPickerTabs()), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorPickerPopoverContent }, this.renderPicker())));
  }
}
const ColorPickerPopover = withTheme2(UnThemedColorPickerPopover);
ColorPickerPopover.displayName = "ColorPickerPopover";
const getStyles$1A = stylesFactory((theme) => {
  return {
    colorPickerPopover: css.css`
      border-radius: ${theme.shape.borderRadius()};
      box-shadow: ${theme.shadows.z3};
      background: ${theme.colors.background.primary};
      border: 1px solid ${theme.colors.border.medium};

      .ColorPickerPopover__tab {
        width: 50%;
        text-align: center;
        padding: ${theme.spacing(1, 0)};
        background: ${theme.colors.background.secondary};
        color: ${theme.colors.text.secondary};
        font-size: ${theme.typography.bodySmall.fontSize};
        cursor: pointer;
        border: none;

        &:focus:not(:focus-visible) {
          outline: none;
          box-shadow: none;
        }

        :focus-visible {
          position: relative;
        }
      }

      .ColorPickerPopover__tab--active {
        color: ${theme.colors.text.primary};
        font-weight: ${theme.typography.fontWeightMedium};
        background: ${theme.colors.background.primary};
      }
    `,
    colorPickerPopoverContent: css.css`
      width: 246px;
      font-size: ${theme.typography.bodySmall.fontSize};
      min-height: 184px;
      padding: ${theme.spacing(1)};
      display: flex;
      flex-direction: column;
    `,
    colorPickerPopoverTabs: css.css`
      display: flex;
      width: 100%;
      border-radius: ${theme.shape.borderRadius()} ${theme.shape.borderRadius()} 0 0;
    `
  };
});

var __defProp$21 = Object.defineProperty;
var __defProps$1h = Object.defineProperties;
var __getOwnPropDescs$1h = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$22 = Object.getOwnPropertySymbols;
var __hasOwnProp$22 = Object.prototype.hasOwnProperty;
var __propIsEnum$22 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$21 = (obj, key, value) => key in obj ? __defProp$21(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$21 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$22.call(b, prop))
      __defNormalProp$21(a, prop, b[prop]);
  if (__getOwnPropSymbols$22)
    for (var prop of __getOwnPropSymbols$22(b)) {
      if (__propIsEnum$22.call(b, prop))
        __defNormalProp$21(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1h = (a, b) => __defProps$1h(a, __getOwnPropDescs$1h(b));
var __objRest$V = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$22.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$22)
    for (var prop of __getOwnPropSymbols$22(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$22.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SeriesColorPickerPopover = (props) => {
  const styles = useStyles2(getStyles$1z);
  const _a = props, { yaxis, onToggleAxis, color } = _a, colorPickerProps = __objRest$V(_a, ["yaxis", "onToggleAxis", "color"]);
  const customPickers = onToggleAxis ? {
    yaxis: {
      name: "Y-Axis",
      tabComponent() {
        return /* @__PURE__ */ React__default["default"].createElement(
          Switch$1,
          {
            key: "yaxisSwitch",
            label: "Use right y-axis",
            className: styles.colorPickerAxisSwitch,
            labelClass: styles.colorPickerAxisSwitchLabel,
            checked: yaxis === 2,
            onChange: () => {
              if (onToggleAxis) {
                onToggleAxis();
              }
            }
          }
        );
      }
    }
  } : void 0;
  return /* @__PURE__ */ React__default["default"].createElement(ColorPickerPopover, __spreadProps$1h(__spreadValues$21({}, colorPickerProps), { color: color || "#000000", customPickers }));
};
const SeriesColorPickerPopoverWithTheme = withTheme2(SeriesColorPickerPopover);
const getStyles$1z = () => {
  return {
    colorPickerAxisSwitch: css.css`
      width: 100%;
    `,
    colorPickerAxisSwitchLabel: css.css`
      display: flex;
      flex-grow: 1;
    `
  };
};

var __defProp$20 = Object.defineProperty;
var __defProps$1g = Object.defineProperties;
var __getOwnPropDescs$1g = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$21 = Object.getOwnPropertySymbols;
var __hasOwnProp$21 = Object.prototype.hasOwnProperty;
var __propIsEnum$21 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$20 = (obj, key, value) => key in obj ? __defProp$20(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$20 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$21.call(b, prop))
      __defNormalProp$20(a, prop, b[prop]);
  if (__getOwnPropSymbols$21)
    for (var prop of __getOwnPropSymbols$21(b)) {
      if (__propIsEnum$21.call(b, prop))
        __defNormalProp$20(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1g = (a, b) => __defProps$1g(a, __getOwnPropDescs$1g(b));
const colorPickerFactory = (popover, displayName = "ColorPicker") => {
  var _a;
  return _a = class extends React.Component {
    constructor() {
      super(...arguments);
      this.pickerTriggerRef = React.createRef();
    }
    render() {
      const { theme, children, onChange } = this.props;
      const styles = getStyles$1y(theme);
      const popoverElement = React__default["default"].createElement(popover, __spreadProps$1g(__spreadValues$20({}, __spreadProps$1g(__spreadValues$20({}, this.props), { children: null })), {
        onChange
      }));
      return /* @__PURE__ */ React__default["default"].createElement(PopoverController, { content: popoverElement, hideAfter: 300 }, (showPopper, hidePopper, popperProps) => {
        return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, this.pickerTriggerRef.current && /* @__PURE__ */ React__default["default"].createElement(
          Popover,
          __spreadProps$1g(__spreadValues$20({}, popperProps), {
            referenceElement: this.pickerTriggerRef.current,
            wrapperClassName: styles.colorPicker,
            onMouseLeave: hidePopper,
            onMouseEnter: showPopper,
            onKeyDown: (event) => closePopover(event, hidePopper)
          })
        ), children ? (
          // Children have a bit weird type due to intersection used in the definition so we need to cast here,
          // but the definition is correct and should not allow to pass a children that does not conform to
          // ColorPickerTriggerRenderer type.
          children({
            ref: this.pickerTriggerRef,
            showColorPicker: showPopper,
            hideColorPicker: hidePopper
          })
        ) : /* @__PURE__ */ React__default["default"].createElement(
          ColorSwatch,
          {
            ref: this.pickerTriggerRef,
            onClick: showPopper,
            onMouseLeave: hidePopper,
            color: theme.visualization.getColorByName(this.props.color || "#000000")
          }
        ));
      });
    }
  }, _a.displayName = displayName, _a;
};
const ColorPicker = withTheme2(colorPickerFactory(ColorPickerPopover, "ColorPicker"));
const SeriesColorPicker = withTheme2(colorPickerFactory(SeriesColorPickerPopover, "SeriesColorPicker"));
const getStyles$1y = stylesFactory((theme) => {
  return {
    colorPicker: css.css`
      position: absolute;
      z-index: ${theme.zIndex.tooltip};
      color: ${theme.colors.text.primary};
      max-width: 400px;
      font-size: ${theme.typography.size.sm};
      // !important because these styles are also provided to popper via .popper classes from Tooltip component
      // hope to get rid of those soon
      padding: 15px !important;
      & [data-placement^='top'] {
        padding-left: 0 !important;
        padding-right: 0 !important;
      }
      & [data-placement^='bottom'] {
        padding-left: 0 !important;
        padding-right: 0 !important;
      }
      & [data-placement^='left'] {
        padding-top: 0 !important;
      }
      & [data-placement^='right'] {
        padding-top: 0 !important;
      }
    `
  };
});

class ClickOutsideWrapper extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.myRef = React.createRef();
    this.state = {
      hasEventListener: false
    };
    this.onOutsideClick = (event) => {
      const domNode = this.myRef.current;
      if (!domNode || !domNode.contains(event.target)) {
        this.props.onClick();
      }
    };
  }
  componentDidMount() {
    this.props.parent.addEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.addEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  componentWillUnmount() {
    this.props.parent.removeEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.removeEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  render() {
    return /* @__PURE__ */ React__default["default"].createElement("div", { ref: this.myRef }, this.props.children);
  }
}
ClickOutsideWrapper.defaultProps = {
  includeButtonPress: true,
  parent: typeof window !== "undefined" ? window : null,
  useCapture: false
};

var __defProp$1$ = Object.defineProperty;
var __defProps$1f = Object.defineProperties;
var __getOwnPropDescs$1f = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$20 = Object.getOwnPropertySymbols;
var __hasOwnProp$20 = Object.prototype.hasOwnProperty;
var __propIsEnum$20 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1$ = (obj, key, value) => key in obj ? __defProp$1$(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1$ = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$20.call(b, prop))
      __defNormalProp$1$(a, prop, b[prop]);
  if (__getOwnPropSymbols$20)
    for (var prop of __getOwnPropSymbols$20(b)) {
      if (__propIsEnum$20.call(b, prop))
        __defNormalProp$1$(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1f = (a, b) => __defProps$1f(a, __getOwnPropDescs$1f(b));
var __objRest$U = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$20.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$20)
    for (var prop of __getOwnPropSymbols$20(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$20.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ColorPickerInput = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { value = "", onChange, returnColorAs = "rgb" } = _b, inputProps = __objRest$U(_b, ["value", "onChange", "returnColorAs"]);
    const [currentColor, setColor] = React.useState(value);
    const [isOpen, setIsOpen] = React.useState(false);
    const theme = useTheme2();
    const styles = useStyles2(getStyles$1x);
    const paletteStyles = useStyles2(getStyles$1B);
    reactUse.useThrottleFn(
      (c) => {
        if (c === value) {
          return;
        }
        if (!c) {
          onChange("");
          return;
        }
        const color = theme.visualization.getColorByName(c);
        if (returnColorAs === "rgb") {
          onChange(data.colorManipulator.asRgbString(color));
        } else {
          onChange(data.colorManipulator.asHexString(color));
        }
      },
      500,
      [currentColor]
    );
    return /* @__PURE__ */ React__default["default"].createElement(ClickOutsideWrapper, { onClick: () => setIsOpen(false) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, isOpen && !inputProps.disabled && /* @__PURE__ */ React__default["default"].createElement(
      reactColorful.RgbaStringColorPicker,
      {
        "data-testid": "color-popover",
        color: currentColor,
        onChange: setColor,
        className: css.cx(paletteStyles.root, styles.picker)
      }
    ), /* @__PURE__ */ React__default["default"].createElement(
      ColorInput,
      __spreadProps$1f(__spreadValues$1$({}, inputProps), {
        theme,
        color: currentColor,
        onChange: setColor,
        buttonAriaLabel: "Open color picker",
        onClick: () => setIsOpen(true),
        onBlur: () => setIsOpen(false),
        ref,
        isClearable: true
      })
    )));
  }
);
ColorPickerInput.displayName = "ColorPickerInput";
const getStyles$1x = (theme) => {
  return {
    wrapper: css.css`
      position: relative;
    `,
    picker: css.css`
      &.react-colorful {
        position: absolute;
        width: 100%;
        z-index: 11;
        bottom: 36px;
      }
    `,
    inner: css.css`
      position: absolute;
    `
  };
};

const EmptySearchResult = ({ children }) => {
  const styles = useStyles2(getStyles$1w);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, children);
};
const getStyles$1w = (theme) => {
  return {
    container: css.css`
      border-left: 3px solid ${theme.colors.info.main};
      background-color: ${theme.colors.background.secondary};
      padding: ${theme.spacing(2)};
      min-width: 350px;
      border-radius: ${theme.shape.radius.default};
      margin-bottom: ${theme.spacing(4)};
    `
  };
};

function formatCreateLabel(input) {
  return `Custom unit: ${input}`;
}
class UnitPicker extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.onChange = (value) => {
      this.props.onChange(value.value);
    };
  }
  render() {
    const { value, width } = this.props;
    let current = void 0;
    const unitGroups = data.getValueFormats();
    const groupOptions = unitGroups.map((group) => {
      const options = group.submenu.map((unit) => {
        const sel = {
          label: unit.text,
          value: unit.value
        };
        if (unit.value === value) {
          current = sel;
        }
        return sel;
      });
      return {
        label: group.text,
        value: group.text,
        items: options
      };
    });
    if (value && !current) {
      current = { value, label: value };
    }
    return /* @__PURE__ */ React__default["default"].createElement(
      Cascader,
      {
        width,
        initialValue: current && current.label,
        allowCustomValue: true,
        changeOnSelect: false,
        formatCreateLabel,
        options: groupOptions,
        placeholder: "Choose",
        onSelect: this.props.onChange
      }
    );
  }
}

class StatsPicker extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.checkInput = () => {
      const { stats, allowMultiple, defaultStat, onChange } = this.props;
      const current = data.fieldReducers.list(stats);
      if (current.length !== stats.length) {
        const found = current.map((v) => v.id);
        const notFound = lodash.difference(stats, found);
        console.warn("Unknown stats", notFound, stats);
        onChange(current.map((stat) => stat.id));
      }
      if (!allowMultiple && stats.length > 1) {
        console.warn("Removing extra stat", stats);
        onChange([stats[0]]);
      }
      if (defaultStat && stats.length < 1) {
        onChange([defaultStat]);
      }
    };
    this.onSelectionChange = (item) => {
      const { onChange } = this.props;
      if (Array.isArray(item)) {
        onChange(item.map((v) => v.value));
      } else {
        onChange(item && item.value ? [item.value] : []);
      }
    };
  }
  componentDidMount() {
    this.checkInput();
  }
  componentDidUpdate(prevProps) {
    this.checkInput();
  }
  render() {
    const { stats, allowMultiple, defaultStat, placeholder, className, menuPlacement, width, inputId } = this.props;
    const select = data.fieldReducers.selectOptions(stats);
    return /* @__PURE__ */ React__default["default"].createElement(
      Select,
      {
        value: select.current,
        className,
        isClearable: !defaultStat,
        isMulti: allowMultiple,
        width,
        isSearchable: true,
        options: select.options,
        placeholder,
        onChange: this.onSelectionChange,
        menuPlacement,
        inputId
      }
    );
  }
}
StatsPicker.defaultProps = {
  allowMultiple: false
};

function MenuDivider() {
  const styles = useStyles2(getStyles$1v);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.divider });
}
const getStyles$1v = (theme) => {
  return {
    divider: css.css({
      height: 1,
      backgroundColor: theme.colors.border.weak,
      margin: theme.spacing(0.5, 0)
    })
  };
};

const MenuGroup = ({ label, ariaLabel, children }) => {
  const styles = useStyles2(getStyles$1u);
  const labelID = `group-label-${lodash.uniqueId()}`;
  return /* @__PURE__ */ React__default["default"].createElement("div", { role: "group", "aria-labelledby": !ariaLabel && label ? labelID : void 0, "aria-label": ariaLabel }, label && /* @__PURE__ */ React__default["default"].createElement("label", { id: labelID, className: styles.groupLabel, "aria-hidden": true }, label), children);
};
MenuGroup.displayName = "MenuGroup";
const getStyles$1u = (theme) => {
  return {
    groupLabel: css.css`
      color: ${theme.colors.text.secondary};
      font-size: ${theme.typography.size.sm};
      padding: ${theme.spacing(0.5, 1)};
    `
  };
};

const modulo$2 = (a, n) => (a % n + n) % n;
const UNFOCUSED = -1;
const useMenuFocus = ({
  localRef,
  isMenuOpen,
  openedWithArrow,
  setOpenedWithArrow,
  close,
  onOpen,
  onClose,
  onKeyDown
}) => {
  const [focusedItem, setFocusedItem] = React.useState(UNFOCUSED);
  React.useEffect(() => {
    if (isMenuOpen && openedWithArrow) {
      setFocusedItem(0);
      setOpenedWithArrow == null ? void 0 : setOpenedWithArrow(false);
    }
  }, [isMenuOpen, openedWithArrow, setOpenedWithArrow]);
  React.useEffect(() => {
    var _a, _b;
    const menuItems = (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.querySelectorAll(
      '[data-role="menuitem"]:not([data-disabled])'
    );
    (_b = menuItems == null ? void 0 : menuItems[focusedItem]) == null ? void 0 : _b.focus();
    menuItems == null ? void 0 : menuItems.forEach((menuItem, i) => {
      menuItem.tabIndex = i === focusedItem ? 0 : -1;
    });
  }, [localRef, focusedItem]);
  reactUse.useEffectOnce(() => {
    onOpen == null ? void 0 : onOpen(setFocusedItem);
  });
  const handleKeys = (event) => {
    var _a, _b, _c;
    const menuItems = (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.querySelectorAll(
      '[data-role="menuitem"]:not([data-disabled])'
    );
    const menuItemsCount = (_b = menuItems == null ? void 0 : menuItems.length) != null ? _b : 0;
    switch (event.key) {
      case "ArrowUp":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(modulo$2(focusedItem - 1, menuItemsCount));
        break;
      case "ArrowDown":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(modulo$2(focusedItem + 1, menuItemsCount));
        break;
      case "ArrowLeft":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(UNFOCUSED);
        close == null ? void 0 : close();
        break;
      case "Home":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(0);
        break;
      case "End":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(menuItemsCount - 1);
        break;
      case "Enter":
        event.preventDefault();
        event.stopPropagation();
        (_c = menuItems == null ? void 0 : menuItems[focusedItem]) == null ? void 0 : _c.click();
        break;
      case "Escape":
        onClose == null ? void 0 : onClose();
        break;
      case "Tab":
        event.preventDefault();
        onClose == null ? void 0 : onClose();
        break;
    }
    onKeyDown == null ? void 0 : onKeyDown(event);
  };
  return [handleKeys];
};

const isElementOverflowing = (element) => {
  if (!element) {
    return false;
  }
  const wrapperPos = element.parentElement.getBoundingClientRect();
  const pos = element.getBoundingClientRect();
  return pos.width !== 0 && wrapperPos.right + pos.width + 10 > window.innerWidth;
};

const SubMenu = React__default["default"].memo(
  ({ items, isOpen, openedWithArrow, setOpenedWithArrow, close, customStyle }) => {
    const styles = useStyles2(getStyles$1t);
    const localRef = React.useRef(null);
    const [handleKeys] = useMenuFocus({
      localRef,
      isMenuOpen: isOpen,
      openedWithArrow,
      setOpenedWithArrow,
      close
    });
    const [pushLeft, setPushLeft] = React.useState(false);
    React.useEffect(() => {
      if (isOpen && localRef.current) {
        setPushLeft(isElementOverflowing(localRef.current));
      }
    }, [isOpen]);
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.iconWrapper, "aria-label": e2eSelectors.selectors.components.Menu.SubMenu.icon }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right", className: styles.icon, "aria-hidden": true })), isOpen && /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        ref: localRef,
        className: css.cx(styles.subMenu, { [styles.pushLeft]: pushLeft }),
        "aria-label": e2eSelectors.selectors.components.Menu.SubMenu.container,
        style: customStyle
      },
      /* @__PURE__ */ React__default["default"].createElement("div", { tabIndex: -1, className: styles.itemsWrapper, role: "menu", onKeyDown: handleKeys }, items)
    ));
  }
);
SubMenu.displayName = "SubMenu";
const getStyles$1t = (theme) => {
  return {
    iconWrapper: css.css`
      display: flex;
      flex: 1;
      justify-content: end;
    `,
    icon: css.css`
      opacity: 0.7;
      margin-left: ${theme.spacing(1)};
      color: ${theme.colors.text.secondary};
    `,
    itemsWrapper: css.css`
      background: ${theme.colors.background.primary};
      box-shadow: ${theme.shadows.z3};
      display: inline-block;
      border-radius: ${theme.shape.borderRadius()};
    `,
    pushLeft: css.css`
      right: 100%;
      left: unset;
    `,
    subMenu: css.css`
      position: absolute;
      top: 0;
      left: 100%;
      z-index: ${theme.zIndex.dropdown};
    `
  };
};

var __defProp$1_ = Object.defineProperty;
var __getOwnPropSymbols$1$ = Object.getOwnPropertySymbols;
var __hasOwnProp$1$ = Object.prototype.hasOwnProperty;
var __propIsEnum$1$ = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1_ = (obj, key, value) => key in obj ? __defProp$1_(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1_ = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1$.call(b, prop))
      __defNormalProp$1_(a, prop, b[prop]);
  if (__getOwnPropSymbols$1$)
    for (var prop of __getOwnPropSymbols$1$(b)) {
      if (__propIsEnum$1$.call(b, prop))
        __defNormalProp$1_(a, prop, b[prop]);
    }
  return a;
};
const MenuItem = React__default["default"].memo(
  React__default["default"].forwardRef((props, ref) => {
    const {
      url,
      icon,
      label,
      ariaLabel,
      ariaChecked,
      target,
      onClick,
      className,
      active,
      disabled,
      destructive,
      childItems,
      role = "menuitem",
      tabIndex = -1,
      customSubMenuContainerStyles,
      shortcut,
      testId
    } = props;
    const styles = useStyles2(getStyles$1s);
    const [isActive, setIsActive] = React.useState(active);
    const [isSubMenuOpen, setIsSubMenuOpen] = React.useState(false);
    const [openedWithArrow, setOpenedWithArrow] = React.useState(false);
    const onMouseEnter = React.useCallback(() => {
      if (disabled) {
        return;
      }
      setIsSubMenuOpen(true);
      setIsActive(true);
    }, [disabled]);
    const onMouseLeave = React.useCallback(() => {
      if (disabled) {
        return;
      }
      setIsSubMenuOpen(false);
      setIsActive(false);
    }, [disabled]);
    const hasSubMenu = childItems && childItems.length > 0;
    const ItemElement = hasSubMenu ? "div" : url === void 0 ? "button" : "a";
    const itemStyle = css.cx(
      {
        [styles.item]: true,
        [styles.active]: isActive,
        [styles.disabled]: disabled,
        [styles.destructive]: destructive && !disabled
      },
      className
    );
    const disabledProps = __spreadValues$1_(__spreadValues$1_({
      [ItemElement === "button" ? "disabled" : "aria-disabled"]: disabled
    }, ItemElement === "a" && disabled && { href: void 0, onClick: void 0 }), disabled && {
      tabIndex: -1,
      ["data-disabled"]: disabled
      // used to identify disabled items in Menu.tsx
    });
    const localRef = React.useRef(null);
    React.useImperativeHandle(ref, () => localRef.current);
    const handleKeys = (event) => {
      switch (event.key) {
        case "ArrowRight":
          event.preventDefault();
          event.stopPropagation();
          if (hasSubMenu) {
            setIsSubMenuOpen(true);
            setOpenedWithArrow(true);
            setIsActive(true);
          }
          break;
      }
    };
    const closeSubMenu = () => {
      var _a;
      setIsSubMenuOpen(false);
      setIsActive(false);
      (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.focus();
    };
    const hasShortcut = Boolean(shortcut && shortcut.length > 0);
    return /* @__PURE__ */ React__default["default"].createElement(
      ItemElement,
      __spreadValues$1_({
        target,
        className: itemStyle,
        rel: target === "_blank" ? "noopener noreferrer" : void 0,
        href: url,
        onClick,
        onMouseEnter,
        onMouseLeave,
        onKeyDown: handleKeys,
        role: url === void 0 ? role : void 0,
        "data-role": "menuitem",
        ref: localRef,
        "data-testid": testId,
        "aria-label": ariaLabel,
        "aria-checked": ariaChecked,
        tabIndex
      }, disabledProps),
      /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, className: styles.icon, "aria-hidden": true }), label, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.rightWrapper, { [styles.withShortcut]: hasShortcut }) }, hasShortcut && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.shortcut }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "keyboard", "aria-hidden": true }), shortcut), hasSubMenu && /* @__PURE__ */ React__default["default"].createElement(
        SubMenu,
        {
          items: childItems,
          isOpen: isSubMenuOpen,
          openedWithArrow,
          setOpenedWithArrow,
          close: closeSubMenu,
          customStyle: customSubMenuContainerStyles
        }
      )))
    );
  })
);
MenuItem.displayName = "MenuItem";
const getStyles$1s = (theme) => {
  return {
    item: css.css`
      background: none;
      cursor: pointer;
      white-space: nowrap;
      color: ${theme.colors.text.primary};
      display: flex;
      align-items: center;
      padding: ${theme.spacing(0.5, 2)};
      min-height: ${theme.spacing(4)};
      margin: 0;
      border: none;
      width: 100%;
      position: relative;

      &:hover,
      &:focus,
      &:focus-visible {
        background: ${theme.colors.action.hover};
        color: ${theme.colors.text.primary};
        text-decoration: none;
      }

      &:focus-visible {
        ${getFocusStyles(theme)}
      }
    `,
    active: css.css`
      background: ${theme.colors.action.hover};
    `,
    destructive: css.css`
      color: ${theme.colors.error.text};

      svg {
        color: ${theme.colors.error.text};
      }

      &:hover,
      &:focus,
      &:focus-visible {
        background: ${theme.colors.error.main};
        color: ${theme.colors.error.contrastText};

        svg {
          color: ${theme.colors.error.contrastText};
        }
      }
    `,
    disabled: css.css`
      color: ${theme.colors.action.disabledText};

      &:hover,
      &:focus,
      &:focus-visible {
        cursor: not-allowed;
        background: none;
        color: ${theme.colors.action.disabledText};
      }
    `,
    icon: css.css`
      opacity: 0.7;
      margin-right: 10px;
      margin-left: -4px;
      color: ${theme.colors.text.secondary};
    `,
    rightWrapper: css.css`
      display: flex;
      align-items: center;
      margin-left: auto;
    `,
    shortcutIcon: css.css`
      margin-right: ${theme.spacing(1)};
    `,
    withShortcut: css.css`
      min-width: ${theme.spacing(10.5)};
    `,
    shortcut: css.css`
      display: flex;
      align-items: center;
      gap: ${theme.spacing(1)};
      margin-left: ${theme.spacing(2)};
      color: ${theme.colors.text.secondary};
      opacity: 0.7;
    `
  };
};

var __defProp$1Z = Object.defineProperty;
var __defProps$1e = Object.defineProperties;
var __getOwnPropDescs$1e = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1_ = Object.getOwnPropertySymbols;
var __hasOwnProp$1_ = Object.prototype.hasOwnProperty;
var __propIsEnum$1_ = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1Z = (obj, key, value) => key in obj ? __defProp$1Z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1Z = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1_.call(b, prop))
      __defNormalProp$1Z(a, prop, b[prop]);
  if (__getOwnPropSymbols$1_)
    for (var prop of __getOwnPropSymbols$1_(b)) {
      if (__propIsEnum$1_.call(b, prop))
        __defNormalProp$1Z(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1e = (a, b) => __defProps$1e(a, __getOwnPropDescs$1e(b));
var __objRest$T = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1_.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1_)
    for (var prop of __getOwnPropSymbols$1_(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1_.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const MenuComp = React__default["default"].forwardRef(
  (_a, forwardedRef) => {
    var _b = _a, { header, children, ariaLabel, onOpen, onClose, onKeyDown } = _b, otherProps = __objRest$T(_b, ["header", "children", "ariaLabel", "onOpen", "onClose", "onKeyDown"]);
    const styles = useStyles2(getStyles$1r);
    const localRef = React.useRef(null);
    React.useImperativeHandle(forwardedRef, () => localRef.current);
    const [handleKeys] = useMenuFocus({ localRef, onOpen, onClose, onKeyDown });
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      __spreadProps$1e(__spreadValues$1Z({}, otherProps), {
        tabIndex: -1,
        ref: localRef,
        className: styles.wrapper,
        role: "menu",
        "aria-label": ariaLabel,
        onKeyDown: handleKeys
      }),
      header && /* @__PURE__ */ React__default["default"].createElement(
        "div",
        {
          className: css.cx(
            styles.header,
            Boolean(children) && React__default["default"].Children.toArray(children).length > 0 && styles.headerBorder
          )
        },
        header
      ),
      children
    );
  }
);
MenuComp.displayName = "Menu";
const Menu = Object.assign(MenuComp, {
  Item: MenuItem,
  Divider: MenuDivider,
  Group: MenuGroup
});
const getStyles$1r = (theme) => {
  return {
    header: css.css({
      padding: `${theme.spacing(0.5, 1, 1, 1)}`
    }),
    headerBorder: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`
    }),
    wrapper: css.css({
      background: `${theme.colors.background.primary}`,
      boxShadow: `${theme.shadows.z3}`,
      display: `inline-block`,
      borderRadius: `${theme.shape.borderRadius()}`,
      padding: `${theme.spacing(0.5, 0)}`
    })
  };
};

var __defProp$1Y = Object.defineProperty;
var __getOwnPropSymbols$1Z = Object.getOwnPropertySymbols;
var __hasOwnProp$1Z = Object.prototype.hasOwnProperty;
var __propIsEnum$1Z = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1Y = (obj, key, value) => key in obj ? __defProp$1Y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1Y = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1Z.call(b, prop))
      __defNormalProp$1Y(a, prop, b[prop]);
  if (__getOwnPropSymbols$1Z)
    for (var prop of __getOwnPropSymbols$1Z(b)) {
      if (__propIsEnum$1Z.call(b, prop))
        __defNormalProp$1Y(a, prop, b[prop]);
    }
  return a;
};
var __objRest$S = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1Z.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1Z)
    for (var prop of __getOwnPropSymbols$1Z(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1Z.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ToolbarButton = React.forwardRef(
  (_a, ref) => {
    var _b = _a, {
      tooltip,
      icon,
      iconSize,
      className,
      children,
      imgSrc,
      imgAlt,
      fullWidth,
      isOpen,
      narrow,
      variant = "default",
      iconOnly,
      "aria-label": ariaLabel,
      isHighlighted
    } = _b, rest = __objRest$S(_b, [
      "tooltip",
      "icon",
      "iconSize",
      "className",
      "children",
      "imgSrc",
      "imgAlt",
      "fullWidth",
      "isOpen",
      "narrow",
      "variant",
      "iconOnly",
      "aria-label",
      "isHighlighted"
    ]);
    const styles = useStyles2(getStyles$1q);
    const buttonStyles = css.cx(
      {
        [styles.button]: true,
        [styles.buttonFullWidth]: fullWidth,
        [styles.narrow]: narrow
      },
      styles[variant],
      className
    );
    const contentStyles = css.cx({
      [styles.content]: true,
      [styles.contentWithIcon]: !!icon,
      [styles.contentWithRightIcon]: isOpen !== void 0
    });
    const body = /* @__PURE__ */ React__default["default"].createElement(
      "button",
      __spreadValues$1Y({
        ref,
        className: buttonStyles,
        "aria-label": getButtonAriaLabel(ariaLabel, tooltip),
        "aria-expanded": isOpen
      }, rest),
      renderIcon(icon, iconSize),
      imgSrc && /* @__PURE__ */ React__default["default"].createElement("img", { className: styles.img, src: imgSrc, alt: imgAlt != null ? imgAlt : "" }),
      children && !iconOnly && /* @__PURE__ */ React__default["default"].createElement("div", { className: contentStyles }, children),
      isOpen === false && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-down" }),
      isOpen === true && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-up" }),
      isHighlighted && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.highlight })
    );
    return tooltip ? /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: tooltip, placement: "bottom" }, body) : body;
  }
);
ToolbarButton.displayName = "ToolbarButton";
function getButtonAriaLabel(ariaLabel, tooltip) {
  return ariaLabel ? ariaLabel : tooltip ? e2eSelectors.selectors.components.PageToolbar.item(tooltip) : void 0;
}
function renderIcon(icon, iconSize) {
  if (!icon) {
    return null;
  }
  if (data.isIconName(icon)) {
    return /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size: `${iconSize ? iconSize : "lg"}` });
  }
  return icon;
}
const getStyles$1q = (theme) => {
  const primaryVariant = getPropertiesForVariant(theme, "primary", "solid");
  const destructiveVariant = getPropertiesForVariant(theme, "destructive", "solid");
  const defaultOld = css.css`
    color: ${theme.colors.text.secondary};
    background-color: ${theme.colors.background.primary};

    &:hover {
      color: ${theme.colors.text.primary};
      background: ${theme.colors.background.secondary};
    }
  `;
  const defaultTopNav = css.css`
    color: ${theme.colors.text.secondary};
    background: transparent;
    border: 1px solid transparent;

    &:hover {
      color: ${theme.colors.text.primary};
      background: ${theme.colors.background.secondary};
    }
  `;
  return {
    button: css.css`
      label: toolbar-button;
      position: relative;
      display: flex;
      align-items: center;
      height: ${theme.spacing(theme.components.height.md)};
      padding: ${theme.spacing(0, 1)};
      border-radius: ${theme.shape.borderRadius()};
      line-height: ${theme.components.height.md * theme.spacing.gridSize - 2}px;
      font-weight: ${theme.typography.fontWeightMedium};
      border: 1px solid ${theme.colors.border.weak};
      white-space: nowrap;
      transition: ${theme.transitions.create(["background", "box-shadow", "border-color", "color"], {
      duration: theme.transitions.duration.short
    })};

      &:focus,
      &:focus-visible {
        ${getFocusStyles(theme)}
        z-index: 1;
      }

      &:focus:not(:focus-visible) {
        ${getMouseFocusStyles()}
      }

      &:hover {
        box-shadow: ${theme.shadows.z1};
      }

      &[disabled],
      &:disabled {
        cursor: not-allowed;
        opacity: ${theme.colors.action.disabledOpacity};
        background: ${theme.colors.action.disabledBackground};
        box-shadow: none;

        &:hover {
          color: ${theme.colors.text.disabled};
          background: ${theme.colors.action.disabledBackground};
          box-shadow: none;
        }
      }
    `,
    default: theme.flags.topnav ? defaultTopNav : defaultOld,
    canvas: defaultOld,
    active: css.css`
      color: ${theme.v1.palette.orangeDark};
      border-color: ${theme.v1.palette.orangeDark};
      background-color: transparent;

      &:hover {
        color: ${theme.colors.text.primary};
        background: ${theme.colors.emphasize(theme.colors.background.canvas, 0.03)};
      }
    `,
    primary: css.css(primaryVariant),
    destructive: css.css(destructiveVariant),
    narrow: css.css`
      padding: 0 ${theme.spacing(0.5)};
    `,
    img: css.css`
      width: 16px;
      height: 16px;
      margin-right: ${theme.spacing(1)};
    `,
    buttonFullWidth: css.css`
      flex-grow: 1;
    `,
    content: css.css`
      flex-grow: 1;
    `,
    contentWithIcon: css.css`
      display: none;
      padding-left: ${theme.spacing(1)};

      @media ${mediaUp(theme.v1.breakpoints.md)} {
        display: block;
      }
    `,
    contentWithRightIcon: css.css`
      padding-right: ${theme.spacing(0.5)};
    `,
    highlight: css.css`
      background-color: ${theme.colors.success.main};
      border-radius: 50%;
      width: 6px;
      height: 6px;
      position: absolute;
      top: -3px;
      right: -3px;
      z-index: 1;
    `
  };
};

var __defProp$1X = Object.defineProperty;
var __getOwnPropSymbols$1Y = Object.getOwnPropertySymbols;
var __hasOwnProp$1Y = Object.prototype.hasOwnProperty;
var __propIsEnum$1Y = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1X = (obj, key, value) => key in obj ? __defProp$1X(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1X = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1Y.call(b, prop))
      __defNormalProp$1X(a, prop, b[prop]);
  if (__getOwnPropSymbols$1Y)
    for (var prop of __getOwnPropSymbols$1Y(b)) {
      if (__propIsEnum$1Y.call(b, prop))
        __defNormalProp$1X(a, prop, b[prop]);
    }
  return a;
};
var __objRest$R = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1Y.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1Y)
    for (var prop of __getOwnPropSymbols$1Y(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1Y.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ToolbarButtonRow = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { alignment = "left", className, children } = _b, rest = __objRest$R(_b, ["alignment", "className", "children"]);
    const childrenWithoutNull = React__default["default"].Children.toArray(children).filter((child) => child !== null);
    const [childVisibility, setChildVisibility] = React.useState(Array(childrenWithoutNull.length).fill(true));
    const containerRef = React.useRef(null);
    const [showOverflowItems, setShowOverflowItems] = React.useState(false);
    const overflowRef = React.useRef(null);
    const overflowItemsRef = React.createRef();
    const { overlayProps } = overlays.useOverlay(
      {
        onClose: () => setShowOverflowItems(false),
        isDismissable: true,
        isOpen: showOverflowItems,
        shouldCloseOnInteractOutside: (element) => {
          var _a2;
          return !((_a2 = overflowRef.current) == null ? void 0 : _a2.contains(element));
        }
      },
      overflowItemsRef
    );
    const { dialogProps } = dialog.useDialog({}, overflowItemsRef);
    const theme = useTheme2();
    const overflowButtonOrder = alignment === "left" ? childVisibility.indexOf(false) - 1 : childVisibility.length;
    const styles = getStyles$1p(theme, overflowButtonOrder, alignment);
    React.useLayoutEffect(() => {
      const intersectionObserver = new IntersectionObserver(
        (entries) => {
          entries.forEach((entry) => {
            if (entry.target instanceof HTMLElement && entry.target.parentNode) {
              const index = Array.prototype.indexOf.call(entry.target.parentNode.children, entry.target);
              setChildVisibility((prev) => {
                const newVisibility = [...prev];
                newVisibility[index] = entry.isIntersecting;
                return newVisibility;
              });
            }
          });
        },
        {
          threshold: 1,
          root: containerRef.current
        }
      );
      if (containerRef.current) {
        Array.from(containerRef.current.children).forEach((item) => {
          if (item instanceof HTMLElement && item !== overflowRef.current) {
            intersectionObserver.observe(item);
          }
        });
      }
      return () => intersectionObserver.disconnect();
    }, [children]);
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1X({ ref: containerRef, className: css.cx(styles.container, className) }, rest), childrenWithoutNull.map((child, index) => /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        key: index,
        style: { order: index, visibility: childVisibility[index] ? "visible" : "hidden" },
        className: styles.childWrapper
      },
      child
    )), childVisibility.includes(false) && /* @__PURE__ */ React__default["default"].createElement("div", { ref: overflowRef, className: styles.overflowButton }, /* @__PURE__ */ React__default["default"].createElement(
      ToolbarButton,
      {
        variant: showOverflowItems ? "active" : "default",
        tooltip: "Show more items",
        onClick: () => setShowOverflowItems(!showOverflowItems),
        icon: "ellipsis-v",
        iconOnly: true,
        narrow: true
      }
    ), showOverflowItems && /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1X(__spreadValues$1X({ className: styles.overflowItems, ref: overflowItemsRef }, overlayProps), dialogProps), childrenWithoutNull.map((child, index) => !childVisibility[index] && child)))));
  }
);
ToolbarButtonRow.displayName = "ToolbarButtonRow";
const getStyles$1p = (theme, overflowButtonOrder, alignment) => ({
  overflowButton: css.css`
    order: ${overflowButtonOrder};
  `,
  overflowItems: css.css`
    align-items: center;
    background-color: ${theme.colors.background.primary};
    border-radius: ${theme.shape.borderRadius()};
    box-shadow: ${theme.shadows.z3};
    display: flex;
    flex-wrap: wrap;
    gap: ${theme.spacing(1)};
    margin-top: ${theme.spacing(1)};
    max-width: 80vw;
    padding: ${theme.spacing(0.5, 1)};
    position: absolute;
    right: 0;
    top: 100%;
    width: max-content;
    z-index: ${theme.zIndex.sidemenu};
  `,
  container: css.css`
    align-items: center;
    display: flex;
    gap: ${theme.spacing(1)};
    justify-content: ${alignment === "left" ? "flex-start" : "flex-end"};
    min-width: 0;
    position: relative;
  `,
  childWrapper: css.css`
    align-items: center;
    display: flex;
    gap: ${theme.spacing(1)};
  `
});

var __defProp$1W = Object.defineProperty;
var __getOwnPropSymbols$1X = Object.getOwnPropertySymbols;
var __hasOwnProp$1X = Object.prototype.hasOwnProperty;
var __propIsEnum$1X = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1W = (obj, key, value) => key in obj ? __defProp$1W(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1W = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1X.call(b, prop))
      __defNormalProp$1W(a, prop, b[prop]);
  if (__getOwnPropSymbols$1X)
    for (var prop of __getOwnPropSymbols$1X(b)) {
      if (__propIsEnum$1X.call(b, prop))
        __defNormalProp$1W(a, prop, b[prop]);
    }
  return a;
};
var __objRest$Q = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1X.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1X)
    for (var prop of __getOwnPropSymbols$1X(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1X.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ButtonSelectComponent = (props) => {
  const _a = props, { className, options, value, onChange, narrow, variant } = _a, restProps = __objRest$Q(_a, ["className", "options", "value", "onChange", "narrow", "variant"]);
  const styles = useStyles2(getStyles$1o);
  const state = menu.useMenuTriggerState({});
  const ref = React__default["default"].useRef(null);
  const { menuTriggerProps, menuProps } = menu$1.useMenuTrigger({}, state, ref);
  const { buttonProps } = button.useButton(menuTriggerProps, ref);
  const onChangeInternal = (item) => {
    onChange(item);
    state.close();
  };
  return /* @__PURE__ */ React__default["default"].createElement(ButtonGroup, { className: styles.wrapper }, /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    __spreadValues$1W(__spreadValues$1W({
      className,
      isOpen: state.isOpen,
      narrow,
      variant,
      ref
    }, buttonProps), restProps),
    (value == null ? void 0 : value.label) || ((value == null ? void 0 : value.value) != null ? String(value == null ? void 0 : value.value) : null)
  ), state.isOpen && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.menuWrapper }, /* @__PURE__ */ React__default["default"].createElement(ClickOutsideWrapper, { onClick: state.close, parent: document, includeButtonPress: false }, /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default["default"].createElement(Menu, __spreadValues$1W({ tabIndex: -1, onClose: state.close }, menuProps), options.map((item) => {
    var _a2;
    return /* @__PURE__ */ React__default["default"].createElement(
      MenuItem,
      {
        key: `${item.value}`,
        label: (_a2 = item.label) != null ? _a2 : String(item.value),
        onClick: () => onChangeInternal(item),
        active: item.value === (value == null ? void 0 : value.value),
        ariaChecked: item.value === (value == null ? void 0 : value.value),
        ariaLabel: item.ariaLabel || item.label,
        role: "menuitemradio"
      }
    );
  }))))));
};
ButtonSelectComponent.displayName = "ButtonSelect";
const ButtonSelect = React__default["default"].memo(ButtonSelectComponent);
const getStyles$1o = (theme) => {
  return {
    wrapper: css.css`
      position: relative;
      display: inline-flex;
    `,
    menuWrapper: css.css`
      position: absolute;
      z-index: ${theme.zIndex.dropdown};
      top: ${theme.spacing(4)};
      right: 0;
    `
  };
};

const defaultIntervals = ["5s", "10s", "30s", "1m", "5m", "15m", "30m", "1h", "2h", "1d"];
const _RefreshPicker = class extends React.PureComponent {
  constructor(props) {
    super(props);
    this.onChangeSelect = (item) => {
      const { onIntervalChanged } = this.props;
      if (onIntervalChanged && item.value != null) {
        onIntervalChanged(item.value);
      }
    };
  }
  getVariant() {
    if (this.props.isLive) {
      return "primary";
    }
    if (this.props.isLoading) {
      return "destructive";
    }
    if (this.props.primary) {
      return "primary";
    }
    return this.props.isOnCanvas ? "canvas" : "default";
  }
  render() {
    const { onRefresh, intervals, tooltip, value, text, isLoading, noIntervalPicker, width } = this.props;
    const currentValue = value || "";
    const variant = this.getVariant();
    const options = intervalsToOptions({ intervals });
    const option = options.find(({ value: value2 }) => value2 === currentValue);
    const translatedOffOption = translateOption(_RefreshPicker.offOption.value);
    let selectedValue = option || translatedOffOption;
    if (selectedValue.label === translatedOffOption.label) {
      selectedValue = { value: "" };
    }
    const durationAriaLabel = selectedValue.ariaLabel;
    const ariaLabelDurationSelectedMessage = t(
      "refresh-picker.aria-label.duration-selected",
      "Choose refresh time interval with current interval {{durationAriaLabel}} selected",
      { durationAriaLabel }
    );
    const ariaLabelChooseIntervalMessage = t(
      "refresh-picker.aria-label.choose-interval",
      "Auto refresh turned off. Choose refresh time interval"
    );
    const ariaLabel = selectedValue.value === "" ? ariaLabelChooseIntervalMessage : ariaLabelDurationSelectedMessage;
    return /* @__PURE__ */ React__default["default"].createElement(ButtonGroup, { className: "refresh-picker" }, /* @__PURE__ */ React__default["default"].createElement(
      ToolbarButton,
      {
        "aria-label": text,
        tooltip,
        onClick: onRefresh,
        variant,
        icon: isLoading ? "fa fa-spinner" : "sync",
        style: width ? { width } : void 0,
        "data-testid": e2eSelectors.selectors.components.RefreshPicker.runButtonV2
      },
      text
    ), !noIntervalPicker && /* @__PURE__ */ React__default["default"].createElement(
      ButtonSelect,
      {
        value: selectedValue,
        options,
        onChange: this.onChangeSelect,
        variant,
        title: t("refresh-picker.select-button.auto-refresh", "Set auto refresh interval"),
        "data-testid": e2eSelectors.selectors.components.RefreshPicker.intervalButtonV2,
        "aria-label": ariaLabel
      }
    ));
  }
};
let RefreshPicker = _RefreshPicker;
RefreshPicker.offOption = {
  label: "Off",
  value: "",
  ariaLabel: "Turn off auto refresh"
};
RefreshPicker.liveOption = {
  label: "Live",
  value: "LIVE",
  ariaLabel: "Turn on live streaming"
};
RefreshPicker.isLive = (refreshInterval) => refreshInterval === _RefreshPicker.liveOption.value;
function translateOption(option) {
  if (option === RefreshPicker.liveOption.value) {
    return {
      label: t("refresh-picker.live-option.label", "Live"),
      value: "LIVE",
      ariaLabel: t("refresh-picker.live-option.aria-label", "Turn on live streaming")
    };
  }
  return {
    label: t("refresh-picker.off-option.label", "Off"),
    value: "",
    ariaLabel: t("refresh-picker.off-option.aria-label", "Turn off auto refresh")
  };
}
function intervalsToOptions({ intervals = defaultIntervals } = {}) {
  const options = intervals.map((interval) => {
    const duration = data.parseDuration(interval);
    const ariaLabel = formatDuration__default["default"](duration);
    return {
      label: interval,
      value: interval,
      ariaLabel
    };
  });
  options.unshift(translateOption(RefreshPicker.offOption.value));
  return options;
}

const getModalStyles = stylesFactory((theme) => {
  const borderRadius = theme.shape.borderRadius(1);
  return {
    modal: css.css`
      position: fixed;
      z-index: ${theme.zIndex.modal};
      background: ${theme.colors.background.primary};
      box-shadow: ${theme.shadows.z3};
      border-radius: ${borderRadius};
      border: 1px solid ${theme.colors.border.weak};
      background-clip: padding-box;
      outline: none;
      width: 750px;
      max-width: 100%;
      left: 0;
      right: 0;
      margin-left: auto;
      margin-right: auto;
      top: 10%;
      max-height: 80%;
      display: flex;
      flex-direction: column;
    `,
    modalBackdrop: css.css`
      position: fixed;
      z-index: ${theme.zIndex.modalBackdrop};
      top: 0;
      right: 0;
      bottom: 0;
      left: 0;
      background-color: ${theme.components.overlay.background};
      backdrop-filter: blur(1px);
    `,
    modalHeader: css.css`
      label: modalHeader;
      display: flex;
      align-items: center;
      min-height: 42px;
      margin: ${theme.spacing(1, 2, 0, 2)};
    `,
    modalHeaderWithTabs: css.css`
      border-bottom: 1px solid ${theme.colors.border.weak};
    `,
    modalHeaderTitle: css.css`
      font-size: ${theme.typography.size.lg};
      margin: ${theme.spacing(0, 4, 0, 1)};
      display: flex;
      align-items: center;
      position: relative;
      top: 2px;
    `,
    modalHeaderIcon: css.css`
      margin-right: ${theme.spacing(2)};
      font-size: inherit;
      &:before {
        vertical-align: baseline;
      }
    `,
    modalHeaderClose: css.css`
      height: 100%;
      display: flex;
      align-items: center;
      color: ${theme.colors.text.secondary};
      flex-grow: 1;
      justify-content: flex-end;
    `,
    modalContent: css.css`
      overflow: auto;
      padding: ${theme.spacing(3)};
      width: 100%;
    `,
    modalButtonRow: css.css`
      padding-top: ${theme.spacing(3)};
    `
  };
});

const TimeZoneGroup = (props) => {
  const { children, label } = props;
  const styles = useStyles2(getStyles$1n);
  if (!label) {
    return /* @__PURE__ */ React__default["default"].createElement("div", null, children);
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.header }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.label }, label)), children);
};
const getStyles$1n = (theme) => {
  return {
    header: css.css`
      padding: 7px 10px;
      width: 100%;
      border-top: 1px solid ${theme.colors.border.weak};
      text-transform: capitalize;
    `,
    label: css.css`
      font-size: ${theme.typography.size.sm};
      color: ${theme.colors.text.secondary};
      font-weight: ${theme.typography.fontWeightMedium};
    `
  };
};

const TimeZoneOffset = (props) => {
  const { timestamp, timeZone, className } = props;
  const styles = useStyles2(getStyles$1m);
  if (!lodash.isString(timeZone)) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx(styles.offset, className) }, formatUtcOffset(timestamp, timeZone)));
};
const formatUtcOffset = (timestamp, timeZone) => {
  const offset = data.dateTimeFormat(timestamp, {
    timeZone,
    format: "Z"
  });
  if (offset === "+00:00") {
    return "UTC";
  }
  return `UTC${offset}`;
};
const getStyles$1m = (theme) => {
  const textBase = css.css`
    font-weight: normal;
    font-size: ${theme.typography.size.sm};
    color: ${theme.colors.text.secondary};
    white-space: normal;
  `;
  return {
    offset: css.css`
      ${textBase};
      color: ${theme.colors.text.primary};
      background: ${theme.colors.background.secondary};
      padding: 2px 5px;
      border-radius: 2px;
      margin-left: 4px;
    `
  };
};

const TimeZoneDescription = ({ info }) => {
  const styles = useStyles2(getStyles$1l);
  const description = useDescription(info);
  if (!info) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.description }, description);
};
const useDescription = (info) => {
  return React.useMemo(() => {
    const parts = [];
    if (!info) {
      return "";
    }
    if (info.countries.length > 0) {
      const country = info.countries[0];
      parts.push(country.name);
    }
    if (info.abbreviation) {
      parts.push(info.abbreviation);
    }
    return parts.join(", ");
  }, [info]);
};
const getStyles$1l = (theme) => {
  return {
    description: css.css`
      font-weight: normal;
      font-size: ${theme.typography.size.sm};
      color: ${theme.colors.text.secondary};
      white-space: normal;
      text-overflow: ellipsis;
    `
  };
};

const TimeZoneTitle = ({ title }) => {
  const styles = useStyles2(getStyles$1k);
  if (!title) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.title }, title);
};
const getStyles$1k = (theme) => {
  return {
    title: css.css`
      font-weight: ${theme.typography.fontWeightRegular};
      text-overflow: ellipsis;
    `
  };
};

var __defProp$1V = Object.defineProperty;
var __defProps$1d = Object.defineProperties;
var __getOwnPropDescs$1d = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1W = Object.getOwnPropertySymbols;
var __hasOwnProp$1W = Object.prototype.hasOwnProperty;
var __propIsEnum$1W = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1V = (obj, key, value) => key in obj ? __defProp$1V(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1V = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1W.call(b, prop))
      __defNormalProp$1V(a, prop, b[prop]);
  if (__getOwnPropSymbols$1W)
    for (var prop of __getOwnPropSymbols$1W(b)) {
      if (__propIsEnum$1W.call(b, prop))
        __defNormalProp$1V(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1d = (a, b) => __defProps$1d(a, __getOwnPropDescs$1d(b));
const offsetClassName = "tz-utc-offset";
const WideTimeZoneOption = (props) => {
  const { children, innerProps, innerRef, data: data$1, isSelected, isFocused } = props;
  const theme = useTheme2();
  const styles = getStyles$1j(theme);
  const timestamp = Date.now();
  const containerStyles = css.cx(styles.container, isFocused && styles.containerFocused);
  if (!lodash.isString(data$1.value)) {
    return null;
  }
  const timeZoneInfo = data.getTimeZoneInfo(data$1.value, timestamp);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1d(__spreadValues$1V({ className: containerStyles }, innerProps), { ref: innerRef, "aria-label": "Select option" }), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.leftColumn, styles.row) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.leftColumn, styles.wideRow) }, /* @__PURE__ */ React__default["default"].createElement(TimeZoneTitle, { title: children }), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.spacer }), /* @__PURE__ */ React__default["default"].createElement(TimeZoneDescription, { info: timeZoneInfo })), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightColumn }, /* @__PURE__ */ React__default["default"].createElement(
    TimeZoneOffset,
    {
      timeZone: (timeZoneInfo == null ? void 0 : timeZoneInfo.ianaName) || data$1.value,
      timestamp,
      className: offsetClassName
    }
  ), isSelected && /* @__PURE__ */ React__default["default"].createElement("span", null, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check" })))));
};
const CompactTimeZoneOption = (props) => {
  const { children, innerProps, innerRef, data: data$1, isSelected, isFocused } = props;
  const theme = useTheme2();
  const styles = getStyles$1j(theme);
  const timestamp = Date.now();
  const containerStyles = css.cx(styles.container, isFocused && styles.containerFocused);
  if (!lodash.isString(data$1.value)) {
    return null;
  }
  const timeZoneInfo = data.getTimeZoneInfo(data$1.value, timestamp);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1d(__spreadValues$1V({ className: containerStyles }, innerProps), { ref: innerRef, "aria-label": "Select option" }), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.body }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.row }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.leftColumn }, /* @__PURE__ */ React__default["default"].createElement(TimeZoneTitle, { title: children })), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightColumn }, isSelected && /* @__PURE__ */ React__default["default"].createElement("span", null, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check" })))), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.row }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.leftColumn }, /* @__PURE__ */ React__default["default"].createElement(TimeZoneDescription, { info: timeZoneInfo })), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightColumn }, /* @__PURE__ */ React__default["default"].createElement(
    TimeZoneOffset,
    {
      timestamp,
      timeZone: (timeZoneInfo == null ? void 0 : timeZoneInfo.ianaName) || data$1.value,
      className: offsetClassName
    }
  )))));
};
const getStyles$1j = stylesFactory((theme) => {
  return {
    container: css.css`
      display: flex;
      align-items: center;
      flex-direction: row;
      flex-shrink: 0;
      white-space: nowrap;
      cursor: pointer;
      padding: 6px 8px 4px;

      &:hover {
        background: ${theme.colors.action.hover};
      }
    `,
    containerFocused: css.css`
      background: ${theme.colors.action.hover};
    `,
    body: css.css`
      display: flex;
      font-weight: ${theme.typography.fontWeightMedium};
      flex-direction: column;
      flex-grow: 1;
    `,
    row: css.css`
      display: flex;
      flex-direction: row;
    `,
    leftColumn: css.css`
      flex-grow: 1;
      text-overflow: ellipsis;
    `,
    rightColumn: css.css`
      justify-content: flex-end;
      align-items: center;
    `,
    wideRow: css.css`
      display: flex;
      flex-direction: row;
      align-items: baseline;
    `,
    spacer: css.css`
      margin-left: 6px;
    `
  };
});

const TimeZonePicker = (props) => {
  const {
    onChange,
    width,
    autoFocus = false,
    onBlur,
    value,
    includeInternal = false,
    disabled = false,
    inputId
  } = props;
  const groupedTimeZones = useTimeZones(includeInternal);
  const selected = useSelectedTimeZone(groupedTimeZones, value);
  const filterBySearchIndex = useFilterBySearchIndex();
  const TimeZoneOption = width && width <= 45 ? CompactTimeZoneOption : WideTimeZoneOption;
  const onChangeTz = React.useCallback(
    (selectable) => {
      if (!selectable || !lodash.isString(selectable.value)) {
        return onChange(value);
      }
      onChange(selectable.value);
    },
    [onChange, value]
  );
  return /* @__PURE__ */ React__default["default"].createElement(
    Select,
    {
      inputId,
      value: selected,
      placeholder: t("time-picker.zone.select-search-input", "Type to search (country, city, abbreviation)"),
      autoFocus,
      menuShouldPortal: false,
      openMenuOnFocus: true,
      width,
      filterOption: filterBySearchIndex,
      options: groupedTimeZones,
      onChange: onChangeTz,
      onBlur,
      components: { Option: TimeZoneOption, Group: TimeZoneGroup },
      disabled,
      "aria-label": t("time-picker.zone.select-aria-label", "Time zone picker")
    }
  );
};
const useTimeZones = (includeInternal) => {
  const now = Date.now();
  const timeZoneGroups = data.getTimeZoneGroups(includeInternal).map((group) => {
    const options = group.zones.reduce((options2, zone) => {
      const info = data.getTimeZoneInfo(zone, now);
      if (!info) {
        return options2;
      }
      options2.push({
        label: info.name,
        value: info.zone,
        searchIndex: getSearchIndex(info, now)
      });
      return options2;
    }, []);
    return {
      label: group.name,
      options
    };
  });
  return timeZoneGroups;
};
const useSelectedTimeZone = (groups, timeZone) => {
  return React.useMemo(() => {
    if (timeZone === void 0) {
      return void 0;
    }
    const tz = lodash.toLower(timeZone);
    const group = groups.find((group2) => {
      if (!group2.label) {
        return isInternal(tz);
      }
      return tz.startsWith(lodash.toLower(group2.label));
    });
    return group == null ? void 0 : group.options.find((option) => {
      if (lodash.isEmpty(tz)) {
        return option.value === data.InternalTimeZones.default;
      }
      return lodash.toLower(option.value) === tz;
    });
  }, [groups, timeZone]);
};
const isInternal = (timeZone) => {
  switch (timeZone) {
    case data.InternalTimeZones.default:
    case data.InternalTimeZones.localBrowserTime:
    case data.InternalTimeZones.utc:
      return true;
    default:
      return false;
  }
};
const useFilterBySearchIndex = () => {
  return React.useCallback((option, searchQuery) => {
    if (!searchQuery || !option.data || !option.data.searchIndex) {
      return true;
    }
    return option.data.searchIndex.indexOf(lodash.toLower(searchQuery)) > -1;
  }, []);
};
const getSearchIndex = (info, timestamp) => {
  const parts = [
    lodash.toLower(info.name),
    lodash.toLower(info.abbreviation),
    lodash.toLower(formatUtcOffset(timestamp, info.zone))
  ];
  for (const country of info.countries) {
    parts.push(lodash.toLower(country.name));
    parts.push(lodash.toLower(country.code));
  }
  return parts.join("|");
};

const quickOptions = [
  { from: "now-5m", to: "now", display: "Last 5 minutes" },
  { from: "now-15m", to: "now", display: "Last 15 minutes" },
  { from: "now-30m", to: "now", display: "Last 30 minutes" },
  { from: "now-1h", to: "now", display: "Last 1 hour" },
  { from: "now-3h", to: "now", display: "Last 3 hours" },
  { from: "now-6h", to: "now", display: "Last 6 hours" },
  { from: "now-12h", to: "now", display: "Last 12 hours" },
  { from: "now-24h", to: "now", display: "Last 24 hours" },
  { from: "now-2d", to: "now", display: "Last 2 days" },
  { from: "now-7d", to: "now", display: "Last 7 days" },
  { from: "now-30d", to: "now", display: "Last 30 days" },
  { from: "now-90d", to: "now", display: "Last 90 days" },
  { from: "now-6M", to: "now", display: "Last 6 months" },
  { from: "now-1y", to: "now", display: "Last 1 year" },
  { from: "now-2y", to: "now", display: "Last 2 years" },
  { from: "now-5y", to: "now", display: "Last 5 years" },
  { from: "now-1d/d", to: "now-1d/d", display: "Yesterday" },
  { from: "now-2d/d", to: "now-2d/d", display: "Day before yesterday" },
  { from: "now-7d/d", to: "now-7d/d", display: "This day last week" },
  { from: "now-1w/w", to: "now-1w/w", display: "Previous week" },
  { from: "now-1M/M", to: "now-1M/M", display: "Previous month" },
  { from: "now-1Q/fQ", to: "now-1Q/fQ", display: "Previous fiscal quarter" },
  { from: "now-1y/y", to: "now-1y/y", display: "Previous year" },
  { from: "now-1y/fy", to: "now-1y/fy", display: "Previous fiscal year" },
  { from: "now/d", to: "now/d", display: "Today" },
  { from: "now/d", to: "now", display: "Today so far" },
  { from: "now/w", to: "now/w", display: "This week" },
  { from: "now/w", to: "now", display: "This week so far" },
  { from: "now/M", to: "now/M", display: "This month" },
  { from: "now/M", to: "now", display: "This month so far" },
  { from: "now/y", to: "now/y", display: "This year" },
  { from: "now/y", to: "now", display: "This year so far" },
  { from: "now/fQ", to: "now", display: "This fiscal quarter so far" },
  { from: "now/fQ", to: "now/fQ", display: "This fiscal quarter" },
  { from: "now/fy", to: "now", display: "This fiscal year so far" },
  { from: "now/fy", to: "now/fy", display: "This fiscal year" }
];
const monthOptions = [
  { label: "January", value: 0 },
  { label: "February", value: 1 },
  { label: "March", value: 2 },
  { label: "April", value: 3 },
  { label: "May", value: 4 },
  { label: "June", value: 5 },
  { label: "July", value: 6 },
  { label: "August", value: 7 },
  { label: "September", value: 8 },
  { label: "October", value: 9 },
  { label: "November", value: 10 },
  { label: "December", value: 11 }
];

const TimePickerFooter = (props) => {
  const {
    timeZone,
    fiscalYearStartMonth,
    timestamp = Date.now(),
    onChangeTimeZone,
    onChangeFiscalYearStartMonth
  } = props;
  const [isEditing, setEditing] = React.useState(false);
  const [editMode, setEditMode] = React.useState("tz");
  const onToggleChangeTimeSettings = React.useCallback(
    (event) => {
      if (event) {
        event.stopPropagation();
      }
      setEditing(!isEditing);
    },
    [isEditing, setEditing]
  );
  const theme = useTheme2();
  const style = getStyle(theme);
  if (!lodash.isString(timeZone)) {
    return null;
  }
  const info = data.getTimeZoneInfo(timeZone, timestamp);
  if (!info) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement(
    "section",
    {
      "aria-label": t("time-picker.footer.time-zone-selection", "Time zone selection"),
      className: style.container
    },
    /* @__PURE__ */ React__default["default"].createElement("div", { className: style.timeZoneContainer }, /* @__PURE__ */ React__default["default"].createElement("div", { className: style.timeZone }, /* @__PURE__ */ React__default["default"].createElement(TimeZoneTitle, { title: info.name }), /* @__PURE__ */ React__default["default"].createElement("div", { className: style.spacer }), /* @__PURE__ */ React__default["default"].createElement(TimeZoneDescription, { info })), /* @__PURE__ */ React__default["default"].createElement(TimeZoneOffset, { timeZone, timestamp })),
    /* @__PURE__ */ React__default["default"].createElement("div", { className: style.spacer }),
    /* @__PURE__ */ React__default["default"].createElement(Button, { variant: "secondary", onClick: onToggleChangeTimeSettings, size: "sm" }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.footer.change-settings-button" }, "Change time settings"))
  ), isEditing ? /* @__PURE__ */ React__default["default"].createElement("div", { className: style.editContainer }, /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement(
    RadioButtonGroup,
    {
      value: editMode,
      options: [
        { label: t("time-picker.footer.time-zone-option", "Time zone"), value: "tz" },
        { label: t("time-picker.footer.fiscal-year-option", "Fiscal year"), value: "fy" }
      ],
      onChange: setEditMode
    }
  )), editMode === "tz" ? /* @__PURE__ */ React__default["default"].createElement(
    "section",
    {
      "data-testid": e2eSelectors.selectors.components.TimeZonePicker.containerV2,
      className: css.cx(style.timeZoneContainer, style.timeSettingContainer)
    },
    /* @__PURE__ */ React__default["default"].createElement(
      TimeZonePicker,
      {
        includeInternal: true,
        onChange: (timeZone2) => {
          onToggleChangeTimeSettings();
          if (lodash.isString(timeZone2)) {
            onChangeTimeZone(timeZone2);
          }
        },
        onBlur: onToggleChangeTimeSettings
      }
    )
  ) : /* @__PURE__ */ React__default["default"].createElement(
    "section",
    {
      "aria-label": e2eSelectors.selectors.components.TimeZonePicker.containerV2,
      className: css.cx(style.timeZoneContainer, style.timeSettingContainer)
    },
    /* @__PURE__ */ React__default["default"].createElement(
      Field,
      {
        className: style.fiscalYearField,
        label: t("time-picker.footer.fiscal-year-start", "Fiscal year start month")
      },
      /* @__PURE__ */ React__default["default"].createElement(
        Select,
        {
          value: fiscalYearStartMonth,
          menuShouldPortal: false,
          options: monthOptions,
          onChange: (value) => {
            var _a;
            if (onChangeFiscalYearStartMonth) {
              onChangeFiscalYearStartMonth((_a = value.value) != null ? _a : 0);
            }
          }
        }
      )
    )
  )) : null);
};
const getStyle = stylesFactory((theme) => {
  return {
    container: css.css`
      border-top: 1px solid ${theme.colors.border.weak};
      padding: 11px;
      display: flex;
      flex-direction: row;
      justify-content: space-between;
      align-items: center;
    `,
    editContainer: css.css`
      border-top: 1px solid ${theme.colors.border.weak};
      padding: 11px;
      justify-content: space-between;
      align-items: center;
      padding: 7px;
    `,
    spacer: css.css`
      margin-left: 7px;
    `,
    timeSettingContainer: css.css`
      padding-top: ${theme.spacing(1)};
    `,
    fiscalYearField: css.css`
      margin-bottom: 0px;
    `,
    timeZoneContainer: css.css`
      display: flex;
      flex-direction: row;
      justify-content: space-between;
      align-items: center;
      flex-grow: 1;
    `,
    timeZone: css.css`
      display: flex;
      flex-direction: row;
      align-items: baseline;
      flex-grow: 1;
    `
  };
});

const getStyles$1i = (theme) => {
  return {
    text: css.css`
      font-size: ${theme.typography.size.md};
      font-weight: ${theme.typography.fontWeightMedium};
      color: ${theme.colors.text.primary};
      margin: 0;
      display: flex;
    `
  };
};
const TimePickerTitle = React.memo(({ children }) => {
  const styles = useStyles2(getStyles$1i);
  return /* @__PURE__ */ React__default["default"].createElement("h3", { className: styles.text }, children);
});
TimePickerTitle.displayName = "TimePickerTitle";

const getFieldValidationMessageStyles = stylesFactory((theme) => {
  const baseStyle = `
      font-size: ${theme.typography.size.sm};
      font-weight: ${theme.typography.fontWeightMedium};
      padding: ${theme.spacing(0.5, 1)};
      color: ${theme.colors.error.contrastText};
      background: ${theme.colors.error.main};
      border-radius: ${theme.shape.borderRadius()};
      position: relative;
      display: inline-block;
      align-self: flex-start;

      a {
        color: ${theme.colors.error.contrastText};
        text-decoration: underline;
      }

      a:hover {
        text-decoration: none;
      }
    `;
  return {
    vertical: css.css`
      ${baseStyle}
      margin: ${theme.spacing(0.5, 0, 0, 0)};

      &:before {
        content: '';
        position: absolute;
        left: 9px;
        top: -5px;
        width: 0;
        height: 0;
        border-width: 0 4px 5px 4px;
        border-color: transparent transparent ${theme.colors.error.main} transparent;
        border-style: solid;
      }
    `,
    horizontal: css.css`
      ${baseStyle}
      margin-left: 10px;

      &:before {
        content: '';
        position: absolute;
        left: -5px;
        top: 9px;
        width: 0;
        height: 0;
        border-width: 4px 5px 4px 0;
        border-color: transparent #e02f44 transparent transparent;
        border-style: solid;
      }
    `,
    fieldValidationMessageIcon: css.css`
      margin-right: ${theme.spacing()};
    `
  };
});
const FieldValidationMessage = ({
  children,
  horizontal,
  className
}) => {
  const theme = useTheme2();
  const styles = getFieldValidationMessageStyles(theme);
  const cssName = css.cx(horizontal ? styles.horizontal : styles.vertical, className);
  return /* @__PURE__ */ React__default["default"].createElement("div", { role: "alert", className: cssName }, /* @__PURE__ */ React__default["default"].createElement(Icon, { className: styles.fieldValidationMessageIcon, name: "exclamation-triangle" }), children);
};

var __defProp$1U = Object.defineProperty;
var __getOwnPropSymbols$1V = Object.getOwnPropertySymbols;
var __hasOwnProp$1V = Object.prototype.hasOwnProperty;
var __propIsEnum$1V = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1U = (obj, key, value) => key in obj ? __defProp$1U(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1U = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1V.call(b, prop))
      __defNormalProp$1U(a, prop, b[prop]);
  if (__getOwnPropSymbols$1V)
    for (var prop of __getOwnPropSymbols$1V(b)) {
      if (__propIsEnum$1V.call(b, prop))
        __defNormalProp$1U(a, prop, b[prop]);
    }
  return a;
};
var __objRest$P = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1V.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1V)
    for (var prop of __getOwnPropSymbols$1V(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1V.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getLabelStyles$2 = stylesFactory((theme) => {
  return {
    label: css.css`
      label: Label;
      font-size: ${theme.typography.size.sm};
      font-weight: ${theme.typography.fontWeightMedium};
      line-height: 1.25;
      margin-bottom: ${theme.spacing(0.5)};
      color: ${theme.colors.text.primary};
      max-width: 480px;
    `,
    labelContent: css.css`
      display: flex;
      align-items: center;
    `,
    description: css.css`
      label: Label-description;
      color: ${theme.colors.text.secondary};
      font-size: ${theme.typography.size.sm};
      font-weight: ${theme.typography.fontWeightRegular};
      margin-top: ${theme.spacing(0.25)};
      display: block;
    `,
    categories: css.css`
      label: Label-categories;
      display: inline-flex;
      align-items: center;
    `,
    chevron: css.css`
      margin: 0 ${theme.spacing(0.25)};
    `
  };
});
const Label$1 = (_a) => {
  var _b = _a, { children, description, className, category } = _b, labelProps = __objRest$P(_b, ["children", "description", "className", "category"]);
  const theme = useTheme2();
  const styles = getLabelStyles$2(theme);
  const categories = category == null ? void 0 : category.map((c, i) => {
    return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.categories, key: `${c}/${i}` }, /* @__PURE__ */ React__default["default"].createElement("span", null, c), /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right", className: styles.chevron }));
  });
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.label, className) }, /* @__PURE__ */ React__default["default"].createElement("label", __spreadValues$1U({}, labelProps), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.labelContent }, categories, children), description && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.description }, description)));
};

var __defProp$1T = Object.defineProperty;
var __getOwnPropSymbols$1U = Object.getOwnPropertySymbols;
var __hasOwnProp$1U = Object.prototype.hasOwnProperty;
var __propIsEnum$1U = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1T = (obj, key, value) => key in obj ? __defProp$1T(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1T = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1U.call(b, prop))
      __defNormalProp$1T(a, prop, b[prop]);
  if (__getOwnPropSymbols$1U)
    for (var prop of __getOwnPropSymbols$1U(b)) {
      if (__propIsEnum$1U.call(b, prop))
        __defNormalProp$1T(a, prop, b[prop]);
    }
  return a;
};
var __objRest$O = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1U.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1U)
    for (var prop of __getOwnPropSymbols$1U(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1U.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getFieldStyles = stylesFactory((theme) => {
  return {
    field: css.css`
      display: flex;
      flex-direction: column;
      margin-bottom: ${theme.spacing(2)};
    `,
    fieldHorizontal: css.css`
      flex-direction: row;
      justify-content: space-between;
      flex-wrap: wrap;
    `,
    fieldValidationWrapper: css.css`
      margin-top: ${theme.spacing(0.5)};
    `,
    fieldValidationWrapperHorizontal: css.css`
      flex: 1 1 100%;
    `,
    validationMessageHorizontalOverflow: css.css`
      width: 0;
      overflow-x: visible;

      & > * {
        white-space: nowrap;
      }
    `
  };
});
const Field = (_a) => {
  var _b = _a, {
    label,
    description,
    horizontal,
    invalid,
    loading,
    disabled,
    required,
    error,
    children,
    className,
    validationMessageHorizontalOverflow,
    htmlFor
  } = _b, otherProps = __objRest$O(_b, [
    "label",
    "description",
    "horizontal",
    "invalid",
    "loading",
    "disabled",
    "required",
    "error",
    "children",
    "className",
    "validationMessageHorizontalOverflow",
    "htmlFor"
  ]);
  const theme = useTheme2();
  const styles = getFieldStyles(theme);
  const inputId = htmlFor != null ? htmlFor : getChildId(children);
  const labelElement = typeof label === "string" ? /* @__PURE__ */ React__default["default"].createElement(Label$1, { htmlFor: inputId, description }, `${label}${required ? " *" : ""}`) : label;
  const childProps = deleteUndefinedProps({ invalid, disabled, loading });
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1T({ className: css.cx(styles.field, horizontal && styles.fieldHorizontal, className) }, otherProps), labelElement, /* @__PURE__ */ React__default["default"].createElement("div", null, React__default["default"].cloneElement(children, childProps), invalid && error && !horizontal && /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.fieldValidationWrapper, {
        [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
      })
    },
    /* @__PURE__ */ React__default["default"].createElement(FieldValidationMessage, null, error)
  )), invalid && error && horizontal && /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.fieldValidationWrapper, styles.fieldValidationWrapperHorizontal, {
        [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
      })
    },
    /* @__PURE__ */ React__default["default"].createElement(FieldValidationMessage, null, error)
  ));
};
function deleteUndefinedProps(obj) {
  for (const key in obj) {
    if (obj[key] === void 0) {
      delete obj[key];
    }
  }
  return obj;
}

function Body$1({ onChange, from, to, timeZone }) {
  const value = inputToValue(from, to);
  const onCalendarChange = useOnCalendarChange(onChange, timeZone);
  const styles = useStyles2(getBodyStyles);
  return /* @__PURE__ */ React__default["default"].createElement(
    Calendar__default["default"],
    {
      selectRange: true,
      next2Label: null,
      prev2Label: null,
      className: styles.body,
      tileClassName: styles.title,
      value,
      nextLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right" }),
      prevLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-left" }),
      onChange: onCalendarChange,
      locale: "en"
    }
  );
}
Body$1.displayName = "Body";
function inputToValue(from, to, invalidDateDefault = new Date()) {
  const fromAsDate = from.toDate();
  const toAsDate = to.toDate();
  const fromAsValidDate = data.dateTime(fromAsDate).isValid() ? fromAsDate : invalidDateDefault;
  const toAsValidDate = data.dateTime(toAsDate).isValid() ? toAsDate : invalidDateDefault;
  if (fromAsValidDate > toAsValidDate) {
    return [toAsValidDate, fromAsValidDate];
  }
  return [fromAsValidDate, toAsValidDate];
}
function useOnCalendarChange(onChange, timeZone) {
  return React.useCallback(
    (value) => {
      if (!Array.isArray(value)) {
        return console.error("onCalendarChange: should be run in selectRange={true}");
      }
      const from = data.dateTimeParse(dateInfo(value[0]), { timeZone });
      const to = data.dateTimeParse(dateInfo(value[1]), { timeZone });
      onChange(from, to);
    },
    [onChange, timeZone]
  );
}
function dateInfo(date) {
  return [date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds()];
}
const getBodyStyles = (theme) => {
  const hasActiveSelector = `.react-calendar__tile--hasActive:not(.react-calendar__tile--range)`;
  return {
    title: css.css`
      color: ${theme.colors.text.primary};
      background-color: ${theme.colors.background.primary};
      font-size: ${theme.typography.size.md};
      border: 1px solid transparent;

      &:hover {
        position: relative;
      }

      &:disabled {
        color: ${theme.colors.action.disabledText};
      }
    `,
    body: css.css`
      z-index: ${theme.zIndex.modal};
      background-color: ${theme.colors.background.primary};
      width: 268px;

      .react-calendar__navigation {
        display: flex;
      }

      .react-calendar__navigation__label,
      .react-calendar__navigation__arrow,
      .react-calendar__navigation {
        padding-top: 4px;
        background-color: inherit;
        color: ${theme.colors.text.primary};
        border: 0;
        font-weight: ${theme.typography.fontWeightMedium};
      }

      .react-calendar__month-view__weekdays {
        background-color: inherit;
        text-align: center;
        color: ${theme.colors.primary.text};

        abbr {
          border: 0;
          text-decoration: none;
          cursor: default;
          display: block;
          padding: 4px 0 4px 0;
        }
      }

      .react-calendar__month-view__days {
        background-color: inherit;
      }

      .react-calendar__tile,
      .react-calendar__tile--now {
        margin-bottom: 4px;
        background-color: inherit;
        height: 26px;
      }

      .react-calendar__navigation__label,
      .react-calendar__navigation > button:focus,
      .time-picker-calendar-tile:focus {
        outline: 0;
      }

      ${hasActiveSelector},
      .react-calendar__tile--active,
      .react-calendar__tile--active:hover {
        color: ${theme.colors.primary.contrastText};
        font-weight: ${theme.typography.fontWeightMedium};
        background: ${theme.colors.primary.main};
        box-shadow: none;
        border: 0px;
      }

      .react-calendar__tile--rangeEnd,
      .react-calendar__tile--rangeStart {
        padding: 0;
        border: 0px;
        color: ${theme.colors.primary.contrastText};
        font-weight: ${theme.typography.fontWeightMedium};
        background: ${theme.colors.primary.main};

        abbr {
          background-color: ${theme.colors.primary.main};
          border-radius: 100px;
          display: block;
          padding-top: 2px;
          height: 26px;
        }
      }

      ${hasActiveSelector},
      .react-calendar__tile--rangeStart {
        border-top-left-radius: 20px;
        border-bottom-left-radius: 20px;
      }

      ${hasActiveSelector},
      .react-calendar__tile--rangeEnd {
        border-top-right-radius: 20px;
        border-bottom-right-radius: 20px;
      }
    `
  };
};

function Footer({ onClose, onApply }) {
  const styles = useStyles2(getFooterStyles);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement(Button, { className: styles.apply, onClick: onApply }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.calendar.apply-button" }, "Apply time range")), /* @__PURE__ */ React__default["default"].createElement(Button, { variant: "secondary", onClick: onClose }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.calendar.cancel-button" }, "Cancel")));
}
Footer.displayName = "Footer";
const getFooterStyles = (theme) => {
  return {
    container: css.css`
      background-color: ${theme.colors.background.primary};
      display: flex;
      justify-content: center;
      padding: 10px;
      align-items: stretch;
    `,
    apply: css.css`
      margin-right: 4px;
      width: 100%;
      justify-content: center;
    `
  };
};

function Header({ onClose }) {
  const styles = useStyles2(getHeaderStyles);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement(TimePickerTitle, null, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.calendar.select-time" }, "Select a time range")), /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      "aria-label": e2eSelectors.selectors.components.TimePicker.calendar.closeButton,
      icon: "times",
      variant: "secondary",
      onClick: onClose
    }
  ));
}
Header.displayName = "Header";
const getHeaderStyles = (theme) => {
  return {
    container: css.css`
      background-color: ${theme.colors.background.primary};
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 7px;
    `
  };
};

var __defProp$1S = Object.defineProperty;
var __getOwnPropSymbols$1T = Object.getOwnPropertySymbols;
var __hasOwnProp$1T = Object.prototype.hasOwnProperty;
var __propIsEnum$1T = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1S = (obj, key, value) => key in obj ? __defProp$1S(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1S = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1T.call(b, prop))
      __defNormalProp$1S(a, prop, b[prop]);
  if (__getOwnPropSymbols$1T)
    for (var prop of __getOwnPropSymbols$1T(b)) {
      if (__propIsEnum$1T.call(b, prop))
        __defNormalProp$1S(a, prop, b[prop]);
    }
  return a;
};
const getStyles$1h = (theme, isReversed = false) => {
  return {
    container: css.css`
      top: 0px;
      position: absolute;
      ${isReversed ? "left" : "right"}: 544px;
      box-shadow: ${theme.shadows.z3};
      background-color: ${theme.colors.background.primary};
      z-index: -1;
      border: 1px solid ${theme.colors.border.weak};
      border-radius: 2px 0 0 2px;

      &:after {
        display: block;
        background-color: ${theme.colors.background.primary};
        width: 19px;
        height: 100%;
        content: ${!isReversed ? " " : ""};
        position: absolute;
        top: 0;
        right: -19px;
        border-left: 1px solid ${theme.colors.border.weak};
      }
    `,
    modal: css.css`
      box-shadow: ${theme.shadows.z3};
      left: 50%;
      position: fixed;
      top: 50%;
      transform: translate(-50%, -50%);
      z-index: ${theme.zIndex.modal};
    `,
    content: css.css`
      margin: 0 auto;
      width: 268px;
    `
  };
};
function TimePickerCalendar(props) {
  const theme = useTheme2();
  const { modalBackdrop } = getModalStyles(theme);
  const styles = getStyles$1h(theme, props.isReversed);
  const { isOpen, isFullscreen, onClose } = props;
  const ref = React__default["default"].createRef();
  const { dialogProps } = dialog.useDialog(
    {
      "aria-label": e2eSelectors.selectors.components.TimePicker.calendar.label
    },
    ref
  );
  const { overlayProps } = overlays.useOverlay(
    {
      isDismissable: true,
      isOpen,
      onClose
    },
    ref
  );
  if (!isOpen) {
    return null;
  }
  if (isFullscreen) {
    return /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, restoreFocus: true, autoFocus: true }, /* @__PURE__ */ React__default["default"].createElement("section", __spreadValues$1S(__spreadValues$1S({ className: styles.container, ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default["default"].createElement(Header, __spreadValues$1S({}, props)), /* @__PURE__ */ React__default["default"].createElement(Body$1, __spreadValues$1S({}, props))));
  }
  return /* @__PURE__ */ React__default["default"].createElement(overlays.OverlayContainer, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: modalBackdrop }), /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default["default"].createElement("section", __spreadValues$1S(__spreadValues$1S({ className: styles.modal, ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.content, "aria-label": e2eSelectors.selectors.components.TimePicker.calendar.label }, /* @__PURE__ */ React__default["default"].createElement(Header, __spreadValues$1S({}, props)), /* @__PURE__ */ React__default["default"].createElement(Body$1, __spreadValues$1S({}, props)), /* @__PURE__ */ React__default["default"].createElement(Footer, __spreadValues$1S({}, props))))));
}
var TimePickerCalendar$1 = React.memo(TimePickerCalendar);
TimePickerCalendar.displayName = "TimePickerCalendar";

const ERROR_MESSAGES = {
  default: () => t("time-picker.range-content.default-error", 'Please enter a past date or "now"'),
  range: () => t("time-picker.range-content.range-error", `"From" can't be after "To"`)
};
const TimeRangeContent = (props) => {
  const { value, isFullscreen = false, timeZone, onApply: onApplyFromProps, isReversed, fiscalYearStartMonth } = props;
  const [fromValue, toValue] = valueToState(value.raw.from, value.raw.to, timeZone);
  const style = useStyles2(getStyles$1g);
  const [from, setFrom] = React.useState(fromValue);
  const [to, setTo] = React.useState(toValue);
  const [isOpen, setOpen] = React.useState(false);
  React.useEffect(() => {
    const [fromValue2, toValue2] = valueToState(value.raw.from, value.raw.to, timeZone);
    setFrom(fromValue2);
    setTo(toValue2);
  }, [value.raw.from, value.raw.to, timeZone]);
  const onOpen = React.useCallback(
    (event) => {
      event.preventDefault();
      setOpen(true);
    },
    [setOpen]
  );
  const onApply = React.useCallback(() => {
    if (to.invalid || from.invalid) {
      return;
    }
    const raw = { from: from.value, to: to.value };
    const timeRange = data.rangeUtil.convertRawToRange(raw, timeZone, fiscalYearStartMonth);
    onApplyFromProps(timeRange);
  }, [from.invalid, from.value, onApplyFromProps, timeZone, to.invalid, to.value, fiscalYearStartMonth]);
  const onChange = React.useCallback(
    (from2, to2) => {
      const [fromValue2, toValue2] = valueToState(from2, to2, timeZone);
      setFrom(fromValue2);
      setTo(toValue2);
    },
    [timeZone]
  );
  const submitOnEnter = (event) => {
    if (event.key === "Enter") {
      onApply();
    }
  };
  const fiscalYear = data.rangeUtil.convertRawToRange({ from: "now/fy", to: "now/fy" }, timeZone, fiscalYearStartMonth);
  const fiscalYearMessage = t("time-picker.range-content.fiscal-year", "Fiscal year");
  const fyTooltip = /* @__PURE__ */ React__default["default"].createElement("div", { className: style.tooltip }, data.rangeUtil.isFiscal(value) ? /* @__PURE__ */ React__default["default"].createElement(
    Tooltip,
    {
      content: `${fiscalYearMessage}: ${fiscalYear.from.format("MMM-DD")} - ${fiscalYear.to.format("MMM-DD")}`
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "info-circle" })
  ) : null);
  const icon = /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      "aria-label": e2eSelectors.selectors.components.TimePicker.calendar.openButton,
      icon: "calendar-alt",
      variant: "secondary",
      type: "button",
      onClick: onOpen
    }
  );
  return /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement("div", { className: style.fieldContainer }, /* @__PURE__ */ React__default["default"].createElement(
    Field,
    {
      label: t("time-picker.range-content.from-input", "From"),
      invalid: from.invalid,
      error: from.errorMessage
    },
    /* @__PURE__ */ React__default["default"].createElement(
      Input,
      {
        onClick: (event) => event.stopPropagation(),
        onChange: (event) => onChange(event.currentTarget.value, to.value),
        addonAfter: icon,
        onKeyDown: submitOnEnter,
        "aria-label": e2eSelectors.selectors.components.TimePicker.fromField,
        value: from.value
      }
    )
  ), fyTooltip), /* @__PURE__ */ React__default["default"].createElement("div", { className: style.fieldContainer }, /* @__PURE__ */ React__default["default"].createElement(Field, { label: t("time-picker.range-content.to-input", "To"), invalid: to.invalid, error: to.errorMessage }, /* @__PURE__ */ React__default["default"].createElement(
    Input,
    {
      onClick: (event) => event.stopPropagation(),
      onChange: (event) => onChange(from.value, event.currentTarget.value),
      addonAfter: icon,
      onKeyDown: submitOnEnter,
      "aria-label": e2eSelectors.selectors.components.TimePicker.toField,
      value: to.value
    }
  )), fyTooltip), /* @__PURE__ */ React__default["default"].createElement(Button, { "data-testid": e2eSelectors.selectors.components.TimePicker.applyTimeRange, type: "button", onClick: onApply }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.range-content.apply-button" }, "Apply time range")), /* @__PURE__ */ React__default["default"].createElement(
    TimePickerCalendar$1,
    {
      isFullscreen,
      isOpen,
      from: data.dateTimeParse(from.value),
      to: data.dateTimeParse(to.value),
      onApply,
      onClose: () => setOpen(false),
      onChange,
      timeZone,
      isReversed
    }
  ));
};
function isRangeInvalid(from, to, timezone) {
  const raw = { from, to };
  const timeRange = data.rangeUtil.convertRawToRange(raw, timezone);
  const valid = timeRange.from.isSame(timeRange.to) || timeRange.from.isBefore(timeRange.to);
  return !valid;
}
function valueToState(rawFrom, rawTo, timeZone) {
  const fromValue = valueAsString(rawFrom, timeZone);
  const toValue = valueAsString(rawTo, timeZone);
  const fromInvalid = !isValid$1(fromValue, false, timeZone);
  const toInvalid = !isValid$1(toValue, true, timeZone);
  const rangeInvalid = isRangeInvalid(fromValue, toValue, timeZone) && !toInvalid;
  return [
    {
      value: fromValue,
      invalid: fromInvalid || rangeInvalid,
      errorMessage: rangeInvalid && !fromInvalid ? ERROR_MESSAGES.range() : ERROR_MESSAGES.default()
    },
    { value: toValue, invalid: toInvalid, errorMessage: ERROR_MESSAGES.default() }
  ];
}
function valueAsString(value, timeZone) {
  if (data.isDateTime(value)) {
    return data.dateTimeFormat(value, { timeZone });
  }
  return value;
}
function isValid$1(value, roundUp, timeZone) {
  if (data.isDateTime(value)) {
    return value.isValid();
  }
  if (data.dateMath.isMathString(value)) {
    return data.dateMath.isValid(value);
  }
  const parsed = data.dateTimeParse(value, { roundUp, timeZone });
  return parsed.isValid();
}
function getStyles$1g(theme) {
  return {
    fieldContainer: css.css`
      display: flex;
    `,
    tooltip: css.css`
      padding-left: ${theme.spacing(1)};
      padding-top: ${theme.spacing(3)};
    `
  };
}

const getStyles$1f = (theme) => {
  return {
    container: css.css`
      display: flex;
      align-items: center;
      flex-direction: row-reverse;
      justify-content: space-between;
    `,
    selected: css.css`
      background: ${theme.colors.action.selected};
      font-weight: ${theme.typography.fontWeightMedium};
    `,
    radio: css.css`
      opacity: 0;
      width: 0 !important;

      &:focus-visible + label {
        ${getFocusStyles(theme)};
      }
    `,
    label: css.css`
      cursor: pointer;
      flex: 1;
      padding: 7px 9px 7px 9px;

      &:hover {
        background: ${theme.colors.action.hover};
        cursor: pointer;
      }
    `
  };
};
const TimeRangeOption = React.memo(({ value, onSelect, selected = false, name }) => {
  const styles = useStyles2(getStyles$1f);
  const id = uuid.v4();
  return /* @__PURE__ */ React__default["default"].createElement("li", { className: css.cx(styles.container, selected && styles.selected) }, /* @__PURE__ */ React__default["default"].createElement(
    "input",
    {
      className: styles.radio,
      checked: selected,
      name,
      type: "checkbox",
      id,
      onChange: () => onSelect(value)
    }
  ), /* @__PURE__ */ React__default["default"].createElement("label", { className: styles.label, htmlFor: id }, value.display));
});
TimeRangeOption.displayName = "TimeRangeOption";

var __defProp$1R = Object.defineProperty;
var __getOwnPropSymbols$1S = Object.getOwnPropertySymbols;
var __hasOwnProp$1S = Object.prototype.hasOwnProperty;
var __propIsEnum$1S = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1R = (obj, key, value) => key in obj ? __defProp$1R(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1R = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1S.call(b, prop))
      __defNormalProp$1R(a, prop, b[prop]);
  if (__getOwnPropSymbols$1S)
    for (var prop of __getOwnPropSymbols$1S(b)) {
      if (__propIsEnum$1S.call(b, prop))
        __defNormalProp$1R(a, prop, b[prop]);
    }
  return a;
};
const getStyles$1e = stylesFactory(() => {
  return {
    title: css.css`
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 8px 16px 5px 9px;
    `
  };
});
const getOptionsStyles = stylesFactory(() => {
  return {
    grow: css.css`
      flex-grow: 1;
      align-items: flex-start;
    `
  };
});
const TimeRangeList = (props) => {
  const styles = getStyles$1e();
  const { title, options, placeholderEmpty } = props;
  if (typeof placeholderEmpty !== "undefined" && options.length <= 0) {
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, placeholderEmpty);
  }
  if (!title) {
    return /* @__PURE__ */ React__default["default"].createElement(Options$1, __spreadValues$1R({}, props));
  }
  return /* @__PURE__ */ React__default["default"].createElement("section", { "aria-label": title }, /* @__PURE__ */ React__default["default"].createElement("fieldset", null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.title }, /* @__PURE__ */ React__default["default"].createElement(TimePickerTitle, null, title)), /* @__PURE__ */ React__default["default"].createElement(Options$1, __spreadValues$1R({}, props))));
};
const Options$1 = ({ options, value, onChange, title }) => {
  const styles = getOptionsStyles();
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("ul", { "aria-roledescription": t("time-picker.time-range.aria-role", "Time range selection") }, options.map((option, index) => /* @__PURE__ */ React__default["default"].createElement(
    TimeRangeOption,
    {
      key: keyForOption(option, index),
      value: option,
      selected: isEqual(option, value),
      onSelect: onChange,
      name: title != null ? title : t("time-picker.time-range.default-title", "Time ranges")
    }
  ))), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.grow }));
};
function keyForOption(option, index) {
  return `${option.from}-${option.to}-${index}`;
}
function isEqual(x, y) {
  if (!y || !x) {
    return false;
  }
  return y.from === x.from && y.to === x.to;
}

const mapOptionToTimeRange = (option, timeZone) => {
  return data.rangeUtil.convertRawToRange({ from: option.from, to: option.to }, timeZone);
};
const mapRangeToTimeOption = (range, timeZone) => {
  const from = data.dateTimeFormat(range.from, { timeZone });
  const to = data.dateTimeFormat(range.to, { timeZone });
  return {
    from,
    to,
    display: `${from} to ${to}`
  };
};

var __defProp$1Q = Object.defineProperty;
var __defProps$1c = Object.defineProperties;
var __getOwnPropDescs$1c = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1R = Object.getOwnPropertySymbols;
var __hasOwnProp$1R = Object.prototype.hasOwnProperty;
var __propIsEnum$1R = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1Q = (obj, key, value) => key in obj ? __defProp$1Q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1Q = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1R.call(b, prop))
      __defNormalProp$1Q(a, prop, b[prop]);
  if (__getOwnPropSymbols$1R)
    for (var prop of __getOwnPropSymbols$1R(b)) {
      if (__propIsEnum$1R.call(b, prop))
        __defNormalProp$1Q(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1c = (a, b) => __defProps$1c(a, __getOwnPropDescs$1c(b));
const TimePickerContentWithScreenSize = (props) => {
  const {
    quickOptions = [],
    isReversed,
    isFullscreen,
    hideQuickRanges,
    timeZone,
    fiscalYearStartMonth,
    value,
    onChange,
    history,
    showHistory,
    className,
    hideTimeZone,
    onChangeTimeZone,
    onChangeFiscalYearStartMonth
  } = props;
  const isHistoryEmpty = !(history == null ? void 0 : history.length);
  const isContainerTall = isFullscreen && showHistory || !isFullscreen && (showHistory && !isHistoryEmpty || !hideQuickRanges);
  const theme = useTheme2();
  const styles = getStyles$1d(theme, isReversed, hideQuickRanges, isContainerTall, isFullscreen);
  const historyOptions = mapToHistoryOptions(history, timeZone);
  const timeOption = useTimeOption(value.raw, quickOptions);
  const [searchTerm, setSearchQuery] = React.useState("");
  const filteredQuickOptions = quickOptions.filter((o) => o.display.toLowerCase().includes(searchTerm.toLowerCase()));
  const onChangeTimeOption = (timeOption2) => {
    return onChange(mapOptionToTimeRange(timeOption2));
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { id: "TimePickerContent", className: css.cx(styles.container, className) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.body }, (!isFullscreen || !hideQuickRanges) && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightSide }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.timeRangeFilter }, /* @__PURE__ */ React__default["default"].createElement(
    FilterInput,
    {
      width: 0,
      autoFocus: true,
      value: searchTerm,
      onChange: setSearchQuery,
      placeholder: t("time-picker.content.filter-placeholder", "Search quick ranges")
    }
  )), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, null, !isFullscreen && /* @__PURE__ */ React__default["default"].createElement(NarrowScreenForm, __spreadProps$1c(__spreadValues$1Q({}, props), { historyOptions })), !hideQuickRanges && /* @__PURE__ */ React__default["default"].createElement(TimeRangeList, { options: filteredQuickOptions, onChange: onChangeTimeOption, value: timeOption }))), isFullscreen && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.leftSide }, /* @__PURE__ */ React__default["default"].createElement(FullScreenForm, __spreadProps$1c(__spreadValues$1Q({}, props), { historyOptions })))), !hideTimeZone && isFullscreen && /* @__PURE__ */ React__default["default"].createElement(
    TimePickerFooter,
    {
      timeZone,
      fiscalYearStartMonth,
      onChangeTimeZone,
      onChangeFiscalYearStartMonth
    }
  ));
};
const TimePickerContent = (props) => {
  const { widthOverride } = props;
  const theme = useTheme2();
  const isFullscreen = (widthOverride || window.innerWidth) >= theme.breakpoints.values.lg;
  return /* @__PURE__ */ React__default["default"].createElement(TimePickerContentWithScreenSize, __spreadProps$1c(__spreadValues$1Q({}, props), { isFullscreen }));
};
const NarrowScreenForm = (props) => {
  const { value, hideQuickRanges, onChange, timeZone, historyOptions = [], showHistory } = props;
  const theme = useTheme2();
  const styles = getNarrowScreenStyles(theme);
  const isAbsolute = data.isDateTime(value.raw.from) || data.isDateTime(value.raw.to);
  const [collapsedFlag, setCollapsedFlag] = React.useState(!isAbsolute);
  const collapsed = hideQuickRanges ? false : collapsedFlag;
  const onChangeTimeOption = (timeOption) => {
    return onChange(mapOptionToTimeRange(timeOption, timeZone));
  };
  return /* @__PURE__ */ React__default["default"].createElement("fieldset", null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.header }, /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      type: "button",
      className: styles.expandButton,
      onClick: () => {
        if (!hideQuickRanges) {
          setCollapsedFlag(!collapsed);
        }
      },
      "data-testid": e2eSelectors.selectors.components.TimePicker.absoluteTimeRangeTitle,
      "aria-expanded": !collapsed,
      "aria-controls": "expanded-timerange"
    },
    /* @__PURE__ */ React__default["default"].createElement(TimePickerTitle, null, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.absolute.title" }, "Absolute time range")),
    !hideQuickRanges && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: !collapsed ? "angle-up" : "angle-down" })
  )), !collapsed && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.body, id: "expanded-timerange" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.form }, /* @__PURE__ */ React__default["default"].createElement(TimeRangeContent, { value, onApply: onChange, timeZone, isFullscreen: false })), showHistory && /* @__PURE__ */ React__default["default"].createElement(
    TimeRangeList,
    {
      title: t("time-picker.absolute.recent-title", "Recently used absolute ranges"),
      options: historyOptions,
      onChange: onChangeTimeOption,
      placeholderEmpty: null
    }
  )));
};
const FullScreenForm = (props) => {
  const { onChange, value, timeZone, fiscalYearStartMonth, isReversed, historyOptions } = props;
  const theme = useTheme2();
  const styles = getFullScreenStyles(theme, props.hideQuickRanges);
  const onChangeTimeOption = (timeOption) => {
    return onChange(mapOptionToTimeRange(timeOption, timeZone));
  };
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.title, "data-testid": e2eSelectors.selectors.components.TimePicker.absoluteTimeRangeTitle }, /* @__PURE__ */ React__default["default"].createElement(TimePickerTitle, null, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.absolute.title" }, "Absolute time range"))), /* @__PURE__ */ React__default["default"].createElement(
    TimeRangeContent,
    {
      value,
      timeZone,
      fiscalYearStartMonth,
      onApply: onChange,
      isFullscreen: true,
      isReversed
    }
  )), props.showHistory && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.recent }, /* @__PURE__ */ React__default["default"].createElement(
    TimeRangeList,
    {
      title: t("time-picker.absolute.recent-title", "Recently used absolute ranges"),
      options: historyOptions || [],
      onChange: onChangeTimeOption,
      placeholderEmpty: /* @__PURE__ */ React__default["default"].createElement(EmptyRecentList, null)
    }
  )));
};
const EmptyRecentList = React.memo(() => {
  const theme = useTheme2();
  const styles = getEmptyListStyles(theme);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.content.empty-recent-list" }, /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement("span", null, "It looks like you haven't used this time picker before. As soon as you enter some time intervals, recently used intervals will appear here.")), /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement(
    "a",
    {
      className: styles.link,
      href: "https://grafana.com/docs/grafana/latest/dashboards/time-range-controls",
      target: "_new"
    },
    "Read the documentation"
  ), /* @__PURE__ */ React__default["default"].createElement("span", null, " to find out more about how to enter custom time ranges."))));
});
function mapToHistoryOptions(ranges, timeZone) {
  if (!Array.isArray(ranges) || ranges.length === 0) {
    return [];
  }
  return ranges.map((range) => mapRangeToTimeOption(range, timeZone));
}
EmptyRecentList.displayName = "EmptyRecentList";
const useTimeOption = (raw, quickOptions) => {
  return React.useMemo(() => {
    if (!data.rangeUtil.isRelativeTimeRange(raw)) {
      return;
    }
    return quickOptions.find((option) => {
      return option.from === raw.from && option.to === raw.to;
    });
  }, [raw, quickOptions]);
};
const getStyles$1d = stylesFactory((theme, isReversed, hideQuickRanges, isContainerTall, isFullscreen) => {
  return {
    container: css.css`
      background: ${theme.colors.background.primary};
      box-shadow: ${theme.shadows.z3};
      width: ${isFullscreen ? "546px" : "262px"};
      border-radius: 2px;
      border: 1px solid ${theme.colors.border.weak};
      ${isReversed ? "left" : "right"}: 0;
    `,
    body: css.css`
      display: flex;
      flex-direction: row-reverse;
      height: ${isContainerTall ? "381px" : "217px"};
    `,
    leftSide: css.css`
      display: flex;
      flex-direction: column;
      border-right: ${isReversed ? "none" : `1px solid ${theme.colors.border.weak}`};
      width: ${!hideQuickRanges ? "60%" : "100%"};
      overflow: hidden;
      order: ${isReversed ? 1 : 0};
    `,
    rightSide: css.css`
      width: ${isFullscreen ? "40%" : "100%"}; !important;
      border-right: ${isReversed ? `1px solid ${theme.colors.border.weak}` : "none"};
      display: flex;
      flex-direction: column;
    `,
    timeRangeFilter: css.css`
      padding: ${theme.spacing(1)};
    `,
    spacing: css.css`
      margin-top: 16px;
    `
  };
});
const getNarrowScreenStyles = stylesFactory((theme) => {
  return {
    header: css.css`
      display: flex;
      flex-direction: row;
      justify-content: space-between;
      align-items: center;
      border-bottom: 1px solid ${theme.colors.border.weak};
      padding: 7px 9px 7px 9px;
    `,
    expandButton: css.css`
      background-color: transparent;
      border: none;
      display: flex;
      width: 100%;

      &:focus-visible {
        ${getFocusStyles(theme)}
      }
    `,
    body: css.css`
      border-bottom: 1px solid ${theme.colors.border.weak};
    `,
    form: css.css`
      padding: 7px 9px 7px 9px;
    `
  };
});
const getFullScreenStyles = stylesFactory((theme, hideQuickRanges) => {
  return {
    container: css.css`
      padding-top: 9px;
      padding-left: 11px;
      padding-right: ${!hideQuickRanges ? "20%" : "11px"};
    `,
    title: css.css`
      margin-bottom: 11px;
    `,
    recent: css.css`
      flex-grow: 1;
      display: flex;
      flex-direction: column;
      justify-content: flex-end;
      padding-top: ${theme.spacing(1)};
    `
  };
});
const getEmptyListStyles = stylesFactory((theme) => {
  return {
    container: css.css`
      padding: 12px;
      margin: 12px;

      a,
      span {
        font-size: 13px;
      }\
    `,
    link: css.css`
      color: ${theme.colors.text.link};
    `
  };
});

var __defProp$1P = Object.defineProperty;
var __getOwnPropSymbols$1Q = Object.getOwnPropertySymbols;
var __hasOwnProp$1Q = Object.prototype.hasOwnProperty;
var __propIsEnum$1Q = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1P = (obj, key, value) => key in obj ? __defProp$1P(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1P = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1Q.call(b, prop))
      __defNormalProp$1P(a, prop, b[prop]);
  if (__getOwnPropSymbols$1Q)
    for (var prop of __getOwnPropSymbols$1Q(b)) {
      if (__propIsEnum$1Q.call(b, prop))
        __defNormalProp$1P(a, prop, b[prop]);
    }
  return a;
};
function TimeRangePicker(props) {
  const [isOpen, setOpen] = React.useState(false);
  const {
    value,
    onMoveBackward,
    onMoveForward,
    onZoom,
    timeZone,
    fiscalYearStartMonth,
    timeSyncButton,
    isSynced,
    history,
    onChangeTimeZone,
    onChangeFiscalYearStartMonth,
    hideQuickRanges,
    widthOverride,
    isOnCanvas
  } = props;
  const onChange = (timeRange) => {
    props.onChange(timeRange);
    setOpen(false);
  };
  const onOpen = (event) => {
    event.stopPropagation();
    event.preventDefault();
    setOpen(!isOpen);
  };
  const onClose = () => {
    setOpen(false);
  };
  const ref = React.createRef();
  const { overlayProps, underlayProps } = overlays.useOverlay({ onClose, isDismissable: true, isOpen }, ref);
  const { dialogProps } = dialog.useDialog({}, ref);
  const theme = useTheme2();
  const styles = useStyles2(getStyles$1c);
  const { modalBackdrop } = getModalStyles(theme);
  const hasAbsolute = data.isDateTime(value.raw.from) || data.isDateTime(value.raw.to);
  const variant = isSynced ? "active" : isOnCanvas ? "canvas" : "default";
  const currentTimeRange = formattedRange(value, timeZone);
  return /* @__PURE__ */ React__default["default"].createElement(ButtonGroup, { className: styles.container }, hasAbsolute && /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    {
      "aria-label": t("time-picker.range-picker.backwards-time-aria-label", "Move time range backwards"),
      variant,
      onClick: onMoveBackward,
      icon: "angle-left",
      narrow: true
    }
  ), /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: /* @__PURE__ */ React__default["default"].createElement(TimePickerTooltip, { timeRange: value, timeZone }), placement: "bottom", interactive: true }, /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    {
      "data-testid": e2eSelectors.selectors.components.TimePicker.openButton,
      "aria-label": t("time-picker.range-picker.current-time-selected", "Time range selected: {{currentTimeRange}}", {
        currentTimeRange
      }),
      "aria-controls": "TimePickerContent",
      onClick: onOpen,
      icon: "clock-nine",
      isOpen,
      variant
    },
    /* @__PURE__ */ React__default["default"].createElement(TimePickerButtonLabel, __spreadValues$1P({}, props))
  )), isOpen && /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1P({ role: "presentation", className: css.cx(modalBackdrop, styles.backdrop) }, underlayProps)), /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true }, /* @__PURE__ */ React__default["default"].createElement("section", __spreadValues$1P(__spreadValues$1P({ className: styles.content, ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default["default"].createElement(
    TimePickerContent,
    {
      timeZone,
      fiscalYearStartMonth,
      value,
      onChange,
      quickOptions,
      history,
      showHistory: true,
      widthOverride,
      onChangeTimeZone,
      onChangeFiscalYearStartMonth,
      hideQuickRanges
    }
  )))), timeSyncButton, hasAbsolute && /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    {
      "aria-label": t("time-picker.range-picker.forwards-time-aria-label", "Move time range forwards"),
      onClick: onMoveForward,
      icon: "angle-right",
      narrow: true,
      variant
    }
  ), /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: ZoomOutTooltip, placement: "bottom" }, /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    {
      "aria-label": t("time-picker.range-picker.zoom-out-button", "Zoom out time range"),
      onClick: onZoom,
      icon: "search-minus",
      variant
    }
  )));
}
TimeRangePicker.displayName = "TimeRangePicker";
const ZoomOutTooltip = () => /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.range-picker.zoom-out-tooltip" }, "Time range zoom out ", /* @__PURE__ */ React__default["default"].createElement("br", null), " CTRL+Z"));
const TimePickerTooltip = ({ timeRange, timeZone }) => {
  const styles = useStyles2(getLabelStyles$1);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, data.dateTimeFormat(timeRange.from, { timeZone }), /* @__PURE__ */ React__default["default"].createElement("div", { className: "text-center" }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.range-picker.to" }, "to")), data.dateTimeFormat(timeRange.to, { timeZone }), /* @__PURE__ */ React__default["default"].createElement("div", { className: "text-center" }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.utc }, data.timeZoneFormatUserFriendly(timeZone))));
};
const TimePickerButtonLabel = React.memo(({ hideText, value, timeZone }) => {
  const styles = useStyles2(getLabelStyles$1);
  if (hideText) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement("span", null, formattedRange(value, timeZone)), /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.utc }, data.rangeUtil.describeTimeRangeAbbreviation(value, timeZone)));
});
TimePickerButtonLabel.displayName = "TimePickerButtonLabel";
const formattedRange = (value, timeZone) => {
  const adjustedTimeRange = {
    to: data.dateMath.isMathString(value.raw.to) ? value.raw.to : value.to,
    from: data.dateMath.isMathString(value.raw.from) ? value.raw.from : value.from
  };
  return data.rangeUtil.describeTimeRange(adjustedTimeRange, timeZone);
};
const getStyles$1c = (theme) => {
  return {
    container: css.css`
      position: relative;
      display: flex;
      vertical-align: middle;
    `,
    backdrop: css.css({
      display: "none",
      [theme.breakpoints.down("sm")]: {
        display: "block"
      }
    }),
    content: css.css({
      position: "absolute",
      right: 0,
      top: "116%",
      zIndex: theme.zIndex.dropdown,
      [theme.breakpoints.down("sm")]: {
        position: "fixed",
        right: "50%",
        top: "50%",
        transform: "translate(50%, -50%)",
        zIndex: theme.zIndex.modal
      }
    })
  };
};
const getLabelStyles$1 = (theme) => {
  return {
    container: css.css`
      display: flex;
      align-items: center;
      white-space: nowrap;
    `,
    utc: css.css`
      color: ${theme.v1.palette.orange};
      font-size: ${theme.typography.size.sm};
      padding-left: 6px;
      line-height: 28px;
      vertical-align: bottom;
      font-weight: ${theme.typography.fontWeightMedium};
    `
  };
};

const POPUP_CLASS_NAME = "time-of-day-picker-panel";
const TimeOfDayPicker = ({
  minuteStep = 1,
  showHour = true,
  showSeconds = false,
  onChange,
  value,
  size = "auto",
  disabled,
  disabledHours,
  disabledMinutes,
  disabledSeconds
}) => {
  const styles = useStyles2(getStyles$1b);
  return /* @__PURE__ */ React__default["default"].createElement(
    RcTimePicker__default["default"],
    {
      className: css.cx(inputSizes()[size], styles.input),
      popupClassName: css.cx(styles.picker, POPUP_CLASS_NAME),
      defaultValue: data.dateTimeAsMoment(),
      onChange: (value2) => onChange(data.dateTime(value2)),
      allowEmpty: false,
      showSecond: showSeconds,
      value: data.dateTimeAsMoment(value),
      showHour,
      minuteStep,
      inputIcon: /* @__PURE__ */ React__default["default"].createElement(Caret, { wrapperStyle: styles.caretWrapper }),
      disabled,
      disabledHours,
      disabledMinutes,
      disabledSeconds
    }
  );
};
const Caret = ({ wrapperStyle = "" }) => {
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: wrapperStyle }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-down" }));
};
const getStyles$1b = (theme) => {
  const bgColor = theme.components.input.background;
  const menuShadowColor = theme.v1.palette.black;
  const optionBgHover = theme.colors.background.secondary;
  const borderRadius = theme.shape.borderRadius(1);
  const borderColor = theme.components.input.borderColor;
  return {
    caretWrapper: css.css`
      position: absolute;
      right: 8px;
      top: 50%;
      transform: translateY(-50%);
      display: inline-block;
      text-align: right;
      color: ${theme.colors.text.secondary};
    `,
    picker: css.css`
      .rc-time-picker-panel-select {
        font-size: 14px;
        background-color: ${bgColor};
        border-color: ${borderColor};
        li {
          outline-width: 2px;
          &.rc-time-picker-panel-select-option-selected {
            background-color: inherit;
            border: 1px solid ${theme.v1.palette.orange};
            border-radius: ${borderRadius};
          }

          &:hover {
            background: ${optionBgHover};
          }

          &.rc-time-picker-panel-select-option-disabled {
            color: ${theme.colors.action.disabledText};
          }
        }
      }

      .rc-time-picker-panel-inner {
        box-shadow: 0px 4px 4px ${menuShadowColor};
        background-color: ${bgColor};
        border-color: ${borderColor};
        border-radius: ${borderRadius};
        margin-top: 3px;

        .rc-time-picker-panel-input-wrap {
          margin-right: 2px;

          &,
          .rc-time-picker-panel-input {
            background-color: ${bgColor};
            padding-top: 2px;
          }
        }

        .rc-time-picker-panel-combobox {
          display: flex;
        }
      }
    `,
    input: css.css`
      .rc-time-picker-input {
        background-color: ${bgColor};
        border-radius: ${borderRadius};
        border-color: ${borderColor};
        height: ${theme.spacing(4)};

        &:focus {
          ${focusCss(theme)}
        }

        &:disabled {
          background-color: ${theme.colors.action.disabledBackground};
          color: ${theme.colors.action.disabledText};
          border: 1px solid ${theme.colors.action.disabledBackground};
          &:focus {
            box-shadow: none;
          }
        }
      }
    `
  };
};

const weekStarts = [
  { value: "", label: "Default" },
  { value: "saturday", label: "Saturday" },
  { value: "sunday", label: "Sunday" },
  { value: "monday", label: "Monday" }
];
const WeekStartPicker = (props) => {
  var _a;
  const { onChange, width, autoFocus = false, onBlur, value, disabled = false, inputId } = props;
  const onChangeWeekStart = React.useCallback(
    (selectable) => {
      if (selectable.value !== void 0) {
        onChange(selectable.value);
      }
    },
    [onChange]
  );
  return /* @__PURE__ */ React__default["default"].createElement(
    Select,
    {
      inputId,
      value: (_a = weekStarts.find((item) => item.value === value)) == null ? void 0 : _a.value,
      placeholder: e2eSelectors.selectors.components.WeekStartPicker.placeholder,
      autoFocus,
      openMenuOnFocus: true,
      width,
      options: weekStarts,
      onChange: onChangeWeekStart,
      onBlur,
      disabled
    }
  );
};

var __defProp$1O = Object.defineProperty;
var __getOwnPropSymbols$1P = Object.getOwnPropertySymbols;
var __hasOwnProp$1P = Object.prototype.hasOwnProperty;
var __propIsEnum$1P = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1O = (obj, key, value) => key in obj ? __defProp$1O(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1O = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1P.call(b, prop))
      __defNormalProp$1O(a, prop, b[prop]);
  if (__getOwnPropSymbols$1P)
    for (var prop of __getOwnPropSymbols$1P(b)) {
      if (__propIsEnum$1P.call(b, prop))
        __defNormalProp$1O(a, prop, b[prop]);
    }
  return a;
};
const DatePicker = React.memo((props) => {
  const styles = useStyles2(getStyles$1a);
  const { isOpen, onClose } = props;
  if (!isOpen) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(ClickOutsideWrapper, { useCapture: true, includeButtonPress: false, onClick: onClose }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modal, "data-testid": "date-picker" }, /* @__PURE__ */ React__default["default"].createElement(Body, __spreadValues$1O({}, props))));
});
DatePicker.displayName = "DatePicker";
const Body = React.memo(({ value, minDate, maxDate, onChange }) => {
  const styles = useStyles2(getBodyStyles);
  return /* @__PURE__ */ React__default["default"].createElement(
    Calendar__default["default"],
    {
      className: styles.body,
      tileClassName: styles.title,
      value: value || new Date(),
      minDate,
      maxDate,
      nextLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right" }),
      prevLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-left" }),
      onChange: (ev) => {
        if (!Array.isArray(ev)) {
          onChange(ev);
        }
      },
      locale: "en"
    }
  );
});
Body.displayName = "Body";
const getStyles$1a = (theme) => {
  return {
    modal: css.css`
      z-index: ${theme.zIndex.modal};
      position: absolute;
      box-shadow: ${theme.shadows.z3};
      background-color: ${theme.colors.background.primary};
      border: 1px solid ${theme.colors.border.weak};
      border-radius: 2px 0 0 2px;

      button:disabled {
        color: ${theme.colors.text.disabled};
      }
    `
  };
};

var __defProp$1N = Object.defineProperty;
var __getOwnPropSymbols$1O = Object.getOwnPropertySymbols;
var __hasOwnProp$1O = Object.prototype.hasOwnProperty;
var __propIsEnum$1O = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1N = (obj, key, value) => key in obj ? __defProp$1N(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1N = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1O.call(b, prop))
      __defNormalProp$1N(a, prop, b[prop]);
  if (__getOwnPropSymbols$1O)
    for (var prop of __getOwnPropSymbols$1O(b)) {
      if (__propIsEnum$1O.call(b, prop))
        __defNormalProp$1N(a, prop, b[prop]);
    }
  return a;
};
var __objRest$N = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1O.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1O)
    for (var prop of __getOwnPropSymbols$1O(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1O.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const formatDate = (date) => data.dateTime(date).format("L");
const DatePickerWithInput = (_a) => {
  var _b = _a, {
    value,
    minDate,
    maxDate,
    onChange,
    closeOnSelect,
    placeholder = "Date"
  } = _b, rest = __objRest$N(_b, [
    "value",
    "minDate",
    "maxDate",
    "onChange",
    "closeOnSelect",
    "placeholder"
  ]);
  const [open, setOpen] = React__default["default"].useState(false);
  const styles = useStyles2(getStyles$19);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement(
    Input,
    __spreadValues$1N({
      type: "text",
      autoComplete: "off",
      placeholder,
      value: value ? formatDate(value) : value,
      onClick: () => setOpen(true),
      onChange: (ev) => {
        if (ev.target.value === "") {
          onChange("");
        }
      },
      className: styles.input
    }, rest)
  ), /* @__PURE__ */ React__default["default"].createElement(
    DatePicker,
    {
      isOpen: open,
      value: value && typeof value !== "string" ? value : data.dateTime().toDate(),
      minDate,
      maxDate,
      onChange: (ev) => {
        onChange(ev);
        if (closeOnSelect) {
          setOpen(false);
        }
      },
      onClose: () => setOpen(false)
    }
  ));
};
const getStyles$19 = () => {
  return {
    container: css.css`
      position: relative;
    `,
    input: css.css`
    /* hides the native Calendar picker icon given when using type=date */
    input[type='date']::-webkit-inner-spin-button,
    input[type='date']::-webkit-calendar-picker-indicator {
    display: none;
    -webkit-appearance: none;
    `
  };
};

function isValid(value, roundUp, timeZone) {
  if (data.isDateTime(value)) {
    return value.isValid();
  }
  if (data.dateMath.isMathString(value)) {
    return data.dateMath.isValid(value);
  }
  const parsed = data.dateTimeParse(value, { roundUp, timeZone });
  return parsed.isValid();
}

var __defProp$1M = Object.defineProperty;
var __getOwnPropSymbols$1N = Object.getOwnPropertySymbols;
var __hasOwnProp$1N = Object.prototype.hasOwnProperty;
var __propIsEnum$1N = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1M = (obj, key, value) => key in obj ? __defProp$1M(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1M = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1N.call(b, prop))
      __defNormalProp$1M(a, prop, b[prop]);
  if (__getOwnPropSymbols$1N)
    for (var prop of __getOwnPropSymbols$1N(b)) {
      if (__propIsEnum$1N.call(b, prop))
        __defNormalProp$1M(a, prop, b[prop]);
    }
  return a;
};
const DateTimePicker = ({
  date,
  maxDate,
  minDate,
  label,
  onChange,
  disabledHours,
  disabledMinutes,
  disabledSeconds,
  showSeconds = true
}) => {
  const [isOpen, setOpen] = React.useState(false);
  const ref = React.useRef(null);
  const { overlayProps, underlayProps } = overlays.useOverlay(
    {
      onClose: () => setOpen(false),
      isDismissable: true,
      isOpen,
      shouldCloseOnInteractOutside: (element) => {
        const popupElement = document.getElementsByClassName(POPUP_CLASS_NAME)[0];
        return !(popupElement && popupElement.contains(element));
      }
    },
    ref
  );
  const { dialogProps } = dialog.useDialog({}, ref);
  const theme = useTheme2();
  const { modalBackdrop } = getModalStyles(theme);
  const isFullscreen = reactUse.useMedia(`(min-width: ${theme.breakpoints.values.lg}px)`);
  const styles = useStyles2(getStyles$18);
  const [markerElement, setMarkerElement] = React.useState();
  const [selectorElement, setSelectorElement] = React.useState();
  const popper = reactPopper.usePopper(markerElement, selectorElement, {
    placement: "bottom-start"
  });
  const onApply = React.useCallback(
    (date2) => {
      setOpen(false);
      onChange(date2);
    },
    [onChange]
  );
  const onOpen = React.useCallback(
    (event) => {
      event.preventDefault();
      setOpen(true);
    },
    [setOpen]
  );
  return /* @__PURE__ */ React__default["default"].createElement("div", { "data-testid": "date-time-picker", style: { position: "relative" } }, /* @__PURE__ */ React__default["default"].createElement(
    DateTimeInput,
    {
      date,
      onChange,
      isFullscreen,
      onOpen,
      label,
      ref: setMarkerElement,
      showSeconds
    }
  ), isOpen ? isFullscreen ? /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1M(__spreadValues$1M({ ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default["default"].createElement(
    DateTimeCalendar,
    {
      date,
      onChange: onApply,
      isFullscreen: true,
      onClose: () => setOpen(false),
      maxDate,
      minDate,
      ref: setSelectorElement,
      style: popper.styles.popper,
      showSeconds,
      disabledHours,
      disabledMinutes,
      disabledSeconds
    }
  )))) : /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1M({ className: modalBackdrop }, underlayProps)), /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1M(__spreadValues$1M({ ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modal }, /* @__PURE__ */ React__default["default"].createElement(
    DateTimeCalendar,
    {
      date,
      maxDate,
      minDate,
      onChange: onApply,
      isFullscreen: false,
      onClose: () => setOpen(false),
      showSeconds,
      disabledHours,
      disabledMinutes,
      disabledSeconds
    }
  ))))) : null);
};
const DateTimeInput = React__default["default"].forwardRef(
  ({ date, label, onChange, isFullscreen, onOpen, showSeconds = true }, ref) => {
    const format = showSeconds ? "YYYY-MM-DD HH:mm:ss" : "YYYY-MM-DD HH:mm";
    const [internalDate, setInternalDate] = React.useState(() => {
      return { value: date ? data.dateTimeFormat(date) : data.dateTimeFormat(data.dateTime()), invalid: false };
    });
    React.useEffect(() => {
      if (date) {
        setInternalDate({
          invalid: !isValid(data.dateTimeFormat(date, { format })),
          value: data.isDateTime(date) ? data.dateTimeFormat(date, { format }) : date
        });
      }
    }, [date, format]);
    const onChangeDate = React.useCallback((event) => {
      const isInvalid = !isValid(event.currentTarget.value);
      setInternalDate({
        value: event.currentTarget.value,
        invalid: isInvalid
      });
    }, []);
    const onBlur = React.useCallback(() => {
      if (data.isDateTime(internalDate.value)) {
        onChange(data.dateTime(internalDate.value));
      }
    }, [internalDate.value, onChange]);
    const icon = /* @__PURE__ */ React__default["default"].createElement(Button, { "aria-label": "Time picker", icon: "calendar-alt", variant: "secondary", onClick: onOpen });
    return /* @__PURE__ */ React__default["default"].createElement(
      InlineField,
      {
        label,
        invalid: !!(internalDate.value && internalDate.invalid),
        className: css.css`
          margin-bottom: 0;
        `
      },
      /* @__PURE__ */ React__default["default"].createElement(
        Input,
        {
          onChange: onChangeDate,
          addonAfter: icon,
          value: internalDate.value,
          onBlur,
          "data-testid": "date-time-input",
          placeholder: "Select date/time",
          ref
        }
      )
    );
  }
);
DateTimeInput.displayName = "DateTimeInput";
const DateTimeCalendar = React__default["default"].forwardRef(
  ({
    date,
    onClose,
    onChange,
    isFullscreen,
    maxDate,
    minDate,
    style,
    showSeconds = true,
    disabledHours,
    disabledMinutes,
    disabledSeconds
  }, ref) => {
    const calendarStyles = useStyles2(getBodyStyles);
    const styles = useStyles2(getStyles$18);
    const [internalDate, setInternalDate] = React.useState(() => {
      if (date && date.isValid()) {
        return date.toDate();
      }
      return new Date();
    });
    const onChangeDate = React.useCallback((date2) => {
      if (!Array.isArray(date2)) {
        setInternalDate((prevState) => {
          date2.setHours(prevState.getHours());
          date2.setMinutes(prevState.getMinutes());
          date2.setSeconds(prevState.getSeconds());
          return date2;
        });
      }
    }, []);
    const onChangeTime = React.useCallback((date2) => {
      setInternalDate(date2.toDate());
    }, []);
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.container, { [styles.fullScreen]: isFullscreen }), style, ref }, /* @__PURE__ */ React__default["default"].createElement(
      Calendar__default["default"],
      {
        next2Label: null,
        prev2Label: null,
        value: internalDate,
        nextLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right" }),
        nextAriaLabel: "Next month",
        prevLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-left" }),
        prevAriaLabel: "Previous month",
        onChange: onChangeDate,
        locale: "en",
        className: calendarStyles.body,
        tileClassName: calendarStyles.title,
        maxDate,
        minDate
      }
    ), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.time }, /* @__PURE__ */ React__default["default"].createElement(
      TimeOfDayPicker,
      {
        showSeconds,
        onChange: onChangeTime,
        value: data.dateTime(internalDate),
        disabledHours,
        disabledMinutes,
        disabledSeconds
      }
    )), /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, null, /* @__PURE__ */ React__default["default"].createElement(Button, { type: "button", onClick: () => onChange(data.dateTime(internalDate)) }, "Apply"), /* @__PURE__ */ React__default["default"].createElement(Button, { variant: "secondary", type: "button", onClick: onClose }, "Cancel")));
  }
);
DateTimeCalendar.displayName = "DateTimeCalendar";
const getStyles$18 = (theme) => ({
  container: css.css`
    padding: ${theme.spacing(1)};
    border: 1px ${theme.colors.border.weak} solid;
    border-radius: ${theme.shape.borderRadius(1)};
    background-color: ${theme.colors.background.primary};
    z-index: ${theme.zIndex.modal};
  `,
  fullScreen: css.css`
    position: absolute;
  `,
  time: css.css`
    margin-bottom: ${theme.spacing(2)};
  `,
  modal: css.css`
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    z-index: ${theme.zIndex.modal};
    max-width: 280px;
  `
});

const getStyles$17 = stylesFactory((inlineList = false) => ({
  list: css.css`
    list-style-type: none;
    margin: 0;
    padding: 0;
  `,
  item: css.css`
    display: ${inlineList && "inline-block" || "block"};
  `
}));
class AbstractList extends React.PureComponent {
  constructor(props) {
    super(props);
  }
  render() {
    const { items, renderItem, getItemKey, className, inline } = this.props;
    const styles = getStyles$17(inline);
    return /* @__PURE__ */ React__default["default"].createElement("ul", { className: css.cx(styles.list, className) }, items.map((item, i) => {
      return /* @__PURE__ */ React__default["default"].createElement("li", { className: styles.item, key: getItemKey ? getItemKey(item) : i }, renderItem(item, i));
    }));
  }
}

var __defProp$1L = Object.defineProperty;
var __getOwnPropSymbols$1M = Object.getOwnPropertySymbols;
var __hasOwnProp$1M = Object.prototype.hasOwnProperty;
var __propIsEnum$1M = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1L = (obj, key, value) => key in obj ? __defProp$1L(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1L = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1M.call(b, prop))
      __defNormalProp$1L(a, prop, b[prop]);
  if (__getOwnPropSymbols$1M)
    for (var prop of __getOwnPropSymbols$1M(b)) {
      if (__propIsEnum$1M.call(b, prop))
        __defNormalProp$1L(a, prop, b[prop]);
    }
  return a;
};
class List extends React.PureComponent {
  render() {
    return /* @__PURE__ */ React__default["default"].createElement(AbstractList, __spreadValues$1L({}, this.props));
  }
}

var __defProp$1K = Object.defineProperty;
var __getOwnPropSymbols$1L = Object.getOwnPropertySymbols;
var __hasOwnProp$1L = Object.prototype.hasOwnProperty;
var __propIsEnum$1L = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1K = (obj, key, value) => key in obj ? __defProp$1K(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1K = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1L.call(b, prop))
      __defNormalProp$1K(a, prop, b[prop]);
  if (__getOwnPropSymbols$1L)
    for (var prop of __getOwnPropSymbols$1L(b)) {
      if (__propIsEnum$1L.call(b, prop))
        __defNormalProp$1K(a, prop, b[prop]);
    }
  return a;
};
const expanderContainerStyles = css.css`
  display: flex;
  align-items: center;
  height: 100%;
`;
function ExpanderCell({ row, __rowID }) {
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: expanderContainerStyles }, /* @__PURE__ */ React__default["default"].createElement(
    IconButton,
    __spreadValues$1K({
      tooltip: "toggle row expanded",
      "aria-controls": __rowID,
      name: row.isExpanded ? "angle-down" : "angle-right",
      "aria-expanded": row.isExpanded
    }, row.getToggleRowExpandedProps())
  ));
}

var __defProp$1J = Object.defineProperty;
var __getOwnPropSymbols$1K = Object.getOwnPropertySymbols;
var __hasOwnProp$1K = Object.prototype.hasOwnProperty;
var __propIsEnum$1K = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1J = (obj, key, value) => key in obj ? __defProp$1J(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1J = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1K.call(b, prop))
      __defNormalProp$1J(a, prop, b[prop]);
  if (__getOwnPropSymbols$1K)
    for (var prop of __getOwnPropSymbols$1K(b)) {
      if (__propIsEnum$1K.call(b, prop))
        __defNormalProp$1J(a, prop, b[prop]);
    }
  return a;
};
const EXPANDER_CELL_ID = "__expander";
function getColumns$1(columns) {
  return [
    {
      id: EXPANDER_CELL_ID,
      Cell: ExpanderCell,
      disableSortBy: true,
      width: 0
    },
    // @ts-expect-error react-table expects each column key(id) to have data associated with it and therefore complains about
    // column.id being possibly undefined and not keyof T (where T is the data object)
    // We do not want to be that strict as we simply pass undefined to cells that do not have data associated with them.
    ...columns.map((column) => __spreadValues$1J({
      id: column.id,
      accessor: column.id,
      Header: column.header || (() => null),
      sortType: column.sortType || "alphanumeric",
      disableSortBy: !Boolean(column.sortType),
      width: column.disableGrow ? 0 : void 0,
      visible: column.visible
    }, column.cell && { Cell: column.cell }))
  ];
}

var __defProp$1I = Object.defineProperty;
var __defProps$1b = Object.defineProperties;
var __getOwnPropDescs$1b = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1J = Object.getOwnPropertySymbols;
var __hasOwnProp$1J = Object.prototype.hasOwnProperty;
var __propIsEnum$1J = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1I = (obj, key, value) => key in obj ? __defProp$1I(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1I = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1J.call(b, prop))
      __defNormalProp$1I(a, prop, b[prop]);
  if (__getOwnPropSymbols$1J)
    for (var prop of __getOwnPropSymbols$1J(b)) {
      if (__propIsEnum$1J.call(b, prop))
        __defNormalProp$1I(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1b = (a, b) => __defProps$1b(a, __getOwnPropDescs$1b(b));
var __objRest$M = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1J.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1J)
    for (var prop of __getOwnPropSymbols$1J(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1J.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getStyles$16 = (theme) => ({
  table: css.css`
    border-radius: ${theme.shape.borderRadius()};
    border: solid 1px ${theme.colors.border.weak};
    background-color: ${theme.colors.background.secondary};
    width: 100%;

    td {
      padding: ${theme.spacing(1)};
    }

    td,
    th {
      min-width: ${theme.spacing(3)};
    }
  `,
  evenRow: css.css`
    background: ${theme.colors.background.primary};
  `,
  disableGrow: css.css`
    width: 0%;
  `,
  header: css.css`
    &,
    & > button {
      position: relative;
      white-space: nowrap;
      padding: ${theme.spacing(1)};
    }
    & > button {
      &:after {
        content: '\\00a0';
      }
      width: 100%;
      height: 100%;
      background: none;
      border: none;
      padding-right: ${theme.spacing(2.5)};
      text-align: left;
      &:hover {
        background-color: ${theme.colors.emphasize(theme.colors.background.secondary, 0.05)};
      }
    }
  `,
  sortableHeader: css.css`
    /* increases selector's specificity so that it always takes precedence over default styles  */
    && {
      padding: 0;
    }
  `
});
function InteractiveTable({
  data: data$1,
  className,
  columns,
  renderExpandedRow,
  getRowId
}) {
  const styles = useStyles2(getStyles$16);
  const tableColumns = React.useMemo(() => {
    const cols = getColumns$1(columns);
    return cols;
  }, [columns]);
  const id = useUniqueId();
  const getRowHTMLID = React.useCallback(
    (row) => {
      return `${id}-${row.id}`.replace(/\s/g, "");
    },
    [id]
  );
  const { getTableProps, getTableBodyProps, headerGroups, rows, prepareRow } = reactTable.useTable(
    {
      columns: tableColumns,
      data: data$1,
      autoResetExpanded: false,
      autoResetSortBy: false,
      disableMultiSort: true,
      getRowId,
      initialState: {
        hiddenColumns: [
          !renderExpandedRow && EXPANDER_CELL_ID,
          ...tableColumns.filter((col) => !(col.visible ? col.visible(data$1) : true)).map((c) => c.id).filter(data.isTruthy)
        ].filter(data.isTruthy)
      }
    },
    reactTable.useSortBy,
    reactTable.useExpanded
  );
  rows.forEach(prepareRow);
  return /* @__PURE__ */ React__default["default"].createElement("table", __spreadProps$1b(__spreadValues$1I({}, getTableProps()), { className: css.cx(styles.table, className) }), /* @__PURE__ */ React__default["default"].createElement("thead", null, headerGroups.map((headerGroup) => {
    const _a = headerGroup.getHeaderGroupProps(), { key } = _a, headerRowProps = __objRest$M(_a, ["key"]);
    return /* @__PURE__ */ React__default["default"].createElement("tr", __spreadValues$1I({ key }, headerRowProps), headerGroup.headers.map((column) => {
      const _a2 = column.getHeaderProps(), { key: key2 } = _a2, headerCellProps = __objRest$M(_a2, ["key"]);
      return /* @__PURE__ */ React__default["default"].createElement(
        "th",
        __spreadValues$1I(__spreadValues$1I({
          key: key2,
          className: css.cx(styles.header, {
            [styles.disableGrow]: column.width === 0,
            [styles.sortableHeader]: column.canSort
          })
        }, headerCellProps), column.isSorted && { "aria-sort": column.isSortedDesc ? "descending" : "ascending" }),
        /* @__PURE__ */ React__default["default"].createElement(ColumnHeader, { column })
      );
    }));
  })), /* @__PURE__ */ React__default["default"].createElement("tbody", __spreadValues$1I({}, getTableBodyProps()), rows.map((row, rowIndex) => {
    const className2 = css.cx(rowIndex % 2 === 0 && styles.evenRow);
    const _a = row.getRowProps(), { key } = _a, otherRowProps = __objRest$M(_a, ["key"]);
    const rowId = getRowHTMLID(row);
    return /* @__PURE__ */ React__default["default"].createElement(
      React.Fragment,
      { key },
      /* @__PURE__ */ React__default["default"].createElement("tr", __spreadValues$1I({ className: className2 }, otherRowProps), row.cells.map((cell) => {
        const _a2 = cell.getCellProps(), { key: key2 } = _a2, otherCellProps = __objRest$M(_a2, ["key"]);
        return /* @__PURE__ */ React__default["default"].createElement("td", __spreadValues$1I({ key: key2 }, otherCellProps), cell.render("Cell", { __rowID: rowId }));
      })),
      // @ts-expect-error react-table doesn't ship with useExpanded types and we can't use declaration merging without affecting the table viz
      row.isExpanded && renderExpandedRow && /* @__PURE__ */ React__default["default"].createElement("tr", __spreadProps$1b(__spreadValues$1I({ className: className2 }, otherRowProps), { id: rowId }), /* @__PURE__ */ React__default["default"].createElement("td", { colSpan: row.cells.length }, renderExpandedRow(row.original)))
    );
  })));
}
const useUniqueId = () => {
  return React.useMemo(() => lodash.uniqueId("InteractiveTable"), []);
};
const getColumnheaderStyles = (theme) => ({
  sortIcon: css.css`
    position: absolute;
    top: ${theme.spacing(1)};
  `
});
function ColumnHeader({
  column: { canSort, render, isSorted, isSortedDesc, getSortByToggleProps }
}) {
  const styles = useStyles2(getColumnheaderStyles);
  const { onClick } = getSortByToggleProps();
  const children = /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, render("Header"), isSorted && /* @__PURE__ */ React__default["default"].createElement("span", { "aria-hidden": "true", className: styles.sortIcon }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: isSortedDesc ? "angle-down" : "angle-up" })));
  if (canSort) {
    return /* @__PURE__ */ React__default["default"].createElement("button", { type: "button", onClick }, children);
  }
  return children;
}

const TagItem = ({ name, disabled, onRemove }) => {
  const { color, borderColor } = React.useMemo(() => getTagColorsFromName(name), [name]);
  const styles = useStyles2(getStyles$15);
  return /* @__PURE__ */ React__default["default"].createElement("li", { className: styles.itemStyle, style: { backgroundColor: color, borderColor } }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.nameStyle }, name), /* @__PURE__ */ React__default["default"].createElement(
    IconButton,
    {
      name: "times",
      size: "lg",
      disabled,
      ariaLabel: `Remove "${name}" tag`,
      onClick: () => onRemove(name),
      type: "button",
      className: styles.buttonStyles
    }
  ));
};
const getStyles$15 = (theme) => {
  const height = theme.spacing.gridSize * 3;
  return {
    itemStyle: css.css({
      display: "flex",
      gap: "3px",
      alignItems: "center",
      height: `${height}px`,
      lineHeight: `${height - 2}px`,
      color: "#fff",
      borderWidth: "1px",
      borderStyle: "solid",
      borderRadius: theme.shape.radius.default,
      padding: `0 ${theme.spacing(0.5)}`,
      whiteSpace: "nowrap",
      textShadow: "none",
      fontWeight: 500,
      fontSize: theme.typography.size.sm
    }),
    nameStyle: css.css({
      maxWidth: "25ch",
      textOverflow: "ellipsis",
      overflow: "hidden"
    }),
    buttonStyles: css.css({
      margin: 0,
      "&:hover::before": {
        display: "none"
      }
    })
  };
};

const TagsInput = ({
  placeholder = "New tag (enter key to add)",
  tags = [],
  onChange,
  width,
  className,
  disabled,
  addOnBlur,
  invalid,
  id
}) => {
  const [newTagName, setNewTagName] = React.useState("");
  const styles = useStyles2(getStyles$14);
  const theme = useTheme2();
  const onNameChange = React.useCallback((event) => {
    setNewTagName(event.target.value);
  }, []);
  const onRemove = (tagToRemove) => {
    onChange(tags.filter((x) => x !== tagToRemove));
  };
  const onAdd = (event) => {
    event == null ? void 0 : event.preventDefault();
    if (!tags.includes(newTagName)) {
      onChange(tags.concat(newTagName));
    }
    setNewTagName("");
  };
  const onBlur = () => {
    if (addOnBlur && newTagName) {
      onAdd();
    }
  };
  const onKeyboardAdd = (event) => {
    if (event.key === "Enter" && newTagName !== "") {
      onAdd(event);
    }
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.wrapper, className, width ? css.css({ width: theme.spacing(width) }) : "") }, /* @__PURE__ */ React__default["default"].createElement(
    Input,
    {
      id,
      disabled,
      placeholder,
      onChange: onNameChange,
      value: newTagName,
      onKeyDown: onKeyboardAdd,
      onBlur,
      invalid,
      suffix: /* @__PURE__ */ React__default["default"].createElement(
        Button,
        {
          fill: "text",
          className: styles.addButtonStyle,
          onClick: onAdd,
          size: "md",
          disabled: newTagName.length <= 0
        },
        "Add"
      )
    }
  ), (tags == null ? void 0 : tags.length) > 0 && /* @__PURE__ */ React__default["default"].createElement("ul", { className: styles.tags }, tags.map((tag) => /* @__PURE__ */ React__default["default"].createElement(TagItem, { key: tag, name: tag, onRemove, disabled }))));
};
const getStyles$14 = (theme) => ({
  wrapper: css.css`
    min-height: ${theme.spacing(4)};
    display: flex;
    flex-direction: column;
    gap: ${theme.spacing(1)};
    flex-wrap: wrap;
  `,
  tags: css.css`
    display: flex;
    justify-content: flex-start;
    flex-wrap: wrap;
    gap: ${theme.spacing(0.5)};
  `,
  addButtonStyle: css.css`
    margin: 0 -${theme.spacing(1)};
  `
});

const Pagination = ({
  currentPage,
  numberOfPages,
  onNavigate,
  hideWhenSinglePage,
  showSmallVersion,
  className
}) => {
  const styles = useStyles2(getStyles$13);
  const pageLengthToCondense = showSmallVersion ? 1 : 8;
  const pageButtons = React.useMemo(() => {
    const pages = [...new Array(numberOfPages).keys()];
    const condensePages = numberOfPages > pageLengthToCondense;
    const getListItem = (page, variant) => /* @__PURE__ */ React__default["default"].createElement("li", { key: page, className: styles.item }, /* @__PURE__ */ React__default["default"].createElement(Button, { size: "sm", variant, onClick: () => onNavigate(page) }, page));
    return pages.reduce((pagesToRender, pageIndex) => {
      const page = pageIndex + 1;
      const variant = page === currentPage ? "primary" : "secondary";
      const lowerBoundIndex = pageLengthToCondense;
      const upperBoundIndex = numberOfPages - pageLengthToCondense + 1;
      const differenceOfBounds = upperBoundIndex - lowerBoundIndex;
      const isFirstOrLastPage = page === 1 || page === numberOfPages;
      const currentPageIsBetweenBounds = differenceOfBounds > -1 && currentPage >= lowerBoundIndex && currentPage <= upperBoundIndex;
      const ellipsisOffset = showSmallVersion ? 1 : 3;
      const pageOffset = showSmallVersion ? 0 : 2;
      if (condensePages) {
        if (isFirstOrLastPage || currentPage < lowerBoundIndex && page < lowerBoundIndex || differenceOfBounds >= 0 && currentPage > upperBoundIndex && page > upperBoundIndex || differenceOfBounds < 0 && currentPage >= lowerBoundIndex && page > upperBoundIndex || currentPageIsBetweenBounds && page >= currentPage - pageOffset && page <= currentPage + pageOffset) {
          pagesToRender.push(getListItem(page, variant));
        } else if (page === lowerBoundIndex && currentPage < lowerBoundIndex || page === upperBoundIndex && currentPage > upperBoundIndex || currentPageIsBetweenBounds && (page === currentPage - ellipsisOffset || page === currentPage + ellipsisOffset)) {
          pagesToRender.push(
            /* @__PURE__ */ React__default["default"].createElement("li", { key: page, className: styles.item }, /* @__PURE__ */ React__default["default"].createElement(Icon, { className: styles.ellipsis, name: "ellipsis-v" }))
          );
        }
      } else {
        pagesToRender.push(getListItem(page, variant));
      }
      return pagesToRender;
    }, []);
  }, [currentPage, numberOfPages, onNavigate, pageLengthToCondense, showSmallVersion, styles.ellipsis, styles.item]);
  if (hideWhenSinglePage && numberOfPages <= 1) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.container, className) }, /* @__PURE__ */ React__default["default"].createElement("ol", null, /* @__PURE__ */ React__default["default"].createElement("li", { className: styles.item }, /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      "aria-label": "previous",
      size: "sm",
      variant: "secondary",
      onClick: () => onNavigate(currentPage - 1),
      disabled: currentPage === 1
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-left" })
  )), pageButtons, /* @__PURE__ */ React__default["default"].createElement("li", { className: styles.item }, /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      "aria-label": "next",
      size: "sm",
      variant: "secondary",
      onClick: () => onNavigate(currentPage + 1),
      disabled: currentPage === numberOfPages
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right" })
  ))));
};
const getStyles$13 = () => {
  return {
    container: css.css`
      float: right;
    `,
    item: css.css`
      display: inline-block;
      padding-left: 10px;
      margin-bottom: 5px;
    `,
    ellipsis: css.css`
      transform: rotate(90deg);
    `
  };
};

var __defProp$1H = Object.defineProperty;
var __defProps$1a = Object.defineProperties;
var __getOwnPropDescs$1a = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1I = Object.getOwnPropertySymbols;
var __hasOwnProp$1I = Object.prototype.hasOwnProperty;
var __propIsEnum$1I = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1H = (obj, key, value) => key in obj ? __defProp$1H(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1H = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1I.call(b, prop))
      __defNormalProp$1H(a, prop, b[prop]);
  if (__getOwnPropSymbols$1I)
    for (var prop of __getOwnPropSymbols$1I(b)) {
      if (__propIsEnum$1I.call(b, prop))
        __defNormalProp$1H(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1a = (a, b) => __defProps$1a(a, __getOwnPropDescs$1a(b));
var __objRest$L = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1I.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1I)
    for (var prop of __getOwnPropSymbols$1I(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1I.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Tag = React.forwardRef((_a, ref) => {
  var _b = _a, { name, onClick, icon, className, colorIndex } = _b, rest = __objRest$L(_b, ["name", "onClick", "icon", "className", "colorIndex"]);
  const theme = useTheme2();
  const styles = getTagStyles$1(theme, name, colorIndex);
  const onTagClick = (event) => {
    event.preventDefault();
    event.stopPropagation();
    onClick == null ? void 0 : onClick(name, event);
  };
  const classes = css.cx(styles.wrapper, className, { [styles.hover]: onClick !== void 0 });
  return onClick ? /* @__PURE__ */ React__default["default"].createElement("button", __spreadProps$1a(__spreadValues$1H({}, rest), { className: classes, onClick: onTagClick, ref }), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon }), name) : /* @__PURE__ */ React__default["default"].createElement("span", __spreadProps$1a(__spreadValues$1H({}, rest), { className: classes, ref }), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon }), name);
});
Tag.displayName = "Tag";
const getTagStyles$1 = (theme, name, colorIndex) => {
  let colors;
  if (colorIndex === void 0) {
    colors = getTagColorsFromName(name);
  } else {
    colors = getTagColor(colorIndex);
  }
  return {
    wrapper: css.css`
      appearance: none;
      border-style: none;
      font-weight: ${theme.typography.fontWeightMedium};
      font-size: ${theme.typography.size.sm};
      line-height: ${theme.typography.bodySmall.lineHeight};
      vertical-align: baseline;
      background-color: ${colors.color};
      color: ${theme.v1.palette.gray98};
      white-space: nowrap;
      text-shadow: none;
      padding: 3px 6px;
      border-radius: ${theme.shape.radius.default};
    `,
    hover: css.css`
      &:hover {
        opacity: 0.85;
        cursor: pointer;
      }
    `
  };
};

const TagList = React.memo(
  React.forwardRef(({ displayMax, tags, icon, onClick, className, getAriaLabel }, ref) => {
    const theme = useTheme2();
    const styles = getStyles$12(theme, Boolean(displayMax && displayMax > 0));
    const numTags = tags.length;
    const tagsToDisplay = displayMax ? tags.slice(0, displayMax) : tags;
    return /* @__PURE__ */ React__default["default"].createElement("ul", { className: css.cx(styles.wrapper, className), "aria-label": "Tags", ref }, tagsToDisplay.map((tag, i) => /* @__PURE__ */ React__default["default"].createElement("li", { className: styles.li, key: tag }, /* @__PURE__ */ React__default["default"].createElement(Tag, { name: tag, icon, onClick, "aria-label": getAriaLabel == null ? void 0 : getAriaLabel(tag, i), "data-tag-id": i }))), displayMax && displayMax > 0 && numTags - displayMax > 0 && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.moreTagsLabel }, "+ ", numTags - displayMax));
  })
);
TagList.displayName = "TagList";
const getStyles$12 = (theme, isTruncated) => {
  return {
    wrapper: css.css`
      position: relative;
      align-items: ${isTruncated ? "center" : "unset"};
      display: flex;
      flex: 1 1 auto;
      flex-wrap: wrap;
      flex-shrink: ${isTruncated ? 0 : 1};
      justify-content: flex-end;
      gap: 6px;
    `,
    moreTagsLabel: css.css`
      color: ${theme.colors.text.secondary};
      font-size: ${theme.typography.size.sm};
    `,
    li: css.css({
      listStyle: "none"
    })
  };
};

const FilterPill = ({ label, selected, onClick, icon = "check" }) => {
  const styles = useStyles2(getStyles$11);
  const clearButton = useStyles2(clearButtonStyles);
  return /* @__PURE__ */ React__default["default"].createElement("button", { type: "button", className: css.cx(clearButton, styles.wrapper, selected && styles.selected), onClick }, /* @__PURE__ */ React__default["default"].createElement("span", null, label), selected && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, className: styles.icon }));
};
const getStyles$11 = (theme) => {
  return {
    wrapper: css.css`
      background: ${theme.colors.background.secondary};
      border-radius: ${theme.shape.borderRadius(8)};
      padding: ${theme.spacing(0, 2)};
      font-size: ${theme.typography.bodySmall.fontSize};
      font-weight: ${theme.typography.fontWeightMedium};
      line-height: ${theme.typography.bodySmall.lineHeight};
      color: ${theme.colors.text.secondary};
      display: flex;
      align-items: center;
      height: 32px;

      &:hover {
        background: ${theme.colors.action.hover};
        color: ${theme.colors.text.primary};
      }
    `,
    selected: css.css`
      color: ${theme.colors.text.primary};
      background: ${theme.colors.action.selected};

      &:hover {
        background: ${theme.colors.action.focus};
      }
    `,
    icon: css.css`
      margin-left: ${theme.spacing(0.5)};
    `
  };
};

var __defProp$1G = Object.defineProperty;
var __getOwnPropSymbols$1H = Object.getOwnPropertySymbols;
var __hasOwnProp$1H = Object.prototype.hasOwnProperty;
var __propIsEnum$1H = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1G = (obj, key, value) => key in obj ? __defProp$1G(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1G = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1H.call(b, prop))
      __defNormalProp$1G(a, prop, b[prop]);
  if (__getOwnPropSymbols$1H)
    for (var prop of __getOwnPropSymbols$1H(b)) {
      if (__propIsEnum$1H.call(b, prop))
        __defNormalProp$1G(a, prop, b[prop]);
    }
  return a;
};
var __objRest$K = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1H.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1H)
    for (var prop of __getOwnPropSymbols$1H(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1H.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Layout = (_a) => {
  var _b = _a, {
    children,
    orientation = 0 /* Horizontal */,
    spacing = "sm",
    justify = "flex-start",
    align = "normal",
    wrap = false,
    width = "100%",
    height = "100%"
  } = _b, rest = __objRest$K(_b, [
    "children",
    "orientation",
    "spacing",
    "justify",
    "align",
    "wrap",
    "width",
    "height"
  ]);
  const styles = useStyles2(
    React.useCallback(
      (theme) => getStyles$10(theme, orientation, spacing, justify, align, wrap),
      [align, justify, orientation, spacing, wrap]
    )
  );
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1G({ className: styles.layout, style: { width, height } }, rest), React__default["default"].Children.toArray(children).filter(Boolean).map((child, index) => {
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.childWrapper, key: index }, child);
  }));
};
const HorizontalGroup = ({
  children,
  spacing,
  justify,
  align = "center",
  wrap,
  width,
  height
}) => /* @__PURE__ */ React__default["default"].createElement(
  Layout,
  {
    spacing,
    justify,
    orientation: 0 /* Horizontal */,
    align,
    width,
    height,
    wrap
  },
  children
);
const VerticalGroup = ({
  children,
  spacing,
  justify,
  align,
  width,
  height
}) => /* @__PURE__ */ React__default["default"].createElement(
  Layout,
  {
    spacing,
    justify,
    orientation: 1 /* Vertical */,
    align,
    width,
    height
  },
  children
);
const Container = ({ children, padding, margin, grow, shrink }) => {
  const styles = useStyles2(React.useCallback((theme) => getContainerStyles(theme, padding, margin), [padding, margin]));
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(
        styles.wrapper,
        grow !== void 0 && css.css`
            flex-grow: ${grow};
          `,
        shrink !== void 0 && css.css`
            flex-shrink: ${shrink};
          `
      )
    },
    children
  );
};
const getStyles$10 = (theme, orientation, spacing, justify, align, wrap) => {
  const finalSpacing = spacing !== "none" ? theme.spacing(spacingToNumber[spacing]) : 0;
  const marginCompensation = orientation === 0 /* Horizontal */ && !wrap || orientation === 1 /* Vertical */ ? 0 : `-${finalSpacing}`;
  const label = orientation === 1 /* Vertical */ ? "vertical-group" : "horizontal-group";
  return {
    layout: css.css`
      label: ${label};
      display: flex;
      flex-direction: ${orientation === 1 /* Vertical */ ? "column" : "row"};
      flex-wrap: ${wrap ? "wrap" : "nowrap"};
      justify-content: ${justify};
      align-items: ${align};
      height: 100%;
      max-width: 100%;
      // compensate for last row margin when wrapped, horizontal layout
      margin-bottom: ${marginCompensation};
    `,
    childWrapper: css.css`
      label: layoutChildrenWrapper;
      margin-bottom: ${orientation === 0 /* Horizontal */ && !wrap ? 0 : finalSpacing};
      margin-right: ${orientation === 0 /* Horizontal */ ? finalSpacing : 0};
      display: flex;
      align-items: ${align};

      &:last-child {
        margin-bottom: ${orientation === 1 /* Vertical */ && 0};
        margin-right: ${orientation === 0 /* Horizontal */ && 0};
      }
    `
  };
};
const spacingToNumber = {
  none: 0,
  xs: 0.5,
  sm: 1,
  md: 2,
  lg: 3
};
const getContainerStyles = (theme, padding, margin) => {
  const paddingSize = padding && padding !== "none" && theme.spacing(spacingToNumber[padding]) || 0;
  const marginSize = margin && margin !== "none" && theme.spacing(spacingToNumber[margin]) || 0;
  return {
    wrapper: css.css`
      label: container;
      margin: ${marginSize};
      padding: ${paddingSize};
    `
  };
};

const ModalHeader = ({ icon, iconTooltip, title, children, id }) => {
  const styles = useStyles2(getModalStyles);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("h2", { className: styles.modalHeaderTitle, id }, title), children);
};

var __defProp$1F = Object.defineProperty;
var __defProps$19 = Object.defineProperties;
var __getOwnPropDescs$19 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1G = Object.getOwnPropertySymbols;
var __hasOwnProp$1G = Object.prototype.hasOwnProperty;
var __propIsEnum$1G = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1F = (obj, key, value) => key in obj ? __defProp$1F(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1F = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1G.call(b, prop))
      __defNormalProp$1F(a, prop, b[prop]);
  if (__getOwnPropSymbols$1G)
    for (var prop of __getOwnPropSymbols$1G(b)) {
      if (__propIsEnum$1G.call(b, prop))
        __defNormalProp$1F(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$19 = (a, b) => __defProps$19(a, __getOwnPropDescs$19(b));
function Modal(props) {
  const {
    title,
    children,
    isOpen = false,
    closeOnEscape = true,
    closeOnBackdropClick = true,
    className,
    contentClassName,
    onDismiss,
    onClickBackdrop,
    trapFocus = true
  } = props;
  const theme = useTheme2();
  const styles = getModalStyles(theme);
  const ref = React.useRef(null);
  const { overlayProps, underlayProps } = overlays.useOverlay(
    { isKeyboardDismissDisabled: !closeOnEscape, isOpen, onClose: onDismiss },
    ref
  );
  const { dialogProps, titleProps } = dialog.useDialog({}, ref);
  if (!isOpen) {
    return null;
  }
  const headerClass = css.cx(styles.modalHeader, typeof title !== "string" && styles.modalHeaderWithTabs);
  return /* @__PURE__ */ React__default["default"].createElement(overlays.OverlayContainer, null, /* @__PURE__ */ React__default["default"].createElement(
    "div",
    __spreadValues$1F({
      role: "presentation",
      className: styles.modalBackdrop,
      onClick: onClickBackdrop || (closeOnBackdropClick ? onDismiss : void 0)
    }, underlayProps)
  ), /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: trapFocus, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1F(__spreadValues$1F({ className: css.cx(styles.modal, className), ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default["default"].createElement(
    "div",
    { className: headerClass },
    typeof title === "string" && /* @__PURE__ */ React__default["default"].createElement(DefaultModalHeader, __spreadProps$19(__spreadValues$1F({}, props), { title, id: titleProps.id })),
    // FIXME: custom title components won't get an accessible title.
    // Do we really want to support them or shall we just limit this ModalTabsHeader?
    typeof title !== "string" && title,
    /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalHeaderClose }, /* @__PURE__ */ React__default["default"].createElement(IconButton, { "aria-label": "Close dialogue", name: "times", size: "xl", onClick: onDismiss }))
  ), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.modalContent, contentClassName) }, children))));
}
function ModalButtonRow({ leftItems, children }) {
  const theme = useTheme2();
  const styles = getModalStyles(theme);
  if (leftItems) {
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalButtonRow }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { justify: "space-between" }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { justify: "flex-start", spacing: "md" }, leftItems), /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { justify: "flex-end", spacing: "md" }, children)));
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalButtonRow }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { justify: "flex-end", spacing: "md" }, children));
}
Modal.ButtonRow = ModalButtonRow;
function DefaultModalHeader({ icon, iconTooltip, title, id }) {
  return /* @__PURE__ */ React__default["default"].createElement(ModalHeader, { icon, iconTooltip, title, id });
}

const ConfirmModal = ({
  isOpen,
  title,
  body,
  description,
  confirmText,
  confirmVariant = "destructive",
  confirmationText,
  dismissText = "Cancel",
  dismissVariant = "secondary",
  alternativeText,
  modalClass,
  icon = "exclamation-triangle",
  onConfirm,
  onDismiss,
  onAlternative,
  confirmButtonVariant = "destructive"
}) => {
  const [disabled, setDisabled] = React.useState(Boolean(confirmationText));
  const styles = useStyles2(getStyles$$);
  const buttonRef = React.useRef(null);
  const onConfirmationTextChange = (event) => {
    setDisabled((confirmationText == null ? void 0 : confirmationText.localeCompare(event.currentTarget.value)) !== 0);
  };
  React.useEffect(() => {
    var _a;
    if (isOpen) {
      (_a = buttonRef.current) == null ? void 0 : _a.focus();
    }
  }, [isOpen]);
  React.useEffect(() => {
    if (isOpen) {
      setDisabled(Boolean(confirmationText));
    }
  }, [isOpen, confirmationText]);
  return /* @__PURE__ */ React__default["default"].createElement(Modal, { className: css.cx(styles.modal, modalClass), title, icon, isOpen, onDismiss }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalText }, body, description ? /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalDescription }, description) : null, confirmationText ? /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalConfirmationInput }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, null, /* @__PURE__ */ React__default["default"].createElement(Input, { placeholder: `Type ${confirmationText} to confirm`, onChange: onConfirmationTextChange }))) : null), /* @__PURE__ */ React__default["default"].createElement(Modal.ButtonRow, null, /* @__PURE__ */ React__default["default"].createElement(Button, { variant: dismissVariant, onClick: onDismiss, fill: "outline" }, dismissText), /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      variant: confirmButtonVariant,
      onClick: onConfirm,
      disabled,
      ref: buttonRef,
      "aria-label": e2eSelectors.selectors.pages.ConfirmModal.delete
    },
    confirmText
  ), onAlternative ? /* @__PURE__ */ React__default["default"].createElement(Button, { variant: "primary", onClick: onAlternative }, alternativeText) : null));
};
const getStyles$$ = (theme) => ({
  modal: css.css`
    width: 500px;
  `,
  modalText: css.css({
    fontSize: theme.typography.h5.fontSize,
    color: theme.colors.text.primary
  }),
  modalDescription: css.css({
    fontSize: theme.typography.body.fontSize
  }),
  modalConfirmationInput: css.css({
    paddingTop: theme.spacing(1)
  })
});

const BRACES = {
  "[": "]",
  "{": "}",
  "(": ")"
};
const MATCH_MARK = "brace_match";
function BracesPlugin() {
  return {
    onKeyDown(event, editor, next) {
      const { value } = editor;
      switch (event.key) {
        case "(":
        case "{":
        case "[": {
          const {
            start: { offset: startOffset, key: startKey },
            end: { offset: endOffset, key: endKey },
            focus: { offset: focusOffset }
          } = value.selection;
          const text = value.focusText.text;
          if (value.selection.isExpanded) {
            event.preventDefault();
            editor.insertTextByKey(startKey, startOffset, event.key).insertTextByKey(endKey, endOffset + 1, BRACES[event.key]).moveEndBackward(1);
            return true;
          } else if (
            // Insert matching brace when there is no input after caret
            focusOffset === text.length || text[focusOffset] === " " || Object.values(BRACES).includes(text[focusOffset])
          ) {
            event.preventDefault();
            const complement = BRACES[event.key];
            const matchAnnotation = {
              key: `${MATCH_MARK}-${uuid.v4()}`,
              type: `${MATCH_MARK}-${complement}`,
              anchor: {
                key: startKey,
                offset: startOffset,
                object: "point"
              },
              focus: {
                key: endKey,
                offset: endOffset + 1,
                object: "point"
              },
              object: "annotation"
            };
            editor.insertText(event.key).insertText(complement).addAnnotation(matchAnnotation).moveBackward(1);
            return true;
          }
          break;
        }
        case ")":
        case "}":
        case "]": {
          const text = value.anchorText.text;
          const offset = value.selection.anchor.offset;
          const nextChar = text[offset];
          const complement = event.key;
          const annotationType = `${MATCH_MARK}-${complement}`;
          const annotation = value.annotations.find(
            (a) => (a == null ? void 0 : a.type) === annotationType && a.anchor.key === value.anchorText.key
          );
          if (annotation && nextChar === complement && !value.selection.isExpanded) {
            event.preventDefault();
            editor.moveFocusForward(1).removeAnnotation(annotation).moveAnchorForward(1);
            return true;
          }
          break;
        }
        case "Backspace": {
          const text = value.anchorText.text;
          const offset = value.selection.anchor.offset;
          const previousChar = text[offset - 1];
          const nextChar = text[offset];
          if (BRACES[previousChar] && BRACES[previousChar] === nextChar) {
            event.preventDefault();
            editor.deleteBackward(1).deleteForward(1).focus();
            return true;
          }
        }
      }
      return next();
    }
  };
}

function ClearPlugin() {
  return {
    onKeyDown(event, editor, next) {
      const value = editor.value;
      if (value.selection.isExpanded) {
        return next();
      }
      if (event.key === "k" && event.ctrlKey) {
        event.preventDefault();
        const text = value.anchorText.text;
        const offset = value.selection.anchor.offset;
        const length = text.length;
        const forward = length - offset;
        editor.deleteForward(forward);
        return true;
      }
      return next();
    }
  };
}

var __defProp$1E = Object.defineProperty;
var __defProps$18 = Object.defineProperties;
var __getOwnPropDescs$18 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1F = Object.getOwnPropertySymbols;
var __hasOwnProp$1F = Object.prototype.hasOwnProperty;
var __propIsEnum$1F = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1E = (obj, key, value) => key in obj ? __defProp$1E(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1E = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1F.call(b, prop))
      __defNormalProp$1E(a, prop, b[prop]);
  if (__getOwnPropSymbols$1F)
    for (var prop of __getOwnPropSymbols$1F(b)) {
      if (__propIsEnum$1F.call(b, prop))
        __defNormalProp$1E(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$18 = (a, b) => __defProps$18(a, __getOwnPropDescs$18(b));
const getCopiedText = (textBlocks, startOffset, endOffset) => {
  if (!textBlocks.length) {
    return void 0;
  }
  const excludingLastLineLength = textBlocks.slice(0, -1).join("").length + textBlocks.length - 1;
  return textBlocks.join("\n").slice(startOffset, excludingLastLineLength + endOffset);
};
const removeBom = (str) => {
  return str == null ? void 0 : str.replace(/[\uFEFF]/g, "");
};
function ClipboardPlugin() {
  const clipboardPlugin = {
    onCopy(event, editor, next) {
      event.preventDefault();
      const { document, selection } = editor.value;
      const {
        start: { offset: startOffset },
        end: { offset: endOffset }
      } = selection;
      const selectedBlocks = document.getLeafBlocksAtRange(selection).toArray().map((block) => block.text);
      const copiedText = removeBom(getCopiedText(selectedBlocks, startOffset, endOffset));
      if (copiedText && event.clipboardData) {
        event.clipboardData.setData("Text", copiedText);
      }
      return true;
    },
    onPaste(event, editor, next) {
      event.preventDefault();
      if (event.clipboardData) {
        const pastedValue = removeBom(event.clipboardData.getData("Text"));
        const lines = pastedValue == null ? void 0 : pastedValue.split("\n");
        if (lines && lines.length) {
          editor.insertText(lines[0]);
          for (const line of lines.slice(1)) {
            editor.splitBlock().insertText(line);
          }
        }
      }
      return true;
    }
  };
  return __spreadProps$18(__spreadValues$1E({}, clipboardPlugin), {
    onCut(event, editor, next) {
      clipboardPlugin.onCopy(event, editor, next);
      editor.deleteAtRange(editor.value.selection);
      return true;
    }
  });
}

const isIndentLeftHotkey = isHotkey.isKeyHotkey("mod+[");
const isShiftTabHotkey = isHotkey.isKeyHotkey("shift+tab");
const isIndentRightHotkey = isHotkey.isKeyHotkey("mod+]");
const SLATE_TAB = "  ";
const handleTabKey = (event, editor, next) => {
  const {
    startBlock,
    endBlock,
    selection: {
      start: { offset: startOffset, key: startKey },
      end: { offset: endOffset, key: endKey }
    }
  } = editor.value;
  if (Plain__default["default"].serialize(editor.value) === "") {
    return;
  }
  event.preventDefault();
  const first = startBlock.getFirstText();
  const startBlockIsSelected = first && startOffset === 0 && startKey === first.key && endOffset === first.text.length && endKey === first.key;
  if (startBlockIsSelected || !startBlock.equals(endBlock)) {
    handleIndent(editor, "right");
  } else {
    editor.insertText(SLATE_TAB);
  }
};
const handleIndent = (editor, indentDirection) => {
  const curSelection = editor.value.selection;
  const selectedBlocks = editor.value.document.getLeafBlocksAtRange(curSelection).toArray();
  if (indentDirection === "left") {
    for (const block of selectedBlocks) {
      const blockWhitespace = block.text.length - block.text.trimLeft().length;
      const textKey = block.getFirstText().key;
      const rangeProperties = {
        anchor: {
          key: textKey,
          offset: blockWhitespace,
          path: []
        },
        focus: {
          key: textKey,
          offset: blockWhitespace,
          path: []
        }
      };
      editor.deleteBackwardAtRange(slate.Range.create(rangeProperties), Math.min(SLATE_TAB.length, blockWhitespace));
    }
  } else {
    const { startText } = editor.value;
    const textBeforeCaret = startText.text.slice(0, curSelection.start.offset);
    const isWhiteSpace = /^\s*$/.test(textBeforeCaret);
    for (const block of selectedBlocks) {
      editor.insertTextByKey(block.getFirstText().key, 0, SLATE_TAB);
    }
    if (isWhiteSpace) {
      editor.moveStartBackward(SLATE_TAB.length);
    }
  }
};
function IndentationPlugin() {
  return {
    onKeyDown(event, editor, next) {
      if (isIndentLeftHotkey(event) || isShiftTabHotkey(event)) {
        event.preventDefault();
        handleIndent(editor, "left");
      } else if (isIndentRightHotkey(event)) {
        event.preventDefault();
        handleIndent(editor, "right");
      } else if (event.key === "Tab") {
        handleTabKey(event, editor);
      } else {
        return next();
      }
      return true;
    }
  };
}

function getIndent(text) {
  let offset = text.length - text.trimLeft().length;
  if (offset) {
    let indent = text[0];
    while (--offset) {
      indent += text[0];
    }
    return indent;
  }
  return "";
}
function NewlinePlugin() {
  return {
    onKeyDown(event, editor, next) {
      const value = editor.value;
      if (value.selection.isExpanded) {
        return next();
      }
      if (event.key === "Enter") {
        event.preventDefault();
        const { startBlock } = value;
        const currentLineText = startBlock.text;
        const indent = getIndent(currentLineText);
        return editor.splitBlock().insertText(indent).focus();
      }
      return next();
    }
  };
}

function RunnerPlugin({ handler }) {
  return {
    onKeyDown(event, editor, next) {
      if (handler && event.key === "Enter" && (event.shiftKey || event.ctrlKey)) {
        event.preventDefault();
        handler(event);
        return editor;
      }
      return next();
    }
  };
}

const isSelectLineHotkey = isHotkey.isKeyHotkey("mod+l");
function SelectionShortcutsPlugin() {
  return {
    onKeyDown(event, editor, next) {
      if (isSelectLineHotkey(event)) {
        event.preventDefault();
        const { focusBlock, document } = editor.value;
        editor.moveAnchorToStartOfBlock();
        const nextBlock = document.getNextBlock(focusBlock.key);
        if (nextBlock) {
          editor.moveFocusToStartOfNextBlock();
        } else {
          editor.moveFocusToEndOfText();
        }
      } else {
        return next();
      }
      return true;
    }
  };
}

const TOKEN_MARK = "prism-token";

function defaultOnlyIn(node) {
  return node.object === "block" && node.type === "code_block";
}
function defaultGetSyntax(node) {
  return "javascript";
}
function defaultRenderDecoration(props, editor, next) {
  const { decoration } = props;
  if (decoration.type !== TOKEN_MARK) {
    return next();
  }
  const className = decoration.data.get("className");
  return /* @__PURE__ */ React__default["default"].createElement("span", { className }, props.children);
}
class Options extends immutable.Record({
  onlyIn: defaultOnlyIn,
  getSyntax: defaultGetSyntax,
  renderDecoration: defaultRenderDecoration
}) {
  constructor(props) {
    super(props);
  }
}

function SlatePrism(optsParam = {}, prismLanguages = Prism__default["default"].languages) {
  const opts = new Options(optsParam);
  return {
    decorateNode: (node, editor, next) => {
      if (!opts.onlyIn(node)) {
        return next();
      }
      const block = slate.Block.create(node);
      const grammarName = opts.getSyntax(block);
      const grammar = prismLanguages[grammarName];
      if (!grammar) {
        return [];
      }
      const texts = block.getTexts();
      const blockText = texts.map((text) => text && text.getText()).join("\n");
      const tokens = Prism__default["default"].tokenize(blockText, grammar);
      const flattened = flattenTokens(tokens);
      const newData = editor.value.data.set("tokens", flattened);
      editor.setData(newData);
      return decorateNode(opts, tokens, block);
    },
    renderDecoration: (props, editor, next) => opts.renderDecoration(
      {
        children: props.children,
        decoration: props.decoration
      },
      editor,
      next
    )
  };
}
function decorateNode(opts, tokens, block) {
  const texts = block.getTexts();
  const decorations = [];
  let textStart = 0;
  let textEnd = 0;
  texts.forEach((text) => {
    textEnd = textStart + text.getText().length;
    let offset = 0;
    function processToken(token, accu) {
      if (typeof token === "string") {
        if (accu) {
          const decoration = createDecoration({
            text,
            textStart,
            textEnd,
            start: offset,
            end: offset + token.length,
            className: `prism-token token ${accu}`,
            block
          });
          if (decoration) {
            decorations.push(decoration);
          }
        }
        offset += token.length;
      } else {
        accu = `${accu} ${token.type}`;
        if (token.alias) {
          accu += " " + token.alias;
        }
        if (typeof token.content === "string") {
          const decoration = createDecoration({
            text,
            textStart,
            textEnd,
            start: offset,
            end: offset + token.content.length,
            className: `prism-token token ${accu}`,
            block
          });
          if (decoration) {
            decorations.push(decoration);
          }
          offset += token.content.length;
        } else {
          for (let i = 0; i < token.content.length; i += 1) {
            processToken(token.content[i], accu);
          }
        }
      }
    }
    tokens.forEach(processToken);
    textStart = textEnd + 1;
  });
  return decorations;
}
function createDecoration({
  text,
  textStart,
  textEnd,
  start,
  end,
  className,
  block
}) {
  if (start >= textEnd || end <= textStart) {
    return null;
  }
  start = Math.max(start, textStart);
  end = Math.min(end, textEnd);
  start -= textStart;
  end -= textStart;
  const myDec = block.createDecoration({
    object: "decoration",
    anchor: {
      key: text.key,
      offset: start,
      object: "point"
    },
    focus: {
      key: text.key,
      offset: end,
      object: "point"
    },
    type: TOKEN_MARK,
    data: { className }
  });
  return myDec;
}
function flattenToken(token) {
  if (typeof token === "string") {
    return [
      {
        content: token,
        types: [],
        aliases: []
      }
    ];
  } else if (Array.isArray(token)) {
    return token.flatMap((t) => flattenToken(t));
  } else if (token instanceof Prism__default["default"].Token) {
    return flattenToken(token.content).flatMap((t) => {
      var _a;
      let aliases = [];
      if (typeof token.alias === "string") {
        aliases = [token.alias];
      } else {
        aliases = (_a = token.alias) != null ? _a : [];
      }
      return {
        content: t.content,
        types: [token.type, ...t.types],
        aliases: [...aliases, ...t.aliases]
      };
    });
  }
  return [];
}
function flattenTokens(token) {
  const tokens = flattenToken(token);
  if (!tokens.length) {
    return [];
  }
  const firstToken = tokens[0];
  firstToken.prev = null;
  firstToken.next = tokens.length >= 2 ? tokens[1] : null;
  firstToken.offsets = {
    start: 0,
    end: firstToken.content.length
  };
  for (let i = 1; i < tokens.length - 1; i++) {
    tokens[i].prev = tokens[i - 1];
    tokens[i].next = tokens[i + 1];
    tokens[i].offsets = {
      start: tokens[i - 1].offsets.end,
      end: tokens[i - 1].offsets.end + tokens[i].content.length
    };
  }
  const lastToken = tokens[tokens.length - 1];
  lastToken.prev = tokens.length >= 2 ? tokens[tokens.length - 2] : null;
  lastToken.next = null;
  lastToken.offsets = {
    start: tokens.length >= 2 ? tokens[tokens.length - 2].offsets.end : 0,
    end: tokens.length >= 2 ? tokens[tokens.length - 2].offsets.end + lastToken.content.length : lastToken.content.length
  };
  return tokens;
}

var CompletionItemKind = /* @__PURE__ */ ((CompletionItemKind2) => {
  CompletionItemKind2["GroupTitle"] = "GroupTitle";
  return CompletionItemKind2;
})(CompletionItemKind || {});

const flattenGroupItems = (groupedItems) => {
  return groupedItems.reduce((all, { items, label }) => {
    all.push({
      label,
      kind: CompletionItemKind.GroupTitle
    });
    return items.reduce((all2, item) => {
      all2.push(item);
      return all2;
    }, all);
  }, []);
};
const calculateLongestLabel = (allItems) => {
  return allItems.reduce((longest, current) => {
    return longest.length < current.label.length ? current.label : longest;
  }, "");
};
const calculateListSizes = (theme, allItems, longestLabel) => {
  const size = calculateSize__default["default"](longestLabel, {
    font: theme.typography.fontFamilyMonospace,
    fontSize: theme.typography.bodySmall.fontSize,
    fontWeight: "normal"
  });
  const listWidth = calculateListWidth(size.width, theme);
  const itemHeight = calculateItemHeight(size.height, theme);
  const listHeight = calculateListHeight(itemHeight, allItems);
  return {
    listWidth,
    listHeight,
    itemHeight
  };
};
const calculateItemHeight = (longestLabelHeight, theme) => {
  const horizontalPadding = theme.spacing.gridSize * 2;
  const itemHeight = longestLabelHeight + horizontalPadding;
  return itemHeight;
};
const calculateListWidth = (longestLabelWidth, theme) => {
  const verticalPadding = theme.spacing.gridSize * 3;
  const maxWidth = 800;
  const listWidth = Math.min(Math.max(longestLabelWidth + verticalPadding, 200), maxWidth);
  return listWidth;
};
const calculateListHeight = (itemHeight, allItems) => {
  const numberOfItemsToShow = Math.min(allItems.length, 10);
  const minHeight = 100;
  const totalHeight = numberOfItemsToShow * itemHeight;
  const listHeight = Math.max(totalHeight, minHeight);
  return listHeight;
};

const getStyles$_ = (theme, height, visible) => {
  return {
    typeaheadItem: css.css`
      label: type-ahead-item;
      z-index: 11;
      padding: ${theme.spacing(1, 1, 1, 2)};
      border: ${theme.colors.border.medium};
      overflow-y: scroll;
      overflow-x: hidden;
      outline: none;
      background: ${theme.colors.background.secondary};
      color: ${theme.colors.text};
      box-shadow: 0 0 20px ${theme.v1.colors.dropdownShadow};
      visibility: ${visible === true ? "visible" : "hidden"};
      width: 250px;
      min-height: ${height + parseInt(theme.spacing(0.25), 10)}px;
      position: relative;
      word-break: break-word;
    `
  };
};
const TypeaheadInfo = ({ item, height }) => {
  const visible = item && !!item.documentation;
  const label = item ? item.label : "";
  const documentation = data.renderMarkdown(item == null ? void 0 : item.documentation);
  const theme = useTheme2();
  const styles = getStyles$_(theme, height, visible);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([styles.typeaheadItem]) }, /* @__PURE__ */ React__default["default"].createElement("b", null, label), /* @__PURE__ */ React__default["default"].createElement("hr", null), /* @__PURE__ */ React__default["default"].createElement("div", { dangerouslySetInnerHTML: { __html: documentation } }));
};

function getStartIndices(parts, length) {
  const indices = [];
  parts.forEach((part) => {
    indices.push(part.start, part.end + 1);
  });
  if (indices[0] !== 0) {
    indices.unshift(0);
  }
  if (indices[indices.length - 1] !== length) {
    indices.push(length);
  }
  return indices;
}
const PartialHighlighter = (props) => {
  let { highlightParts, text, highlightClassName } = props;
  if (!(highlightParts == null ? void 0 : highlightParts.length)) {
    return null;
  }
  let children = [];
  let indices = getStartIndices(highlightParts, text.length);
  let highlighted = highlightParts[0].start === 0;
  for (let i = 1; i < indices.length; i++) {
    let start = indices[i - 1];
    let end = indices[i];
    children.push(
      React.createElement(
        highlighted ? "mark" : "span",
        {
          key: i - 1,
          className: highlighted ? highlightClassName : void 0
        },
        text.substring(start, end)
      )
    );
    highlighted = !highlighted;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", null, children);
};

const getStyles$Z = (theme) => ({
  typeaheadItem: css.css`
    border: none;
    background: none;
    text-align: left;
    label: type-ahead-item;
    height: auto;
    font-family: ${theme.typography.fontFamilyMonospace};
    padding: ${theme.spacing(1, 1, 1, 2)};
    font-size: ${theme.typography.bodySmall.fontSize};
    text-overflow: ellipsis;
    overflow: hidden;
    z-index: 11;
    display: block;
    white-space: nowrap;
    cursor: pointer;
    transition: color 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), border-color 0.3s cubic-bezier(0.645, 0.045, 0.355, 1),
      background 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), padding 0.15s cubic-bezier(0.645, 0.045, 0.355, 1);
  `,
  typeaheadItemSelected: css.css`
    label: type-ahead-item-selected;
    background-color: ${theme.colors.background.secondary};
  `,
  typeaheadItemMatch: css.css`
    label: type-ahead-item-match;
    color: ${theme.v1.palette.yellow};
    border-bottom: 1px solid ${theme.v1.palette.yellow};
    padding: inherit;
    background: inherit;
  `,
  typeaheadItemGroupTitle: css.css`
    label: type-ahead-item-group-title;
    color: ${theme.colors.text.secondary};
    font-size: ${theme.typography.bodySmall.fontSize};
    line-height: ${theme.typography.body.lineHeight};
    padding: ${theme.spacing(1)};
  `
});
const TypeaheadItem = (props) => {
  const styles = useStyles2(getStyles$Z);
  const { isSelected, item, prefix, style, onMouseEnter, onMouseLeave, onClickItem } = props;
  const className = isSelected ? css.cx([styles.typeaheadItem, styles.typeaheadItemSelected]) : css.cx([styles.typeaheadItem]);
  const highlightClassName = css.cx([styles.typeaheadItemMatch]);
  const itemGroupTitleClassName = css.cx([styles.typeaheadItemGroupTitle]);
  const label = item.label || "";
  if (item.kind === CompletionItemKind.GroupTitle) {
    return /* @__PURE__ */ React__default["default"].createElement("li", { className: itemGroupTitleClassName, style }, /* @__PURE__ */ React__default["default"].createElement("span", null, label));
  }
  return /* @__PURE__ */ React__default["default"].createElement("li", { role: "none" }, /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      role: "menuitem",
      className,
      style,
      onMouseDown: onClickItem,
      onMouseEnter,
      onMouseLeave,
      type: "button"
    },
    item.highlightParts !== void 0 ? /* @__PURE__ */ React__default["default"].createElement(
      PartialHighlighter,
      {
        text: label,
        highlightClassName,
        highlightParts: item.highlightParts
      }
    ) : /* @__PURE__ */ React__default["default"].createElement(
      Highlighter__default["default"],
      {
        textToHighlight: label,
        searchWords: [prefix != null ? prefix : ""],
        autoEscape: true,
        highlightClassName
      }
    )
  ));
};

const modulo$1 = (a, n) => a - n * Math.floor(a / n);
class Typeahead extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.listRef = React.createRef();
    this.state = {
      hoveredItem: null,
      typeaheadIndex: null,
      allItems: [],
      listWidth: -1,
      listHeight: -1,
      itemHeight: -1
    };
    this.componentDidMount = () => {
      if (this.props.menuRef) {
        this.props.menuRef(this);
      }
      document.addEventListener("selectionchange", this.handleSelectionChange);
      const allItems = flattenGroupItems(this.props.groupedItems);
      const longestLabel = calculateLongestLabel(allItems);
      const { listWidth, listHeight, itemHeight } = calculateListSizes(this.context, allItems, longestLabel);
      this.setState({
        listWidth,
        listHeight,
        itemHeight,
        allItems
      });
    };
    this.componentWillUnmount = () => {
      document.removeEventListener("selectionchange", this.handleSelectionChange);
    };
    this.handleSelectionChange = () => {
      this.forceUpdate();
    };
    this.componentDidUpdate = (prevProps, prevState) => {
      if (this.state.typeaheadIndex !== null && prevState.typeaheadIndex !== this.state.typeaheadIndex && this.listRef && this.listRef.current) {
        if (this.state.typeaheadIndex === 1) {
          this.listRef.current.scrollToItem(0);
          return;
        }
        this.listRef.current.scrollToItem(this.state.typeaheadIndex);
      }
      if (lodash.isEqual(prevProps.groupedItems, this.props.groupedItems) === false) {
        const allItems = flattenGroupItems(this.props.groupedItems);
        const longestLabel = calculateLongestLabel(allItems);
        const { listWidth, listHeight, itemHeight } = calculateListSizes(this.context, allItems, longestLabel);
        this.setState({ listWidth, listHeight, itemHeight, allItems, typeaheadIndex: null });
      }
    };
    this.onMouseEnter = (index) => {
      this.setState({
        hoveredItem: index
      });
    };
    this.onMouseLeave = () => {
      this.setState({
        hoveredItem: null
      });
    };
    this.moveMenuIndex = (moveAmount) => {
      const itemCount = this.state.allItems.length;
      if (itemCount) {
        const typeaheadIndex = this.state.typeaheadIndex || 0;
        let newTypeaheadIndex = modulo$1(typeaheadIndex + moveAmount, itemCount);
        if (this.state.allItems[newTypeaheadIndex].kind === CompletionItemKind.GroupTitle) {
          newTypeaheadIndex = modulo$1(newTypeaheadIndex + moveAmount, itemCount);
        }
        this.setState({
          typeaheadIndex: newTypeaheadIndex
        });
        return;
      }
    };
    this.insertSuggestion = () => {
      if (this.props.onSelectSuggestion && this.state.typeaheadIndex !== null) {
        this.props.onSelectSuggestion(this.state.allItems[this.state.typeaheadIndex]);
      }
    };
  }
  get menuPosition() {
    if (!window.getSelection) {
      return "";
    }
    const selection = window.getSelection();
    const node = selection && selection.anchorNode;
    if (node && node.parentElement) {
      const rect = node.parentElement.getBoundingClientRect();
      const scrollX = window.scrollX;
      const scrollY = window.scrollY;
      return `position: absolute; display: flex; top: ${rect.top + scrollY + rect.height + 6}px; left: ${rect.left + scrollX - 2}px`;
    }
    return "";
  }
  render() {
    const { prefix, isOpen = false, origin } = this.props;
    const { allItems, listWidth, listHeight, itemHeight, hoveredItem, typeaheadIndex } = this.state;
    const showDocumentation = hoveredItem || typeaheadIndex;
    const documentationItem = allItems[hoveredItem ? hoveredItem : typeaheadIndex || 0];
    return /* @__PURE__ */ React__default["default"].createElement(Portal, { origin, isOpen, style: this.menuPosition }, /* @__PURE__ */ React__default["default"].createElement("ul", { role: "menu", className: "typeahead", "data-testid": "typeahead" }, /* @__PURE__ */ React__default["default"].createElement(
      reactWindow.FixedSizeList,
      {
        ref: this.listRef,
        itemCount: allItems.length,
        itemSize: itemHeight,
        itemKey: (index) => {
          const item = allItems && allItems[index];
          const key = item ? `${index}-${item.label}` : `${index}`;
          return key;
        },
        width: listWidth,
        height: listHeight
      },
      ({ index, style }) => {
        const item = allItems && allItems[index];
        if (!item) {
          return null;
        }
        return /* @__PURE__ */ React__default["default"].createElement(
          TypeaheadItem,
          {
            onClickItem: () => this.props.onSelectSuggestion ? this.props.onSelectSuggestion(item) : {},
            isSelected: typeaheadIndex === null ? false : allItems[typeaheadIndex] === item,
            item,
            prefix,
            style,
            onMouseEnter: () => this.onMouseEnter(index),
            onMouseLeave: this.onMouseLeave
          }
        );
      }
    )), showDocumentation && /* @__PURE__ */ React__default["default"].createElement(TypeaheadInfo, { height: listHeight, item: documentationItem }));
  }
}
Typeahead.contextType = ThemeContext;
class Portal extends React.PureComponent {
  constructor(props) {
    super(props);
    const { index = 0, origin = "query", style } = props;
    this.node = document.createElement("div");
    this.node.setAttribute("style", style);
    this.node.classList.add(`slate-typeahead`, `slate-typeahead-${origin}-${index}`);
    document.body.appendChild(this.node);
  }
  componentWillUnmount() {
    document.body.removeChild(this.node);
  }
  render() {
    if (this.props.isOpen) {
      this.node.setAttribute("style", this.props.style);
      this.node.classList.add(`slate-typeahead--open`);
      return ReactDOM__default["default"].createPortal(this.props.children, this.node);
    } else {
      this.node.classList.remove(`slate-typeahead--open`);
    }
    return null;
  }
}

var __defProp$1D = Object.defineProperty;
var __defProps$17 = Object.defineProperties;
var __getOwnPropDescs$17 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1E = Object.getOwnPropertySymbols;
var __hasOwnProp$1E = Object.prototype.hasOwnProperty;
var __propIsEnum$1E = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1D = (obj, key, value) => key in obj ? __defProp$1D(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1D = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1E.call(b, prop))
      __defNormalProp$1D(a, prop, b[prop]);
  if (__getOwnPropSymbols$1E)
    for (var prop of __getOwnPropSymbols$1E(b)) {
      if (__propIsEnum$1E.call(b, prop))
        __defNormalProp$1D(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$17 = (a, b) => __defProps$17(a, __getOwnPropDescs$17(b));
const TYPEAHEAD_DEBOUNCE = 250;
function SuggestionsPlugin({
  onTypeahead,
  cleanText,
  onWillApplySuggestion,
  portalOrigin
}) {
  let typeaheadRef;
  let state = {
    groupedItems: [],
    typeaheadPrefix: "",
    typeaheadContext: "",
    typeaheadText: ""
  };
  const handleTypeaheadDebounced = lodash.debounce(handleTypeahead, TYPEAHEAD_DEBOUNCE);
  const setState = (update) => {
    state = __spreadValues$1D(__spreadValues$1D({}, state), update);
  };
  return {
    onBlur: (event, editor, next) => {
      state = __spreadProps$17(__spreadValues$1D({}, state), {
        groupedItems: []
      });
      return next();
    },
    onClick: (event, editor, next) => {
      state = __spreadProps$17(__spreadValues$1D({}, state), {
        groupedItems: []
      });
      return next();
    },
    onKeyDown: (event, editor, next) => {
      const currentSuggestions = state.groupedItems;
      const hasSuggestions = currentSuggestions.length;
      switch (event.key) {
        case "Escape": {
          if (hasSuggestions) {
            event.preventDefault();
            state = __spreadProps$17(__spreadValues$1D({}, state), {
              groupedItems: []
            });
            return editor.insertText("");
          }
          break;
        }
        case "ArrowDown":
        case "ArrowUp":
          if (hasSuggestions) {
            event.preventDefault();
            typeaheadRef.moveMenuIndex(event.key === "ArrowDown" ? 1 : -1);
            return;
          }
          break;
        case "Enter": {
          if (!(event.shiftKey || event.ctrlKey) && hasSuggestions) {
            event.preventDefault();
            return typeaheadRef.insertSuggestion();
          }
          break;
        }
        case "Tab": {
          if (hasSuggestions) {
            event.preventDefault();
            return typeaheadRef.insertSuggestion();
          }
          break;
        }
        default: {
          if (event.key.length === 1) {
            handleTypeaheadDebounced(editor, setState, onTypeahead, cleanText);
          }
          break;
        }
      }
      return next();
    },
    commands: {
      selectSuggestion: (editor, suggestion) => {
        const suggestions = state.groupedItems;
        if (!suggestions || !suggestions.length) {
          return editor;
        }
        const ed = editor.applyTypeahead(suggestion);
        handleTypeaheadDebounced(editor, setState, onTypeahead, cleanText);
        return ed;
      },
      applyTypeahead: (editor, suggestion) => {
        let suggestionText = suggestion.insertText || suggestion.label;
        const preserveSuffix = suggestion.kind === "function";
        const move = suggestion.move || 0;
        const moveForward = move > 0 ? move : 0;
        const moveBackward = move < 0 ? -move : 0;
        const { typeaheadPrefix, typeaheadText, typeaheadContext } = state;
        if (onWillApplySuggestion) {
          suggestionText = onWillApplySuggestion(suggestionText, {
            groupedItems: state.groupedItems,
            typeaheadContext,
            typeaheadPrefix,
            typeaheadText
          });
        }
        const backward = suggestion.deleteBackwards || typeaheadPrefix.length;
        const text = cleanText ? cleanText(typeaheadText) : typeaheadText;
        const suffixLength = text.length - typeaheadPrefix.length;
        const offset = typeaheadText.indexOf(typeaheadPrefix);
        const midWord = typeaheadPrefix && (suffixLength > 0 && offset > -1 || suggestionText === typeaheadText);
        const forward = midWord && !preserveSuffix ? suffixLength + offset : 0;
        if (suggestionText.match(/\n/)) {
          const fragment = makeFragment(suggestionText);
          editor.deleteBackward(backward).deleteForward(forward).insertFragment(fragment).focus();
          return editor;
        }
        state = __spreadProps$17(__spreadValues$1D({}, state), {
          groupedItems: []
        });
        editor.snapshotSelection().deleteBackward(backward).deleteForward(forward).insertText(suggestionText).moveForward(moveForward).moveBackward(moveBackward).focus();
        return editor;
      }
    },
    renderEditor(props, editor, next) {
      if (editor.value.selection.isExpanded) {
        return next();
      }
      const children = next();
      return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, children, /* @__PURE__ */ React__default["default"].createElement(
        Typeahead,
        {
          menuRef: (menu) => typeaheadRef = menu,
          origin: portalOrigin,
          prefix: state.typeaheadPrefix,
          isOpen: !!state.groupedItems.length,
          groupedItems: state.groupedItems,
          onSelectSuggestion: editor.selectSuggestion
        }
      ));
    }
  };
}
const handleTypeahead = async (editor, onStateChange, onTypeahead, cleanText) => {
  if (!onTypeahead) {
    return;
  }
  const { value } = editor;
  const { selection } = value;
  const parentBlock = value.document.getClosestBlock(value.focusBlock.key);
  const selectionStartOffset = value.selection.start.offset - 1;
  const decorations = parentBlock && parentBlock.getDecorations(editor);
  const filteredDecorations = decorations ? decorations.filter(
    (decoration) => decoration.start.offset <= selectionStartOffset && decoration.end.offset > selectionStartOffset && decoration.type === TOKEN_MARK
  ).toArray() : [];
  const labelKeyDec = decorations && decorations.filter(
    (decoration) => decoration.end.offset <= selectionStartOffset && decoration.type === TOKEN_MARK && decoration.data.get("className").includes("label-key")
  ).last();
  const labelKey = labelKeyDec && value.focusText.text.slice(labelKeyDec.start.offset, labelKeyDec.end.offset);
  const wrapperClasses = filteredDecorations.map((decoration) => decoration.data.get("className")).join(" ").split(" ").filter((className) => className.length);
  let text = value.focusText.text;
  let prefix = text.slice(0, selection.focus.offset);
  if (filteredDecorations.length) {
    text = value.focusText.text.slice(filteredDecorations[0].start.offset, filteredDecorations[0].end.offset);
    prefix = value.focusText.text.slice(filteredDecorations[0].start.offset, selection.focus.offset);
  }
  const labelValueMatch = prefix.match(/(?:!?=~?"?|")(.*)/);
  if (labelValueMatch) {
    prefix = labelValueMatch[1];
  } else if (cleanText) {
    prefix = cleanText(prefix);
  }
  const { suggestions, context } = await onTypeahead({
    prefix,
    text,
    value,
    wrapperClasses,
    labelKey: labelKey || void 0,
    editor
  });
  const filteredSuggestions = suggestions.map((group) => {
    if (!group.items) {
      return group;
    }
    const searchFunctionType = group.searchFunctionType || (group.prefixMatch ? SearchFunctionType.Prefix : SearchFunctionType.Word);
    const searchFunction = SearchFunctionMap[searchFunctionType];
    let newGroup = __spreadValues$1D({}, group);
    if (prefix) {
      if (!group.skipFilter) {
        newGroup.items = newGroup.items.filter((c) => (c.filterText || c.label).length >= prefix.length);
        newGroup.items = searchFunction(newGroup.items, prefix);
      }
      newGroup.items = newGroup.items.filter(
        (c) => {
          var _a;
          return !(c.insertText === prefix || ((_a = c.filterText) != null ? _a : c.label) === prefix);
        }
      );
    }
    if (!group.skipSort) {
      newGroup.items = lodash.sortBy(newGroup.items, (item) => {
        if (item.sortText === void 0) {
          return item.sortValue !== void 0 ? item.sortValue : item.label;
        } else {
          return item.sortText || item.label;
        }
      });
    }
    return newGroup;
  }).filter((gr) => gr.items && gr.items.length);
  onStateChange({
    groupedItems: filteredSuggestions,
    typeaheadPrefix: prefix,
    typeaheadContext: context,
    typeaheadText: text
  });
  editor.blur().focus();
};

class UnThemedQueryField extends React.PureComponent {
  constructor(props, context) {
    super(props, context);
    this.lastExecutedValue = null;
    this.mounted = false;
    this.editor = null;
    /**
     * Update local state, propagate change upstream and optionally run the query afterwards.
     */
    this.onChange = (value, runQuery) => {
      const documentChanged = value.document !== this.state.value.document;
      const prevValue = this.state.value;
      if (this.props.onRichValueChange) {
        this.props.onRichValueChange(value);
      }
      this.setState({ value }, () => {
        if (documentChanged) {
          const textChanged = Plain__default["default"].serialize(prevValue) !== Plain__default["default"].serialize(value);
          if (textChanged && runQuery) {
            this.runOnChangeAndRunQuery();
          }
          if (textChanged && !runQuery) {
            this.runOnChangeDebounced();
          }
        }
      });
    };
    this.runOnChange = () => {
      const { onChange } = this.props;
      const value = Plain__default["default"].serialize(this.state.value);
      if (onChange) {
        onChange(this.cleanText(value));
      }
    };
    this.runOnRunQuery = () => {
      const { onRunQuery } = this.props;
      if (onRunQuery) {
        onRunQuery();
        this.lastExecutedValue = this.state.value;
      }
    };
    this.runOnChangeAndRunQuery = () => {
      this.runOnChange();
      this.runOnRunQuery();
    };
    /**
     * We need to handle blur events here mainly because of dashboard panels which expect to have query executed on blur.
     */
    this.handleBlur = (_, editor, next) => {
      const { onBlur } = this.props;
      if (onBlur) {
        onBlur();
      } else {
        const previousValue = this.lastExecutedValue ? Plain__default["default"].serialize(this.lastExecutedValue) : "";
        const currentValue = Plain__default["default"].serialize(editor.value);
        if (previousValue !== currentValue) {
          this.runOnChangeAndRunQuery();
        }
      }
      return next();
    };
    this.runOnChangeDebounced = lodash.debounce(this.runOnChange, 500);
    const { onTypeahead, cleanText, portalOrigin, onWillApplySuggestion } = props;
    this.plugins = [
      // SuggestionsPlugin and RunnerPlugin need to be before NewlinePlugin
      // because they override Enter behavior
      SuggestionsPlugin({ onTypeahead, cleanText, portalOrigin, onWillApplySuggestion }),
      RunnerPlugin({ handler: this.runOnChangeAndRunQuery }),
      NewlinePlugin(),
      ClearPlugin(),
      SelectionShortcutsPlugin(),
      IndentationPlugin(),
      ClipboardPlugin(),
      ...props.additionalPlugins || []
    ].filter((p) => p);
    this.state = {
      suggestions: [],
      typeaheadContext: null,
      typeaheadPrefix: "",
      typeaheadText: "",
      value: makeValue(props.query || "", props.syntax)
    };
  }
  componentDidMount() {
    this.mounted = true;
  }
  componentWillUnmount() {
    this.mounted = false;
  }
  componentDidUpdate(prevProps, prevState) {
    const { query, syntax, syntaxLoaded } = this.props;
    if (!prevProps.syntaxLoaded && syntaxLoaded && this.editor) {
      const editor = this.editor.insertText(" ").deleteBackward(1);
      this.onChange(editor.value, true);
    }
    const { value } = this.state;
    if (query !== prevProps.query) {
      if (query !== Plain__default["default"].serialize(value)) {
        this.setState({ value: makeValue(query || "", syntax) });
      }
    }
  }
  cleanText(text) {
    const newText = text.replace(/[\r]/g, "");
    return newText;
  }
  render() {
    const { disabled, theme } = this.props;
    const wrapperClassName = classNames__default["default"]("slate-query-field__wrapper", {
      "slate-query-field__wrapper--disabled": disabled
    });
    const styles = getStyles$Y(theme);
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(wrapperClassName, styles.wrapper) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "slate-query-field", "aria-label": e2eSelectors.selectors.components.QueryField.container }, /* @__PURE__ */ React__default["default"].createElement(
      slateReact.Editor,
      {
        ref: (editor) => this.editor = editor,
        schema: SCHEMA,
        autoCorrect: false,
        readOnly: this.props.disabled,
        onBlur: this.handleBlur,
        onClick: this.props.onClick,
        onChange: (change) => {
          this.onChange(change.value, false);
        },
        placeholder: this.props.placeholder,
        plugins: this.plugins,
        spellCheck: false,
        value: this.state.value
      }
    )));
  }
}
const QueryField = withTheme2(UnThemedQueryField);
const getStyles$Y = (theme) => {
  const focusStyles = getFocusStyles(theme);
  return {
    wrapper: css.css`
      &:focus-within {
        ${focusStyles}
      }
    `
  };
};

var __defProp$1C = Object.defineProperty;
var __defProps$16 = Object.defineProperties;
var __getOwnPropDescs$16 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1D = Object.getOwnPropertySymbols;
var __hasOwnProp$1D = Object.prototype.hasOwnProperty;
var __propIsEnum$1D = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1C = (obj, key, value) => key in obj ? __defProp$1C(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1C = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1D.call(b, prop))
      __defNormalProp$1C(a, prop, b[prop]);
  if (__getOwnPropSymbols$1D)
    for (var prop of __getOwnPropSymbols$1D(b)) {
      if (__propIsEnum$1D.call(b, prop))
        __defNormalProp$1C(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$16 = (a, b) => __defProps$16(a, __getOwnPropDescs$16(b));
const useAsyncDependency = (importStatement) => {
  const state = reactUse.useAsync(async () => {
    return await importStatement;
  });
  return __spreadProps$16(__spreadValues$1C({}, state), {
    dependency: state.value
  });
};

var __defProp$1B = Object.defineProperty;
var __getOwnPropSymbols$1C = Object.getOwnPropertySymbols;
var __hasOwnProp$1C = Object.prototype.hasOwnProperty;
var __propIsEnum$1C = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1B = (obj, key, value) => key in obj ? __defProp$1B(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1B = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1C.call(b, prop))
      __defNormalProp$1B(a, prop, b[prop]);
  if (__getOwnPropSymbols$1C)
    for (var prop of __getOwnPropSymbols$1C(b)) {
      if (__propIsEnum$1C.call(b, prop))
        __defNormalProp$1B(a, prop, b[prop]);
    }
  return a;
};
const ReactMonacoEditorLazy = (props) => {
  const { loading, error, dependency } = useAsyncDependency(
    Promise.resolve().then(function () { return require(
      /* webpackChunkName: "react-monaco-editor" */
      './ReactMonacoEditor-8ab536b2.js'
    ); })
  );
  if (loading) {
    return /* @__PURE__ */ React__default["default"].createElement(LoadingPlaceholder, { text: "" });
  }
  if (error) {
    return /* @__PURE__ */ React__default["default"].createElement(
      ErrorWithStack,
      {
        title: "React Monaco Editor failed to load",
        error,
        errorInfo: { componentStack: (error == null ? void 0 : error.stack) || "" }
      }
    );
  }
  const ReactMonacoEditor = dependency.ReactMonacoEditor;
  return /* @__PURE__ */ React__default["default"].createElement(ReactMonacoEditor, __spreadValues$1B({}, props));
};

var CodeEditorSuggestionItemKind = /* @__PURE__ */ ((CodeEditorSuggestionItemKind2) => {
  CodeEditorSuggestionItemKind2["Method"] = "method";
  CodeEditorSuggestionItemKind2["Field"] = "field";
  CodeEditorSuggestionItemKind2["Property"] = "property";
  CodeEditorSuggestionItemKind2["Constant"] = "constant";
  CodeEditorSuggestionItemKind2["Text"] = "text";
  return CodeEditorSuggestionItemKind2;
})(CodeEditorSuggestionItemKind || {});

var __defProp$1A = Object.defineProperty;
var __defProps$15 = Object.defineProperties;
var __getOwnPropDescs$15 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1B = Object.getOwnPropertySymbols;
var __hasOwnProp$1B = Object.prototype.hasOwnProperty;
var __propIsEnum$1B = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1A = (obj, key, value) => key in obj ? __defProp$1A(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1A = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1B.call(b, prop))
      __defNormalProp$1A(a, prop, b[prop]);
  if (__getOwnPropSymbols$1B)
    for (var prop of __getOwnPropSymbols$1B(b)) {
      if (__propIsEnum$1B.call(b, prop))
        __defNormalProp$1A(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$15 = (a, b) => __defProps$15(a, __getOwnPropDescs$15(b));
function findInsertIndex(line) {
  for (let i = line.length - 1; i > 0; i--) {
    const ch = line.charAt(i);
    if (ch === "$") {
      return {
        index: i,
        prefix: line.substring(i)
      };
    }
    if (ch === " " || ch === "	" || ch === '"' || ch === "'") {
      return {
        index: i + 1,
        prefix: line.substring(i + 1)
      };
    }
  }
  return {
    index: 0,
    prefix: line
  };
}
function getCompletionItems(monaco, prefix, suggestions, range) {
  var _a;
  const items = [];
  for (const suggestion of suggestions) {
    if (prefix && !suggestion.label.startsWith(prefix)) {
      continue;
    }
    items.push(__spreadProps$15(__spreadValues$1A({}, suggestion), {
      kind: mapKinds(monaco, suggestion.kind),
      range,
      insertText: (_a = suggestion.insertText) != null ? _a : suggestion.label
    }));
  }
  return items;
}
function mapKinds(monaco, sug) {
  switch (sug) {
    case CodeEditorSuggestionItemKind.Method:
      return monaco.languages.CompletionItemKind.Method;
    case CodeEditorSuggestionItemKind.Field:
      return monaco.languages.CompletionItemKind.Field;
    case CodeEditorSuggestionItemKind.Property:
      return monaco.languages.CompletionItemKind.Property;
    case CodeEditorSuggestionItemKind.Constant:
      return monaco.languages.CompletionItemKind.Constant;
    case CodeEditorSuggestionItemKind.Text:
      return monaco.languages.CompletionItemKind.Text;
  }
  return monaco.languages.CompletionItemKind.Text;
}
function registerSuggestions(monaco, language, getSuggestions) {
  if (!language || !getSuggestions) {
    return void 0;
  }
  return monaco.languages.registerCompletionItemProvider(language, {
    triggerCharacters: ["$"],
    provideCompletionItems: (model, position, context) => {
      const range = {
        startLineNumber: position.lineNumber,
        endLineNumber: position.lineNumber,
        startColumn: position.column,
        endColumn: position.column
      };
      if (context.triggerCharacter === "$") {
        range.startColumn = position.column - 1;
        return {
          suggestions: getCompletionItems(monaco, "$", getSuggestions(), range)
        };
      }
      const currentLine = model.getValueInRange({
        startLineNumber: position.lineNumber,
        startColumn: 1,
        endLineNumber: position.lineNumber,
        endColumn: position.column
      });
      const { index, prefix } = findInsertIndex(currentLine);
      range.startColumn = index + 1;
      const suggestions = getCompletionItems(monaco, prefix, getSuggestions(), range);
      if (suggestions.length) {
        return { suggestions };
      }
      return void 0;
    }
  });
}

var __defProp$1z = Object.defineProperty;
var __getOwnPropSymbols$1A = Object.getOwnPropertySymbols;
var __hasOwnProp$1A = Object.prototype.hasOwnProperty;
var __propIsEnum$1A = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1z = (obj, key, value) => key in obj ? __defProp$1z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1z = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1A.call(b, prop))
      __defNormalProp$1z(a, prop, b[prop]);
  if (__getOwnPropSymbols$1A)
    for (var prop of __getOwnPropSymbols$1A(b)) {
      if (__propIsEnum$1A.call(b, prop))
        __defNormalProp$1z(a, prop, b[prop]);
    }
  return a;
};
class UnthemedCodeEditor extends React.PureComponent {
  constructor(props) {
    super(props);
    this.loadCustomLanguage = () => {
      const { language } = this.props;
      const customLanguage = data.monacoLanguageRegistry.getIfExists(language);
      if (customLanguage) {
        return customLanguage.init();
      }
      return Promise.resolve();
    };
    // This is replaced with a real function when the actual editor mounts
    this.getEditorValue = () => "";
    this.onBlur = () => {
      const { onBlur } = this.props;
      if (onBlur) {
        onBlur(this.getEditorValue());
      }
    };
    this.onSave = () => {
      const { onSave } = this.props;
      if (onSave) {
        onSave(this.getEditorValue());
      }
    };
    this.handleBeforeMount = (monaco) => {
      this.monaco = monaco;
      const { language, getSuggestions, onBeforeEditorMount } = this.props;
      if (getSuggestions) {
        this.completionCancel = registerSuggestions(monaco, language, getSuggestions);
      }
      onBeforeEditorMount == null ? void 0 : onBeforeEditorMount(monaco);
    };
    this.handleOnMount = (editor, monaco) => {
      var _a;
      const { onChange, onEditorDidMount } = this.props;
      this.getEditorValue = () => editor.getValue();
      editor.addCommand(monaco.KeyMod.CtrlCmd | monaco.KeyCode.KeyS, this.onSave);
      const languagePromise = this.loadCustomLanguage();
      if (onEditorDidMount) {
        languagePromise.then(() => onEditorDidMount(editor, monaco));
        (_a = editor.getModel()) == null ? void 0 : _a.onDidChangeContent(() => onChange == null ? void 0 : onChange(editor.getValue()));
      }
    };
  }
  componentWillUnmount() {
    if (this.completionCancel) {
      this.completionCancel.dispose();
    }
  }
  componentDidUpdate(oldProps) {
    const { getSuggestions, language } = this.props;
    const newLanguage = oldProps.language !== language;
    const newGetSuggestions = oldProps.getSuggestions !== getSuggestions;
    if (newGetSuggestions || newLanguage) {
      if (this.completionCancel) {
        this.completionCancel.dispose();
      }
      if (!this.monaco) {
        console.warn("Monaco instance not loaded yet");
        return;
      }
      if (getSuggestions) {
        this.completionCancel = registerSuggestions(this.monaco, language, getSuggestions);
      }
    }
    if (newLanguage) {
      this.loadCustomLanguage();
    }
  }
  render() {
    var _a, _b;
    const { theme, language, width, height, showMiniMap, showLineNumbers, readOnly, monacoOptions } = this.props;
    const value = (_a = this.props.value) != null ? _a : "";
    const longText = value.length > 100;
    const containerStyles = (_b = this.props.containerStyles) != null ? _b : getStyles$X(theme).container;
    const options = {
      wordWrap: "off",
      tabSize: 2,
      codeLens: false,
      contextmenu: false,
      minimap: {
        enabled: longText && showMiniMap,
        renderCharacters: false
      },
      readOnly,
      lineNumbersMinChars: 4,
      lineDecorationsWidth: 1 * theme.spacing.gridSize,
      overviewRulerBorder: false,
      automaticLayout: true,
      padding: {
        top: 0.5 * theme.spacing.gridSize,
        bottom: 0.5 * theme.spacing.gridSize
      },
      fixedOverflowWidgets: true
      // Ensures suggestions menu is drawn on top
    };
    if (!showLineNumbers) {
      options.glyphMargin = false;
      options.folding = false;
      options.lineNumbers = "off";
      options.lineNumbersMinChars = 0;
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: containerStyles, onBlur: this.onBlur, "aria-label": e2eSelectors.selectors.components.CodeEditor.container }, /* @__PURE__ */ React__default["default"].createElement(
      ReactMonacoEditorLazy,
      {
        width,
        height,
        language,
        value,
        options: __spreadValues$1z(__spreadValues$1z({}, options), monacoOptions != null ? monacoOptions : {}),
        beforeMount: this.handleBeforeMount,
        onMount: this.handleOnMount
      }
    ));
  }
}
const CodeEditor = withTheme2(UnthemedCodeEditor);
const getStyles$X = (theme) => {
  return {
    container: css.css`
      border-radius: ${theme.shape.borderRadius()};
      border: 1px solid ${theme.components.input.borderColor};
    `
  };
};

function variableSuggestionToCodeEditorSuggestion(sug) {
  const label = "${" + sug.value + "}";
  const detail = sug.value === sug.label ? sug.origin : `${sug.label} / ${sug.origin}`;
  return {
    label,
    kind: CodeEditorSuggestionItemKind.Property,
    detail,
    documentation: sug.documentation
  };
}

const getStyles$W = stylesFactory((theme) => {
  return {
    counter: css.css`
      label: counter;
      margin-left: ${theme.spacing(1)};
      border-radius: ${theme.spacing(3)};
      background-color: ${theme.colors.action.hover};
      padding: ${theme.spacing(0.25, 1)};
      color: ${theme.colors.text.secondary};
      font-weight: ${theme.typography.fontWeightMedium};
      font-size: ${theme.typography.size.sm};
    `
  };
});
const Counter = ({ value }) => {
  const styles = useStyles2(getStyles$W);
  return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.counter }, data.locale(value, 0).text);
};

var __defProp$1y = Object.defineProperty;
var __defProps$14 = Object.defineProperties;
var __getOwnPropDescs$14 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1z = Object.getOwnPropertySymbols;
var __hasOwnProp$1z = Object.prototype.hasOwnProperty;
var __propIsEnum$1z = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1y = (obj, key, value) => key in obj ? __defProp$1y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1y = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1z.call(b, prop))
      __defNormalProp$1y(a, prop, b[prop]);
  if (__getOwnPropSymbols$1z)
    for (var prop of __getOwnPropSymbols$1z(b)) {
      if (__propIsEnum$1z.call(b, prop))
        __defNormalProp$1y(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$14 = (a, b) => __defProps$14(a, __getOwnPropDescs$14(b));
var __objRest$J = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1z.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1z)
    for (var prop of __getOwnPropSymbols$1z(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1z.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Tab = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { label, active, icon, onChangeTab, counter, suffix: Suffix, className, href } = _b, otherProps = __objRest$J(_b, ["label", "active", "icon", "onChangeTab", "counter", "suffix", "className", "href"]);
    const tabsStyles = useStyles2(getStyles$V);
    const content = () => /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon }), label, typeof counter === "number" && /* @__PURE__ */ React__default["default"].createElement(Counter, { value: counter }), Suffix && /* @__PURE__ */ React__default["default"].createElement(Suffix, { className: tabsStyles.suffix }));
    const linkClass = css.cx(tabsStyles.link, active ? tabsStyles.activeStyle : tabsStyles.notActive);
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: tabsStyles.item }, /* @__PURE__ */ React__default["default"].createElement(
      "a",
      __spreadProps$14(__spreadValues$1y({
        href: href ? href : "#",
        className: linkClass
      }, otherProps), {
        onClick: onChangeTab,
        "aria-label": otherProps["aria-label"] || e2eSelectors.selectors.components.Tab.title(label),
        role: "tab",
        "aria-selected": active,
        ref
      }),
      content()
    ));
  }
);
Tab.displayName = "Tab";
const getStyles$V = (theme) => {
  return {
    item: css.css`
      list-style: none;
      position: relative;
      display: flex;
      white-space: nowrap;
    `,
    link: css.css`
      color: ${theme.colors.text.secondary};
      padding: ${theme.spacing(1.5, 2, 1)};
      display: block;
      height: 100%;

      svg {
        margin-right: ${theme.spacing(1)};
      }

      &:focus-visible {
        ${getFocusStyles(theme)}
      }

      &::before {
        display: block;
        content: ' ';
        position: absolute;
        left: 0;
        right: 0;
        height: 4px;
        border-radius: ${theme.shape.radius.default};
        bottom: 0px;
      }
    `,
    notActive: css.css`
      a:hover,
      &:hover,
      &:focus {
        color: ${theme.colors.text.primary};

        &::before {
          background-color: ${theme.colors.action.hover};
        }
      }
    `,
    activeStyle: css.css`
      label: activeTabStyle;
      color: ${theme.colors.text.primary};
      overflow: hidden;

      a {
        color: ${theme.colors.text.primary};
      }

      &::before {
        background-image: ${theme.colors.gradients.brandHorizontal};
      }
    `,
    suffix: css.css`
      margin-left: ${theme.spacing(1)};
    `
  };
};

const getTabsBarStyles = stylesFactory((theme, hideBorder = false) => {
  return {
    tabsWrapper: !hideBorder && css.css`
        border-bottom: 1px solid ${theme.colors.border.weak};
      `,
    tabs: css.css`
      position: relative;
      display: flex;
      height: ${theme.components.menuTabs.height}px;
    `
  };
});
const TabsBar = React__default["default"].forwardRef(({ children, className, hideBorder }, ref) => {
  const theme = useTheme2();
  const tabsStyles = getTabsBarStyles(theme, hideBorder);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(tabsStyles.tabsWrapper, className), ref }, /* @__PURE__ */ React__default["default"].createElement("div", { className: tabsStyles.tabs, role: "tablist" }, children));
});
TabsBar.displayName = "TabsBar";

const ModalTabsHeader = ({ icon, title, tabs, activeTab, onChangeTab }) => {
  return /* @__PURE__ */ React__default["default"].createElement(ModalHeader, { icon, title }, /* @__PURE__ */ React__default["default"].createElement(TabsBar, { hideBorder: true }, tabs.map((t, index) => {
    return /* @__PURE__ */ React__default["default"].createElement(
      Tab,
      {
        key: `${t.value}-${index}`,
        label: t.label,
        icon: t.icon,
        suffix: t.tabSuffix,
        active: t.value === activeTab,
        onChangeTab: () => onChangeTab(t)
      }
    );
  })));
};

const ModalTabContent = ({ children }) => {
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: "share-modal-body" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "share-modal-header" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "share-modal-content" }, children)));
};

var __defProp$1x = Object.defineProperty;
var __getOwnPropSymbols$1y = Object.getOwnPropertySymbols;
var __hasOwnProp$1y = Object.prototype.hasOwnProperty;
var __propIsEnum$1y = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1x = (obj, key, value) => key in obj ? __defProp$1x(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1x = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1y.call(b, prop))
      __defNormalProp$1x(a, prop, b[prop]);
  if (__getOwnPropSymbols$1y)
    for (var prop of __getOwnPropSymbols$1y(b)) {
      if (__propIsEnum$1y.call(b, prop))
        __defNormalProp$1x(a, prop, b[prop]);
    }
  return a;
};
const ModalsContext = React__default["default"].createContext({
  component: null,
  props: {},
  showModal: () => {
  },
  hideModal: () => {
  }
});
class ModalsProvider extends React.Component {
  constructor(props) {
    super(props);
    this.showModal = (component, props) => {
      this.setState({
        component,
        props
      });
    };
    this.hideModal = () => {
      this.setState({
        component: null,
        props: {}
      });
    };
    this.state = {
      component: props.component || null,
      props: props.props || {},
      showModal: this.showModal,
      hideModal: this.hideModal
    };
  }
  render() {
    return /* @__PURE__ */ React__default["default"].createElement(ModalsContext.Provider, { value: this.state }, this.props.children);
  }
}
const ModalRoot = () => /* @__PURE__ */ React__default["default"].createElement(ModalsContext.Consumer, null, ({ component: Component2, props }) => {
  return Component2 ? /* @__PURE__ */ React__default["default"].createElement(Component2, __spreadValues$1x({}, props)) : null;
});
const ModalsController = ModalsContext.Consumer;

const PageToolbar = React__default["default"].memo(
  ({
    title,
    section,
    parent,
    pageIcon,
    onGoBack,
    children,
    titleHref,
    parentHref,
    leftItems,
    isFullscreen,
    className,
    /** main nav-container aria-label **/
    "aria-label": ariaLabel,
    buttonOverflowAlignment = "right",
    forceShowLeftItems = false
  }) => {
    const styles = useStyles2(getStyles$U);
    const mainStyle = css.cx(
      "page-toolbar",
      styles.toolbar,
      {
        ["page-toolbar--fullscreen"]: isFullscreen,
        [styles.noPageIcon]: !pageIcon
      },
      className
    );
    const titleEl = /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.truncateText }, title), section && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.pre }, " / ", section));
    return /* @__PURE__ */ React__default["default"].createElement("nav", { className: mainStyle, "aria-label": ariaLabel }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.leftWrapper }, pageIcon && !onGoBack && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.pageIcon }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: pageIcon, size: "lg", "aria-hidden": true })), onGoBack && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.pageIcon }, /* @__PURE__ */ React__default["default"].createElement(
      IconButton,
      {
        name: "arrow-left",
        tooltip: "Go back (Esc)",
        tooltipPlacement: "bottom",
        size: "xxl",
        "aria-label": e2eSelectors.selectors.components.BackButton.backArrow,
        onClick: onGoBack
      }
    )), /* @__PURE__ */ React__default["default"].createElement("nav", { "aria-label": "Search links", className: styles.navElement }, parent && parentHref && /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
      Link,
      {
        "aria-label": `Search dashboard in the ${parent} folder`,
        className: css.cx(styles.titleText, styles.parentLink, styles.titleLink, styles.truncateText),
        href: parentHref
      },
      parent,
      " ",
      /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.parentIcon })
    ), titleHref && /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx(styles.titleText, styles.titleDivider), "aria-hidden": true }, "/")), (title || Boolean(leftItems == null ? void 0 : leftItems.length)) && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.titleWrapper }, title && /* @__PURE__ */ React__default["default"].createElement("h1", { className: styles.h1Styles }, titleHref ? /* @__PURE__ */ React__default["default"].createElement(
      Link,
      {
        "aria-label": "Search dashboard by name",
        className: css.cx(styles.titleText, styles.titleLink),
        href: titleHref
      },
      titleEl
    ) : /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.titleText }, titleEl)), leftItems == null ? void 0 : leftItems.map((child, index) => /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        className: css.cx(styles.leftActionItem, { [styles.forceShowLeftActionItems]: forceShowLeftItems }),
        key: index
      },
      child
    ))))), /* @__PURE__ */ React__default["default"].createElement(ToolbarButtonRow, { alignment: buttonOverflowAlignment }, React__default["default"].Children.toArray(children).filter(Boolean)));
  }
);
PageToolbar.displayName = "PageToolbar";
const getStyles$U = (theme) => {
  const { spacing, typography } = theme;
  const focusStyle = getFocusStyles(theme);
  return {
    pre: css.css`
      white-space: pre;
    `,
    toolbar: css.css`
      align-items: center;
      background: ${theme.colors.background.canvas};
      display: flex;
      gap: ${theme.spacing(2)};
      justify-content: space-between;
      padding: ${theme.spacing(1.5, 2)};

      ${theme.breakpoints.down("md")} {
        padding-left: 53px;
      }
    `,
    noPageIcon: css.css`
      ${theme.breakpoints.down("md")} {
        padding-left: ${theme.spacing(2)};
      }
    `,
    leftWrapper: css.css`
      display: flex;
      flex-wrap: nowrap;
      max-width: 70%;
    `,
    pageIcon: css.css`
      display: none;
      ${theme.breakpoints.up("sm")} {
        display: flex;
        padding-right: ${theme.spacing(1)};
        align-items: center;
      }
    `,
    truncateText: css.css`
      overflow: hidden;
      text-overflow: ellipsis;
      white-space: nowrap;
    `,
    titleWrapper: css.css`
      display: flex;
      margin: 0;
      min-width: 0;
    `,
    navElement: css.css`
      display: flex;
      align-items: center;
      min-width: 0;
    `,
    h1Styles: css.css`
      margin: ${spacing(0, 1, 0, 0)};
      line-height: inherit;
      flex-grow: 1;
      min-width: 0;
    `,
    parentIcon: css.css`
      margin-left: ${theme.spacing(0.5)};
    `,
    titleText: css.css`
      display: flex;
      font-size: ${typography.size.lg};
      margin: 0;
      max-width: 300px;
      border-radius: ${theme.shape.radius.default};
    `,
    titleLink: css.css`
      &:focus-visible {
        ${focusStyle}
      }
    `,
    titleDivider: css.css`
      padding: ${spacing(0, 0.5, 0, 0.5)};
      display: none;
      ${theme.breakpoints.up("md")} {
        display: unset;
      }
    `,
    parentLink: css.css`
      display: none;
      ${theme.breakpoints.up("md")} {
        display: unset;
        flex: 1;
      }
    `,
    leftActionItem: css.css`
      display: none;
      align-items: center;
      padding-right: ${spacing(0.5)};
      ${theme.breakpoints.up("md")} {
        display: flex;
      }
    `,
    forceShowLeftActionItems: css.css`
      display: flex;
    `
  };
};

class SetInterval extends React.PureComponent {
  constructor(props) {
    super(props);
    this.propsSubject = new rxjs.Subject();
    this.subscription = null;
  }
  componentDidMount() {
    this.subscription = this.propsSubject.pipe(
      // switchMap creates a new observables based on the input stream,
      // which becomes part of the propsSubject stream
      operators.switchMap((props) => {
        if (RefreshPicker.isLive(props.interval)) {
          return rxjs.of({});
        }
        return props.loading ? rxjs.NEVER : rxjs.interval(data.stringToMs(props.interval));
      }),
      // tap will execute function passed via func prop
      // * on value from `of` stream merged if query is live
      // * on specified interval (triggered by values emitted by interval)
      operators.tap(() => this.props.func())
    ).subscribe();
    this.propsSubject.next(this.props);
  }
  componentDidUpdate(prevProps) {
    if (RefreshPicker.isLive(prevProps.interval) && RefreshPicker.isLive(this.props.interval) || lodash.isEqual(prevProps, this.props)) {
      return;
    }
    this.propsSubject.next(this.props);
  }
  componentWillUnmount() {
    if (this.subscription) {
      this.subscription.unsubscribe();
    }
    this.propsSubject.unsubscribe();
  }
  render() {
    return null;
  }
}

const FooterCell = (props) => {
  const cell = css.css`
    width: 100%;
    list-style: none;
  `;
  const list = css.css`
    width: 100%;
    display: flex;
    flex-direction: row;
    justify-content: space-between;
  `;
  if (props.value && !Array.isArray(props.value)) {
    return /* @__PURE__ */ React__default["default"].createElement("span", null, props.value);
  }
  if (props.value && Array.isArray(props.value) && props.value.length > 0) {
    return /* @__PURE__ */ React__default["default"].createElement("ul", { className: cell }, props.value.map((v, i) => {
      const key = Object.keys(v)[0];
      return /* @__PURE__ */ React__default["default"].createElement("li", { className: list, key: i }, /* @__PURE__ */ React__default["default"].createElement("span", null, key), /* @__PURE__ */ React__default["default"].createElement("span", null, v[key]));
    }));
  }
  return EmptyCell;
};
const EmptyCell = () => {
  return /* @__PURE__ */ React__default["default"].createElement("span", null, "\xA0");
};

var __defProp$1w = Object.defineProperty;
var __defProps$13 = Object.defineProperties;
var __getOwnPropDescs$13 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1x = Object.getOwnPropertySymbols;
var __hasOwnProp$1x = Object.prototype.hasOwnProperty;
var __propIsEnum$1x = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1w = (obj, key, value) => key in obj ? __defProp$1w(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1w = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1x.call(b, prop))
      __defNormalProp$1w(a, prop, b[prop]);
  if (__getOwnPropSymbols$1x)
    for (var prop of __getOwnPropSymbols$1x(b)) {
      if (__propIsEnum$1x.call(b, prop))
        __defNormalProp$1w(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$13 = (a, b) => __defProps$13(a, __getOwnPropDescs$13(b));
var __objRest$I = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1x.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1x)
    for (var prop of __getOwnPropSymbols$1x(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1x.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function FooterRow(props) {
  const { totalColumnsWidth, footerGroups, isPaginationVisible, tableStyles } = props;
  const e2eSelectorsTable = e2eSelectors.selectors.components.Panels.Visualization.Table;
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      style: {
        position: isPaginationVisible ? "relative" : "absolute",
        width: totalColumnsWidth ? `${totalColumnsWidth}px` : "100%",
        bottom: "0px"
      }
    },
    footerGroups.map((footerGroup) => {
      const _a = footerGroup.getFooterGroupProps(), { key } = _a, footerGroupProps = __objRest$I(_a, ["key"]);
      return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$13(__spreadValues$1w({ className: tableStyles.tfoot }, footerGroupProps), { key, "data-testid": e2eSelectorsTable.footer }), footerGroup.headers.map((column) => renderFooterCell(column, tableStyles)));
    })
  );
}
function renderFooterCell(column, tableStyles) {
  var _a;
  const footerProps = column.getHeaderProps();
  if (!footerProps) {
    return null;
  }
  footerProps.style = (_a = footerProps.style) != null ? _a : {};
  footerProps.style.position = "absolute";
  footerProps.style.justifyContent = column.justifyContent;
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1w({ className: tableStyles.headerCell }, footerProps), column.render("Footer"));
}
function getFooterValue(index, footerValues, isCountRowsSet) {
  if (footerValues === void 0) {
    return EmptyCell;
  }
  if (isCountRowsSet) {
    if (footerValues[index] === void 0) {
      return EmptyCell;
    }
    const key = data.fieldReducers.get(data.ReducerID.count).name;
    return FooterCell({ value: [{ [key]: String(footerValues[index]) }] });
  }
  return FooterCell({ value: footerValues[index] });
}

const getAvailableIcons = () => Object.keys(data.availableIconsIndex);
function getFieldTypeIcon(field) {
  return getFieldTypeIconName(field == null ? void 0 : field.type);
}
function getFieldTypeIconName(type) {
  if (type) {
    switch (type) {
      case data.FieldType.time:
        return "clock-nine";
      case data.FieldType.string:
        return "font";
      case data.FieldType.number:
        return "calculator-alt";
      case data.FieldType.boolean:
        return "toggle-on";
      case data.FieldType.trace:
        return "info-circle";
      case data.FieldType.enum:
        return "list-ol";
      case data.FieldType.geo:
        return "map-marker";
      case data.FieldType.other:
        return "brackets-curly";
    }
  }
  return "question-circle";
}

const ITEM_HEIGHT = 28;
const MIN_HEIGHT = ITEM_HEIGHT * 5;
const FilterList = ({ options, values, caseSensitive, onChange }) => {
  const theme = useTheme2();
  const styles = getStyles$T(theme);
  const [searchFilter, setSearchFilter] = React.useState("");
  const regex = React.useMemo(() => new RegExp(searchFilter, caseSensitive ? void 0 : "i"), [searchFilter, caseSensitive]);
  const items = React.useMemo(
    () => options.filter((option) => {
      if (option.label === void 0) {
        return false;
      }
      return regex.test(option.label);
    }),
    [options, regex]
  );
  const gutter = theme.spacing.gridSize;
  const height = React.useMemo(() => Math.min(items.length * ITEM_HEIGHT, MIN_HEIGHT) + gutter, [gutter, items.length]);
  const onInputChange = React.useCallback(
    (v) => {
      setSearchFilter(v);
    },
    [setSearchFilter]
  );
  const onCheckedChanged = React.useCallback(
    (option) => (event) => {
      const newValues = event.currentTarget.checked ? values.concat(option) : values.filter((c) => c.value !== option.value);
      onChange(newValues);
    },
    [onChange, values]
  );
  return /* @__PURE__ */ React__default["default"].createElement(VerticalGroup, { spacing: "md" }, /* @__PURE__ */ React__default["default"].createElement(FilterInput, { placeholder: "Filter values", onChange: onInputChange, value: searchFilter }), !items.length && /* @__PURE__ */ React__default["default"].createElement(Label$1, null, "No values"), items.length && /* @__PURE__ */ React__default["default"].createElement(
    reactWindow.FixedSizeList,
    {
      height,
      itemCount: items.length,
      itemSize: ITEM_HEIGHT,
      width: "100%",
      className: styles.filterList
    },
    ({ index, style }) => {
      const option = items[index];
      const { value, label } = option;
      const isChecked = values.find((s) => s.value === value) !== void 0;
      return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.filterListRow, style, title: label }, /* @__PURE__ */ React__default["default"].createElement(Checkbox, { value: isChecked, label, onChange: onCheckedChanged(option) }));
    }
  ));
};
const getStyles$T = stylesFactory((theme) => ({
  filterList: css.css`
    label: filterList;
  `,
  filterListRow: css.css`
    label: filterListRow;
    cursor: pointer;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    padding: ${theme.spacing(0.5)};

    :hover {
      background-color: ${theme.colors.action.hover};
    }
  `
}));

var __defProp$1v = Object.defineProperty;
var __getOwnPropSymbols$1w = Object.getOwnPropertySymbols;
var __hasOwnProp$1w = Object.prototype.hasOwnProperty;
var __propIsEnum$1w = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1v = (obj, key, value) => key in obj ? __defProp$1v(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1v = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1w.call(b, prop))
      __defNormalProp$1v(a, prop, b[prop]);
  if (__getOwnPropSymbols$1w)
    for (var prop of __getOwnPropSymbols$1w(b)) {
      if (__propIsEnum$1w.call(b, prop))
        __defNormalProp$1v(a, prop, b[prop]);
    }
  return a;
};
var __objRest$H = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1w.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1w)
    for (var prop of __getOwnPropSymbols$1w(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1w.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function fontSizeReductionFactor(fontSize) {
  if (fontSize < 20) {
    return 0.9;
  }
  if (fontSize < 26) {
    return 0.8;
  }
  return 0.6;
}
const FormattedValueDisplay = (_a) => {
  var _b = _a, { value, className, style } = _b, htmlProps = __objRest$H(_b, ["value", "className", "style"]);
  var _a2, _b2;
  const hasPrefix = ((_a2 = value.prefix) != null ? _a2 : "").length > 0;
  const hasSuffix = ((_b2 = value.suffix) != null ? _b2 : "").length > 0;
  let suffixStyle;
  if (style && style.fontSize && typeof style.fontSize === "number") {
    const fontSize = style.fontSize;
    const reductionFactor = fontSizeReductionFactor(fontSize);
    suffixStyle = { fontSize: fontSize * reductionFactor };
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1v({ className, style }, htmlProps), /* @__PURE__ */ React__default["default"].createElement("div", null, hasPrefix && /* @__PURE__ */ React__default["default"].createElement("span", null, value.prefix), /* @__PURE__ */ React__default["default"].createElement("span", null, value.text), hasSuffix && /* @__PURE__ */ React__default["default"].createElement("span", { style: suffixStyle }, value.suffix)));
};
FormattedValueDisplay.displayName = "FormattedDisplayValue";

const MIN_VALUE_HEIGHT = 18;
const MAX_VALUE_HEIGHT = 50;
const MAX_VALUE_WIDTH = 150;
const TITLE_LINE_HEIGHT = 1.5;
const VALUE_LINE_HEIGHT = 1;
const VALUE_LEFT_PADDING = 10;
class BarGauge extends React.PureComponent {
  render() {
    const { onClick, className, theme } = this.props;
    const { title } = this.props.value;
    const styles = getTitleStyles(this.props);
    if (onClick) {
      return /* @__PURE__ */ React__default["default"].createElement(
        "button",
        {
          type: "button",
          style: styles.wrapper,
          onClick,
          className: css.cx(clearButtonStyles(theme), className)
        },
        /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.title }, title),
        this.renderBarAndValue()
      );
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.wrapper, className }, title && /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.title }, title), this.renderBarAndValue());
  }
  renderBarAndValue() {
    switch (this.props.displayMode) {
      case "lcd":
        return this.renderRetroBars();
      case "basic":
      case "gradient":
      default:
        return this.renderBasicAndGradientBars();
    }
  }
  renderBasicAndGradientBars() {
    const { value, showUnfilled, valueDisplayMode } = this.props;
    const styles = getBasicAndGradientStyles(this.props);
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.wrapper }, valueDisplayMode !== schema.BarGaugeValueMode.Hidden && /* @__PURE__ */ React__default["default"].createElement(
      FormattedValueDisplay,
      {
        "data-testid": e2eSelectors.selectors.components.Panels.Visualization.BarGauge.valueV2,
        value,
        style: styles.value
      }
    ), showUnfilled && /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.emptyBar }), /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.bar }));
  }
  renderRetroBars() {
    var _a, _b;
    const {
      display,
      field,
      value,
      itemSpacing,
      alignmentFactors,
      orientation,
      lcdCellWidth,
      text,
      valueDisplayMode,
      theme
    } = this.props;
    const { valueHeight, valueWidth, maxBarHeight, maxBarWidth, wrapperWidth, wrapperHeight } = calculateBarAndValueDimensions(this.props);
    const minValue = (_a = field.min) != null ? _a : data.GAUGE_DEFAULT_MINIMUM;
    const maxValue = (_b = field.max) != null ? _b : data.GAUGE_DEFAULT_MAXIMUM;
    const isVert = isVertical(orientation);
    const valueRange = maxValue - minValue;
    const maxSize = isVert ? maxBarHeight : maxBarWidth;
    const cellSpacing = itemSpacing;
    const cellCount = Math.floor(maxSize / lcdCellWidth);
    const cellSize = Math.floor((maxSize - cellSpacing * cellCount) / cellCount);
    const valueColor = getTextValueColor(this.props);
    const valueToBaseSizeOn = alignmentFactors ? alignmentFactors : value;
    const valueStyles = getValueStyles(valueToBaseSizeOn, valueColor, valueWidth, valueHeight, orientation, text);
    const containerStyles = {
      width: `${wrapperWidth}px`,
      height: `${wrapperHeight}px`,
      display: "flex"
    };
    if (isVert) {
      containerStyles.flexDirection = "column-reverse";
      containerStyles.alignItems = "center";
    } else {
      containerStyles.flexDirection = "row";
      containerStyles.alignItems = "center";
      valueStyles.justifyContent = "flex-end";
    }
    const cells = [];
    for (let i = 0; i < cellCount; i++) {
      const currentValue = minValue + valueRange / cellCount * i;
      const cellColor = getCellColor(currentValue, value, display);
      const cellStyles = {
        borderRadius: theme.shape.radius.default
      };
      if (cellColor.isLit) {
        cellStyles.backgroundImage = `radial-gradient(${cellColor.background} 10%, ${cellColor.backgroundShade})`;
      } else {
        cellStyles.backgroundColor = cellColor.background;
      }
      if (isVert) {
        cellStyles.height = `${cellSize}px`;
        cellStyles.width = `${maxBarWidth}px`;
        cellStyles.marginTop = `${cellSpacing}px`;
      } else {
        cellStyles.width = `${cellSize}px`;
        cellStyles.height = `${maxBarHeight}px`;
        cellStyles.marginRight = `${cellSpacing}px`;
      }
      cells.push(/* @__PURE__ */ React__default["default"].createElement("div", { key: i.toString(), style: cellStyles }));
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: containerStyles }, cells, valueDisplayMode !== schema.BarGaugeValueMode.Hidden && /* @__PURE__ */ React__default["default"].createElement(
      FormattedValueDisplay,
      {
        "data-testid": e2eSelectors.selectors.components.Panels.Visualization.BarGauge.valueV2,
        value,
        style: valueStyles
      }
    ));
  }
}
BarGauge.defaultProps = {
  lcdCellWidth: 12,
  value: {
    text: "100",
    numeric: 100
  },
  displayMode: schema.BarGaugeDisplayMode.Gradient,
  orientation: data.VizOrientation.Horizontal,
  field: {
    min: 0,
    max: 100,
    thresholds: {
      mode: data.ThresholdsMode.Absolute,
      steps: []
    }
  },
  itemSpacing: 8,
  showUnfilled: true
};
function isVertical(orientation) {
  return orientation === data.VizOrientation.Vertical;
}
function calculateTitleDimensions(props) {
  var _a, _b;
  const { height, width, alignmentFactors, orientation, text } = props;
  const title = alignmentFactors ? alignmentFactors.title : props.value.title;
  if (!title) {
    return { fontSize: 0, width: 0, height: 0, placement: "above" };
  }
  if (isVertical(orientation)) {
    const fontSize = (_a = text == null ? void 0 : text.titleSize) != null ? _a : 14;
    return {
      fontSize,
      width,
      height: fontSize * TITLE_LINE_HEIGHT,
      placement: "below"
    };
  }
  if (height > 40) {
    if (text == null ? void 0 : text.titleSize) {
      return {
        fontSize: text == null ? void 0 : text.titleSize,
        width: 0,
        height: text.titleSize * TITLE_LINE_HEIGHT,
        placement: "above"
      };
    }
    const maxTitleHeightRatio2 = 0.45;
    const titleHeight2 = Math.max(Math.min(height * maxTitleHeightRatio2, MAX_VALUE_HEIGHT), 17);
    return {
      fontSize: titleHeight2 / TITLE_LINE_HEIGHT,
      width: 0,
      height: titleHeight2,
      placement: "above"
    };
  }
  const maxTitleHeightRatio = 0.6;
  const titleHeight = Math.max(height * maxTitleHeightRatio, MIN_VALUE_HEIGHT);
  const titleFontSize = titleHeight / TITLE_LINE_HEIGHT;
  const textSize = measureText(title, titleFontSize);
  const textWidth = Math.min(textSize.width + 15, width * 0.4);
  return {
    fontSize: (_b = text == null ? void 0 : text.titleSize) != null ? _b : titleFontSize,
    height: 0,
    width: textWidth,
    placement: "left"
  };
}
function getTitleStyles(props) {
  const wrapperStyles = {
    display: "flex",
    overflow: "hidden",
    width: "100%"
  };
  const titleDim = calculateTitleDimensions(props);
  const titleStyles = {
    fontSize: `${titleDim.fontSize}px`,
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    width: "100%",
    alignItems: "center",
    alignSelf: "center"
  };
  if (isVertical(props.orientation)) {
    wrapperStyles.flexDirection = "column-reverse";
    titleStyles.textAlign = "center";
  } else {
    if (titleDim.placement === "above") {
      wrapperStyles.flexDirection = "column";
    } else {
      wrapperStyles.flexDirection = "row";
      titleStyles.width = `${titleDim.width}px`;
      titleStyles.textAlign = "right";
      titleStyles.paddingRight = "10px";
    }
  }
  return {
    wrapper: wrapperStyles,
    title: titleStyles
  };
}
function calculateBarAndValueDimensions(props) {
  var _a;
  const { height, width, orientation, text, alignmentFactors, valueDisplayMode } = props;
  const titleDim = calculateTitleDimensions(props);
  const value = alignmentFactors != null ? alignmentFactors : props.value;
  const valueString = data.formattedValueToString(value);
  let maxBarHeight = 0;
  let maxBarWidth = 0;
  let valueHeight = 0;
  let valueWidth = 0;
  let wrapperWidth = 0;
  let wrapperHeight = 0;
  const fontSizeToMeasureWith = (_a = text == null ? void 0 : text.valueSize) != null ? _a : Math.max(titleDim.fontSize, 12);
  const realTextSize = measureText(valueString, fontSizeToMeasureWith);
  const realValueWidth = realTextSize.width + VALUE_LEFT_PADDING * 2;
  if (isVertical(orientation)) {
    if (text == null ? void 0 : text.valueSize) {
      valueHeight = text.valueSize * VALUE_LINE_HEIGHT;
    } else {
      valueHeight = Math.min(Math.max(height * 0.1, MIN_VALUE_HEIGHT), MAX_VALUE_HEIGHT);
    }
    valueWidth = width;
    if (valueDisplayMode === schema.BarGaugeValueMode.Hidden) {
      valueHeight = 0;
      valueWidth = 0;
    }
    maxBarHeight = height - (titleDim.height + valueHeight);
    maxBarWidth = width;
    wrapperWidth = width;
    wrapperHeight = height - titleDim.height;
  } else {
    if (valueDisplayMode === schema.BarGaugeValueMode.Hidden) {
      valueHeight = 0;
      valueWidth = 0;
    } else {
      valueHeight = height - titleDim.height;
      valueWidth = Math.max(Math.min(width * 0.2, MAX_VALUE_WIDTH), realValueWidth);
    }
    maxBarHeight = height - titleDim.height;
    maxBarWidth = width - valueWidth - titleDim.width;
    if (titleDim.placement === "above") {
      wrapperWidth = width;
      wrapperHeight = height - titleDim.height;
    } else {
      wrapperWidth = width - titleDim.width;
      wrapperHeight = height;
    }
  }
  return {
    valueWidth,
    valueHeight,
    maxBarWidth,
    maxBarHeight,
    wrapperHeight,
    wrapperWidth
  };
}
function getCellColor(positionValue, value, display) {
  if (positionValue === null) {
    return {
      background: data.FALLBACK_COLOR,
      border: data.FALLBACK_COLOR
    };
  }
  const color = display ? display(positionValue).color : null;
  if (color) {
    if (value === null || isNaN(value.numeric) || positionValue !== null && positionValue > value.numeric) {
      return {
        background: tinycolor__default["default"](color).setAlpha(0.18).toRgbString(),
        border: "transparent",
        isLit: false
      };
    } else {
      return {
        background: tinycolor__default["default"](color).setAlpha(0.95).toRgbString(),
        backgroundShade: tinycolor__default["default"](color).setAlpha(0.55).toRgbString(),
        border: tinycolor__default["default"](color).setAlpha(0.9).toRgbString(),
        isLit: true
      };
    }
  }
  return {
    background: data.FALLBACK_COLOR,
    border: data.FALLBACK_COLOR
  };
}
function getValuePercent(value, minValue, maxValue) {
  const valueRatio = Math.min((value - minValue) / (maxValue - minValue), 1);
  return isNaN(valueRatio) ? 0 : valueRatio;
}
function getBasicAndGradientStyles(props) {
  var _a, _b, _c;
  const { displayMode, field, value, alignmentFactors, orientation, theme, text } = props;
  const { valueWidth, valueHeight, maxBarHeight, maxBarWidth } = calculateBarAndValueDimensions(props);
  const minValue = (_a = field.min) != null ? _a : data.GAUGE_DEFAULT_MINIMUM;
  const maxValue = (_b = field.max) != null ? _b : data.GAUGE_DEFAULT_MAXIMUM;
  const valuePercent = getValuePercent(value.numeric, minValue, maxValue);
  const textColor = getTextValueColor(props);
  const barColor = (_c = value.color) != null ? _c : data.FALLBACK_COLOR;
  const valueToBaseSizeOn = alignmentFactors ? alignmentFactors : value;
  const valueStyles = getValueStyles(valueToBaseSizeOn, textColor, valueWidth, valueHeight, orientation, text);
  const isBasic = displayMode === "basic";
  const wrapperStyles = {
    display: "flex",
    flexGrow: 1
  };
  const barStyles = {
    borderRadius: theme.shape.radius.default,
    position: "relative",
    zIndex: 1
  };
  const emptyBar = {
    background: theme.colors.background.secondary,
    flexGrow: 1,
    display: "flex",
    borderRadius: theme.shape.radius.default,
    position: "relative"
  };
  if (isVertical(orientation)) {
    const barHeight = Math.max(valuePercent * maxBarHeight, 1);
    wrapperStyles.flexDirection = "column";
    wrapperStyles.justifyContent = "flex-end";
    barStyles.transition = "height 1s";
    barStyles.height = `${barHeight}px`;
    barStyles.width = `${maxBarWidth}px`;
    emptyBar.bottom = "-3px";
    emptyBar.width = `${valueWidth}px`;
    if (isBasic) {
      barStyles.background = `${tinycolor__default["default"](barColor).setAlpha(0.35).toRgbString()}`;
      barStyles.borderTop = `2px solid ${barColor}`;
    } else {
      barStyles.background = getBarGradient(props, maxBarHeight);
    }
  } else {
    const barWidth = Math.max(valuePercent * maxBarWidth, 1);
    wrapperStyles.flexDirection = "row-reverse";
    wrapperStyles.justifyContent = "flex-end";
    wrapperStyles.alignItems = "stretch";
    barStyles.transition = "width 1s";
    barStyles.height = `${maxBarHeight}px`;
    barStyles.width = `${barWidth}px`;
    emptyBar.left = "-3px";
    emptyBar.height = `${valueHeight}px`;
    if (isBasic) {
      barStyles.background = `${tinycolor__default["default"](barColor).setAlpha(0.35).toRgbString()}`;
      barStyles.borderRight = `2px solid ${barColor}`;
    } else {
      barStyles.background = getBarGradient(props, maxBarWidth);
    }
  }
  return {
    wrapper: wrapperStyles,
    bar: barStyles,
    value: valueStyles,
    emptyBar
  };
}
function getBarGradient(props, maxSize) {
  var _a, _b;
  const { field, value, orientation, theme } = props;
  const cssDirection = isVertical(orientation) ? "0deg" : "90deg";
  const minValue = field.min;
  const maxValue = field.max;
  let gradient = "";
  let lastpos = 0;
  let mode = data.getFieldColorMode((_a = field.color) == null ? void 0 : _a.mode);
  if (mode.id === data.FieldColorModeId.Thresholds) {
    const thresholds = field.thresholds;
    for (let i = 0; i < thresholds.steps.length; i++) {
      const threshold = thresholds.steps[i];
      const color = props.theme.visualization.getColorByName(threshold.color);
      const valuePercent = thresholds.mode === data.ThresholdsMode.Percentage ? threshold.value / 100 : getValuePercent(threshold.value, minValue, maxValue);
      const pos = valuePercent * maxSize;
      const offset = Math.round(pos - (pos - lastpos) / 2);
      const thresholdValue = thresholds.mode === data.ThresholdsMode.Percentage ? minValue + (maxValue - minValue) * valuePercent : threshold.value;
      if (gradient === "") {
        gradient = `linear-gradient(${cssDirection}, ${color}, ${color}`;
      } else if (value.numeric < thresholdValue) {
        break;
      } else {
        lastpos = pos;
        gradient += ` ${offset}px, ${color}`;
      }
    }
    return gradient + ")";
  }
  if (mode.isContinuous && mode.getColors) {
    const scheme = mode.getColors(theme);
    for (let i = 0; i < scheme.length; i++) {
      const color = scheme[i];
      if (gradient === "") {
        gradient = `linear-gradient(${cssDirection}, ${color} 0px`;
      } else {
        const valuePercent = i / (scheme.length - 1);
        const pos = valuePercent * maxSize;
        gradient += `, ${color} ${pos}px`;
      }
    }
    return gradient + ")";
  }
  return (_b = value.color) != null ? _b : data.FALLBACK_COLOR;
}
function getTextValueColor(props) {
  if (props.valueDisplayMode === "text") {
    return props.theme.colors.text.primary;
  }
  const { value } = props;
  if (value.color) {
    return value.color;
  }
  return data.FALLBACK_COLOR;
}
function getValueStyles(value, color, width, height, orientation, text) {
  var _a, _b;
  const styles = {
    color,
    height: `${height}px`,
    width: `${width}px`,
    display: "flex",
    alignItems: "center",
    lineHeight: VALUE_LINE_HEIGHT
  };
  let textWidth = width;
  const formattedValueString = data.formattedValueToString(value);
  if (isVertical(orientation)) {
    styles.fontSize = (_a = text == null ? void 0 : text.valueSize) != null ? _a : calculateFontSize(formattedValueString, textWidth, height, VALUE_LINE_HEIGHT);
    styles.justifyContent = `center`;
  } else {
    styles.fontSize = (_b = text == null ? void 0 : text.valueSize) != null ? _b : calculateFontSize(formattedValueString, textWidth - VALUE_LEFT_PADDING * 2, height, VALUE_LINE_HEIGHT);
    styles.justifyContent = `flex-end`;
    styles.paddingLeft = `${VALUE_LEFT_PADDING}px`;
    styles.paddingRight = `${VALUE_LEFT_PADDING}px`;
    textWidth -= VALUE_LEFT_PADDING;
  }
  return styles;
}

const ContextMenu = React__default["default"].memo(
  ({ x, y, onClose, focusOnOpen = true, renderMenuItems, renderHeader }) => {
    const menuRef = React.useRef(null);
    const [positionStyles, setPositionStyles] = React.useState({});
    React.useLayoutEffect(() => {
      const menuElement = menuRef.current;
      if (menuElement) {
        const rect = menuElement.getBoundingClientRect();
        const OFFSET = 5;
        const collisions = {
          right: window.innerWidth < x + rect.width,
          bottom: window.innerHeight < y + rect.height + OFFSET
        };
        setPositionStyles({
          position: "fixed",
          left: collisions.right ? x - rect.width - OFFSET : x - OFFSET,
          top: collisions.bottom ? y - rect.height - OFFSET : y + OFFSET
        });
      }
    }, [x, y]);
    reactUse.useClickAway(menuRef, () => {
      onClose == null ? void 0 : onClose();
    });
    const header = renderHeader == null ? void 0 : renderHeader();
    const menuItems = renderMenuItems == null ? void 0 : renderMenuItems();
    const onOpen = (setFocusedItem) => {
      if (focusOnOpen) {
        setFocusedItem(0);
      }
    };
    const onKeyDown = (e) => {
      if (e.key === "Escape") {
        e.preventDefault();
        e.stopPropagation();
        onClose == null ? void 0 : onClose();
      }
    };
    return /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(
      Menu,
      {
        header,
        ref: menuRef,
        style: positionStyles,
        ariaLabel: e2eSelectors.selectors.components.Menu.MenuComponent("Context"),
        onOpen,
        onClick: onClose,
        onKeyDown
      },
      menuItems
    ));
  }
);
ContextMenu.displayName = "ContextMenu";

const WithContextMenu = ({ children, renderMenuItems, focusOnOpen = true }) => {
  const [isMenuOpen, setIsMenuOpen] = React.useState(false);
  const [menuPosition, setMenuPosition] = React.useState({ x: 0, y: 0 });
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, children({
    openMenu: (e) => {
      setIsMenuOpen(true);
      setMenuPosition({
        x: e.pageX,
        y: e.pageY
      });
    }
  }), isMenuOpen && /* @__PURE__ */ React__default["default"].createElement(
    ContextMenu,
    {
      onClose: () => setIsMenuOpen(false),
      x: menuPosition.x,
      y: menuPosition.y,
      renderMenuItems,
      focusOnOpen
    }
  ));
};

var __defProp$1u = Object.defineProperty;
var __defProps$12 = Object.defineProperties;
var __getOwnPropDescs$12 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1v = Object.getOwnPropertySymbols;
var __hasOwnProp$1v = Object.prototype.hasOwnProperty;
var __propIsEnum$1v = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1u = (obj, key, value) => key in obj ? __defProp$1u(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1u = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1v.call(b, prop))
      __defNormalProp$1u(a, prop, b[prop]);
  if (__getOwnPropSymbols$1v)
    for (var prop of __getOwnPropSymbols$1v(b)) {
      if (__propIsEnum$1v.call(b, prop))
        __defNormalProp$1u(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$12 = (a, b) => __defProps$12(a, __getOwnPropDescs$12(b));
const DataLinksContextMenu = ({ children, links, style }) => {
  const itemsGroup = [{ items: linkModelToContextMenuItems(links), label: "Data links" }];
  const linksCounter = itemsGroup[0].items.length;
  const renderMenuGroupItems = () => {
    return itemsGroup.map((group, index) => /* @__PURE__ */ React__default["default"].createElement(MenuGroup, { key: `${group.label}${index}`, label: group.label }, (group.items || []).map((item) => /* @__PURE__ */ React__default["default"].createElement(
      MenuItem,
      {
        key: item.label,
        url: item.url,
        label: item.label,
        target: item.target,
        icon: item.icon,
        active: item.active,
        onClick: item.onClick
      }
    ))));
  };
  const targetClassName = css.css`
    cursor: context-menu;
  `;
  if (linksCounter > 1) {
    return /* @__PURE__ */ React__default["default"].createElement(WithContextMenu, { renderMenuItems: renderMenuGroupItems }, ({ openMenu }) => {
      return children({ openMenu, targetClassName });
    });
  } else {
    const linkModel = links()[0];
    return /* @__PURE__ */ React__default["default"].createElement(
      "a",
      {
        href: linkModel.href,
        onClick: linkModel.onClick,
        target: linkModel.target,
        title: linkModel.title,
        style: __spreadProps$12(__spreadValues$1u({}, style), { overflow: "hidden", display: "flex" }),
        "aria-label": e2eSelectors.selectors.components.DataLinksContextMenu.singleLink
      },
      children({})
    );
  }
};

const FILTER_FOR_OPERATOR = "=";
const FILTER_OUT_OPERATOR = "!=";

var __defProp$1t = Object.defineProperty;
var __defProps$11 = Object.defineProperties;
var __getOwnPropDescs$11 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1u = Object.getOwnPropertySymbols;
var __hasOwnProp$1u = Object.prototype.hasOwnProperty;
var __propIsEnum$1u = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1t = (obj, key, value) => key in obj ? __defProp$1t(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1t = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1u.call(b, prop))
      __defNormalProp$1t(a, prop, b[prop]);
  if (__getOwnPropSymbols$1u)
    for (var prop of __getOwnPropSymbols$1u(b)) {
      if (__propIsEnum$1u.call(b, prop))
        __defNormalProp$1t(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$11 = (a, b) => __defProps$11(a, __getOwnPropDescs$11(b));
const defaultScale = {
  mode: data.ThresholdsMode.Absolute,
  steps: [
    {
      color: "blue",
      value: -Infinity
    },
    {
      color: "green",
      value: 20
    }
  ]
};
const BarGaugeCell = (props) => {
  var _a;
  const { field, innerWidth, tableStyles, cell, cellProps, row } = props;
  const displayValue = field.display(cell.value);
  const cellOptions = getCellOptions(field);
  let config = data.getFieldConfigWithMinMax(field, false);
  if (!config.thresholds) {
    config = __spreadProps$11(__spreadValues$1t({}, config), {
      thresholds: defaultScale
    });
  }
  let barGaugeMode = schema.BarGaugeDisplayMode.Gradient;
  let valueDisplayMode = void 0;
  if (cellOptions.type === schema.TableCellDisplayMode.Gauge) {
    barGaugeMode = (_a = cellOptions.mode) != null ? _a : schema.BarGaugeDisplayMode.Gradient;
    valueDisplayMode = cellOptions.valueDisplayMode !== void 0 ? cellOptions.valueDisplayMode : schema.BarGaugeValueMode.Text;
  }
  const getLinks = () => {
    if (!lodash.isFunction(field.getLinks)) {
      return [];
    }
    return field.getLinks({ valueRowIndex: row.index });
  };
  const hasLinks = Boolean(getLinks().length);
  const alignmentFactors = getAlignmentFactor(field, displayValue, cell.row.index);
  const renderComponent = (menuProps) => {
    const { openMenu, targetClassName } = menuProps;
    return /* @__PURE__ */ React__default["default"].createElement(
      BarGauge,
      {
        width: innerWidth,
        height: tableStyles.cellHeightInner,
        field: config,
        display: field.display,
        text: { valueSize: 14 },
        value: displayValue,
        orientation: data.VizOrientation.Horizontal,
        theme: tableStyles.theme,
        alignmentFactors,
        onClick: openMenu,
        className: targetClassName,
        itemSpacing: 1,
        lcdCellWidth: 8,
        displayMode: barGaugeMode,
        valueDisplayMode
      }
    );
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$11(__spreadValues$1t({}, cellProps), { className: tableStyles.cellContainer }), hasLinks && /* @__PURE__ */ React__default["default"].createElement(DataLinksContextMenu, { links: getLinks, style: { display: "flex", width: "100%" } }, (api) => renderComponent(api)), !hasLinks && renderComponent({}));
};
function getAlignmentFactor(field, displayValue, rowIndex) {
  var _a;
  let alignmentFactor = (_a = field.state) == null ? void 0 : _a.alignmentFactors;
  if (alignmentFactor) {
    if (alignmentFactor.text.length < displayValue.text.length) {
      alignmentFactor.text = displayValue.text;
    }
    return alignmentFactor;
  } else {
    alignmentFactor = __spreadValues$1t({}, displayValue);
    const maxIndex = Math.min(field.values.length, rowIndex + 1e3);
    for (let i = rowIndex + 1; i < maxIndex; i++) {
      const nextDisplayValue = field.display(field.values.get(i));
      if (nextDisplayValue.text.length > alignmentFactor.text.length) {
        alignmentFactor.text = displayValue.text;
      }
    }
    if (field.state) {
      field.state.alignmentFactors = alignmentFactor;
    } else {
      field.state = { alignmentFactors: alignmentFactor };
    }
    return alignmentFactor;
  }
}

function TableCellInspectModal({ value, onDismiss, mode }) {
  let displayValue = value;
  if (lodash.isString(value)) {
    try {
      value = JSON.parse(value);
    } catch (e) {
    }
  } else {
    displayValue = JSON.stringify(value, null, " ");
  }
  let text = displayValue;
  if (mode === "code") {
    text = JSON.stringify(value, null, " ");
  }
  return /* @__PURE__ */ React__default["default"].createElement(Modal, { onDismiss, isOpen: true, title: "Inspect value" }, mode === "code" ? /* @__PURE__ */ React__default["default"].createElement(
    CodeEditor,
    {
      width: "100%",
      height: 500,
      language: "json",
      showLineNumbers: true,
      showMiniMap: (text && text.length) > 100,
      value: text,
      readOnly: true
    }
  ) : /* @__PURE__ */ React__default["default"].createElement("pre", null, text), /* @__PURE__ */ React__default["default"].createElement(Modal.ButtonRow, null, /* @__PURE__ */ React__default["default"].createElement(ClipboardButton, { icon: "copy", getText: () => text }, "Copy to Clipboard")));
}

var __defProp$1s = Object.defineProperty;
var __getOwnPropSymbols$1t = Object.getOwnPropertySymbols;
var __hasOwnProp$1t = Object.prototype.hasOwnProperty;
var __propIsEnum$1t = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1s = (obj, key, value) => key in obj ? __defProp$1s(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1s = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1t.call(b, prop))
      __defNormalProp$1s(a, prop, b[prop]);
  if (__getOwnPropSymbols$1t)
    for (var prop of __getOwnPropSymbols$1t(b)) {
      if (__propIsEnum$1t.call(b, prop))
        __defNormalProp$1s(a, prop, b[prop]);
    }
  return a;
};
function CellActions({ field, cell, previewMode, showFilters, onCellFilterAdded }) {
  var _a;
  const [isInspecting, setIsInspecting] = React.useState(false);
  const isRightAligned = getTextAlign(field) === "flex-end";
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const commonButtonProps = {
    size: "sm",
    tooltipPlacement: "top"
  };
  const onFilterFor = React.useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_FOR_OPERATOR, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  const onFilterOut = React.useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_OUT_OPERATOR, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: `cellActions ${isRightAligned ? "cellActionsLeft" : ""}` }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { spacing: "xs" }, inspectEnabled && /* @__PURE__ */ React__default["default"].createElement(
    IconButton,
    __spreadValues$1s({
      name: "eye",
      tooltip: "Inspect value",
      onClick: () => {
        setIsInspecting(true);
      }
    }, commonButtonProps)
  ), showFilters && /* @__PURE__ */ React__default["default"].createElement(IconButton, __spreadValues$1s({ name: "search-plus", onClick: onFilterFor, tooltip: "Filter for value" }, commonButtonProps)), showFilters && /* @__PURE__ */ React__default["default"].createElement(IconButton, __spreadValues$1s({ name: "search-minus", onClick: onFilterOut, tooltip: "Filter out value" }, commonButtonProps)))), isInspecting && /* @__PURE__ */ React__default["default"].createElement(
    TableCellInspectModal,
    {
      mode: previewMode,
      value: cell.value,
      onDismiss: () => {
        setIsInspecting(false);
      }
    }
  ));
}

var __defProp$1r = Object.defineProperty;
var __defProps$10 = Object.defineProperties;
var __getOwnPropDescs$10 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1s = Object.getOwnPropertySymbols;
var __hasOwnProp$1s = Object.prototype.hasOwnProperty;
var __propIsEnum$1s = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1r = (obj, key, value) => key in obj ? __defProp$1r(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1r = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1s.call(b, prop))
      __defNormalProp$1r(a, prop, b[prop]);
  if (__getOwnPropSymbols$1s)
    for (var prop of __getOwnPropSymbols$1s(b)) {
      if (__propIsEnum$1s.call(b, prop))
        __defNormalProp$1r(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$10 = (a, b) => __defProps$10(a, __getOwnPropDescs$10(b));
const DefaultCell = (props) => {
  var _a, _b;
  const { field, cell, tableStyles, row, cellProps } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const displayValue = field.display(cell.value);
  let value;
  if (React__default["default"].isValidElement(cell.value)) {
    value = cell.value;
  } else {
    value = data.formattedValueToString(displayValue);
  }
  const showFilters = props.onCellFilterAdded && field.config.filterable;
  const showActions = showFilters && cell.value !== void 0 || inspectEnabled;
  const cellOptions = getCellOptions(field);
  const cellStyle = getCellStyle(tableStyles, cellOptions, displayValue, inspectEnabled);
  const hasLinks = Boolean((_b = getCellLinks(field, row)) == null ? void 0 : _b.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$10(__spreadValues$1r({}, cellProps), { className: cellStyle }), !hasLinks && /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.cellText }, value), hasLinks && /* @__PURE__ */ React__default["default"].createElement(DataLinksContextMenu, { links: () => getCellLinks(field, row) || [] }, (api) => {
    if (api.openMenu) {
      return /* @__PURE__ */ React__default["default"].createElement(
        "button",
        {
          className: css.cx(clearButtonStyle, getLinkStyle(tableStyles, cellOptions, api.targetClassName)),
          onClick: api.openMenu
        },
        value
      );
    } else {
      return /* @__PURE__ */ React__default["default"].createElement("div", { className: getLinkStyle(tableStyles, cellOptions, api.targetClassName) }, value);
    }
  }), showActions && /* @__PURE__ */ React__default["default"].createElement(CellActions, __spreadProps$10(__spreadValues$1r({}, props), { previewMode: "text", showFilters })));
};
function getCellStyle(tableStyles, cellOptions, displayValue, disableOverflowOnHover = false) {
  var _a;
  const darkeningFactor = tableStyles.theme.isDark ? 1 : -0.7;
  let textColor = void 0;
  let bgColor = void 0;
  if (cellOptions.type === schema.TableCellDisplayMode.ColorText) {
    textColor = displayValue.color;
  } else if (cellOptions.type === schema.TableCellDisplayMode.ColorBackground) {
    const mode = (_a = cellOptions.mode) != null ? _a : schema.TableCellBackgroundDisplayMode.Gradient;
    if (mode === schema.TableCellBackgroundDisplayMode.Basic) {
      textColor = getTextColorForAlphaBackground(displayValue.color, tableStyles.theme.isDark);
      bgColor = tinycolor__default["default"](displayValue.color).toRgbString();
    } else if (mode === schema.TableCellBackgroundDisplayMode.Gradient) {
      const bgColor2 = tinycolor__default["default"](displayValue.color).darken(10 * darkeningFactor).spin(5);
      textColor = getTextColorForAlphaBackground(displayValue.color, tableStyles.theme.isDark);
      bgColor = `linear-gradient(120deg, ${bgColor2.toRgbString()}, ${displayValue.color})`;
    }
  }
  if (textColor !== void 0 || bgColor !== void 0) {
    return tableStyles.buildCellContainerStyle(textColor, bgColor, !disableOverflowOnHover);
  }
  return disableOverflowOnHover ? tableStyles.cellContainerNoOverflow : tableStyles.cellContainer;
}
function getLinkStyle(tableStyles, cellOptions, targetClassName) {
  if (cellOptions.type === schema.TableCellDisplayMode.Auto) {
    return css.cx(tableStyles.cellLink, targetClassName);
  }
  return css.cx(tableStyles.cellLinkForColoredCell, targetClassName);
}

var __defProp$1q = Object.defineProperty;
var __defProps$$ = Object.defineProperties;
var __getOwnPropDescs$$ = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1r = Object.getOwnPropertySymbols;
var __hasOwnProp$1r = Object.prototype.hasOwnProperty;
var __propIsEnum$1r = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1q = (obj, key, value) => key in obj ? __defProp$1q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1q = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1r.call(b, prop))
      __defNormalProp$1q(a, prop, b[prop]);
  if (__getOwnPropSymbols$1r)
    for (var prop of __getOwnPropSymbols$1r(b)) {
      if (__propIsEnum$1r.call(b, prop))
        __defNormalProp$1q(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$$ = (a, b) => __defProps$$(a, __getOwnPropDescs$$(b));
function GeoCell(props) {
  const { cell, tableStyles, cellProps } = props;
  let disp = "";
  if (cell.value instanceof geom.Geometry) {
    disp = new WKT__default["default"]().writeGeometry(cell.value, {
      featureProjection: "EPSG:3857",
      dataProjection: "EPSG:4326"
    });
  } else if (cell.value != null) {
    disp = `${cell.value}`;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$$(__spreadValues$1q({}, cellProps), { className: tableStyles.cellContainer }), /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.cellText, style: { fontFamily: "monospace" } }, disp));
}

var __defProp$1p = Object.defineProperty;
var __defProps$_ = Object.defineProperties;
var __getOwnPropDescs$_ = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1q = Object.getOwnPropertySymbols;
var __hasOwnProp$1q = Object.prototype.hasOwnProperty;
var __propIsEnum$1q = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1p = (obj, key, value) => key in obj ? __defProp$1p(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1p = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1q.call(b, prop))
      __defNormalProp$1p(a, prop, b[prop]);
  if (__getOwnPropSymbols$1q)
    for (var prop of __getOwnPropSymbols$1q(b)) {
      if (__propIsEnum$1q.call(b, prop))
        __defNormalProp$1p(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$_ = (a, b) => __defProps$_(a, __getOwnPropDescs$_(b));
const ImageCell = (props) => {
  var _a;
  const { field, cell, tableStyles, row, cellProps } = props;
  const displayValue = field.display(cell.value);
  const hasLinks = Boolean((_a = getCellLinks(field, row)) == null ? void 0 : _a.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$_(__spreadValues$1p({}, cellProps), { className: tableStyles.cellContainer }), !hasLinks && /* @__PURE__ */ React__default["default"].createElement("img", { src: displayValue.text, className: tableStyles.imageCell, alt: "" }), hasLinks && /* @__PURE__ */ React__default["default"].createElement(DataLinksContextMenu, { style: { height: "100%" }, links: () => getCellLinks(field, row) || [] }, (api) => {
    const img = /* @__PURE__ */ React__default["default"].createElement("img", { src: displayValue.text, className: tableStyles.imageCell, alt: "" });
    if (api.openMenu) {
      return /* @__PURE__ */ React__default["default"].createElement(Button, { className: css.cx(clearButtonStyle), onClick: api.openMenu }, img);
    } else {
      return img;
    }
  }));
};

var __defProp$1o = Object.defineProperty;
var __defProps$Z = Object.defineProperties;
var __getOwnPropDescs$Z = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1p = Object.getOwnPropertySymbols;
var __hasOwnProp$1p = Object.prototype.hasOwnProperty;
var __propIsEnum$1p = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1o = (obj, key, value) => key in obj ? __defProp$1o(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1o = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1p.call(b, prop))
      __defNormalProp$1o(a, prop, b[prop]);
  if (__getOwnPropSymbols$1p)
    for (var prop of __getOwnPropSymbols$1p(b)) {
      if (__propIsEnum$1p.call(b, prop))
        __defNormalProp$1o(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$Z = (a, b) => __defProps$Z(a, __getOwnPropDescs$Z(b));
function JSONViewCell(props) {
  var _a, _b;
  const { cell, tableStyles, cellProps, field, row } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const txt = css.css`
    cursor: pointer;
    font-family: monospace;
  `;
  let value = cell.value;
  let displayValue = value;
  if (lodash.isString(value)) {
    try {
      value = JSON.parse(value);
    } catch (e) {
    }
  } else {
    displayValue = JSON.stringify(value, null, " ");
  }
  const hasLinks = Boolean((_b = getCellLinks(field, row)) == null ? void 0 : _b.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$Z(__spreadValues$1o({}, cellProps), { className: inspectEnabled ? tableStyles.cellContainerNoOverflow : tableStyles.cellContainer }), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(tableStyles.cellText, txt) }, !hasLinks && /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.cellText }, displayValue), hasLinks && /* @__PURE__ */ React__default["default"].createElement(DataLinksContextMenu, { links: () => getCellLinks(field, row) || [] }, (api) => {
    if (api.openMenu) {
      return /* @__PURE__ */ React__default["default"].createElement(Button, { className: css.cx(clearButtonStyle), onClick: api.openMenu }, displayValue);
    } else {
      return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, displayValue);
    }
  })), inspectEnabled && /* @__PURE__ */ React__default["default"].createElement(CellActions, __spreadProps$Z(__spreadValues$1o({}, props), { previewMode: "code" })));
}

var __defProp$1n = Object.defineProperty;
var __getOwnPropSymbols$1o = Object.getOwnPropertySymbols;
var __hasOwnProp$1o = Object.prototype.hasOwnProperty;
var __propIsEnum$1o = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1n = (obj, key, value) => key in obj ? __defProp$1n(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1n = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1o.call(b, prop))
      __defNormalProp$1n(a, prop, b[prop]);
  if (__getOwnPropSymbols$1o)
    for (var prop of __getOwnPropSymbols$1o(b)) {
      if (__propIsEnum$1o.call(b, prop))
        __defNormalProp$1n(a, prop, b[prop]);
    }
  return a;
};
function RowExpander({ row, tableStyles }) {
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1n({ className: tableStyles.expanderCell }, row.getToggleRowExpandedProps()), /* @__PURE__ */ React__default["default"].createElement(
    Icon,
    {
      "aria-label": row.isExpanded ? "Collapse row" : "Expand row",
      name: row.isExpanded ? "angle-down" : "angle-right",
      size: "xl"
    }
  ));
}

const PanelContextRoot = React__default["default"].createContext({
  eventBus: new data.EventBusSrv()
});
const PanelContextProvider = PanelContextRoot.Provider;
const usePanelContext = () => React__default["default"].useContext(PanelContextRoot);

const VizLayout = ({ width, height, legend, children }) => {
  const styles = useStyles2(getVizStyles);
  const containerStyle = {
    display: "flex",
    width: `${width}px`,
    height: `${height}px`
  };
  const [legendRef, legendMeasure] = reactUse.useMeasure();
  if (!legend) {
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { tabIndex: 0, style: containerStyle, className: styles.viz }, children(width, height)));
  }
  const { placement, maxHeight = "35%", maxWidth = "60%" } = legend.props;
  let size = null;
  const legendStyle = {};
  switch (placement) {
    case "bottom":
      containerStyle.flexDirection = "column";
      legendStyle.maxHeight = maxHeight;
      if (legendMeasure) {
        size = { width, height: height - legendMeasure.height };
      }
      break;
    case "right":
      containerStyle.flexDirection = "row";
      legendStyle.maxWidth = maxWidth;
      if (legendMeasure) {
        size = { width: width - legendMeasure.width, height };
      }
      if (legend.props.width) {
        legendStyle.width = legend.props.width;
        size = { width: width - legend.props.width, height };
      }
      break;
  }
  if ((size == null ? void 0 : size.width) === 0) {
    size.width = width;
  }
  if ((size == null ? void 0 : size.height) === 0) {
    size.height = height;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", { style: containerStyle }, /* @__PURE__ */ React__default["default"].createElement("div", { tabIndex: 0, className: styles.viz }, size && children(size.width, size.height)), /* @__PURE__ */ React__default["default"].createElement("div", { style: legendStyle, ref: legendRef }, /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { hideHorizontalTrack: true }, legend)));
};
const getVizStyles = (theme) => {
  return {
    viz: css.css({
      flexGrow: 2,
      borderRadius: theme.shape.borderRadius(1),
      "&:focus-visible": getFocusStyles(theme)
    })
  };
};
const VizLayoutLegend = ({ children }) => {
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, children);
};
VizLayout.Legend = VizLayoutLegend;

const FIXED_UNIT = "__fixed";
function sameProps(prevProps, nextProps, propsToDiff = []) {
  for (const propName of propsToDiff) {
    if (typeof propName === "function") {
      if (!propName(prevProps, nextProps)) {
        return false;
      }
    } else if (nextProps[propName] !== prevProps[propName]) {
      return false;
    }
  }
  return true;
}
class GraphNG extends React.Component {
  constructor(props) {
    super(props);
    this.panelContext = {};
    this.subscription = new rxjs.Subscription();
    this.getTimeRange = () => this.props.timeRange;
    let state = this.prepState(props);
    state.alignedData = state.config.prepData([state.alignedFrame]);
    this.state = state;
    this.plotInstance = React__default["default"].createRef();
  }
  prepState(props, withConfig = true) {
    var _a;
    let state = null;
    const { frames, fields, preparePlotFrame } = props;
    const preparePlotFrameFn = preparePlotFrame || preparePlotFrame$1;
    const alignedFrame = preparePlotFrameFn(
      frames,
      fields || {
        x: data.fieldMatchers.get(data.FieldMatcherID.firstTimeField).get({}),
        y: data.fieldMatchers.get(data.FieldMatcherID.numeric).get({})
      },
      props.timeRange
    );
    pluginLog("GraphNG", false, "data aligned", alignedFrame);
    if (alignedFrame) {
      let config = (_a = this.state) == null ? void 0 : _a.config;
      if (withConfig) {
        config = props.prepConfig(alignedFrame, this.props.frames, this.getTimeRange);
        pluginLog("GraphNG", false, "config prepared", config);
      }
      state = {
        alignedFrame,
        config
      };
      pluginLog("GraphNG", false, "data prepared", state.alignedData);
    }
    return state;
  }
  handleCursorUpdate(evt) {
    var _a, _b;
    const time = (_b = (_a = evt.payload) == null ? void 0 : _a.point) == null ? void 0 : _b.time;
    const u = this.plotInstance.current;
    if (u && time) {
      const left = u.valToPos(time, "x");
      let top;
      if (left) {
        top = findMidPointYPosition(u, u.posToIdx(left));
      }
      if (!top || !left) {
        return;
      }
      u.setCursor({
        left,
        top
      });
    }
  }
  componentDidMount() {
    this.panelContext = this.context;
    const { eventBus } = this.panelContext;
    this.subscription.add(
      eventBus.getStream(data.DataHoverEvent).pipe(operators.throttleTime(50)).subscribe({
        next: (evt) => {
          if (eventBus === evt.origin) {
            return;
          }
          this.handleCursorUpdate(evt);
        }
      })
    );
    this.subscription.add(
      eventBus.getStream(data.LegacyGraphHoverEvent).pipe(operators.throttleTime(50)).subscribe({
        next: (evt) => this.handleCursorUpdate(evt)
      })
    );
    this.subscription.add(
      eventBus.getStream(data.DataHoverClearEvent).pipe(operators.throttleTime(50)).subscribe({
        next: () => {
          var _a;
          const u = (_a = this.plotInstance) == null ? void 0 : _a.current;
          if (u) {
            u.setCursor({
              left: -10,
              top: -10
            });
          }
        }
      })
    );
  }
  componentDidUpdate(prevProps) {
    const { frames, structureRev, timeZone, propsToDiff } = this.props;
    const propsChanged = !sameProps(prevProps, this.props, propsToDiff);
    if (frames !== prevProps.frames || propsChanged || timeZone !== prevProps.timeZone) {
      let newState = this.prepState(this.props, false);
      if (newState) {
        const shouldReconfig = this.state.config === void 0 || timeZone !== prevProps.timeZone || structureRev !== prevProps.structureRev || !structureRev || propsChanged;
        if (shouldReconfig) {
          newState.config = this.props.prepConfig(newState.alignedFrame, this.props.frames, this.getTimeRange);
          pluginLog("GraphNG", false, "config recreated", newState.config);
        }
        newState.alignedData = newState.config.prepData([newState.alignedFrame]);
        this.setState(newState);
      }
    }
  }
  componentWillUnmount() {
    this.subscription.unsubscribe();
  }
  render() {
    const { width, height, children, timeRange, renderLegend } = this.props;
    const { config, alignedFrame, alignedData } = this.state;
    if (!config) {
      return null;
    }
    return /* @__PURE__ */ React__default["default"].createElement(VizLayout, { width, height, legend: renderLegend(config) }, (vizWidth, vizHeight) => /* @__PURE__ */ React__default["default"].createElement(
      UPlotChart,
      {
        config,
        data: alignedData,
        width: vizWidth,
        height: vizHeight,
        timeRange,
        plotRef: (u) => this.plotInstance.current = u
      },
      children ? children(config, alignedFrame) : null
    ));
  }
}
GraphNG.contextType = PanelContextRoot;

var __defProp$1m = Object.defineProperty;
var __defProps$Y = Object.defineProperties;
var __getOwnPropDescs$Y = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1n = Object.getOwnPropertySymbols;
var __hasOwnProp$1n = Object.prototype.hasOwnProperty;
var __propIsEnum$1n = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1m = (obj, key, value) => key in obj ? __defProp$1m(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1m = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1n.call(b, prop))
      __defNormalProp$1m(a, prop, b[prop]);
  if (__getOwnPropSymbols$1n)
    for (var prop of __getOwnPropSymbols$1n(b)) {
      if (__propIsEnum$1n.call(b, prop))
        __defNormalProp$1m(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$Y = (a, b) => __defProps$Y(a, __getOwnPropDescs$Y(b));
const INSERT_MODES = {
  threshold: (prev, next, threshold) => prev + threshold,
  midpoint: (prev, next, threshold) => (prev + next) / 2,
  // previous time + 1ms to prevent StateTimeline from forward-interpolating prior state
  plusone: (prev, next, threshold) => prev + 1
};
function applyNullInsertThreshold(opts) {
  if (opts.frame.length === 0) {
    return opts.frame;
  }
  let thorough = true;
  let { frame, refFieldName, refFieldPseudoMax, refFieldPseudoMin, insertMode } = opts;
  if (!insertMode) {
    insertMode = INSERT_MODES.threshold;
  }
  const refField = frame.fields.find((field) => {
    return refFieldName != null ? field.name === refFieldName : field.type === data.FieldType.time;
  });
  if (refField == null) {
    return frame;
  }
  refField.state = __spreadProps$Y(__spreadValues$1m({}, refField.state), {
    nullThresholdApplied: true
  });
  const thresholds = frame.fields.map((field) => {
    var _a, _b, _c;
    return (_c = (_b = (_a = field.config.custom) == null ? void 0 : _a.insertNulls) != null ? _b : refField.config.interval) != null ? _c : null;
  });
  const uniqueThresholds = new Set(thresholds);
  uniqueThresholds.delete(null);
  if (uniqueThresholds.size === 0) {
    return frame;
  }
  if (uniqueThresholds.size === 1) {
    const threshold = uniqueThresholds.values().next().value;
    if (threshold <= 0) {
      return frame;
    }
    const refValues = refField.values.toArray();
    const frameValues = frame.fields.map((field) => field.values.toArray());
    const filledFieldValues = nullInsertThreshold(
      refValues,
      frameValues,
      threshold,
      refFieldPseudoMin,
      refFieldPseudoMax,
      insertMode,
      thorough
    );
    if (filledFieldValues === frameValues) {
      return frame;
    }
    return __spreadProps$Y(__spreadValues$1m({}, frame), {
      length: filledFieldValues[0].length,
      fields: frame.fields.map((field, i) => __spreadProps$Y(__spreadValues$1m({}, field), {
        values: new data.ArrayVector(filledFieldValues[i])
      }))
    });
  }
  return frame;
}
function nullInsertThreshold(refValues, frameValues, threshold, refFieldPseudoMin = null, refFieldPseudoMax = null, getInsertValue, thorough) {
  const len = refValues.length;
  const refValuesNew = [];
  if (refFieldPseudoMin != null && refFieldPseudoMin < refValues[0]) {
    let preFillCount = Math.ceil((refValues[0] - refFieldPseudoMin) / threshold);
    let prevSlot = refValues[0] - preFillCount * threshold;
    while (prevSlot < refValues[0]) {
      refValuesNew.push(getInsertValue(prevSlot - threshold, prevSlot, threshold));
      prevSlot += threshold;
    }
  }
  refValuesNew.push(refValues[0]);
  let prevValue = refValues[0];
  for (let i = 1; i < len; i++) {
    const curValue = refValues[i];
    while (curValue - prevValue > threshold) {
      refValuesNew.push(getInsertValue(prevValue, curValue, threshold));
      prevValue += threshold;
      if (!thorough) {
        break;
      }
    }
    refValuesNew.push(curValue);
    prevValue = curValue;
  }
  if (refFieldPseudoMax != null && refFieldPseudoMax > prevValue) {
    while (prevValue + threshold < refFieldPseudoMax) {
      refValuesNew.push(getInsertValue(prevValue, refFieldPseudoMax, threshold));
      prevValue += threshold;
    }
  }
  const filledLen = refValuesNew.length;
  if (filledLen === len) {
    return frameValues;
  }
  const filledFieldValues = [];
  for (let fieldValues of frameValues) {
    let filledValues;
    if (fieldValues !== refValues) {
      filledValues = Array(filledLen);
      for (let i = 0, j = 0; i < filledLen; i++) {
        filledValues[i] = refValues[j] === refValuesNew[i] ? fieldValues[j++] : null;
      }
    } else {
      filledValues = refValuesNew;
    }
    filledFieldValues.push(filledValues);
  }
  return filledFieldValues;
}

function nullToUndefThreshold(refValues, fieldValues, maxThreshold) {
  let prevRef;
  let nullIdx;
  for (let i = 0; i < fieldValues.length; i++) {
    let fieldVal = fieldValues[i];
    if (fieldVal == null) {
      if (nullIdx == null && prevRef != null) {
        nullIdx = i;
      }
    } else {
      if (nullIdx != null) {
        if (refValues[i] - prevRef < maxThreshold) {
          while (nullIdx < i) {
            fieldValues[nullIdx++] = void 0;
          }
        }
        nullIdx = null;
      }
      prevRef = refValues[i];
    }
  }
  return fieldValues;
}

var __defProp$1l = Object.defineProperty;
var __defProps$X = Object.defineProperties;
var __getOwnPropDescs$X = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1m = Object.getOwnPropertySymbols;
var __hasOwnProp$1m = Object.prototype.hasOwnProperty;
var __propIsEnum$1m = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1l = (obj, key, value) => key in obj ? __defProp$1l(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1l = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1m.call(b, prop))
      __defNormalProp$1l(a, prop, b[prop]);
  if (__getOwnPropSymbols$1m)
    for (var prop of __getOwnPropSymbols$1m(b)) {
      if (__propIsEnum$1m.call(b, prop))
        __defNormalProp$1l(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$X = (a, b) => __defProps$X(a, __getOwnPropDescs$X(b));
function isVisibleBarField(f) {
  var _a, _b, _c;
  return f.type === data.FieldType.number && ((_a = f.config.custom) == null ? void 0 : _a.drawStyle) === schema.GraphDrawStyle.Bars && !((_c = (_b = f.config.custom) == null ? void 0 : _b.hideFrom) == null ? void 0 : _c.viz);
}
function applySpanNullsThresholds(frame) {
  var _a;
  let refField = frame.fields.find((field) => field.type === data.FieldType.time);
  let refValues = refField == null ? void 0 : refField.values.toArray();
  for (let i = 0; i < frame.fields.length; i++) {
    let field = frame.fields[i];
    if (field === refField || isVisibleBarField(field)) {
      continue;
    }
    let spanNulls = (_a = field.config.custom) == null ? void 0 : _a.spanNulls;
    if (typeof spanNulls === "number") {
      if (spanNulls !== -1) {
        field.values = new data.ArrayVector(nullToUndefThreshold(refValues, field.values.toArray(), spanNulls));
      }
    }
  }
  return frame;
}
function preparePlotFrame$1(frames, dimFields, timeRange) {
  frames = frames.map((frame) => {
    var _a;
    if (!((_a = frame.fields[0].state) == null ? void 0 : _a.nullThresholdApplied)) {
      return applyNullInsertThreshold({
        frame,
        refFieldName: null,
        refFieldPseudoMin: timeRange == null ? void 0 : timeRange.from.valueOf(),
        refFieldPseudoMax: timeRange == null ? void 0 : timeRange.to.valueOf()
      });
    } else {
      return frame;
    }
  });
  let numBarSeries = 0;
  frames.forEach((frame) => {
    frame.fields.forEach((f) => {
      if (isVisibleBarField(f)) {
        f.config.custom = __spreadProps$X(__spreadValues$1l({}, f.config.custom), {
          spanNulls: -1
        });
        numBarSeries++;
      }
    });
  });
  let minXDelta = Infinity;
  if (numBarSeries > 1) {
    frames.forEach((frame) => {
      if (!frame.fields.some(isVisibleBarField)) {
        return;
      }
      const xVals = frame.fields[0].values.toArray();
      for (let i = 0; i < xVals.length; i++) {
        if (i > 0) {
          minXDelta = Math.min(minXDelta, xVals[i] - xVals[i - 1]);
        }
      }
    });
  }
  let alignedFrame = data.outerJoinDataFrames({
    frames,
    joinBy: dimFields.x,
    keep: dimFields.y,
    keepOriginIndices: true
  });
  if (alignedFrame) {
    alignedFrame = applySpanNullsThresholds(alignedFrame);
    if (minXDelta !== Infinity) {
      alignedFrame.fields.forEach((f, fi) => {
        let vals = f.values.toArray();
        if (fi === 0) {
          let lastVal = vals[vals.length - 1];
          vals.push(lastVal + minXDelta, lastVal + 2 * minXDelta);
        } else if (isVisibleBarField(f)) {
          vals.push(null, null);
        } else {
          vals.push(void 0, void 0);
        }
      });
      alignedFrame.length += 2;
    }
    return alignedFrame;
  }
  return null;
}
function buildScaleKey(config) {
  var _a, _b, _c, _d, _e, _f, _g;
  const defaultPart = "na";
  const scaleRange = `${config.min !== void 0 ? config.min : defaultPart}-${config.max !== void 0 ? config.max : defaultPart}`;
  const scaleSoftRange = `${((_a = config.custom) == null ? void 0 : _a.axisSoftMin) !== void 0 ? config.custom.axisSoftMin : defaultPart}-${((_b = config.custom) == null ? void 0 : _b.axisSoftMax) !== void 0 ? config.custom.axisSoftMax : defaultPart}`;
  const scalePlacement = `${((_c = config.custom) == null ? void 0 : _c.axisPlacement) !== void 0 ? (_d = config.custom) == null ? void 0 : _d.axisPlacement : schema.AxisPlacement.Auto}`;
  const scaleUnit = (_e = config.unit) != null ? _e : FIXED_UNIT;
  const scaleDistribution = ((_f = config.custom) == null ? void 0 : _f.scaleDistribution) ? getScaleDistributionPart(config.custom.scaleDistribution) : schema.ScaleDistribution.Linear;
  const scaleLabel = Boolean((_g = config.custom) == null ? void 0 : _g.axisLabel) ? config.custom.axisLabel : defaultPart;
  return `${scaleUnit}/${scaleRange}/${scaleSoftRange}/${scalePlacement}/${scaleDistribution}/${scaleLabel}`;
}
function getScaleDistributionPart(config) {
  if (config.type === schema.ScaleDistribution.Log) {
    return `${config.type}${config.log}`;
  }
  return config.type;
}

const paddingSide = (u, side, sidesWithAxes) => {
  let hasCrossAxis = side % 2 ? sidesWithAxes[0] || sidesWithAxes[2] : sidesWithAxes[1] || sidesWithAxes[3];
  return sidesWithAxes[side] || !hasCrossAxis ? 0 : 8;
};
const DEFAULT_PLOT_CONFIG = {
  ms: 1,
  focus: {
    alpha: 1
  },
  cursor: {
    focus: {
      prox: 30
    }
  },
  legend: {
    show: false
  },
  padding: [paddingSide, paddingSide, paddingSide, paddingSide],
  series: [],
  hooks: {}
};
function getStackingBands(group) {
  let bands = [];
  let { series, dir } = group;
  let lastIdx = series.length - 1;
  let rSeries = series.slice().reverse();
  rSeries.forEach((si, i) => {
    if (i !== lastIdx) {
      let nextIdx = rSeries[i + 1];
      bands.push({
        series: [si, nextIdx],
        // fill direction is inverted from stack direction
        dir: -1 * dir
      });
    }
  });
  return bands;
}
function getStackingGroups(frame) {
  let groups = /* @__PURE__ */ new Map();
  frame.fields.forEach(({ config, values }, i) => {
    var _a;
    if (i === 0) {
      return;
    }
    let { custom } = config;
    if (custom == null) {
      return;
    }
    if ((_a = custom.hideFrom) == null ? void 0 : _a.viz) {
      return;
    }
    let { stacking } = custom;
    if (stacking == null) {
      return;
    }
    let { mode: stackingMode, group: stackingGroup } = stacking;
    if (stackingMode === schema.StackingMode.None) {
      return;
    }
    let vals = values.toArray();
    let transform = custom.transform;
    let stackDir = getStackDirection(transform, vals);
    let drawStyle = custom.drawStyle;
    let drawStyle2 = drawStyle === schema.GraphDrawStyle.Bars ? custom.barAlignment : drawStyle === schema.GraphDrawStyle.Line ? custom.lineInterpolation : null;
    let stackKey = `${stackDir}|${stackingMode}|${stackingGroup}|${buildScaleKey(config)}|${drawStyle}|${drawStyle2}`;
    let group = groups.get(stackKey);
    if (group == null) {
      group = {
        series: [],
        dir: stackDir
      };
      groups.set(stackKey, group);
    }
    group.series.push(i);
  });
  return [...groups.values()];
}
function preparePlotData2(frame, stackingGroups, onStackMeta) {
  let data$1 = Array(frame.fields.length);
  let stacksQty = stackingGroups.length;
  let dataLen = frame.length;
  let zeroArr = stacksQty > 0 ? Array(dataLen).fill(0) : [];
  let falseArr = stacksQty > 0 ? Array(dataLen).fill(false) : [];
  let accums = Array.from({ length: stacksQty }, () => zeroArr.slice());
  let anyValsAtX = Array.from({ length: stacksQty }, () => falseArr.slice());
  stackingGroups.forEach((group, groupIdx) => {
    let groupValsAtX = anyValsAtX[groupIdx];
    group.series.forEach((seriesIdx) => {
      var _a, _b;
      let field = frame.fields[seriesIdx];
      if ((_b = (_a = field.config.custom) == null ? void 0 : _a.hideFrom) == null ? void 0 : _b.viz) {
        return;
      }
      let vals = field.values.toArray();
      for (let i = 0; i < dataLen; i++) {
        if (vals[i] != null) {
          groupValsAtX[i] = true;
        }
      }
    });
  });
  frame.fields.forEach((field, i) => {
    var _a, _b;
    let vals = field.values.toArray();
    if (i === 0) {
      if (field.type === data.FieldType.time) {
        data$1[i] = data.ensureTimeField(field).values.toArray();
      } else {
        data$1[i] = vals;
      }
      return;
    }
    let { custom } = field.config;
    if (!custom || ((_a = custom.hideFrom) == null ? void 0 : _a.viz)) {
      data$1[i] = vals;
      return;
    }
    if (custom.transform === schema.GraphTransform.Constant) {
      let firstValIdx = vals.findIndex((v) => v != null);
      let firstVal = vals[firstValIdx];
      vals = Array(vals.length).fill(void 0);
      vals[firstValIdx] = firstVal;
    } else {
      vals = vals.slice();
      if (custom.transform === schema.GraphTransform.NegativeY) {
        for (let i2 = 0; i2 < vals.length; i2++) {
          if (vals[i2] != null) {
            vals[i2] *= -1;
          }
        }
      }
    }
    let stackingMode = (_b = custom.stacking) == null ? void 0 : _b.mode;
    if (!stackingMode || stackingMode === schema.StackingMode.None) {
      data$1[i] = vals;
    } else {
      let stackIdx = stackingGroups.findIndex((group) => group.series.indexOf(i) > -1);
      let accum = accums[stackIdx];
      let groupValsAtX = anyValsAtX[stackIdx];
      let stacked = data$1[i] = Array(dataLen);
      for (let i2 = 0; i2 < dataLen; i2++) {
        let v = vals[i2];
        if (v != null) {
          stacked[i2] = accum[i2] += v;
        } else {
          stacked[i2] = groupValsAtX[i2] ? accum[i2] : v;
        }
      }
    }
  });
  if (onStackMeta) {
    let accumsBySeriesIdx = data$1.map((vals, i) => {
      let stackIdx = stackingGroups.findIndex((group) => group.series.indexOf(i) > -1);
      return stackIdx !== -1 ? accums[stackIdx] : vals;
    });
    onStackMeta({
      totals: accumsBySeriesIdx
    });
  }
  frame.fields.forEach((field, i) => {
    var _a, _b, _c, _d;
    if (i === 0 || ((_b = (_a = field.config.custom) == null ? void 0 : _a.hideFrom) == null ? void 0 : _b.viz)) {
      return;
    }
    let stackingMode = (_d = (_c = field.config.custom) == null ? void 0 : _c.stacking) == null ? void 0 : _d.mode;
    if (stackingMode === schema.StackingMode.Percent) {
      let stackIdx = stackingGroups.findIndex((group2) => group2.series.indexOf(i) > -1);
      let accum = accums[stackIdx];
      let group = stackingGroups[stackIdx];
      let stacked = data$1[i];
      for (let i2 = 0; i2 < dataLen; i2++) {
        let v = stacked[i2];
        if (v != null) {
          stacked[i2] = accum[i2] === 0 ? 0 : group.dir * (v / accum[i2]);
        }
      }
    }
  });
  return data$1;
}
function findMidPointYPosition(u, idx) {
  let y;
  let sMaxIdx = 1;
  let sMinIdx = 1;
  let max = u.data[1][idx];
  let min = u.data[1][idx];
  for (let i = 1; i < u.data.length; i++) {
    const sData = u.data[i];
    const sVal = sData[idx];
    if (sVal != null) {
      if (max == null) {
        max = sVal;
      } else {
        if (sVal > max) {
          max = u.data[i][idx];
          sMaxIdx = i;
        }
      }
      if (min == null) {
        min = sVal;
      } else {
        if (sVal < min) {
          min = u.data[i][idx];
          sMinIdx = i;
        }
      }
    }
  }
  if (min == null && max == null) {
    y = void 0;
  } else if (min != null && max != null) {
    y = (u.valToPos(min, u.series[sMinIdx].scale) + u.valToPos(max, u.series[sMaxIdx].scale)) / 2;
  } else {
    y = u.valToPos(min || max, u.series[sMaxIdx || sMinIdx].scale);
  }
  if (y !== void 0 && y < 0) {
    y = u.bbox.height / devicePixelRatio;
  }
  return y;
}
function getStackDirection(transform, data) {
  const hasNegSamp = hasNegSample(data);
  if (transform === schema.GraphTransform.NegativeY) {
    return hasNegSamp ? 1 /* Pos */ : -1 /* Neg */;
  }
  return hasNegSamp ? -1 /* Neg */ : 1 /* Pos */;
}
function hasNegSample(data, samples = 100) {
  const len = data.length;
  if (len === 0) {
    return false;
  }
  let firstIdx = 0;
  let lastIdx = len - 1;
  while (firstIdx <= lastIdx && data[firstIdx] == null) {
    firstIdx++;
  }
  while (lastIdx >= firstIdx && data[lastIdx] == null) {
    lastIdx--;
  }
  let negCount = 0;
  let posCount = 0;
  if (lastIdx >= firstIdx) {
    const stride = Math.max(1, Math.floor((lastIdx - firstIdx + 1) / samples));
    for (let i = firstIdx; i <= lastIdx; i += stride) {
      const v = data[i];
      if (v != null) {
        if (v < 0 || Object.is(v, -0)) {
          negCount++;
        } else if (v > 0) {
          posCount++;
        }
      }
    }
    if (negCount > posCount) {
      return true;
    }
  }
  return false;
}
const pluginLogger = createLogger("uPlot");
const pluginLog = pluginLogger.logger;
attachDebugger("graphng", void 0, pluginLogger);

var __defProp$1k = Object.defineProperty;
var __getOwnPropSymbols$1l = Object.getOwnPropertySymbols;
var __hasOwnProp$1l = Object.prototype.hasOwnProperty;
var __propIsEnum$1l = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1k = (obj, key, value) => key in obj ? __defProp$1k(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1k = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1l.call(b, prop))
      __defNormalProp$1k(a, prop, b[prop]);
  if (__getOwnPropSymbols$1l)
    for (var prop of __getOwnPropSymbols$1l(b)) {
      if (__propIsEnum$1l.call(b, prop))
        __defNormalProp$1k(a, prop, b[prop]);
    }
  return a;
};
function sameDims(prevProps, nextProps) {
  return nextProps.width === prevProps.width && nextProps.height === prevProps.height;
}
function sameData(prevProps, nextProps) {
  return nextProps.data === prevProps.data;
}
function sameConfig(prevProps, nextProps) {
  return nextProps.config === prevProps.config;
}
function sameTimeRange(prevProps, nextProps) {
  let prevTime = prevProps.timeRange;
  let nextTime = nextProps.timeRange;
  return prevTime === nextTime || nextTime.from.valueOf() === prevTime.from.valueOf() && nextTime.to.valueOf() === prevTime.to.valueOf();
}
class UPlotChart extends React.Component {
  constructor(props) {
    super(props);
    this.plotContainer = React.createRef();
    this.plotCanvasBBox = React.createRef();
    this.state = {
      plot: null
    };
  }
  reinitPlot() {
    var _a;
    let { width, height, plotRef } = this.props;
    (_a = this.state.plot) == null ? void 0 : _a.destroy();
    if (width === 0 && height === 0) {
      return;
    }
    this.props.config.addHook("setSize", (u) => {
      const canvas = u.over;
      if (!canvas) {
        return;
      }
    });
    const config = __spreadValues$1k({
      width: Math.floor(this.props.width),
      height: Math.floor(this.props.height)
    }, this.props.config.getConfig());
    pluginLog("UPlot", false, "Reinitializing plot", config);
    const plot = new uPlot__default["default"](config, this.props.data, this.plotContainer.current);
    if (plotRef) {
      plotRef(plot);
    }
    this.setState({ plot });
  }
  componentDidMount() {
    this.reinitPlot();
  }
  componentWillUnmount() {
    var _a;
    (_a = this.state.plot) == null ? void 0 : _a.destroy();
  }
  componentDidUpdate(prevProps) {
    let { plot } = this.state;
    if (!sameDims(prevProps, this.props)) {
      plot == null ? void 0 : plot.setSize({
        width: Math.floor(this.props.width),
        height: Math.floor(this.props.height)
      });
    } else if (!sameConfig(prevProps, this.props)) {
      this.reinitPlot();
    } else if (!sameData(prevProps, this.props)) {
      plot == null ? void 0 : plot.setData(this.props.data);
    } else if (!sameTimeRange(prevProps, this.props)) {
      plot == null ? void 0 : plot.setScale("x", {
        min: this.props.timeRange.from.valueOf(),
        max: this.props.timeRange.to.valueOf()
      });
    }
  }
  render() {
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: { position: "relative" } }, /* @__PURE__ */ React__default["default"].createElement("div", { ref: this.plotContainer, "data-testid": "uplot-main-div" }), this.props.children);
  }
}

class PlotConfigBuilder {
  constructor(props) {
    this.props = props;
  }
}

var __defProp$1j = Object.defineProperty;
var __getOwnPropSymbols$1k = Object.getOwnPropertySymbols;
var __hasOwnProp$1k = Object.prototype.hasOwnProperty;
var __propIsEnum$1k = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1j = (obj, key, value) => key in obj ? __defProp$1j(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1j = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1k.call(b, prop))
      __defNormalProp$1j(a, prop, b[prop]);
  if (__getOwnPropSymbols$1k)
    for (var prop of __getOwnPropSymbols$1k(b)) {
      if (__propIsEnum$1k.call(b, prop))
        __defNormalProp$1j(a, prop, b[prop]);
    }
  return a;
};
class UPlotScaleBuilder extends PlotConfigBuilder {
  merge(props) {
    this.props.min = optMinMax("min", this.props.min, props.min);
    this.props.max = optMinMax("max", this.props.max, props.max);
  }
  getConfig() {
    var _a, _b;
    let {
      isTime,
      scaleKey,
      min: hardMin,
      max: hardMax,
      softMin,
      softMax,
      range,
      direction,
      orientation,
      centeredZero,
      decimals
    } = this.props;
    const distr = this.props.distribution;
    const distribution = !isTime ? {
      distr: distr === schema.ScaleDistribution.Symlog ? 4 : distr === schema.ScaleDistribution.Log ? 3 : distr === schema.ScaleDistribution.Ordinal ? 2 : 1,
      log: distr === schema.ScaleDistribution.Log || distr === schema.ScaleDistribution.Symlog ? (_a = this.props.log) != null ? _a : 2 : void 0,
      asinh: distr === schema.ScaleDistribution.Symlog ? (_b = this.props.linearThreshold) != null ? _b : 1 : void 0
    } : {};
    if (distr === schema.ScaleDistribution.Log) {
      let logBase = this.props.log;
      let logFn = logBase === 2 ? Math.log2 : Math.log10;
      if (hardMin != null) {
        if (hardMin <= 0) {
          hardMin = null;
        } else {
          hardMin = logBase ** Math.floor(logFn(hardMin));
        }
      }
      if (hardMax != null) {
        if (hardMax <= 0) {
          hardMax = null;
        } else {
          hardMax = logBase ** Math.ceil(logFn(hardMax));
        }
      }
      if (softMin != null) {
        if (softMin <= 0) {
          softMin = null;
        } else {
          softMin = logBase ** Math.floor(logFn(softMin));
        }
      }
      if (softMax != null) {
        if (softMax <= 0) {
          softMax = null;
        } else {
          softMax = logBase ** Math.ceil(logFn(softMax));
        }
      }
    }
    let softMinMode = softMin == null ? 3 : 1;
    let softMaxMode = softMax == null ? 3 : 1;
    const rangeConfig = {
      min: {
        pad: 0.1,
        hard: hardMin != null ? hardMin : -Infinity,
        soft: softMin || 0,
        mode: softMinMode
      },
      max: {
        pad: 0.1,
        hard: hardMax != null ? hardMax : Infinity,
        soft: softMax || 0,
        mode: softMaxMode
      }
    };
    let hardMinOnly = softMin == null && hardMin != null;
    let hardMaxOnly = softMax == null && hardMax != null;
    let hasFixedRange = hardMinOnly && hardMaxOnly;
    const rangeFn = (u, dataMin, dataMax, scaleKey2) => {
      var _a2;
      const scale = u.scales[scaleKey2];
      let minMax = [dataMin, dataMax];
      if (!hasFixedRange && dataMin == null && dataMax == null) {
        return minMax;
      }
      let logBase = (_a2 = scale.log) != null ? _a2 : 10;
      if (scale.distr === 1 || scale.distr === 2 || scale.distr === 4) {
        if (centeredZero) {
          let absMin = Math.abs(dataMin);
          let absMax = Math.abs(dataMax);
          let max = Math.max(absMin, absMax);
          dataMin = -max;
          dataMax = max;
        }
        if (scale.distr === 4) {
          minMax = uPlot__default["default"].rangeAsinh(dataMin, dataMax, logBase, true);
        } else {
          minMax = uPlot__default["default"].rangeNum(hardMinOnly ? hardMin : dataMin, hardMaxOnly ? hardMax : dataMax, rangeConfig);
        }
      } else if (scale.distr === 3) {
        minMax = uPlot__default["default"].rangeLog(hardMin != null ? hardMin : dataMin, hardMax != null ? hardMax : dataMax, logBase, true);
      }
      if (decimals === 0) {
        if (scale.distr === 1 || scale.distr === 2) {
          minMax[0] = data.incrRoundDn(minMax[0], 1);
          minMax[1] = data.incrRoundUp(minMax[1], 1);
        } else if (scale.distr === 3) {
          let logFn = scale.log === 2 ? Math.log2 : Math.log10;
          if (minMax[0] <= 1) {
            minMax[0] = 1;
          } else {
            let minExp = Math.floor(logFn(minMax[0]));
            minMax[0] = logBase ** minExp;
          }
          let maxExp = Math.ceil(logFn(minMax[1]));
          minMax[1] = logBase ** maxExp;
          if (minMax[0] === minMax[1]) {
            minMax[1] *= logBase;
          }
        } else if (scale.distr === 4) {
          minMax[0] = data.incrRoundDn(minMax[0], 1);
          minMax[1] = data.incrRoundUp(minMax[1], 1);
        }
      }
      if (scale.distr === 1 || scale.distr === 4) {
        if (hardMinOnly) {
          minMax[0] = hardMin;
        }
        if (hardMaxOnly) {
          minMax[1] = hardMax;
        }
      }
      if (minMax[0] >= minMax[1]) {
        minMax[0] = scale.distr === 3 ? 1 : 0;
        minMax[1] = 100;
      }
      return minMax;
    };
    let auto = !isTime && !hasFixedRange;
    if (data.isBooleanUnit(scaleKey)) {
      auto = false;
      range = [0, 1];
    }
    return {
      [scaleKey]: __spreadValues$1j({
        time: isTime,
        auto,
        range: range != null ? range : rangeFn,
        dir: direction,
        ori: orientation
      }, distribution)
    };
  }
}
function optMinMax(minmax, a, b) {
  const hasA = !(a === void 0 || a === null);
  const hasB = !(b === void 0 || b === null);
  if (hasA) {
    if (!hasB) {
      return a;
    }
    if (minmax === "min") {
      return a < b ? a : b;
    }
    return a > b ? a : b;
  }
  return b;
}

const UPLOT_AXIS_FONT_SIZE = 12;
const labelPad = 8;
class UPlotAxisBuilder extends PlotConfigBuilder {
  merge(props) {
    this.props.size = optMinMax("max", this.props.size, props.size);
    if (!this.props.label) {
      this.props.label = props.label;
    }
    if (this.props.placement === schema.AxisPlacement.Auto) {
      this.props.placement = props.placement;
    }
  }
  /* Minimum grid & tick spacing in CSS pixels */
  calculateSpace(self, axisIdx, scaleMin, scaleMax, plotDim) {
    const axis = self.axes[axisIdx];
    const scale = self.scales[axis.scale];
    if (axis.side !== 2 || !scale) {
      return 30;
    }
    const defaultSpacing = 40;
    if (scale.time) {
      const maxTicks = plotDim / defaultSpacing;
      const increment = (scaleMax - scaleMin) / maxTicks;
      const sample = formatTime(self, [scaleMin], axisIdx, defaultSpacing, increment);
      const width = measureText(sample[0], UPLOT_AXIS_FONT_SIZE).width + 18;
      return width;
    }
    return defaultSpacing;
  }
  /** height of x axis or width of y axis in CSS pixels alloted for values, gap & ticks, but excluding axis label */
  calculateAxisSize(self, values, axisIdx) {
    const axis = self.axes[axisIdx];
    let axisSize = axis.ticks.size;
    if (axis.side === 2) {
      axisSize += axis.gap + UPLOT_AXIS_FONT_SIZE;
    } else if (values == null ? void 0 : values.length) {
      let maxTextWidth = values.reduce(
        (acc, value) => Math.max(acc, measureText(value, UPLOT_AXIS_FONT_SIZE).width),
        0
      );
      const textWidthWithLimit = Math.min(self.width * 0.4, maxTextWidth);
      axisSize += axis.gap + axis.labelGap + textWidthWithLimit;
    }
    return Math.ceil(axisSize);
  }
  getConfig() {
    let {
      scaleKey,
      label,
      show = true,
      placement = schema.AxisPlacement.Auto,
      grid = { show: true },
      ticks,
      space,
      filter,
      gap = 5,
      formatValue,
      splits,
      values,
      incrs,
      isTime,
      timeZone,
      theme,
      tickLabelRotation,
      size,
      color,
      border,
      decimals,
      distr = schema.ScaleDistribution.Linear
    } = this.props;
    const font = `${UPLOT_AXIS_FONT_SIZE}px ${theme.typography.fontFamily}`;
    const gridColor = theme.isDark ? "rgba(240, 250, 255, 0.09)" : "rgba(0, 10, 23, 0.09)";
    if (data.isBooleanUnit(scaleKey)) {
      splits = [0, 1];
    }
    if (decimals === 0 && distr === schema.ScaleDistribution.Linear) {
      filter = (u, splits2) => splits2.map((v) => Number.isInteger(v) ? v : null);
    }
    let config = {
      scale: scaleKey,
      show,
      stroke: color != null ? color : theme.colors.text.primary,
      side: getUPlotSideFromAxis(placement),
      font,
      size: size != null ? size : (self, values2, axisIdx) => {
        return this.calculateAxisSize(self, values2, axisIdx);
      },
      rotate: tickLabelRotation,
      gap,
      labelGap: 0,
      grid: {
        show: grid.show,
        stroke: gridColor,
        width: 1 / devicePixelRatio
      },
      ticks: Object.assign(
        {
          show: true,
          stroke: gridColor,
          width: 1 / devicePixelRatio,
          size: 4
        },
        ticks
      ),
      splits,
      values,
      space: space != null ? space : (self, axisIdx, scaleMin, scaleMax, plotDim) => {
        return this.calculateSpace(self, axisIdx, scaleMin, scaleMax, plotDim);
      },
      filter,
      incrs
    };
    if (border != null) {
      config.border = border;
    }
    if (label != null && label.length > 0) {
      config.label = label;
      config.labelSize = UPLOT_AXIS_FONT_SIZE + labelPad;
      config.labelFont = font;
      config.labelGap = labelPad;
    }
    if (values) {
      config.values = values;
    } else if (isTime) {
      config.values = formatTime;
    } else if (formatValue) {
      config.values = (u, splits2, axisIdx, tickSpace, tickIncr) => {
        let decimals2 = data.guessDecimals(data.roundDecimals(tickIncr, 6));
        return splits2.map((v) => formatValue(v, decimals2 > 0 ? decimals2 : void 0));
      };
    }
    config.timeZone = timeZone;
    return config;
  }
}
const timeUnitSize = {
  second: 1e3,
  minute: 60 * 1e3,
  hour: 60 * 60 * 1e3,
  day: 24 * 60 * 60 * 1e3,
  month: 28 * 24 * 60 * 60 * 1e3,
  year: 365 * 24 * 60 * 60 * 1e3
};
function formatTime(self, splits, axisIdx, foundSpace, foundIncr) {
  var _a, _b;
  const timeZone = self.axes[axisIdx].timeZone;
  const scale = self.scales.x;
  const range = ((_a = scale == null ? void 0 : scale.max) != null ? _a : 0) - ((_b = scale == null ? void 0 : scale.min) != null ? _b : 0);
  const yearRoundedToDay = Math.round(timeUnitSize.year / timeUnitSize.day) * timeUnitSize.day;
  const incrementRoundedToDay = Math.round(foundIncr / timeUnitSize.day) * timeUnitSize.day;
  let format = data.systemDateFormats.interval.year;
  if (foundIncr < timeUnitSize.second) {
    format = data.systemDateFormats.interval.millisecond;
  } else if (foundIncr <= timeUnitSize.minute) {
    format = data.systemDateFormats.interval.second;
  } else if (range <= timeUnitSize.day) {
    format = data.systemDateFormats.interval.minute;
  } else if (foundIncr <= timeUnitSize.day) {
    format = data.systemDateFormats.interval.hour;
  } else if (range < timeUnitSize.year) {
    format = data.systemDateFormats.interval.day;
  } else if (incrementRoundedToDay === yearRoundedToDay) {
    format = data.systemDateFormats.interval.year;
  } else if (foundIncr <= timeUnitSize.year) {
    format = data.systemDateFormats.interval.month;
  }
  return splits.map((v) => v == null ? "" : data.dateTimeFormat(v, { format, timeZone }));
}
function getUPlotSideFromAxis(axis) {
  switch (axis) {
    case schema.AxisPlacement.Top:
      return 0;
    case schema.AxisPlacement.Right:
      return 1;
    case schema.AxisPlacement.Bottom:
      return 2;
    case schema.AxisPlacement.Left:
  }
  return 3;
}

function makeDirectionalGradient(direction, bbox, ctx) {
  let x0 = 0, y0 = 0, x1 = 0, y1 = 0;
  if (direction === GradientDirection.Down) {
    y0 = bbox.top;
    y1 = bbox.top + bbox.height;
  } else if (direction === GradientDirection.Left) {
    x0 = bbox.left + bbox.width;
    x1 = bbox.left;
  } else if (direction === GradientDirection.Up) {
    y0 = bbox.top + bbox.height;
    y1 = bbox.top;
  } else if (direction === GradientDirection.Right) {
    x0 = bbox.left;
    x1 = bbox.left + bbox.width;
  }
  return ctx.createLinearGradient(x0, y0, x1, y1);
}
function getOpacityGradientFn(color, opacity) {
  return (plot, seriesIdx) => {
    const ctx = getCanvasContext();
    const gradient = makeDirectionalGradient(
      plot.scales.x.ori === schema.ScaleOrientation.Horizontal ? GradientDirection.Down : GradientDirection.Left,
      plot.bbox,
      ctx
    );
    gradient.addColorStop(0, data.colorManipulator.alpha(color, opacity));
    gradient.addColorStop(1, data.colorManipulator.alpha(color, 0));
    return gradient;
  };
}
function getHueGradientFn(color, opacity, theme) {
  return (plot, seriesIdx) => {
    const ctx = getCanvasContext();
    const gradient = makeDirectionalGradient(
      plot.scales.x.ori === schema.ScaleOrientation.Horizontal ? GradientDirection.Down : GradientDirection.Left,
      plot.bbox,
      ctx
    );
    const color1 = tinycolor__default["default"](color).spin(-15);
    const color2 = tinycolor__default["default"](color).spin(15);
    if (theme.isDark) {
      gradient.addColorStop(0, color2.lighten(10).setAlpha(opacity).toString());
      gradient.addColorStop(1, color1.darken(10).setAlpha(opacity).toString());
    } else {
      gradient.addColorStop(0, color2.lighten(10).setAlpha(opacity).toString());
      gradient.addColorStop(1, color1.setAlpha(opacity).toString());
    }
    return gradient;
  };
}
var GradientDirection = /* @__PURE__ */ ((GradientDirection2) => {
  GradientDirection2[GradientDirection2["Right"] = 0] = "Right";
  GradientDirection2[GradientDirection2["Up"] = 1] = "Up";
  GradientDirection2[GradientDirection2["Left"] = 2] = "Left";
  GradientDirection2[GradientDirection2["Down"] = 3] = "Down";
  return GradientDirection2;
})(GradientDirection || {});
function scaleGradient(u, scaleKey, scaleStops, discrete = false) {
  let scale = u.scales[scaleKey];
  let minStopIdx = null;
  let maxStopIdx = null;
  for (let i = 0; i < scaleStops.length; i++) {
    let stopVal = scaleStops[i][0];
    if (stopVal <= scale.min || minStopIdx == null) {
      minStopIdx = i;
    }
    maxStopIdx = i;
    if (stopVal >= scale.max) {
      break;
    }
  }
  if (minStopIdx === maxStopIdx) {
    return scaleStops[minStopIdx][1];
  }
  let minStopVal = scaleStops[minStopIdx][0];
  let maxStopVal = scaleStops[maxStopIdx][0];
  if (minStopVal === -Infinity) {
    minStopVal = scale.min;
  }
  if (maxStopVal === Infinity) {
    maxStopVal = scale.max;
  }
  let minStopPos = Math.round(u.valToPos(minStopVal, scaleKey, true));
  let maxStopPos = Math.round(u.valToPos(maxStopVal, scaleKey, true));
  let range = minStopPos - maxStopPos;
  if (range === 0) {
    return scaleStops[maxStopIdx][1];
  }
  let x0, y0, x1, y1;
  if (u.scales.x.ori === schema.ScaleOrientation.Horizontal) {
    x0 = x1 = 0;
    y0 = minStopPos;
    y1 = maxStopPos;
  } else {
    y0 = y1 = 0;
    x0 = minStopPos;
    x1 = maxStopPos;
  }
  let ctx = getCanvasContext();
  let grd = ctx.createLinearGradient(x0, y0, x1, y1);
  let prevColor;
  for (let i = minStopIdx; i <= maxStopIdx; i++) {
    let s = scaleStops[i];
    let stopPos = i === minStopIdx ? minStopPos : i === maxStopIdx ? maxStopPos : Math.round(u.valToPos(s[0], scaleKey, true));
    let pct = (minStopPos - stopPos) / range;
    if (discrete && i > minStopIdx) {
      grd.addColorStop(pct, prevColor);
    }
    grd.addColorStop(pct, prevColor = s[1]);
  }
  return grd;
}
function getDataRange(plot, scaleKey) {
  let sc = plot.scales[scaleKey];
  let min = Infinity;
  let max = -Infinity;
  plot.series.forEach((ser, seriesIdx) => {
    if (ser.show && ser.scale === scaleKey) {
      if (ser.min == null) {
        let data = plot.data[seriesIdx];
        for (let i = 0; i < data.length; i++) {
          if (data[i] != null) {
            min = Math.min(min, data[i]);
            max = Math.max(max, data[i]);
          }
        }
      } else {
        min = Math.min(min, ser.min);
        max = Math.max(max, ser.max);
      }
    }
  });
  if (max === min) {
    min = sc.min;
    max = sc.max;
  }
  return [min, max];
}
function getGradientRange(u, scaleKey, hardMin, hardMax, softMin, softMax) {
  var _a, _b, _c, _d;
  let min = (_a = hardMin != null ? hardMin : softMin) != null ? _a : null;
  let max = (_b = hardMax != null ? hardMax : softMax) != null ? _b : null;
  if (min == null || max == null) {
    let [dataMin, dataMax] = getDataRange(u, scaleKey);
    min = (_c = min != null ? min : dataMin) != null ? _c : 0;
    max = (_d = max != null ? max : dataMax) != null ? _d : 100;
  }
  return [min, max];
}
function getScaleGradientFn(opacity, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax) {
  if (!colorMode) {
    throw Error("Missing colorMode required for color scheme gradients");
  }
  if (!thresholds) {
    throw Error("Missing thresholds required for color scheme gradients");
  }
  return (plot, seriesIdx) => {
    let scaleKey = plot.series[seriesIdx].scale;
    let gradient = "";
    if (colorMode.id === data.FieldColorModeId.Thresholds) {
      if (thresholds.mode === data.ThresholdsMode.Absolute) {
        const valueStops = thresholds.steps.map(
          (step) => [step.value, data.colorManipulator.alpha(theme.visualization.getColorByName(step.color), opacity)]
        );
        gradient = scaleGradient(plot, scaleKey, valueStops, true);
      } else {
        const [min, max] = getGradientRange(plot, scaleKey, hardMin, hardMax, softMin, softMax);
        const range = max - min;
        const valueStops = thresholds.steps.map(
          (step) => [
            min + range * (step.value / 100),
            data.colorManipulator.alpha(theme.visualization.getColorByName(step.color), opacity)
          ]
        );
        gradient = scaleGradient(plot, scaleKey, valueStops, true);
      }
    } else if (colorMode.getColors) {
      const colors = colorMode.getColors(theme);
      const [min, max] = getGradientRange(plot, scaleKey, hardMin, hardMax, softMin, softMax);
      const range = max - min;
      const valueStops = colors.map(
        (color, i) => [
          min + range * (i / (colors.length - 1)),
          data.colorManipulator.alpha(theme.visualization.getColorByName(color), opacity)
        ]
      );
      gradient = scaleGradient(plot, scaleKey, valueStops, false);
    }
    return gradient;
  };
}

var __defProp$1i = Object.defineProperty;
var __getOwnPropSymbols$1j = Object.getOwnPropertySymbols;
var __hasOwnProp$1j = Object.prototype.hasOwnProperty;
var __propIsEnum$1j = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1i = (obj, key, value) => key in obj ? __defProp$1i(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1i = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1j.call(b, prop))
      __defNormalProp$1i(a, prop, b[prop]);
  if (__getOwnPropSymbols$1j)
    for (var prop of __getOwnPropSymbols$1j(b)) {
      if (__propIsEnum$1j.call(b, prop))
        __defNormalProp$1i(a, prop, b[prop]);
    }
  return a;
};
class UPlotSeriesBuilder extends PlotConfigBuilder {
  getConfig() {
    var _a;
    const {
      facets,
      drawStyle,
      pathBuilder,
      pointsBuilder,
      pointsFilter,
      lineInterpolation,
      lineWidth,
      lineStyle,
      barAlignment,
      barWidthFactor,
      barMaxWidth,
      showPoints,
      pointSize,
      scaleKey,
      pxAlign,
      spanNulls,
      show = true
    } = this.props;
    let lineConfig = {};
    let lineColor = this.getLineColor();
    lineConfig.stroke = lineColor;
    if (pathBuilder != null) {
      lineConfig.paths = pathBuilder;
      lineConfig.width = lineWidth;
    } else if (drawStyle === schema.GraphDrawStyle.Points) {
      lineConfig.paths = () => null;
    } else if (drawStyle != null) {
      lineConfig.width = lineWidth;
      if (lineStyle && lineStyle.fill !== "solid") {
        if (lineStyle.fill === "dot") {
          lineConfig.cap = "round";
        }
        lineConfig.dash = (_a = lineStyle.dash) != null ? _a : [10, 10];
      }
      lineConfig.paths = (self, seriesIdx, idx0, idx1) => {
        let pathsBuilder = mapDrawStyleToPathBuilder(
          drawStyle,
          lineInterpolation,
          barAlignment,
          barWidthFactor,
          barMaxWidth
        );
        return pathsBuilder(self, seriesIdx, idx0, idx1);
      };
    }
    const useColor = (
      // @ts-ignore
      typeof lineColor === "string" ? lineColor : (u, seriesIdx) => u.series[seriesIdx]._stroke
    );
    const pointsConfig = {
      points: {
        stroke: useColor,
        fill: useColor,
        size: !pointSize || pointSize < lineWidth ? void 0 : pointSize,
        filter: pointsFilter
      }
    };
    if (pointsBuilder != null) {
      pointsConfig.points.show = pointsBuilder;
    } else {
      if (drawStyle === schema.GraphDrawStyle.Points) {
        pointsConfig.points.show = true;
      } else {
        if (showPoints === schema.VisibilityMode.Auto) {
          if (drawStyle === schema.GraphDrawStyle.Bars) {
            pointsConfig.points.show = false;
          }
        } else if (showPoints === schema.VisibilityMode.Never) {
          pointsConfig.points.show = false;
        } else if (showPoints === schema.VisibilityMode.Always) {
          pointsConfig.points.show = true;
        }
      }
    }
    return __spreadValues$1i(__spreadValues$1i({
      scale: scaleKey,
      facets,
      spanGaps: typeof spanNulls === "number" ? false : spanNulls,
      value: () => "",
      pxAlign,
      show,
      fill: this.getFill()
    }, lineConfig), pointsConfig);
  }
  getLineColor() {
    const {
      lineColor,
      gradientMode,
      colorMode,
      thresholds,
      theme,
      hardMin,
      hardMax,
      softMin,
      softMax,
      dynamicSeriesColor
    } = this.props;
    if (gradientMode === schema.GraphGradientMode.None && dynamicSeriesColor) {
      return (plot, seriesIdx) => {
        var _a, _b;
        return (_b = (_a = dynamicSeriesColor(seriesIdx)) != null ? _a : lineColor) != null ? _b : data.FALLBACK_COLOR;
      };
    }
    if (gradientMode === schema.GraphGradientMode.Scheme && (colorMode == null ? void 0 : colorMode.id) !== data.FieldColorModeId.Fixed) {
      return getScaleGradientFn(1, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax);
    }
    return lineColor != null ? lineColor : data.FALLBACK_COLOR;
  }
  getFill() {
    const {
      lineColor,
      fillColor,
      gradientMode,
      fillOpacity,
      colorMode,
      thresholds,
      theme,
      hardMin,
      hardMax,
      softMin,
      softMax,
      dynamicSeriesColor
    } = this.props;
    if (fillColor) {
      return fillColor;
    }
    const mode = gradientMode != null ? gradientMode : schema.GraphGradientMode.None;
    const opacityPercent = (fillOpacity != null ? fillOpacity : 0) / 100;
    if (mode === schema.GraphGradientMode.None && dynamicSeriesColor && opacityPercent > 0) {
      return (u, seriesIdx) => {
        let lineColor2 = u.series[seriesIdx]._stroke;
        return data.colorManipulator.alpha(lineColor2 != null ? lineColor2 : "", opacityPercent);
      };
    }
    switch (mode) {
      case schema.GraphGradientMode.Opacity:
        return getOpacityGradientFn(fillColor != null ? fillColor : lineColor, opacityPercent);
      case schema.GraphGradientMode.Hue:
        return getHueGradientFn(fillColor != null ? fillColor : lineColor, opacityPercent, theme);
      case schema.GraphGradientMode.Scheme:
        if ((colorMode == null ? void 0 : colorMode.id) !== data.FieldColorModeId.Fixed) {
          return getScaleGradientFn(opacityPercent, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax);
        }
      default:
        if (opacityPercent > 0) {
          return data.colorManipulator.alpha(lineColor != null ? lineColor : "", opacityPercent);
        }
    }
    return void 0;
  }
}
let builders = void 0;
function mapDrawStyleToPathBuilder(style, lineInterpolation, barAlignment = 0, barWidthFactor = 0.6, barMaxWidth = 200) {
  const pathBuilders = uPlot__default["default"].paths;
  if (!builders) {
    builders = {
      linear: pathBuilders.linear(),
      smooth: pathBuilders.spline(),
      stepBefore: pathBuilders.stepped({ align: -1 }),
      stepAfter: pathBuilders.stepped({ align: 1 })
    };
  }
  if (style === schema.GraphDrawStyle.Bars) {
    let barsCfgKey = `bars|${barAlignment}|${barWidthFactor}|${barMaxWidth}`;
    if (!builders[barsCfgKey]) {
      builders[barsCfgKey] = pathBuilders.bars({
        size: [barWidthFactor, barMaxWidth],
        align: barAlignment
      });
    }
    return builders[barsCfgKey];
  } else if (style === schema.GraphDrawStyle.Line) {
    if (lineInterpolation === schema.LineInterpolation.StepBefore) {
      return builders.stepBefore;
    }
    if (lineInterpolation === schema.LineInterpolation.StepAfter) {
      return builders.stepAfter;
    }
    if (lineInterpolation === schema.LineInterpolation.Smooth) {
      return builders.smooth;
    }
  }
  return builders.linear;
}

var __defProp$1h = Object.defineProperty;
var __defProps$W = Object.defineProperties;
var __getOwnPropDescs$W = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1i = Object.getOwnPropertySymbols;
var __hasOwnProp$1i = Object.prototype.hasOwnProperty;
var __propIsEnum$1i = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1h = (obj, key, value) => key in obj ? __defProp$1h(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1h = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1i.call(b, prop))
      __defNormalProp$1h(a, prop, b[prop]);
  if (__getOwnPropSymbols$1i)
    for (var prop of __getOwnPropSymbols$1i(b)) {
      if (__propIsEnum$1i.call(b, prop))
        __defNormalProp$1h(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$W = (a, b) => __defProps$W(a, __getOwnPropDescs$W(b));
function getThresholdsDrawHook(options) {
  const dashSegments = options.config.mode === schema.GraphTresholdsStyleMode.Dashed || options.config.mode === schema.GraphTresholdsStyleMode.DashedAndArea ? [10, 10] : null;
  function addLines(u, yScaleKey, steps, theme2) {
    let ctx = u.ctx;
    let transparentIndex = 0;
    for (let idx = 0; idx < steps.length; idx++) {
      const step = steps[idx];
      if (step.color === "transparent") {
        transparentIndex = idx;
        break;
      }
    }
    ctx.lineWidth = 2;
    if (dashSegments) {
      ctx.setLineDash(dashSegments);
    }
    for (let idx = 1; idx < steps.length; idx++) {
      const step = steps[idx];
      let color;
      if (transparentIndex >= idx && idx > 0) {
        color = tinycolor__default["default"](theme2.visualization.getColorByName(steps[idx - 1].color));
      } else {
        color = tinycolor__default["default"](theme2.visualization.getColorByName(step.color));
      }
      if (color.getAlpha() === 1) {
        color.setAlpha(0.7);
      }
      let x0 = Math.round(u.bbox.left);
      let y0 = Math.round(u.valToPos(step.value, yScaleKey, true));
      let x1 = Math.round(u.bbox.left + u.bbox.width);
      let y1 = Math.round(u.valToPos(step.value, yScaleKey, true));
      ctx.beginPath();
      ctx.moveTo(x0, y0);
      ctx.lineTo(x1, y1);
      ctx.strokeStyle = color.toString();
      ctx.stroke();
    }
  }
  function addAreas(u, yScaleKey, steps, theme2) {
    let ctx = u.ctx;
    let grd = scaleGradient(
      u,
      yScaleKey,
      steps.map((step) => {
        let color = tinycolor__default["default"](theme2.visualization.getColorByName(step.color));
        if (color.getAlpha() === 1) {
          color.setAlpha(0.15);
        }
        return [step.value, color.toString()];
      }),
      true
    );
    ctx.fillStyle = grd;
    ctx.fillRect(u.bbox.left, u.bbox.top, u.bbox.width, u.bbox.height);
  }
  const { scaleKey, thresholds, theme, config, hardMin, hardMax, softMin, softMax } = options;
  return (u) => {
    const ctx = u.ctx;
    const { min: xMin, max: xMax } = u.scales.x;
    const { min: yMin, max: yMax } = u.scales[scaleKey];
    if (xMin == null || xMax == null || yMin == null || yMax == null) {
      return;
    }
    let { steps, mode } = thresholds;
    if (mode === data.ThresholdsMode.Percentage) {
      let [min, max] = getGradientRange(u, scaleKey, hardMin, hardMax, softMin, softMax);
      let range = max - min;
      steps = steps.map((step) => __spreadProps$W(__spreadValues$1h({}, step), {
        value: min + range * (step.value / 100)
      }));
    }
    ctx.save();
    switch (config.mode) {
      case schema.GraphTresholdsStyleMode.Line:
      case schema.GraphTresholdsStyleMode.Dashed:
        addLines(u, scaleKey, steps, theme);
        break;
      case schema.GraphTresholdsStyleMode.Area:
        addAreas(u, scaleKey, steps, theme);
        break;
      case schema.GraphTresholdsStyleMode.LineAndArea:
      case schema.GraphTresholdsStyleMode.DashedAndArea:
        addAreas(u, scaleKey, steps, theme);
        addLines(u, scaleKey, steps, theme);
    }
    ctx.restore();
  };
}

var __defProp$1g = Object.defineProperty;
var __defProps$V = Object.defineProperties;
var __getOwnPropDescs$V = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1h = Object.getOwnPropertySymbols;
var __hasOwnProp$1h = Object.prototype.hasOwnProperty;
var __propIsEnum$1h = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1g = (obj, key, value) => key in obj ? __defProp$1g(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1g = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1h.call(b, prop))
      __defNormalProp$1g(a, prop, b[prop]);
  if (__getOwnPropSymbols$1h)
    for (var prop of __getOwnPropSymbols$1h(b)) {
      if (__propIsEnum$1h.call(b, prop))
        __defNormalProp$1g(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$V = (a, b) => __defProps$V(a, __getOwnPropDescs$V(b));
const cursorDefaults = {
  // prevent client-side zoom from triggering at the end of a selection
  drag: { setScale: false },
  points: {
    /*@ts-ignore*/
    size: (u, seriesIdx) => u.series[seriesIdx].points.size * 2,
    /*@ts-ignore*/
    width: (u, seriesIdx, size) => size / 4
  },
  focus: {
    prox: 30
  }
};
class UPlotConfigBuilder {
  constructor(timeZone = data.DefaultTimeZone) {
    this.series = [];
    this.axes = {};
    this.scales = [];
    this.bands = [];
    this.stackingGroups = [];
    this.hasLeftAxis = false;
    this.hooks = {};
    this.tz = void 0;
    this.sync = false;
    this.mode = 1;
    this.frames = void 0;
    // to prevent more than one threshold per scale
    this.thresholds = {};
    // Custom handler for closest datapoint and series lookup
    this.tooltipInterpolator = void 0;
    this.padding = void 0;
    this.prepData = void 0;
    // Exposed to let the container know the primary scale keys
    this.scaleKeys = ["", ""];
    this.tzDate = (ts) => {
      let date = new Date(ts);
      return this.tz ? uPlot__default["default"].tzDate(date, this.tz) : date;
    };
    var _a;
    this.tz = (_a = data.getTimeZoneInfo(timeZone, Date.now())) == null ? void 0 : _a.ianaName;
  }
  addHook(type, hook) {
    pluginLog("UPlotConfigBuilder", false, "addHook", type);
    if (!this.hooks[type]) {
      this.hooks[type] = [];
    }
    this.hooks[type].push(hook);
  }
  addThresholds(options) {
    if (!this.thresholds[options.scaleKey]) {
      this.thresholds[options.scaleKey] = options;
      this.addHook("drawClear", getThresholdsDrawHook(options));
    }
  }
  addAxis(props) {
    var _a, _b, _c;
    props.placement = (_a = props.placement) != null ? _a : schema.AxisPlacement.Auto;
    props.grid = (_b = props.grid) != null ? _b : {};
    let scaleKey = props.scaleKey;
    if (scaleKey === "x") {
      scaleKey += (_c = props.timeZone) != null ? _c : "";
    }
    if (this.axes[scaleKey]) {
      this.axes[scaleKey].merge(props);
      return;
    }
    if (props.placement === schema.AxisPlacement.Auto) {
      props.placement = this.hasLeftAxis ? schema.AxisPlacement.Right : schema.AxisPlacement.Left;
    }
    if (props.placement === schema.AxisPlacement.Left) {
      this.hasLeftAxis = true;
    }
    if (props.placement === schema.AxisPlacement.Hidden) {
      props.grid.show = false;
      props.size = 0;
    }
    this.axes[scaleKey] = new UPlotAxisBuilder(props);
  }
  getAxisPlacement(scaleKey) {
    var _a;
    const axis = this.axes[scaleKey];
    return (_a = axis == null ? void 0 : axis.props.placement) != null ? _a : schema.AxisPlacement.Left;
  }
  setCursor(cursor) {
    this.cursor = lodash.merge({}, this.cursor, cursor);
  }
  setMode(mode) {
    this.mode = mode;
  }
  setSelect(select) {
    this.select = select;
  }
  addSeries(props) {
    this.series.push(new UPlotSeriesBuilder(props));
  }
  getSeries() {
    return this.series;
  }
  /** Add or update the scale with the scale key */
  addScale(props) {
    const current = this.scales.find((v) => v.props.scaleKey === props.scaleKey);
    if (current) {
      current.merge(props);
      return;
    }
    this.scales.push(new UPlotScaleBuilder(props));
  }
  addBand(band) {
    this.bands.push(band);
  }
  setStackingGroups(groups) {
    this.stackingGroups = groups;
  }
  getStackingGroups() {
    return this.stackingGroups;
  }
  setTooltipInterpolator(interpolator) {
    this.tooltipInterpolator = interpolator;
  }
  getTooltipInterpolator() {
    return this.tooltipInterpolator;
  }
  setPrepData(prepData) {
    this.prepData = (frames) => {
      this.frames = frames;
      return prepData(frames, this.getStackingGroups());
    };
  }
  setSync() {
    this.sync = true;
  }
  hasSync() {
    return this.sync;
  }
  setPadding(padding) {
    this.padding = padding;
  }
  getConfig() {
    const config = __spreadProps$V(__spreadValues$1g({}, DEFAULT_PLOT_CONFIG), {
      mode: this.mode,
      series: [
        this.mode === 2 ? null : {
          value: () => ""
        }
      ]
    });
    config.axes = this.ensureNonOverlappingAxes(Object.values(this.axes)).map((a) => a.getConfig());
    config.series = [...config.series, ...this.series.map((s) => s.getConfig())];
    config.scales = this.scales.reduce((acc, s) => {
      return __spreadValues$1g(__spreadValues$1g({}, acc), s.getConfig());
    }, {});
    config.hooks = this.hooks;
    config.select = this.select;
    const pointColorFn = (alphaHex = "") => (u, seriesIdx) => {
      let s = u.series[seriesIdx].points._stroke;
      if (typeof s !== "string") {
        let field = this.frames[0].fields[seriesIdx];
        s = field.display(field.values.get(u.cursor.idxs[seriesIdx])).color;
      }
      return s + alphaHex;
    };
    config.cursor = lodash.merge(
      {},
      cursorDefaults,
      {
        points: {
          stroke: pointColorFn("80"),
          fill: pointColorFn()
        }
      },
      this.cursor
    );
    config.tzDate = this.tzDate;
    if (Array.isArray(this.padding)) {
      config.padding = this.padding;
    }
    if (this.stackingGroups.length) {
      this.stackingGroups.forEach((group) => {
        getStackingBands(group).forEach((band) => {
          this.addBand(band);
        });
      });
    }
    if (this.bands.length) {
      config.bands = this.bands;
    }
    return config;
  }
  ensureNonOverlappingAxes(axes) {
    const xAxis = axes.find((a) => a.props.scaleKey === "x");
    const axesWithoutGridSet = axes.filter((a) => {
      var _a;
      return ((_a = a.props.grid) == null ? void 0 : _a.show) === void 0;
    });
    const firstValueAxisIdx = axesWithoutGridSet.findIndex(
      (a) => a.props.placement === schema.AxisPlacement.Left || a.props.placement === schema.AxisPlacement.Right || a.props.placement === schema.AxisPlacement.Bottom && a !== xAxis
    );
    for (let i = 0; i < axesWithoutGridSet.length; i++) {
      if (axesWithoutGridSet[i] === xAxis || i === firstValueAxisIdx) {
        axesWithoutGridSet[i].props.grid.show = true;
      } else {
        axesWithoutGridSet[i].props.grid.show = false;
      }
    }
    return axes;
  }
}

var __defProp$1f = Object.defineProperty;
var __defProps$U = Object.defineProperties;
var __getOwnPropDescs$U = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1g = Object.getOwnPropertySymbols;
var __hasOwnProp$1g = Object.prototype.hasOwnProperty;
var __propIsEnum$1g = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1f = (obj, key, value) => key in obj ? __defProp$1f(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1f = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1g.call(b, prop))
      __defNormalProp$1f(a, prop, b[prop]);
  if (__getOwnPropSymbols$1g)
    for (var prop of __getOwnPropSymbols$1g(b)) {
      if (__propIsEnum$1g.call(b, prop))
        __defNormalProp$1f(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$U = (a, b) => __defProps$U(a, __getOwnPropDescs$U(b));
function preparePlotFrame(sparkline, config) {
  var _a;
  const length = sparkline.y.values.length;
  const yFieldConfig = __spreadValues$1f(__spreadValues$1f({}, sparkline.y.config), config);
  return applyNullInsertThreshold({
    frame: {
      refId: "sparkline",
      fields: [
        (_a = sparkline.x) != null ? _a : data.IndexVector.newField(length),
        __spreadProps$U(__spreadValues$1f({}, sparkline.y), {
          config: yFieldConfig
        })
      ],
      length
    }
  });
}

var __defProp$1e = Object.defineProperty;
var __defProps$T = Object.defineProperties;
var __getOwnPropDescs$T = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1f = Object.getOwnPropertySymbols;
var __hasOwnProp$1f = Object.prototype.hasOwnProperty;
var __propIsEnum$1f = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1e = (obj, key, value) => key in obj ? __defProp$1e(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1e = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1f.call(b, prop))
      __defNormalProp$1e(a, prop, b[prop]);
  if (__getOwnPropSymbols$1f)
    for (var prop of __getOwnPropSymbols$1f(b)) {
      if (__propIsEnum$1f.call(b, prop))
        __defNormalProp$1e(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$T = (a, b) => __defProps$T(a, __getOwnPropDescs$T(b));
const defaultConfig$1 = {
  drawStyle: schema.GraphDrawStyle.Line,
  showPoints: schema.VisibilityMode.Auto,
  axisPlacement: schema.AxisPlacement.Hidden,
  pointSize: 2
};
class Sparkline extends React.PureComponent {
  constructor(props) {
    super(props);
    const alignedDataFrame = preparePlotFrame(props.sparkline, props.config);
    this.state = {
      data: preparePlotData2(alignedDataFrame, getStackingGroups(alignedDataFrame)),
      alignedDataFrame,
      configBuilder: this.prepareConfig(alignedDataFrame)
    };
  }
  static getDerivedStateFromProps(props, state) {
    const frame = preparePlotFrame(props.sparkline, props.config);
    if (!frame) {
      return __spreadValues$1e({}, state);
    }
    return __spreadProps$T(__spreadValues$1e({}, state), {
      data: preparePlotData2(frame, getStackingGroups(frame)),
      alignedDataFrame: frame
    });
  }
  componentDidUpdate(prevProps, prevState) {
    const { alignedDataFrame } = this.state;
    if (!alignedDataFrame) {
      return;
    }
    let rebuildConfig = false;
    if (prevProps.sparkline !== this.props.sparkline) {
      rebuildConfig = !data.compareDataFrameStructures(this.state.alignedDataFrame, prevState.alignedDataFrame);
    } else {
      rebuildConfig = !lodash.isEqual(prevProps.config, this.props.config);
    }
    if (rebuildConfig) {
      this.setState({ configBuilder: this.prepareConfig(alignedDataFrame) });
    }
  }
  getYRange(field) {
    var _a, _b, _c;
    let { min, max } = (_a = this.state.alignedDataFrame.fields[1].state) == null ? void 0 : _a.range;
    if (min === max) {
      if (min === 0) {
        max = 100;
      } else {
        min = 0;
        max *= 2;
      }
      return [min, max];
    }
    return [Math.max(min, (_b = field.config.min) != null ? _b : -Infinity), Math.min(max, (_c = field.config.max) != null ? _c : Infinity)];
  }
  prepareConfig(data$1) {
    var _a;
    const { theme } = this.props;
    const builder = new UPlotConfigBuilder();
    builder.setCursor({
      show: false,
      x: false,
      // no crosshairs
      y: false
    });
    const xField = data$1.fields[0];
    builder.addScale({
      scaleKey: "x",
      orientation: schema.ScaleOrientation.Horizontal,
      direction: schema.ScaleDirection.Right,
      isTime: false,
      //xField.type === FieldType.time,
      range: () => {
        const { sparkline } = this.props;
        if (sparkline.x) {
          if (sparkline.timeRange && sparkline.x.type === data.FieldType.time) {
            return [sparkline.timeRange.from.valueOf(), sparkline.timeRange.to.valueOf()];
          }
          const vals = sparkline.x.values;
          return [vals.get(0), vals.get(vals.length - 1)];
        }
        return [0, sparkline.y.values.length - 1];
      }
    });
    builder.addAxis({
      scaleKey: "x",
      theme,
      placement: schema.AxisPlacement.Hidden
    });
    for (let i = 0; i < data$1.fields.length; i++) {
      const field = data$1.fields[i];
      const config = field.config;
      const customConfig = __spreadValues$1e(__spreadValues$1e({}, defaultConfig$1), config.custom);
      if (field === xField || field.type !== data.FieldType.number) {
        continue;
      }
      const scaleKey = config.unit || "__fixed";
      builder.addScale({
        scaleKey,
        orientation: schema.ScaleOrientation.Vertical,
        direction: schema.ScaleDirection.Up,
        range: () => this.getYRange(field)
      });
      builder.addAxis({
        scaleKey,
        theme,
        placement: schema.AxisPlacement.Hidden
      });
      const colorMode = data.getFieldColorModeForField(field);
      const seriesColor = colorMode.getCalculator(field, theme)(0, 0);
      const pointsMode = customConfig.drawStyle === schema.GraphDrawStyle.Points ? schema.VisibilityMode.Always : customConfig.showPoints;
      builder.addSeries({
        pxAlign: false,
        scaleKey,
        theme,
        colorMode,
        thresholds: config.thresholds,
        drawStyle: customConfig.drawStyle,
        lineColor: (_a = customConfig.lineColor) != null ? _a : seriesColor,
        lineWidth: customConfig.lineWidth,
        lineInterpolation: customConfig.lineInterpolation,
        showPoints: pointsMode,
        pointSize: customConfig.pointSize,
        fillOpacity: customConfig.fillOpacity,
        fillColor: customConfig.fillColor,
        lineStyle: customConfig.lineStyle,
        gradientMode: customConfig.gradientMode
      });
    }
    return builder;
  }
  render() {
    const { data, configBuilder } = this.state;
    const { width, height, sparkline } = this.props;
    return /* @__PURE__ */ React__default["default"].createElement(UPlotChart, { data, config: configBuilder, width, height, timeRange: sparkline.timeRange });
  }
}

var __defProp$1d = Object.defineProperty;
var __defProps$S = Object.defineProperties;
var __getOwnPropDescs$S = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1e = Object.getOwnPropertySymbols;
var __hasOwnProp$1e = Object.prototype.hasOwnProperty;
var __propIsEnum$1e = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1d = (obj, key, value) => key in obj ? __defProp$1d(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1d = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1e.call(b, prop))
      __defNormalProp$1d(a, prop, b[prop]);
  if (__getOwnPropSymbols$1e)
    for (var prop of __getOwnPropSymbols$1e(b)) {
      if (__propIsEnum$1e.call(b, prop))
        __defNormalProp$1d(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$S = (a, b) => __defProps$S(a, __getOwnPropDescs$S(b));
const defaultSparklineCellConfig = {
  drawStyle: schema.GraphDrawStyle.Line,
  lineInterpolation: schema.LineInterpolation.Smooth,
  lineWidth: 1,
  fillOpacity: 17,
  gradientMode: schema.GraphGradientMode.Hue,
  pointSize: 2,
  barAlignment: schema.BarAlignment.Center,
  showPoints: schema.VisibilityMode.Never
};
const SparklineCell = (props) => {
  const { field, innerWidth, tableStyles, cell, cellProps } = props;
  const sparkline = getSparkline(cell.value);
  if (!sparkline) {
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$S(__spreadValues$1d({}, cellProps), { className: tableStyles.cellContainer }), "no data");
  }
  const range = data.getMinMaxAndDelta(sparkline.y);
  sparkline.y.config.min = range.min;
  sparkline.y.config.max = range.max;
  sparkline.y.state = { range };
  const cellOptions = getTableSparklineCellOptions(field);
  const config = {
    color: field.config.color,
    custom: __spreadValues$1d(__spreadValues$1d({}, defaultSparklineCellConfig), cellOptions)
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$S(__spreadValues$1d({}, cellProps), { className: tableStyles.cellContainer }), /* @__PURE__ */ React__default["default"].createElement(
    Sparkline,
    {
      width: innerWidth,
      height: tableStyles.cellHeightInner,
      sparkline,
      config,
      theme: tableStyles.theme
    }
  ));
};
function getSparkline(value) {
  if (lodash.isArray(value)) {
    return {
      y: {
        name: "test",
        type: data.FieldType.number,
        values: new data.ArrayVector(value),
        config: {}
      }
    };
  }
  if (data.isDataFrame(value)) {
    const timeField = value.fields.find((x) => x.type === data.FieldType.time);
    const numberField = value.fields.find((x) => x.type === data.FieldType.number);
    if (timeField && numberField) {
      return { x: timeField, y: numberField };
    }
  }
  return;
}
function getTableSparklineCellOptions(field) {
  let options = getCellOptions(field);
  if (options.type === schema.TableCellDisplayMode.Auto) {
    options = __spreadProps$S(__spreadValues$1d({}, options), { type: schema.TableCellDisplayMode.Sparkline });
  }
  if (options.type === schema.TableCellDisplayMode.Sparkline) {
    return options;
  }
  throw new Error(`Excpected options type ${schema.TableCellDisplayMode.Sparkline} but got ${options.type}`);
}

const EXPANDER_WIDTH = 50;
function getTextAlign(field) {
  if (!field) {
    return "flex-start";
  }
  if (field.config.custom) {
    const custom = field.config.custom;
    switch (custom.align) {
      case "right":
        return "flex-end";
      case "left":
        return "flex-start";
      case "center":
        return "center";
    }
  }
  if (field.type === data.FieldType.number) {
    return "flex-end";
  }
  return "flex-start";
}
function getColumns(data$1, availableWidth, columnMinWidth, expander, footerValues, isCountRowsSet) {
  var _a, _b;
  const columns = [];
  let fieldCountWithoutWidth = 0;
  if (expander) {
    columns.push({
      // Make an expander cell
      Header: () => null,
      // No header
      id: "expander",
      // It needs an ID
      Cell: RowExpander,
      width: EXPANDER_WIDTH,
      minWidth: EXPANDER_WIDTH,
      filter: (_rows, _id, _filterValues) => {
        return [];
      },
      justifyContent: "left",
      field: data$1.fields[0],
      sortType: "basic"
    });
    availableWidth -= EXPANDER_WIDTH;
  }
  for (const [fieldIndex, field] of data$1.fields.entries()) {
    const fieldTableOptions = field.config.custom || {};
    if (fieldTableOptions.hidden) {
      continue;
    }
    if (fieldTableOptions.width) {
      availableWidth -= fieldTableOptions.width;
    } else {
      fieldCountWithoutWidth++;
    }
    const selectSortType = (type) => {
      switch (type) {
        case data.FieldType.number:
          return "number";
        case data.FieldType.time:
          return "basic";
        default:
          return "alphanumeric-insensitive";
      }
    };
    const Cell = getCellComponent((_a = fieldTableOptions.cellOptions) == null ? void 0 : _a.type, field);
    columns.push({
      Cell,
      id: fieldIndex.toString(),
      field,
      Header: data.getFieldDisplayName(field, data$1),
      accessor: (_row, i) => {
        return field.values.get(i);
      },
      sortType: selectSortType(field.type),
      width: fieldTableOptions.width,
      minWidth: (_b = fieldTableOptions.minWidth) != null ? _b : columnMinWidth,
      filter: memoizeOne__default["default"](filterByValue(field)),
      justifyContent: getTextAlign(field),
      Footer: getFooterValue(fieldIndex, footerValues, isCountRowsSet)
    });
  }
  let sharedWidth = availableWidth / fieldCountWithoutWidth;
  for (let i = fieldCountWithoutWidth; i > 0; i--) {
    for (const column of columns) {
      if (!column.width && column.minWidth > sharedWidth) {
        column.width = column.minWidth;
        availableWidth -= column.width;
        fieldCountWithoutWidth -= 1;
        sharedWidth = availableWidth / fieldCountWithoutWidth;
      }
    }
  }
  for (const column of columns) {
    if (!column.width) {
      column.width = sharedWidth;
    }
    column.minWidth = 50;
  }
  return columns;
}
function getCellComponent(displayMode, field) {
  switch (displayMode) {
    case schema.TableCellDisplayMode.ColorText:
    case schema.TableCellDisplayMode.ColorBackground:
      return DefaultCell;
    case schema.TableCellDisplayMode.Image:
      return ImageCell;
    case schema.TableCellDisplayMode.Gauge:
      return BarGaugeCell;
    case schema.TableCellDisplayMode.Sparkline:
      return SparklineCell;
    case schema.TableCellDisplayMode.JSONView:
      return JSONViewCell;
  }
  if (field.type === data.FieldType.geo) {
    return GeoCell;
  }
  if (field.type === data.FieldType.frame) {
    const firstValue = field.values.get(0);
    if (data.isDataFrame(firstValue) && data.isTimeSeriesFrame(firstValue)) {
      return SparklineCell;
    }
    return JSONViewCell;
  }
  if (field.type === data.FieldType.other) {
    return JSONViewCell;
  }
  return DefaultCell;
}
function filterByValue(field) {
  return function(rows, id, filterValues) {
    if (rows.length === 0) {
      return rows;
    }
    if (!filterValues) {
      return rows;
    }
    if (!field) {
      return rows;
    }
    return rows.filter((row) => {
      if (!row.values.hasOwnProperty(id)) {
        return false;
      }
      const value = rowToFieldValue(row, field);
      return filterValues.find((filter) => filter.value === value) !== void 0;
    });
  };
}
function calculateUniqueFieldValues(rows, field) {
  if (!field || rows.length === 0) {
    return {};
  }
  const set = {};
  for (let index = 0; index < rows.length; index++) {
    const value = rowToFieldValue(rows[index], field);
    set[value || "(Blanks)"] = value;
  }
  return set;
}
function rowToFieldValue(row, field) {
  if (!field || !row) {
    return "";
  }
  const fieldValue = field.values.get(row.index);
  const displayValue = field.display ? field.display(fieldValue) : fieldValue;
  const value = field.display ? data.formattedValueToString(displayValue) : displayValue;
  return value;
}
function valuesToOptions(unique) {
  return Object.keys(unique).reduce((all, key) => all.concat({ value: unique[key], label: key }), []).sort(sortOptions);
}
function sortOptions(a, b) {
  if (a.label === void 0 && b.label === void 0) {
    return 0;
  }
  if (a.label === void 0 && b.label !== void 0) {
    return -1;
  }
  if (a.label !== void 0 && b.label === void 0) {
    return 1;
  }
  if (a.label < b.label) {
    return -1;
  }
  if (a.label > b.label) {
    return 1;
  }
  return 0;
}
function getFilteredOptions(options, filterValues) {
  if (!filterValues) {
    return [];
  }
  return options.filter((option) => filterValues.some((filtered) => filtered.value === option.value));
}
function sortCaseInsensitive(a, b, id) {
  return String(a.values[id]).localeCompare(String(b.values[id]), void 0, { sensitivity: "base" });
}
function sortNumber(rowA, rowB, id) {
  const a = toNumber(rowA.values[id]);
  const b = toNumber(rowB.values[id]);
  return a === b ? 0 : a > b ? 1 : -1;
}
function toNumber(value) {
  if (value === null || value === void 0 || value === "" || isNaN(value)) {
    return Number.NEGATIVE_INFINITY;
  }
  if (typeof value === "number") {
    return value;
  }
  return Number(value);
}
function getFooterItems(filterFields, values, options, theme2) {
  addMissingColumnIndex(filterFields);
  return filterFields.map((data$1, i) => {
    var _a;
    if (((_a = data$1 == null ? void 0 : data$1.field) == null ? void 0 : _a.type) !== data.FieldType.number) {
      if (i === 0 && options.reducer && options.reducer.length > 0) {
        const reducer = data.fieldReducers.get(options.reducer[0]);
        return reducer.name;
      }
      return void 0;
    }
    let newField = lodash.clone(data$1.field);
    newField.values = new data.ArrayVector(values[data$1.id]);
    newField.state = void 0;
    data$1.field = newField;
    if (options.fields && options.fields.length > 0) {
      const f = options.fields.find((f2) => {
        var _a2;
        return f2 === ((_a2 = data$1 == null ? void 0 : data$1.field) == null ? void 0 : _a2.name);
      });
      if (f) {
        return getFormattedValue(data$1.field, options.reducer, theme2);
      }
      return void 0;
    }
    return getFormattedValue(data$1.field, options.reducer || [], theme2);
  });
}
function getFormattedValue(field, reducer, theme) {
  var _a;
  const fmt = (_a = field.display) != null ? _a : data.getDisplayProcessor({ field, theme });
  const calc = reducer[0];
  const v = data.reduceField({ field, reducers: reducer })[calc];
  return data.formattedValueToString(fmt(v));
}
function createFooterCalculationValues(rows) {
  const values = [];
  for (const key in rows) {
    for (const [valKey, val] of Object.entries(rows[key].values)) {
      if (values[valKey] === void 0) {
        values[valKey] = [];
      }
      values[valKey].push(val);
    }
  }
  return values;
}
const defaultCellOptions = { type: schema.TableCellDisplayMode.Auto };
function getCellOptions(field) {
  var _a, _b, _c;
  if ((_a = field.config.custom) == null ? void 0 : _a.displayMode) {
    return migrateTableDisplayModeToCellOptions((_b = field.config.custom) == null ? void 0 : _b.displayMode);
  }
  if (!((_c = field.config.custom) == null ? void 0 : _c.cellOptions)) {
    return defaultCellOptions;
  }
  return field.config.custom.cellOptions;
}
function migrateTableDisplayModeToCellOptions(displayMode) {
  switch (displayMode) {
    case "basic":
    case "gradient-gauge":
    case "lcd-gauge":
      let gaugeMode = schema.BarGaugeDisplayMode.Basic;
      if (displayMode === "gradient-gauge") {
        gaugeMode = schema.BarGaugeDisplayMode.Gradient;
      } else if (displayMode === "lcd-gauge") {
        gaugeMode = schema.BarGaugeDisplayMode.Lcd;
      }
      return {
        type: schema.TableCellDisplayMode.Gauge,
        mode: gaugeMode
      };
    case "color-background":
    case "color-background-solid":
      let mode = schema.TableCellBackgroundDisplayMode.Basic;
      if (displayMode === "color-background") {
        mode = schema.TableCellBackgroundDisplayMode.Gradient;
      }
      return {
        type: schema.TableCellDisplayMode.ColorBackground,
        mode
      };
    default:
      return {
        // @ts-ignore
        type: displayMode
      };
  }
}
function addMissingColumnIndex(columns) {
  const missingIndex = columns.findIndex((field, index) => (field == null ? void 0 : field.id) !== String(index));
  if (missingIndex === -1) {
    return;
  }
  columns.splice(missingIndex, 0, { id: String(missingIndex) });
  addMissingColumnIndex(columns);
}

const FilterPopup = ({ column: { preFilteredRows, filterValue, setFilter }, onClose, field }) => {
  const theme = useTheme2();
  const uniqueValues = React.useMemo(() => calculateUniqueFieldValues(preFilteredRows, field), [preFilteredRows, field]);
  const options = React.useMemo(() => valuesToOptions(uniqueValues), [uniqueValues]);
  const filteredOptions = React.useMemo(() => getFilteredOptions(options, filterValue), [options, filterValue]);
  const [values, setValues] = React.useState(filteredOptions);
  const [matchCase, setMatchCase] = React.useState(false);
  const onCancel = React.useCallback((event) => onClose(), [onClose]);
  const onFilter = React.useCallback(
    (event) => {
      const filtered = values.length ? values : void 0;
      setFilter(filtered);
      onClose();
    },
    [setFilter, values, onClose]
  );
  const onClearFilter = React.useCallback(
    (event) => {
      setFilter(void 0);
      onClose();
    },
    [setFilter, onClose]
  );
  const clearFilterVisible = React.useMemo(() => filterValue !== void 0, [filterValue]);
  const styles = useStyles2(getStyles$S);
  return /* @__PURE__ */ React__default["default"].createElement(ClickOutsideWrapper, { onClick: onCancel, useCapture: true }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.filterContainer), onClick: stopPropagation }, /* @__PURE__ */ React__default["default"].createElement(VerticalGroup, { spacing: "lg" }, /* @__PURE__ */ React__default["default"].createElement(VerticalGroup, { spacing: "xs" }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { justify: "space-between", align: "center" }, /* @__PURE__ */ React__default["default"].createElement(Label$1, { className: styles.label }, "Filter by values:"), /* @__PURE__ */ React__default["default"].createElement(
    IconButton,
    {
      name: "text-fields",
      tooltip: "Match case",
      style: { color: matchCase ? theme.colors.text.link : theme.colors.text.disabled },
      onClick: () => {
        setMatchCase((s) => !s);
      }
    }
  )), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.listDivider) }), /* @__PURE__ */ React__default["default"].createElement(FilterList, { onChange: setValues, values, options, caseSensitive: matchCase })), /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { spacing: "lg" }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, null, /* @__PURE__ */ React__default["default"].createElement(Button, { size: "sm", onClick: onFilter }, "Ok"), /* @__PURE__ */ React__default["default"].createElement(Button, { size: "sm", variant: "secondary", onClick: onCancel }, "Cancel")), clearFilterVisible && /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, null, /* @__PURE__ */ React__default["default"].createElement(Button, { fill: "text", size: "sm", onClick: onClearFilter }, "Clear filter"))))));
};
const getStyles$S = (theme) => ({
  filterContainer: css.css`
    label: filterContainer;
    width: 100%;
    min-width: 250px;
    height: 100%;
    max-height: 400px;
    background-color: ${theme.colors.background.primary};
    border: 1px solid ${theme.colors.border.weak};
    padding: ${theme.spacing(2)};
    margin: ${theme.spacing(1)} 0;
    box-shadow: ${theme.shadows.z3};
    border-radius: ${theme.shape.radius.default};
  `,
  listDivider: css.css`
    label: listDivider;
    width: 100%;
    border-top: 1px solid ${theme.colors.border.medium};
    padding: ${theme.spacing(0.5, 2)};
  `,
  label: css.css`
    margin-bottom: 0;
  `
});
const stopPropagation = (event) => {
  event.stopPropagation();
};

const Filter = ({ column, field, tableStyles }) => {
  var _a;
  const ref = React.useRef(null);
  const [isPopoverVisible, setPopoverVisible] = React.useState(false);
  const styles = useStyles2(getStyles$R);
  const filterEnabled = React.useMemo(() => Boolean(column.filterValue), [column.filterValue]);
  const onShowPopover = React.useCallback(() => setPopoverVisible(true), [setPopoverVisible]);
  const onClosePopover = React.useCallback(() => setPopoverVisible(false), [setPopoverVisible]);
  if (!field || !((_a = field.config.custom) == null ? void 0 : _a.filterable)) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      className: css.cx(tableStyles.headerFilter, filterEnabled ? styles.filterIconEnabled : styles.filterIconDisabled),
      ref,
      type: "button",
      onClick: onShowPopover
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "filter" }),
    isPopoverVisible && ref.current && /* @__PURE__ */ React__default["default"].createElement(
      Popover,
      {
        content: /* @__PURE__ */ React__default["default"].createElement(FilterPopup, { column, tableStyles, field, onClose: onClosePopover }),
        placement: "bottom-start",
        referenceElement: ref.current,
        show: true
      }
    )
  );
};
const getStyles$R = (theme) => ({
  filterIconEnabled: css.css`
    label: filterIconEnabled;
    color: ${theme.colors.primary.text};
  `,
  filterIconDisabled: css.css`
    label: filterIconDisabled;
    color: ${theme.colors.text.disabled};
  `
});

var __defProp$1c = Object.defineProperty;
var __defProps$R = Object.defineProperties;
var __getOwnPropDescs$R = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1d = Object.getOwnPropertySymbols;
var __hasOwnProp$1d = Object.prototype.hasOwnProperty;
var __propIsEnum$1d = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1c = (obj, key, value) => key in obj ? __defProp$1c(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1c = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1d.call(b, prop))
      __defNormalProp$1c(a, prop, b[prop]);
  if (__getOwnPropSymbols$1d)
    for (var prop of __getOwnPropSymbols$1d(b)) {
      if (__propIsEnum$1d.call(b, prop))
        __defNormalProp$1c(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$R = (a, b) => __defProps$R(a, __getOwnPropDescs$R(b));
var __objRest$G = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1d.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1d)
    for (var prop of __getOwnPropSymbols$1d(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1d.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const HeaderRow = (props) => {
  const { headerGroups, showTypeIcons, tableStyles } = props;
  const e2eSelectorsTable = e2eSelectors.selectors.components.Panels.Visualization.Table;
  return /* @__PURE__ */ React__default["default"].createElement("div", { role: "rowgroup", className: tableStyles.headerRow }, headerGroups.map((headerGroup) => {
    const _a = headerGroup.getHeaderGroupProps(), { key } = _a, headerGroupProps = __objRest$G(_a, ["key"]);
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      __spreadProps$R(__spreadValues$1c({
        className: tableStyles.thead
      }, headerGroupProps), {
        key,
        "aria-label": e2eSelectorsTable.header,
        role: "row"
      }),
      headerGroup.headers.map(
        (column, index) => renderHeaderCell(column, tableStyles, showTypeIcons)
      )
    );
  }));
};
function renderHeaderCell(column, tableStyles, showTypeIcons) {
  var _a;
  const headerProps = column.getHeaderProps();
  const field = (_a = column.field) != null ? _a : null;
  if (column.canResize) {
    headerProps.style.userSelect = column.isResizing ? "none" : "auto";
  }
  headerProps.style.position = "absolute";
  headerProps.style.justifyContent = column.justifyContent;
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$R(__spreadValues$1c({ className: tableStyles.headerCell }, headerProps), { role: "columnheader" }), column.canSort && /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("button", __spreadProps$R(__spreadValues$1c({}, column.getSortByToggleProps()), { className: tableStyles.headerCellLabel }), showTypeIcons && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: getFieldTypeIcon(field), title: field == null ? void 0 : field.type, size: "sm", className: tableStyles.typeIcon }), /* @__PURE__ */ React__default["default"].createElement("div", null, column.render("Header")), column.isSorted && (column.isSortedDesc ? /* @__PURE__ */ React__default["default"].createElement(Icon, { size: "lg", name: "arrow-down", className: tableStyles.sortIcon }) : /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "arrow-up", size: "lg", className: tableStyles.sortIcon }))), column.canFilter && /* @__PURE__ */ React__default["default"].createElement(Filter, { column, tableStyles, field })), !column.canSort && column.render("Header"), !column.canSort && column.canFilter && /* @__PURE__ */ React__default["default"].createElement(Filter, { column, tableStyles, field }), column.canResize && /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$R(__spreadValues$1c({}, column.getResizerProps()), { className: tableStyles.resizeHandle })));
}

const TableCell = ({ cell, tableStyles, onCellFilterAdded, userProps }) => {
  var _a;
  const cellProps = cell.getCellProps();
  const field = cell.column.field;
  if (!(field == null ? void 0 : field.display)) {
    return null;
  }
  if (cellProps.style) {
    cellProps.style.minWidth = cellProps.style.width;
    cellProps.style.justifyContent = cell.column.justifyContent;
  }
  let innerWidth = ((_a = cell.column.width) != null ? _a : 24) - tableStyles.cellPadding * 2;
  return cell.render("Cell", {
    field,
    tableStyles,
    onCellFilterAdded,
    cellProps,
    innerWidth,
    userProps
  });
};

function useFixScrollbarContainer(variableSizeListScrollbarRef, tableDivRef) {
  React.useEffect(() => {
    var _a, _b, _c;
    const listVerticalScrollbarHTML = (_a = variableSizeListScrollbarRef.current) == null ? void 0 : _a.querySelector(
      ".track-vertical"
    );
    const tableScrollbarView = (_b = tableDivRef.current) == null ? void 0 : _b.firstChild;
    if (tableScrollbarView && listVerticalScrollbarHTML) {
      listVerticalScrollbarHTML == null ? void 0 : listVerticalScrollbarHTML.remove();
      (_c = tableScrollbarView.querySelector(":scope > .track-vertical")) == null ? void 0 : _c.remove();
      tableScrollbarView.append(listVerticalScrollbarHTML);
    }
  });
}
function useResetVariableListSizeCache(extendedState, listRef, data) {
  React.useEffect(() => {
    var _a;
    if (extendedState.lastExpandedIndex !== void 0) {
      (_a = listRef.current) == null ? void 0 : _a.resetAfterIndex(Math.max(extendedState.lastExpandedIndex - 1, 0));
      return;
    }
  }, [extendedState.lastExpandedIndex, extendedState.toggleRowExpandedCounter, listRef, data]);
}

var __defProp$1b = Object.defineProperty;
var __defProps$Q = Object.defineProperties;
var __getOwnPropDescs$Q = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1c = Object.getOwnPropertySymbols;
var __hasOwnProp$1c = Object.prototype.hasOwnProperty;
var __propIsEnum$1c = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1b = (obj, key, value) => key in obj ? __defProp$1b(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1b = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1c.call(b, prop))
      __defNormalProp$1b(a, prop, b[prop]);
  if (__getOwnPropSymbols$1c)
    for (var prop of __getOwnPropSymbols$1c(b)) {
      if (__propIsEnum$1c.call(b, prop))
        __defNormalProp$1b(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$Q = (a, b) => __defProps$Q(a, __getOwnPropDescs$Q(b));
function useTableStateReducer({ onColumnResize, onSortByChange, data: data$1 }) {
  return React.useCallback(
    (newState, action) => {
      switch (action.type) {
        case "columnDoneResizing":
          if (onColumnResize) {
            const info = newState.columnResizing.headerIdWidths[0];
            const columnIdString = info[0];
            const fieldIndex = parseInt(columnIdString, 10);
            const width = Math.round(newState.columnResizing.columnWidths[columnIdString]);
            const field = data$1.fields[fieldIndex];
            if (!field) {
              return newState;
            }
            const fieldDisplayName = data.getFieldDisplayName(field, data$1);
            onColumnResize(fieldDisplayName, width);
          }
        case "toggleSortBy":
          if (onSortByChange) {
            const sortByFields = [];
            for (const sortItem of newState.sortBy) {
              const field = data$1.fields[parseInt(sortItem.id, 10)];
              if (!field) {
                continue;
              }
              sortByFields.push({
                displayName: data.getFieldDisplayName(field, data$1),
                desc: sortItem.desc
              });
            }
            onSortByChange(sortByFields);
          }
        case "toggleRowExpanded": {
          if (action.id) {
            return __spreadProps$Q(__spreadValues$1b({}, newState), {
              lastExpandedIndex: parseInt(action.id, 10),
              toggleRowExpandedCounter: newState.toggleRowExpandedCounter + 1
            });
          }
        }
      }
      return newState;
    },
    [data$1, onColumnResize, onSortByChange]
  );
}
function getInitialState(initialSortBy, columns) {
  const state = {
    toggleRowExpandedCounter: 0
  };
  if (initialSortBy) {
    state.sortBy = [];
    for (const sortBy of initialSortBy) {
      for (const col of columns) {
        if (col.Header === sortBy.displayName) {
          state.sortBy.push({ id: col.id, desc: sortBy.desc });
        }
      }
    }
  }
  return state;
}

function useTableStyles(theme, cellHeightOption) {
  const borderColor = theme.colors.border.weak;
  const resizerColor = theme.colors.primary.border;
  const cellPadding = 6;
  const cellHeight = getCellHeight(theme, cellHeightOption, cellPadding);
  const rowHeight = cellHeight + 2;
  const headerHeight = 28;
  const rowHoverBg = theme.colors.emphasize(theme.colors.background.primary, 0.03);
  const buildCellContainerStyle = (color, background, overflowOnHover) => {
    const cellActionsOverflow = {
      margin: theme.spacing(0, -0.5, 0, 0.5)
    };
    const cellActionsNoOverflow = {
      position: "absolute",
      top: 0,
      right: 0,
      margin: "auto"
    };
    const onHoverOverflow = {
      overflow: "visible",
      width: "auto !important",
      boxShadow: `0 0 2px ${theme.colors.primary.main}`,
      background: background != null ? background : rowHoverBg,
      zIndex: 1
    };
    return css.css`
      label: ${overflowOnHover ? "cellContainerOverflow" : "cellContainerNoOverflow"};
      padding: ${cellPadding}px;
      width: 100%;
      // Cell height need to account for row border
      height: ${rowHeight - 1}px;
      display: flex;
      align-items: center;
      border-right: 1px solid ${borderColor};

      ${color ? `color: ${color};` : ""};
      ${background ? `background: ${background};` : ""};
      background-clip: padding-box;

      &:last-child:not(:only-child) {
        border-right: none;
      }

      &:hover {
        ${overflowOnHover && onHoverOverflow};
        .cellActions {
          visibility: visible;
          opacity: 1;
          width: auto;
        }
      }

      a {
        color: inherit;
      }

      .cellActions {
        display: flex;
        ${overflowOnHover ? cellActionsOverflow : cellActionsNoOverflow}
        visibility: hidden;
        opacity: 0;
        width: 0;
        align-items: center;
        height: 100%;
        padding: ${theme.spacing(1, 0.5, 1, 0.5)};
        background: ${background ? "none" : theme.colors.emphasize(theme.colors.background.primary, 0.03)};

        svg {
          color: ${color};
        }
      }

      .cellActionsLeft {
        right: auto !important;
        left: 0;
      }

      .cellActionsTransparent {
        background: none;
      }
    `;
  };
  return {
    theme,
    cellHeight,
    buildCellContainerStyle,
    cellPadding,
    cellHeightInner: cellHeight - cellPadding * 2,
    rowHeight,
    table: css.css`
      height: 100%;
      width: 100%;
      overflow: auto;
      display: flex;
      flex-direction: column;
    `,
    thead: css.css`
      label: thead;
      height: ${headerHeight}px;
      overflow-y: auto;
      overflow-x: hidden;
      position: relative;
    `,
    tfoot: css.css`
      label: tfoot;
      height: ${headerHeight}px;
      border-top: 1px solid ${borderColor};
      overflow-y: auto;
      overflow-x: hidden;
      position: relative;
    `,
    headerRow: css.css`
      label: row;
      border-bottom: 1px solid ${borderColor};
    `,
    headerCell: css.css`
      height: 100%;
      padding: 0 ${cellPadding}px;
      overflow: hidden;
      white-space: nowrap;
      display: flex;
      align-items: center;
      font-weight: ${theme.typography.fontWeightMedium};

      &:last-child {
        border-right: none;
      }
    `,
    headerCellLabel: css.css`
      border: none;
      padding: 0;
      background: inherit;
      cursor: pointer;
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      font-weight: ${theme.typography.fontWeightMedium};
      display: flex;
      align-items: center;
      margin-right: ${theme.spacing(0.5)};

      &:hover {
        text-decoration: underline;
        color: ${theme.colors.text.link};
      }
    `,
    cellContainer: buildCellContainerStyle(void 0, void 0, true),
    cellContainerNoOverflow: buildCellContainerStyle(void 0, void 0, false),
    cellText: css.css`
      overflow: hidden;
      text-overflow: ellipsis;
      user-select: text;
      white-space: nowrap;
    `,
    sortIcon: css.css`
      margin-left: ${theme.spacing(0.5)};
    `,
    cellLink: css.css`
      cursor: pointer;
      overflow: hidden;
      text-overflow: ellipsis;
      user-select: text;
      white-space: nowrap;
      color: ${theme.colors.text.link};
      font-weight: ${theme.typography.fontWeightMedium};
      &:hover {
        text-decoration: underline;
        color: ${theme.colors.text.link};
      }
    `,
    cellLinkForColoredCell: css.css`
      cursor: pointer;
      overflow: hidden;
      text-overflow: ellipsis;
      user-select: text;
      white-space: nowrap;
      font-weight: ${theme.typography.fontWeightMedium};
      text-decoration: underline;
    `,
    imageCellLink: css.css`
      cursor: pointer;
      overflow: hidden;
      height: 100%;
    `,
    headerFilter: css.css`
      background: transparent;
      border: none;
      label: headerFilter;
      padding: 0;
    `,
    paginationWrapper: css.css`
      display: flex;
      height: ${cellHeight}px;
      justify-content: center;
      align-items: center;
      width: 100%;
      li {
        margin-bottom: 0;
      }
    `,
    paginationSummary: css.css`
      color: ${theme.colors.text.secondary};
      font-size: ${theme.typography.bodySmall.fontSize};
      display: flex;
      justify-content: flex-end;
      padding: ${theme.spacing(0, 1, 0, 2)};
    `,
    tableContentWrapper: (totalColumnsWidth) => {
      const width = totalColumnsWidth !== void 0 ? `${totalColumnsWidth}px` : "100%";
      return css.css`
        label: tableContentWrapper;
        width: ${width};
        display: flex;
        flex-direction: column;
      `;
    },
    row: css.css`
      label: row;
      border-bottom: 1px solid ${borderColor};

      &:hover {
        background-color: ${rowHoverBg};
      }

      &:last-child {
        border-bottom: 0;
      }
    `,
    imageCell: css.css`
      height: 100%;
    `,
    resizeHandle: css.css`
      label: resizeHandle;
      cursor: col-resize !important;
      display: inline-block;
      background: ${resizerColor};
      opacity: 0;
      transition: opacity 0.2s ease-in-out;
      width: 8px;
      height: 100%;
      position: absolute;
      right: -4px;
      border-radius: ${theme.shape.radius.default};
      top: 0;
      touch-action: none;

      &:hover {
        opacity: 1;
      }
    `,
    typeIcon: css.css`
      margin-right: ${theme.spacing(1)};
      color: ${theme.colors.text.secondary};
    `,
    noData: css.css`
      align-items: center;
      display: flex;
      height: 100%;
      justify-content: center;
      width: 100%;
    `,
    expanderCell: css.css`
      display: flex;
      flex-direction: column;
      justify-content: center;
      height: ${rowHeight}px;
      cursor: pointer;
    `
  };
}
function getCellHeight(theme, cellHeightOption, cellPadding) {
  const bodyFontSize = theme.typography.fontSize;
  const lineHeight = theme.typography.body.lineHeight;
  switch (cellHeightOption) {
    case "md":
      return 42;
    case "lg":
      return 48;
    case "sm":
    default:
      return cellPadding * 2 + bodyFontSize * lineHeight;
  }
}

var __defProp$1a = Object.defineProperty;
var __defProps$P = Object.defineProperties;
var __getOwnPropDescs$P = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1b = Object.getOwnPropertySymbols;
var __hasOwnProp$1b = Object.prototype.hasOwnProperty;
var __propIsEnum$1b = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1a = (obj, key, value) => key in obj ? __defProp$1a(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1a = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1b.call(b, prop))
      __defNormalProp$1a(a, prop, b[prop]);
  if (__getOwnPropSymbols$1b)
    for (var prop of __getOwnPropSymbols$1b(b)) {
      if (__propIsEnum$1b.call(b, prop))
        __defNormalProp$1a(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$P = (a, b) => __defProps$P(a, __getOwnPropDescs$P(b));
const COLUMN_MIN_WIDTH = 150;
const FOOTER_ROW_HEIGHT = 36;
const Table = React.memo((props) => {
  const {
    ariaLabel,
    data: data$1,
    subData,
    height,
    onCellFilterAdded,
    width,
    columnMinWidth = COLUMN_MIN_WIDTH,
    noHeader,
    resizable = true,
    initialSortBy,
    footerOptions,
    showTypeIcons,
    footerValues,
    enablePagination,
    cellHeight = schema.TableCellHeight.Sm
  } = props;
  const listRef = React.useRef(null);
  const tableDivRef = React.useRef(null);
  const variableSizeListScrollbarRef = React.useRef(null);
  const theme = useTheme2();
  const tableStyles = useTableStyles(theme, cellHeight);
  const headerHeight = noHeader ? 0 : tableStyles.rowHeight;
  const [footerItems, setFooterItems] = React.useState(footerValues);
  const footerHeight = React.useMemo(() => {
    const EXTENDED_ROW_HEIGHT = FOOTER_ROW_HEIGHT;
    let length = 0;
    if (!footerItems) {
      return 0;
    }
    for (const fv of footerItems) {
      if (Array.isArray(fv) && fv.length > length) {
        length = fv.length;
      }
    }
    if (length > 1) {
      return EXTENDED_ROW_HEIGHT * length;
    }
    return EXTENDED_ROW_HEIGHT;
  }, [footerItems]);
  const memoizedData = React.useMemo(() => {
    if (!data$1.fields.length) {
      return [];
    }
    return Array(data$1.length).fill(0);
  }, [data$1]);
  const isCountRowsSet = Boolean(
    (footerOptions == null ? void 0 : footerOptions.countRows) && footerOptions.reducer && footerOptions.reducer.length && footerOptions.reducer[0] === data.ReducerID.count
  );
  const memoizedColumns = React.useMemo(
    () => getColumns(data$1, width, columnMinWidth, !!(subData == null ? void 0 : subData.length), footerItems, isCountRowsSet),
    [data$1, width, columnMinWidth, footerItems, subData, isCountRowsSet]
  );
  const stateReducer = useTableStateReducer(props);
  const options = React.useMemo(
    () => ({
      columns: memoizedColumns,
      data: memoizedData,
      disableResizing: !resizable,
      stateReducer,
      initialState: getInitialState(initialSortBy, memoizedColumns),
      autoResetFilters: false,
      sortTypes: {
        number: sortNumber,
        // the builtin number type on react-table does not handle NaN values
        "alphanumeric-insensitive": sortCaseInsensitive
        // should be replace with the builtin string when react-table is upgraded, see https://github.com/tannerlinsley/react-table/pull/3235
      }
    }),
    [initialSortBy, memoizedColumns, memoizedData, resizable, stateReducer]
  );
  const {
    getTableProps,
    headerGroups,
    footerGroups,
    rows,
    prepareRow,
    totalColumnsWidth,
    page,
    state,
    gotoPage,
    setPageSize,
    pageOptions
  } = reactTable.useTable(options, reactTable.useFilters, reactTable.useSortBy, reactTable.useAbsoluteLayout, reactTable.useResizeColumns, reactTable.useExpanded, reactTable.usePagination);
  const extendedState = state;
  React.useEffect(() => {
    if (!footerOptions) {
      setFooterItems(footerValues);
    }
  }, [footerValues, footerOptions]);
  React.useEffect(() => {
    var _a, _b, _c;
    if (!footerOptions) {
      return;
    }
    if (!footerOptions.show) {
      setFooterItems(void 0);
      return;
    }
    if (isCountRowsSet) {
      const footerItemsCountRows = [];
      footerItemsCountRows[0] = (_c = (_b = (_a = headerGroups[0]) == null ? void 0 : _a.headers[0]) == null ? void 0 : _b.filteredRows.length.toString()) != null ? _c : data$1.length.toString();
      setFooterItems(footerItemsCountRows);
      return;
    }
    const footerItems2 = getFooterItems(
      headerGroups[0].headers,
      createFooterCalculationValues(rows),
      footerOptions,
      theme
    );
    setFooterItems(footerItems2);
  }, [footerOptions, theme, state.filters, data$1]);
  let listHeight = height - (headerHeight + footerHeight);
  if (enablePagination) {
    listHeight -= tableStyles.cellHeight;
  }
  const pageSize = Math.round(listHeight / tableStyles.rowHeight) - 1;
  React.useEffect(() => {
    if (pageSize <= 0) {
      return;
    }
    setPageSize(pageSize);
  }, [pageSize, setPageSize]);
  useResetVariableListSizeCache(extendedState, listRef, data$1);
  useFixScrollbarContainer(variableSizeListScrollbarRef, tableDivRef);
  const renderSubTable = React.useCallback(
    (rowIndex) => {
      var _a, _b;
      if (state.expanded[rowIndex]) {
        const rowSubData = subData == null ? void 0 : subData.find((frame) => {
          var _a2, _b2;
          return ((_b2 = (_a2 = frame.meta) == null ? void 0 : _a2.custom) == null ? void 0 : _b2.parentRowIndex) === rowIndex;
        });
        if (rowSubData) {
          const noHeader2 = !!((_b = (_a = rowSubData.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.noHeader);
          const subTableStyle = {
            height: tableStyles.rowHeight * (rowSubData.length + (noHeader2 ? 0 : 1)),
            // account for the header with + 1
            background: theme.colors.emphasize(theme.colors.background.primary, 0.015),
            paddingLeft: EXPANDER_WIDTH,
            position: "absolute",
            bottom: 0
          };
          return /* @__PURE__ */ React__default["default"].createElement("div", { style: subTableStyle }, /* @__PURE__ */ React__default["default"].createElement(
            Table,
            {
              data: rowSubData,
              width: width - EXPANDER_WIDTH,
              height: tableStyles.rowHeight * (rowSubData.length + 1),
              noHeader: noHeader2
            }
          ));
        }
      }
      return null;
    },
    [state.expanded, subData, tableStyles.rowHeight, theme.colors, width]
  );
  const RenderRow = React.useCallback(
    ({ index: rowIndex, style }) => {
      let row = rows[rowIndex];
      if (enablePagination) {
        row = page[rowIndex];
      }
      prepareRow(row);
      return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$P(__spreadValues$1a({}, row.getRowProps({ style })), { className: tableStyles.row }), renderSubTable(rowIndex), row.cells.map((cell, index) => /* @__PURE__ */ React__default["default"].createElement(
        TableCell,
        {
          key: index,
          tableStyles,
          cell,
          onCellFilterAdded,
          columnIndex: index,
          columnCount: row.cells.length
        }
      )));
    },
    [onCellFilterAdded, page, enablePagination, prepareRow, rows, tableStyles, renderSubTable]
  );
  const onNavigate = React.useCallback(
    (toPage) => {
      gotoPage(toPage - 1);
    },
    [gotoPage]
  );
  const itemCount = enablePagination ? page.length : rows.length;
  let paginationEl = null;
  if (enablePagination) {
    const itemsRangeStart = state.pageIndex * state.pageSize + 1;
    let itemsRangeEnd = itemsRangeStart + state.pageSize - 1;
    const isSmall = width < 550;
    if (itemsRangeEnd > data$1.length) {
      itemsRangeEnd = data$1.length;
    }
    paginationEl = /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.paginationWrapper }, /* @__PURE__ */ React__default["default"].createElement(
      Pagination,
      {
        currentPage: state.pageIndex + 1,
        numberOfPages: pageOptions.length,
        showSmallVersion: isSmall,
        onNavigate
      }
    ), isSmall ? null : /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.paginationSummary }, itemsRangeStart, " - ", itemsRangeEnd, " of ", data$1.length, " rows"));
  }
  const getItemSize = (index) => {
    var _a, _b;
    if (state.expanded[index]) {
      const rowSubData = subData == null ? void 0 : subData.find((frame) => {
        var _a2, _b2;
        return ((_b2 = (_a2 = frame.meta) == null ? void 0 : _a2.custom) == null ? void 0 : _b2.parentRowIndex) === index;
      });
      if (rowSubData) {
        const noHeader2 = !!((_b = (_a = rowSubData.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.noHeader);
        return tableStyles.rowHeight * (rowSubData.length + 1 + (noHeader2 ? 0 : 1));
      }
    }
    return tableStyles.rowHeight;
  };
  const handleScroll = (event) => {
    const { scrollTop } = event.target;
    if (listRef.current !== null) {
      listRef.current.scrollTo(scrollTop);
    }
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$P(__spreadValues$1a({}, getTableProps()), { className: tableStyles.table, "aria-label": ariaLabel, role: "table", ref: tableDivRef }), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { hideVerticalTrack: true }, /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.tableContentWrapper(totalColumnsWidth) }, !noHeader && /* @__PURE__ */ React__default["default"].createElement(HeaderRow, { headerGroups, showTypeIcons, tableStyles }), itemCount > 0 ? /* @__PURE__ */ React__default["default"].createElement("div", { ref: variableSizeListScrollbarRef }, /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { onScroll: handleScroll, hideHorizontalTrack: true }, /* @__PURE__ */ React__default["default"].createElement(
    reactWindow.VariableSizeList,
    {
      key: tableStyles.rowHeight,
      height: listHeight,
      itemCount,
      itemSize: getItemSize,
      width: "100%",
      ref: listRef,
      style: { overflow: void 0 }
    },
    RenderRow
  ))) : /* @__PURE__ */ React__default["default"].createElement("div", { style: { height: height - headerHeight }, className: tableStyles.noData }, "No data"), footerItems && /* @__PURE__ */ React__default["default"].createElement(
    FooterRow,
    {
      isPaginationVisible: Boolean(enablePagination),
      footerValues: footerItems,
      footerGroups,
      totalColumnsWidth,
      tableStyles
    }
  ))), paginationEl);
});
Table.displayName = "Table";

var __defProp$19 = Object.defineProperty;
var __defProps$O = Object.defineProperties;
var __getOwnPropDescs$O = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1a = Object.getOwnPropertySymbols;
var __hasOwnProp$1a = Object.prototype.hasOwnProperty;
var __propIsEnum$1a = Object.prototype.propertyIsEnumerable;
var __defNormalProp$19 = (obj, key, value) => key in obj ? __defProp$19(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$19 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1a.call(b, prop))
      __defNormalProp$19(a, prop, b[prop]);
  if (__getOwnPropSymbols$1a)
    for (var prop of __getOwnPropSymbols$1a(b)) {
      if (__propIsEnum$1a.call(b, prop))
        __defNormalProp$19(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$O = (a, b) => __defProps$O(a, __getOwnPropDescs$O(b));
var __objRest$F = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1a.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1a)
    for (var prop of __getOwnPropSymbols$1a(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1a.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const TextArea = React__default["default"].forwardRef((_a, ref) => {
  var _b = _a, { invalid, className } = _b, props = __objRest$F(_b, ["invalid", "className"]);
  const theme = useTheme2();
  const styles = getTextAreaStyle(theme, invalid);
  return /* @__PURE__ */ React__default["default"].createElement("textarea", __spreadProps$O(__spreadValues$19({}, props), { className: css.cx(styles.textarea, className), ref }));
});
const getTextAreaStyle = stylesFactory((theme, invalid = false) => {
  return {
    textarea: css.cx(
      sharedInputStyle(theme),
      getFocusStyle(theme),
      css.css`
        border-radius: ${theme.shape.borderRadius()};
        padding: ${theme.spacing.gridSize / 4}px ${theme.spacing.gridSize}px;
        width: 100%;
        border-color: ${invalid ? theme.colors.error.border : theme.components.input.borderColor};
      `
    )
  };
});
TextArea.displayName = "TextArea";

class UnThemedTableInputCSV extends React.PureComponent {
  constructor(props) {
    super(props);
    this.readCSV = lodash.debounce(() => {
      const { config } = this.props;
      const { text } = this.state;
      this.setState({ data: data.readCSV(text, { config }) });
    }, 150);
    this.onTextChange = (event) => {
      this.setState({ text: event.target.value });
    };
    const { text, config } = props;
    this.state = {
      text,
      data: data.readCSV(text, { config })
    };
  }
  componentDidUpdate(prevProps, prevState) {
    const { text } = this.state;
    if (text !== prevState.text || this.props.config !== prevProps.config) {
      this.readCSV();
    }
    if (this.props.text !== prevProps.text && this.props.text !== text) {
      this.setState({ text: this.props.text });
    }
    if (this.state.data !== prevState.data) {
      this.props.onSeriesParsed(this.state.data, this.state.text);
    }
  }
  render() {
    const { width, height, theme } = this.props;
    const { data } = this.state;
    const styles = getStyles$Q(theme);
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.tableInputCsv }, /* @__PURE__ */ React__default["default"].createElement(
      TextArea,
      {
        style: { width, height },
        placeholder: "Enter CSV here...",
        value: this.state.text,
        onChange: this.onTextChange,
        className: styles.textarea
      }
    ), data && /* @__PURE__ */ React__default["default"].createElement("footer", { className: styles.footer }, data.map((frame, index) => {
      return /* @__PURE__ */ React__default["default"].createElement("span", { key: index }, "Rows:", frame.length, ", Columns:", frame.fields.length, " \xA0", /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check-circle" }));
    })));
  }
}
const TableInputCSV = withTheme2(UnThemedTableInputCSV);
TableInputCSV.displayName = "TableInputCSV";
const getStyles$Q = stylesFactory((theme) => {
  return {
    tableInputCsv: css.css`
      position: relative;
    `,
    textarea: css.css`
      height: 100%;
      width: 100%;
    `,
    footer: css.css`
      position: absolute;
      bottom: 15px;
      right: 15px;
      border: 1px solid #222;
      background: ${theme.colors.success.main};
      padding: 1px ${theme.spacing(0.5)};
      font-size: 80%;
    `
  };
});

var __defProp$18 = Object.defineProperty;
var __defProps$N = Object.defineProperties;
var __getOwnPropDescs$N = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$19 = Object.getOwnPropertySymbols;
var __hasOwnProp$19 = Object.prototype.hasOwnProperty;
var __propIsEnum$19 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$18 = (obj, key, value) => key in obj ? __defProp$18(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$18 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$19.call(b, prop))
      __defNormalProp$18(a, prop, b[prop]);
  if (__getOwnPropSymbols$19)
    for (var prop of __getOwnPropSymbols$19(b)) {
      if (__propIsEnum$19.call(b, prop))
        __defNormalProp$18(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$N = (a, b) => __defProps$N(a, __getOwnPropDescs$N(b));
var __objRest$E = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$19.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$19)
    for (var prop of __getOwnPropSymbols$19(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$19.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const VerticalTab = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { label, active, icon, counter, className, suffix: Suffix, onChangeTab, href } = _b, otherProps = __objRest$E(_b, ["label", "active", "icon", "counter", "className", "suffix", "onChangeTab", "href"]);
    const tabsStyles = useStyles2(getTabStyles);
    const content = () => /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon }), label, typeof counter === "number" && /* @__PURE__ */ React__default["default"].createElement(Counter, { value: counter }), Suffix && /* @__PURE__ */ React__default["default"].createElement(Suffix, { className: tabsStyles.suffix }));
    const linkClass = css.cx(tabsStyles.link, active && tabsStyles.activeStyle);
    return /* @__PURE__ */ React__default["default"].createElement(
      "a",
      __spreadProps$N(__spreadValues$18({
        href,
        className: linkClass
      }, otherProps), {
        onClick: onChangeTab,
        "aria-label": otherProps["aria-label"] || e2eSelectors.selectors.components.Tab.title(label),
        role: "tab",
        "aria-selected": active,
        ref
      }),
      content()
    );
  }
);
VerticalTab.displayName = "Tab";
const getTabStyles = (theme) => {
  return {
    link: css.css`
      padding: 6px 12px;
      display: block;
      height: 100%;
      cursor: pointer;
      position: relative;

      color: ${theme.colors.text.primary};

      svg {
        margin-right: ${theme.spacing(1)};
      }

      &:hover,
      &:focus {
        text-decoration: underline;
      }
    `,
    activeStyle: css.css`
      label: activeTabStyle;
      color: ${theme.colors.text.maxContrast};
      overflow: hidden;

      &::before {
        display: block;
        content: ' ';
        position: absolute;
        left: 0;
        width: 4px;
        bottom: 2px;
        top: 2px;
        border-radius: ${theme.shape.radius.default};
        background-image: linear-gradient(0deg, #f05a28 30%, #fbca0a 99%);
      }
    `,
    suffix: css.css`
      margin-left: ${theme.spacing(1)};
    `
  };
};

var __defProp$17 = Object.defineProperty;
var __defProps$M = Object.defineProperties;
var __getOwnPropDescs$M = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$18 = Object.getOwnPropertySymbols;
var __hasOwnProp$18 = Object.prototype.hasOwnProperty;
var __propIsEnum$18 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$17 = (obj, key, value) => key in obj ? __defProp$17(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$17 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$18.call(b, prop))
      __defNormalProp$17(a, prop, b[prop]);
  if (__getOwnPropSymbols$18)
    for (var prop of __getOwnPropSymbols$18(b)) {
      if (__propIsEnum$18.call(b, prop))
        __defNormalProp$17(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$M = (a, b) => __defProps$M(a, __getOwnPropDescs$M(b));
var __objRest$D = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$18.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$18)
    for (var prop of __getOwnPropSymbols$18(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$18.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getTabContentStyle = stylesFactory((theme) => {
  return {
    tabContent: css.css`
      background: ${theme.colors.background.primary};
    `
  };
});
const TabContent = (_a) => {
  var _b = _a, { children, className } = _b, restProps = __objRest$D(_b, ["children", "className"]);
  const theme = useTheme2();
  const styles = getTabContentStyle(theme);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$M(__spreadValues$17({}, restProps), { className: css.cx(styles.tabContent, className) }), children);
};

var __defProp$16 = Object.defineProperty;
var __getOwnPropSymbols$17 = Object.getOwnPropertySymbols;
var __hasOwnProp$17 = Object.prototype.hasOwnProperty;
var __propIsEnum$17 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$16 = (obj, key, value) => key in obj ? __defProp$16(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$16 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$17.call(b, prop))
      __defNormalProp$16(a, prop, b[prop]);
  if (__getOwnPropSymbols$17)
    for (var prop of __getOwnPropSymbols$17(b)) {
      if (__propIsEnum$17.call(b, prop))
        __defNormalProp$16(a, prop, b[prop]);
    }
  return a;
};
var __objRest$C = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$17.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$17)
    for (var prop of __getOwnPropSymbols$17(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$17.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function RenderUserContentAsHTML(_a) {
  var _b = _a, {
    component,
    content
  } = _b, rest = __objRest$C(_b, [
    "component",
    "content"
  ]);
  return React__default["default"].createElement(component || "span", __spreadValues$16({
    dangerouslySetInnerHTML: { __html: data.textUtil.sanitize(content) }
  }, rest));
}

var __defProp$15 = Object.defineProperty;
var __defProps$L = Object.defineProperties;
var __getOwnPropDescs$L = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$16 = Object.getOwnPropertySymbols;
var __hasOwnProp$16 = Object.prototype.hasOwnProperty;
var __propIsEnum$16 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$15 = (obj, key, value) => key in obj ? __defProp$15(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$15 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$16.call(b, prop))
      __defNormalProp$15(a, prop, b[prop]);
  if (__getOwnPropSymbols$16)
    for (var prop of __getOwnPropSymbols$16(b)) {
      if (__propIsEnum$16.call(b, prop))
        __defNormalProp$15(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$L = (a, b) => __defProps$L(a, __getOwnPropDescs$L(b));
const LINE_HEIGHT = 1.2;
const MAX_TITLE_SIZE = 30;
const VALUE_FONT_WEIGHT = 500;
class BigValueLayout {
  constructor(props) {
    this.props = props;
    var _a;
    const { width, height, value, text } = props;
    this.valueColor = (_a = value.color) != null ? _a : "gray";
    this.panelPadding = height > 100 ? 12 : 8;
    this.textValues = getTextValues(props);
    this.justifyCenter = shouldJustifyCenter(props.justifyMode, this.textValues.title);
    this.valueToAlignTo = this.textValues.valueToAlignTo;
    this.titleToAlignTo = this.textValues.titleToAlignTo;
    this.titleFontSize = 0;
    this.valueFontSize = 0;
    this.chartHeight = 0;
    this.chartWidth = 0;
    this.maxTextWidth = width - this.panelPadding * 2;
    this.maxTextHeight = height - this.panelPadding * 2;
    if (text) {
      if (text.titleSize) {
        this.titleFontSize = text.titleSize;
        this.titleToAlignTo = void 0;
      }
      if (text.valueSize) {
        this.valueFontSize = text.valueSize;
        this.valueToAlignTo = "";
      }
    }
  }
  getTitleStyles() {
    const styles = {
      fontSize: `${this.titleFontSize}px`,
      lineHeight: LINE_HEIGHT
    };
    if (this.props.parentOrientation === data.VizOrientation.Horizontal && this.justifyCenter) {
      styles.paddingRight = "0.75ch";
    }
    if (this.props.colorMode === BigValueColorMode.Background || this.props.colorMode === BigValueColorMode.BackgroundSolid) {
      styles.color = getTextColorForAlphaBackground(this.valueColor, this.props.theme.isDark);
    }
    return styles;
  }
  getValueStyles() {
    const styles = {
      fontSize: this.valueFontSize,
      fontWeight: VALUE_FONT_WEIGHT,
      lineHeight: LINE_HEIGHT,
      position: "relative",
      zIndex: 1
    };
    if (this.justifyCenter) {
      styles.textAlign = "center";
    }
    switch (this.props.colorMode) {
      case BigValueColorMode.Value:
        styles.color = this.valueColor;
        break;
      case BigValueColorMode.Background:
      case BigValueColorMode.BackgroundSolid:
        styles.color = getTextColorForAlphaBackground(this.valueColor, this.props.theme.isDark);
        break;
      case BigValueColorMode.None:
        styles.color = this.props.theme.colors.text.primary;
        break;
    }
    return styles;
  }
  getValueAndTitleContainerStyles() {
    const styles = {
      display: "flex"
    };
    if (this.justifyCenter) {
      styles.alignItems = "center";
      styles.justifyContent = "center";
      styles.flexGrow = 1;
    }
    return styles;
  }
  getPanelStyles() {
    const { width, height, theme, colorMode } = this.props;
    const panelStyles = {
      width: `${width}px`,
      height: `${height}px`,
      padding: `${this.panelPadding}px`,
      borderRadius: theme.shape.borderRadius(),
      position: "relative",
      display: "flex"
    };
    const themeFactor = theme.isDark ? 1 : -0.7;
    switch (colorMode) {
      case BigValueColorMode.Background:
        const bgColor2 = tinycolor__default["default"](this.valueColor).darken(15 * themeFactor).spin(8).toRgbString();
        const bgColor3 = tinycolor__default["default"](this.valueColor).darken(5 * themeFactor).spin(-8).toRgbString();
        panelStyles.background = `linear-gradient(120deg, ${bgColor2}, ${bgColor3})`;
        break;
      case BigValueColorMode.BackgroundSolid:
        panelStyles.background = tinycolor__default["default"](this.valueColor).toString();
        break;
      case BigValueColorMode.Value:
        panelStyles.background = `transparent`;
        break;
    }
    if (this.justifyCenter) {
      panelStyles.alignItems = "center";
      panelStyles.flexDirection = "row";
    }
    return panelStyles;
  }
  renderChart() {
    var _a;
    const { sparkline, colorMode } = this.props;
    if (!sparkline || ((_a = sparkline.y) == null ? void 0 : _a.type) !== data.FieldType.number) {
      return null;
    }
    let fillColor;
    let lineColor;
    switch (colorMode) {
      case BigValueColorMode.Background:
      case BigValueColorMode.BackgroundSolid:
        fillColor = "rgba(255,255,255,0.4)";
        lineColor = tinycolor__default["default"](this.valueColor).brighten(40).toRgbString();
        break;
      case BigValueColorMode.None:
      case BigValueColorMode.Value:
      default:
        lineColor = this.valueColor;
        fillColor = tinycolor__default["default"](this.valueColor).setAlpha(0.2).toRgbString();
        break;
    }
    const config = {
      custom: {
        drawStyle: schema.GraphDrawStyle.Line,
        lineWidth: 1,
        fillColor,
        lineColor
      }
    };
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: this.getChartStyles() }, /* @__PURE__ */ React__default["default"].createElement(
      Sparkline,
      {
        height: this.chartHeight,
        width: this.chartWidth,
        sparkline,
        config,
        theme: this.props.theme
      }
    ));
  }
  getChartStyles() {
    return {
      position: "absolute",
      right: 0,
      bottom: 0
    };
  }
}
class WideNoChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const valueWidthPercent = ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) ? 0.3 : 1;
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth * valueWidthPercent,
        this.maxTextHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth * 0.6,
        this.maxTextHeight,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "row";
    styles.alignItems = "center";
    styles.flexGrow = 1;
    if (!this.justifyCenter) {
      styles.justifyContent = "space-between";
    }
    return styles;
  }
  renderChart() {
    return null;
  }
  getPanelStyles() {
    const panelStyles = super.getPanelStyles();
    panelStyles.alignItems = "center";
    return panelStyles;
  }
}
class WideWithChartLayout extends BigValueLayout {
  constructor(props) {
    var _a;
    super(props);
    const { width, height } = props;
    const chartHeightPercent = 0.5;
    const titleWidthPercent = 0.6;
    const valueWidthPercent = 1 - titleWidthPercent;
    const textHeightPercent = 0.4;
    this.chartWidth = width;
    this.chartHeight = height * chartHeightPercent;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth * titleWidthPercent,
        this.maxTextHeight * textHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth * valueWidthPercent,
        this.maxTextHeight * chartHeightPercent,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "row";
    styles.flexGrow = 1;
    if (!this.justifyCenter) {
      styles.justifyContent = "space-between";
    }
    return styles;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.flexDirection = "row";
    styles.justifyContent = "space-between";
    return styles;
  }
}
class StackedWithChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const { width, height } = props;
    const titleHeightPercent = 0.15;
    const chartHeightPercent = 0.25;
    let titleHeight = 0;
    this.chartHeight = height * chartHeightPercent;
    this.chartWidth = width;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth,
        height * titleHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      titleHeight = this.titleFontSize * LINE_HEIGHT;
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth,
        this.maxTextHeight - this.chartHeight - titleHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
    this.chartHeight = height - this.titleFontSize * LINE_HEIGHT - this.valueFontSize * LINE_HEIGHT;
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "column";
    styles.justifyContent = "center";
    return styles;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.flexDirection = "column";
    return styles;
  }
}
class StackedWithNoChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const { height } = props;
    const titleHeightPercent = 0.15;
    let titleHeight = 0;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth,
        height * titleHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      titleHeight = this.titleFontSize * LINE_HEIGHT;
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth,
        this.maxTextHeight - titleHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "column";
    styles.flexGrow = 1;
    return styles;
  }
  renderChart() {
    return null;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.alignItems = "center";
    return styles;
  }
}
function buildLayout(props) {
  const { width, height, sparkline } = props;
  const useWideLayout = width / height > 2.5;
  if (useWideLayout) {
    if (height > 50 && !!sparkline && sparkline.y.values.length > 1) {
      return new WideWithChartLayout(props);
    } else {
      return new WideNoChartLayout(props);
    }
  }
  if (height > 100 && sparkline && sparkline.y.values.length > 1) {
    return new StackedWithChartLayout(props);
  } else {
    return new StackedWithNoChartLayout(props);
  }
}
function shouldJustifyCenter(justifyMode, title) {
  if (justifyMode === BigValueJustifyMode.Center) {
    return true;
  }
  return (title != null ? title : "").length === 0;
}
function getTextValues(props) {
  const { value, alignmentFactors, count } = props;
  let { textMode } = props;
  const titleToAlignTo = alignmentFactors ? alignmentFactors.title : value.title;
  const valueToAlignTo = data.formattedValueToString(alignmentFactors ? alignmentFactors : value);
  if (textMode === BigValueTextMode.Auto && (count != null ? count : 1) === 1) {
    textMode = BigValueTextMode.Value;
  }
  switch (textMode) {
    case BigValueTextMode.Name:
      return __spreadProps$L(__spreadValues$15({}, value), {
        title: void 0,
        prefix: void 0,
        suffix: void 0,
        text: value.title || "",
        titleToAlignTo: void 0,
        valueToAlignTo: titleToAlignTo != null ? titleToAlignTo : "",
        tooltip: data.formattedValueToString(value)
      });
    case BigValueTextMode.Value:
      return __spreadProps$L(__spreadValues$15({}, value), {
        title: void 0,
        titleToAlignTo: void 0,
        valueToAlignTo,
        tooltip: value.title
      });
    case BigValueTextMode.None:
      return {
        numeric: value.numeric,
        color: value.color,
        title: void 0,
        text: "",
        titleToAlignTo: void 0,
        valueToAlignTo: "1",
        tooltip: `Name: ${value.title}
Value: ${data.formattedValueToString(value)}`
      };
    case BigValueTextMode.ValueAndName:
    default:
      return __spreadProps$L(__spreadValues$15({}, value), {
        titleToAlignTo,
        valueToAlignTo
      });
  }
}

var BigValueColorMode = /* @__PURE__ */ ((BigValueColorMode2) => {
  BigValueColorMode2["Background"] = "background";
  BigValueColorMode2["BackgroundSolid"] = "background_solid";
  BigValueColorMode2["None"] = "none";
  BigValueColorMode2["Value"] = "value";
  return BigValueColorMode2;
})(BigValueColorMode || {});
var BigValueGraphMode = /* @__PURE__ */ ((BigValueGraphMode2) => {
  BigValueGraphMode2["None"] = "none";
  BigValueGraphMode2["Line"] = "line";
  BigValueGraphMode2["Area"] = "area";
  return BigValueGraphMode2;
})(BigValueGraphMode || {});
var BigValueJustifyMode = /* @__PURE__ */ ((BigValueJustifyMode2) => {
  BigValueJustifyMode2["Auto"] = "auto";
  BigValueJustifyMode2["Center"] = "center";
  return BigValueJustifyMode2;
})(BigValueJustifyMode || {});
var BigValueTextMode = /* @__PURE__ */ ((BigValueTextMode2) => {
  BigValueTextMode2["Auto"] = "auto";
  BigValueTextMode2["Value"] = "value";
  BigValueTextMode2["ValueAndName"] = "value_and_name";
  BigValueTextMode2["Name"] = "name";
  BigValueTextMode2["None"] = "none";
  return BigValueTextMode2;
})(BigValueTextMode || {});
class BigValue extends React.PureComponent {
  render() {
    const { onClick, className, hasLinks, theme } = this.props;
    const layout = buildLayout(this.props);
    const panelStyles = layout.getPanelStyles();
    const valueAndTitleContainerStyles = layout.getValueAndTitleContainerStyles();
    const valueStyles = layout.getValueStyles();
    const titleStyles = layout.getTitleStyles();
    const textValues = layout.textValues;
    const tooltip = hasLinks ? void 0 : textValues.tooltip;
    if (!onClick) {
      return /* @__PURE__ */ React__default["default"].createElement("div", { className, style: panelStyles, title: tooltip }, /* @__PURE__ */ React__default["default"].createElement("div", { style: valueAndTitleContainerStyles }, textValues.title && /* @__PURE__ */ React__default["default"].createElement("div", { style: titleStyles }, textValues.title), /* @__PURE__ */ React__default["default"].createElement(FormattedValueDisplay, { value: textValues, style: valueStyles })), layout.renderChart());
    }
    return /* @__PURE__ */ React__default["default"].createElement(
      "button",
      {
        type: "button",
        className: css.cx(clearButtonStyles(theme), className),
        style: panelStyles,
        onClick,
        title: tooltip
      },
      /* @__PURE__ */ React__default["default"].createElement("div", { style: valueAndTitleContainerStyles }, textValues.title && /* @__PURE__ */ React__default["default"].createElement("div", { style: titleStyles }, textValues.title), /* @__PURE__ */ React__default["default"].createElement(FormattedValueDisplay, { value: textValues, style: valueStyles })),
      layout.renderChart()
    );
  }
}
BigValue.defaultProps = {
  justifyMode: "auto" /* Auto */
};

const DEFAULT_THRESHOLDS = {
  mode: data.ThresholdsMode.Absolute,
  steps: [
    { value: -Infinity, color: "green" },
    { value: 80, color: "red" }
  ]
};
function calculateGaugeAutoProps(width, height, title) {
  const showLabel = title !== null && title !== void 0;
  const titleFontSize = Math.min(width * 0.15 / 1.5, 20);
  const titleHeight = titleFontSize * 1.5;
  const availableHeight = showLabel ? height - titleHeight : height;
  const gaugeHeight = Math.min(availableHeight, width);
  return {
    showLabel,
    gaugeHeight,
    titleFontSize
  };
}
function getFormattedThresholds(decimals, field, value, theme) {
  var _a, _b, _c, _d, _e, _f;
  if (((_a = field.color) == null ? void 0 : _a.mode) !== data.FieldColorModeId.Thresholds) {
    return [{ value: (_b = field.min) != null ? _b : data.GAUGE_DEFAULT_MINIMUM, color: (_c = value.color) != null ? _c : data.FALLBACK_COLOR }];
  }
  const thresholds = (_d = field.thresholds) != null ? _d : DEFAULT_THRESHOLDS;
  const isPercent = thresholds.mode === data.ThresholdsMode.Percentage;
  const steps = thresholds.steps;
  let min = (_e = field.min) != null ? _e : data.GAUGE_DEFAULT_MINIMUM;
  let max = (_f = field.max) != null ? _f : data.GAUGE_DEFAULT_MAXIMUM;
  if (isPercent) {
    min = 0;
    max = 100;
  }
  const first = data.getActiveThreshold(min, steps);
  const last = data.getActiveThreshold(max, steps);
  const formatted = [
    { value: +min.toFixed(decimals), color: theme.visualization.getColorByName(first.color) }
  ];
  let skip = true;
  for (let i = 0; i < steps.length; i++) {
    const step = steps[i];
    if (skip) {
      if (first === step) {
        skip = false;
      }
      continue;
    }
    const prev = steps[i - 1];
    formatted.push({ value: step.value, color: theme.visualization.getColorByName(prev.color) });
    if (step === last) {
      break;
    }
  }
  formatted.push({ value: +max.toFixed(decimals), color: theme.visualization.getColorByName(last.color) });
  return formatted;
}

class Gauge extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.canvasElement = null;
    this.renderVisualization = () => {
      var _a;
      const { width, value, height, onClick, text, theme } = this.props;
      const autoProps = calculateGaugeAutoProps(width, height, value.title);
      const gaugeElement = /* @__PURE__ */ React__default["default"].createElement(
        "div",
        {
          style: { height: `${autoProps.gaugeHeight}px`, width: "100%" },
          ref: (element) => this.canvasElement = element
        }
      );
      return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, onClick ? /* @__PURE__ */ React__default["default"].createElement("button", { className: clearButtonStyles(theme), type: "button", onClick }, gaugeElement) : gaugeElement, autoProps.showLabel && /* @__PURE__ */ React__default["default"].createElement(
        "div",
        {
          style: {
            textAlign: "center",
            fontSize: (_a = text == null ? void 0 : text.titleSize) != null ? _a : autoProps.titleFontSize,
            overflow: "hidden",
            textOverflow: "ellipsis",
            whiteSpace: "nowrap",
            position: "relative",
            width: "100%",
            top: "-4px",
            cursor: "default"
          }
        },
        value.title
      ));
    };
  }
  componentDidMount() {
    this.draw();
  }
  componentDidUpdate() {
    this.draw();
  }
  draw() {
    var _a, _b, _c, _d, _e, _f;
    const { field, showThresholdLabels, showThresholdMarkers, width, height, theme, value } = this.props;
    const autoProps = calculateGaugeAutoProps(width, height, value.title);
    const dimension = Math.min(width, autoProps.gaugeHeight);
    const backgroundColor = theme.colors.background.secondary;
    const gaugeWidthReduceRatio = showThresholdLabels ? 1.5 : 1;
    const gaugeWidth = Math.min(dimension / 5.5, 40) / gaugeWidthReduceRatio;
    const thresholdMarkersWidth = gaugeWidth / 5;
    const text = data.formattedValueToString(value);
    const valueWidthBase = Math.min(width, dimension * 1.3) * 0.9;
    const valueWidth = valueWidthBase - ((gaugeWidth + (showThresholdMarkers ? thresholdMarkersWidth : 0) + (showThresholdLabels ? 10 : 0)) * 2 + 10);
    const fontSize = (_b = (_a = this.props.text) == null ? void 0 : _a.valueSize) != null ? _b : calculateFontSize(text, valueWidth, dimension, 1, gaugeWidth * 1.7);
    const thresholdLabelFontSize = Math.max(fontSize / 2.5, 12);
    let min = (_c = field.min) != null ? _c : data.GAUGE_DEFAULT_MINIMUM;
    let max = (_d = field.max) != null ? _d : data.GAUGE_DEFAULT_MAXIMUM;
    let numeric = value.numeric;
    if (((_e = field.thresholds) == null ? void 0 : _e.mode) === data.ThresholdsMode.Percentage) {
      min = 0;
      max = 100;
      if (value.percent === void 0) {
        numeric = (numeric - min) / (max - min) * 100;
      } else {
        numeric = value.percent * 100;
      }
    }
    const decimals = field.decimals === void 0 ? 2 : field.decimals;
    if (showThresholdMarkers) {
      min = +min.toFixed(decimals);
      max = +max.toFixed(decimals);
    }
    const options = {
      series: {
        gauges: {
          gauge: {
            min,
            max,
            neutralValue: (_f = field.custom) == null ? void 0 : _f.neutral,
            background: { color: backgroundColor },
            border: { color: null },
            shadow: { show: false },
            width: gaugeWidth
          },
          frame: { show: false },
          label: { show: false },
          layout: { margin: 0, thresholdWidth: 0, vMargin: 0 },
          cell: { border: { width: 0 } },
          threshold: {
            values: getFormattedThresholds(decimals, field, value, theme),
            label: {
              show: showThresholdLabels,
              margin: thresholdMarkersWidth + 1,
              font: { size: thresholdLabelFontSize }
            },
            show: showThresholdMarkers,
            width: thresholdMarkersWidth
          },
          value: {
            color: value.color,
            formatter: () => {
              return text;
            },
            font: { size: fontSize, family: theme.typography.fontFamily }
          },
          show: true
        }
      }
    };
    const plotSeries = {
      data: [[0, numeric]],
      label: value.title
    };
    try {
      if (this.canvasElement) {
        $__default["default"].plot(this.canvasElement, [plotSeries], options);
      }
    } catch (err) {
      console.error("Gauge rendering error", err, options, value);
    }
  }
  render() {
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        style: {
          width: "100%",
          height: "100%",
          display: "flex",
          flexDirection: "column",
          justifyContent: "center",
          overflow: "hidden"
        },
        className: this.props.className
      },
      this.renderVisualization()
    );
  }
}
Gauge.defaultProps = {
  showThresholdMarkers: true,
  showThresholdLabels: false,
  field: {
    min: 0,
    max: 100,
    thresholds: DEFAULT_THRESHOLDS
  }
};

const calculateTooltipPosition = (xPos = 0, yPos = 0, tooltipWidth = 0, tooltipHeight = 0, xOffset = 0, yOffset = 0, windowWidth = 0, windowHeight = 0) => {
  let x = xPos;
  let y = yPos;
  const overflowRight = Math.max(xPos + xOffset + tooltipWidth - (windowWidth - xOffset), 0);
  const overflowLeft = Math.abs(Math.min(xPos - xOffset - tooltipWidth - xOffset, 0));
  const wouldOverflowRight = overflowRight > 0;
  const wouldOverflowLeft = overflowLeft > 0;
  const overflowBelow = Math.max(yPos + yOffset + tooltipHeight - (windowHeight - yOffset), 0);
  const overflowAbove = Math.abs(Math.min(yPos - yOffset - tooltipHeight - yOffset, 0));
  const wouldOverflowBelow = overflowBelow > 0;
  const wouldOverflowAbove = overflowAbove > 0;
  if (wouldOverflowRight && wouldOverflowLeft) {
    x = overflowRight > overflowLeft ? xOffset : windowWidth - xOffset - tooltipWidth;
  } else if (wouldOverflowRight) {
    x = xPos - xOffset - tooltipWidth;
  } else {
    x = xPos + xOffset;
  }
  if (wouldOverflowBelow && wouldOverflowAbove) {
    y = overflowBelow > overflowAbove ? yOffset : windowHeight - yOffset - tooltipHeight;
  } else if (wouldOverflowBelow) {
    y = yPos - yOffset - tooltipHeight;
  } else {
    y = yPos + yOffset;
  }
  return { x, y };
};

var __defProp$14 = Object.defineProperty;
var __defProps$K = Object.defineProperties;
var __getOwnPropDescs$K = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$15 = Object.getOwnPropertySymbols;
var __hasOwnProp$15 = Object.prototype.hasOwnProperty;
var __propIsEnum$15 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$14 = (obj, key, value) => key in obj ? __defProp$14(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$14 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$15.call(b, prop))
      __defNormalProp$14(a, prop, b[prop]);
  if (__getOwnPropSymbols$15)
    for (var prop of __getOwnPropSymbols$15(b)) {
      if (__propIsEnum$15.call(b, prop))
        __defNormalProp$14(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$K = (a, b) => __defProps$K(a, __getOwnPropDescs$K(b));
var __objRest$B = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$15.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$15)
    for (var prop of __getOwnPropSymbols$15(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$15.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const VizTooltipContainer = (_a) => {
  var _b = _a, {
    position: { x: positionX, y: positionY },
    offset: { x: offsetX, y: offsetY },
    children,
    allowPointerEvents = false,
    className
  } = _b, otherProps = __objRest$B(_b, [
    "position",
    "offset",
    "children",
    "allowPointerEvents",
    "className"
  ]);
  const tooltipRef = React.useRef(null);
  const [tooltipMeasurement, setTooltipMeasurement] = React.useState({ width: 0, height: 0 });
  const { width, height } = reactUse.useWindowSize();
  const [placement, setPlacement] = React.useState({
    x: positionX + offsetX,
    y: positionY + offsetY
  });
  const resizeObserver = React.useMemo(
    () => (
      // TS has hard time playing games with @types/resize-observer-browser, hence the ignore
      // @ts-ignore
      new ResizeObserver((entries) => {
        for (let entry of entries) {
          const tW = Math.floor(entry.contentRect.width + 2 * 8);
          const tH = Math.floor(entry.contentRect.height + 2 * 8);
          if (tooltipMeasurement.width !== tW || tooltipMeasurement.height !== tH) {
            setTooltipMeasurement({
              width: Math.min(tW, width),
              height: Math.min(tH, height)
            });
          }
        }
      })
    ),
    [tooltipMeasurement, width, height]
  );
  React.useLayoutEffect(() => {
    if (tooltipRef.current) {
      resizeObserver.observe(tooltipRef.current);
    }
    return () => {
      resizeObserver.disconnect();
    };
  }, [resizeObserver]);
  React.useLayoutEffect(() => {
    if (tooltipRef && tooltipRef.current) {
      const { x, y } = calculateTooltipPosition(
        positionX,
        positionY,
        tooltipMeasurement.width,
        tooltipMeasurement.height,
        offsetX,
        offsetY,
        width,
        height
      );
      setPlacement({ x, y });
    }
  }, [width, height, positionX, offsetX, positionY, offsetY, tooltipMeasurement]);
  const styles = useStyles2(getStyles$P);
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    __spreadProps$K(__spreadValues$14({
      ref: tooltipRef,
      style: {
        position: "fixed",
        left: 0,
        // disabling pointer-events is to prevent the tooltip from flickering when moving left to right
        // see e.g. https://github.com/grafana/grafana/pull/33609
        pointerEvents: allowPointerEvents ? "auto" : "none",
        top: 0,
        transform: `translate(${placement.x}px, ${placement.y}px)`,
        transition: "transform ease-out 0.1s"
      }
    }, otherProps), {
      className: css.cx(styles.wrapper, className)
    }),
    children
  );
};
VizTooltipContainer.displayName = "VizTooltipContainer";
const getStyles$P = (theme) => ({
  wrapper: css.css`
    ${getTooltipContainerStyles(theme)}
  `
});

const VizTooltip = ({ content, position, offset }) => {
  const styles = useStyles2(getStyles$O);
  if (position) {
    return /* @__PURE__ */ React__default["default"].createElement(Portal$1, { className: styles.portal }, /* @__PURE__ */ React__default["default"].createElement(VizTooltipContainer, { position, offset: offset || { x: 0, y: 0 } }, content));
  }
  return null;
};
VizTooltip.displayName = "VizTooltip";
const getStyles$O = () => {
  return {
    portal: css.css`
      position: absolute;
      top: 0;
      left: 0;
      pointer-events: none;
      width: 100%;
      height: 100%;
    `
  };
};

var __defProp$13 = Object.defineProperty;
var __getOwnPropSymbols$14 = Object.getOwnPropertySymbols;
var __hasOwnProp$14 = Object.prototype.hasOwnProperty;
var __propIsEnum$14 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$13 = (obj, key, value) => key in obj ? __defProp$13(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$13 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$14.call(b, prop))
      __defNormalProp$13(a, prop, b[prop]);
  if (__getOwnPropSymbols$14)
    for (var prop of __getOwnPropSymbols$14(b)) {
      if (__propIsEnum$14.call(b, prop))
        __defNormalProp$13(a, prop, b[prop]);
    }
  return a;
};
var __objRest$A = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$14.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$14)
    for (var prop of __getOwnPropSymbols$14(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$14.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SeriesIcon = React__default["default"].memo(
  React__default["default"].forwardRef((_a, ref) => {
    var _b = _a, { color, className, gradient } = _b, restProps = __objRest$A(_b, ["color", "className", "gradient"]);
    var _a2, _b2;
    const theme = useTheme2();
    let cssColor;
    if (gradient) {
      const colors = (_b2 = (_a2 = data.fieldColorModeRegistry.get(gradient)).getColors) == null ? void 0 : _b2.call(_a2, theme);
      if (colors == null ? void 0 : colors.length) {
        cssColor = `linear-gradient(90deg, ${colors.join(", ")})`;
      } else {
        cssColor = theme.visualization.getColorByName("");
      }
    } else {
      cssColor = color;
    }
    const styles = {
      background: cssColor,
      width: "14px",
      height: "4px",
      borderRadius: theme.shape.radius.default,
      display: "inline-block",
      marginRight: "8px"
    };
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$13({ "data-testid": "series-icon", ref, className, style: styles }, restProps));
  })
);
SeriesIcon.displayName = "SeriesIcon";

const getSeriesTableRowStyles = (theme) => {
  return {
    icon: css.css`
      margin-right: ${theme.spacing(1)};
      vertical-align: middle;
    `,
    seriesTable: css.css`
      display: table;
    `,
    seriesTableRow: css.css`
      display: table-row;
      font-size: ${theme.typography.bodySmall.fontSize};
    `,
    seriesTableCell: css.css`
      display: table-cell;
    `,
    label: css.css`
      word-break: break-all;
    `,
    value: css.css`
      padding-left: ${theme.spacing(2)};
    `,
    activeSeries: css.css`
      font-weight: ${theme.typography.fontWeightBold};
      color: ${theme.colors.text.maxContrast};
    `,
    timestamp: css.css`
      font-weight: ${theme.typography.fontWeightBold};
      font-size: ${theme.typography.bodySmall.fontSize};
    `
  };
};
const SeriesTableRow = ({ color, label, value, isActive }) => {
  const styles = useStyles2(getSeriesTableRowStyles);
  return /* @__PURE__ */ React__default["default"].createElement("div", { "data-testid": "SeriesTableRow", className: css.cx(styles.seriesTableRow, isActive && styles.activeSeries) }, color && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.seriesTableCell }, /* @__PURE__ */ React__default["default"].createElement(SeriesIcon, { color, className: styles.icon })), label && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.seriesTableCell, styles.label) }, label), value && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.seriesTableCell, styles.value) }, value));
};
const SeriesTable = ({ timestamp, series }) => {
  const styles = useStyles2(getSeriesTableRowStyles);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, timestamp && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.timestamp, "aria-label": "Timestamp" }, timestamp), series.map((s, i) => {
    return /* @__PURE__ */ React__default["default"].createElement(
      SeriesTableRow,
      {
        isActive: s.isActive,
        label: s.label,
        color: s.color,
        value: s.value,
        key: `${s.label}-${i}`
      }
    );
  }));
};

var __defProp$12 = Object.defineProperty;
var __defProps$J = Object.defineProperties;
var __getOwnPropDescs$J = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$13 = Object.getOwnPropertySymbols;
var __hasOwnProp$13 = Object.prototype.hasOwnProperty;
var __propIsEnum$13 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$12 = (obj, key, value) => key in obj ? __defProp$12(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$12 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$13.call(b, prop))
      __defNormalProp$12(a, prop, b[prop]);
  if (__getOwnPropSymbols$13)
    for (var prop of __getOwnPropSymbols$13(b)) {
      if (__propIsEnum$13.call(b, prop))
        __defNormalProp$12(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$J = (a, b) => __defProps$J(a, __getOwnPropDescs$J(b));
var __objRest$z = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$13.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$13)
    for (var prop of __getOwnPropSymbols$13(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$13.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const GraphContextMenu = (_a) => {
  var _b = _a, {
    getContextMenuSource,
    timeZone,
    itemsGroup,
    dimensions,
    contextDimensions
  } = _b, otherProps = __objRest$z(_b, [
    "getContextMenuSource",
    "timeZone",
    "itemsGroup",
    "dimensions",
    "contextDimensions"
  ]);
  const source = getContextMenuSource();
  const itemsToRender = itemsGroup ? itemsGroup.map((group) => {
    var _a2;
    return __spreadProps$J(__spreadValues$12({}, group), {
      items: (_a2 = group.items) == null ? void 0 : _a2.filter((item) => item.label)
    });
  }) : [];
  const renderHeader = () => {
    var _a2;
    if (!source) {
      return null;
    }
    let value;
    if ((dimensions == null ? void 0 : dimensions.yAxis) && ((_a2 = contextDimensions == null ? void 0 : contextDimensions.yAxis) == null ? void 0 : _a2[1])) {
      const valueFromDimensions = data.getValueFromDimension(
        dimensions.yAxis,
        contextDimensions.yAxis[0],
        contextDimensions.yAxis[1]
      );
      const display = source.series.valueField.display;
      value = display(valueFromDimensions);
    }
    const formattedValue = data.dateTimeFormat(source.datapoint[0], {
      defaultWithMS: source.series.hasMsResolution,
      timeZone
    });
    return /* @__PURE__ */ React__default["default"].createElement(
      GraphContextMenuHeader,
      {
        timestamp: formattedValue,
        seriesColor: source.series.color,
        displayName: source.series.alias || source.series.label,
        displayValue: value
      }
    );
  };
  const renderMenuGroupItems = () => {
    return itemsToRender == null ? void 0 : itemsToRender.map((group, index) => /* @__PURE__ */ React__default["default"].createElement(MenuGroup, { key: `${group.label}${index}`, label: group.label }, (group.items || []).map((item) => /* @__PURE__ */ React__default["default"].createElement(
      MenuItem,
      {
        key: `${item.label}`,
        url: item.url,
        label: item.label,
        target: item.target,
        icon: item.icon,
        active: item.active,
        onClick: item.onClick
      }
    ))));
  };
  return /* @__PURE__ */ React__default["default"].createElement(ContextMenu, __spreadProps$J(__spreadValues$12({}, otherProps), { renderMenuItems: renderMenuGroupItems, renderHeader }));
};
const GraphContextMenuHeader = ({
  timestamp,
  seriesColor,
  displayName,
  displayValue
}) => {
  const styles = useStyles2(getStyles$N);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, /* @__PURE__ */ React__default["default"].createElement("strong", null, timestamp), /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, null, /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement(SeriesIcon, { color: seriesColor }), /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.displayName }, displayName)), displayValue && /* @__PURE__ */ React__default["default"].createElement(FormattedValueDisplay, { value: displayValue })));
};
function getStyles$N(theme) {
  return {
    wrapper: css.css`
      padding: ${theme.spacing(0.5)} ${theme.spacing(1)};
      font-size: ${theme.typography.size.sm};
      z-index: ${theme.zIndex.tooltip};
    `,
    displayName: css.css`
      white-space: nowrap;
      padding-left: ${theme.spacing(0.5)};
    `
  };
}

const findHoverIndexFromData = (xAxisDimension, xPos) => {
  let lower = 0;
  let upper = xAxisDimension.values.length - 1;
  let middle;
  while (true) {
    if (lower > upper) {
      return Math.max(upper, 0);
    }
    middle = Math.floor((lower + upper) / 2);
    const xPosition = xAxisDimension.values.get(middle);
    if (xPosition === xPos) {
      return middle;
    } else if (xPosition && xPosition < xPos) {
      lower = middle + 1;
    } else {
      upper = middle - 1;
    }
  }
};
const getMultiSeriesGraphHoverInfo = (yAxisDimensions, xAxisDimensions, xAxisPosition, timeZone) => {
  let i, field, hoverIndex, hoverDistance, pointTime;
  const results = [];
  let minDistance, minTime;
  for (i = 0; i < yAxisDimensions.length; i++) {
    field = yAxisDimensions[i];
    const time = xAxisDimensions[i];
    hoverIndex = findHoverIndexFromData(time, xAxisPosition);
    hoverDistance = xAxisPosition - time.values.get(hoverIndex);
    pointTime = time.values.get(hoverIndex);
    if (minDistance === void 0 || hoverDistance >= 0 && (hoverDistance < minDistance || minDistance < 0) || hoverDistance < 0 && hoverDistance > minDistance) {
      minDistance = hoverDistance;
      minTime = time.display ? data.formattedValueToString(time.display(pointTime)) : pointTime;
    }
    const disp = field.display(field.values.get(hoverIndex));
    results.push({
      value: data.formattedValueToString(disp),
      datapointIndex: hoverIndex,
      seriesIndex: i,
      color: disp.color,
      label: data.getFieldDisplayName(field),
      time: time.display ? data.formattedValueToString(time.display(pointTime)) : pointTime
    });
  }
  return {
    results,
    time: minTime
  };
};
const graphTickFormatter = (epoch, axis) => {
  var _a, _b;
  return data.dateTimeFormat(epoch, {
    format: (_a = axis == null ? void 0 : axis.options) == null ? void 0 : _a.timeformat,
    timeZone: (_b = axis == null ? void 0 : axis.options) == null ? void 0 : _b.timezone
  });
};
const graphTimeFormat = (ticks, min, max) => {
  if (min && max && ticks) {
    const range = max - min;
    const secPerTick = range / ticks / 1e3;
    const oneDay = 86400010;
    const oneYear = 31536e6;
    if (secPerTick <= 10) {
      return data.systemDateFormats.interval.millisecond;
    }
    if (secPerTick <= 45) {
      return data.systemDateFormats.interval.second;
    }
    if (range <= oneDay) {
      return data.systemDateFormats.interval.minute;
    }
    if (secPerTick <= 8e4) {
      return data.systemDateFormats.interval.hour;
    }
    if (range <= oneYear) {
      return data.systemDateFormats.interval.day;
    }
    if (secPerTick <= 31536e3) {
      return data.systemDateFormats.interval.month;
    }
    return data.systemDateFormats.interval.year;
  }
  return data.systemDateFormats.interval.minute;
};

const MultiModeGraphTooltip = ({ dimensions, activeDimensions, pos, timeZone }) => {
  let activeSeriesIndex = null;
  if (activeDimensions.xAxis === null) {
    return null;
  }
  if (activeDimensions.yAxis) {
    activeSeriesIndex = activeDimensions.yAxis[0];
  }
  const time = activeDimensions.xAxis[1] ? data.getValueFromDimension(dimensions.xAxis, activeDimensions.xAxis[0], activeDimensions.xAxis[1]) : pos.x;
  const hoverInfo = getMultiSeriesGraphHoverInfo(dimensions.yAxis.columns, dimensions.xAxis.columns, time);
  const timestamp = hoverInfo.time;
  const series = hoverInfo.results.map((s, i) => {
    return {
      color: s.color,
      label: s.label,
      value: s.value,
      isActive: activeSeriesIndex === i
    };
  });
  return /* @__PURE__ */ React__default["default"].createElement(SeriesTable, { series, timestamp });
};
MultiModeGraphTooltip.displayName = "MultiModeGraphTooltip";

const SingleModeGraphTooltip = ({ dimensions, activeDimensions, timeZone }) => {
  if (activeDimensions.yAxis === null || activeDimensions.yAxis[1] === void 0 || activeDimensions.xAxis === null || activeDimensions.xAxis[1] === void 0) {
    return null;
  }
  const time = data.getValueFromDimension(dimensions.xAxis, activeDimensions.xAxis[0], activeDimensions.xAxis[1]);
  const timeField = data.getColumnFromDimension(dimensions.xAxis, activeDimensions.xAxis[0]);
  const processedTime = timeField.display ? data.formattedValueToString(timeField.display(time)) : time;
  const valueField = data.getColumnFromDimension(dimensions.yAxis, activeDimensions.yAxis[0]);
  const value = data.getValueFromDimension(dimensions.yAxis, activeDimensions.yAxis[0], activeDimensions.yAxis[1]);
  const display = valueField.display;
  const disp = display(value);
  return /* @__PURE__ */ React__default["default"].createElement(
    SeriesTable,
    {
      series: [
        {
          color: disp.color,
          label: data.getFieldDisplayName(valueField),
          value: data.formattedValueToString(disp)
        }
      ],
      timestamp: processedTime
    }
  );
};
SingleModeGraphTooltip.displayName = "SingleModeGraphTooltip";

const GraphTooltip = ({
  mode = schema.TooltipDisplayMode.Single,
  dimensions,
  activeDimensions,
  pos,
  timeZone
}) => {
  if (!activeDimensions || !activeDimensions.xAxis) {
    return null;
  }
  if (mode === "single") {
    return /* @__PURE__ */ React__default["default"].createElement(SingleModeGraphTooltip, { dimensions, activeDimensions, timeZone });
  } else {
    return /* @__PURE__ */ React__default["default"].createElement(
      MultiModeGraphTooltip,
      {
        dimensions,
        activeDimensions,
        pos,
        timeZone
      }
    );
  }
};
GraphTooltip.displayName = "GraphTooltip";

var __defProp$11 = Object.defineProperty;
var __getOwnPropSymbols$12 = Object.getOwnPropertySymbols;
var __hasOwnProp$12 = Object.prototype.hasOwnProperty;
var __propIsEnum$12 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$11 = (obj, key, value) => key in obj ? __defProp$11(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$11 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$12.call(b, prop))
      __defNormalProp$11(a, prop, b[prop]);
  if (__getOwnPropSymbols$12)
    for (var prop of __getOwnPropSymbols$12(b)) {
      if (__propIsEnum$12.call(b, prop))
        __defNormalProp$11(a, prop, b[prop]);
    }
  return a;
};
class Graph extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      isTooltipVisible: false,
      isContextVisible: false
    };
    this.element = null;
    this.onPlotSelected = (event, ranges) => {
      const { onHorizontalRegionSelected } = this.props;
      if (onHorizontalRegionSelected) {
        onHorizontalRegionSelected(ranges.xaxis.from, ranges.xaxis.to);
      }
    };
    this.onPlotHover = (event, pos, item) => {
      this.setState({
        isTooltipVisible: true,
        activeItem: item,
        pos
      });
    };
    this.onPlotClick = (event, contextPos, item) => {
      this.setState({
        isContextVisible: true,
        isTooltipVisible: false,
        contextItem: item,
        contextPos
      });
    };
    this.renderTooltip = () => {
      const { children, series, timeZone } = this.props;
      const { pos, activeItem, isTooltipVisible } = this.state;
      let tooltipElement = null;
      if (!isTooltipVisible || !pos || series.length === 0) {
        return null;
      }
      React__default["default"].Children.forEach(children, (c) => {
        if (tooltipElement) {
          return;
        }
        const childType = c && c.type && (c.type.displayName || c.type.name);
        if (childType === VizTooltip.displayName) {
          tooltipElement = c;
        }
      });
      if (!tooltipElement) {
        return null;
      }
      const tooltipElementProps = tooltipElement.props;
      const tooltipMode = tooltipElementProps.mode || "single";
      if (!activeItem && tooltipMode === "single") {
        return null;
      }
      const tooltipContentRenderer = tooltipElementProps.tooltipComponent || GraphTooltip;
      const seriesIndex = activeItem ? activeItem.series.seriesIndex : 0;
      const rowIndex = activeItem ? activeItem.dataIndex : void 0;
      const activeDimensions = {
        // Described x-axis active item
        // When hovering over an item - let's take it's dataIndex, otherwise undefined
        // Tooltip itself needs to figure out correct datapoint display information based on pos passed to it
        xAxis: [seriesIndex, rowIndex],
        // Describes y-axis active item
        yAxis: activeItem ? [activeItem.series.seriesIndex, activeItem.dataIndex] : null
      };
      const tooltipContentProps = {
        dimensions: {
          // time/value dimension columns are index-aligned - see getGraphSeriesModel
          xAxis: data.createDimension(
            "xAxis",
            series.map((s) => s.timeField)
          ),
          yAxis: data.createDimension(
            "yAxis",
            series.map((s) => s.valueField)
          )
        },
        activeDimensions,
        pos,
        mode: tooltipElementProps.mode || schema.TooltipDisplayMode.Single,
        timeZone
      };
      const tooltipContent = React__default["default"].createElement(tooltipContentRenderer, __spreadValues$11({}, tooltipContentProps));
      return React__default["default"].cloneElement(tooltipElement, {
        content: tooltipContent,
        position: { x: pos.pageX, y: pos.pageY },
        offset: { x: 10, y: 10 }
      });
    };
    this.renderContextMenu = () => {
      const { series } = this.props;
      const { contextPos, contextItem, isContextVisible } = this.state;
      if (!isContextVisible || !contextPos || !contextItem || series.length === 0) {
        return null;
      }
      const seriesIndex = contextItem ? contextItem.series.seriesIndex : 0;
      const rowIndex = contextItem ? contextItem.dataIndex : void 0;
      const contextDimensions = {
        // Described x-axis context item
        xAxis: [seriesIndex, rowIndex],
        // Describes y-axis context item
        yAxis: contextItem ? [contextItem.series.seriesIndex, contextItem.dataIndex] : null
      };
      const dimensions = {
        // time/value dimension columns are index-aligned - see getGraphSeriesModel
        xAxis: data.createDimension(
          "xAxis",
          series.map((s) => s.timeField)
        ),
        yAxis: data.createDimension(
          "yAxis",
          series.map((s) => s.valueField)
        )
      };
      const closeContext = () => this.setState({ isContextVisible: false });
      const getContextMenuSource = () => {
        return {
          datapoint: contextItem.datapoint,
          dataIndex: contextItem.dataIndex,
          series: contextItem.series,
          seriesIndex: contextItem.series.seriesIndex,
          pageX: contextPos.pageX,
          pageY: contextPos.pageY
        };
      };
      const contextContentProps = {
        x: contextPos.pageX,
        y: contextPos.pageY,
        onClose: closeContext,
        getContextMenuSource,
        timeZone: this.props.timeZone,
        dimensions,
        contextDimensions
      };
      return /* @__PURE__ */ React__default["default"].createElement(GraphContextMenu, __spreadValues$11({}, contextContentProps));
    };
    this.getBarWidth = () => {
      const { series } = this.props;
      return Math.min(...series.map((s) => s.timeStep));
    };
  }
  componentDidUpdate(prevProps, prevState) {
    if (prevProps !== this.props) {
      this.draw();
    }
  }
  componentDidMount() {
    this.draw();
    if (this.element) {
      this.$element = $__default["default"](this.element);
      this.$element.bind("plotselected", this.onPlotSelected);
      this.$element.bind("plothover", this.onPlotHover);
      this.$element.bind("plotclick", this.onPlotClick);
    }
  }
  componentWillUnmount() {
    if (this.$element) {
      this.$element.unbind("plotselected", this.onPlotSelected);
    }
  }
  getYAxes(series) {
    if (series.length === 0) {
      return [{ show: true, min: -1, max: 1 }];
    }
    return lodash.uniqBy(
      series.map((s) => {
        const index = s.yAxis ? s.yAxis.index : 1;
        const min = s.yAxis && s.yAxis.min && !isNaN(s.yAxis.min) ? s.yAxis.min : null;
        const tickDecimals = s.yAxis && s.yAxis.tickDecimals && !isNaN(s.yAxis.tickDecimals) ? s.yAxis.tickDecimals : null;
        return {
          show: true,
          index,
          position: index === 1 ? "left" : "right",
          min,
          tickDecimals
        };
      }),
      (yAxisConfig) => yAxisConfig.index
    );
  }
  draw() {
    if (this.element === null) {
      return;
    }
    const {
      width,
      series,
      timeRange,
      showLines,
      showBars,
      showPoints,
      isStacked,
      lineWidth,
      timeZone,
      onHorizontalRegionSelected
    } = this.props;
    if (!width) {
      return;
    }
    const ticks = width / 100;
    const min = timeRange.from.valueOf();
    const max = timeRange.to.valueOf();
    const yaxes = this.getYAxes(series);
    const flotOptions = {
      legend: {
        show: false
      },
      series: {
        stack: isStacked,
        lines: {
          show: showLines,
          lineWidth,
          zero: false
        },
        points: {
          show: showPoints,
          fill: 1,
          fillColor: false,
          radius: 2
        },
        bars: {
          show: showBars,
          fill: 1,
          // Dividig the width by 1.5 to make the bars not touch each other
          barWidth: showBars ? this.getBarWidth() / 1.5 : 1,
          zero: false,
          lineWidth
        },
        shadowSize: 0
      },
      xaxis: {
        timezone: timeZone,
        show: true,
        mode: "time",
        min,
        max,
        label: "Datetime",
        ticks,
        timeformat: graphTimeFormat(ticks, min, max),
        tickFormatter: graphTickFormatter
      },
      yaxes,
      grid: {
        minBorderMargin: 0,
        markings: [],
        backgroundColor: null,
        borderWidth: 0,
        hoverable: true,
        clickable: true,
        color: "#a1a1a1",
        margin: { left: 0, right: 0 },
        labelMarginX: 0,
        mouseActiveRadius: 30
      },
      selection: {
        mode: onHorizontalRegionSelected ? "x" : null,
        color: "#666"
      },
      crosshair: {
        mode: "x"
      }
    };
    try {
      $__default["default"].plot(
        this.element,
        series.filter((s) => s.isVisible),
        flotOptions
      );
    } catch (err) {
      console.error("Graph rendering error", err, flotOptions, series);
      throw new Error("Error rendering panel");
    }
  }
  render() {
    const { ariaLabel, height, width, series } = this.props;
    const noDataToBeDisplayed = series.length === 0;
    const tooltip = this.renderTooltip();
    const context = this.renderContextMenu();
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: "graph-panel", "aria-label": ariaLabel }, /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        className: "graph-panel__chart",
        ref: (e) => this.element = e,
        style: { height, width },
        onMouseLeave: () => {
          this.setState({ isTooltipVisible: false });
        }
      }
    ), noDataToBeDisplayed && /* @__PURE__ */ React__default["default"].createElement("div", { className: "datapoints-warning" }, "No data"), tooltip, context);
  }
}
Graph.defaultProps = {
  showLines: true,
  showPoints: false,
  showBars: false,
  isStacked: false,
  lineWidth: 1
};

const commonColorsPalette = {
  // New greys palette used by next-gen form elements
  gray98: "#f7f8fa",
  gray97: "#f1f5f9",
  gray95: "#e9edf2",
  gray90: "#dce1e6",
  gray85: "#c7d0d9",
  gray70: "#9fa7b3",
  gray60: "#7b8087",
  gray33: "#464c54",
  gray25: "#2c3235",
  gray15: "#202226",
  gray10: "#141619",
  gray05: "#0b0c0e",
  // New blues palette used by next-gen form elements
  blue95: "#5794f2",
  // blue95
  blue85: "#33a2e5",
  // blueText
  blue80: "#3274d9",
  // blue80
  blue77: "#1f60c4",
  // blue77
  // New reds palette used by next-gen form elements
  red88: "#e02f44"
};

const ErrorIndicator = ({ error, onClick }) => {
  const styles = useStyles2(getStyles$M);
  if (!error) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { theme: "error", content: error }, /* @__PURE__ */ React__default["default"].createElement(
    Icon,
    {
      onClick,
      className: css.cx(styles.icon, { [styles.clickable]: !!onClick }),
      size: "sm",
      name: "exclamation-triangle"
    }
  ));
};
const getStyles$M = () => {
  return {
    clickable: css.css({
      cursor: "pointer"
    }),
    icon: css.css({
      color: `${commonColorsPalette.red88}`
    })
  };
};

const LoadingIndicator = ({ onCancel, loading }) => {
  const styles = useStyles2(getStyles$L);
  if (!loading) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: "Cancel query" }, /* @__PURE__ */ React__default["default"].createElement(
    Icon,
    {
      className: css.cx("spin-clockwise", { [styles.clickable]: !!onCancel }),
      name: "sync",
      size: "sm",
      onClick: onCancel,
      "aria-label": e2eSelectors.selectors.components.LoadingIndicator.icon
    }
  ));
};
const getStyles$L = () => {
  return {
    clickable: css.css({
      cursor: "pointer"
    })
  };
};

function DelayRender({ children, delay }) {
  const [shouldRender, setShouldRender] = React.useState(false);
  React.useEffect(() => {
    window.setTimeout(() => {
      setShouldRender(true);
    }, delay);
  }, [children, delay]);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, shouldRender ? children : null);
}

var __defProp$10 = Object.defineProperty;
var __defProps$I = Object.defineProperties;
var __getOwnPropDescs$I = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$11 = Object.getOwnPropertySymbols;
var __hasOwnProp$11 = Object.prototype.hasOwnProperty;
var __propIsEnum$11 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$10 = (obj, key, value) => key in obj ? __defProp$10(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$10 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$11.call(b, prop))
      __defNormalProp$10(a, prop, b[prop]);
  if (__getOwnPropSymbols$11)
    for (var prop of __getOwnPropSymbols$11(b)) {
      if (__propIsEnum$11.call(b, prop))
        __defNormalProp$10(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$I = (a, b) => __defProps$I(a, __getOwnPropDescs$I(b));
const Dropdown = React__default["default"].memo(({ children, overlay, placement, offset, onVisibleChange }) => {
  const [show, setShow] = React.useState(false);
  const transitionRef = React.useRef(null);
  React.useEffect(() => {
    onVisibleChange == null ? void 0 : onVisibleChange(show);
  }, [onVisibleChange, show]);
  const { getArrowProps, getTooltipProps, setTooltipRef, setTriggerRef, visible } = reactPopperTooltip.usePopperTooltip({
    visible: show,
    placement,
    onVisibleChange: setShow,
    interactive: true,
    delayHide: 0,
    delayShow: 0,
    offset: offset != null ? offset : [0, 8],
    trigger: ["click"]
  });
  const animationDuration = 150;
  const animationStyles = getStyles$K(animationDuration);
  const onOverlayClicked = () => {
    setShow(false);
  };
  const handleKeys = (event) => {
    if (event.key === "Escape" || event.key === "Tab") {
      setShow(false);
    }
  };
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, React__default["default"].cloneElement(typeof children === "function" ? children(visible) : children, {
    ref: setTriggerRef
  }), visible && /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { autoFocus: true, restoreFocus: true, contain: true }, /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$I(__spreadValues$10({ ref: setTooltipRef }, getTooltipProps()), { onClick: onOverlayClicked, onKeyDown: handleKeys }), /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$10({}, getArrowProps({ className: "tooltip-arrow" }))), /* @__PURE__ */ React__default["default"].createElement(
    reactTransitionGroup.CSSTransition,
    {
      nodeRef: transitionRef,
      appear: true,
      in: true,
      timeout: { appear: animationDuration, exit: 0, enter: 0 },
      classNames: animationStyles
    },
    /* @__PURE__ */ React__default["default"].createElement("div", { ref: transitionRef }, renderOrCallToRender(overlay))
  )))));
});
Dropdown.displayName = "Dropdown";
const getStyles$K = (duration) => {
  return {
    appear: css.css({
      opacity: "0",
      position: "relative",
      transform: "scaleY(0.5)",
      transformOrigin: "top"
    }),
    appearActive: css.css({
      opacity: "1",
      transform: "scaleY(1)",
      transition: `transform ${duration}ms cubic-bezier(0.2, 0, 0.2, 1), opacity ${duration}ms cubic-bezier(0.2, 0, 0.2, 1)`
    })
  };
};

function PanelMenu({
  menu,
  title,
  placement = "bottom",
  offset,
  dragClassCancel,
  menuButtonClass,
  onVisibleChange,
  onOpenMenu
}) {
  const testId = title ? e2eSelectors.selectors.components.Panels.Panel.menu(title) : `panel-menu-button`;
  const handleVisibility = React.useCallback(
    (show) => {
      if (show && onOpenMenu) {
        onOpenMenu();
      }
      return onVisibleChange;
    },
    [onOpenMenu, onVisibleChange]
  );
  return /* @__PURE__ */ React__default["default"].createElement(Dropdown, { overlay: menu, placement, offset, onVisibleChange: handleVisibility }, /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    {
      "aria-label": `Menu for panel with ${title ? `title ${title}` : "no title"}`,
      title: "Menu",
      icon: "ellipsis-v",
      iconSize: "md",
      narrow: true,
      "data-testid": testId,
      className: css.cx(menuButtonClass, dragClassCancel)
    }
  ));
}

function HoverWidget({ menu, title, dragClass, children, offset = -32, onOpenMenu }) {
  const styles = useStyles2(getStyles$J);
  const draggableRef = React.useRef(null);
  const onPointerDown = React.useCallback((e) => {
    var _a;
    (_a = draggableRef.current) == null ? void 0 : _a.setPointerCapture(e.pointerId);
  }, []);
  const onPointerUp = React.useCallback((e) => {
    var _a;
    (_a = draggableRef.current) == null ? void 0 : _a.releasePointerCapture(e.pointerId);
  }, []);
  const [menuOpen, setMenuOpen] = React.useState(false);
  if (children === void 0 || React__default["default"].Children.count(children) === 0) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.container, { "show-on-hover": !menuOpen }),
      style: { top: `${offset}px` },
      "data-testid": "hover-header-container"
    },
    dragClass && /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        className: css.cx(styles.square, styles.draggable, dragClass),
        onPointerDown,
        onPointerUp,
        ref: draggableRef
      },
      /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "expand-arrows", className: styles.draggableIcon })
    ),
    !title && /* @__PURE__ */ React__default["default"].createElement("h6", { className: css.cx(styles.untitled, styles.draggable, dragClass) }, "Untitled"),
    children,
    menu && /* @__PURE__ */ React__default["default"].createElement(
      PanelMenu,
      {
        menu,
        title,
        placement: "bottom",
        menuButtonClass: styles.menuButton,
        onVisibleChange: setMenuOpen,
        onOpenMenu
      }
    )
  );
}
function getStyles$J(theme) {
  return {
    hidden: css.css({
      visibility: "hidden",
      opacity: "0"
    }),
    container: css.css({
      label: "hover-container-widget",
      transition: `all .1s linear`,
      display: "flex",
      position: "absolute",
      zIndex: 1,
      right: 0,
      boxSizing: "content-box",
      alignItems: "center",
      background: theme.colors.background.secondary,
      color: theme.colors.text.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      borderRadius: theme.shape.radius.default,
      height: theme.spacing(4),
      boxShadow: theme.shadows.z1
    }),
    square: css.css({
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      width: theme.spacing(4),
      height: "100%"
    }),
    draggable: css.css({
      cursor: "move",
      // mobile do not support draggable panels
      [theme.breakpoints.down("md")]: {
        display: "none"
      }
    }),
    menuButton: css.css({
      // Background and border are overriden when topnav toggle is disabled
      background: "inherit",
      border: "none",
      "&:hover": {
        background: theme.colors.secondary.main
      }
    }),
    untitled: css.css({
      color: theme.colors.text.disabled,
      fontStyle: "italic",
      padding: theme.spacing(0, 1),
      marginBottom: 0
    }),
    draggableIcon: css.css({
      transform: "rotate(45deg)",
      color: theme.colors.text.secondary,
      "&:hover": {
        color: theme.colors.text.primary
      }
    })
  };
}

var __defProp$$ = Object.defineProperty;
var __defProps$H = Object.defineProperties;
var __getOwnPropDescs$H = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$10 = Object.getOwnPropertySymbols;
var __hasOwnProp$10 = Object.prototype.hasOwnProperty;
var __propIsEnum$10 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$$ = (obj, key, value) => key in obj ? __defProp$$(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$$ = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$10.call(b, prop))
      __defNormalProp$$(a, prop, b[prop]);
  if (__getOwnPropSymbols$10)
    for (var prop of __getOwnPropSymbols$10(b)) {
      if (__propIsEnum$10.call(b, prop))
        __defNormalProp$$(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$H = (a, b) => __defProps$H(a, __getOwnPropDescs$H(b));
var __objRest$y = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$10.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$10)
    for (var prop of __getOwnPropSymbols$10(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$10.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const TitleItem = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { className, children, href, onClick, target, title } = _b, rest = __objRest$y(_b, ["className", "children", "href", "onClick", "target", "title"]);
    const styles = useStyles2(getStyles$I);
    if (href) {
      return /* @__PURE__ */ React__default["default"].createElement(
        "a",
        __spreadValues$$({
          ref,
          href,
          onClick,
          target,
          title,
          className: css.cx(styles.linkItem, className)
        }, rest),
        children
      );
    } else if (onClick) {
      return /* @__PURE__ */ React__default["default"].createElement(Button, { ref, className: css.cx(styles.item, className), variant: "secondary", fill: "text", onClick }, children);
    } else {
      return /* @__PURE__ */ React__default["default"].createElement("span", __spreadValues$$({ ref, className: css.cx(styles.item, className) }, rest), children);
    }
  }
);
TitleItem.displayName = "TitleItem";
const getStyles$I = (theme) => {
  const item = css.css({
    color: `${theme.colors.text.secondary}`,
    label: "panel-header-item",
    cursor: "auto",
    border: "none",
    borderRadius: `${theme.shape.borderRadius()}`,
    padding: `${theme.spacing(0, 1)}`,
    height: `${theme.spacing(theme.components.panel.headerHeight)}`,
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    "&:focus, &:focus-visible": __spreadProps$H(__spreadValues$$({}, getFocusStyles(theme)), {
      zIndex: 1
    }),
    "&: focus:not(:focus-visible)": getMouseFocusStyles(),
    "&:hover ": {
      boxShadow: `${theme.shadows.z1}`,
      background: `${theme.colors.background.secondary}`,
      color: `${theme.colors.text.primary}`
    }
  });
  return {
    item,
    linkItem: css.cx(item, css.css({ cursor: "pointer" }))
  };
};

function PanelDescription({ description, className }) {
  const styles = useStyles2(getStyles$H);
  const getDescriptionContent = () => {
    const panelDescription = typeof description === "function" ? description() : description;
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: "panel-info-content markdown-html" }, /* @__PURE__ */ React__default["default"].createElement("div", { dangerouslySetInnerHTML: { __html: panelDescription } }));
  };
  return description !== "" ? /* @__PURE__ */ React__default["default"].createElement(Tooltip, { interactive: true, content: getDescriptionContent }, /* @__PURE__ */ React__default["default"].createElement(TitleItem, { className: css.cx(className, styles.description) }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "info-circle", size: "md" }))) : null;
}
const getStyles$H = (theme) => {
  return {
    description: css.css({
      code: {
        whiteSpace: "normal",
        wordWrap: "break-word"
      },
      "pre > code": {
        display: "block"
      }
    })
  };
};

function PanelStatus({ message, onClick, ariaLabel = "status" }) {
  const styles = useStyles2(getStyles$G);
  return /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    {
      className: styles.buttonStyles,
      onClick,
      variant: "destructive",
      icon: "exclamation-triangle",
      iconSize: "md",
      tooltip: message || "",
      "aria-label": ariaLabel
    }
  );
}
const getStyles$G = (theme) => {
  const { headerHeight, padding } = theme.components.panel;
  return {
    buttonStyles: css.css({
      label: "panel-header-state-button",
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      padding: theme.spacing(padding),
      width: theme.spacing(headerHeight),
      height: theme.spacing(headerHeight),
      borderRadius: theme.shape.radius.default
    })
  };
};

function PanelChrome$1({
  width,
  height,
  children,
  padding = "md",
  title = "",
  description = "",
  displayMode = "default",
  titleItems,
  menu,
  dragClass,
  dragClassCancel,
  hoverHeader = false,
  hoverHeaderOffset,
  loadingState,
  statusMessage,
  statusMessageOnClick,
  leftItems,
  actions,
  onCancelQuery,
  onOpenMenu
}) {
  const theme = useTheme2();
  const styles = useStyles2(getStyles$F);
  const hasHeader = !hoverHeader;
  const showOnHoverClass = "show-on-hover";
  const headerHeight = getHeaderHeight(theme, hasHeader);
  const { contentStyle, innerWidth, innerHeight } = getContentStyle(padding, theme, width, headerHeight, height);
  const headerStyles = {
    height: headerHeight,
    cursor: dragClass ? "move" : "auto"
  };
  const containerStyles = { width, height };
  if (displayMode === "transparent") {
    containerStyles.backgroundColor = "transparent";
    containerStyles.border = "none";
  }
  if (leftItems) {
    actions = leftItems;
  }
  const testid = title ? e2eSelectors.selectors.components.Panels.Panel.title(title) : "Panel";
  const headerContent = /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, title && /* @__PURE__ */ React__default["default"].createElement("h6", { title, className: styles.title }, title), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.titleItems, dragClassCancel), "data-testid": "title-items-container" }, /* @__PURE__ */ React__default["default"].createElement(PanelDescription, { description, className: dragClassCancel }), titleItems), loadingState === data.LoadingState.Streaming && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: onCancelQuery ? "Stop streaming" : "Streaming" }, /* @__PURE__ */ React__default["default"].createElement(TitleItem, { className: dragClassCancel, "data-testid": "panel-streaming", onClick: onCancelQuery }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "circle-mono", size: "md", className: styles.streaming }))), loadingState === data.LoadingState.Loading && onCancelQuery && /* @__PURE__ */ React__default["default"].createElement(DelayRender, { delay: 2e3 }, /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: "Cancel query" }, /* @__PURE__ */ React__default["default"].createElement(
    TitleItem,
    {
      className: css.cx(dragClassCancel, styles.pointer),
      "data-testid": "panel-cancel-query",
      onClick: onCancelQuery
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "sync-slash", size: "md" })
  ))), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightAligned }, actions && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightActions }, itemsRenderer(actions, (item) => item))));
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container, style: containerStyles, "data-testid": testid }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.loadingBarContainer }, loadingState === data.LoadingState.Loading ? /* @__PURE__ */ React__default["default"].createElement(LoadingBar, { width, ariaLabel: "Panel loading bar" }) : null), hoverHeader && /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
    HoverWidget,
    {
      menu,
      title,
      offset: hoverHeaderOffset,
      dragClass,
      onOpenMenu
    },
    headerContent
  ), statusMessage && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.errorContainerFloating }, /* @__PURE__ */ React__default["default"].createElement(PanelStatus, { message: statusMessage, onClick: statusMessageOnClick, ariaLabel: "Panel status" }))), hasHeader && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.headerContainer, dragClass), style: headerStyles, "data-testid": "header-container" }, statusMessage && /* @__PURE__ */ React__default["default"].createElement("div", { className: dragClassCancel }, /* @__PURE__ */ React__default["default"].createElement(PanelStatus, { message: statusMessage, onClick: statusMessageOnClick, ariaLabel: "Panel status" })), headerContent, menu && /* @__PURE__ */ React__default["default"].createElement(
    PanelMenu,
    {
      menu,
      title,
      placement: "bottom-end",
      menuButtonClass: css.cx(styles.menuItem, dragClassCancel, showOnHoverClass),
      onOpenMenu
    }
  )), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.content, style: contentStyle }, children(innerWidth, innerHeight)));
}
const itemsRenderer = (items, renderer) => {
  const toRender = React__default["default"].Children.toArray(items).filter(Boolean);
  return toRender.length > 0 ? renderer(toRender) : null;
};
const getHeaderHeight = (theme, hasHeader) => {
  if (hasHeader) {
    return theme.spacing.gridSize * theme.components.panel.headerHeight;
  }
  return 0;
};
const getContentStyle = (padding, theme, width, headerHeight, height) => {
  const chromePadding = (padding === "md" ? theme.components.panel.padding : 0) * theme.spacing.gridSize;
  const panelPadding = chromePadding * 2;
  const panelBorder = 1 * 2;
  const innerWidth = width - panelPadding - panelBorder;
  const innerHeight = height - headerHeight - panelPadding - panelBorder;
  const contentStyle = {
    padding: chromePadding
  };
  return { contentStyle, innerWidth, innerHeight };
};
const getStyles$F = (theme) => {
  const { background, borderColor, padding } = theme.components.panel;
  return {
    container: css.css({
      label: "panel-container",
      backgroundColor: background,
      border: `1px solid ${borderColor}`,
      position: "relative",
      borderRadius: theme.shape.borderRadius(1),
      height: "100%",
      display: "flex",
      flexDirection: "column",
      flex: "1 1 0",
      ".show-on-hover": {
        visibility: "hidden",
        opacity: "0"
      },
      "&:focus-visible, &:hover": {
        // only show menu icon on hover or focused panel
        ".show-on-hover": {
          visibility: "visible",
          opacity: "1"
        }
      },
      "&:focus-visible": {
        outline: `1px solid ${theme.colors.action.focus}`
      },
      "&:focus-within": {
        ".show-on-hover": {
          visibility: "visible",
          opacity: "1"
        }
      }
    }),
    loadingBarContainer: css.css({
      label: "panel-loading-bar-container",
      position: "absolute",
      top: 0,
      width: "100%",
      overflow: "hidden"
    }),
    content: css.css({
      label: "panel-content",
      flexGrow: 1,
      contain: "strict"
    }),
    headerContainer: css.css({
      label: "panel-header",
      display: "flex",
      alignItems: "center"
    }),
    pointer: css.css({
      cursor: "pointer"
    }),
    streaming: css.css({
      label: "panel-streaming",
      marginRight: 0,
      color: theme.colors.success.text,
      "&:hover": {
        color: theme.colors.success.text
      }
    }),
    title: css.css({
      label: "panel-title",
      marginBottom: 0,
      // override default h6 margin-bottom
      padding: theme.spacing(0, padding),
      textOverflow: "ellipsis",
      overflow: "hidden",
      whiteSpace: "nowrap",
      fontSize: theme.typography.h6.fontSize,
      fontWeight: theme.typography.h6.fontWeight
    }),
    items: css.css({
      display: "flex"
    }),
    item: css.css({
      display: "flex",
      justifyContent: "center",
      alignItems: "center"
    }),
    hiddenMenu: css.css({
      visibility: "hidden"
    }),
    menuItem: css.css({
      label: "panel-menu",
      border: "none",
      background: theme.colors.secondary.main,
      "&:hover": {
        background: theme.colors.secondary.shade
      }
    }),
    errorContainerFloating: css.css({
      label: "error-container",
      position: "absolute",
      left: 0,
      top: 0,
      zIndex: theme.zIndex.tooltip
    }),
    rightActions: css.css({
      display: "flex",
      padding: theme.spacing(0, padding),
      gap: theme.spacing(1)
    }),
    rightAligned: css.css({
      label: "right-aligned-container",
      marginLeft: "auto",
      display: "flex",
      alignItems: "center"
    }),
    titleItems: css.css({
      display: "flex",
      height: "100%"
    })
  };
};

var SeriesVisibilityChangeMode = /* @__PURE__ */ ((SeriesVisibilityChangeMode2) => {
  SeriesVisibilityChangeMode2["ToggleSelection"] = "select";
  SeriesVisibilityChangeMode2["AppendToSelection"] = "append";
  return SeriesVisibilityChangeMode2;
})(SeriesVisibilityChangeMode || {});

const PanelChrome = PanelChrome$1;
PanelChrome.LoadingIndicator = LoadingIndicator;
PanelChrome.ErrorIndicator = ErrorIndicator;
PanelChrome.TitleItem = TitleItem;

var __defProp$_ = Object.defineProperty;
var __getOwnPropSymbols$$ = Object.getOwnPropertySymbols;
var __hasOwnProp$$ = Object.prototype.hasOwnProperty;
var __propIsEnum$$ = Object.prototype.propertyIsEnumerable;
var __defNormalProp$_ = (obj, key, value) => key in obj ? __defProp$_(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$_ = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$$.call(b, prop))
      __defNormalProp$_(a, prop, b[prop]);
  if (__getOwnPropSymbols$$)
    for (var prop of __getOwnPropSymbols$$(b)) {
      if (__propIsEnum$$.call(b, prop))
        __defNormalProp$_(a, prop, b[prop]);
    }
  return a;
};
class InlineList extends React.PureComponent {
  render() {
    return /* @__PURE__ */ React__default["default"].createElement(AbstractList, __spreadValues$_({ inline: true }, this.props));
  }
}

const VizLegendSeriesIcon = React__default["default"].memo(({ seriesName, color, gradient, readonly }) => {
  const { onSeriesColorChange } = usePanelContext();
  const onChange = React.useCallback(
    (color2) => {
      return onSeriesColorChange(seriesName, color2);
    },
    [seriesName, onSeriesColorChange]
  );
  if (seriesName && onSeriesColorChange && color && !readonly) {
    return /* @__PURE__ */ React__default["default"].createElement(SeriesColorPicker, { color, onChange, enableNamedColors: true }, ({ ref, showColorPicker, hideColorPicker }) => /* @__PURE__ */ React__default["default"].createElement(
      SeriesIcon,
      {
        color,
        className: "pointer",
        ref,
        onClick: showColorPicker,
        onMouseLeave: hideColorPicker
      }
    ));
  }
  return /* @__PURE__ */ React__default["default"].createElement(SeriesIcon, { color, gradient });
});
VizLegendSeriesIcon.displayName = "VizLegendSeriesIcon";

const VizLegendStatsList = ({ stats }) => {
  const styles = useStyles2(getStyles$E);
  if (stats.length === 0) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    InlineList,
    {
      className: styles.list,
      items: stats,
      renderItem: (stat) => /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.item, title: stat.description }, stat.title && `${lodash.capitalize(stat.title)}:`, " ", data.formattedValueToString(stat))
    }
  );
};
const getStyles$E = () => ({
  list: css.css`
    flex-grow: 1;
    text-align: right;
  `,
  item: css.css`
    margin-left: 8px;
  `
});
VizLegendStatsList.displayName = "VizLegendStatsList";

const VizLegendListItem = ({
  item,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  className,
  readonly
}) => {
  const styles = useStyles2(getStyles$D);
  const onMouseOver = React.useCallback(
    (event) => {
      if (onLabelMouseOver) {
        onLabelMouseOver(item, event);
      }
    },
    [item, onLabelMouseOver]
  );
  const onMouseOut = React.useCallback(
    (event) => {
      if (onLabelMouseOut) {
        onLabelMouseOut(item, event);
      }
    },
    [item, onLabelMouseOut]
  );
  const onClick = React.useCallback(
    (event) => {
      if (onLabelClick) {
        onLabelClick(item, event);
      }
    },
    [item, onLabelClick]
  );
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.itemWrapper, item.disabled && styles.itemDisabled, className),
      "aria-label": e2eSelectors.selectors.components.VizLegend.seriesName(item.label)
    },
    /* @__PURE__ */ React__default["default"].createElement(VizLegendSeriesIcon, { seriesName: item.label, color: item.color, gradient: item.gradient, readonly }),
    /* @__PURE__ */ React__default["default"].createElement(
      "button",
      {
        disabled: readonly,
        type: "button",
        onBlur: onMouseOut,
        onFocus: onMouseOver,
        onMouseOver,
        onMouseOut,
        onClick,
        className: styles.label
      },
      item.label
    ),
    item.getDisplayValues && /* @__PURE__ */ React__default["default"].createElement(VizLegendStatsList, { stats: item.getDisplayValues() })
  );
};
VizLegendListItem.displayName = "VizLegendListItem";
const getStyles$D = (theme) => ({
  label: css.css`
    label: LegendLabel;
    white-space: nowrap;
    background: none;
    border: none;
    font-size: inherit;
    padding: 0;
    user-select: text;
  `,
  itemDisabled: css.css`
    label: LegendLabelDisabled;
    color: ${theme.colors.text.disabled};
  `,
  itemWrapper: css.css`
    label: LegendItemWrapper;
    display: flex;
    white-space: nowrap;
    align-items: center;
    flex-grow: 1;
  `,
  value: css.css`
    text-align: right;
  `,
  yAxisLabel: css.css`
    color: ${theme.v1.palette.gray2};
  `
});

const VizLegendList = ({
  items,
  itemRenderer,
  onLabelMouseOver,
  onLabelMouseOut,
  onLabelClick,
  placement,
  className,
  readonly
}) => {
  const styles = useStyles2(getStyles$C);
  if (!itemRenderer) {
    itemRenderer = (item) => /* @__PURE__ */ React__default["default"].createElement(
      VizLegendListItem,
      {
        item,
        onLabelClick,
        onLabelMouseOver,
        onLabelMouseOut,
        readonly
      }
    );
  }
  const getItemKey = (item) => `${item.getItemKey ? item.getItemKey() : item.label}`;
  switch (placement) {
    case "right": {
      const renderItem = (item, index) => {
        return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.itemRight }, itemRenderer(item, index));
      };
      return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.rightWrapper, className) }, /* @__PURE__ */ React__default["default"].createElement(List, { items, renderItem, getItemKey }));
    }
    case "bottom":
    default: {
      const renderItem = (item, index) => {
        return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.itemBottom }, itemRenderer(item, index));
      };
      return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.bottomWrapper, className) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.section }, /* @__PURE__ */ React__default["default"].createElement(
        InlineList,
        {
          items: items.filter((item) => item.yAxis === 1),
          renderItem,
          getItemKey
        }
      )), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.section, styles.sectionRight) }, /* @__PURE__ */ React__default["default"].createElement(
        InlineList,
        {
          items: items.filter((item) => item.yAxis !== 1),
          renderItem,
          getItemKey
        }
      )));
    }
  }
};
VizLegendList.displayName = "VizLegendList";
const getStyles$C = (theme) => {
  const itemStyles = css.css`
    padding-right: 10px;
    display: flex;
    font-size: ${theme.typography.bodySmall.fontSize};
    white-space: nowrap;
  `;
  return {
    itemBottom: itemStyles,
    itemRight: css.cx(
      itemStyles,
      css.css`
        margin-bottom: ${theme.spacing(0.5)};
      `
    ),
    rightWrapper: css.css`
      padding-left: ${theme.spacing(0.5)};
    `,
    bottomWrapper: css.css`
      display: flex;
      flex-wrap: wrap;
      justify-content: space-between;
      width: 100%;
      padding-left: ${theme.spacing(0.5)};
    `,
    section: css.css`
      display: flex;
    `,
    sectionRight: css.css`
      justify-content: flex-end;
      flex-grow: 1;
    `
  };
};

const LegendTableItem = ({
  item,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  className,
  readonly
}) => {
  const styles = useStyles2(getStyles$B);
  const onMouseOver = React.useCallback(
    (event) => {
      if (onLabelMouseOver) {
        onLabelMouseOver(item, event);
      }
    },
    [item, onLabelMouseOver]
  );
  const onMouseOut = React.useCallback(
    (event) => {
      if (onLabelMouseOut) {
        onLabelMouseOut(item, event);
      }
    },
    [item, onLabelMouseOut]
  );
  const onClick = React.useCallback(
    (event) => {
      if (onLabelClick) {
        onLabelClick(item, event);
      }
    },
    [item, onLabelClick]
  );
  return /* @__PURE__ */ React__default["default"].createElement("tr", { className: css.cx(styles.row, className) }, /* @__PURE__ */ React__default["default"].createElement("td", null, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.itemWrapper }, /* @__PURE__ */ React__default["default"].createElement(VizLegendSeriesIcon, { color: item.color, seriesName: item.label, readonly }), /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      disabled: readonly,
      type: "button",
      onBlur: onMouseOut,
      onFocus: onMouseOver,
      onMouseOver,
      onMouseOut,
      onClick: !readonly ? onClick : void 0,
      className: css.cx(styles.label, item.disabled && styles.labelDisabled)
    },
    item.label,
    " ",
    item.yAxis === 2 && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.yAxisLabel }, "(right y-axis)")
  ))), item.getDisplayValues && item.getDisplayValues().map((stat, index) => {
    return /* @__PURE__ */ React__default["default"].createElement("td", { className: styles.value, key: `${stat.title}-${index}` }, data.formattedValueToString(stat));
  }));
};
LegendTableItem.displayName = "LegendTableItem";
const getStyles$B = (theme) => {
  const rowHoverBg = hoverColor(theme.colors.background.primary, theme);
  return {
    row: css.css`
      label: LegendRow;
      font-size: ${theme.v1.typography.size.sm};
      border-bottom: 1px solid ${theme.colors.border.weak};
      td {
        padding: ${theme.spacing(0.25, 1)};
        white-space: nowrap;
      }

      &:hover {
        background: ${rowHoverBg};
      }
    `,
    label: css.css`
      label: LegendLabel;
      white-space: nowrap;
      background: none;
      border: none;
      font-size: inherit;
      padding: 0;
    `,
    labelDisabled: css.css`
      label: LegendLabelDisabled;
      color: ${theme.colors.text.disabled};
    `,
    itemWrapper: css.css`
      display: flex;
      white-space: nowrap;
      align-items: center;
    `,
    value: css.css`
      text-align: right;
    `,
    yAxisLabel: css.css`
      color: ${theme.colors.text.secondary};
    `
  };
};

const VizLegendTable = ({
  items,
  sortBy: sortKey,
  sortDesc,
  itemRenderer,
  className,
  onToggleSort,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  readonly
}) => {
  var _a;
  const styles = useStyles2(getStyles$A);
  const stats = {};
  for (const item of items) {
    if (item.getDisplayValues) {
      for (const displayValue of item.getDisplayValues()) {
        stats[(_a = displayValue.title) != null ? _a : "?"] = displayValue;
      }
    }
  }
  const sortedItems = sortKey ? lodash.orderBy(
    items,
    (item) => {
      if (item.getDisplayValues) {
        const stat = item.getDisplayValues().filter((stat2) => stat2.title === sortKey)[0];
        return stat && stat.numeric;
      }
      return void 0;
    },
    sortDesc ? "desc" : "asc"
  ) : items;
  if (!itemRenderer) {
    itemRenderer = (item, index) => /* @__PURE__ */ React__default["default"].createElement(
      LegendTableItem,
      {
        key: `${item.label}-${index}`,
        item,
        onLabelClick,
        onLabelMouseOver,
        onLabelMouseOut,
        readonly
      }
    );
  }
  return /* @__PURE__ */ React__default["default"].createElement("table", { className: css.cx(styles.table, className) }, /* @__PURE__ */ React__default["default"].createElement("thead", null, /* @__PURE__ */ React__default["default"].createElement("tr", null, /* @__PURE__ */ React__default["default"].createElement("th", null), Object.keys(stats).map((columnTitle) => {
    const displayValue = stats[columnTitle];
    return /* @__PURE__ */ React__default["default"].createElement(
      "th",
      {
        title: displayValue.description,
        key: columnTitle,
        className: css.cx(styles.header, onToggleSort && styles.headerSortable, {
          [styles.withIcon]: sortKey === columnTitle
        }),
        onClick: () => {
          if (onToggleSort) {
            onToggleSort(columnTitle);
          }
        }
      },
      columnTitle,
      sortKey === columnTitle && /* @__PURE__ */ React__default["default"].createElement(Icon, { size: "xs", name: sortDesc ? "angle-down" : "angle-up" })
    );
  }))), /* @__PURE__ */ React__default["default"].createElement("tbody", null, sortedItems.map(itemRenderer)));
};
const getStyles$A = (theme) => ({
  table: css.css`
    width: 100%;
    th:first-child {
      width: 100%;
      border-bottom: 1px solid ${theme.colors.border.weak};
    }
  `,
  header: css.css`
    color: ${theme.colors.primary.text};
    font-weight: ${theme.typography.fontWeightMedium};
    border-bottom: 1px solid ${theme.colors.border.weak};
    padding: ${theme.spacing(0.25, 1, 0.25, 1)};
    font-size: ${theme.typography.bodySmall.fontSize};
    text-align: right;
    white-space: nowrap;
  `,
  // This needs to be padding-right - icon size(xs==12) to avoid jumping
  withIcon: css.css`
    padding-right: 4px;
  `,
  headerSortable: css.css`
    cursor: pointer;
  `
});

var SeriesVisibilityChangeBehavior = /* @__PURE__ */ ((SeriesVisibilityChangeBehavior2) => {
  SeriesVisibilityChangeBehavior2[SeriesVisibilityChangeBehavior2["Isolate"] = 0] = "Isolate";
  SeriesVisibilityChangeBehavior2[SeriesVisibilityChangeBehavior2["Hide"] = 1] = "Hide";
  return SeriesVisibilityChangeBehavior2;
})(SeriesVisibilityChangeBehavior || {});

function mapMouseEventToMode(event) {
  if (event.ctrlKey || event.metaKey || event.shiftKey) {
    return SeriesVisibilityChangeMode.AppendToSelection;
  }
  return SeriesVisibilityChangeMode.ToggleSelection;
}

function VizLegend({
  items,
  displayMode,
  sortBy: sortKey,
  seriesVisibilityChangeBehavior = SeriesVisibilityChangeBehavior.Isolate,
  sortDesc,
  onLabelClick,
  onToggleSort,
  placement,
  className,
  itemRenderer,
  readonly
}) {
  const { eventBus, onToggleSeriesVisibility, onToggleLegendSort } = usePanelContext();
  const onMouseOver = React.useCallback(
    (item, event) => {
      eventBus == null ? void 0 : eventBus.publish({
        type: data.DataHoverEvent.type,
        payload: {
          raw: event,
          x: 0,
          y: 0,
          dataId: item.label
        }
      });
    },
    [eventBus]
  );
  const onMouseOut = React.useCallback(
    (item, event) => {
      eventBus == null ? void 0 : eventBus.publish({
        type: data.DataHoverClearEvent.type,
        payload: {
          raw: event,
          x: 0,
          y: 0,
          dataId: item.label
        }
      });
    },
    [eventBus]
  );
  const onLegendLabelClick = React.useCallback(
    (item, event) => {
      if (onLabelClick) {
        onLabelClick(item, event);
      }
      if (onToggleSeriesVisibility) {
        onToggleSeriesVisibility(
          item.label,
          seriesVisibilityChangeBehavior === SeriesVisibilityChangeBehavior.Hide ? SeriesVisibilityChangeMode.AppendToSelection : mapMouseEventToMode(event)
        );
      }
    },
    [onToggleSeriesVisibility, onLabelClick, seriesVisibilityChangeBehavior]
  );
  switch (displayMode) {
    case schema.LegendDisplayMode.Table:
      return /* @__PURE__ */ React__default["default"].createElement(
        VizLegendTable,
        {
          className,
          items,
          placement,
          sortBy: sortKey,
          sortDesc,
          onLabelClick: onLegendLabelClick,
          onToggleSort: onToggleSort || onToggleLegendSort,
          onLabelMouseOver: onMouseOver,
          onLabelMouseOut: onMouseOut,
          itemRenderer,
          readonly
        }
      );
    case schema.LegendDisplayMode.List:
      return /* @__PURE__ */ React__default["default"].createElement(
        VizLegendList,
        {
          className,
          items,
          placement,
          onLabelMouseOver: onMouseOver,
          onLabelMouseOut: onMouseOut,
          onLabelClick: onLegendLabelClick,
          itemRenderer,
          readonly
        }
      );
    default:
      return null;
  }
}
VizLegend.displayName = "VizLegend";

const getGraphWithLegendStyles = stylesFactory(({ placement }) => ({
  wrapper: css.css`
    display: flex;
    flex-direction: ${placement === "bottom" ? "column" : "row"};
  `,
  graphContainer: css.css`
    min-height: 65%;
    flex-grow: 1;
  `,
  legendContainer: css.css`
    padding: 10px 0;
    max-height: ${placement === "bottom" ? "35%" : "none"};
  `
}));
const shouldHideLegendItem = (data, hideEmpty = false, hideZero = false) => {
  const isZeroOnlySeries = data.reduce((acc, current) => acc + (current[1] || 0), 0) === 0;
  const isNullOnlySeries = !data.reduce((acc, current) => acc && current[1] !== null, true);
  return hideEmpty && isNullOnlySeries || hideZero && isZeroOnlySeries;
};
const GraphWithLegend = (props) => {
  const {
    series,
    timeRange,
    width,
    height,
    showBars,
    showLines,
    showPoints,
    sortLegendBy,
    sortLegendDesc,
    legendDisplayMode,
    legendVisibility,
    placement,
    onSeriesToggle,
    onToggleSort,
    hideEmpty,
    hideZero,
    isStacked,
    lineWidth,
    onHorizontalRegionSelected,
    timeZone,
    children,
    ariaLabel
  } = props;
  const { graphContainer, wrapper, legendContainer } = getGraphWithLegendStyles(props);
  const legendItems = series.reduce((acc, s) => {
    return shouldHideLegendItem(s.data, hideEmpty, hideZero) ? acc : acc.concat([
      {
        label: s.label,
        color: s.color || "",
        disabled: !s.isVisible,
        yAxis: s.yAxis.index,
        getDisplayValues: () => s.info || []
      }
    ]);
  }, []);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: wrapper, "aria-label": ariaLabel }, /* @__PURE__ */ React__default["default"].createElement("div", { className: graphContainer }, /* @__PURE__ */ React__default["default"].createElement(
    Graph,
    {
      series,
      timeRange,
      timeZone,
      showLines,
      showPoints,
      showBars,
      width,
      height,
      isStacked,
      lineWidth,
      onHorizontalRegionSelected
    },
    children
  )), legendVisibility && /* @__PURE__ */ React__default["default"].createElement("div", { className: legendContainer }, /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { hideHorizontalTrack: true }, /* @__PURE__ */ React__default["default"].createElement(
    VizLegend,
    {
      items: legendItems,
      displayMode: legendDisplayMode,
      placement,
      sortBy: sortLegendBy,
      sortDesc: sortLegendDesc,
      onLabelClick: (item, event) => {
        if (onSeriesToggle) {
          onSeriesToggle(item.label, event);
        }
      },
      onToggleSort
    }
  ))));
};

const calculateGridDimensions = (parentWidth, parentHeight, itemSpacing, numberOfChildren) => {
  const vertical = calculateSizeOfChild(parentWidth, parentHeight, numberOfChildren);
  const horizontal = calculateSizeOfChild(parentHeight, parentWidth, numberOfChildren);
  const square = Math.max(vertical, horizontal);
  let xCount = Math.floor(parentWidth / square);
  let yCount = Math.ceil(numberOfChildren / xCount);
  xCount = Math.ceil(numberOfChildren / yCount);
  const itemsOnLastRow = xCount - (xCount * yCount - numberOfChildren);
  const widthOnLastRow = parentWidth / itemsOnLastRow - itemSpacing + itemSpacing / itemsOnLastRow;
  return {
    width: parentWidth / xCount - itemSpacing + itemSpacing / xCount,
    height: parentHeight / yCount - itemSpacing + itemSpacing / yCount,
    widthOnLastRow,
    xCount,
    yCount
  };
};
function calculateSizeOfChild(parentWidth, parentHeight, numberOfChildren) {
  const parts = Math.ceil(Math.sqrt(numberOfChildren * parentWidth / parentHeight));
  if (Math.floor(parts * parentHeight / parentWidth) * parts < numberOfChildren) {
    return parentHeight / Math.ceil(parts * parentHeight / parentWidth);
  }
  return parentWidth / parts;
}

var __defProp$Z = Object.defineProperty;
var __defProps$G = Object.defineProperties;
var __getOwnPropDescs$G = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$_ = Object.getOwnPropertySymbols;
var __hasOwnProp$_ = Object.prototype.hasOwnProperty;
var __propIsEnum$_ = Object.prototype.propertyIsEnumerable;
var __defNormalProp$Z = (obj, key, value) => key in obj ? __defProp$Z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$Z = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$_.call(b, prop))
      __defNormalProp$Z(a, prop, b[prop]);
  if (__getOwnPropSymbols$_)
    for (var prop of __getOwnPropSymbols$_(b)) {
      if (__propIsEnum$_.call(b, prop))
        __defNormalProp$Z(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$G = (a, b) => __defProps$G(a, __getOwnPropDescs$G(b));
class VizRepeater extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      values: props.getValues()
    };
  }
  componentDidUpdate(prevProps) {
    const { renderCounter, source } = this.props;
    if (renderCounter !== prevProps.renderCounter || source !== prevProps.source) {
      this.setState({ values: this.props.getValues() });
    }
  }
  getOrientation() {
    const { orientation, width, height } = this.props;
    if (orientation === data.VizOrientation.Auto) {
      if (width > height) {
        return data.VizOrientation.Vertical;
      } else {
        return data.VizOrientation.Horizontal;
      }
    }
    return orientation;
  }
  renderGrid() {
    const { renderValue, height, width, itemSpacing, getAlignmentFactors, orientation } = this.props;
    const { values } = this.state;
    const grid = calculateGridDimensions(width, height, itemSpacing, values.length);
    const alignmentFactors = getAlignmentFactors ? getAlignmentFactors(values, grid.width, grid.height) : {};
    let xGrid = 0;
    let yGrid = 0;
    let items = [];
    for (let i = 0; i < values.length; i++) {
      const value = values[i];
      const isLastRow = yGrid === grid.yCount - 1;
      const itemWidth = isLastRow ? grid.widthOnLastRow : grid.width;
      const itemHeight = grid.height;
      const xPos = xGrid * itemWidth + itemSpacing * xGrid;
      const yPos = yGrid * itemHeight + itemSpacing * yGrid;
      const itemStyles = {
        position: "absolute",
        left: xPos,
        top: yPos,
        width: `${itemWidth}px`,
        height: `${itemHeight}px`
      };
      items.push(
        /* @__PURE__ */ React__default["default"].createElement("div", { key: i, style: itemStyles }, renderValue({
          value,
          width: itemWidth,
          height: itemHeight,
          alignmentFactors,
          orientation,
          count: values.length
        }))
      );
      xGrid++;
      if (xGrid === grid.xCount) {
        xGrid = 0;
        yGrid++;
      }
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: { position: "relative" } }, items);
  }
  render() {
    const {
      renderValue,
      height,
      width,
      itemSpacing,
      getAlignmentFactors,
      autoGrid,
      orientation,
      minVizWidth,
      minVizHeight
    } = this.props;
    const { values } = this.state;
    if (autoGrid && orientation === data.VizOrientation.Auto) {
      return this.renderGrid();
    }
    const itemStyles = {
      display: "flex"
    };
    const repeaterStyle = {
      display: "flex",
      overflow: `${minVizWidth ? "auto" : "hidden"} ${minVizHeight ? "auto" : "hidden"}`
    };
    let vizHeight = height;
    let vizWidth = width;
    let resolvedOrientation = this.getOrientation();
    switch (resolvedOrientation) {
      case data.VizOrientation.Horizontal:
        repeaterStyle.flexDirection = "column";
        repeaterStyle.height = `${height}px`;
        itemStyles.marginBottom = `${itemSpacing}px`;
        vizWidth = width;
        vizHeight = Math.max(height / values.length - itemSpacing + itemSpacing / values.length, minVizHeight != null ? minVizHeight : 0);
        break;
      case data.VizOrientation.Vertical:
        repeaterStyle.flexDirection = "row";
        repeaterStyle.justifyContent = "space-between";
        itemStyles.marginRight = `${itemSpacing}px`;
        vizHeight = height;
        vizWidth = Math.max(width / values.length - itemSpacing + itemSpacing / values.length, minVizWidth != null ? minVizWidth : 0);
    }
    itemStyles.width = `${vizWidth}px`;
    itemStyles.height = `${vizHeight}px`;
    const alignmentFactors = getAlignmentFactors ? getAlignmentFactors(values, vizWidth, vizHeight) : {};
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: repeaterStyle }, values.map((value, index) => {
      return /* @__PURE__ */ React__default["default"].createElement("div", { key: index, style: getItemStylesForIndex(itemStyles, index, values.length) }, renderValue({
        value,
        width: vizWidth,
        height: vizHeight,
        alignmentFactors,
        orientation: resolvedOrientation,
        count: values.length
      }));
    }));
  }
}
VizRepeater.defaultProps = {
  itemSpacing: 8
};
function getItemStylesForIndex(itemStyles, index, length) {
  if (index === length - 1) {
    return __spreadProps$G(__spreadValues$Z({}, itemStyles), {
      marginRight: 0,
      marginBottom: 0
    });
  }
  return itemStyles;
}

var __defProp$Y = Object.defineProperty;
var __getOwnPropSymbols$Z = Object.getOwnPropertySymbols;
var __hasOwnProp$Z = Object.prototype.hasOwnProperty;
var __propIsEnum$Z = Object.prototype.propertyIsEnumerable;
var __defNormalProp$Y = (obj, key, value) => key in obj ? __defProp$Y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$Y = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$Z.call(b, prop))
      __defNormalProp$Y(a, prop, b[prop]);
  if (__getOwnPropSymbols$Z)
    for (var prop of __getOwnPropSymbols$Z(b)) {
      if (__propIsEnum$Z.call(b, prop))
        __defNormalProp$Y(a, prop, b[prop]);
    }
  return a;
};
var __objRest$x = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$Z.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$Z)
    for (var prop of __getOwnPropSymbols$Z(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$Z.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Alert = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, {
      title,
      onRemove,
      children,
      buttonContent,
      elevated,
      bottomSpacing,
      topSpacing,
      className,
      severity = "error"
    } = _b, restProps = __objRest$x(_b, [
      "title",
      "onRemove",
      "children",
      "buttonContent",
      "elevated",
      "bottomSpacing",
      "topSpacing",
      "className",
      "severity"
    ]);
    const theme = useTheme2();
    const hasTitle = Boolean(title);
    const styles = getStyles$z(theme, severity, hasTitle, elevated, bottomSpacing, topSpacing);
    const rolesBySeverity = {
      error: "alert",
      warning: "alert",
      info: "status",
      success: "status"
    };
    const role = restProps["role"] || rolesBySeverity[severity];
    const ariaLabel = restProps["aria-label"] || title;
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      __spreadValues$Y({
        ref,
        className: css.cx(styles.alert, className),
        "data-testid": e2eSelectors.selectors.components.Alert.alertV2(severity),
        role,
        "aria-label": ariaLabel
      }, restProps),
      /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.icon }, /* @__PURE__ */ React__default["default"].createElement(Icon, { size: "xl", name: getIconFromSeverity(severity) })),
      /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.body }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.title }, title), children && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.content }, children)),
      onRemove && !buttonContent && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.close }, /* @__PURE__ */ React__default["default"].createElement(IconButton, { "aria-label": "Close alert", name: "times", onClick: onRemove, size: "lg", type: "button" })),
      onRemove && buttonContent && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.buttonWrapper }, /* @__PURE__ */ React__default["default"].createElement(Button, { "aria-label": "Close alert", variant: "secondary", onClick: onRemove, type: "button" }, buttonContent))
    );
  }
);
Alert.displayName = "Alert";
const getIconFromSeverity = (severity) => {
  switch (severity) {
    case "error":
    case "warning":
      return "exclamation-triangle";
    case "info":
      return "info-circle";
    case "success":
      return "check";
  }
};
const getStyles$z = (theme, severity, hasTitle, elevated, bottomSpacing, topSpacing) => {
  const color = theme.colors[severity];
  const borderRadius = theme.shape.borderRadius();
  return {
    alert: css.css`
      flex-grow: 1;
      position: relative;
      border-radius: ${borderRadius};
      display: flex;
      flex-direction: row;
      align-items: stretch;
      background: ${theme.colors.background.secondary};
      box-shadow: ${elevated ? theme.shadows.z3 : theme.shadows.z1};
      margin-bottom: ${theme.spacing(bottomSpacing != null ? bottomSpacing : 2)};
      margin-top: ${theme.spacing(topSpacing != null ? topSpacing : 0)};

      &:before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        bottom: 0;
        right: 0;
        background: ${theme.colors.background.primary};
        z-index: -1;
      }
    `,
    icon: css.css`
      padding: ${theme.spacing(2, 3)};
      background: ${color.main};
      border-radius: ${borderRadius} 0 0 ${borderRadius};
      color: ${color.contrastText};
      display: flex;
      align-items: center;
      justify-content: center;
    `,
    title: css.css`
      font-weight: ${theme.typography.fontWeightMedium};
      color: ${theme.colors.text.primary};
    `,
    body: css.css`
      color: ${theme.colors.text.secondary};
      padding: ${theme.spacing(2)};
      flex-grow: 1;
      display: flex;
      flex-direction: column;
      justify-content: center;
      overflow-wrap: break-word;
      word-break: break-word;
    `,
    content: css.css`
      color: ${theme.colors.text.secondary};
      padding-top: ${hasTitle ? theme.spacing(1) : 0};
      max-height: 50vh;
      overflow-y: auto;
    `,
    buttonWrapper: css.css`
      padding: ${theme.spacing(1)};
      background: none;
      display: flex;
      align-items: center;
    `,
    close: css.css`
      padding: ${theme.spacing(2, 1)};
      background: none;
      display: flex;
    `
  };
};

var __defProp$X = Object.defineProperty;
var __defProps$F = Object.defineProperties;
var __getOwnPropDescs$F = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$Y = Object.getOwnPropertySymbols;
var __hasOwnProp$Y = Object.prototype.hasOwnProperty;
var __propIsEnum$Y = Object.prototype.propertyIsEnumerable;
var __defNormalProp$X = (obj, key, value) => key in obj ? __defProp$X(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$X = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$Y.call(b, prop))
      __defNormalProp$X(a, prop, b[prop]);
  if (__getOwnPropSymbols$Y)
    for (var prop of __getOwnPropSymbols$Y(b)) {
      if (__propIsEnum$Y.call(b, prop))
        __defNormalProp$X(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$F = (a, b) => __defProps$F(a, __getOwnPropDescs$F(b));
class GraphSeriesToggler extends React.Component {
  constructor(props) {
    super(props);
    this.onSeriesToggle = this.onSeriesToggle.bind(this);
    this.state = {
      hiddenSeries: [],
      toggledSeries: props.series
    };
  }
  componentDidUpdate(prevProps) {
    const { series } = this.props;
    if (!lodash.isEqual(prevProps.series, series)) {
      this.setState({ hiddenSeries: [], toggledSeries: series });
    }
  }
  onSeriesToggle(label, event) {
    const { series, onHiddenSeriesChanged } = this.props;
    const { hiddenSeries } = this.state;
    if (event.ctrlKey || event.metaKey || event.shiftKey) {
      const newHiddenSeries2 = hiddenSeries.indexOf(label) > -1 ? hiddenSeries.filter((series2) => series2 !== label) : hiddenSeries.concat([label]);
      const toggledSeries2 = series.map((series2) => __spreadProps$F(__spreadValues$X({}, series2), {
        isVisible: newHiddenSeries2.indexOf(series2.label) === -1
      }));
      this.setState(
        { hiddenSeries: newHiddenSeries2, toggledSeries: toggledSeries2 },
        () => onHiddenSeriesChanged ? onHiddenSeriesChanged(newHiddenSeries2) : void 0
      );
      return;
    }
    const allSeriesLabels = series.map((series2) => series2.label);
    const newHiddenSeries = hiddenSeries.length + 1 === allSeriesLabels.length ? [] : lodash.difference(allSeriesLabels, [label]);
    const toggledSeries = series.map((series2) => __spreadProps$F(__spreadValues$X({}, series2), {
      isVisible: newHiddenSeries.indexOf(series2.label) === -1
    }));
    this.setState(
      { hiddenSeries: newHiddenSeries, toggledSeries },
      () => onHiddenSeriesChanged ? onHiddenSeriesChanged(newHiddenSeries) : void 0
    );
  }
  render() {
    const { children } = this.props;
    const { toggledSeries } = this.state;
    return children({
      onSeriesToggle: this.onSeriesToggle,
      toggledSeries
    });
  }
}

var __defProp$W = Object.defineProperty;
var __defProps$E = Object.defineProperties;
var __getOwnPropDescs$E = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$X = Object.getOwnPropertySymbols;
var __hasOwnProp$X = Object.prototype.hasOwnProperty;
var __propIsEnum$X = Object.prototype.propertyIsEnumerable;
var __defNormalProp$W = (obj, key, value) => key in obj ? __defProp$W(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$W = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$X.call(b, prop))
      __defNormalProp$W(a, prop, b[prop]);
  if (__getOwnPropSymbols$X)
    for (var prop of __getOwnPropSymbols$X(b)) {
      if (__propIsEnum$X.call(b, prop))
        __defNormalProp$W(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$E = (a, b) => __defProps$E(a, __getOwnPropDescs$E(b));
var __objRest$w = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$X.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$X)
    for (var prop of __getOwnPropSymbols$X(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$X.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getStyles$y = (theme) => ({
  collapse: css.css`
    label: collapse;
    margin-bottom: ${theme.spacing(1)};
    background-color: ${theme.colors.background.primary};
    border: 1px solid ${theme.colors.border.medium};
    position: relative;
    border-radius: ${theme.shape.radius.default};
    width: 100%;
    display: flex;
    flex-direction: column;
    flex: 1 1 0;
  `,
  collapseBody: css.css`
    label: collapse__body;
    padding: ${theme.spacing(theme.components.panel.padding)};
    padding-top: 0;
    flex: 1;
    overflow: hidden;
    display: flex;
    flex-direction: column;
  `,
  bodyContentWrapper: css.css`
    label: bodyContentWrapper;
    flex: 1;
    overflow: hidden;
  `,
  loader: css.css`
    label: collapse__loader;
    height: 2px;
    position: relative;
    overflow: hidden;
    background: none;
    margin: ${theme.spacing(0.5)};
  `,
  loaderActive: css.css`
    label: collapse__loader_active;
    &:after {
      content: ' ';
      display: block;
      width: 25%;
      top: 0;
      top: -50%;
      height: 250%;
      position: absolute;
      animation: loader 2s cubic-bezier(0.17, 0.67, 0.83, 0.67) 500ms;
      animation-iteration-count: 100;
      left: -25%;
      background: ${theme.colors.primary.main};
    }
    @keyframes loader {
      from {
        left: -25%;
        opacity: 0.1;
      }
      to {
        left: 100%;
        opacity: 1;
      }
    }
  `,
  header: css.css`
    label: collapse__header;
    padding: ${theme.spacing(1, 2, 1, 2)};
    display: flex;
    transition: all 0.1s linear;
  `,
  headerCollapsed: css.css`
    label: collapse__header--collapsed;
    padding: ${theme.spacing(1, 2, 1, 2)};
  `,
  headerLabel: css.css`
    label: collapse__header-label;
    font-weight: ${theme.typography.fontWeightMedium};
    margin-right: ${theme.spacing(1)};
    font-size: ${theme.typography.size.md};
  `,
  icon: css.css`
    label: collapse__icon;
    margin: ${theme.spacing(0.25, 1, 0, -1)};
  `
});
const ControlledCollapse = (_a) => {
  var _b = _a, { isOpen, onToggle } = _b, otherProps = __objRest$w(_b, ["isOpen", "onToggle"]);
  const [open, setOpen] = React.useState(isOpen);
  return /* @__PURE__ */ React__default["default"].createElement(
    Collapse,
    __spreadProps$E(__spreadValues$W({
      isOpen: open,
      collapsible: true
    }, otherProps), {
      onToggle: () => {
        setOpen(!open);
        if (onToggle) {
          onToggle(!open);
        }
      }
    })
  );
};
const Collapse = ({
  isOpen,
  label,
  loading,
  collapsible,
  onToggle,
  className,
  children
}) => {
  const buttonStyles = useStyles2(clearButtonStyles);
  const style = useStyles2(getStyles$y);
  const onClickToggle = () => {
    if (onToggle) {
      onToggle(!isOpen);
    }
  };
  const panelClass = css.cx([style.collapse, className]);
  const loaderClass = loading ? css.cx([style.loader, style.loaderActive]) : css.cx([style.loader]);
  const headerClass = collapsible ? css.cx([style.header]) : css.cx([style.headerCollapsed]);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: panelClass }, /* @__PURE__ */ React__default["default"].createElement("button", { type: "button", className: css.cx(buttonStyles, headerClass), onClick: onClickToggle }, collapsible && /* @__PURE__ */ React__default["default"].createElement(Icon, { className: style.icon, name: isOpen ? "angle-down" : "angle-right" }), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([style.headerLabel]) }, label)), isOpen && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([style.collapseBody]) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: loaderClass }), /* @__PURE__ */ React__default["default"].createElement("div", { className: style.bodyContentWrapper }, children)));
};
Collapse.displayName = "Collapse";

const CollapsableSection = ({
  label,
  isOpen,
  onToggle,
  className,
  contentClassName,
  children,
  labelId,
  loading = false,
  headerDataTestId,
  contentDataTestId
}) => {
  const [open, toggleOpen] = React.useState(isOpen);
  const styles = useStyles2(collapsableSectionStyles);
  const onClick = (e) => {
    if (e.target instanceof HTMLElement && e.target.tagName === "A") {
      return;
    }
    e.preventDefault();
    e.stopPropagation();
    onToggle == null ? void 0 : onToggle(!open);
    toggleOpen(!open);
  };
  const { current: id } = React.useRef(lodash.uniqueId());
  const buttonLabelId = labelId != null ? labelId : `collapse-label-${id}`;
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { onClick, className: css.cx(styles.header, className) }, /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      type: "button",
      id: `collapse-button-${id}`,
      className: styles.button,
      onClick,
      "aria-expanded": open && !loading,
      "aria-controls": `collapse-content-${id}`,
      "aria-labelledby": buttonLabelId
    },
    loading ? /* @__PURE__ */ React__default["default"].createElement(Spinner, { className: styles.spinner }) : /* @__PURE__ */ React__default["default"].createElement(Icon, { name: open ? "angle-up" : "angle-down", className: styles.icon })
  ), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.label, id: `collapse-label-${id}`, "data-testid": headerDataTestId }, label)), open && /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      id: `collapse-content-${id}`,
      className: css.cx(styles.content, contentClassName),
      "data-testid": contentDataTestId
    },
    children
  ));
};
const collapsableSectionStyles = (theme) => ({
  header: css.css({
    display: "flex",
    cursor: "pointer",
    boxSizing: "border-box",
    flexDirection: "row-reverse",
    position: "relative",
    justifyContent: "space-between",
    fontSize: theme.typography.size.lg,
    padding: `${theme.spacing(0.5)} 0`,
    "&:focus-within": getFocusStyles(theme)
  }),
  button: css.css({
    all: "unset",
    "&:focus-visible": {
      outline: "none",
      outlineOffset: "unset",
      transition: "none",
      boxShadow: "none"
    }
  }),
  icon: css.css({
    color: theme.colors.text.secondary
  }),
  content: css.css({
    padding: `${theme.spacing(2)} 0`
  }),
  spinner: css.css({
    display: "flex",
    alignItems: "center",
    width: theme.spacing(2)
  }),
  label: css.css({
    display: "flex"
  })
});

const HIDDEN_LABELS = ["level", "lvl", "filename"];
const LogLabels = ({ labels }) => {
  const styles = useStyles2(getStyles$x);
  const displayLabels = Object.keys(labels).filter((label) => !label.startsWith("_") && !HIDDEN_LABELS.includes(label));
  if (displayLabels.length === 0) {
    return /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx([styles.logsLabels]) }, /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx([styles.logsLabel]) }, "(no unique labels)"));
  }
  return /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx([styles.logsLabels]) }, displayLabels.sort().map((label) => {
    const value = labels[label];
    if (!value) {
      return;
    }
    const tooltip = `${label}: ${value}`;
    return /* @__PURE__ */ React__default["default"].createElement("span", { key: label, className: css.cx([styles.logsLabel]) }, /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx([styles.logsLabelValue]), title: tooltip }, value));
  }));
};
const getStyles$x = (theme) => {
  return {
    logsLabels: css.css`
      display: flex;
      flex-wrap: wrap;
      font-size: ${theme.typography.size.xs};
    `,
    logsLabel: css.css`
      label: logs-label;
      display: flex;
      padding: 0 2px;
      background-color: ${theme.colors.background.secondary};
      border-radius: ${theme.shape.borderRadius(1)};
      margin: 1px 4px 0 0;
      text-overflow: ellipsis;
      white-space: nowrap;
      overflow: hidden;
    `,
    logsLabelValue: css.css`
      label: logs-label__value;
      display: inline-block;
      max-width: 20em;
      text-overflow: ellipsis;
      overflow: hidden;
    `
  };
};

function convertCSSToStyle(theme, css) {
  return css.split(/;\s*/).reduce((accumulated, line) => {
    if (line === "color:rgba(0,0,0,0.5)") {
      return { color: theme.colors.text.secondary };
    }
    const match = line.match(/([^:\s]+)\s*:\s*(.+)/);
    if (match && match[1] && match[2]) {
      const key = match[1].replace(/-([a-z])/g, (_, character) => character.toUpperCase());
      accumulated[key] = match[2];
    }
    return accumulated;
  }, {});
}
class UnThemedLogMessageAnsi extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      chunks: [],
      prevValue: ""
    };
  }
  static getDerivedStateFromProps(props, state) {
    if (props.value === state.prevValue) {
      return null;
    }
    const parsed = ansicolor__default["default"].parse(props.value);
    return {
      chunks: parsed.spans.map((span) => {
        return span.css ? {
          style: convertCSSToStyle(props.theme, span.css),
          text: span.text
        } : { text: span.text };
      }),
      prevValue: props.value
    };
  }
  render() {
    const { chunks } = this.state;
    return chunks.map((chunk, index) => {
      var _a;
      const chunkText = ((_a = this.props.highlight) == null ? void 0 : _a.searchWords) ? /* @__PURE__ */ React__default["default"].createElement(
        Highlighter__default["default"],
        {
          key: index,
          textToHighlight: chunk.text,
          searchWords: this.props.highlight.searchWords,
          findChunks: data.findHighlightChunksInText,
          highlightClassName: this.props.highlight.highlightClassName
        }
      ) : chunk.text;
      return chunk.style ? /* @__PURE__ */ React__default["default"].createElement("span", { key: index, style: chunk.style, "data-testid": "ansiLogLine" }, chunkText) : chunkText;
    });
  }
}
const LogMessageAnsi = withTheme2(UnThemedLogMessageAnsi);
LogMessageAnsi.displayName = "LogMessageAnsi";

var __defProp$V = Object.defineProperty;
var __getOwnPropSymbols$W = Object.getOwnPropertySymbols;
var __hasOwnProp$W = Object.prototype.hasOwnProperty;
var __propIsEnum$W = Object.prototype.propertyIsEnumerable;
var __defNormalProp$V = (obj, key, value) => key in obj ? __defProp$V(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$V = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$W.call(b, prop))
      __defNormalProp$V(a, prop, b[prop]);
  if (__getOwnPropSymbols$W)
    for (var prop of __getOwnPropSymbols$W(b)) {
      if (__propIsEnum$W.call(b, prop))
        __defNormalProp$V(a, prop, b[prop]);
    }
  return a;
};
function DataLinkButton({ link, buttonProps }) {
  return /* @__PURE__ */ React__default["default"].createElement(
    "a",
    {
      href: link.href,
      target: link.target,
      rel: "noreferrer",
      onClick: link.onClick ? (event) => {
        if (!(event.ctrlKey || event.metaKey || event.shiftKey) && link.onClick) {
          event.preventDefault();
          link.onClick(event);
        }
      } : void 0
    },
    /* @__PURE__ */ React__default["default"].createElement(Button, __spreadValues$V({ icon: "external-link-alt", variant: "primary", size: "sm" }, buttonProps), link.title)
  );
}

const getStyles$w = (theme) => ({
  logsStatsRow: css.css`
    label: logs-stats-row;
    margin: ${parseInt(theme.spacing(2), 10) / 1.75}px 0;
  `,
  logsStatsRowActive: css.css`
    label: logs-stats-row--active;
    color: ${theme.colors.primary.text};
    position: relative;
  `,
  logsStatsRowLabel: css.css`
    label: logs-stats-row__label;
    display: flex;
    margin-bottom: 1px;
  `,
  logsStatsRowValue: css.css`
    label: logs-stats-row__value;
    flex: 1;
    text-overflow: ellipsis;
    overflow: hidden;
  `,
  logsStatsRowCount: css.css`
    label: logs-stats-row__count;
    text-align: right;
    margin-left: 0.5em;
  `,
  logsStatsRowPercent: css.css`
    label: logs-stats-row__percent;
    text-align: right;
    margin-left: 0.5em;
    width: 3em;
  `,
  logsStatsRowBar: css.css`
    label: logs-stats-row__bar;
    height: 4px;
    overflow: hidden;
    background: ${theme.colors.text.disabled};
  `,
  logsStatsRowInnerBar: css.css`
    label: logs-stats-row__innerbar;
    height: 4px;
    overflow: hidden;
    background: ${theme.colors.primary.main};
  `
});
const LogLabelStatsRow = ({ active, count, proportion, value }) => {
  const style = useStyles2(getStyles$w);
  const percent = `${Math.round(proportion * 100)}%`;
  const barStyle = { width: percent };
  const className = active ? css.cx([style.logsStatsRow, style.logsStatsRowActive]) : css.cx([style.logsStatsRow]);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([style.logsStatsRowLabel]) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([style.logsStatsRowValue]), title: value }, value), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([style.logsStatsRowCount]) }, count), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([style.logsStatsRowPercent]) }, percent)), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([style.logsStatsRowBar]) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([style.logsStatsRowInnerBar]), style: barStyle })));
};
LogLabelStatsRow.displayName = "LogLabelStatsRow";

var __defProp$U = Object.defineProperty;
var __defProps$D = Object.defineProperties;
var __getOwnPropDescs$D = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$V = Object.getOwnPropertySymbols;
var __hasOwnProp$V = Object.prototype.hasOwnProperty;
var __propIsEnum$V = Object.prototype.propertyIsEnumerable;
var __defNormalProp$U = (obj, key, value) => key in obj ? __defProp$U(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$U = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$V.call(b, prop))
      __defNormalProp$U(a, prop, b[prop]);
  if (__getOwnPropSymbols$V)
    for (var prop of __getOwnPropSymbols$V(b)) {
      if (__propIsEnum$V.call(b, prop))
        __defNormalProp$U(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$D = (a, b) => __defProps$D(a, __getOwnPropDescs$D(b));
const STATS_ROW_LIMIT = 5;
const getStyles$v = stylesFactory((theme) => {
  return {
    logsStats: css.css`
      label: logs-stats;
      background: inherit;
      color: ${theme.colors.text.primary};
      word-break: break-all;
      width: fit-content;
      max-width: 100%;
    `,
    logsStatsHeader: css.css`
      label: logs-stats__header;
      border-bottom: 1px solid ${theme.colors.border.medium};
      display: flex;
    `,
    logsStatsTitle: css.css`
      label: logs-stats__title;
      font-weight: ${theme.typography.fontWeightMedium};
      padding-right: ${theme.spacing(2)};
      display: inline-block;
      white-space: nowrap;
      text-overflow: ellipsis;
      flex-grow: 1;
    `,
    logsStatsClose: css.css`
      label: logs-stats__close;
      cursor: pointer;
    `,
    logsStatsBody: css.css`
      label: logs-stats__body;
      padding: 5px 0;
    `
  };
});
class UnThemedLogLabelStats extends React.PureComponent {
  render() {
    const { label, rowCount, stats, value, theme, isLabel } = this.props;
    const style = getStyles$v(theme);
    const topRows = stats.slice(0, STATS_ROW_LIMIT);
    let activeRow = topRows.find((row) => row.value === value);
    let otherRows = stats.slice(STATS_ROW_LIMIT);
    const insertActiveRow = !activeRow;
    if (insertActiveRow) {
      activeRow = otherRows.find((row) => row.value === value);
      otherRows = otherRows.filter((row) => row.value !== value);
    }
    const otherCount = otherRows.reduce((sum, row) => sum + row.count, 0);
    const topCount = topRows.reduce((sum, row) => sum + row.count, 0);
    const total = topCount + otherCount;
    const otherProportion = otherCount / total;
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: style.logsStats, "data-testid": "logLabelStats" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: style.logsStatsHeader }, /* @__PURE__ */ React__default["default"].createElement("div", { className: style.logsStatsTitle }, label, ": ", total, " of ", rowCount, " rows have that ", isLabel ? "label" : "field")), /* @__PURE__ */ React__default["default"].createElement("div", { className: style.logsStatsBody }, topRows.map((stat) => /* @__PURE__ */ React__default["default"].createElement(LogLabelStatsRow, __spreadProps$D(__spreadValues$U({ key: stat.value }, stat), { active: stat.value === value }))), insertActiveRow && activeRow && /* @__PURE__ */ React__default["default"].createElement(LogLabelStatsRow, __spreadProps$D(__spreadValues$U({ key: activeRow.value }, activeRow), { active: true })), otherCount > 0 && /* @__PURE__ */ React__default["default"].createElement(LogLabelStatsRow, { key: "__OTHERS__", count: otherCount, value: "Other", proportion: otherProportion })));
  }
}
const LogLabelStats = withTheme2(UnThemedLogLabelStats);
LogLabelStats.displayName = "LogLabelStats";

const getLogRowStyles = (theme, logLevel) => {
  let logColor = theme.isLight ? theme.v1.palette.gray5 : theme.v1.palette.gray2;
  const hoverBgColor = hoverColor(theme.colors.background.secondary, theme);
  switch (logLevel) {
    case data.LogLevel.crit:
    case data.LogLevel.critical:
      logColor = "#705da0";
      break;
    case data.LogLevel.error:
    case data.LogLevel.err:
      logColor = "#e24d42";
      break;
    case data.LogLevel.warning:
    case data.LogLevel.warn:
      logColor = theme.colors.warning.main;
      break;
    case data.LogLevel.info:
      logColor = "#7eb26d";
      break;
    case data.LogLevel.debug:
      logColor = "#1f78c1";
      break;
    case data.LogLevel.trace:
      logColor = "#6ed0e0";
      break;
  }
  return {
    logsRowMatchHighLight: css.css`
      label: logs-row__match-highlight;
      background: inherit;
      padding: inherit;
      color: ${theme.components.textHighlight.text}
      background-color: ${theme.components.textHighlight};
    `,
    logsRowsTable: css.css`
      label: logs-rows;
      font-family: ${theme.typography.fontFamilyMonospace};
      font-size: ${theme.typography.bodySmall.fontSize};
      width: 100%;
    `,
    context: css.css`
      label: context;
      visibility: hidden;
      white-space: nowrap;
      position: relative;
      margin-left: 10px;
    `,
    logsRow: css.css`
      label: logs-row;
      width: 100%;
      cursor: pointer;
      vertical-align: top;

      &:hover {
        .log-row-context {
          visibility: visible;
          z-index: 1;
          text-decoration: underline;
          &:hover {
            color: ${theme.colors.warning.main};
          }
        }
      }

      td:last-child {
        width: 100%;
      }

      > td {
        position: relative;
        padding-right: ${theme.spacing(1)};
        border-top: 1px solid transparent;
        border-bottom: 1px solid transparent;
        height: 100%;
      }

      &:hover {
        background: ${hoverBgColor};
      }
    `,
    logsRowDuplicates: css.css`
      label: logs-row__duplicates;
      text-align: right;
      width: 4em;
      cursor: default;
    `,
    logsRowLevel: css.css`
      label: logs-row__level;
      max-width: 10px;
      cursor: default;
      &::after {
        content: '';
        display: block;
        position: absolute;
        top: 1px;
        bottom: 1px;
        width: 3px;
        left: 4px;
        background-color: ${logColor};
      }
    `,
    logIconError: css.css`
      color: ${theme.colors.warning.main};
    `,
    logsRowToggleDetails: css.css`
      label: logs-row-toggle-details__level;
      font-size: 9px;
      padding-top: 5px;
      max-width: 15px;
    `,
    logsRowLocalTime: css.css`
      label: logs-row__localtime;
      white-space: nowrap;
    `,
    logsRowLabels: css.css`
      label: logs-row__labels;
      white-space: nowrap;
      max-width: 22em;

      /* This is to make the labels vertical align */
      > span {
        margin-top: 0.75px;
      }
    `,
    logsRowMessage: css.css`
      label: logs-row__message;
      white-space: pre-wrap;
      word-break: break-all;
    `,
    //Log details specific CSS
    logDetailsContainer: css.css`
      label: logs-row-details-table;
      border: 1px solid ${theme.colors.border.medium};
      padding: 0 ${theme.spacing(1)} ${theme.spacing(1)};
      border-radius: ${theme.shape.radius.default};
      margin: 20px 8px 20px 16px;
      cursor: default;
    `,
    logDetailsTable: css.css`
      label: logs-row-details-table;
      line-height: 18px;
      width: 100%;
      td:last-child {
        width: 100%;
      }
    `,
    logsDetailsIcon: css.css`
      label: logs-row-details__icon;
      position: relative;
      color: ${theme.v1.palette.gray3};
      padding-top: 6px;
      padding-left: 6px;
    `,
    logDetailsLabel: css.css`
      label: logs-row-details__label;
      max-width: 30em;
      min-width: 20em;
      padding: 0 ${theme.spacing(1)};
      overflow-wrap: break-word;
    `,
    logDetailsHeading: css.css`
      label: logs-row-details__heading;
      font-weight: ${theme.typography.fontWeightBold};
      padding: ${theme.spacing(1)} 0 ${theme.spacing(0.5)};
    `,
    logDetailsValue: css.css`
      label: logs-row-details__row;
      position: relative;
      vertical-align: middle;
      cursor: default;

      &:hover {
        background-color: ${hoverBgColor};
      }
    `
  };
};

const getStyles$u = (theme) => {
  return {
    noHoverBackground: css.css`
      label: noHoverBackground;
      :hover {
        background-color: transparent;
      }
    `,
    hoverCursor: css.css`
      label: hoverCursor;
      cursor: pointer;
    `,
    wordBreakAll: css.css`
      label: wordBreakAll;
      word-break: break-all;
    `,
    showingField: css.css`
      color: ${theme.colors.primary.text};
    `,
    hoverValueCopy: css.css`
      margin: ${theme.spacing(0, 0, 0, 1.2)};
      position: absolute;
      top: 0px;
      justify-content: center;
      border-radius: ${theme.shape.radius.circle};
      width: 26px;
      height: 26px;
    `,
    wrapLine: css.css`
      label: wrapLine;
      white-space: pre-wrap;
    `
  };
};
class UnThemedLogDetailsRow extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      showFieldsStats: false,
      fieldCount: 0,
      fieldStats: null,
      mouseOver: false
    };
    this.showField = () => {
      const { onClickShowDetectedField, parsedKey } = this.props;
      if (onClickShowDetectedField) {
        onClickShowDetectedField(parsedKey);
      }
    };
    this.hideField = () => {
      const { onClickHideDetectedField, parsedKey } = this.props;
      if (onClickHideDetectedField) {
        onClickHideDetectedField(parsedKey);
      }
    };
    this.filterLabel = () => {
      const { onClickFilterLabel, parsedKey, parsedValue } = this.props;
      if (onClickFilterLabel) {
        onClickFilterLabel(parsedKey, parsedValue);
      }
    };
    this.filterOutLabel = () => {
      const { onClickFilterOutLabel, parsedKey, parsedValue } = this.props;
      if (onClickFilterOutLabel) {
        onClickFilterOutLabel(parsedKey, parsedValue);
      }
    };
    this.showStats = () => {
      const { showFieldsStats } = this.state;
      if (!showFieldsStats) {
        const fieldStats = this.props.getStats();
        const fieldCount = fieldStats ? fieldStats.reduce((sum, stat) => sum + stat.count, 0) : 0;
        this.setState({ fieldStats, fieldCount });
      }
      this.toggleFieldsStats();
    };
  }
  toggleFieldsStats() {
    this.setState((state) => {
      return {
        showFieldsStats: !state.showFieldsStats
      };
    });
  }
  hoverValueCopy() {
    const mouseOver = !this.state.mouseOver;
    this.setState({ mouseOver });
  }
  render() {
    const {
      theme,
      parsedKey,
      parsedValue,
      isLabel,
      links,
      showDetectedFields,
      wrapLogMessage,
      onClickShowDetectedField,
      onClickHideDetectedField,
      onClickFilterLabel,
      onClickFilterOutLabel
    } = this.props;
    const { showFieldsStats, fieldStats, fieldCount, mouseOver } = this.state;
    const styles = getStyles$u(theme);
    const style = getLogRowStyles(theme);
    const hasDetectedFieldsFunctionality = onClickShowDetectedField && onClickHideDetectedField;
    const hasFilteringFunctionality = onClickFilterLabel && onClickFilterOutLabel;
    const toggleFieldButton = !isLabel && showDetectedFields && showDetectedFields.includes(parsedKey) ? /* @__PURE__ */ React__default["default"].createElement(IconButton, { name: "eye", className: styles.showingField, title: "Hide this field", onClick: this.hideField }) : /* @__PURE__ */ React__default["default"].createElement(IconButton, { name: "eye", title: "Show this field instead of the message", onClick: this.showField });
    return /* @__PURE__ */ React__default["default"].createElement("tr", { className: css.cx(style.logDetailsValue, { [styles.noHoverBackground]: showFieldsStats }) }, /* @__PURE__ */ React__default["default"].createElement("td", { className: style.logsDetailsIcon }, /* @__PURE__ */ React__default["default"].createElement(IconButton, { name: "signal", title: "Ad-hoc statistics", onClick: this.showStats })), hasFilteringFunctionality && isLabel && /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("td", { className: style.logsDetailsIcon }, /* @__PURE__ */ React__default["default"].createElement(IconButton, { name: "search-plus", title: "Filter for value", onClick: this.filterLabel })), /* @__PURE__ */ React__default["default"].createElement("td", { className: style.logsDetailsIcon }, /* @__PURE__ */ React__default["default"].createElement(IconButton, { name: "search-minus", title: "Filter out value", onClick: this.filterOutLabel }))), hasDetectedFieldsFunctionality && !isLabel && /* @__PURE__ */ React__default["default"].createElement("td", { className: style.logsDetailsIcon, colSpan: 2 }, toggleFieldButton), /* @__PURE__ */ React__default["default"].createElement("td", { className: style.logDetailsLabel }, parsedKey), /* @__PURE__ */ React__default["default"].createElement(
      "td",
      {
        className: css.cx(styles.wordBreakAll, wrapLogMessage && styles.wrapLine),
        onMouseEnter: this.hoverValueCopy.bind(this),
        onMouseLeave: this.hoverValueCopy.bind(this)
      },
      parsedValue,
      mouseOver && /* @__PURE__ */ React__default["default"].createElement(
        ClipboardButton,
        {
          getText: () => parsedValue,
          title: "Copy value to clipboard",
          fill: "text",
          variant: "secondary",
          icon: "copy",
          size: "sm",
          className: styles.hoverValueCopy
        }
      ),
      links == null ? void 0 : links.map((link) => /* @__PURE__ */ React__default["default"].createElement("span", { key: link.title }, "\xA0", /* @__PURE__ */ React__default["default"].createElement(DataLinkButton, { link }))),
      showFieldsStats && /* @__PURE__ */ React__default["default"].createElement(
        LogLabelStats,
        {
          stats: fieldStats,
          label: parsedKey,
          value: parsedValue,
          rowCount: fieldCount,
          isLabel
        }
      )
    ));
  }
}
const LogDetailsRow = withTheme2(UnThemedLogDetailsRow);
LogDetailsRow.displayName = "LogDetailsRow";

var __defProp$T = Object.defineProperty;
var __getOwnPropSymbols$U = Object.getOwnPropertySymbols;
var __hasOwnProp$U = Object.prototype.hasOwnProperty;
var __propIsEnum$U = Object.prototype.propertyIsEnumerable;
var __defNormalProp$T = (obj, key, value) => key in obj ? __defProp$T(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$T = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$U.call(b, prop))
      __defNormalProp$T(a, prop, b[prop]);
  if (__getOwnPropSymbols$U)
    for (var prop of __getOwnPropSymbols$U(b)) {
      if (__propIsEnum$U.call(b, prop))
        __defNormalProp$T(a, prop, b[prop]);
    }
  return a;
};
const getLogRowContextStyles = (theme, wrapLogMessage) => {
  const afterContext = wrapLogMessage ? css.css`
        top: -250px;
      ` : css.css`
        margin-top: -250px;
        width: 75%;
      `;
  const beforeContext = wrapLogMessage ? css.css`
        top: 100%;
      ` : css.css`
        margin-top: 40px;
        width: 75%;
      `;
  return {
    commonStyles: css.css`
      position: absolute;
      height: 250px;
      z-index: ${theme.zIndex.dropdown};
      overflow: hidden;
      background: ${theme.colors.background.primary};
      box-shadow: 0 0 10px ${theme.v1.palette.black};
      border: 1px solid ${theme.colors.background.secondary};
      border-radius: ${theme.shape.borderRadius()};
      width: 100%;
    `,
    header: css.css`
      height: 30px;
      padding: 0 10px;
      display: flex;
      align-items: center;
      background: ${theme.colors.background.secondary};
    `,
    logs: css.css`
      height: 220px;
      padding: 10px;
    `,
    afterContext,
    beforeContext
  };
};
const LogRowContextGroupHeader = ({ row, rows, onLoadMoreContext, canLoadMoreRows }) => {
  const { header } = useStyles2(getLogRowContextStyles);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: header }, /* @__PURE__ */ React__default["default"].createElement(
    "span",
    {
      className: css.css`
          opacity: 0.6;
        `
    },
    "Found ",
    rows.length,
    " rows."
  ), (rows.length >= 10 || rows.length > 10 && rows.length % 10 !== 0) && canLoadMoreRows && /* @__PURE__ */ React__default["default"].createElement(
    "span",
    {
      className: css.css`
            margin-left: 10px;
            &:hover {
              text-decoration: underline;
              cursor: pointer;
            }
          `,
      onClick: onLoadMoreContext
    },
    "Load 10 more"
  ));
};
const LogRowContextGroup = ({
  row,
  rows,
  error,
  className,
  shouldScrollToBottom,
  canLoadMoreRows,
  onLoadMoreContext
}) => {
  const { commonStyles, logs } = useStyles2(getLogRowContextStyles);
  const [scrollTop, setScrollTop] = React.useState(0);
  const listContainerRef = React.useRef(null);
  React.useLayoutEffect(() => {
    const shouldScrollRows = rows.length > 0 && rows.length <= 10;
    if (shouldScrollToBottom && shouldScrollRows && listContainerRef.current) {
      setScrollTop(listContainerRef.current.offsetHeight);
    }
  }, [shouldScrollToBottom, rows]);
  const headerProps = {
    row,
    rows,
    onLoadMoreContext,
    canLoadMoreRows
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(commonStyles, className) }, shouldScrollToBottom && !error && /* @__PURE__ */ React__default["default"].createElement(LogRowContextGroupHeader, __spreadValues$T({}, headerProps)), /* @__PURE__ */ React__default["default"].createElement("div", { className: logs }, /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { autoHide: true, scrollTop, autoHeightMin: "210px" }, /* @__PURE__ */ React__default["default"].createElement("div", { ref: listContainerRef }, !error && /* @__PURE__ */ React__default["default"].createElement(
    List,
    {
      items: rows,
      renderItem: (item) => {
        return /* @__PURE__ */ React__default["default"].createElement(
          "div",
          {
            className: css.css`
                        padding: 5px 0;
                      `
          },
          typeof item === "string" && data.textUtil.hasAnsiCodes(item) ? /* @__PURE__ */ React__default["default"].createElement(LogMessageAnsi, { value: item }) : item
        );
      }
    }
  ), error && /* @__PURE__ */ React__default["default"].createElement(Alert, { title: error })))), !shouldScrollToBottom && !error && /* @__PURE__ */ React__default["default"].createElement(LogRowContextGroupHeader, __spreadValues$T({}, headerProps)));
};
const LogRowContext = ({
  row,
  context,
  errors,
  onOutsideClick,
  onLoadMoreContext,
  hasMoreContextRows,
  wrapLogMessage
}) => {
  React.useEffect(() => {
    const handleEscKeyDown = (e) => {
      if (e.keyCode === 27) {
        onOutsideClick();
      }
    };
    document.addEventListener("keydown", handleEscKeyDown, false);
    return () => {
      document.removeEventListener("keydown", handleEscKeyDown, false);
    };
  }, [onOutsideClick]);
  const { afterContext, beforeContext } = useStyles2((theme) => getLogRowContextStyles(theme, wrapLogMessage));
  return /* @__PURE__ */ React__default["default"].createElement(ClickOutsideWrapper, { onClick: onOutsideClick }, /* @__PURE__ */ React__default["default"].createElement("div", { onClick: (e) => e.stopPropagation() }, context.after && /* @__PURE__ */ React__default["default"].createElement(
    LogRowContextGroup,
    {
      rows: context.after,
      error: errors && errors.after,
      row,
      className: afterContext,
      shouldScrollToBottom: true,
      canLoadMoreRows: hasMoreContextRows ? hasMoreContextRows.after : false,
      onLoadMoreContext
    }
  ), context.before && /* @__PURE__ */ React__default["default"].createElement(
    LogRowContextGroup,
    {
      onLoadMoreContext,
      canLoadMoreRows: hasMoreContextRows ? hasMoreContextRows.before : false,
      row,
      rows: context.before,
      error: errors && errors.before,
      className: beforeContext
    }
  )));
};

const MAX_CHARACTERS = 1e5;
const getStyles$t = (theme) => {
  const outlineColor = tinycolor__default["default"](theme.components.dashboard.background).setAlpha(0.7).toRgbString();
  return {
    positionRelative: css.css`
      label: positionRelative;
      position: relative;
    `,
    rowWithContext: css.css`
      label: rowWithContext;
      z-index: 1;
      outline: 9999px solid ${outlineColor};
    `,
    horizontalScroll: css.css`
      label: verticalScroll;
      white-space: pre;
    `,
    contextNewline: css.css`
      display: block;
      margin-left: 0px;
    `,
    contextButton: css.css`
      display: flex;
      flex-wrap: nowrap;
      flex-direction: row;
      align-content: flex-end;
      justify-content: space-evenly;
      align-items: center;
      position: absolute;
      right: -8px;
      top: 0;
      bottom: auto;
      width: 80px;
      height: 36px;
      background: ${theme.colors.background.primary};
      box-shadow: ${theme.shadows.z3};
      padding: ${theme.spacing(0, 0, 0, 0.5)};
      z-index: 100;
    `
  };
};
function renderLogMessage(hasAnsi, entry, highlights, highlightClassName) {
  const needsHighlighter = highlights && highlights.length > 0 && highlights[0] && highlights[0].length > 0 && entry.length < MAX_CHARACTERS;
  const searchWords = highlights != null ? highlights : [];
  if (hasAnsi) {
    const highlight = needsHighlighter ? { searchWords, highlightClassName } : void 0;
    return /* @__PURE__ */ React__default["default"].createElement(LogMessageAnsi, { value: entry, highlight });
  } else if (needsHighlighter) {
    return /* @__PURE__ */ React__default["default"].createElement(
      Highlighter__default["default"],
      {
        textToHighlight: entry,
        searchWords,
        findChunks: data.findHighlightChunksInText,
        highlightClassName
      }
    );
  } else {
    return entry;
  }
}
const restructureLog = memoizeOne__default["default"]((line, prettifyLogMessage) => {
  if (prettifyLogMessage) {
    try {
      return JSON.stringify(JSON.parse(line), void 0, 2);
    } catch (error) {
      return line;
    }
  }
  return line;
});
class UnThemedLogRowMessage extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.onContextToggle = (e) => {
      e.stopPropagation();
      this.props.onToggleContext();
    };
  }
  render() {
    const {
      row,
      theme,
      errors,
      hasMoreContextRows,
      updateLimit,
      context,
      contextIsOpen,
      showContextToggle,
      wrapLogMessage,
      prettifyLogMessage,
      onToggleContext
    } = this.props;
    const style = getLogRowStyles(theme, row.logLevel);
    const { hasAnsi, raw } = row;
    const restructuredEntry = restructureLog(raw, prettifyLogMessage);
    const styles = getStyles$t(theme);
    return (
      // When context is open, the position has to be NOT relative.
      // Setting the postion as inline-style to overwrite the more sepecific style definition from `style.logsRowMessage`.
      /* @__PURE__ */ React__default["default"].createElement("td", { style: contextIsOpen ? { position: "unset" } : void 0, className: style.logsRowMessage }, /* @__PURE__ */ React__default["default"].createElement(
        "div",
        {
          className: css.cx({ [styles.positionRelative]: wrapLogMessage }, { [styles.horizontalScroll]: !wrapLogMessage })
        },
        contextIsOpen && context && /* @__PURE__ */ React__default["default"].createElement(
          LogRowContext,
          {
            row,
            context,
            errors,
            wrapLogMessage,
            hasMoreContextRows,
            onOutsideClick: onToggleContext,
            onLoadMoreContext: () => {
              if (updateLimit) {
                updateLimit();
              }
            }
          }
        ),
        /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx(styles.positionRelative, { [styles.rowWithContext]: contextIsOpen }) }, renderLogMessage(hasAnsi, restructuredEntry, row.searchWords, style.logsRowMatchHighLight)),
        !contextIsOpen && (showContextToggle == null ? void 0 : showContextToggle(row)) && /* @__PURE__ */ React__default["default"].createElement(
          "span",
          {
            className: css.cx("log-row-context", style.context, styles.contextButton),
            onClick: (e) => e.stopPropagation()
          },
          /* @__PURE__ */ React__default["default"].createElement(Tooltip, { placement: "top", content: "Show context" }, /* @__PURE__ */ React__default["default"].createElement(IconButton, { size: "md", name: "gf-show-context", onClick: this.onContextToggle })),
          /* @__PURE__ */ React__default["default"].createElement(Tooltip, { placement: "top", content: "Copy" }, /* @__PURE__ */ React__default["default"].createElement(
            IconButton,
            {
              size: "md",
              name: "copy",
              onClick: () => navigator.clipboard.writeText(JSON.stringify(restructuredEntry))
            }
          ))
        )
      ))
    );
  }
}
const LogRowMessage = withTheme2(UnThemedLogRowMessage);
LogRowMessage.displayName = "LogRowMessage";

var __defProp$S = Object.defineProperty;
var __defProps$C = Object.defineProperties;
var __getOwnPropDescs$C = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$T = Object.getOwnPropertySymbols;
var __hasOwnProp$T = Object.prototype.hasOwnProperty;
var __propIsEnum$T = Object.prototype.propertyIsEnumerable;
var __defNormalProp$S = (obj, key, value) => key in obj ? __defProp$S(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$S = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$T.call(b, prop))
      __defNormalProp$S(a, prop, b[prop]);
  if (__getOwnPropSymbols$T)
    for (var prop of __getOwnPropSymbols$T(b)) {
      if (__propIsEnum$T.call(b, prop))
        __defNormalProp$S(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$C = (a, b) => __defProps$C(a, __getOwnPropDescs$C(b));
const memoizedGetParser = memoizeOne__default["default"](data.getParser);
const getAllFields = memoizeOne__default["default"](
  (row, getFieldLinks) => {
    const logMessageFields = parseMessage(row.entry);
    const dataframeFields = getDataframeFields(row, getFieldLinks);
    const fieldsMap = [...dataframeFields, ...logMessageFields].reduce((acc, field) => {
      const value = field.value.replace(/(^")|("$)/g, "");
      const fieldHash = `${field.key}=${value}`;
      if (acc[fieldHash]) {
        acc[fieldHash].links = [...acc[fieldHash].links || [], ...field.links || []];
      } else {
        acc[fieldHash] = field;
      }
      return acc;
    }, {});
    const allFields = Object.values(fieldsMap);
    allFields.sort(sortFieldsLinkFirst);
    return allFields;
  }
);
const parseMessage = memoizeOne__default["default"]((rowEntry) => {
  if (rowEntry.length > MAX_CHARACTERS) {
    return [];
  }
  const parser = memoizedGetParser(rowEntry);
  if (!parser) {
    return [];
  }
  const detectedFields = parser.getFields(rowEntry);
  const fields = detectedFields.map((field) => {
    const key = parser.getLabelFromField(field);
    const value = parser.getValueFromField(field);
    return { key, value };
  });
  return fields;
});
const getDataframeFields = memoizeOne__default["default"](
  (row, getFieldLinks) => {
    return row.dataFrame.fields.map((field, index) => __spreadProps$C(__spreadValues$S({}, field), { index })).filter((field, index) => !shouldRemoveField(field, index, row)).map((field) => {
      const links = getFieldLinks ? getFieldLinks(field, row.rowIndex) : [];
      return {
        key: field.name,
        value: field.values.get(row.rowIndex).toString(),
        links,
        fieldIndex: field.index
      };
    });
  }
);
function sortFieldsLinkFirst(fieldA, fieldB) {
  var _a, _b, _c, _d;
  if (((_a = fieldA.links) == null ? void 0 : _a.length) && !((_b = fieldB.links) == null ? void 0 : _b.length)) {
    return -1;
  }
  if (!((_c = fieldA.links) == null ? void 0 : _c.length) && ((_d = fieldB.links) == null ? void 0 : _d.length)) {
    return 1;
  }
  return fieldA.key > fieldB.key ? 1 : fieldA.key < fieldB.key ? -1 : 0;
}
function shouldRemoveField(field, index, row) {
  var _a;
  if (field.name === "labels" && field.type === data.FieldType.other) {
    return true;
  }
  if (field.name === "id") {
    return true;
  }
  if (row.entryFieldIndex === index) {
    return true;
  }
  if ((_a = field.config.custom) == null ? void 0 : _a.hidden) {
    return true;
  }
  if (field.values.get(row.rowIndex) == null) {
    return true;
  }
  return false;
}

const getStyles$s = (theme) => {
  return {
    logsRowLevelDetails: css.css`
      label: logs-row__level_details;
      &::after {
        top: -3px;
      }
    `,
    logDetails: css.css`
      label: logDetailsDefaultCursor;
      cursor: default;

      &:hover {
        background-color: ${theme.colors.background.primary};
      }
    `
  };
};
class UnThemedLogDetails extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.getParser = memoizeOne__default["default"](data.getParser);
    this.getStatsForDetectedField = (key) => {
      const matcher = this.getParser(this.props.row.entry).buildMatcher(key);
      return data.calculateFieldStats(this.props.getRows(), matcher);
    };
  }
  render() {
    const {
      row,
      theme,
      hasError,
      onClickFilterOutLabel,
      onClickFilterLabel,
      getRows,
      showDuplicates,
      className,
      onClickShowDetectedField,
      onClickHideDetectedField,
      showDetectedFields,
      getFieldLinks,
      wrapLogMessage
    } = this.props;
    const style = getLogRowStyles(theme, row.logLevel);
    const styles = getStyles$s(theme);
    const labels = row.labels ? row.labels : {};
    const labelsAvailable = Object.keys(labels).length > 0;
    const fields = getAllFields(row, getFieldLinks);
    const detectedFieldsAvailable = fields && fields.length > 0;
    const levelClassName = css.cx(!hasError && [style.logsRowLevel, styles.logsRowLevelDetails]);
    return /* @__PURE__ */ React__default["default"].createElement("tr", { className: css.cx(className, styles.logDetails) }, showDuplicates && /* @__PURE__ */ React__default["default"].createElement("td", null), /* @__PURE__ */ React__default["default"].createElement("td", { className: levelClassName, "aria-label": "Log level" }), /* @__PURE__ */ React__default["default"].createElement("td", { colSpan: 4 }, /* @__PURE__ */ React__default["default"].createElement("div", { className: style.logDetailsContainer }, /* @__PURE__ */ React__default["default"].createElement("table", { className: style.logDetailsTable }, /* @__PURE__ */ React__default["default"].createElement("tbody", null, labelsAvailable && /* @__PURE__ */ React__default["default"].createElement("tr", null, /* @__PURE__ */ React__default["default"].createElement("td", { colSpan: 5, className: style.logDetailsHeading, "aria-label": "Log labels" }, "Log labels")), Object.keys(labels).sort().map((key) => {
      const value = labels[key];
      return /* @__PURE__ */ React__default["default"].createElement(
        LogDetailsRow,
        {
          key: `${key}=${value}`,
          parsedKey: key,
          parsedValue: value,
          isLabel: true,
          getStats: () => data.calculateLogsLabelStats(getRows(), key),
          onClickFilterOutLabel,
          onClickFilterLabel
        }
      );
    }), detectedFieldsAvailable && /* @__PURE__ */ React__default["default"].createElement("tr", null, /* @__PURE__ */ React__default["default"].createElement("td", { colSpan: 5, className: style.logDetailsHeading, "aria-label": "Detected fields" }, "Detected fields", /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: "Fields that are parsed from log message and detected by Grafana." }, /* @__PURE__ */ React__default["default"].createElement(
      Icon,
      {
        name: "question-circle",
        size: "xs",
        className: css.css`
                            margin-left: 4px;
                          `
      }
    )))), fields.sort().map((field) => {
      const { key, value, links, fieldIndex } = field;
      return /* @__PURE__ */ React__default["default"].createElement(
        LogDetailsRow,
        {
          key: `${key}=${value}`,
          parsedKey: key,
          parsedValue: value,
          links,
          onClickShowDetectedField,
          onClickHideDetectedField,
          getStats: () => fieldIndex === void 0 ? this.getStatsForDetectedField(key) : data.calculateStats(row.dataFrame.fields[fieldIndex].values.toArray()),
          showDetectedFields,
          wrapLogMessage
        }
      );
    }), !detectedFieldsAvailable && !labelsAvailable && /* @__PURE__ */ React__default["default"].createElement("tr", null, /* @__PURE__ */ React__default["default"].createElement("td", { colSpan: 5, "aria-label": "No details" }, "No details available")))))));
  }
}
const LogDetails = withTheme2(UnThemedLogDetails);
LogDetails.displayName = "LogDetails";

const getRowContexts = async (getRowContext, row, limit, logsSortOrder) => {
  const promises = [
    getRowContext(row, {
      limit
    }),
    getRowContext(row, {
      // The start time is inclusive so we will get the one row we are using as context entry
      limit: limit + 1,
      direction: "FORWARD"
    })
  ];
  const results = await Promise.all(promises.map((p) => p.catch((e) => e)));
  const data$1 = results.map((result) => {
    const dataResult = result;
    if (!dataResult.data) {
      return [];
    }
    const data2 = [];
    for (let index = 0; index < dataResult.data.length; index++) {
      const dataFrame = data.toDataFrame(dataResult.data[index]);
      const fieldCache = new data.FieldCache(dataFrame);
      const timestampField = fieldCache.getFieldByName("ts");
      const idField = fieldCache.getFieldByName("id");
      for (let fieldIndex = 0; fieldIndex < timestampField.values.length; fieldIndex++) {
        if (idField) {
          if (idField.values.get(fieldIndex) === row.uid) {
            continue;
          }
        } else {
          if (parseInt(timestampField.values.get(fieldIndex), 10) === row.timeEpochMs) {
            continue;
          }
        }
        const lineField = dataFrame.fields.filter((field) => field.name === "line")[0];
        const line = lineField.values.get(fieldIndex);
        data2.push(line);
      }
    }
    return logsSortOrder === data.LogsSortOrder.Ascending ? data2.reverse() : data2;
  });
  const errors = results.map((result) => {
    const errorResult = result;
    if (!errorResult.message) {
      return "";
    }
    return errorResult.message;
  });
  return {
    data: logsSortOrder === data.LogsSortOrder.Ascending ? data$1.reverse() : data$1,
    errors: logsSortOrder === data.LogsSortOrder.Ascending ? errors.reverse() : errors
  };
};
const LogRowContextProvider = ({ getRowContext, row, children, logsSortOrder }) => {
  const [limit, setLimit] = React.useState(10);
  const [result, setResult] = React.useState(null);
  const [hasMoreContextRows, setHasMoreContextRows] = React.useState({
    before: true,
    after: true
  });
  const { value } = useAsync__default["default"](async () => {
    return await getRowContexts(getRowContext, row, limit, logsSortOrder);
  }, [limit]);
  React.useEffect(() => {
    if (value) {
      setResult((currentResult) => {
        let hasMoreLogsBefore = true, hasMoreLogsAfter = true;
        if (currentResult) {
          const currentResultBefore = currentResult.data[0];
          const currentResultAfter = currentResult.data[1];
          const valueBefore = value.data[0];
          const valueAfter = value.data[1];
          if (!valueBefore || currentResultBefore.length === valueBefore.length) {
            hasMoreLogsBefore = false;
          }
          if (!valueAfter || currentResultAfter.length === valueAfter.length) {
            hasMoreLogsAfter = false;
          }
        }
        setHasMoreContextRows({
          before: hasMoreLogsBefore,
          after: hasMoreLogsAfter
        });
        return value;
      });
    }
  }, [value]);
  return children({
    result: {
      before: result ? result.data[0] : [],
      after: result ? result.data[1] : []
    },
    errors: {
      before: result ? result.errors[0] : void 0,
      after: result ? result.errors[1] : void 0
    },
    hasMoreContextRows,
    updateLimit: () => setLimit(limit + 10),
    limit
  });
};

class UnThemedLogRowMessageDetectedFields extends React.PureComponent {
  render() {
    const { row, showDetectedFields, getFieldLinks, wrapLogMessage } = this.props;
    const fields = getAllFields(row, getFieldLinks);
    const wrapClassName = wrapLogMessage ? "" : css.css`
          white-space: nowrap;
        `;
    const line = showDetectedFields.map((parsedKey) => {
      const field = fields.find((field2) => {
        const { key } = field2;
        return key === parsedKey;
      });
      if (field) {
        return `${parsedKey}=${field.value}`;
      }
      return null;
    }).filter((s) => s !== null).join(" ");
    return /* @__PURE__ */ React__default["default"].createElement("td", { className: wrapClassName }, line);
  }
}
const LogRowMessageDetectedFields = withTheme2(UnThemedLogRowMessageDetectedFields);
LogRowMessageDetectedFields.displayName = "LogRowMessageDetectedFields";

var __defProp$R = Object.defineProperty;
var __defProps$B = Object.defineProperties;
var __getOwnPropDescs$B = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$S = Object.getOwnPropertySymbols;
var __hasOwnProp$S = Object.prototype.hasOwnProperty;
var __propIsEnum$S = Object.prototype.propertyIsEnumerable;
var __defNormalProp$R = (obj, key, value) => key in obj ? __defProp$R(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$R = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$S.call(b, prop))
      __defNormalProp$R(a, prop, b[prop]);
  if (__getOwnPropSymbols$S)
    for (var prop of __getOwnPropSymbols$S(b)) {
      if (__propIsEnum$S.call(b, prop))
        __defNormalProp$R(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$B = (a, b) => __defProps$B(a, __getOwnPropDescs$B(b));
const getStyles$r = (theme) => {
  return {
    topVerticalAlign: css.css`
      label: topVerticalAlign;
      margin-top: -${theme.spacing(0.9)};
      margin-left: -${theme.spacing(0.25)};
    `,
    detailsOpen: css.css`
      &:hover {
        background-color: ${hoverColor(theme.colors.background.primary, theme)};
      }
    `,
    errorLogRow: css.css`
      label: erroredLogRow;
      color: ${theme.colors.text.secondary};
    `
  };
};
class UnThemedLogRow extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      showContext: false,
      showDetails: false
    };
    this.toggleContext = () => {
      this.setState((state) => {
        return {
          showContext: !state.showContext
        };
      });
    };
    this.toggleDetails = () => {
      if (!this.props.enableLogDetails) {
        return;
      }
      this.setState((state) => {
        return {
          showDetails: !state.showDetails
        };
      });
    };
  }
  renderTimeStamp(epochMs) {
    return data.dateTimeFormat(epochMs, {
      timeZone: this.props.timeZone
    });
  }
  renderLogRow(context, errors, hasMoreContextRows, updateLimit) {
    const {
      getRows,
      onClickFilterLabel,
      onClickFilterOutLabel,
      onClickShowDetectedField,
      onClickHideDetectedField,
      enableLogDetails,
      row,
      showDuplicates,
      showContextToggle,
      showLabels,
      showTime,
      showDetectedFields,
      wrapLogMessage,
      prettifyLogMessage,
      theme,
      getFieldLinks,
      forceEscape,
      onLogRowHover
    } = this.props;
    const { showDetails, showContext } = this.state;
    const style = getLogRowStyles(theme, row.logLevel);
    const styles = getStyles$r(theme);
    const { errorMessage, hasError } = data.checkLogsError(row);
    const logRowBackground = css.cx(style.logsRow, {
      [styles.errorLogRow]: hasError
    });
    const processedRow = row.hasUnescapedContent && forceEscape ? __spreadProps$B(__spreadValues$R({}, row), { entry: data.escapeUnescapedString(row.entry), raw: data.escapeUnescapedString(row.raw) }) : row;
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
      "tr",
      {
        className: logRowBackground,
        onClick: this.toggleDetails,
        onMouseEnter: () => {
          onLogRowHover && onLogRowHover(row);
        },
        onMouseLeave: () => {
          onLogRowHover && onLogRowHover(void 0);
        }
      },
      showDuplicates && /* @__PURE__ */ React__default["default"].createElement("td", { className: style.logsRowDuplicates }, processedRow.duplicates && processedRow.duplicates > 0 ? `${processedRow.duplicates + 1}x` : null),
      /* @__PURE__ */ React__default["default"].createElement("td", { className: css.cx({ [style.logsRowLevel]: !hasError }) }, hasError && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: `Error: ${errorMessage}`, placement: "right", theme: "error" }, /* @__PURE__ */ React__default["default"].createElement(Icon, { className: style.logIconError, name: "exclamation-triangle", size: "xs" }))),
      enableLogDetails && /* @__PURE__ */ React__default["default"].createElement("td", { title: showDetails ? "Hide log details" : "See log details", className: style.logsRowToggleDetails }, /* @__PURE__ */ React__default["default"].createElement(Icon, { className: styles.topVerticalAlign, name: showDetails ? "angle-down" : "angle-right" })),
      showTime && /* @__PURE__ */ React__default["default"].createElement("td", { className: style.logsRowLocalTime }, this.renderTimeStamp(row.timeEpochMs)),
      showLabels && processedRow.uniqueLabels && /* @__PURE__ */ React__default["default"].createElement("td", { className: style.logsRowLabels }, /* @__PURE__ */ React__default["default"].createElement(LogLabels, { labels: processedRow.uniqueLabels })),
      showDetectedFields && showDetectedFields.length > 0 ? /* @__PURE__ */ React__default["default"].createElement(
        LogRowMessageDetectedFields,
        {
          row: processedRow,
          showDetectedFields,
          getFieldLinks,
          wrapLogMessage
        }
      ) : /* @__PURE__ */ React__default["default"].createElement(
        LogRowMessage,
        {
          row: processedRow,
          getRows,
          errors,
          hasMoreContextRows,
          updateLimit,
          context,
          contextIsOpen: showContext,
          showContextToggle,
          wrapLogMessage,
          prettifyLogMessage,
          onToggleContext: this.toggleContext
        }
      )
    ), this.state.showDetails && /* @__PURE__ */ React__default["default"].createElement(
      LogDetails,
      {
        className: logRowBackground,
        showDuplicates,
        getFieldLinks,
        onClickFilterLabel,
        onClickFilterOutLabel,
        onClickShowDetectedField,
        onClickHideDetectedField,
        getRows,
        row: processedRow,
        wrapLogMessage,
        hasError,
        showDetectedFields
      }
    ));
  }
  render() {
    const { showContext } = this.state;
    const { logsSortOrder, row, getRowContext } = this.props;
    if (showContext) {
      return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(LogRowContextProvider, { row, getRowContext, logsSortOrder }, ({ result, errors, hasMoreContextRows, updateLimit }) => {
        return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, this.renderLogRow(result, errors, hasMoreContextRows, updateLimit));
      }));
    }
    return this.renderLogRow();
  }
}
const LogRow = withTheme2(UnThemedLogRow);
LogRow.displayName = "LogRow";

const PREVIEW_LIMIT = 100;
class UnThemedLogRows extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.renderAllTimer = null;
    this.state = {
      renderAll: false
    };
    this.makeGetRows = memoizeOne__default["default"]((orderedRows) => {
      return () => orderedRows;
    });
    this.sortLogs = memoizeOne__default["default"](
      (logRows, logsSortOrder) => data.sortLogRows(logRows, logsSortOrder)
    );
  }
  componentDidMount() {
    const { logRows, previewLimit } = this.props;
    const rowCount = logRows ? logRows.length : 0;
    const renderAll = rowCount <= previewLimit * 2;
    if (renderAll) {
      this.setState({ renderAll });
    } else {
      this.renderAllTimer = window.setTimeout(() => this.setState({ renderAll: true }), 2e3);
    }
  }
  componentWillUnmount() {
    if (this.renderAllTimer) {
      clearTimeout(this.renderAllTimer);
    }
  }
  render() {
    const {
      dedupStrategy,
      showContextToggle,
      showLabels,
      showTime,
      wrapLogMessage,
      prettifyLogMessage,
      logRows,
      deduplicatedRows,
      timeZone,
      onClickFilterLabel,
      onClickFilterOutLabel,
      theme,
      enableLogDetails,
      previewLimit,
      getFieldLinks,
      logsSortOrder,
      showDetectedFields,
      onClickShowDetectedField,
      onClickHideDetectedField,
      forceEscape,
      onLogRowHover
    } = this.props;
    const { renderAll } = this.state;
    const { logsRowsTable } = getLogRowStyles(theme);
    const dedupedRows = deduplicatedRows ? deduplicatedRows : logRows;
    const hasData = logRows && logRows.length > 0;
    const dedupCount = dedupedRows ? dedupedRows.reduce((sum, row) => row.duplicates ? sum + row.duplicates : sum, 0) : 0;
    const showDuplicates = dedupStrategy !== data.LogsDedupStrategy.none && dedupCount > 0;
    const processedRows = dedupedRows ? dedupedRows : [];
    const orderedRows = logsSortOrder ? this.sortLogs(processedRows, logsSortOrder) : processedRows;
    const firstRows = orderedRows.slice(0, previewLimit);
    const lastRows = orderedRows.slice(previewLimit, orderedRows.length);
    const getRows = this.makeGetRows(orderedRows);
    const getRowContext = this.props.getRowContext ? this.props.getRowContext : () => Promise.resolve([]);
    return /* @__PURE__ */ React__default["default"].createElement("table", { className: logsRowsTable }, /* @__PURE__ */ React__default["default"].createElement("tbody", null, hasData && firstRows.map((row, index) => /* @__PURE__ */ React__default["default"].createElement(
      LogRow,
      {
        key: row.uid,
        getRows,
        getRowContext,
        row,
        showContextToggle,
        showDuplicates,
        showLabels,
        showTime,
        showDetectedFields,
        wrapLogMessage,
        prettifyLogMessage,
        timeZone,
        enableLogDetails,
        onClickFilterLabel,
        onClickFilterOutLabel,
        onClickShowDetectedField,
        onClickHideDetectedField,
        getFieldLinks,
        logsSortOrder,
        forceEscape,
        onLogRowHover
      }
    )), hasData && renderAll && lastRows.map((row, index) => /* @__PURE__ */ React__default["default"].createElement(
      LogRow,
      {
        key: row.uid,
        getRows,
        getRowContext,
        row,
        showContextToggle,
        showDuplicates,
        showLabels,
        showTime,
        showDetectedFields,
        wrapLogMessage,
        prettifyLogMessage,
        timeZone,
        enableLogDetails,
        onClickFilterLabel,
        onClickFilterOutLabel,
        onClickShowDetectedField,
        onClickHideDetectedField,
        getFieldLinks,
        logsSortOrder,
        forceEscape,
        onLogRowHover
      }
    )), hasData && !renderAll && /* @__PURE__ */ React__default["default"].createElement("tr", null, /* @__PURE__ */ React__default["default"].createElement("td", { colSpan: 5 }, "Rendering ", orderedRows.length - previewLimit, " rows..."))));
  }
}
UnThemedLogRows.defaultProps = {
  previewLimit: PREVIEW_LIMIT
};
const LogRows = withTheme2(UnThemedLogRows);
LogRows.displayName = "LogsRows";

function FieldLinkList({ links }) {
  const styles = useStyles2(getStyles$q);
  if (links.length === 1) {
    return /* @__PURE__ */ React__default["default"].createElement(DataLinkButton, { link: links[0] });
  }
  const externalLinks = links.filter((link) => link.target === "_blank");
  const internalLinks = links.filter((link) => link.target === "_self");
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, internalLinks.map((link, i) => {
    return /* @__PURE__ */ React__default["default"].createElement(DataLinkButton, { key: i, link });
  }), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, /* @__PURE__ */ React__default["default"].createElement("p", { className: styles.externalLinksHeading }, "External links"), externalLinks.map((link, i) => /* @__PURE__ */ React__default["default"].createElement("a", { key: i, href: link.href, target: link.target, className: styles.externalLink }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "external-link-alt" }), link.title))));
}
const getStyles$q = (theme) => ({
  wrapper: css.css`
    flex-basis: 150px;
    width: 100px;
    margin-top: ${theme.spacing(1)};
  `,
  externalLinksHeading: css.css`
    color: ${theme.colors.text.secondary};
    font-weight: ${theme.typography.fontWeightRegular};
    font-size: ${theme.typography.size.sm};
    margin: 0;
  `,
  externalLink: css.css`
    color: ${theme.colors.text.link};
    font-weight: ${theme.typography.fontWeightRegular};
    display: block;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;

    &:hover {
      text-decoration: underline;
    }

    div {
      margin-right: ${theme.spacing(1)};
    }
  `
});

const FullWidthButtonContainer = ({ className, children }) => {
  const styles = getStyles$p();
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles, className) }, children);
};
const getStyles$p = stylesFactory(() => {
  return css.css`
    display: flex;

    button {
      flex-grow: 1;
      justify-content: center;
    }

    > * {
      flex-grow: 1;
    }

    label {
      flex-grow: 1;
      text-align: center;
    }
  `;
});

var __defProp$Q = Object.defineProperty;
var __defProps$A = Object.defineProperties;
var __getOwnPropDescs$A = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$R = Object.getOwnPropertySymbols;
var __hasOwnProp$R = Object.prototype.hasOwnProperty;
var __propIsEnum$R = Object.prototype.propertyIsEnumerable;
var __defNormalProp$Q = (obj, key, value) => key in obj ? __defProp$Q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$Q = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$R.call(b, prop))
      __defNormalProp$Q(a, prop, b[prop]);
  if (__getOwnPropSymbols$R)
    for (var prop of __getOwnPropSymbols$R(b)) {
      if (__propIsEnum$R.call(b, prop))
        __defNormalProp$Q(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$A = (a, b) => __defProps$A(a, __getOwnPropDescs$A(b));
var __objRest$v = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$R.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$R)
    for (var prop of __getOwnPropSymbols$R(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$R.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const optionsToKeep = ["reduceOptions", "orientation"];
function sharedSingleStatPanelChangedHandler(panel, prevPluginId, prevOptions) {
  let options = panel.options;
  panel.fieldConfig = panel.fieldConfig || {
    defaults: {},
    overrides: []
  };
  if (prevPluginId === "singlestat" && prevOptions.angular) {
    return migrateFromAngularSinglestat(panel, prevOptions);
  }
  for (const k of optionsToKeep) {
    if (prevOptions.hasOwnProperty(k)) {
      options[k] = lodash.cloneDeep(prevOptions[k]);
    }
  }
  return options;
}
function migrateFromAngularSinglestat(panel, prevOptions) {
  const prevPanel = prevOptions.angular;
  const reducer = data.fieldReducers.getIfExists(prevPanel.valueName);
  const options = {
    reduceOptions: {
      calcs: [reducer ? reducer.id : data.ReducerID.mean]
    },
    orientation: data.VizOrientation.Horizontal
  };
  const defaults = {};
  if (prevPanel.format) {
    defaults.unit = prevPanel.format;
  }
  if (prevPanel.tableColumn) {
    options.reduceOptions.fields = `/^${prevPanel.tableColumn}$/`;
  }
  if (prevPanel.nullPointMode) {
    defaults.nullValueMode = prevPanel.nullPointMode;
  }
  if (prevPanel.nullText) {
    defaults.noValue = prevPanel.nullText;
  }
  if (prevPanel.decimals || prevPanel.decimals === 0) {
    defaults.decimals = prevPanel.decimals;
  }
  if (prevPanel.thresholds && prevPanel.colors) {
    const levels = prevPanel.thresholds.split(",").map((strVale) => {
      return Number(strVale.trim());
    });
    const thresholds = [];
    for (const color of prevPanel.colors) {
      const idx = thresholds.length - 1;
      if (idx >= 0) {
        thresholds.push({ value: levels[idx], color });
      } else {
        thresholds.push({ value: -Infinity, color });
      }
    }
    defaults.thresholds = {
      mode: data.ThresholdsMode.Absolute,
      steps: thresholds
    };
  }
  const mappings = data.convertOldAngularValueMappings(prevPanel, defaults.thresholds);
  if (mappings && mappings.length) {
    defaults.mappings = mappings;
  }
  if (prevPanel.gauge && prevPanel.gauge.show) {
    defaults.min = prevPanel.gauge.minValue;
    defaults.max = prevPanel.gauge.maxValue;
  }
  panel.fieldConfig.defaults = defaults;
  return options;
}
function sharedSingleStatMigrationHandler(panel) {
  var _b, _c;
  if (!panel.options) {
    return {};
  }
  const previousVersion = parseFloat(panel.pluginVersion || "6.1");
  let options = panel.options;
  if (previousVersion < 6.2) {
    options = migrateFromValueOptions(options);
  }
  if (previousVersion < 6.3) {
    options = moveThresholdsAndMappingsToField(options);
  }
  const { fieldOptions } = options;
  if (previousVersion < 6.6 && fieldOptions) {
    if (fieldOptions && fieldOptions.override) {
      const _a = options.fieldOptions, rest = __objRest$v(_a, ["override"]);
      options = __spreadProps$A(__spreadValues$Q({}, options), {
        fieldOptions: __spreadProps$A(__spreadValues$Q({}, rest), {
          overrides: []
        })
      });
    }
    let thresholds = (_b = fieldOptions == null ? void 0 : fieldOptions.defaults) == null ? void 0 : _b.thresholds;
    if (thresholds) {
      delete fieldOptions.defaults.thresholds;
    } else {
      thresholds = fieldOptions == null ? void 0 : fieldOptions.thresholds;
      delete fieldOptions.thresholds;
    }
    if (thresholds) {
      fieldOptions.defaults.thresholds = {
        mode: data.ThresholdsMode.Absolute,
        steps: thresholds
      };
    }
    const { defaults } = fieldOptions;
    if (defaults.color && typeof defaults.color === "string") {
      defaults.color = {
        mode: data.FieldColorModeId.Fixed,
        fixedColor: defaults.color
      };
    }
    data.validateFieldConfig(defaults);
  }
  if (previousVersion < 7) {
    panel.fieldConfig = panel.fieldConfig || { defaults: {}, overrides: [] };
    panel.fieldConfig = {
      defaults: fieldOptions && fieldOptions.defaults ? __spreadValues$Q(__spreadValues$Q({}, panel.fieldConfig.defaults), fieldOptions.defaults) : panel.fieldConfig.defaults,
      overrides: fieldOptions && fieldOptions.overrides ? [...panel.fieldConfig.overrides, ...fieldOptions.overrides] : panel.fieldConfig.overrides
    };
    if (fieldOptions) {
      options.reduceOptions = {
        values: fieldOptions.values,
        limit: fieldOptions.limit,
        calcs: fieldOptions.calcs
      };
    }
    delete options.fieldOptions;
  }
  if (previousVersion < 7.1) {
    const oldTitle = panel.fieldConfig.defaults.title;
    if (oldTitle !== void 0 && oldTitle !== null) {
      panel.fieldConfig.defaults.displayName = oldTitle;
      delete panel.fieldConfig.defaults.title;
    }
  }
  if (previousVersion < 8) {
    const config = (_c = panel.fieldConfig) == null ? void 0 : _c.defaults;
    let unit = config == null ? void 0 : config.unit;
    if (unit === "percent") {
      if (!lodash.isNumber(config.min)) {
        config.min = 0;
      }
      if (!lodash.isNumber(config.max)) {
        config.max = 100;
      }
    } else if (unit === "percentunit") {
      if (!lodash.isNumber(config.min)) {
        config.min = 0;
      }
      if (!lodash.isNumber(config.max)) {
        config.max = 1;
      }
    }
  }
  return options;
}
function moveThresholdsAndMappingsToField(old) {
  const { fieldOptions } = old;
  if (!fieldOptions) {
    return old;
  }
  const _a = old.fieldOptions, { mappings } = _a, rest = __objRest$v(_a, ["mappings"]);
  let thresholds = void 0;
  if (old.thresholds) {
    thresholds = {
      mode: data.ThresholdsMode.Absolute,
      steps: migrateOldThresholds(old.thresholds)
    };
  }
  return __spreadProps$A(__spreadValues$Q({}, old), {
    fieldOptions: __spreadProps$A(__spreadValues$Q({}, rest), {
      defaults: __spreadProps$A(__spreadValues$Q({}, fieldOptions.defaults), {
        mappings,
        thresholds
      })
    })
  });
}
function migrateFromValueOptions(old) {
  const { valueOptions } = old;
  if (!valueOptions) {
    return old;
  }
  const fieldOptions = {};
  const fieldDefaults = {};
  fieldOptions.mappings = old.valueMappings;
  fieldOptions.thresholds = old.thresholds;
  fieldOptions.defaults = fieldDefaults;
  fieldDefaults.unit = valueOptions.unit;
  fieldDefaults.decimals = valueOptions.decimals;
  if (valueOptions.stat) {
    const reducer = data.fieldReducers.get(valueOptions.stat);
    if (reducer) {
      fieldOptions.calcs = [reducer.id];
    }
  }
  fieldDefaults.min = old.minValue;
  fieldDefaults.max = old.maxValue;
  const newOptions = __spreadProps$A(__spreadValues$Q({}, old), {
    fieldOptions
  });
  return lodash.omit(newOptions, "valueMappings", "thresholds", "valueOptions", "minValue", "maxValue");
}
function migrateOldThresholds(thresholds) {
  if (!thresholds || !thresholds.length) {
    return void 0;
  }
  const copy = thresholds.map((t) => {
    return {
      // Drops 'index'
      value: t.value === null ? -Infinity : t.value,
      color: t.color
    };
  });
  data.sortThresholds(copy);
  copy[0].value = -Infinity;
  return copy;
}
function convertOldAngularValueMapping(panel) {
  return data.convertOldAngularValueMappings(panel);
}

const CallToActionCard = ({ message, callToActionElement, footer, className }) => {
  const css2 = useStyles2(getStyles$o);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([css2.wrapper, className]) }, message && /* @__PURE__ */ React__default["default"].createElement("div", { className: css2.message }, message), callToActionElement, footer && /* @__PURE__ */ React__default["default"].createElement("div", { className: css2.footer }, footer));
};
const getStyles$o = (theme) => ({
  wrapper: css.css`
    label: call-to-action-card;
    padding: ${theme.spacing(3)};
    background: ${theme.colors.background.secondary};
    border-radius: ${theme.shape.radius.default};
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    flex-grow: 1;
  `,
  message: css.css`
    margin-bottom: ${theme.spacing(3)};
    font-style: italic;
  `,
  footer: css.css`
    margin-top: ${theme.spacing(3)}};
  `
});

var __defProp$P = Object.defineProperty;
var __defProps$z = Object.defineProperties;
var __getOwnPropDescs$z = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$Q = Object.getOwnPropertySymbols;
var __hasOwnProp$Q = Object.prototype.hasOwnProperty;
var __propIsEnum$Q = Object.prototype.propertyIsEnumerable;
var __defNormalProp$P = (obj, key, value) => key in obj ? __defProp$P(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$P = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$Q.call(b, prop))
      __defNormalProp$P(a, prop, b[prop]);
  if (__getOwnPropSymbols$Q)
    for (var prop of __getOwnPropSymbols$Q(b)) {
      if (__propIsEnum$Q.call(b, prop))
        __defNormalProp$P(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$z = (a, b) => __defProps$z(a, __getOwnPropDescs$z(b));
var __objRest$u = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$Q.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$Q)
    for (var prop of __getOwnPropSymbols$Q(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$Q.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Switch = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { value, checked, onChange, id, label, disabled } = _b, inputProps = __objRest$u(_b, ["value", "checked", "onChange", "id", "label", "disabled"]);
    if (checked) {
      data.deprecationWarning("Switch", "checked prop", "value");
    }
    const theme = useTheme2();
    const styles = getSwitchStyles(theme);
    const switchIdRef = React.useRef(id ? id : lodash.uniqueId("switch-"));
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.switch) }, /* @__PURE__ */ React__default["default"].createElement(
      "input",
      __spreadProps$z(__spreadValues$P({
        type: "checkbox",
        disabled,
        checked: value,
        onChange: (event) => {
          !disabled && (onChange == null ? void 0 : onChange(event));
        },
        id: switchIdRef.current
      }, inputProps), {
        ref
      })
    ), /* @__PURE__ */ React__default["default"].createElement("label", { htmlFor: switchIdRef.current, "aria-label": label != null ? label : "Toggle switch" }));
  }
);
Switch.displayName = "Switch";
const InlineSwitch = React__default["default"].forwardRef(
  (_c, ref) => {
    var _d = _c, { transparent, className, showLabel, label, value, id } = _d, props = __objRest$u(_d, ["transparent", "className", "showLabel", "label", "value", "id"]);
    const theme = useTheme2();
    const styles = getSwitchStyles(theme, transparent);
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.inlineContainer, className, props.disabled && styles.disabled) }, showLabel && /* @__PURE__ */ React__default["default"].createElement(
      "label",
      {
        htmlFor: id,
        className: css.cx(styles.inlineLabel, value && styles.inlineLabelEnabled, "inline-switch-label")
      },
      label
    ), /* @__PURE__ */ React__default["default"].createElement(Switch, __spreadProps$z(__spreadValues$P({}, props), { id, label, ref, value })));
  }
);
InlineSwitch.displayName = "Switch";
const getSwitchStyles = stylesFactory((theme, transparent) => {
  return {
    switch: css.css`
      width: 32px;
      height: 16px;
      position: relative;

      input {
        opacity: 0;
        left: -100vw;
        z-index: -1000;
        position: absolute;

        &:disabled + label {
          background: ${theme.colors.action.disabledBackground};
          cursor: not-allowed;
        }

        &:checked + label {
          background: ${theme.colors.primary.main};
          border-color: ${theme.colors.primary.main};

          &:hover {
            background: ${theme.colors.primary.shade};
          }

          &::after {
            transform: translate3d(18px, -50%, 0);
            background: ${theme.colors.primary.contrastText};
          }
        }

        &:focus + label,
        &:focus-visible + label {
          ${getFocusStyles(theme)}
        }

        &:focus:not(:focus-visible) + label {
          ${getMouseFocusStyles()}
        }
      }

      label {
        width: 100%;
        height: 100%;
        cursor: pointer;
        border: none;
        border-radius: ${theme.shape.radius.pill};
        background: ${theme.components.input.background};
        border: 1px solid ${theme.components.input.borderColor};
        transition: all 0.3s ease;

        &:hover {
          border-color: ${theme.components.input.borderHover};
        }

        &::after {
          position: absolute;
          display: block;
          content: '';
          width: 12px;
          height: 12px;
          border-radius: ${theme.shape.radius.circle};
          background: ${theme.colors.text.secondary};
          box-shadow: ${theme.shadows.z1};
          top: 50%;
          transform: translate3d(2px, -50%, 0);
          transition: transform 0.2s cubic-bezier(0.19, 1, 0.22, 1);
        }
      }
    `,
    inlineContainer: css.css`
      padding: ${theme.spacing(0, 1)};
      height: ${theme.spacing(theme.components.height.md)};
      display: inline-flex;
      align-items: center;
      background: ${transparent ? "transparent" : theme.components.input.background};
      border: 1px solid ${transparent ? "transparent" : theme.components.input.borderColor};
      border-radius: ${theme.shape.borderRadius()};

      &:hover {
        border: 1px solid ${transparent ? "transparent" : theme.components.input.borderHover};

        .inline-switch-label {
          color: ${theme.colors.text.primary};
        }
      }
    `,
    disabled: css.css`
      background-color: rgba(204, 204, 220, 0.04);
      color: rgba(204, 204, 220, 0.6);
      border: 1px solid rgba(204, 204, 220, 0.04);
    `,
    inlineLabel: css.css`
      cursor: pointer;
      padding-right: ${theme.spacing(1)};
      color: ${theme.colors.text.secondary};
      white-space: nowrap;
    `,
    inlineLabelEnabled: css.css`
      color: ${theme.colors.text.primary};
    `
  };
});

var __defProp$O = Object.defineProperty;
var __defProps$y = Object.defineProperties;
var __getOwnPropDescs$y = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$P = Object.getOwnPropertySymbols;
var __hasOwnProp$P = Object.prototype.hasOwnProperty;
var __propIsEnum$P = Object.prototype.propertyIsEnumerable;
var __defNormalProp$O = (obj, key, value) => key in obj ? __defProp$O(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$O = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$P.call(b, prop))
      __defNormalProp$O(a, prop, b[prop]);
  if (__getOwnPropSymbols$P)
    for (var prop of __getOwnPropSymbols$P(b)) {
      if (__propIsEnum$P.call(b, prop))
        __defNormalProp$O(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$y = (a, b) => __defProps$y(a, __getOwnPropDescs$y(b));
var __objRest$t = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$P.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$P)
    for (var prop of __getOwnPropSymbols$P(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$P.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getStyles$n = (theme) => {
  return {
    list: css.css`
      border-bottom: 1px solid ${theme.colors.border.weak};
      &:last-child {
        border: none;
      }
    `,
    wrapper: css.css`
      background: ${theme.colors.background.primary};
      width: 250px;
    `,
    item: css.css`
      background: none;
      padding: 2px 8px;
      color: ${theme.colors.text.primary};
      cursor: pointer;
      &:hover {
        background: ${theme.colors.action.hover};
      }
    `,
    label: css.css`
      color: ${theme.colors.text.secondary};
    `,
    activeItem: css.css`
      background: ${theme.colors.background.secondary};
      &:hover {
        background: ${theme.colors.background.secondary};
      }
    `,
    itemValue: css.css`
      font-family: ${theme.typography.fontFamilyMonospace};
      font-size: ${theme.typography.size.sm};
    `
  };
};
const DataLinkSuggestions = (_a) => {
  var _b = _a, { suggestions } = _b, otherProps = __objRest$t(_b, ["suggestions"]);
  const ref = React.useRef(null);
  useClickAway__default["default"](ref, () => {
    if (otherProps.onClose) {
      otherProps.onClose();
    }
  });
  const groupedSuggestions = React.useMemo(() => {
    return lodash.groupBy(suggestions, (s) => s.origin);
  }, [suggestions]);
  const styles = useStyles2(getStyles$n);
  return /* @__PURE__ */ React__default["default"].createElement("div", { role: "menu", ref, className: styles.wrapper }, Object.keys(groupedSuggestions).map((key, i) => {
    const indexOffset = i === 0 ? 0 : Object.keys(groupedSuggestions).reduce((acc, current, index) => {
      if (index >= i) {
        return acc;
      }
      return acc + groupedSuggestions[current].length;
    }, 0);
    return /* @__PURE__ */ React__default["default"].createElement(
      DataLinkSuggestionsList,
      __spreadProps$y(__spreadValues$O({}, otherProps), {
        suggestions: groupedSuggestions[key],
        label: `${lodash.capitalize(key)}`,
        activeIndex: otherProps.activeIndex,
        activeIndexOffset: indexOffset,
        key
      })
    );
  }));
};
DataLinkSuggestions.displayName = "DataLinkSuggestions";
const DataLinkSuggestionsList = React__default["default"].memo(
  ({
    activeIndex,
    activeIndexOffset,
    label,
    onClose,
    onSuggestionSelect,
    suggestions,
    activeRef: selectedRef
  }) => {
    const styles = useStyles2(getStyles$n);
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
      List,
      {
        className: styles.list,
        items: suggestions,
        renderItem: (item, index) => {
          const isActive = index + activeIndexOffset === activeIndex;
          return (
            // key events are handled by DataLinkInput
            // eslint-disable-next-line jsx-a11y/click-events-have-key-events
            /* @__PURE__ */ React__default["default"].createElement(
              "div",
              {
                role: "menuitem",
                tabIndex: 0,
                className: css.cx(styles.item, isActive && styles.activeItem),
                ref: isActive ? selectedRef : void 0,
                onClick: () => {
                  onSuggestionSelect(item);
                },
                title: item.documentation
              },
              /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.itemValue }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.label }, label), " ", item.label)
            )
          );
        }
      }
    ));
  }
);
DataLinkSuggestionsList.displayName = "DataLinkSuggestionsList";

class SelectionReference {
  getBoundingClientRect() {
    const selection = window.getSelection();
    const node = selection && selection.anchorNode;
    if (node && node.parentElement) {
      const rect = node.parentElement.getBoundingClientRect();
      return rect;
    }
    const fallbackDOMRect = {
      top: 0,
      left: 0,
      bottom: 0,
      right: 0,
      width: 0,
      height: 0,
      x: 0,
      y: 0,
      toJSON: () => {
      }
    };
    return fallbackDOMRect;
  }
  get clientWidth() {
    return this.getBoundingClientRect().width;
  }
  get clientHeight() {
    return this.getBoundingClientRect().height;
  }
}

var __defProp$N = Object.defineProperty;
var __defProps$x = Object.defineProperties;
var __getOwnPropDescs$x = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$O = Object.getOwnPropertySymbols;
var __hasOwnProp$O = Object.prototype.hasOwnProperty;
var __propIsEnum$O = Object.prototype.propertyIsEnumerable;
var __defNormalProp$N = (obj, key, value) => key in obj ? __defProp$N(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$N = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$O.call(b, prop))
      __defNormalProp$N(a, prop, b[prop]);
  if (__getOwnPropSymbols$O)
    for (var prop of __getOwnPropSymbols$O(b)) {
      if (__propIsEnum$O.call(b, prop))
        __defNormalProp$N(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$x = (a, b) => __defProps$x(a, __getOwnPropDescs$x(b));
const modulo = (a, n) => a - n * Math.floor(a / n);
const datalinksSyntax = {
  builtInVariable: {
    pattern: /(\${\S+?})/
  }
};
const plugins = [
  SlatePrism(
    {
      onlyIn: (node) => node.type === "code_block",
      getSyntax: () => "links"
    },
    __spreadProps$x(__spreadValues$N({}, Prism__default["default"].languages), { links: datalinksSyntax })
  )
];
const getStyles$m = (theme) => ({
  input: getInputStyles({ theme, invalid: false }).input,
  editor: css.css`
    .token.builtInVariable {
      color: ${theme.colors.success.text};
    }
    .token.variable {
      color: ${theme.colors.primary.text};
    }
  `,
  suggestionsWrapper: css.css`
    box-shadow: ${theme.shadows.z2};
  `,
  // Wrapper with child selector needed.
  // When classnames are applied to the same element as the wrapper, it causes the suggestions to stop working
  wrapperOverrides: css.css`
    width: 100%;
    > .slate-query-field__wrapper {
      padding: 0;
      background-color: transparent;
      border: none;
    }
  `
});
const DataLinkInput = React.memo(
  ({
    value,
    onChange,
    suggestions,
    placeholder = "http://your-grafana.com/d/000000010/annotations"
  }) => {
    const editorRef = React.useRef(null);
    const styles = useStyles2(getStyles$m);
    const [showingSuggestions, setShowingSuggestions] = React.useState(false);
    const [suggestionsIndex, setSuggestionsIndex] = React.useState(0);
    const [linkUrl, setLinkUrl] = React.useState(makeValue(value));
    const prevLinkUrl = usePrevious__default["default"](linkUrl);
    const [scrollTop, setScrollTop] = React.useState(0);
    const stateRef = React.useRef({ showingSuggestions, suggestions, suggestionsIndex, linkUrl, onChange });
    stateRef.current = { showingSuggestions, suggestions, suggestionsIndex, linkUrl, onChange };
    const activeRef = React.useRef(null);
    React.useEffect(() => {
      setScrollTop(getElementPosition(activeRef.current, suggestionsIndex));
    }, [suggestionsIndex]);
    const selectionRef = React.useMemo(() => new SelectionReference(), []);
    const onKeyDown = React__default["default"].useCallback((event, next) => {
      if (!stateRef.current.showingSuggestions) {
        if (event.key === "=" || event.key === "$" || event.keyCode === 32 && event.ctrlKey) {
          return setShowingSuggestions(true);
        }
        return next();
      }
      switch (event.key) {
        case "Backspace":
        case "Escape":
          setShowingSuggestions(false);
          return setSuggestionsIndex(0);
        case "Enter":
          event.preventDefault();
          return onVariableSelect(stateRef.current.suggestions[stateRef.current.suggestionsIndex]);
        case "ArrowDown":
        case "ArrowUp":
          event.preventDefault();
          const direction = event.key === "ArrowDown" ? 1 : -1;
          return setSuggestionsIndex((index) => modulo(index + direction, stateRef.current.suggestions.length));
        default:
          return next();
      }
    }, []);
    React.useEffect(() => {
      if (prevLinkUrl && prevLinkUrl.selection.isFocused && !linkUrl.selection.isFocused) {
        stateRef.current.onChange(Plain__default["default"].serialize(linkUrl));
      }
    }, [linkUrl, prevLinkUrl]);
    const onUrlChange = React__default["default"].useCallback(({ value: value2 }) => {
      setLinkUrl(value2);
    }, []);
    const onVariableSelect = (item, editor = editorRef.current) => {
      const precedingChar = getCharactersAroundCaret();
      const precedingDollar = precedingChar === "$";
      if (item.origin !== data.VariableOrigin.Template || item.value === data.DataLinkBuiltInVars.includeVars) {
        editor.insertText(`${precedingDollar ? "" : "$"}{${item.value}}`);
      } else {
        editor.insertText(`${precedingDollar ? "" : "$"}{${item.value}:queryparam}`);
      }
      setLinkUrl(editor.value);
      setShowingSuggestions(false);
      setSuggestionsIndex(0);
      stateRef.current.onChange(Plain__default["default"].serialize(editor.value));
    };
    const getCharactersAroundCaret = () => {
      const input = document.getElementById("data-link-input");
      let precedingChar = "", sel, range;
      if (window.getSelection) {
        sel = window.getSelection();
        if (sel && sel.rangeCount > 0) {
          range = sel.getRangeAt(0).cloneRange();
          range.collapse(true);
          range.setStart(input, 0);
          precedingChar = range.toString().slice(-1);
        }
      }
      return precedingChar;
    };
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapperOverrides }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "slate-query-field__wrapper" }, /* @__PURE__ */ React__default["default"].createElement("div", { id: "data-link-input", className: "slate-query-field" }, showingSuggestions && /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(
      reactPopper.Popper,
      {
        referenceElement: selectionRef,
        placement: "bottom-end",
        modifiers: [
          {
            name: "preventOverflow",
            enabled: true,
            options: {
              rootBoundary: "viewport"
            }
          },
          {
            name: "arrow",
            enabled: false
          },
          {
            name: "offset",
            options: {
              offset: [250, 0]
            }
          }
        ]
      },
      ({ ref, style, placement }) => {
        return /* @__PURE__ */ React__default["default"].createElement("div", { ref, style, "data-placement": placement, className: styles.suggestionsWrapper }, /* @__PURE__ */ React__default["default"].createElement(
          CustomScrollbar,
          {
            scrollTop,
            autoHeightMax: "300px",
            setScrollTop: ({ scrollTop: scrollTop2 }) => setScrollTop(scrollTop2)
          },
          /* @__PURE__ */ React__default["default"].createElement(
            DataLinkSuggestions,
            {
              activeRef,
              suggestions: stateRef.current.suggestions,
              onSuggestionSelect: onVariableSelect,
              onClose: () => setShowingSuggestions(false),
              activeIndex: suggestionsIndex
            }
          )
        ));
      }
    )), /* @__PURE__ */ React__default["default"].createElement(
      slateReact.Editor,
      {
        schema: SCHEMA,
        ref: editorRef,
        placeholder,
        value: stateRef.current.linkUrl,
        onChange: onUrlChange,
        onKeyDown: (event, _editor, next) => onKeyDown(event, next),
        plugins,
        className: css.cx(
          styles.editor,
          styles.input,
          css.css`
                  padding: 3px 8px;
                `
        )
      }
    ))));
  }
);
DataLinkInput.displayName = "DataLinkInput";
function getElementPosition(suggestionElement, activeIndex) {
  var _a;
  return ((_a = suggestionElement == null ? void 0 : suggestionElement.clientHeight) != null ? _a : 0) * activeIndex;
}

var __defProp$M = Object.defineProperty;
var __defProps$w = Object.defineProperties;
var __getOwnPropDescs$w = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$N = Object.getOwnPropertySymbols;
var __hasOwnProp$N = Object.prototype.hasOwnProperty;
var __propIsEnum$N = Object.prototype.propertyIsEnumerable;
var __defNormalProp$M = (obj, key, value) => key in obj ? __defProp$M(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$M = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$N.call(b, prop))
      __defNormalProp$M(a, prop, b[prop]);
  if (__getOwnPropSymbols$N)
    for (var prop of __getOwnPropSymbols$N(b)) {
      if (__propIsEnum$N.call(b, prop))
        __defNormalProp$M(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$w = (a, b) => __defProps$w(a, __getOwnPropDescs$w(b));
const getStyles$l = (theme) => ({
  listItem: css.css`
    margin-bottom: ${theme.spacing()};
  `,
  infoText: css.css`
    padding-bottom: ${theme.spacing(2)};
    margin-left: 66px;
    color: ${theme.colors.text.secondary};
  `
});
const DataLinkEditor = React__default["default"].memo(({ index, value, onChange, suggestions, isLast }) => {
  const styles = useStyles2(getStyles$l);
  const onUrlChange = (url, callback) => {
    onChange(index, __spreadProps$w(__spreadValues$M({}, value), { url }), callback);
  };
  const onTitleChange = (event) => {
    onChange(index, __spreadProps$w(__spreadValues$M({}, value), { title: event.target.value }));
  };
  const onOpenInNewTabChanged = () => {
    onChange(index, __spreadProps$w(__spreadValues$M({}, value), { targetBlank: !value.targetBlank }));
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.listItem }, /* @__PURE__ */ React__default["default"].createElement(Field, { label: "Title" }, /* @__PURE__ */ React__default["default"].createElement(Input, { value: value.title, onChange: onTitleChange, placeholder: "Show details" })), /* @__PURE__ */ React__default["default"].createElement(
    Field,
    {
      label: "URL",
      invalid: isCompactUrl(value.url),
      error: "Data link is an Explore URL in a deprecated format. Please visit the URL to be redirected, and edit this data link to use that URL."
    },
    /* @__PURE__ */ React__default["default"].createElement(DataLinkInput, { value: value.url, onChange: onUrlChange, suggestions })
  ), /* @__PURE__ */ React__default["default"].createElement(Field, { label: "Open in new tab" }, /* @__PURE__ */ React__default["default"].createElement(Switch, { value: value.targetBlank || false, onChange: onOpenInNewTabChanged })), isLast && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.infoText }, "With data links you can reference data variables like series name, labels and values. Type CMD+Space, CTRL+Space, or $ to open variable suggestions."));
});
DataLinkEditor.displayName = "DataLinkEditor";

const DataLinkEditorModalContent = ({
  link,
  index,
  getSuggestions,
  onSave,
  onCancel
}) => {
  const [dirtyLink, setDirtyLink] = React.useState(link);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
    DataLinkEditor,
    {
      value: dirtyLink,
      index,
      isLast: false,
      suggestions: getSuggestions(),
      onChange: (index2, link2) => {
        setDirtyLink(link2);
      }
    }
  ), /* @__PURE__ */ React__default["default"].createElement(Modal.ButtonRow, null, /* @__PURE__ */ React__default["default"].createElement(Button, { variant: "secondary", onClick: () => onCancel(index), fill: "outline" }, "Cancel"), /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      onClick: () => {
        onSave(index, dirtyLink);
      }
    },
    "Save"
  )));
};

const DataLinksListItem = ({ link, onEdit, onRemove }) => {
  const theme = useTheme2();
  const styles = getDataLinkListItemStyles(theme);
  const { title = "", url = "" } = link;
  const hasTitle = title.trim() !== "";
  const hasUrl = url.trim() !== "";
  const isCompactExploreUrl = isCompactUrl(url);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.titleWrapper }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.url, !hasUrl && styles.notConfigured, isCompactExploreUrl && styles.errored) }, hasTitle ? title : "Data link title not provided"), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.actionButtons }, /* @__PURE__ */ React__default["default"].createElement(IconButton, { name: "pen", onClick: onEdit }), /* @__PURE__ */ React__default["default"].createElement(IconButton, { name: "times", onClick: onRemove }))), /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.url, !hasUrl && styles.notConfigured, isCompactExploreUrl && styles.errored),
      title: url
    },
    hasUrl ? url : "Data link url not provided"
  ), isCompactExploreUrl && /* @__PURE__ */ React__default["default"].createElement(FieldValidationMessage, null, "Explore data link may not work in the future. Please edit."));
};
const getDataLinkListItemStyles = stylesFactory((theme) => {
  return {
    wrapper: css.css`
      margin-bottom: ${theme.spacing(2)};
      width: 100%;
      &:last-child {
        margin-bottom: 0;
      }
      display: flex;
      flex-direction: column;
    `,
    titleWrapper: css.css`
      label: data-links-list-item-title;
      justify-content: space-between;
      display: flex;
      width: 100%;
      align-items: center;
    `,
    actionButtons: css.css`
      margin-left: ${theme.spacing(1)};
      display: flex;
    `,
    errored: css.css`
      color: ${theme.colors.error.text};
      font-style: italic;
    `,
    notConfigured: css.css`
      font-style: italic;
    `,
    title: css.css`
      color: ${theme.colors.text.primary};
      font-size: ${theme.typography.size.sm};
      font-weight: ${theme.typography.fontWeightMedium};
    `,
    url: css.css`
      color: ${theme.colors.text.secondary};
      font-size: ${theme.typography.size.sm};
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      max-width: 90%;
    `
  };
});

const DataLinksInlineEditor = ({ links, onChange, getSuggestions, data }) => {
  const theme = useTheme2();
  const [editIndex, setEditIndex] = React.useState(null);
  const [isNew, setIsNew] = React.useState(false);
  const styles = getDataLinksInlineEditorStyles(theme);
  const linksSafe = links != null ? links : [];
  const isEditing = editIndex !== null;
  const onDataLinkChange = (index, link) => {
    if (isNew) {
      if (link.title.trim() === "" && link.url.trim() === "") {
        setIsNew(false);
        setEditIndex(null);
        return;
      } else {
        setEditIndex(null);
        setIsNew(false);
      }
    }
    const update = lodash.cloneDeep(linksSafe);
    update[index] = link;
    onChange(update);
    setEditIndex(null);
  };
  const onDataLinkAdd = () => {
    let update = lodash.cloneDeep(linksSafe);
    setEditIndex(update.length);
    setIsNew(true);
  };
  const onDataLinkCancel = (index) => {
    if (isNew) {
      setIsNew(false);
    }
    setEditIndex(null);
  };
  const onDataLinkRemove = (index) => {
    const update = lodash.cloneDeep(linksSafe);
    update.splice(index, 1);
    onChange(update);
  };
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, linksSafe.length > 0 && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, linksSafe.map((l, i) => {
    return /* @__PURE__ */ React__default["default"].createElement(
      DataLinksListItem,
      {
        key: `${l.title}/${i}`,
        index: i,
        link: l,
        onChange: onDataLinkChange,
        onEdit: () => setEditIndex(i),
        onRemove: () => onDataLinkRemove(i),
        data
      }
    );
  })), isEditing && editIndex !== null && /* @__PURE__ */ React__default["default"].createElement(
    Modal,
    {
      title: "Edit link",
      isOpen: true,
      closeOnBackdropClick: false,
      onDismiss: () => {
        onDataLinkCancel();
      }
    },
    /* @__PURE__ */ React__default["default"].createElement(
      DataLinkEditorModalContent,
      {
        index: editIndex,
        link: isNew ? { title: "", url: "" } : linksSafe[editIndex],
        data,
        onSave: onDataLinkChange,
        onCancel: onDataLinkCancel,
        getSuggestions
      }
    )
  ), /* @__PURE__ */ React__default["default"].createElement(Button, { size: "sm", icon: "plus", onClick: onDataLinkAdd, variant: "secondary" }, "Add link"));
};
const getDataLinksInlineEditorStyles = stylesFactory((theme) => {
  return {
    wrapper: css.css`
      margin-bottom: ${theme.spacing(2)};
    `
  };
});

var __defProp$L = Object.defineProperty;
var __defProps$v = Object.defineProperties;
var __getOwnPropDescs$v = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$M = Object.getOwnPropertySymbols;
var __hasOwnProp$M = Object.prototype.hasOwnProperty;
var __propIsEnum$M = Object.prototype.propertyIsEnumerable;
var __defNormalProp$L = (obj, key, value) => key in obj ? __defProp$L(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$L = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$M.call(b, prop))
      __defNormalProp$L(a, prop, b[prop]);
  if (__getOwnPropSymbols$M)
    for (var prop of __getOwnPropSymbols$M(b)) {
      if (__propIsEnum$M.call(b, prop))
        __defNormalProp$L(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$v = (a, b) => __defProps$v(a, __getOwnPropDescs$v(b));
var __objRest$s = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$M.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$M)
    for (var prop of __getOwnPropSymbols$M(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$M.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const InfoBox = React__default["default"].memo(
  React__default["default"].forwardRef(
    (_a, ref) => {
      var _b = _a, { title, className, children, branded, url, urlTitle, onDismiss, severity = "info" } = _b, otherProps = __objRest$s(_b, ["title", "className", "children", "branded", "url", "urlTitle", "onDismiss", "severity"]);
      const styles = useStyles2(getStyles$k);
      return /* @__PURE__ */ React__default["default"].createElement(Alert, __spreadProps$v(__spreadValues$L({ severity, className }, otherProps), { ref, title }), /* @__PURE__ */ React__default["default"].createElement("div", null, children), url && /* @__PURE__ */ React__default["default"].createElement("a", { href: url, className: css.cx("external-link", styles.docsLink), target: "_blank", rel: "noreferrer" }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "book" }), " ", urlTitle || "Read more"));
    }
  )
);
InfoBox.displayName = "InfoBox";
const getStyles$k = stylesFactory((theme) => {
  return {
    docsLink: css.css`
      display: inline-block;
      margin-top: ${theme.spacing(2)};
    `
  };
});

var __defProp$K = Object.defineProperty;
var __getOwnPropSymbols$L = Object.getOwnPropertySymbols;
var __hasOwnProp$L = Object.prototype.hasOwnProperty;
var __propIsEnum$L = Object.prototype.propertyIsEnumerable;
var __defNormalProp$K = (obj, key, value) => key in obj ? __defProp$K(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$K = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$L.call(b, prop))
      __defNormalProp$K(a, prop, b[prop]);
  if (__getOwnPropSymbols$L)
    for (var prop of __getOwnPropSymbols$L(b)) {
      if (__propIsEnum$L.call(b, prop))
        __defNormalProp$K(a, prop, b[prop]);
    }
  return a;
};
var __objRest$r = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$L.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$L)
    for (var prop of __getOwnPropSymbols$L(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$L.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Badge = React__default["default"].memo((_a) => {
  var _b = _a, { icon, color, text, tooltip, className } = _b, otherProps = __objRest$r(_b, ["icon", "color", "text", "tooltip", "className"]);
  const styles = useStyles2(React.useCallback((theme) => getStyles$j(theme, color), [color]));
  const badge = /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$K({ className: css.cx(styles.wrapper, className) }, otherProps), /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { align: "center", spacing: "xs" }, icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size: "sm" }), /* @__PURE__ */ React__default["default"].createElement("span", null, text)));
  return tooltip ? /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: tooltip, placement: "auto" }, badge) : badge;
});
Badge.displayName = "Badge";
const getStyles$j = (theme, color) => {
  let sourceColor = theme.visualization.getColorByName(color);
  let borderColor = "";
  let bgColor = "";
  let textColor = "";
  if (theme.isDark) {
    bgColor = tinycolor__default["default"](sourceColor).setAlpha(0.15).toString();
    borderColor = tinycolor__default["default"](sourceColor).darken(30).toString();
    textColor = tinycolor__default["default"](sourceColor).lighten(15).toString();
  } else {
    bgColor = tinycolor__default["default"](sourceColor).setAlpha(0.15).toString();
    borderColor = tinycolor__default["default"](sourceColor).lighten(20).toString();
    textColor = tinycolor__default["default"](sourceColor).darken(20).toString();
  }
  return {
    wrapper: css.css`
      font-size: ${theme.typography.size.sm};
      display: inline-flex;
      padding: 1px 4px;
      border-radius: ${theme.shape.radius.default};
      background: ${bgColor};
      border: 1px solid ${borderColor};
      color: ${textColor};
      font-weight: ${theme.typography.fontWeightRegular};

      > span {
        position: relative;
        top: 1px;
        margin-left: 2px;
      }
    `
  };
};

var __defProp$J = Object.defineProperty;
var __getOwnPropSymbols$K = Object.getOwnPropertySymbols;
var __hasOwnProp$K = Object.prototype.hasOwnProperty;
var __propIsEnum$K = Object.prototype.propertyIsEnumerable;
var __defNormalProp$J = (obj, key, value) => key in obj ? __defProp$J(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$J = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$K.call(b, prop))
      __defNormalProp$J(a, prop, b[prop]);
  if (__getOwnPropSymbols$K)
    for (var prop of __getOwnPropSymbols$K(b)) {
      if (__propIsEnum$K.call(b, prop))
        __defNormalProp$J(a, prop, b[prop]);
    }
  return a;
};
var __objRest$q = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$K.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$K)
    for (var prop of __getOwnPropSymbols$K(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$K.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const FeatureInfoBox = React__default["default"].memo(
  React__default["default"].forwardRef((_a, ref) => {
    var _b = _a, { title, featureState } = _b, otherProps = __objRest$q(_b, ["title", "featureState"]);
    const styles = useStyles2(getFeatureInfoBoxStyles);
    const titleEl = featureState ? /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.badge }, /* @__PURE__ */ React__default["default"].createElement(FeatureBadge, { featureState })), /* @__PURE__ */ React__default["default"].createElement("h3", null, title)) : /* @__PURE__ */ React__default["default"].createElement("h3", null, title);
    return /* @__PURE__ */ React__default["default"].createElement(InfoBox, __spreadValues$J({ branded: true, title: titleEl, urlTitle: "Read documentation", ref }, otherProps));
  })
);
FeatureInfoBox.displayName = "FeatureInfoBox";
const getFeatureInfoBoxStyles = (theme) => {
  return {
    badge: css.css`
      margin-bottom: ${theme.spacing(1)};
    `
  };
};
const FeatureBadge = ({ featureState, tooltip }) => {
  const display = getPanelStateBadgeDisplayModel(featureState);
  return /* @__PURE__ */ React__default["default"].createElement(Badge, { text: display.text, color: display.color, icon: display.icon, tooltip });
};
function getPanelStateBadgeDisplayModel(featureState) {
  switch (featureState) {
    case data.FeatureState.alpha:
      return {
        text: "Alpha",
        icon: "exclamation-triangle",
        color: "orange"
      };
  }
  return {
    text: "Beta",
    icon: "rocket",
    color: "blue"
  };
}

function formatString(str) {
  return str.replace(/\\/g, "\\\\").replace(/"/g, '\\"');
}
function isObject(value2) {
  const type = typeof value2;
  return !!value2 && type === "object";
}
function getObjectName(object) {
  if (object === void 0) {
    return "";
  }
  if (object === null) {
    return "Object";
  }
  if (typeof object === "object" && !object.constructor) {
    return "Object";
  }
  const funcNameRegex = /function ([^(]*)/;
  const results = funcNameRegex.exec(object.constructor.toString());
  if (results && results.length > 1) {
    return results[1];
  } else {
    return "";
  }
}
function getType(object) {
  if (object === null) {
    return "null";
  }
  return typeof object;
}
function getValuePreview(object, value2) {
  const type = getType(object);
  if (type === "null" || type === "undefined") {
    return type;
  }
  if (type === "string") {
    value2 = '"' + formatString(value2) + '"';
  }
  if (type === "function") {
    return object.toString().replace(/[\r\n]/g, "").replace(/\{.*\}/, "") + "{\u2026}";
  }
  return value2;
}
function cssClass(className) {
  return `json-formatter-${className}`;
}
function createElement(type, className, content) {
  const el = document.createElement(type);
  if (className) {
    el.classList.add(cssClass(className));
  }
  if (content !== void 0) {
    if (content instanceof Node) {
      el.appendChild(content);
    } else {
      el.appendChild(document.createTextNode(String(content)));
    }
  }
  return el;
}

const DATE_STRING_REGEX = /(^\d{1,4}[\.|\\/|-]\d{1,2}[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;
const PARTIAL_DATE_REGEX = /\d{2}:\d{2}:\d{2} GMT-\d{4}/;
const JSON_DATE_REGEX = /\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/;
const MAX_ANIMATED_TOGGLE_ITEMS = 10;
const requestAnimationFrame$1 = typeof window !== "undefined" && window.requestAnimationFrame || ((cb) => {
  cb();
  return 0;
});
const _defaultConfig = {
  animateOpen: true,
  animateClose: true
};
class JsonExplorer {
  /**
   * @param {object} json The JSON object you want to render. It has to be an
   * object or array. Do NOT pass raw JSON string.
   *
   * @param {number} [open=1] his number indicates up to how many levels the
   * rendered tree should expand. Set it to `0` to make the whole tree collapsed
   * or set it to `Infinity` to expand the tree deeply
   *
   * @param {object} [config=defaultConfig] -
   *  defaultConfig = {
   *   hoverPreviewEnabled: false,
   *   hoverPreviewArrayCount: 100,
   *   hoverPreviewFieldCount: 5
   * }
   *
   * Available configurations:
   *  #####Hover Preview
   * * `hoverPreviewEnabled`:  enable preview on hover
   * * `hoverPreviewArrayCount`: number of array items to show in preview Any
   *    array larger than this number will be shown as `Array[XXX]` where `XXX`
   *    is length of the array.
   * * `hoverPreviewFieldCount`: number of object properties to show for object
   *   preview. Any object with more properties that thin number will be
   *   truncated.
   *
   * @param {string} [key=undefined] The key that this object in its parent
   * context
   */
  constructor(json, open = 1, config = _defaultConfig, key) {
    this.json = json;
    this.open = open;
    this.config = config;
    this.key = key;
    // Hold the open state after the toggler is used
    this._isOpen = null;
    // A reference to the element that we render to
    this.element = null;
    this.skipChildren = false;
  }
  /*
   * is formatter open?
   */
  get isOpen() {
    if (this._isOpen !== null) {
      return this._isOpen;
    } else {
      return this.open > 0;
    }
  }
  /*
   * set open state (from toggler)
   */
  set isOpen(value) {
    this._isOpen = value;
  }
  /*
   * is this a date string?
   */
  get isDate() {
    return this.type === "string" && (DATE_STRING_REGEX.test(this.json) || JSON_DATE_REGEX.test(this.json) || PARTIAL_DATE_REGEX.test(this.json));
  }
  /*
   * is this a URL string?
   */
  get isUrl() {
    return this.type === "string" && this.json.indexOf("http") === 0;
  }
  /*
   * is this an array?
   */
  get isArray() {
    return Array.isArray(this.json);
  }
  /*
   * is this an object?
   * Note: In this context arrays are object as well
   */
  get isObject() {
    return isObject(this.json);
  }
  /*
   * is this an empty object with no properties?
   */
  get isEmptyObject() {
    return !this.keys.length && !this.isArray;
  }
  /*
   * is this an empty object or array?
   */
  get isEmpty() {
    return this.isEmptyObject || this.keys && !this.keys.length && this.isArray;
  }
  /*
   * did we receive a key argument?
   * This means that the formatter was called as a sub formatter of a parent formatter
   */
  get hasKey() {
    return typeof this.key !== "undefined";
  }
  /*
   * if this is an object, get constructor function name
   */
  get constructorName() {
    return getObjectName(this.json);
  }
  /*
   * get type of this value
   * Possible values: all JavaScript primitive types plus "array" and "null"
   */
  get type() {
    return getType(this.json);
  }
  /*
   * get object keys
   * If there is an empty key we pad it wit quotes to make it visible
   */
  get keys() {
    if (this.isObject) {
      return Object.keys(this.json).map((key) => key ? key : '""');
    } else {
      return [];
    }
  }
  /**
   * Toggles `isOpen` state
   *
   */
  toggleOpen() {
    this.isOpen = !this.isOpen;
    if (this.element) {
      if (this.isOpen) {
        this.appendChildren(this.config.animateOpen);
      } else {
        this.removeChildren(this.config.animateClose);
      }
      this.element.classList.toggle(cssClass("open"));
    }
  }
  /**
   * Open all children up to a certain depth.
   * Allows actions such as expand all/collapse all
   *
   */
  openAtDepth(depth = 1) {
    if (depth < 0) {
      return;
    }
    this.open = depth;
    this.isOpen = depth !== 0;
    if (this.element) {
      this.removeChildren(false);
      if (depth === 0) {
        this.element.classList.remove(cssClass("open"));
      } else {
        this.appendChildren(this.config.animateOpen);
        this.element.classList.add(cssClass("open"));
      }
    }
  }
  isNumberArray() {
    return this.json.length > 0 && this.json.length < 4 && (lodash.isNumber(this.json[0]) || lodash.isNumber(this.json[1]));
  }
  renderArray() {
    const arrayWrapperSpan = createElement("span");
    arrayWrapperSpan.appendChild(createElement("span", "bracket", "["));
    if (this.isNumberArray()) {
      this.json.forEach((val, index) => {
        if (index > 0) {
          arrayWrapperSpan.appendChild(createElement("span", "array-comma", ","));
        }
        arrayWrapperSpan.appendChild(createElement("span", "number", val));
      });
      this.skipChildren = true;
    } else {
      arrayWrapperSpan.appendChild(createElement("span", "number", this.json.length));
    }
    arrayWrapperSpan.appendChild(createElement("span", "bracket", "]"));
    return arrayWrapperSpan;
  }
  /**
   * Renders an HTML element and installs event listeners
   *
   * @returns {HTMLDivElement}
   */
  render(skipRoot = false) {
    this.element = createElement("div", "row");
    const togglerLink = createElement("a", "toggler-link");
    const togglerIcon = createElement("span", "toggler");
    if (this.isObject) {
      togglerLink.appendChild(togglerIcon);
    }
    if (this.hasKey) {
      togglerLink.appendChild(createElement("span", "key", `${this.key}:`));
    }
    if (this.isObject) {
      const value = createElement("span", "value");
      const objectWrapperSpan = createElement("span");
      const constructorName = createElement("span", "constructor-name", this.constructorName);
      objectWrapperSpan.appendChild(constructorName);
      if (this.isArray) {
        const arrayWrapperSpan = this.renderArray();
        objectWrapperSpan.appendChild(arrayWrapperSpan);
      }
      value.appendChild(objectWrapperSpan);
      togglerLink.appendChild(value);
    } else {
      const value = this.isUrl ? createElement("a") : createElement("span");
      value.classList.add(cssClass(this.type));
      if (this.isDate) {
        value.classList.add(cssClass("date"));
      }
      if (this.isUrl) {
        value.classList.add(cssClass("url"));
        value.setAttribute("href", this.json);
      }
      const valuePreview = getValuePreview(this.json, this.json);
      value.appendChild(document.createTextNode(valuePreview));
      togglerLink.appendChild(value);
    }
    const children = createElement("div", "children");
    if (this.isObject) {
      children.classList.add(cssClass("object"));
    }
    if (this.isArray) {
      children.classList.add(cssClass("array"));
    }
    if (this.isEmpty) {
      children.classList.add(cssClass("empty"));
    }
    if (this.config && this.config.theme) {
      this.element.classList.add(cssClass(this.config.theme));
    }
    if (this.isOpen) {
      this.element.classList.add(cssClass("open"));
    }
    if (!skipRoot) {
      this.element.appendChild(togglerLink);
    }
    if (!this.skipChildren) {
      this.element.appendChild(children);
    } else {
      togglerLink.removeChild(togglerIcon);
    }
    if (this.isObject && this.isOpen) {
      this.appendChildren();
    }
    if (this.isObject) {
      togglerLink.addEventListener("click", this.toggleOpen.bind(this));
    }
    return this.element;
  }
  /**
   * Appends all the children to children element
   * Animated option is used when user triggers this via a click
   */
  appendChildren(animated = false) {
    const children = this.element && this.element.querySelector(`div.${cssClass("children")}`);
    if (!children || this.isEmpty) {
      return;
    }
    if (animated) {
      let index = 0;
      const addAChild = () => {
        const key = this.keys[index];
        const formatter = new JsonExplorer(this.json[key], this.open - 1, this.config, key);
        children.appendChild(formatter.render());
        index += 1;
        if (index < this.keys.length) {
          if (index > MAX_ANIMATED_TOGGLE_ITEMS) {
            addAChild();
          } else {
            requestAnimationFrame$1(addAChild);
          }
        }
      };
      requestAnimationFrame$1(addAChild);
    } else {
      this.keys.forEach((key) => {
        const formatter = new JsonExplorer(this.json[key], this.open - 1, this.config, key);
        children.appendChild(formatter.render());
      });
    }
  }
  /**
   * Removes all the children from children element
   * Animated option is used when user triggers this via a click
   */
  removeChildren(animated = false) {
    const childrenElement = this.element && this.element.querySelector(`div.${cssClass("children")}`);
    if (animated) {
      let childrenRemoved = 0;
      const removeAChild = () => {
        if (childrenElement && childrenElement.children.length) {
          childrenElement.removeChild(childrenElement.children[0]);
          childrenRemoved += 1;
          if (childrenRemoved > MAX_ANIMATED_TOGGLE_ITEMS) {
            removeAChild();
          } else {
            requestAnimationFrame$1(removeAChild);
          }
        }
      };
      requestAnimationFrame$1(removeAChild);
    } else {
      if (childrenElement) {
        childrenElement.innerHTML = "";
      }
    }
  }
}

class JSONFormatter extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.wrapperRef = React.createRef();
    this.renderJson = () => {
      const { json, config, open, onDidRender } = this.props;
      const wrapperEl = this.wrapperRef.current;
      const formatter = new JsonExplorer(json, open, config);
      const hasChildren = wrapperEl.hasChildNodes();
      if (hasChildren) {
        wrapperEl.replaceChild(formatter.render(), wrapperEl.lastChild);
      } else {
        wrapperEl.appendChild(formatter.render());
      }
      if (onDidRender) {
        onDidRender(formatter.json);
      }
    };
  }
  componentDidMount() {
    this.renderJson();
  }
  componentDidUpdate() {
    this.renderJson();
  }
  render() {
    const { className } = this.props;
    return /* @__PURE__ */ React__default["default"].createElement("div", { className, ref: this.wrapperRef });
  }
}
JSONFormatter.defaultProps = {
  open: 3,
  config: {
    animateOpen: true
  }
};

const getStyles$i = stylesFactory(() => {
  return css.css`
    width: 500px;
    margin: 64px auto;
  `;
});
const ErrorWithStack = ({ error, errorInfo, title }) => /* @__PURE__ */ React__default["default"].createElement("div", { className: getStyles$i() }, /* @__PURE__ */ React__default["default"].createElement("h2", null, title), /* @__PURE__ */ React__default["default"].createElement("details", { style: { whiteSpace: "pre-wrap" } }, error && error.toString(), /* @__PURE__ */ React__default["default"].createElement("br", null), errorInfo && errorInfo.componentStack));
ErrorWithStack.displayName = "ErrorWithStack";

var __defProp$I = Object.defineProperty;
var __getOwnPropSymbols$J = Object.getOwnPropertySymbols;
var __hasOwnProp$J = Object.prototype.hasOwnProperty;
var __propIsEnum$J = Object.prototype.propertyIsEnumerable;
var __defNormalProp$I = (obj, key, value) => key in obj ? __defProp$I(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$I = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$J.call(b, prop))
      __defNormalProp$I(a, prop, b[prop]);
  if (__getOwnPropSymbols$J)
    for (var prop of __getOwnPropSymbols$J(b)) {
      if (__propIsEnum$J.call(b, prop))
        __defNormalProp$I(a, prop, b[prop]);
    }
  return a;
};
class ErrorBoundary extends React.PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      error: null,
      errorInfo: null
    };
  }
  componentDidCatch(error, errorInfo) {
    var _a, _b;
    browser.captureException(error, { contexts: { react: { componentStack: errorInfo.componentStack } } });
    (_b = (_a = faroWebSdk.faro) == null ? void 0 : _a.api) == null ? void 0 : _b.pushError(error);
    this.setState({ error, errorInfo });
    if (this.props.onError) {
      this.props.onError(error);
    }
  }
  componentDidUpdate(prevProps) {
    const { dependencies, onRecover } = this.props;
    if (this.state.error) {
      if (dependencies && prevProps.dependencies) {
        for (let i = 0; i < dependencies.length; i++) {
          if (dependencies[i] !== prevProps.dependencies[i]) {
            this.setState({ error: null, errorInfo: null });
            if (onRecover) {
              onRecover();
            }
            break;
          }
        }
      }
    }
  }
  render() {
    const { children } = this.props;
    const { error, errorInfo } = this.state;
    return children({
      error,
      errorInfo
    });
  }
}
class ErrorBoundaryAlert extends React.PureComponent {
  render() {
    const { title, children, style, dependencies } = this.props;
    return /* @__PURE__ */ React__default["default"].createElement(ErrorBoundary, { dependencies }, ({ error, errorInfo }) => {
      if (!errorInfo) {
        return children;
      }
      if (style === "alertbox") {
        return /* @__PURE__ */ React__default["default"].createElement(Alert, { title: title || "" }, /* @__PURE__ */ React__default["default"].createElement("details", { style: { whiteSpace: "pre-wrap" } }, error && error.toString(), /* @__PURE__ */ React__default["default"].createElement("br", null), errorInfo.componentStack));
      }
      return /* @__PURE__ */ React__default["default"].createElement(ErrorWithStack, { title: title || "", error, errorInfo });
    });
  }
}
ErrorBoundaryAlert.defaultProps = {
  title: "An unexpected error happened",
  style: "alertbox"
};
function withErrorBoundary(Component, errorBoundaryProps = {}) {
  const comp = (props) => /* @__PURE__ */ React__default["default"].createElement(ErrorBoundaryAlert, __spreadValues$I({}, errorBoundaryProps), /* @__PURE__ */ React__default["default"].createElement(Component, __spreadValues$I({}, props)));
  comp.displayName = "WithErrorBoundary";
  return comp;
}

var __defProp$H = Object.defineProperty;
var __getOwnPropSymbols$I = Object.getOwnPropertySymbols;
var __hasOwnProp$I = Object.prototype.hasOwnProperty;
var __propIsEnum$I = Object.prototype.propertyIsEnumerable;
var __defNormalProp$H = (obj, key, value) => key in obj ? __defProp$H(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$H = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$I.call(b, prop))
      __defNormalProp$H(a, prop, b[prop]);
  if (__getOwnPropSymbols$I)
    for (var prop of __getOwnPropSymbols$I(b)) {
      if (__propIsEnum$I.call(b, prop))
        __defNormalProp$H(a, prop, b[prop]);
    }
  return a;
};
var __objRest$p = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$I.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$I)
    for (var prop of __getOwnPropSymbols$I(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$I.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const InlineLabel = (_a) => {
  var _b = _a, {
    children,
    className,
    tooltip,
    width,
    transparent,
    interactive,
    as: Component = "label"
  } = _b, rest = __objRest$p(_b, [
    "children",
    "className",
    "tooltip",
    "width",
    "transparent",
    "interactive",
    "as"
  ]);
  const styles = useStyles2(
    React.useCallback((theme) => getInlineLabelStyles(theme, transparent, width), [transparent, width])
  );
  return /* @__PURE__ */ React__default["default"].createElement(Component, __spreadValues$H({ className: css.cx(styles.label, className) }, rest), children, tooltip && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { interactive, placement: "top", content: tooltip, theme: "info" }, /* @__PURE__ */ React__default["default"].createElement(Icon, { tabIndex: 0, name: "info-circle", size: "sm", className: styles.icon })));
};
const getInlineLabelStyles = (theme, transparent = false, width) => {
  return {
    label: css.css`
      display: flex;
      align-items: center;
      justify-content: space-between;
      flex-shrink: 0;
      padding: 0 ${theme.spacing(1)};
      font-weight: ${theme.typography.fontWeightMedium};
      font-size: ${theme.typography.size.sm};
      background-color: ${transparent ? "transparent" : theme.colors.background.secondary};
      height: ${theme.spacing(theme.components.height.md)};
      line-height: ${theme.spacing(theme.components.height.md)};
      margin-right: ${theme.spacing(0.5)};
      border-radius: ${theme.shape.radius.default};
      border: none;
      width: ${width ? width !== "auto" ? `${8 * width}px` : width : "100%"};
      color: ${theme.colors.text.primary};
    `,
    icon: css.css`
      color: ${theme.colors.text.secondary};
      margin-left: 10px;

      :hover {
        color: ${theme.colors.text.primary};
      }
    `
  };
};

var __defProp$G = Object.defineProperty;
var __getOwnPropSymbols$H = Object.getOwnPropertySymbols;
var __hasOwnProp$H = Object.prototype.hasOwnProperty;
var __propIsEnum$H = Object.prototype.propertyIsEnumerable;
var __defNormalProp$G = (obj, key, value) => key in obj ? __defProp$G(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$G = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$H.call(b, prop))
      __defNormalProp$G(a, prop, b[prop]);
  if (__getOwnPropSymbols$H)
    for (var prop of __getOwnPropSymbols$H(b)) {
      if (__propIsEnum$H.call(b, prop))
        __defNormalProp$G(a, prop, b[prop]);
    }
  return a;
};
var __objRest$o = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$H.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$H)
    for (var prop of __getOwnPropSymbols$H(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$H.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const InlineField = (_a) => {
  var _b = _a, {
    children,
    label,
    tooltip,
    labelWidth = "auto",
    invalid,
    loading,
    disabled,
    required,
    className,
    htmlFor,
    grow,
    shrink,
    error,
    transparent,
    interactive
  } = _b, htmlProps = __objRest$o(_b, [
    "children",
    "label",
    "tooltip",
    "labelWidth",
    "invalid",
    "loading",
    "disabled",
    "required",
    "className",
    "htmlFor",
    "grow",
    "shrink",
    "error",
    "transparent",
    "interactive"
  ]);
  const theme = useTheme2();
  const styles = getStyles$h(theme, grow, shrink);
  const inputId = htmlFor != null ? htmlFor : getChildId(children);
  const labelElement = typeof label === "string" ? /* @__PURE__ */ React__default["default"].createElement(
    InlineLabel,
    {
      interactive,
      width: labelWidth,
      tooltip,
      htmlFor: inputId,
      transparent
    },
    `${label}${required ? " *" : ""}`
  ) : label;
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$G({ className: css.cx(styles.container, className) }, htmlProps), labelElement, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.childContainer }, React__default["default"].cloneElement(children, { invalid, disabled, loading }), invalid && error && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.fieldValidationWrapper) }, /* @__PURE__ */ React__default["default"].createElement(FieldValidationMessage, null, error))));
};
InlineField.displayName = "InlineField";
const getStyles$h = (theme, grow, shrink) => {
  return {
    container: css.css`
      display: flex;
      flex-direction: row;
      align-items: flex-start;
      text-align: left;
      position: relative;
      flex: ${grow ? 1 : 0} ${shrink ? 1 : 0} auto;
      margin: 0 ${theme.spacing(0.5)} ${theme.spacing(0.5)} 0;
    `,
    childContainer: css.css`
      flex: ${grow ? 1 : 0} ${shrink ? 1 : 0} auto;
    `,
    fieldValidationWrapper: css.css`
      margin-top: ${theme.spacing(0.5)};
    `
  };
};

var __defProp$F = Object.defineProperty;
var __defProps$u = Object.defineProperties;
var __getOwnPropDescs$u = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$G = Object.getOwnPropertySymbols;
var __hasOwnProp$G = Object.prototype.hasOwnProperty;
var __propIsEnum$G = Object.prototype.propertyIsEnumerable;
var __defNormalProp$F = (obj, key, value) => key in obj ? __defProp$F(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$F = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$G.call(b, prop))
      __defNormalProp$F(a, prop, b[prop]);
  if (__getOwnPropSymbols$G)
    for (var prop of __getOwnPropSymbols$G(b)) {
      if (__propIsEnum$G.call(b, prop))
        __defNormalProp$F(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$u = (a, b) => __defProps$u(a, __getOwnPropDescs$u(b));
const BasicAuthSettings = ({ dataSourceConfig, onChange }) => {
  const password = dataSourceConfig.secureJsonData ? dataSourceConfig.secureJsonData.basicAuthPassword : "";
  const onPasswordReset = () => {
    onChange(__spreadProps$u(__spreadValues$F({}, dataSourceConfig), {
      secureJsonData: __spreadProps$u(__spreadValues$F({}, dataSourceConfig.secureJsonData), {
        basicAuthPassword: ""
      }),
      secureJsonFields: __spreadProps$u(__spreadValues$F({}, dataSourceConfig.secureJsonFields), {
        basicAuthPassword: false
      })
    }));
  };
  const onPasswordChange = (event) => {
    onChange(__spreadProps$u(__spreadValues$F({}, dataSourceConfig), {
      secureJsonData: __spreadProps$u(__spreadValues$F({}, dataSourceConfig.secureJsonData), {
        basicAuthPassword: event.currentTarget.value
      })
    }));
  };
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(InlineField, { disabled: dataSourceConfig.readOnly }, /* @__PURE__ */ React__default["default"].createElement(
    FormField,
    {
      label: "User",
      labelWidth: 10,
      inputWidth: 18,
      placeholder: "user",
      value: dataSourceConfig.basicAuthUser,
      onChange: (event) => onChange(__spreadProps$u(__spreadValues$F({}, dataSourceConfig), { basicAuthUser: event.currentTarget.value }))
    }
  )), /* @__PURE__ */ React__default["default"].createElement(InlineField, { disabled: dataSourceConfig.readOnly }, /* @__PURE__ */ React__default["default"].createElement(
    SecretFormField,
    {
      isConfigured: !!(dataSourceConfig.secureJsonFields && dataSourceConfig.secureJsonFields.basicAuthPassword),
      value: password || "",
      inputWidth: 18,
      labelWidth: 10,
      onReset: onPasswordReset,
      onChange: onPasswordChange
    }
  )));
};

var __defProp$E = Object.defineProperty;
var __defProps$t = Object.defineProperties;
var __getOwnPropDescs$t = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$F = Object.getOwnPropertySymbols;
var __hasOwnProp$F = Object.prototype.hasOwnProperty;
var __propIsEnum$F = Object.prototype.propertyIsEnumerable;
var __defNormalProp$E = (obj, key, value) => key in obj ? __defProp$E(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$E = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$F.call(b, prop))
      __defNormalProp$E(a, prop, b[prop]);
  if (__getOwnPropSymbols$F)
    for (var prop of __getOwnPropSymbols$F(b)) {
      if (__propIsEnum$F.call(b, prop))
        __defNormalProp$E(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$t = (a, b) => __defProps$t(a, __getOwnPropDescs$t(b));
const getCustomHeaderRowStyles = stylesFactory(() => {
  return {
    layout: css.css`
      display: flex;
      align-items: center;
      margin-bottom: 4px;
      > * {
        margin-left: 4px;
        margin-bottom: 0;
        height: 100%;
        &:first-child,
        &:last-child {
          margin-left: 0;
        }
      }
    `
  };
});
const CustomHeaderRow = ({ header, onBlur, onChange, onRemove, onReset }) => {
  const styles = getCustomHeaderRowStyles();
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.layout }, /* @__PURE__ */ React__default["default"].createElement(
    FormField,
    {
      label: "Header",
      name: "name",
      placeholder: "X-Custom-Header",
      labelWidth: 5,
      value: header.name || "",
      onChange: (e) => onChange(__spreadProps$t(__spreadValues$E({}, header), { name: e.target.value })),
      onBlur
    }
  ), /* @__PURE__ */ React__default["default"].createElement(
    SecretFormField,
    {
      label: "Value",
      "aria-label": "Value",
      name: "value",
      isConfigured: header.configured,
      value: header.value,
      labelWidth: 5,
      inputWidth: header.configured ? 11 : 12,
      placeholder: "Header Value",
      onReset: () => onReset(header.id),
      onChange: (e) => onChange(__spreadProps$t(__spreadValues$E({}, header), { value: e.target.value })),
      onBlur
    }
  ), /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      type: "button",
      "aria-label": "Remove header",
      variant: "secondary",
      size: "xs",
      onClick: (_e) => onRemove(header.id)
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "trash-alt" })
  ));
};
CustomHeaderRow.displayName = "CustomHeaderRow";
class CustomHeadersSettings extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      headers: []
    };
    this.updateSettings = () => {
      const { headers } = this.state;
      const newJsonData = Object.fromEntries(
        Object.entries(this.props.dataSourceConfig.jsonData).filter(([key, val]) => !key.startsWith("httpHeaderName"))
      );
      const newSecureJsonData = Object.fromEntries(
        Object.entries(this.props.dataSourceConfig.secureJsonData || {}).filter(
          ([key, val]) => !key.startsWith("httpHeaderValue")
        )
      );
      fo