import { throttle } from 'lodash';

const throttledLog = throttle((...t) => {
  console.log(...t);
}, 500);
const createLogger = (name) => {
  let LOGGIN_ENABLED = false;
  return {
    logger: (id, throttle2 = false, ...t) => {
      if (process.env.NODE_ENV === "production" || process.env.NODE_ENV === "test" || !LOGGIN_ENABLED) {
        return;
      }
      const fn = throttle2 ? throttledLog : console.log;
      fn(`[${name}: ${id}]: `, ...t);
    },
    enable: () => LOGGIN_ENABLED = true,
    disable: () => LOGGIN_ENABLED = false,
    isEnabled: () => LOGGIN_ENABLED
  };
};

export { createLogger };
//# sourceMappingURL=logger.js.map
