import { TooltipDisplayMode, SortOrder } from '@grafana/schema';

function addTooltipOptions(builder, singleOnly = false) {
  const category = ["Tooltip"];
  const modeOptions = singleOnly ? [
    { value: TooltipDisplayMode.Single, label: "Single" },
    { value: TooltipDisplayMode.None, label: "Hidden" }
  ] : [
    { value: TooltipDisplayMode.Single, label: "Single" },
    { value: TooltipDisplayMode.Multi, label: "All" },
    { value: TooltipDisplayMode.None, label: "Hidden" }
  ];
  const sortOptions = [
    { value: SortOrder.None, label: "None" },
    { value: SortOrder.Ascending, label: "Ascending" },
    { value: SortOrder.Descending, label: "Descending" }
  ];
  builder.addRadio({
    path: "tooltip.mode",
    name: "Tooltip mode",
    category,
    defaultValue: "single",
    settings: {
      options: modeOptions
    }
  }).addRadio({
    path: "tooltip.sort",
    name: "Values sort order",
    category,
    defaultValue: SortOrder.None,
    showIf: (options) => {
      var _a;
      return ((_a = options.tooltip) == null ? void 0 : _a.mode) === TooltipDisplayMode.Multi;
    },
    settings: {
      options: sortOptions
    }
  });
}

export { addTooltipOptions };
//# sourceMappingURL=tooltip.js.map
