import { css } from '@emotion/css';
import React__default from 'react';
import { CSSTransition } from 'react-transition-group';
import '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';

const getStyles = stylesFactory((duration, measurement, size) => {
  return {
    enter: css`
      label: enter;
      ${measurement}: 0;
      opacity: 0;
    `,
    enterActive: css`
      label: enterActive;
      ${measurement}: ${size}px;
      opacity: 1;
      transition: opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out;
    `,
    exit: css`
      label: exit;
      ${measurement}: ${size}px;
      opacity: 1;
    `,
    exitActive: css`
      label: exitActive;
      opacity: 0;
      ${measurement}: 0;
      transition: opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out;
    `
  };
});
function SlideOutTransition(props) {
  const { visible, children, duration = 250, horizontal, size } = props;
  const styles = getStyles(duration, horizontal ? "width" : "height", size);
  return /* @__PURE__ */ React__default.createElement(CSSTransition, { in: visible, mountOnEnter: true, unmountOnExit: true, timeout: duration, classNames: styles }, children);
}

export { SlideOutTransition };
//# sourceMappingURL=SlideOutTransition.js.map
