import React__default, { PureComponent } from 'react';
import { Manager, Popper } from 'react-popper';
import Transition from 'react-transition-group/Transition';
import { Portal } from '../Portal/Portal.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const defaultTransitionStyles = {
  transitionProperty: "opacity",
  transitionDuration: "200ms",
  transitionTimingFunction: "linear",
  opacity: 0
};
const transitionStyles = {
  exited: { opacity: 0 },
  entering: { opacity: 0 },
  entered: { opacity: 1, transitionDelay: "0s" },
  exiting: { opacity: 0, transitionDelay: "500ms" }
};
class Popover extends PureComponent {
  render() {
    const {
      content,
      show,
      placement,
      onMouseEnter,
      onMouseLeave,
      className,
      wrapperClassName,
      renderArrow,
      referenceElement,
      onKeyDown
    } = this.props;
    return /* @__PURE__ */ React__default.createElement(Manager, null, /* @__PURE__ */ React__default.createElement(Transition, { in: show, timeout: 100, mountOnEnter: true, unmountOnExit: true }, (transitionState) => {
      return /* @__PURE__ */ React__default.createElement(Portal, null, /* @__PURE__ */ React__default.createElement(
        Popper,
        {
          placement,
          referenceElement,
          modifiers: [
            { name: "preventOverflow", enabled: true, options: { rootBoundary: "viewport" } },
            {
              name: "eventListeners",
              options: { scroll: true, resize: true }
            }
          ]
        },
        ({ ref, style, placement: placement2, arrowProps, update }) => {
          return /* @__PURE__ */ React__default.createElement(
            "div",
            {
              onMouseEnter,
              onMouseLeave,
              onKeyDown,
              ref,
              style: __spreadValues(__spreadValues(__spreadValues({}, style), defaultTransitionStyles), transitionStyles[transitionState]),
              "data-placement": placement2,
              className: `${wrapperClassName}`
            },
            /* @__PURE__ */ React__default.createElement("div", { className }, typeof content === "string" && content, React__default.isValidElement(content) && React__default.cloneElement(content), typeof content === "function" && content({
              updatePopperPosition: update
            }), renderArrow && renderArrow({
              arrowProps,
              placement: placement2
            }))
          );
        }
      ));
    }));
  }
}

export { Popover };
//# sourceMappingURL=Popover.js.map
