import { cx, css } from '@emotion/css';
import React__default from 'react';
import { useTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';

const getTabsBarStyles = stylesFactory((theme, hideBorder = false) => {
  return {
    tabsWrapper: !hideBorder && css`
        border-bottom: 1px solid ${theme.colors.border.weak};
      `,
    tabs: css`
      position: relative;
      display: flex;
      height: ${theme.components.menuTabs.height}px;
    `
  };
});
const TabsBar = React__default.forwardRef(({ children, className, hideBorder }, ref) => {
  const theme = useTheme2();
  const tabsStyles = getTabsBarStyles(theme, hideBorder);
  return /* @__PURE__ */ React__default.createElement("div", { className: cx(tabsStyles.tabsWrapper, className), ref }, /* @__PURE__ */ React__default.createElement("div", { className: tabsStyles.tabs, role: "tablist" }, children));
});
TabsBar.displayName = "TabsBar";

export { TabsBar };
//# sourceMappingURL=TabsBar.js.map
