import React__default, { memo, useCallback, useMemo } from 'react';
import { FieldMatcherID, fieldMatchers } from '@grafana/data';
import { Select } from '../Select/Select.js';

const FieldsByFrameRefIdMatcher = memo((props) => {
  const { data, options, onChange: onChangeFromProps } = props;
  const referenceIDs = useFrameRefIds(data);
  const selectOptions = useSelectOptions(referenceIDs);
  const onChange = useCallback(
    (selection) => {
      if (!selection.value || !referenceIDs.has(selection.value)) {
        return;
      }
      return onChangeFromProps(selection.value);
    },
    [referenceIDs, onChangeFromProps]
  );
  const selectedOption = selectOptions.find((v) => v.value === options);
  return /* @__PURE__ */ React__default.createElement(Select, { value: selectedOption, options: selectOptions, onChange });
});
FieldsByFrameRefIdMatcher.displayName = "FieldsByFrameRefIdMatcher";
const fieldsByFrameRefIdItem = {
  id: FieldMatcherID.byFrameRefID,
  component: FieldsByFrameRefIdMatcher,
  matcher: fieldMatchers.get(FieldMatcherID.byFrameRefID),
  name: "Fields returned by query",
  description: "Set properties for fields from a specific query",
  optionsToLabel: (options) => options
};
const useFrameRefIds = (data) => {
  return useMemo(() => {
    const refIds = /* @__PURE__ */ new Set();
    for (const frame of data) {
      if (frame.refId) {
        refIds.add(frame.refId);
      }
    }
    return refIds;
  }, [data]);
};
const useSelectOptions = (displayNames) => {
  return useMemo(() => {
    return Array.from(displayNames).map((n) => ({
      value: n,
      label: n
    }));
  }, [displayNames]);
};

export { FieldsByFrameRefIdMatcher, fieldsByFrameRefIdItem };
//# sourceMappingURL=FieldsByFrameRefIdMatcher.js.map
