import { css, cx } from '@emotion/css';
import React__default, { useEffect, useState, useRef, useLayoutEffect } from 'react';
import { textUtil } from '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import { Alert } from '../Alert/Alert.js';
import { ClickOutsideWrapper } from '../ClickOutsideWrapper/ClickOutsideWrapper.js';
import { CustomScrollbar } from '../CustomScrollbar/CustomScrollbar.js';
import { List } from '../List/List.js';
import { LogMessageAnsi } from './LogMessageAnsi.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const getLogRowContextStyles = (theme, wrapLogMessage) => {
  const afterContext = wrapLogMessage ? css`
        top: -250px;
      ` : css`
        margin-top: -250px;
        width: 75%;
      `;
  const beforeContext = wrapLogMessage ? css`
        top: 100%;
      ` : css`
        margin-top: 40px;
        width: 75%;
      `;
  return {
    commonStyles: css`
      position: absolute;
      height: 250px;
      z-index: ${theme.zIndex.dropdown};
      overflow: hidden;
      background: ${theme.colors.background.primary};
      box-shadow: 0 0 10px ${theme.v1.palette.black};
      border: 1px solid ${theme.colors.background.secondary};
      border-radius: ${theme.shape.borderRadius()};
      width: 100%;
    `,
    header: css`
      height: 30px;
      padding: 0 10px;
      display: flex;
      align-items: center;
      background: ${theme.colors.background.secondary};
    `,
    logs: css`
      height: 220px;
      padding: 10px;
    `,
    afterContext,
    beforeContext
  };
};
const LogRowContextGroupHeader = ({ row, rows, onLoadMoreContext, canLoadMoreRows }) => {
  const { header } = useStyles2(getLogRowContextStyles);
  return /* @__PURE__ */ React__default.createElement("div", { className: header }, /* @__PURE__ */ React__default.createElement(
    "span",
    {
      className: css`
          opacity: 0.6;
        `
    },
    "Found ",
    rows.length,
    " rows."
  ), (rows.length >= 10 || rows.length > 10 && rows.length % 10 !== 0) && canLoadMoreRows && /* @__PURE__ */ React__default.createElement(
    "span",
    {
      className: css`
            margin-left: 10px;
            &:hover {
              text-decoration: underline;
              cursor: pointer;
            }
          `,
      onClick: onLoadMoreContext
    },
    "Load 10 more"
  ));
};
const LogRowContextGroup = ({
  row,
  rows,
  error,
  className,
  shouldScrollToBottom,
  canLoadMoreRows,
  onLoadMoreContext
}) => {
  const { commonStyles, logs } = useStyles2(getLogRowContextStyles);
  const [scrollTop, setScrollTop] = useState(0);
  const listContainerRef = useRef(null);
  useLayoutEffect(() => {
    const shouldScrollRows = rows.length > 0 && rows.length <= 10;
    if (shouldScrollToBottom && shouldScrollRows && listContainerRef.current) {
      setScrollTop(listContainerRef.current.offsetHeight);
    }
  }, [shouldScrollToBottom, rows]);
  const headerProps = {
    row,
    rows,
    onLoadMoreContext,
    canLoadMoreRows
  };
  return /* @__PURE__ */ React__default.createElement("div", { className: cx(commonStyles, className) }, shouldScrollToBottom && !error && /* @__PURE__ */ React__default.createElement(LogRowContextGroupHeader, __spreadValues({}, headerProps)), /* @__PURE__ */ React__default.createElement("div", { className: logs }, /* @__PURE__ */ React__default.createElement(CustomScrollbar, { autoHide: true, scrollTop, autoHeightMin: "210px" }, /* @__PURE__ */ React__default.createElement("div", { ref: listContainerRef }, !error && /* @__PURE__ */ React__default.createElement(
    List,
    {
      items: rows,
      renderItem: (item) => {
        return /* @__PURE__ */ React__default.createElement(
          "div",
          {
            className: css`
                        padding: 5px 0;
                      `
          },
          typeof item === "string" && textUtil.hasAnsiCodes(item) ? /* @__PURE__ */ React__default.createElement(LogMessageAnsi, { value: item }) : item
        );
      }
    }
  ), error && /* @__PURE__ */ React__default.createElement(Alert, { title: error })))), !shouldScrollToBottom && !error && /* @__PURE__ */ React__default.createElement(LogRowContextGroupHeader, __spreadValues({}, headerProps)));
};
const LogRowContext = ({
  row,
  context,
  errors,
  onOutsideClick,
  onLoadMoreContext,
  hasMoreContextRows,
  wrapLogMessage
}) => {
  useEffect(() => {
    const handleEscKeyDown = (e) => {
      if (e.keyCode === 27) {
        onOutsideClick();
      }
    };
    document.addEventListener("keydown", handleEscKeyDown, false);
    return () => {
      document.removeEventListener("keydown", handleEscKeyDown, false);
    };
  }, [onOutsideClick]);
  const { afterContext, beforeContext } = useStyles2((theme) => getLogRowContextStyles(theme, wrapLogMessage));
  return /* @__PURE__ */ React__default.createElement(ClickOutsideWrapper, { onClick: onOutsideClick }, /* @__PURE__ */ React__default.createElement("div", { onClick: (e) => e.stopPropagation() }, context.after && /* @__PURE__ */ React__default.createElement(
    LogRowContextGroup,
    {
      rows: context.after,
      error: errors && errors.after,
      row,
      className: afterContext,
      shouldScrollToBottom: true,
      canLoadMoreRows: hasMoreContextRows ? hasMoreContextRows.after : false,
      onLoadMoreContext
    }
  ), context.before && /* @__PURE__ */ React__default.createElement(
    LogRowContextGroup,
    {
      onLoadMoreContext,
      canLoadMoreRows: hasMoreContextRows ? hasMoreContextRows.before : false,
      row,
      rows: context.before,
      error: errors && errors.before,
      className: beforeContext
    }
  )));
};

export { LogRowContext, LogRowContextGroup };
//# sourceMappingURL=LogRowContext.js.map
