import ansicolor from 'ansicolor';
import React__default, { PureComponent } from 'react';
import Highlighter from 'react-highlight-words';
import { findHighlightChunksInText } from '@grafana/data';
import { withTheme2 } from '../../themes/ThemeContext.js';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';

function convertCSSToStyle(theme, css) {
  return css.split(/;\s*/).reduce((accumulated, line) => {
    if (line === "color:rgba(0,0,0,0.5)") {
      return { color: theme.colors.text.secondary };
    }
    const match = line.match(/([^:\s]+)\s*:\s*(.+)/);
    if (match && match[1] && match[2]) {
      const key = match[1].replace(/-([a-z])/g, (_, character) => character.toUpperCase());
      accumulated[key] = match[2];
    }
    return accumulated;
  }, {});
}
class UnThemedLogMessageAnsi extends PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      chunks: [],
      prevValue: ""
    };
  }
  static getDerivedStateFromProps(props, state) {
    if (props.value === state.prevValue) {
      return null;
    }
    const parsed = ansicolor.parse(props.value);
    return {
      chunks: parsed.spans.map((span) => {
        return span.css ? {
          style: convertCSSToStyle(props.theme, span.css),
          text: span.text
        } : { text: span.text };
      }),
      prevValue: props.value
    };
  }
  render() {
    const { chunks } = this.state;
    return chunks.map((chunk, index) => {
      var _a;
      const chunkText = ((_a = this.props.highlight) == null ? void 0 : _a.searchWords) ? /* @__PURE__ */ React__default.createElement(
        Highlighter,
        {
          key: index,
          textToHighlight: chunk.text,
          searchWords: this.props.highlight.searchWords,
          findChunks: findHighlightChunksInText,
          highlightClassName: this.props.highlight.highlightClassName
        }
      ) : chunk.text;
      return chunk.style ? /* @__PURE__ */ React__default.createElement("span", { key: index, style: chunk.style, "data-testid": "ansiLogLine" }, chunkText) : chunkText;
    });
  }
}
const LogMessageAnsi = withTheme2(UnThemedLogMessageAnsi);
LogMessageAnsi.displayName = "LogMessageAnsi";

export { LogMessageAnsi, UnThemedLogMessageAnsi };
//# sourceMappingURL=LogMessageAnsi.js.map
