import { cx, css } from '@emotion/css';
import React__default from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';

const HIDDEN_LABELS = ["level", "lvl", "filename"];
const LogLabels = ({ labels }) => {
  const styles = useStyles2(getStyles);
  const displayLabels = Object.keys(labels).filter((label) => !label.startsWith("_") && !HIDDEN_LABELS.includes(label));
  if (displayLabels.length === 0) {
    return /* @__PURE__ */ React__default.createElement("span", { className: cx([styles.logsLabels]) }, /* @__PURE__ */ React__default.createElement("span", { className: cx([styles.logsLabel]) }, "(no unique labels)"));
  }
  return /* @__PURE__ */ React__default.createElement("span", { className: cx([styles.logsLabels]) }, displayLabels.sort().map((label) => {
    const value = labels[label];
    if (!value) {
      return;
    }
    const tooltip = `${label}: ${value}`;
    return /* @__PURE__ */ React__default.createElement("span", { key: label, className: cx([styles.logsLabel]) }, /* @__PURE__ */ React__default.createElement("span", { className: cx([styles.logsLabelValue]), title: tooltip }, value));
  }));
};
const getStyles = (theme) => {
  return {
    logsLabels: css`
      display: flex;
      flex-wrap: wrap;
      font-size: ${theme.typography.size.xs};
    `,
    logsLabel: css`
      label: logs-label;
      display: flex;
      padding: 0 2px;
      background-color: ${theme.colors.background.secondary};
      border-radius: ${theme.shape.borderRadius(1)};
      margin: 1px 4px 0 0;
      text-overflow: ellipsis;
      white-space: nowrap;
      overflow: hidden;
    `,
    logsLabelValue: css`
      label: logs-label__value;
      display: inline-block;
      max-width: 20em;
      text-overflow: ellipsis;
      overflow: hidden;
    `
  };
};

export { LogLabels };
//# sourceMappingURL=LogLabels.js.map
