import { css } from '@emotion/css';
import React__default, { PureComponent } from 'react';
import { withTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import { LogLabelStatsRow } from './LogLabelStatsRow.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const STATS_ROW_LIMIT = 5;
const getStyles = stylesFactory((theme) => {
  return {
    logsStats: css`
      label: logs-stats;
      background: inherit;
      color: ${theme.colors.text.primary};
      word-break: break-all;
      width: fit-content;
      max-width: 100%;
    `,
    logsStatsHeader: css`
      label: logs-stats__header;
      border-bottom: 1px solid ${theme.colors.border.medium};
      display: flex;
    `,
    logsStatsTitle: css`
      label: logs-stats__title;
      font-weight: ${theme.typography.fontWeightMedium};
      padding-right: ${theme.spacing(2)};
      display: inline-block;
      white-space: nowrap;
      text-overflow: ellipsis;
      flex-grow: 1;
    `,
    logsStatsClose: css`
      label: logs-stats__close;
      cursor: pointer;
    `,
    logsStatsBody: css`
      label: logs-stats__body;
      padding: 5px 0;
    `
  };
});
class UnThemedLogLabelStats extends PureComponent {
  render() {
    const { label, rowCount, stats, value, theme, isLabel } = this.props;
    const style = getStyles(theme);
    const topRows = stats.slice(0, STATS_ROW_LIMIT);
    let activeRow = topRows.find((row) => row.value === value);
    let otherRows = stats.slice(STATS_ROW_LIMIT);
    const insertActiveRow = !activeRow;
    if (insertActiveRow) {
      activeRow = otherRows.find((row) => row.value === value);
      otherRows = otherRows.filter((row) => row.value !== value);
    }
    const otherCount = otherRows.reduce((sum, row) => sum + row.count, 0);
    const topCount = topRows.reduce((sum, row) => sum + row.count, 0);
    const total = topCount + otherCount;
    const otherProportion = otherCount / total;
    return /* @__PURE__ */ React__default.createElement("div", { className: style.logsStats, "data-testid": "logLabelStats" }, /* @__PURE__ */ React__default.createElement("div", { className: style.logsStatsHeader }, /* @__PURE__ */ React__default.createElement("div", { className: style.logsStatsTitle }, label, ": ", total, " of ", rowCount, " rows have that ", isLabel ? "label" : "field")), /* @__PURE__ */ React__default.createElement("div", { className: style.logsStatsBody }, topRows.map((stat) => /* @__PURE__ */ React__default.createElement(LogLabelStatsRow, __spreadProps(__spreadValues({ key: stat.value }, stat), { active: stat.value === value }))), insertActiveRow && activeRow && /* @__PURE__ */ React__default.createElement(LogLabelStatsRow, __spreadProps(__spreadValues({ key: activeRow.value }, activeRow), { active: true })), otherCount > 0 && /* @__PURE__ */ React__default.createElement(LogLabelStatsRow, { key: "__OTHERS__", count: otherCount, value: "Other", proportion: otherProportion })));
  }
}
const LogLabelStats = withTheme2(UnThemedLogLabelStats);
LogLabelStats.displayName = "LogLabelStats";

export { LogLabelStats };
//# sourceMappingURL=LogLabelStats.js.map
