import { cx, css } from '@emotion/css';
import { uniqueId } from 'lodash';
import React__default, { useMemo, useCallback, Fragment } from 'react';
import { useTable, useSortBy, useExpanded } from 'react-table';
import { isTruthy } from '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { Icon } from '../Icon/Icon.js';
import { getColumns, EXPANDER_CELL_ID } from './utils.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getStyles = (theme) => ({
  table: css`
    border-radius: ${theme.shape.borderRadius()};
    border: solid 1px ${theme.colors.border.weak};
    background-color: ${theme.colors.background.secondary};
    width: 100%;

    td {
      padding: ${theme.spacing(1)};
    }

    td,
    th {
      min-width: ${theme.spacing(3)};
    }
  `,
  evenRow: css`
    background: ${theme.colors.background.primary};
  `,
  disableGrow: css`
    width: 0%;
  `,
  header: css`
    &,
    & > button {
      position: relative;
      white-space: nowrap;
      padding: ${theme.spacing(1)};
    }
    & > button {
      &:after {
        content: '\\00a0';
      }
      width: 100%;
      height: 100%;
      background: none;
      border: none;
      padding-right: ${theme.spacing(2.5)};
      text-align: left;
      &:hover {
        background-color: ${theme.colors.emphasize(theme.colors.background.secondary, 0.05)};
      }
    }
  `,
  sortableHeader: css`
    /* increases selector's specificity so that it always takes precedence over default styles  */
    && {
      padding: 0;
    }
  `
});
function InteractiveTable({
  data,
  className,
  columns,
  renderExpandedRow,
  getRowId
}) {
  const styles = useStyles2(getStyles);
  const tableColumns = useMemo(() => {
    const cols = getColumns(columns);
    return cols;
  }, [columns]);
  const id = useUniqueId();
  const getRowHTMLID = useCallback(
    (row) => {
      return `${id}-${row.id}`.replace(/\s/g, "");
    },
    [id]
  );
  const { getTableProps, getTableBodyProps, headerGroups, rows, prepareRow } = useTable(
    {
      columns: tableColumns,
      data,
      autoResetExpanded: false,
      autoResetSortBy: false,
      disableMultiSort: true,
      getRowId,
      initialState: {
        hiddenColumns: [
          !renderExpandedRow && EXPANDER_CELL_ID,
          ...tableColumns.filter((col) => !(col.visible ? col.visible(data) : true)).map((c) => c.id).filter(isTruthy)
        ].filter(isTruthy)
      }
    },
    useSortBy,
    useExpanded
  );
  rows.forEach(prepareRow);
  return /* @__PURE__ */ React__default.createElement("table", __spreadProps(__spreadValues({}, getTableProps()), { className: cx(styles.table, className) }), /* @__PURE__ */ React__default.createElement("thead", null, headerGroups.map((headerGroup) => {
    const _a = headerGroup.getHeaderGroupProps(), { key } = _a, headerRowProps = __objRest(_a, ["key"]);
    return /* @__PURE__ */ React__default.createElement("tr", __spreadValues({ key }, headerRowProps), headerGroup.headers.map((column) => {
      const _a2 = column.getHeaderProps(), { key: key2 } = _a2, headerCellProps = __objRest(_a2, ["key"]);
      return /* @__PURE__ */ React__default.createElement(
        "th",
        __spreadValues(__spreadValues({
          key: key2,
          className: cx(styles.header, {
            [styles.disableGrow]: column.width === 0,
            [styles.sortableHeader]: column.canSort
          })
        }, headerCellProps), column.isSorted && { "aria-sort": column.isSortedDesc ? "descending" : "ascending" }),
        /* @__PURE__ */ React__default.createElement(ColumnHeader, { column })
      );
    }));
  })), /* @__PURE__ */ React__default.createElement("tbody", __spreadValues({}, getTableBodyProps()), rows.map((row, rowIndex) => {
    const className2 = cx(rowIndex % 2 === 0 && styles.evenRow);
    const _a = row.getRowProps(), { key } = _a, otherRowProps = __objRest(_a, ["key"]);
    const rowId = getRowHTMLID(row);
    return /* @__PURE__ */ React__default.createElement(
      Fragment,
      { key },
      /* @__PURE__ */ React__default.createElement("tr", __spreadValues({ className: className2 }, otherRowProps), row.cells.map((cell) => {
        const _a2 = cell.getCellProps(), { key: key2 } = _a2, otherCellProps = __objRest(_a2, ["key"]);
        return /* @__PURE__ */ React__default.createElement("td", __spreadValues({ key: key2 }, otherCellProps), cell.render("Cell", { __rowID: rowId }));
      })),
      // @ts-expect-error react-table doesn't ship with useExpanded types and we can't use declaration merging without affecting the table viz
      row.isExpanded && renderExpandedRow && /* @__PURE__ */ React__default.createElement("tr", __spreadProps(__spreadValues({ className: className2 }, otherRowProps), { id: rowId }), /* @__PURE__ */ React__default.createElement("td", { colSpan: row.cells.length }, renderExpandedRow(row.original)))
    );
  })));
}
const useUniqueId = () => {
  return useMemo(() => uniqueId("InteractiveTable"), []);
};
const getColumnheaderStyles = (theme) => ({
  sortIcon: css`
    position: absolute;
    top: ${theme.spacing(1)};
  `
});
function ColumnHeader({
  column: { canSort, render, isSorted, isSortedDesc, getSortByToggleProps }
}) {
  const styles = useStyles2(getColumnheaderStyles);
  const { onClick } = getSortByToggleProps();
  const children = /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, render("Header"), isSorted && /* @__PURE__ */ React__default.createElement("span", { "aria-hidden": "true", className: styles.sortIcon }, /* @__PURE__ */ React__default.createElement(Icon, { name: isSortedDesc ? "angle-down" : "angle-up" })));
  if (canSort) {
    return /* @__PURE__ */ React__default.createElement("button", { type: "button", onClick }, children);
  }
  return children;
}

export { InteractiveTable };
//# sourceMappingURL=InteractiveTable.js.map
