import { cx, css } from '@emotion/css';
import React__default from 'react';
import useMeasure from 'react-use/lib/useMeasure';
import { useTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import { getFocusStyle, sharedInputStyle } from '../Forms/commonStyles.js';
import { Spinner } from '../Spinner/Spinner.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Input = React__default.forwardRef((props, ref) => {
  const _a = props, { className, addonAfter, addonBefore, prefix, suffix, invalid, loading, width = 0 } = _a, restProps = __objRest(_a, ["className", "addonAfter", "addonBefore", "prefix", "suffix", "invalid", "loading", "width"]);
  const [prefixRef, prefixRect] = useMeasure();
  const [suffixRef, suffixRect] = useMeasure();
  const theme = useTheme2();
  const styles = getInputStyles({ theme, invalid: !!invalid, width });
  return /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.wrapper, className), "data-testid": "input-wrapper" }, !!addonBefore && /* @__PURE__ */ React__default.createElement("div", { className: styles.addon }, addonBefore), /* @__PURE__ */ React__default.createElement("div", { className: styles.inputWrapper }, prefix && /* @__PURE__ */ React__default.createElement("div", { className: styles.prefix, ref: prefixRef }, prefix), /* @__PURE__ */ React__default.createElement(
    "input",
    __spreadProps(__spreadValues({
      ref,
      className: styles.input
    }, restProps), {
      style: {
        paddingLeft: prefix ? prefixRect.width + 12 : void 0,
        paddingRight: suffix || loading ? suffixRect.width + 12 : void 0
      }
    })
  ), (suffix || loading) && /* @__PURE__ */ React__default.createElement("div", { className: styles.suffix, ref: suffixRef }, loading && /* @__PURE__ */ React__default.createElement(Spinner, { className: styles.loadingIndicator, inline: true }), suffix)), !!addonAfter && /* @__PURE__ */ React__default.createElement("div", { className: styles.addon }, addonAfter));
});
Input.displayName = "Input";
const getInputStyles = stylesFactory(({ theme, invalid = false, width }) => {
  const prefixSuffixStaticWidth = "28px";
  const prefixSuffix = css`
    position: absolute;
    top: 0;
    z-index: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-grow: 0;
    flex-shrink: 0;
    font-size: ${theme.typography.size.md};
    height: 100%;
    /* Min width specified for prefix/suffix classes used outside React component*/
    min-width: ${prefixSuffixStaticWidth};
    color: ${theme.colors.text.secondary};
  `;
  return {
    // Wraps inputWrapper and addons
    wrapper: cx(
      css`
        label: input-wrapper;
        display: flex;
        width: ${width ? `${theme.spacing(width)}` : "100%"};
        height: ${theme.spacing(theme.components.height.md)};
        border-radius: ${theme.shape.borderRadius()};
        &:hover {
          > .prefix,
          .suffix,
          .input {
            border-color: ${invalid ? theme.colors.error.border : theme.colors.primary.border};
          }

          // only show number buttons on hover
          input[type='number'] {
            -moz-appearance: number-input;
            -webkit-appearance: number-input;
            appearance: textfield;
          }

          input[type='number']::-webkit-inner-spin-button,
          input[type='number']::-webkit-outer-spin-button {
            -webkit-appearance: inner-spin-button !important;
            opacity: 1;
          }
        }
      `
    ),
    // Wraps input and prefix/suffix
    inputWrapper: css`
      label: input-inputWrapper;
      position: relative;
      flex-grow: 1;
      /* we want input to be above addons, especially for focused state */
      z-index: 1;

      /* when input rendered with addon before only*/
      &:not(:first-child):last-child {
        > input {
          border-left: none;
          border-top-left-radius: 0;
          border-bottom-left-radius: 0;
        }
      }

      /* when input rendered with addon after only*/
      &:first-child:not(:last-child) {
        > input {
          border-right: none;
          border-top-right-radius: 0;
          border-bottom-right-radius: 0;
        }
      }

      /* when rendered with addon before and after */
      &:not(:first-child):not(:last-child) {
        > input {
          border-right: none;
          border-top-right-radius: 0;
          border-bottom-right-radius: 0;
          border-top-left-radius: 0;
          border-bottom-left-radius: 0;
        }
      }

      input {
        /* paddings specified for classes used outside React component */
        &:not(:first-child) {
          padding-left: ${prefixSuffixStaticWidth};
        }
        &:not(:last-child) {
          padding-right: ${prefixSuffixStaticWidth};
        }
        &[readonly] {
          cursor: default;
        }
      }
    `,
    input: cx(
      getFocusStyle(theme),
      sharedInputStyle(theme, invalid),
      css`
        label: input-input;
        position: relative;
        z-index: 0;
        flex-grow: 1;
        border-radius: ${theme.shape.borderRadius()};
        height: 100%;
        width: 100%;
      `
    ),
    inputDisabled: css`
      background-color: ${theme.colors.action.disabledBackground};
      color: ${theme.colors.action.disabledText};
      border: 1px solid ${theme.colors.action.disabledBackground};
      &:focus {
        box-shadow: none;
      }
    `,
    addon: css`
      label: input-addon;
      display: flex;
      justify-content: center;
      align-items: center;
      flex-grow: 0;
      flex-shrink: 0;
      position: relative;

      &:first-child {
        border-top-right-radius: 0;
        border-bottom-right-radius: 0;
        > :last-child {
          border-top-right-radius: 0;
          border-bottom-right-radius: 0;
        }
      }

      &:last-child {
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
        > :first-child {
          border-top-left-radius: 0;
          border-bottom-left-radius: 0;
        }
      }
      > *:focus {
        /* we want anything that has focus and is an addon to be above input */
        z-index: 2;
      }
    `,
    prefix: cx(
      prefixSuffix,
      css`
        label: input-prefix;
        padding-left: ${theme.spacing(1)};
        padding-right: ${theme.spacing(0.5)};
        border-right: none;
        border-top-right-radius: 0;
        border-bottom-right-radius: 0;
      `
    ),
    suffix: cx(
      prefixSuffix,
      css`
        label: input-suffix;
        padding-left: ${theme.spacing(1)};
        padding-right: ${theme.spacing(1)};
        margin-bottom: -2px;
        border-left: none;
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
        right: 0;
      `
    ),
    loadingIndicator: css`
      & + * {
        margin-left: ${theme.spacing(0.5)};
      }
    `
  };
});

export { Input, getInputStyles };
//# sourceMappingURL=Input.js.map
