import { css } from '@emotion/css';
import { FocusScope } from '@react-aria/focus';
import React__default, { useState, useRef, useEffect } from 'react';
import { usePopperTooltip } from 'react-popper-tooltip';
import { CSSTransition } from 'react-transition-group';
import '../../utils/dom.js';
import { renderOrCallToRender } from '../../utils/reactUtils.js';
import '../../utils/colors.js';
import 'slate';
import 'lodash';
import 'ansicolor';
import '../../utils/logger.js';
import { Portal } from '../Portal/Portal.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const Dropdown = React__default.memo(({ children, overlay, placement, offset, onVisibleChange }) => {
  const [show, setShow] = useState(false);
  const transitionRef = useRef(null);
  useEffect(() => {
    onVisibleChange == null ? void 0 : onVisibleChange(show);
  }, [onVisibleChange, show]);
  const { getArrowProps, getTooltipProps, setTooltipRef, setTriggerRef, visible } = usePopperTooltip({
    visible: show,
    placement,
    onVisibleChange: setShow,
    interactive: true,
    delayHide: 0,
    delayShow: 0,
    offset: offset != null ? offset : [0, 8],
    trigger: ["click"]
  });
  const animationDuration = 150;
  const animationStyles = getStyles(animationDuration);
  const onOverlayClicked = () => {
    setShow(false);
  };
  const handleKeys = (event) => {
    if (event.key === "Escape" || event.key === "Tab") {
      setShow(false);
    }
  };
  return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, React__default.cloneElement(typeof children === "function" ? children(visible) : children, {
    ref: setTriggerRef
  }), visible && /* @__PURE__ */ React__default.createElement(Portal, null, /* @__PURE__ */ React__default.createElement(FocusScope, { autoFocus: true, restoreFocus: true, contain: true }, /* @__PURE__ */ React__default.createElement("div", __spreadProps(__spreadValues({ ref: setTooltipRef }, getTooltipProps()), { onClick: onOverlayClicked, onKeyDown: handleKeys }), /* @__PURE__ */ React__default.createElement("div", __spreadValues({}, getArrowProps({ className: "tooltip-arrow" }))), /* @__PURE__ */ React__default.createElement(
    CSSTransition,
    {
      nodeRef: transitionRef,
      appear: true,
      in: true,
      timeout: { appear: animationDuration, exit: 0, enter: 0 },
      classNames: animationStyles
    },
    /* @__PURE__ */ React__default.createElement("div", { ref: transitionRef }, renderOrCallToRender(overlay))
  )))));
});
Dropdown.displayName = "Dropdown";
const getStyles = (duration) => {
  return {
    appear: css({
      opacity: "0",
      position: "relative",
      transform: "scaleY(0.5)",
      transformOrigin: "top"
    }),
    appearActive: css({
      opacity: "1",
      transform: "scaleY(1)",
      transition: `transform ${duration}ms cubic-bezier(0.2, 0, 0.2, 1), opacity ${duration}ms cubic-bezier(0.2, 0, 0.2, 1)`
    })
  };
};

export { Dropdown };
//# sourceMappingURL=Dropdown.js.map
