import { css } from '@emotion/css';
import { useButton } from '@react-aria/button';
import { FocusScope } from '@react-aria/focus';
import { useMenuTrigger } from '@react-aria/menu';
import { useMenuTriggerState } from '@react-stately/menu';
import React__default from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '../Button/Button.js';
import { ButtonGroup } from '../Button/ButtonGroup.js';
import { ClickOutsideWrapper } from '../ClickOutsideWrapper/ClickOutsideWrapper.js';
import { Menu } from '../Menu/Menu.js';
import { MenuItem } from '../Menu/MenuItem.js';
import { ToolbarButton } from '../ToolbarButton/ToolbarButton.js';
import '../ToolbarButton/ToolbarButtonRow.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ButtonSelectComponent = (props) => {
  const _a = props, { className, options, value, onChange, narrow, variant } = _a, restProps = __objRest(_a, ["className", "options", "value", "onChange", "narrow", "variant"]);
  const styles = useStyles2(getStyles);
  const state = useMenuTriggerState({});
  const ref = React__default.useRef(null);
  const { menuTriggerProps, menuProps } = useMenuTrigger({}, state, ref);
  const { buttonProps } = useButton(menuTriggerProps, ref);
  const onChangeInternal = (item) => {
    onChange(item);
    state.close();
  };
  return /* @__PURE__ */ React__default.createElement(ButtonGroup, { className: styles.wrapper }, /* @__PURE__ */ React__default.createElement(
    ToolbarButton,
    __spreadValues(__spreadValues({
      className,
      isOpen: state.isOpen,
      narrow,
      variant,
      ref
    }, buttonProps), restProps),
    (value == null ? void 0 : value.label) || ((value == null ? void 0 : value.value) != null ? String(value == null ? void 0 : value.value) : null)
  ), state.isOpen && /* @__PURE__ */ React__default.createElement("div", { className: styles.menuWrapper }, /* @__PURE__ */ React__default.createElement(ClickOutsideWrapper, { onClick: state.close, parent: document, includeButtonPress: false }, /* @__PURE__ */ React__default.createElement(FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default.createElement(Menu, __spreadValues({ tabIndex: -1, onClose: state.close }, menuProps), options.map((item) => {
    var _a2;
    return /* @__PURE__ */ React__default.createElement(
      MenuItem,
      {
        key: `${item.value}`,
        label: (_a2 = item.label) != null ? _a2 : String(item.value),
        onClick: () => onChangeInternal(item),
        active: item.value === (value == null ? void 0 : value.value),
        ariaChecked: item.value === (value == null ? void 0 : value.value),
        ariaLabel: item.ariaLabel || item.label,
        role: "menuitemradio"
      }
    );
  }))))));
};
ButtonSelectComponent.displayName = "ButtonSelect";
const ButtonSelect = React__default.memo(ButtonSelectComponent);
const getStyles = (theme) => {
  return {
    wrapper: css`
      position: relative;
      display: inline-flex;
    `,
    menuWrapper: css`
      position: absolute;
      z-index: ${theme.zIndex.dropdown};
      top: ${theme.spacing(4)};
      right: 0;
    `
  };
};

export { ButtonSelect };
//# sourceMappingURL=ButtonSelect.js.map
