import { css } from '@emotion/css';
import React__default from 'react';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';

const TimeZoneTitle = ({ title }) => {
  const styles = useStyles2(getStyles);
  if (!title) {
    return null;
  }
  return /* @__PURE__ */ React__default.createElement("span", { className: styles.title }, title);
};
const getStyles = (theme) => {
  return {
    title: css`
      font-weight: ${theme.typography.fontWeightRegular};
      text-overflow: ellipsis;
    `
  };
};

export { TimeZoneTitle };
//# sourceMappingURL=TimeZoneTitle.js.map
