import { cx, css } from '@emotion/css';
import RcTimePicker from 'rc-time-picker';
import React__default from 'react';
import { dateTimeAsMoment, dateTime } from '@grafana/data';
import { focusCss } from '../../themes/mixins.js';
import { inputSizes } from '../Forms/commonStyles.js';
import { Icon } from '../Icon/Icon.js';
import { useStyles2 } from '../../themes/ThemeContext.js';

const POPUP_CLASS_NAME = "time-of-day-picker-panel";
const TimeOfDayPicker = ({
  minuteStep = 1,
  showHour = true,
  showSeconds = false,
  onChange,
  value,
  size = "auto",
  disabled,
  disabledHours,
  disabledMinutes,
  disabledSeconds
}) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ React__default.createElement(
    RcTimePicker,
    {
      className: cx(inputSizes()[size], styles.input),
      popupClassName: cx(styles.picker, POPUP_CLASS_NAME),
      defaultValue: dateTimeAsMoment(),
      onChange: (value2) => onChange(dateTime(value2)),
      allowEmpty: false,
      showSecond: showSeconds,
      value: dateTimeAsMoment(value),
      showHour,
      minuteStep,
      inputIcon: /* @__PURE__ */ React__default.createElement(Caret, { wrapperStyle: styles.caretWrapper }),
      disabled,
      disabledHours,
      disabledMinutes,
      disabledSeconds
    }
  );
};
const Caret = ({ wrapperStyle = "" }) => {
  return /* @__PURE__ */ React__default.createElement("div", { className: wrapperStyle }, /* @__PURE__ */ React__default.createElement(Icon, { name: "angle-down" }));
};
const getStyles = (theme) => {
  const bgColor = theme.components.input.background;
  const menuShadowColor = theme.v1.palette.black;
  const optionBgHover = theme.colors.background.secondary;
  const borderRadius = theme.shape.borderRadius(1);
  const borderColor = theme.components.input.borderColor;
  return {
    caretWrapper: css`
      position: absolute;
      right: 8px;
      top: 50%;
      transform: translateY(-50%);
      display: inline-block;
      text-align: right;
      color: ${theme.colors.text.secondary};
    `,
    picker: css`
      .rc-time-picker-panel-select {
        font-size: 14px;
        background-color: ${bgColor};
        border-color: ${borderColor};
        li {
          outline-width: 2px;
          &.rc-time-picker-panel-select-option-selected {
            background-color: inherit;
            border: 1px solid ${theme.v1.palette.orange};
            border-radius: ${borderRadius};
          }

          &:hover {
            background: ${optionBgHover};
          }

          &.rc-time-picker-panel-select-option-disabled {
            color: ${theme.colors.action.disabledText};
          }
        }
      }

      .rc-time-picker-panel-inner {
        box-shadow: 0px 4px 4px ${menuShadowColor};
        background-color: ${bgColor};
        border-color: ${borderColor};
        border-radius: ${borderRadius};
        margin-top: 3px;

        .rc-time-picker-panel-input-wrap {
          margin-right: 2px;

          &,
          .rc-time-picker-panel-input {
            background-color: ${bgColor};
            padding-top: 2px;
          }
        }

        .rc-time-picker-panel-combobox {
          display: flex;
        }
      }
    `,
    input: css`
      .rc-time-picker-input {
        background-color: ${bgColor};
        border-radius: ${borderRadius};
        border-color: ${borderColor};
        height: ${theme.spacing(4)};

        &:focus {
          ${focusCss(theme)}
        }

        &:disabled {
          background-color: ${theme.colors.action.disabledBackground};
          color: ${theme.colors.action.disabledText};
          border: 1px solid ${theme.colors.action.disabledBackground};
          &:focus {
            box-shadow: none;
          }
        }
      }
    `
  };
};

export { POPUP_CLASS_NAME, TimeOfDayPicker };
//# sourceMappingURL=TimeOfDayPicker.js.map
