/**
 * TODO docs
 */
interface DataSourceJsonData {
    alertmanagerUid?: string;
    authType?: string;
    defaultRegion?: string;
    manageAlerts?: boolean;
    profile?: string;
}
/**
 * These are the common properties available to all queries in all datasources.
 * Specific implementations will *extend* this interface, adding the required
 * properties for the given context.
 */
interface DataQuery$1 {
    /**
     * For mixed data sources the selected datasource is on the query level.
     * For non mixed scenarios this is undefined.
     * TODO find a better way to do this ^ that's friendly to schema
     * TODO this shouldn't be unknown but DataSourceRef | null
     */
    datasource?: unknown;
    /**
     * true if query is disabled (ie should not be returned to the dashboard)
     * Note this does not always imply that the query should not be executed since
     * the results from a hidden query may be used as the input to other queries (SSE etc)
     */
    hide?: boolean;
    /**
     * Specify the query flavor
     * TODO make this required and give it a default
     */
    queryType?: string;
    /**
     * A unique identifier for the query within the list of targets.
     * In server side expressions, the refId is used as a variable name to identify results.
     * By default, the UI will assign A->Z; however setting meaningful names may be useful.
     */
    refId: string;
}
interface BaseDimensionConfig$1 {
    field?: string;
    fixed: (string | number);
}
interface ScaleDimensionConfig$1 extends BaseDimensionConfig$1 {
    max: number;
    min: number;
}
/**
 * This is actually an empty interface used mainly for naming?
 */
interface ColorDimensionConfig$1 extends BaseDimensionConfig$1 {
}
declare enum TextDimensionMode {
    Field = "field",
    Fixed = "fixed",
    Template = "template"
}
interface MapLayerOptions$1 {
    /**
     * Custom options depending on the type
     */
    config?: unknown;
    /**
     * Defines a frame MatcherConfig that may filter data for the given layer
     */
    filterData?: unknown;
    /**
     * Common method to define geometry fields
     */
    location?: FrameGeometrySource;
    /**
     * configured unique display name
     */
    name: string;
    /**
     * Common properties:
     * https://openlayers.org/en/latest/apidoc/module-ol_layer_Base-BaseLayer.html
     * Layer opacity (0-1)
     */
    opacity?: number;
    /**
     * Check tooltip (defaults to true)
     */
    tooltip?: boolean;
    type: string;
}
declare enum FrameGeometrySourceMode {
    Auto = "auto",
    Coords = "coords",
    Geohash = "geohash",
    Lookup = "lookup"
}
declare enum HeatmapCalculationMode {
    Count = "count",
    Size = "size"
}
declare enum HeatmapCellLayout {
    auto = "auto",
    ge = "ge",
    le = "le",
    unknown = "unknown"
}
interface HeatmapCalculationBucketConfig {
    /**
     * Sets the bucket calculation mode
     */
    mode?: HeatmapCalculationMode;
    /**
     * Controls the scale of the buckets
     */
    scale?: ScaleDistributionConfig;
    /**
     * The number of buckets to use for the axis in the heatmap
     */
    value?: string;
}
declare enum LogsSortOrder {
    Ascending = "Ascending",
    Descending = "Descending"
}
/**
 * TODO docs
 */
declare enum AxisPlacement {
    Auto = "auto",
    Bottom = "bottom",
    Hidden = "hidden",
    Left = "left",
    Right = "right",
    Top = "top"
}
/**
 * TODO docs
 */
declare enum AxisColorMode {
    Series = "series",
    Text = "text"
}
/**
 * TODO docs
 */
declare enum VisibilityMode {
    Always = "always",
    Auto = "auto",
    Never = "never"
}
/**
 * TODO docs
 */
declare enum GraphDrawStyle {
    Bars = "bars",
    Line = "line",
    Points = "points"
}
/**
 * TODO docs
 */
declare enum GraphTransform {
    Constant = "constant",
    NegativeY = "negative-Y"
}
/**
 * TODO docs
 */
declare enum LineInterpolation {
    Linear = "linear",
    Smooth = "smooth",
    StepAfter = "stepAfter",
    StepBefore = "stepBefore"
}
/**
 * TODO docs
 */
declare enum ScaleDistribution {
    Linear = "linear",
    Log = "log",
    Ordinal = "ordinal",
    Symlog = "symlog"
}
/**
 * TODO docs
 */
declare enum GraphGradientMode {
    Hue = "hue",
    None = "none",
    Opacity = "opacity",
    Scheme = "scheme"
}
/**
 * TODO docs
 */
declare enum StackingMode {
    None = "none",
    Normal = "normal",
    Percent = "percent"
}
/**
 * TODO docs
 */
declare enum BarAlignment {
    After = 1,
    Before = -1,
    Center = 0
}
/**
 * TODO docs
 */
declare enum ScaleOrientation {
    Horizontal = 0,
    Vertical = 1
}
/**
 * TODO docs
 */
declare enum ScaleDirection {
    Down = -1,
    Left = -1,
    Right = 1,
    Up = 1
}
/**
 * TODO docs
 */
interface LineStyle {
    dash?: Array<number>;
    fill?: ('solid' | 'dash' | 'dot' | 'square');
}
declare const defaultLineStyle: Partial<LineStyle>;
/**
 * TODO docs
 */
interface LineConfig {
    lineColor?: string;
    lineInterpolation?: LineInterpolation;
    lineStyle?: LineStyle;
    lineWidth?: number;
    /**
     * Indicate if null values should be treated as gaps or connected.
     * When the value is a number, it represents the maximum delta in the
     * X axis that should be considered connected.  For timeseries, this is milliseconds
     */
    spanNulls?: (boolean | number);
}
/**
 * TODO docs
 */
interface BarConfig {
    barAlignment?: BarAlignment;
    barMaxWidth?: number;
    barWidthFactor?: number;
}
/**
 * TODO docs
 */
interface FillConfig {
    fillBelowTo?: string;
    fillColor?: string;
    fillOpacity?: number;
}
/**
 * TODO docs
 */
interface PointsConfig {
    pointColor?: string;
    pointSize?: number;
    pointSymbol?: string;
    showPoints?: VisibilityMode;
}
/**
 * TODO docs
 */
interface ScaleDistributionConfig {
    linearThreshold?: number;
    log?: number;
    type: ScaleDistribution;
}
/**
 * TODO docs
 */
interface AxisConfig {
    axisCenteredZero?: boolean;
    axisColorMode?: AxisColorMode;
    axisGridShow?: boolean;
    axisLabel?: string;
    axisPlacement?: AxisPlacement;
    axisSoftMax?: number;
    axisSoftMin?: number;
    axisWidth?: number;
    scaleDistribution?: ScaleDistributionConfig;
}
/**
 * TODO docs
 */
interface HideSeriesConfig {
    legend: boolean;
    tooltip: boolean;
    viz: boolean;
}
/**
 * TODO docs
 */
interface StackingConfig {
    group?: string;
    mode?: StackingMode;
}
/**
 * TODO docs
 */
interface StackableFieldConfig {
    stacking?: StackingConfig;
}
/**
 * TODO docs
 */
interface HideableFieldConfig {
    hideFrom?: HideSeriesConfig;
}
/**
 * TODO docs
 */
declare enum GraphTresholdsStyleMode {
    Area = "area",
    Dashed = "dashed",
    DashedAndArea = "dashed+area",
    Line = "line",
    LineAndArea = "line+area",
    Off = "off",
    Series = "series"
}
/**
 * TODO docs
 */
interface GraphThresholdsStyleConfig {
    mode: GraphTresholdsStyleMode;
}
/**
 * TODO docs
 */
declare type LegendPlacement = ('bottom' | 'right');
/**
 * TODO docs
 * Note: "hidden" needs to remain as an option for plugins compatibility
 */
declare enum LegendDisplayMode {
    Hidden = "hidden",
    List = "list",
    Table = "table"
}
/**
 * TODO docs
 */
interface SingleStatBaseOptions extends OptionsWithTextFormatting {
    orientation: VizOrientation;
    reduceOptions: ReduceDataOptions;
}
/**
 * TODO docs
 */
interface ReduceDataOptions {
    /**
     * When !values, pick one value for the whole field
     */
    calcs: Array<string>;
    /**
     * Which fields to show.  By default this is only numeric fields
     */
    fields?: string;
    /**
     * if showing all values limit
     */
    limit?: number;
    /**
     * If true show each row value
     */
    values?: boolean;
}
declare const defaultReduceDataOptions: Partial<ReduceDataOptions>;
/**
 * TODO docs
 */
declare enum VizOrientation {
    Auto = "auto",
    Horizontal = "horizontal",
    Vertical = "vertical"
}
/**
 * TODO docs
 */
interface OptionsWithTooltip {
    tooltip: VizTooltipOptions;
}
/**
 * TODO docs
 */
interface OptionsWithLegend {
    legend: VizLegendOptions;
}
/**
 * TODO docs
 */
interface OptionsWithTimezones {
    timezone?: Array<TimeZone>;
}
declare const defaultOptionsWithTimezones: Partial<OptionsWithTimezones>;
/**
 * TODO docs
 */
interface OptionsWithTextFormatting {
    text?: VizTextDisplayOptions;
}
/**
 * TODO docs
 */
declare enum BigValueColorMode {
    Background = "background",
    BackgroundSolid = "background_solid",
    None = "none",
    Value = "value"
}
/**
 * TODO docs
 */
declare enum BigValueGraphMode {
    Area = "area",
    Line = "line",
    None = "none"
}
/**
 * TODO docs
 */
declare enum BigValueJustifyMode {
    Auto = "auto",
    Center = "center"
}
/**
 * TODO docs
 */
declare enum BigValueTextMode {
    Auto = "auto",
    Name = "name",
    None = "none",
    Value = "value",
    ValueAndName = "value_and_name"
}
/**
 * TODO -- should not be table specific!
 * TODO docs
 */
declare type FieldTextAlignment = ('auto' | 'left' | 'right' | 'center');
/**
 * Controls the value alignment in the TimelineChart component
 */
declare type TimelineValueAlignment = ('center' | 'left' | 'right');
/**
 * TODO docs
 */
interface VizTextDisplayOptions {
    /**
     * Explicit title text size
     */
    titleSize?: number;
    /**
     * Explicit value text size
     */
    valueSize?: number;
}
/**
 * TODO docs
 */
declare enum TooltipDisplayMode {
    Multi = "multi",
    None = "none",
    Single = "single"
}
/**
 * TODO docs
 */
declare enum SortOrder {
    Ascending = "asc",
    Descending = "desc",
    None = "none"
}
/**
 * TODO docs
 */
interface GraphFieldConfig extends LineConfig, FillConfig, PointsConfig, AxisConfig, BarConfig, StackableFieldConfig, HideableFieldConfig {
    drawStyle?: GraphDrawStyle;
    gradientMode?: GraphGradientMode;
    thresholdsStyle?: GraphThresholdsStyleConfig;
    transform?: GraphTransform;
}
/**
 * TODO docs
 */
interface VizLegendOptions {
    asTable?: boolean;
    calcs: Array<string>;
    displayMode: LegendDisplayMode;
    isVisible?: boolean;
    placement: LegendPlacement;
    showLegend: boolean;
    sortBy?: string;
    sortDesc?: boolean;
    width?: number;
}
declare const defaultVizLegendOptions: Partial<VizLegendOptions>;
/**
 * Enum expressing the possible display modes
 * for the bar gauge component of Grafana UI
 */
declare enum BarGaugeDisplayMode {
    Basic = "basic",
    Gradient = "gradient",
    Lcd = "lcd"
}
/**
 * Allows for the table cell gauge display type to set the gauge mode.
 */
declare enum BarGaugeValueMode {
    Color = "color",
    Hidden = "hidden",
    Text = "text"
}
/**
 * TODO docs
 */
interface VizTooltipOptions {
    mode: TooltipDisplayMode;
    sort: SortOrder;
}
interface Labels {
}
/**
 * Internally, this is the "type" of cell that's being displayed
 * in the table such as colored text, JSON, gauge, etc.
 * The color-background-solid, gradient-gauge, and lcd-gauge
 * modes are deprecated in favor of new cell subOptions
 */
declare enum TableCellDisplayMode {
    Auto = "auto",
    BasicGauge = "basic",
    ColorBackground = "color-background",
    ColorBackgroundSolid = "color-background-solid",
    ColorText = "color-text",
    Gauge = "gauge",
    GradientGauge = "gradient-gauge",
    Image = "image",
    JSONView = "json-view",
    LcdGauge = "lcd-gauge",
    Sparkline = "sparkline"
}
/**
 * Display mode to the "Colored Background" display
 * mode for table cells. Either displays a solid color (basic mode)
 * or a gradient.
 */
declare enum TableCellBackgroundDisplayMode {
    Basic = "basic",
    Gradient = "gradient"
}
/**
 * Sort by field state
 */
interface TableSortByFieldState {
    /**
     * Flag used to indicate descending sort order
     */
    desc?: boolean;
    /**
     * Sets the display name of the field to sort by
     */
    displayName: string;
}
/**
 * Footer options
 */
interface TableFooterOptions {
    countRows?: boolean;
    enablePagination?: boolean;
    fields?: Array<string>;
    reducer: Array<string>;
    show: boolean;
}
declare const defaultTableFooterOptions: Partial<TableFooterOptions>;
/**
 * Auto mode table cell options
 */
interface TableAutoCellOptions {
    type: TableCellDisplayMode.Auto;
}
/**
 * Colored text cell options
 */
interface TableColorTextCellOptions {
    type: TableCellDisplayMode.ColorText;
}
/**
 * Json view cell options
 */
interface TableJsonViewCellOptions {
    type: TableCellDisplayMode.JSONView;
}
/**
 * Json view cell options
 */
interface TableImageCellOptions {
    type: TableCellDisplayMode.Image;
}
/**
 * Gauge cell options
 */
interface TableBarGaugeCellOptions {
    mode?: BarGaugeDisplayMode;
    type: TableCellDisplayMode.Gauge;
    valueDisplayMode?: BarGaugeValueMode;
}
/**
 * Sparkline cell options
 */
interface TableSparklineCellOptions extends GraphFieldConfig {
    type: TableCellDisplayMode.Sparkline;
}
/**
 * Colored background cell options
 */
interface TableColoredBackgroundCellOptions {
    mode?: TableCellBackgroundDisplayMode;
    type: TableCellDisplayMode.ColorBackground;
}
/**
 * Height of a table cell
 */
declare enum TableCellHeight {
    Lg = "lg",
    Md = "md",
    Sm = "sm"
}
/**
 * Table cell options. Each cell has a display mode
 * and other potential options for that display.
 */
declare type TableCellOptions = (TableAutoCellOptions | TableSparklineCellOptions | TableBarGaugeCellOptions | TableColoredBackgroundCellOptions | TableColorTextCellOptions | TableImageCellOptions | TableJsonViewCellOptions);
/**
 * Use UTC/GMT timezone
 */
declare type TimeZoneUtc = 'utc';
/**
 * Use the timezone defined by end user web browser
 */
declare type TimeZoneBrowser = 'browser';
/**
 * Optional formats for the template variable replace functions
 * See also https://grafana.com/docs/grafana/latest/dashboards/variables/variable-syntax/#advanced-variable-format-options
 */
declare enum VariableFormatID {
    CSV = "csv",
    Date = "date",
    Distributed = "distributed",
    DoubleQuote = "doublequote",
    Glob = "glob",
    HTML = "html",
    JSON = "json",
    Lucene = "lucene",
    PercentEncode = "percentencode",
    Pipe = "pipe",
    QueryParam = "queryparam",
    Raw = "raw",
    Regex = "regex",
    SQLString = "sqlstring",
    SingleQuote = "singlequote",
    Text = "text",
    UriEncode = "uriencode"
}
interface DataSourceRef$1 {
    /**
     * The plugin type-id
     */
    type?: string;
    /**
     * Specific datasource instance
     */
    uid?: string;
}
interface TextDimensionConfig$1 extends BaseDimensionConfig$1 {
    mode: TextDimensionMode;
}
interface FrameGeometrySource {
    /**
     * Path to Gazetteer
     */
    gazetteer?: string;
    /**
     * Field mappings
     */
    geohash?: string;
    latitude?: string;
    longitude?: string;
    lookup?: string;
    mode: FrameGeometrySourceMode;
    wkt?: string;
}
interface HeatmapCalculationOptions {
    /**
     * The number of buckets to use for the xAxis in the heatmap
     */
    xBuckets?: HeatmapCalculationBucketConfig;
    /**
     * The number of buckets to use for the yAxis in the heatmap
     */
    yBuckets?: HeatmapCalculationBucketConfig;
}
declare enum LogsDedupStrategy {
    exact = "exact",
    none = "none",
    numbers = "numbers",
    signature = "signature"
}
/**
 * Compare two values
 */
declare enum ComparisonOperation {
    EQ = "eq",
    GT = "gt",
    GTE = "gte",
    LT = "lt",
    LTE = "lte",
    NEQ = "neq"
}
/**
 * Field options for each field within a table (e.g 10, "The String", 64.20, etc.)
 * Generally defines alignment, filtering capabilties, display options, etc.
 */
interface TableFieldOptions {
    align: FieldTextAlignment;
    cellOptions: TableCellOptions;
    /**
     * This field is deprecated in favor of using cellOptions
     */
    displayMode?: TableCellDisplayMode;
    filterable?: boolean;
    hidden?: boolean;
    inspect: boolean;
    minWidth?: number;
    width?: number;
}
/**
 * A specific timezone from https://en.wikipedia.org/wiki/Tz_database
 */
declare type TimeZone = (TimeZoneUtc | TimeZoneBrowser | string);
declare const defaultTimeZone: TimeZone;

/**
 * TODO docs
 */
interface AnnotationTarget {
    limit: number;
    matchAny: boolean;
    tags: Array<string>;
    type: string;
}
declare const defaultAnnotationTarget: Partial<AnnotationTarget>;
/**
 * TODO docs
 * FROM: AnnotationQuery in grafana-data/src/types/annotations.ts
 */
interface AnnotationQuery {
    builtIn: number;
    /**
     * Datasource to use for annotation.
     */
    datasource: {
        type?: string;
        uid?: string;
    };
    /**
     * Whether annotation is enabled.
     */
    enable: boolean;
    /**
     * Whether to hide annotation.
     */
    hide?: boolean;
    /**
     * Annotation icon color.
     */
    iconColor?: string;
    /**
     * Name of annotation.
     */
    name?: string;
    /**
     * Query for annotation data.
     */
    rawQuery?: string;
    showIn: number;
    target?: AnnotationTarget;
    type: string;
}
declare const defaultAnnotationQuery: Partial<AnnotationQuery>;
/**
 * FROM: packages/grafana-data/src/types/templateVars.ts
 * TODO docs
 * TODO what about what's in public/app/features/types.ts?
 * TODO there appear to be a lot of different kinds of [template] vars here? if so need a disjunction
 */
interface VariableModel$1 {
    datasource?: DataSourceRef;
    description?: string;
    error?: Record<string, unknown>;
    global: boolean;
    hide: VariableHide$1;
    id: string;
    index: number;
    label?: string;
    name: string;
    /**
     * TODO: Move this into a separated QueryVariableModel type
     */
    query?: (string | Record<string, unknown>);
    rootStateKey?: string;
    skipUrlSync: boolean;
    state: LoadingState;
    type: VariableType;
}
declare enum VariableHide$1 {
    dontHide = 0,
    hideLabel = 1,
    hideVariable = 2
}
declare enum LoadingState {
    Done = "Done",
    Error = "Error",
    Loading = "Loading",
    NotStarted = "NotStarted",
    Streaming = "Streaming"
}
/**
 * Ref to a DataSource instance
 */
interface DataSourceRef {
    /**
     * The plugin type-id
     */
    type?: string;
    /**
     * Specific datasource instance
     */
    uid?: string;
}
/**
 * FROM public/app/features/dashboard/state/DashboardModels.ts - ish
 * TODO docs
 */
interface DashboardLink {
    asDropdown: boolean;
    icon: string;
    includeVars: boolean;
    keepTime: boolean;
    tags: Array<string>;
    targetBlank: boolean;
    title: string;
    tooltip: string;
    type: DashboardLinkType;
    url: string;
}
declare const defaultDashboardLink: Partial<DashboardLink>;
/**
 * TODO docs
 */
declare type DashboardLinkType = ('link' | 'dashboards');
/**
 * FROM: packages/grafana-data/src/types/templateVars.ts
 * TODO docs
 * TODO this implies some wider pattern/discriminated union, probably?
 */
declare type VariableType = ('query' | 'adhoc' | 'constant' | 'datasource' | 'interval' | 'textbox' | 'custom' | 'system');
/**
 * TODO docs
 */
declare enum FieldColorModeId {
    ContinuousGrYlRd = "continuous-GrYlRd",
    Fixed = "fixed",
    PaletteClassic = "palette-classic",
    PaletteSaturated = "palette-saturated",
    Thresholds = "thresholds"
}
/**
 * TODO docs
 */
declare type FieldColorSeriesByMode = ('min' | 'max' | 'last');
/**
 * TODO docs
 */
interface FieldColor {
    /**
     * Stores the fixed color value if mode is fixed
     */
    fixedColor?: string;
    /**
     * The main color scheme mode
     */
    mode: FieldColorModeId;
    /**
     * Some visualizations need to know how to assign a series color from by value color schemes
     */
    seriesBy?: FieldColorSeriesByMode;
}
interface GridPos {
    /**
     * Panel
     */
    h: number;
    /**
     * true if fixed
     */
    static?: boolean;
    /**
     * Panel
     */
    w: number;
    /**
     * Panel x
     */
    x: number;
    /**
     * Panel y
     */
    y: number;
}
declare const defaultGridPos: Partial<GridPos>;
/**
 * TODO docs
 */
interface Threshold {
    /**
     * TODO docs
     */
    color: string;
    /**
     * Threshold index, an old property that is not needed an should only appear in older dashboards
     */
    index?: number;
    /**
     * TODO docs
     * TODO are the values here enumerable into a disjunction?
     * Some seem to be listed in typescript comment
     */
    state?: string;
    /**
     * TODO docs
     * FIXME the corresponding typescript field is required/non-optional, but nulls currently appear here when serializing -Infinity to JSON
     */
    value?: number;
}
declare enum ThresholdsMode {
    Absolute = "absolute",
    Percentage = "percentage"
}
interface ThresholdsConfig {
    mode: ThresholdsMode;
    /**
     * Must be sorted by 'value', first value is always -Infinity
     */
    steps: Array<Threshold>;
}
declare const defaultThresholdsConfig: Partial<ThresholdsConfig>;
/**
 * TODO docs
 */
declare type ValueMapping = (ValueMap | RangeMap | RegexMap | SpecialValueMap);
/**
 * TODO docs
 */
declare enum MappingType {
    RangeToText = "range",
    RegexToText = "regex",
    SpecialValue = "special",
    ValueToText = "value"
}
/**
 * TODO docs
 */
interface ValueMap {
    options: Record<string, ValueMappingResult>;
    type: MappingType.ValueToText;
}
/**
 * TODO docs
 */
interface RangeMap {
    options: {
        /**
         * to and from are `number | null` in current ts, really not sure what to do
         */
        from: number;
        to: number;
        result: ValueMappingResult;
    };
    type: MappingType.RangeToText;
}
/**
 * TODO docs
 */
interface RegexMap {
    options: {
        pattern: string;
        result: ValueMappingResult;
    };
    type: MappingType.RegexToText;
}
/**
 * TODO docs
 */
interface SpecialValueMap {
    options: {
        match: ('true' | 'false');
        pattern: string;
        result: ValueMappingResult;
    };
    type: MappingType.SpecialValue;
}
/**
 * TODO docs
 */
declare enum SpecialValueMatch {
    Empty = "empty",
    False = "false",
    NaN = "nan",
    Null = "null",
    NullAndNan = "null+nan",
    True = "true"
}
/**
 * TODO docs
 */
interface ValueMappingResult {
    color?: string;
    icon?: string;
    index?: number;
    text?: string;
}
/**
 * TODO docs
 */
interface DataTransformerConfig$1 {
    /**
     * Disabled transformations are skipped
     */
    disabled?: boolean;
    /**
     * Optional frame matcher.  When missing it will be applied to all results
     */
    filter?: MatcherConfig$1;
    /**
     * Unique identifier of transformer
     */
    id: string;
    /**
     * Options to be passed to the transformer
     * Valid options depend on the transformer id
     */
    options: unknown;
}
/**
 * 0 for no shared crosshair or tooltip (default).
 * 1 for shared crosshair.
 * 2 for shared crosshair AND shared tooltip.
 */
declare enum DashboardCursorSync {
    Crosshair = 1,
    Off = 0,
    Tooltip = 2
}
declare const defaultDashboardCursorSync: DashboardCursorSync;
/**
 * Dashboard panels. Panels are canonically defined inline
 * because they share a version timeline with the dashboard
 * schema; they do not evolve independently.
 */
interface Panel$1 {
    /**
     * The datasource used in all targets.
     */
    datasource?: {
        type?: string;
        uid?: string;
    };
    /**
     * Description.
     */
    description?: string;
    fieldConfig: FieldConfigSource$1;
    /**
     * Grid position.
     */
    gridPos?: GridPos;
    /**
     * TODO docs
     */
    id?: number;
    /**
     * TODO docs
     * TODO tighter constraint
     */
    interval?: string;
    /**
     * Dynamically load the panel
     */
    libraryPanel?: LibraryPanelRef;
    /**
     * Panel links.
     * TODO fill this out - seems there are a couple variants?
     */
    links?: Array<DashboardLink>;
    /**
     * TODO docs
     */
    maxDataPoints?: number;
    /**
     * options is specified by the PanelOptions field in panel
     * plugin schemas.
     */
    options: Record<string, unknown>;
    /**
     * FIXME this almost certainly has to be changed in favor of scuemata versions
     */
    pluginVersion?: string;
    /**
     * Name of template variable to repeat for.
     */
    repeat?: string;
    /**
     * Direction to repeat in if 'repeat' is set.
     * "h" for horizontal, "v" for vertical.
     * TODO this is probably optional
     */
    repeatDirection: ('h' | 'v');
    /**
     * Id of the repeating panel.
     */
    repeatPanelId?: number;
    /**
     * TODO docs
     */
    tags?: Array<string>;
    /**
     * TODO docs
     */
    targets?: Array<Record<string, unknown>>;
    /**
     * TODO docs - seems to be an old field from old dashboard alerts?
     */
    thresholds?: Array<unknown>;
    /**
     * TODO docs
     * TODO tighter constraint
     */
    timeFrom?: string;
    /**
     * TODO docs
     */
    timeRegions?: Array<unknown>;
    /**
     * TODO docs
     * TODO tighter constraint
     */
    timeShift?: string;
    /**
     * Panel title.
     */
    title?: string;
    transformations: Array<DataTransformerConfig$1>;
    /**
     * Whether to display the panel without a background.
     */
    transparent: boolean;
    /**
     * The panel plugin type id. May not be empty.
     */
    type: string;
}
interface FieldConfigSource$1 {
    defaults: FieldConfig$1;
    overrides: Array<{
        matcher: MatcherConfig$1;
        properties: Array<{
            id: string;
            value?: unknown;
        }>;
    }>;
}
interface LibraryPanelRef {
    name: string;
    uid: string;
}
interface MatcherConfig$1 {
    id: string;
    options?: unknown;
}
interface FieldConfig$1 {
    /**
     * Map values to a display color
     */
    color?: FieldColor;
    /**
     * custom is specified by the PanelFieldConfig field
     * in panel plugin schemas.
     */
    custom?: Record<string, unknown>;
    /**
     * Significant digits (for display)
     */
    decimals?: number;
    /**
     * Human readable field metadata
     */
    description?: string;
    /**
     * The display value for this field.  This supports template variables blank is auto
     */
    displayName?: string;
    /**
     * This can be used by data sources that return and explicit naming structure for values and labels
     * When this property is configured, this value is used rather than the default naming strategy.
     */
    displayNameFromDS?: string;
    /**
     * True if data source field supports ad-hoc filters
     */
    filterable?: boolean;
    /**
     * The behavior when clicking on a result
     */
    links?: Array<unknown>;
    /**
     * Convert input values into a display string
     */
    mappings?: Array<ValueMapping>;
    max?: number;
    min?: number;
    /**
     * Alternative to empty string
     */
    noValue?: string;
    /**
     * An explicit path to the field in the datasource.  When the frame meta includes a path,
     * This will default to `${frame.meta.path}/${field.name}
     *
     * When defined, this value can be used as an identifier within the datasource scope, and
     * may be used to update the results
     */
    path?: string;
    /**
     * Map numeric values to states
     */
    thresholds?: ThresholdsConfig;
    /**
     * Numeric Options
     */
    unit?: string;
    /**
     * True if data source can write a value to the path.  Auth/authz are supported separately
     */
    writeable?: boolean;
}
/**
 * Row panel
 */
interface RowPanel {
    collapsed: boolean;
    /**
     * Name of default datasource.
     */
    datasource?: {
        type?: string;
        uid?: string;
    };
    gridPos?: GridPos;
    id: number;
    panels: Array<(Panel$1 | GraphPanel | HeatmapPanel)>;
    /**
     * Name of template variable to repeat for.
     */
    repeat?: string;
    title?: string;
    type: 'row';
}
declare const defaultRowPanel: Partial<RowPanel>;
/**
 * Support for legacy graph and heatmap panels.
 */
interface GraphPanel {
    /**
     * @deprecated this is part of deprecated graph panel
     */
    legend?: {
        show: boolean;
        sort?: string;
        sortDesc?: boolean;
    };
    type: 'graph';
}
interface HeatmapPanel {
    type: 'heatmap';
}
interface Dashboard$1 {
    /**
     * TODO docs
     */
    annotations?: {
        list?: Array<AnnotationQuery>;
    };
    /**
     * Description of dashboard.
     */
    description?: string;
    /**
     * Whether a dashboard is editable or not.
     */
    editable: boolean;
    /**
     * The month that the fiscal year starts on.  0 = January, 11 = December
     */
    fiscalYearStartMonth?: number;
    /**
     * For dashboards imported from the https://grafana.com/grafana/dashboards/ portal
     */
    gnetId?: string;
    /**
     * Configuration of dashboard cursor sync behavior.
     */
    graphTooltip: DashboardCursorSync;
    /**
     * Unique numeric identifier for the dashboard.
     * TODO must isolate or remove identifiers local to a Grafana instance...?
     */
    id?: number;
    /**
     * TODO docs
     */
    links?: Array<DashboardLink>;
    /**
     * When set to true, the dashboard will redraw panels at an interval matching the pixel width.
     * This will keep data "moving left" regardless of the query refresh rate.  This setting helps
     * avoid dashboards presenting stale live data
     */
    liveNow?: boolean;
    panels?: Array<(Panel$1 | RowPanel | GraphPanel | HeatmapPanel)>;
    /**
     * Refresh rate of dashboard. Represented via interval string, e.g. "5s", "1m", "1h", "1d".
     */
    refresh?: (string | false);
    /**
     * This property should only be used in dashboards defined by plugins.  It is a quick check
     * to see if the version has changed since the last time.  Unclear why using the version property
     * is insufficient.
     */
    revision?: number;
    /**
     * Version of the JSON schema, incremented each time a Grafana update brings
     * changes to said schema.
     * TODO this is the existing schema numbering system. It will be replaced by Thema's themaVersion
     */
    schemaVersion: number;
    snapshot?: {
        /**
         * TODO docs
         */
        created: string;
        /**
         * TODO docs
         */
        expires: string;
        /**
         * TODO docs
         */
        external: boolean;
        /**
         * TODO docs
         */
        externalUrl: string;
        /**
         * TODO docs
         */
        id: number;
        /**
         * TODO docs
         */
        key: string;
        /**
         * TODO docs
         */
        name: string;
        /**
         * TODO docs
         */
        orgId: number;
        /**
         * TODO docs
         */
        updated: string;
        /**
         * TODO docs
         */
        url?: string;
        /**
         * TODO docs
         */
        userId: number;
    };
    /**
     * Theme of dashboard.
     */
    style: ('light' | 'dark');
    /**
     * Tags associated with dashboard.
     */
    tags?: Array<string>;
    /**
     * TODO docs
     */
    templating?: {
        list?: Array<VariableModel$1>;
    };
    /**
     * Time range for dashboard, e.g. last 6 hours, last 7 days, etc
     */
    time?: {
        from: string;
        to: string;
    };
    /**
     * TODO docs
     * TODO this appears to be spread all over in the frontend. Concepts will likely need tidying in tandem with schema changes
     */
    timepicker?: {
        /**
         * Whether timepicker is collapsed or not.
         */
        collapse: boolean;
        /**
         * Whether timepicker is enabled or not.
         */
        enable: boolean;
        /**
         * Whether timepicker is visible or not.
         */
        hidden: boolean;
        /**
         * Selectable intervals for auto-refresh.
         */
        refresh_intervals: Array<string>;
        /**
         * TODO docs
         */
        time_options: Array<string>;
    };
    /**
     * Timezone of dashboard. Accepts IANA TZDB zone ID or "browser" or "utc".
     */
    timezone?: string;
    /**
     * Title of dashboard.
     */
    title?: string;
    /**
     * Unique dashboard identifier that can be generated by anyone. string (8-40)
     */
    uid?: string;
    /**
     * Version of the dashboard, incremented each time the dashboard is updated.
     */
    version?: number;
    /**
     * TODO docs
     */
    weekStart?: string;
}

interface Panel<TOptions = Record<string, unknown>, TCustomFieldConfig = Record<string, unknown>> extends Panel$1 {
    fieldConfig: FieldConfigSource<TCustomFieldConfig>;
}
declare enum VariableHide {
    dontHide = 0,
    hideLabel = 1,
    hideVariable = 2
}
interface VariableModel extends Omit<VariableModel$1, 'rootStateKey' | 'error' | 'description' | 'hide' | 'datasource'> {
    rootStateKey: string | null;
    error: any | null;
    description: string | null;
    hide: VariableHide;
    datasource: DataSourceRef$1 | null;
}
interface Dashboard extends Omit<Dashboard$1, 'templating'> {
    panels?: Array<Panel | RowPanel | GraphPanel | HeatmapPanel>;
    templating?: {
        list?: VariableModel[];
    };
}
interface FieldConfig<TOptions = Record<string, unknown>> extends FieldConfig$1 {
    custom?: TOptions & Record<string, unknown>;
}
interface FieldConfigSource<TOptions = Record<string, unknown>> extends FieldConfigSource$1 {
    defaults: FieldConfig<TOptions>;
}
interface MatcherConfig<TConfig = any> extends MatcherConfig$1 {
    options?: TConfig;
}
interface DataTransformerConfig<TOptions = any> extends DataTransformerConfig$1 {
    options: TOptions;
}
declare const defaultDashboard: Dashboard;
declare const defaultVariableModel: VariableModel;
declare const defaultPanel: Partial<Panel>;
declare const defaultFieldConfig: Partial<FieldConfig>;
declare const defaultFieldConfigSource: Partial<FieldConfigSource>;
declare const defaultMatcherConfig: Partial<MatcherConfig>;

interface MapLayerOptions<TConfig = any> extends MapLayerOptions$1 {
    config?: TConfig;
    filterData?: MatcherConfig;
}
interface DataQuery extends DataQuery$1 {
    /**
     * Unique, guid like, string (used only in explore mode)
     */
    key?: string;
    datasource?: DataSourceRef$1 | null;
}
interface BaseDimensionConfig<T = string | number> extends Omit<BaseDimensionConfig$1, 'fixed'> {
    fixed: T;
}
interface ScaleDimensionConfig extends BaseDimensionConfig<number>, Omit<ScaleDimensionConfig$1, 'fixed'> {
}
interface TextDimensionConfig extends BaseDimensionConfig<string>, Omit<TextDimensionConfig$1, 'fixed'> {
}
interface ColorDimensionConfig extends BaseDimensionConfig<string>, Omit<ColorDimensionConfig$1, 'fixed'> {
}

declare const defaultTableFieldOptions: TableFieldOptions;

interface LibraryElementDTOMetaUser {
    avatarUrl: string;
    id: number;
    name: string;
}
interface LibraryElementDTOMeta {
    connectedDashboards: number;
    created: string;
    createdBy: LibraryElementDTOMetaUser;
    folderName: string;
    folderUid: string;
    updated: string;
    updatedBy: LibraryElementDTOMetaUser;
}
interface LibraryPanel$1 {
    /**
     * Panel description
     */
    description?: string;
    /**
     * Folder UID
     */
    folderUid?: string;
    /**
     * Object storage metadata
     */
    meta?: LibraryElementDTOMeta;
    /**
     * TODO: should be the same panel schema defined in dashboard
     * Typescript: Omit<Panel, 'gridPos' | 'id' | 'libraryPanel'>;
     */
    model: Record<string, unknown>;
    /**
     * Panel name (also saved in the model)
     */
    name: string;
    /**
     * Dashboard version when this was saved (zero if unknown)
     */
    schemaVersion?: number;
    /**
     * The panel type (from inside the model)
     */
    type: string;
    /**
     * Library element UID
     */
    uid: string;
    /**
     * panel version, incremented each time the dashboard is updated.
     */
    version: number;
}

interface LibraryPanel extends LibraryPanel$1 {
    model: Omit<Panel, 'gridPos' | 'id' | 'libraryPanel'>;
}

interface PlaylistItem {
    /**
     * Title is an unused property -- it will be removed in the future
     */
    title?: string;
    /**
     * Type of the item.
     */
    type: ('dashboard_by_uid' | 'dashboard_by_id' | 'dashboard_by_tag');
    /**
     * Value depends on type and describes the playlist item.
     *
     *  - dashboard_by_id: The value is an internal numerical identifier set by Grafana. This
     *  is not portable as the numerical identifier is non-deterministic between different instances.
     *  Will be replaced by dashboard_by_uid in the future. (deprecated)
     *  - dashboard_by_tag: The value is a tag which is set on any number of dashboards. All
     *  dashboards behind the tag will be added to the playlist.
     *  - dashboard_by_uid: The value is the dashboard UID
     */
    value: string;
}
interface Playlist {
    /**
     * Interval sets the time between switching views in a playlist.
     * FIXME: Is this based on a standardized format or what options are available? Can datemath be used?
     */
    interval: string;
    /**
     * The ordered list of items that the playlist will iterate over.
     * FIXME! This should not be optional, but changing it makes the godegen awkward
     */
    items?: Array<PlaylistItem>;
    /**
     * Name of the playlist.
     */
    name: string;
    /**
     * Unique playlist identifier. Generated on creation, either by the
     * creator of the playlist of by the application.
     */
    uid: string;
}
declare const defaultPlaylist: Partial<Playlist>;

interface QueryHistoryPreference {
    /**
     * one of: '' | 'query' | 'starred';
     */
    homeTab?: string;
}
interface Preferences {
    /**
     * UID for the home dashboard
     */
    homeDashboardUID?: string;
    /**
     * Selected language (beta)
     */
    language?: string;
    /**
     * Explore query history preferences
     */
    queryHistory?: QueryHistoryPreference;
    /**
     * light, dark, empty is default
     */
    theme?: string;
    /**
     * The timezone selection
     * TODO: this should use the timezone defined in common
     */
    timezone?: string;
    /**
     * day of the week (sunday, monday, etc)
     */
    weekStart?: string;
}

interface PublicDashboard {
    /**
     * Unique public access token
     */
    accessToken?: string;
    /**
     * Flag that indicates if annotations are enabled
     */
    annotationsEnabled: boolean;
    /**
     * Dashboard unique identifier referenced by this public dashboard
     */
    dashboardUid: string;
    /**
     * Flag that indicates if the public dashboard is enabled
     */
    isEnabled: boolean;
    /**
     * Flag that indicates if the time range picker is enabled
     */
    timeSelectionEnabled: boolean;
    /**
     * Unique public dashboard identifier
     */
    uid: string;
}

/**
 * OrgRole is a Grafana Organization Role which can be 'Viewer', 'Editor', 'Admin'.
 */
declare type OrgRole = ('Admin' | 'Editor' | 'Viewer');
interface ServiceAccount {
    /**
     * AccessControl metadata associated with a given resource.
     */
    accessControl?: Record<string, boolean>;
    /**
     * AvatarUrl is the service account's avatar URL. It allows the frontend to display a picture in front
     * of the service account.
     */
    avatarUrl: string;
    /**
     * Created indicates when the service account was created.
     */
    created?: string;
    /**
     * ID is the unique identifier of the service account in the database.
     */
    id: number;
    /**
     * IsDisabled indicates if the service account is disabled.
     */
    isDisabled: boolean;
    /**
     * Login of the service account.
     */
    login: string;
    /**
     * Name of the service account.
     */
    name: string;
    /**
     * OrgId is the ID of an organisation the service account belongs to.
     */
    orgId: number;
    /**
     * Role is the Grafana organization role of the service account which can be 'Viewer', 'Editor', 'Admin'.
     */
    role: OrgRole;
    /**
     * Teams is a list of teams the service account belongs to.
     */
    teams?: Array<string>;
    /**
     * Tokens is the number of active tokens for the service account.
     * Tokens are used to authenticate the service account against Grafana.
     */
    tokens: number;
    /**
     * Updated indicates when the service account was updated.
     */
    updated?: string;
}
declare const defaultServiceAccount: Partial<ServiceAccount>;

declare enum Permission {
    Admin = 4,
    Editor = 2,
    Member = 0,
    Viewer = 1
}
interface Team {
    /**
     * AccessControl metadata associated with a given resource.
     */
    accessControl?: Record<string, boolean>;
    /**
     * AvatarUrl is the team's avatar URL.
     */
    avatarUrl?: string;
    /**
     * Created indicates when the team was created.
     */
    created: string;
    /**
     * Email of the team.
     */
    email?: string;
    /**
     * MemberCount is the number of the team members.
     */
    memberCount: number;
    /**
     * Name of the team.
     */
    name: string;
    /**
     * OrgId is the ID of an organisation the team belongs to.
     */
    orgId: number;
    /**
     * TODO - it seems it's a team_member.permission, unlikely it should belong to the team kind
     */
    permission: Permission;
    /**
     * Updated indicates when the team was updated.
     */
    updated: string;
}

export { AnnotationQuery, AnnotationTarget, AxisColorMode, AxisConfig, AxisPlacement, BarAlignment, BarConfig, BarGaugeDisplayMode, BarGaugeValueMode, BaseDimensionConfig, BigValueColorMode, BigValueGraphMode, BigValueJustifyMode, BigValueTextMode, ColorDimensionConfig, ComparisonOperation, Dashboard, DashboardCursorSync, DashboardLink, DashboardLinkType, DataQuery, DataSourceJsonData, DataSourceRef$1 as DataSourceRef, DataTransformerConfig, FieldColor, FieldColorModeId, FieldColorSeriesByMode, FieldConfig, FieldConfigSource, FieldTextAlignment, FillConfig, FrameGeometrySource, FrameGeometrySourceMode, GraphDrawStyle, GraphFieldConfig, GraphGradientMode, GraphPanel, GraphThresholdsStyleConfig, GraphTransform, GraphTresholdsStyleMode, GridPos, HeatmapCalculationBucketConfig, HeatmapCalculationMode, HeatmapCalculationOptions, HeatmapCellLayout, HeatmapPanel, HideSeriesConfig, HideableFieldConfig, Labels, LegendDisplayMode, LegendPlacement, LibraryElementDTOMeta, LibraryElementDTOMetaUser, LibraryPanel, LibraryPanelRef, LineConfig, LineInterpolation, LineStyle, LoadingState, LogsDedupStrategy, LogsSortOrder, MapLayerOptions, MappingType, MatcherConfig, OptionsWithLegend, OptionsWithTextFormatting, OptionsWithTimezones, OptionsWithTooltip, OrgRole, Panel, Permission, Playlist, PlaylistItem, PointsConfig, Preferences, PublicDashboard, QueryHistoryPreference, RangeMap, ReduceDataOptions, RegexMap, RowPanel, ScaleDimensionConfig, ScaleDirection, ScaleDistribution, ScaleDistributionConfig, ScaleOrientation, ServiceAccount, SingleStatBaseOptions, SortOrder, SpecialValueMap, SpecialValueMatch, StackableFieldConfig, StackingConfig, StackingMode, TableAutoCellOptions, TableBarGaugeCellOptions, TableCellBackgroundDisplayMode, TableCellDisplayMode, TableCellHeight, TableCellOptions, TableColorTextCellOptions, TableColoredBackgroundCellOptions, TableFieldOptions, TableFooterOptions, TableImageCellOptions, TableJsonViewCellOptions, TableSortByFieldState, TableSparklineCellOptions, Team, TextDimensionConfig, TextDimensionMode, Threshold, ThresholdsConfig, ThresholdsMode, TimeZone, TimeZoneBrowser, TimeZoneUtc, TimelineValueAlignment, TooltipDisplayMode, ValueMap, ValueMapping, ValueMappingResult, VariableFormatID, VariableHide, VariableModel, VariableType, VisibilityMode, VizLegendOptions, VizOrientation, VizTextDisplayOptions, VizTooltipOptions, defaultAnnotationQuery, defaultAnnotationTarget, defaultDashboard, defaultDashboardCursorSync, defaultDashboardLink, defaultFieldConfig, defaultFieldConfigSource, defaultGridPos, defaultLineStyle, defaultMatcherConfig, defaultOptionsWithTimezones, defaultPanel, defaultPlaylist, defaultReduceDataOptions, defaultRowPanel, defaultServiceAccount, defaultTableFieldOptions, defaultTableFooterOptions, defaultThresholdsConfig, defaultTimeZone, defaultVariableModel, defaultVizLegendOptions };
