import System from 'systemjs/dist/system.js';
import { config } from '../config.js';

const SystemJS = System;
function loadPluginCss(options) {
  const theme = config.bootData.user.lightTheme ? options.light : options.dark;
  return SystemJS.import(`${theme}!css`);
}
let pluginImportUtils;
function setPluginImportUtils(utils) {
  if (pluginImportUtils) {
    throw new Error("pluginImportUtils should only be set once, when Grafana is starting.");
  }
  pluginImportUtils = utils;
}
function getPluginImportUtils() {
  if (!pluginImportUtils) {
    throw new Error("pluginImportUtils can only be used after Grafana instance has started.");
  }
  return pluginImportUtils;
}

export { SystemJS, getPluginImportUtils, loadPluginCss, setPluginImportUtils };
//# sourceMappingURL=plugin.js.map
