/**
 * A string selector
 *
 * @alpha
 */
declare type StringSelector = string;
/**
 * A function selector with an argument
 *
 * @alpha
 */
declare type FunctionSelector = (id: string) => string;
/**
 * A function selector without argument
 *
 * @alpha
 */
declare type CssSelector = () => string;
/**
 * @alpha
 */
interface Selectors {
    [key: string]: StringSelector | FunctionSelector | CssSelector | UrlSelector | Selectors;
}
/**
 * @alpha
 */
declare type E2ESelectors<S extends Selectors> = {
    [P in keyof S]: S[P];
};
/**
 * @alpha
 */
interface UrlSelector extends Selectors {
    url: string | FunctionSelector;
}

/**
 * Selectors grouped/defined in Components
 *
 * @alpha
 */
declare const Components: {
    Breadcrumbs: {
        breadcrumb: (title: string) => string;
    };
    TimePicker: {
        openButton: string;
        fromField: string;
        toField: string;
        applyTimeRange: string;
        calendar: {
            label: string;
            openButton: string;
            closeButton: string;
        };
        absoluteTimeRangeTitle: string;
    };
    DataSourcePermissions: {
        form: () => string;
        roleType: string;
        rolePicker: string;
        permissionLevel: string;
    };
    DataSource: {
        TestData: {
            QueryTab: {
                scenarioSelectContainer: string;
                scenarioSelect: string;
                max: string;
                min: string;
                noise: string;
                seriesCount: string;
                spread: string;
                startValue: string;
                drop: string;
            };
        };
        DataSourceHttpSettings: {
            urlInput: string;
        };
        Jaeger: {
            traceIDInput: string;
        };
        Prometheus: {
            configPage: {
                exemplarsAddButton: string;
                internalLinkSwitch: string;
            };
            exemplarMarker: string;
        };
    };
    Menu: {
        MenuComponent: (title: string) => string;
        MenuGroup: (title: string) => string;
        MenuItem: (title: string) => string;
        SubMenu: {
            container: string;
            icon: string;
        };
    };
    Panels: {
        Panel: {
            title: (title: string) => string;
            headerItems: (item: string) => string;
            menuItems: (item: string) => string;
            menu: (title: string) => string;
            containerByTitle: (title: string) => string;
            headerCornerInfo: (mode: string) => string;
        };
        Visualization: {
            Graph: {
                container: string;
                VisualizationTab: {
                    legendSection: string;
                };
                Legend: {
                    legendItemAlias: (name: string) => string;
                    showLegendSwitch: string;
                };
                xAxis: {
                    labels: () => string;
                };
            };
            BarGauge: {
                /**
                 * @deprecated use valueV2 from Grafana 8.3 instead
                 */
                value: string;
                valueV2: string;
            };
            PieChart: {
                svgSlice: string;
            };
            Text: {
                container: () => string;
            };
            Table: {
                header: string;
                footer: string;
            };
        };
    };
    VizLegend: {
        seriesName: (name: string) => string;
    };
    Drawer: {
        General: {
            title: (title: string) => string;
            expand: string;
            contract: string;
            close: string;
            rcContentWrapper: () => string;
        };
    };
    PanelEditor: {
        General: {
            content: string;
        };
        OptionsPane: {
            content: string;
            select: string;
            fieldLabel: (type: string) => string;
        };
        DataPane: {
            content: string;
        };
        applyButton: string;
        toggleVizPicker: string;
        toggleVizOptions: string;
        toggleTableView: string;
        measureButton: string;
    };
    PanelInspector: {
        Data: {
            content: string;
        };
        Stats: {
            content: string;
        };
        Json: {
            content: string;
        };
        Query: {
            content: string;
            refreshButton: string;
            jsonObjectKeys: () => string;
        };
    };
    Tab: {
        title: (title: string) => string;
        active: () => string;
    };
    RefreshPicker: {
        /**
         * @deprecated use runButtonV2 from Grafana 8.3 instead
         */
        runButton: string;
        /**
         * @deprecated use intervalButtonV2 from Grafana 8.3 instead
         */
        intervalButton: string;
        runButtonV2: string;
        intervalButtonV2: string;
    };
    QueryTab: {
        content: string;
        queryInspectorButton: string;
        queryHistoryButton: string;
        addQuery: string;
    };
    QueryHistory: {
        queryText: string;
    };
    QueryEditorRows: {
        rows: string;
    };
    QueryEditorRow: {
        actionButton: (title: string) => string;
        title: (refId: string) => string;
        container: (refId: string) => string;
    };
    AlertTab: {
        content: string;
    };
    Alert: {
        /**
         * @deprecated use alertV2 from Grafana 8.3 instead
         */
        alert: (severity: string) => string;
        alertV2: (severity: string) => string;
    };
    TransformTab: {
        content: string;
        newTransform: (name: string) => string;
        transformationEditor: (name: string) => string;
        transformationEditorDebugger: (name: string) => string;
    };
    Transforms: {
        card: (name: string) => string;
        Reduce: {
            modeLabel: string;
            calculationsLabel: string;
        };
        SpatialOperations: {
            actionLabel: string;
            locationLabel: string;
            location: {
                autoOption: string;
                coords: {
                    option: string;
                    latitudeFieldLabel: string;
                    longitudeFieldLabel: string;
                };
                geohash: {
                    option: string;
                    geohashFieldLabel: string;
                };
                lookup: {
                    option: string;
                    lookupFieldLabel: string;
                    gazetteerFieldLabel: string;
                };
            };
        };
        searchInput: string;
    };
    NavBar: {
        Configuration: {
            button: string;
        };
        Toggle: {
            button: string;
        };
        Reporting: {
            button: string;
        };
    };
    NavMenu: {
        item: string;
    };
    NavToolbar: {
        container: string;
    };
    PageToolbar: {
        container: () => string;
        item: (tooltip: string) => string;
        itemButton: (title: string) => string;
    };
    QueryEditorToolbarItem: {
        button: (title: string) => string;
    };
    BackButton: {
        backArrow: string;
    };
    OptionsGroup: {
        group: (title?: string) => string;
        toggle: (title?: string) => string;
    };
    PluginVisualization: {
        item: (title: string) => string;
        current: () => string;
    };
    Select: {
        option: string;
        input: () => string;
        singleValue: () => string;
    };
    FieldConfigEditor: {
        content: string;
    };
    OverridesConfigEditor: {
        content: string;
    };
    FolderPicker: {
        /**
         * @deprecated use containerV2 from Grafana 8.3 instead
         */
        container: string;
        containerV2: string;
        input: string;
    };
    ReadonlyFolderPicker: {
        container: string;
    };
    DataSourcePicker: {
        container: string;
        /**
         * @deprecated use inputV2 instead
         */
        input: () => string;
        inputV2: string;
    };
    TimeZonePicker: {
        /**
         * @deprecated use TimeZonePicker.containerV2 from Grafana 8.3 instead
         */
        container: string;
        containerV2: string;
    };
    WeekStartPicker: {
        /**
         * @deprecated use WeekStartPicker.containerV2 from Grafana 8.3 instead
         */
        container: string;
        containerV2: string;
        placeholder: string;
    };
    TraceViewer: {
        spanBar: string;
    };
    QueryField: {
        container: string;
    };
    QueryBuilder: {
        queryPatterns: string;
        labelSelect: string;
        valueSelect: string;
        matchOperatorSelect: string;
    };
    ValuePicker: {
        button: (name: string) => string;
        select: (name: string) => string;
    };
    Search: {
        /**
         * @deprecated use sectionV2 from Grafana 8.3 instead
         */
        section: string;
        sectionV2: string;
        /**
         * @deprecated use itemsV2 from Grafana 8.3 instead
         */
        items: string;
        itemsV2: string;
        cards: string;
        collapseFolder: (sectionId: string) => string;
        expandFolder: (sectionId: string) => string;
        dashboardItem: (item: string) => string;
        dashboardCard: (item: string) => string;
        folderHeader: (folderName: string) => string;
        folderContent: (folderName: string) => string;
        dashboardItems: string;
    };
    DashboardLinks: {
        container: string;
        dropDown: string;
        link: string;
    };
    LoadingIndicator: {
        icon: string;
    };
    CallToActionCard: {
        /**
         * @deprecated use buttonV2 from Grafana 8.3 instead
         */
        button: (name: string) => string;
        buttonV2: (name: string) => string;
    };
    DataLinksContextMenu: {
        singleLink: string;
    };
    CodeEditor: {
        container: string;
    };
    DashboardImportPage: {
        textarea: string;
        submit: string;
    };
    ImportDashboardForm: {
        name: string;
        submit: string;
    };
    PanelAlertTabContent: {
        content: string;
    };
    VisualizationPreview: {
        card: (name: string) => string;
    };
    ColorSwatch: {
        name: string;
    };
    DashboardRow: {
        title: (title: string) => string;
    };
    UserProfile: {
        profileSaveButton: string;
        preferencesSaveButton: string;
        orgsTable: string;
        sessionsTable: string;
    };
    FileUpload: {
        inputField: string;
        fileNameSpan: string;
    };
    DebugOverlay: {
        wrapper: string;
    };
    OrgRolePicker: {
        input: string;
    };
    AnalyticsToolbarButton: {
        button: string;
    };
    Variables: {
        variableOption: string;
    };
};

/**
 * Selectors grouped/defined in Pages
 *
 * @alpha
 */
declare const Pages: {
    Login: {
        url: string;
        username: string;
        password: string;
        submit: string;
        skip: string;
    };
    Home: {
        url: string;
    };
    DataSource: {
        name: string;
        delete: string;
        readOnly: string;
        saveAndTest: string;
        alert: string;
    };
    DataSources: {
        url: string;
        dataSources: (dataSourceName: string) => string;
    };
    EditDataSource: {
        url: (dataSourceUid: string) => string;
        settings: string;
    };
    AddDataSource: {
        url: string;
        /** @deprecated Use dataSourcePluginsV2 */
        dataSourcePlugins: (pluginName: string) => string;
        dataSourcePluginsV2: (pluginName: string) => string;
    };
    ConfirmModal: {
        delete: string;
    };
    AddDashboard: {
        url: string;
        itemButton: (title: string) => string;
        addNewPanel: string;
        addNewRow: string;
        addNewPanelLibrary: string;
    };
    Dashboard: {
        url: (uid: string) => string;
        DashNav: {
            /**
             * @deprecated use navV2 from Grafana 8.3 instead
             */
            nav: string;
            navV2: string;
            publicDashboardTag: string;
        };
        SubMenu: {
            submenu: string;
            submenuItem: string;
            submenuItemLabels: (item: string) => string;
            submenuItemValueDropDownValueLinkTexts: (item: string) => string;
            submenuItemValueDropDownDropDown: string;
            submenuItemValueDropDownOptionTexts: (item: string) => string;
        };
        Settings: {
            Actions: {
                close: string;
            };
            General: {
                deleteDashBoard: string;
                sectionItems: (item: string) => string;
                saveDashBoard: string;
                saveAsDashBoard: string;
                /**
                 * @deprecated use components.TimeZonePicker.containerV2 from Grafana 8.3 instead
                 */
                timezone: string;
                title: string;
            };
            Annotations: {
                List: {
                    /**
                     * @deprecated use addAnnotationCTAV2 from Grafana 8.3 instead
                     */
                    addAnnotationCTA: string;
                    addAnnotationCTAV2: string;
                };
                Settings: {
                    name: string;
                };
            };
            Variables: {
                List: {
                    /**
                     * @deprecated use addVariableCTAV2 from Grafana 8.3 instead
                     */
                    addVariableCTA: string;
                    addVariableCTAV2: string;
                    newButton: string;
                    table: string;
                    tableRowNameFields: (variableName: string) => string;
                    tableRowDefinitionFields: (variableName: string) => string;
                    tableRowArrowUpButtons: (variableName: string) => string;
                    tableRowArrowDownButtons: (variableName: string) => string;
                    tableRowDuplicateButtons: (variableName: string) => string;
                    tableRowRemoveButtons: (variableName: string) => string;
                };
                Edit: {
                    General: {
                        headerLink: string;
                        modeLabelNew: string;
                        /**
                         * @deprecated
                         */
                        modeLabelEdit: string;
                        generalNameInput: string;
                        generalNameInputV2: string;
                        generalTypeSelect: string;
                        generalTypeSelectV2: string;
                        generalLabelInput: string;
                        generalLabelInputV2: string;
                        generalHideSelect: string;
                        generalHideSelectV2: string;
                        selectionOptionsMultiSwitch: string;
                        selectionOptionsIncludeAllSwitch: string;
                        selectionOptionsCustomAllInput: string;
                        selectionOptionsCustomAllInputV2: string;
                        previewOfValuesOption: string;
                        submitButton: string;
                        applyButton: string;
                    };
                    QueryVariable: {
                        queryOptionsDataSourceSelect: string;
                        queryOptionsRefreshSelect: string;
                        queryOptionsRefreshSelectV2: string;
                        queryOptionsRegExInput: string;
                        queryOptionsRegExInputV2: string;
                        queryOptionsSortSelect: string;
                        queryOptionsSortSelectV2: string;
                        queryOptionsQueryInput: string;
                        valueGroupsTagsEnabledSwitch: string;
                        valueGroupsTagsTagsQueryInput: string;
                        valueGroupsTagsTagsValuesQueryInput: string;
                    };
                    ConstantVariable: {
                        constantOptionsQueryInput: string;
                        constantOptionsQueryInputV2: string;
                    };
                    DatasourceVariable: {
                        datasourceSelect: string;
                    };
                    TextBoxVariable: {
                        textBoxOptionsQueryInput: string;
                        textBoxOptionsQueryInputV2: string;
                    };
                    CustomVariable: {
                        customValueInput: string;
                    };
                    IntervalVariable: {
                        intervalsValueInput: string;
                    };
                };
            };
        };
    };
    Dashboards: {
        url: string;
        /**
         * @deprecated use components.Search.dashboardItem from Grafana 8.3 instead
         */
        dashboards: (title: string) => string;
    };
    SaveDashboardAsModal: {
        newName: string;
        save: string;
    };
    SaveDashboardModal: {
        save: string;
        saveVariables: string;
        saveTimerange: string;
    };
    SharePanelModal: {
        linkToRenderedImage: string;
    };
    ShareDashboardModal: {
        shareButton: string;
        PublicDashboard: {
            Tab: string;
            WillBePublicCheckbox: string;
            LimitedDSCheckbox: string;
            CostIncreaseCheckbox: string;
            PauseSwitch: string;
            EnableAnnotationsSwitch: string;
            CreateButton: string;
            DeleteButton: string;
            CopyUrlInput: string;
            CopyUrlButton: string;
            TemplateVariablesWarningAlert: string;
            UnsupportedDataSourcesWarningAlert: string;
            NoUpsertPermissionsWarningAlert: string;
            EnableTimeRangeSwitch: string;
            EmailSharingConfiguration: {
                Container: string;
                ShareType: string;
                EmailSharingInput: string;
                EmailSharingInviteButton: string;
                EmailSharingList: string;
                DeleteEmail: string;
                ReshareLink: string;
            };
        };
    };
    PublicDashboard: {
        page: string;
        NotAvailable: {
            container: string;
            title: string;
            pausedDescription: string;
        };
    };
    RequestViewAccess: {
        form: string;
        recipientInput: string;
        submitButton: string;
    };
    Explore: {
        url: string;
        General: {
            container: string;
            graph: string;
            table: string;
            scrollView: string;
        };
    };
    SoloPanel: {
        url: (page: string) => string;
    };
    PluginsList: {
        page: string;
        list: string;
        listItem: string;
        signatureErrorNotice: string;
    };
    PluginPage: {
        page: string;
        signatureInfo: string;
        disabledInfo: string;
    };
    PlaylistForm: {
        name: string;
        interval: string;
        itemDelete: string;
    };
    Search: {
        url: string;
        FolderView: {
            url: string;
        };
    };
    PublicDashboards: {
        ListItem: {
            linkButton: string;
            configButton: string;
            trashcanButton: string;
        };
    };
    UserListPage: {
        org: {
            url: string;
        };
        admin: {
            url: string;
        };
    };
};

/**
 * Exposes selectors in package for easy use in e2e tests and in production code
 *
 * @alpha
 */
declare const selectors: {
    pages: E2ESelectors<typeof Pages>;
    components: E2ESelectors<typeof Components>;
};

export { Components, CssSelector, E2ESelectors, FunctionSelector, Pages, Selectors, StringSelector, UrlSelector, selectors };
