---
aliases:
  - ../http_api/
  - ../overview/
canonical: /docs/grafana/latest/developers/http_api/
description: Grafana HTTP API
keywords:
  - grafana
  - http
  - documentation
  - api
  - overview
title: HTTP API
weight: 100
---

# HTTP API reference

The Grafana backend exposes an HTTP API, which is the same API that is used by the frontend to do everything from saving
dashboards, creating users, and updating data sources.

Since version 8.4, HTTP API details are [specified](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/public/api-merged.json) using OpenAPI v2.

Starting from version 9.1, there is also a [OpenAPI v3 specification](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/public/openapi3.json) (generated by the v2 one).

Users can browser and try out both via the Swagger UI editor (served by the grafana server) by navigating to `/swagger-ui` and `/openapi3` respectively.

## HTTP APIs

- [Admin API]({{< relref "admin/" >}})
- [Alerting API (unstable)](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/pkg/services/ngalert/api/tooling/post.json)
- [Alerting Provisioning API]({{< relref "alerting_provisioning/" >}})
- [Annotations API]({{< relref "annotations/" >}})
- [Authentication API]({{< relref "auth/" >}})
- [Correlations API]({{< relref "correlations/" >}})
- [Dashboard API]({{< relref "dashboard/" >}})
- [Dashboard Permissions API]({{< relref "dashboard_permissions/" >}})
- [Dashboard Versions API]({{< relref "dashboard_versions/" >}})
- [Data source API]({{< relref "data_source/" >}})
- [Folder API]({{< relref "folder/" >}})
- [Folder Permissions API]({{< relref "folder_permissions/" >}})
- [Folder/Dashboard Search API]({{< relref "folder_dashboard_search/" >}})
- [Library Element API]({{< relref "library_element/" >}})
- [Organization API]({{< relref "org/" >}})
- [Other API]({{< relref "other/" >}})
- [Playlists API]({{< relref "playlist/" >}})
- [Preferences API]({{< relref "preferences/" >}})
- [Short URL API]({{< relref "short_url/" >}})
- [Query history API]({{< relref "query_history/" >}})
- [Snapshot API]({{< relref "snapshot/" >}})
- [Team API]({{< relref "team/" >}})
- [User API]({{< relref "user/" >}})

## Deprecated HTTP APIs

- [Alerting Notification Channels API]({{< relref "alerting_notification_channels/" >}})
- [Alerting API]({{< relref "alerting/" >}})

## Grafana Enterprise HTTP APIs

Grafana Enterprise includes all of the Grafana OSS APIs as well as those that follow:

- [Role-based access control API]({{< relref "access_control/" >}})
- [Data source permissions API]({{< relref "datasource_permissions/" >}})
- [Team sync API]({{< relref "team_sync/" >}})
- [License API]({{< relref "licensing/" >}})
- [Reporting API]({{< relref "reporting/" >}})
