import { FunctionalVector } from './FunctionalVector.js';

class ArrayVector extends FunctionalVector {
  constructor(buffer) {
    super();
    this.buffer = buffer ? buffer : [];
  }
  get length() {
    return this.buffer.length;
  }
  add(value) {
    this.buffer.push(value);
  }
  get(index) {
    return this.buffer[index];
  }
  set(index, value) {
    this.buffer[index] = value;
  }
  reverse() {
    this.buffer.reverse();
  }
  toArray() {
    return this.buffer;
  }
  toJSON() {
    return this.buffer;
  }
}

export { ArrayVector };
//# sourceMappingURL=ArrayVector.js.map
