import { makeClassES5Compatible } from '../utils/makeClassES5Compatible.js';
import { GrafanaPlugin } from './plugin.js';

class DataSourcePlugin extends GrafanaPlugin {
  constructor(DataSourceClass) {
    super();
    this.DataSourceClass = DataSourceClass;
    this.components = {};
  }
  setConfigEditor(editor) {
    this.components.ConfigEditor = editor;
    return this;
  }
  setConfigCtrl(ConfigCtrl) {
    this.angularConfigCtrl = ConfigCtrl;
    return this;
  }
  setQueryCtrl(QueryCtrl) {
    this.components.QueryCtrl = QueryCtrl;
    return this;
  }
  setAnnotationQueryCtrl(AnnotationsQueryCtrl) {
    this.components.AnnotationsQueryCtrl = AnnotationsQueryCtrl;
    return this;
  }
  setQueryEditor(QueryEditor) {
    this.components.QueryEditor = QueryEditor;
    return this;
  }
  /** @deprecated Use `setQueryEditor` instead. When using Explore `props.app` is equal to `CoreApp.Explore` */
  setExploreQueryField(ExploreQueryField) {
    this.components.ExploreQueryField = ExploreQueryField;
    return this;
  }
  /** @deprecated Use `setQueryEditor` instead. */
  setExploreMetricsQueryField(ExploreQueryField) {
    this.components.ExploreMetricsQueryField = ExploreQueryField;
    return this;
  }
  /** @deprecated Use `setQueryEditor` instead. */
  setExploreLogsQueryField(ExploreQueryField) {
    this.components.ExploreLogsQueryField = ExploreQueryField;
    return this;
  }
  setQueryEditorHelp(QueryEditorHelp) {
    this.components.QueryEditorHelp = QueryEditorHelp;
    return this;
  }
  /**
   * @deprecated prefer using `setQueryEditorHelp`
   */
  setExploreStartPage(ExploreStartPage) {
    return this.setQueryEditorHelp(ExploreStartPage);
  }
  /**
   * @deprecated -- prefer using {@link StandardVariableSupport} or {@link CustomVariableSupport} or {@link DataSourceVariableSupport} in data source instead
   */
  setVariableQueryEditor(VariableQueryEditor) {
    this.components.VariableQueryEditor = VariableQueryEditor;
    return this;
  }
  setMetadataInspector(MetadataInspector) {
    this.components.MetadataInspector = MetadataInspector;
    return this;
  }
  setComponentsFromLegacyExports(pluginExports) {
    this.angularConfigCtrl = pluginExports.ConfigCtrl;
    this.components.QueryCtrl = pluginExports.QueryCtrl;
    this.components.AnnotationsQueryCtrl = pluginExports.AnnotationsQueryCtrl;
    this.components.ExploreQueryField = pluginExports.ExploreQueryField;
    this.components.QueryEditor = pluginExports.QueryEditor;
    this.components.QueryEditorHelp = pluginExports.QueryEditorHelp;
    this.components.VariableQueryEditor = pluginExports.VariableQueryEditor;
  }
}
class DataSourceApi {
  constructor(instanceSettings) {
    this.name = instanceSettings.name;
    this.id = instanceSettings.id;
    this.type = instanceSettings.type;
    this.meta = instanceSettings.meta;
    this.cachingConfig = instanceSettings.cachingConfig;
    this.uid = instanceSettings.uid;
  }
  /** Get an identifier object for this datasource instance */
  getRef() {
    return { type: this.type, uid: this.uid };
  }
}
var ExploreMode = /* @__PURE__ */ ((ExploreMode2) => {
  ExploreMode2["Logs"] = "Logs";
  ExploreMode2["Metrics"] = "Metrics";
  ExploreMode2["Tracing"] = "Tracing";
  return ExploreMode2;
})(ExploreMode || {});
var DataQueryErrorType = /* @__PURE__ */ ((DataQueryErrorType2) => {
  DataQueryErrorType2["Cancelled"] = "cancelled";
  DataQueryErrorType2["Timeout"] = "timeout";
  DataQueryErrorType2["Unknown"] = "unknown";
  return DataQueryErrorType2;
})(DataQueryErrorType || {});
class LanguageProvider {
}
LanguageProvider = makeClassES5Compatible(LanguageProvider);
DataSourceApi = makeClassES5Compatible(DataSourceApi);

export { DataQueryErrorType, DataSourceApi, DataSourcePlugin, ExploreMode, LanguageProvider };
//# sourceMappingURL=datasource.js.map
