import { GrafanaPlugin, PluginIncludeType } from './plugin.js';
import { PluginExtensionTypes } from './pluginExtensions.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var CoreApp = /* @__PURE__ */ ((CoreApp2) => {
  CoreApp2["CloudAlerting"] = "cloud-alerting";
  CoreApp2["UnifiedAlerting"] = "unified-alerting";
  CoreApp2["Dashboard"] = "dashboard";
  CoreApp2["Explore"] = "explore";
  CoreApp2["Correlations"] = "correlations";
  CoreApp2["Unknown"] = "unknown";
  CoreApp2["PanelEditor"] = "panel-editor";
  CoreApp2["PanelViewer"] = "panel-viewer";
  return CoreApp2;
})(CoreApp || {});
class AppPlugin extends GrafanaPlugin {
  constructor() {
    super(...arguments);
    this._extensionConfigs = [];
  }
  /**
   * Called after the module has loaded, and before the app is used.
   * This function may be called multiple times on the same instance.
   * The first time, `this.meta` will be undefined
   */
  init(meta) {
  }
  /**
   * Set the component displayed under:
   *   /a/${plugin-id}/*
   *
   * If the NavModel is configured, the page will have a managed frame, otheriwse it has full control.
   */
  setRootPage(root) {
    this.root = root;
    return this;
  }
  setComponentsFromLegacyExports(pluginExports) {
    if (pluginExports.ConfigCtrl) {
      this.angularConfigCtrl = pluginExports.ConfigCtrl;
    }
    if (this.meta && this.meta.includes) {
      for (const include of this.meta.includes) {
        if (include.type === PluginIncludeType.page && include.component) {
          const exp = pluginExports[include.component];
          if (!exp) {
            console.warn("App Page uses unknown component: ", include.component, this.meta);
            continue;
          }
        }
      }
    }
  }
  get extensionConfigs() {
    return this._extensionConfigs;
  }
  configureExtensionLink(extension) {
    this._extensionConfigs.push(__spreadProps(__spreadValues({}, extension), {
      type: PluginExtensionTypes.link
    }));
    return this;
  }
}
var FeatureState = /* @__PURE__ */ ((FeatureState2) => {
  FeatureState2["alpha"] = "alpha";
  FeatureState2["beta"] = "beta";
  return FeatureState2;
})(FeatureState || {});

export { AppPlugin, CoreApp, FeatureState };
//# sourceMappingURL=app.js.map
