import { isDate, includes } from 'lodash';
import { isDateTime, dateTime, dateTimeForTimeZone, ISO_8601 } from './moment_wrapper.js';

const units = ["y", "M", "w", "d", "h", "m", "s", "Q"];
function isMathString(text) {
  if (!text) {
    return false;
  }
  if (typeof text === "string" && (text.substring(0, 3) === "now" || text.includes("||"))) {
    return true;
  } else {
    return false;
  }
}
function parse(text, roundUp, timezone, fiscalYearStartMonth) {
  if (!text) {
    return void 0;
  }
  if (typeof text !== "string") {
    if (isDateTime(text)) {
      return text;
    }
    if (isDate(text)) {
      return dateTime(text);
    }
    return void 0;
  } else {
    let time;
    let mathString = "";
    let index;
    let parseString;
    if (text.substring(0, 3) === "now") {
      time = dateTimeForTimeZone(timezone);
      mathString = text.substring("now".length);
    } else {
      index = text.indexOf("||");
      if (index === -1) {
        parseString = text;
        mathString = "";
      } else {
        parseString = text.substring(0, index);
        mathString = text.substring(index + 2);
      }
      time = dateTime(parseString, ISO_8601);
    }
    if (!mathString.length) {
      return time;
    }
    return parseDateMath(mathString, time, roundUp, fiscalYearStartMonth);
  }
}
function isValid(text) {
  const date = parse(text);
  if (!date) {
    return false;
  }
  if (isDateTime(date)) {
    return date.isValid();
  }
  return false;
}
function parseDateMath(mathString, time, roundUp, fiscalYearStartMonth = 0) {
  const strippedMathString = mathString.replace(/\s/g, "");
  const dateTime2 = time;
  let i = 0;
  const len = strippedMathString.length;
  while (i < len) {
    const c = strippedMathString.charAt(i++);
    let type;
    let num;
    let unit;
    let isFiscal = false;
    if (c === "/") {
      type = 0;
    } else if (c === "+") {
      type = 1;
    } else if (c === "-") {
      type = 2;
    } else {
      return void 0;
    }
    if (isNaN(parseInt(strippedMathString.charAt(i), 10))) {
      num = 1;
    } else if (strippedMathString.length === 2) {
      num = parseInt(strippedMathString.charAt(i), 10);
    } else {
      const numFrom = i;
      while (!isNaN(parseInt(strippedMathString.charAt(i), 10))) {
        i++;
        if (i > 10) {
          return void 0;
        }
      }
      num = parseInt(strippedMathString.substring(numFrom, i), 10);
    }
    if (type === 0) {
      if (num !== 1) {
        return void 0;
      }
    }
    unit = strippedMathString.charAt(i++);
    if (unit === "f") {
      unit = strippedMathString.charAt(i++);
      isFiscal = true;
    }
    if (!includes(units, unit)) {
      return void 0;
    } else {
      if (type === 0) {
        if (roundUp) {
          if (isFiscal) {
            roundToFiscal(fiscalYearStartMonth, dateTime2, unit, roundUp);
          } else {
            dateTime2.endOf(unit);
          }
        } else {
          if (isFiscal) {
            roundToFiscal(fiscalYearStartMonth, dateTime2, unit, roundUp);
          } else {
            dateTime2.startOf(unit);
          }
        }
      } else if (type === 1) {
        dateTime2.add(num, unit);
      } else if (type === 2) {
        dateTime2.subtract(num, unit);
      }
    }
  }
  return dateTime2;
}
function roundToFiscal(fyStartMonth, dateTime2, unit, roundUp) {
  switch (unit) {
    case "y":
      if (roundUp) {
        roundToFiscal(fyStartMonth, dateTime2, unit, false).add(11, "M").endOf("M");
      } else {
        dateTime2.subtract((dateTime2.month() - fyStartMonth + 12) % 12, "M").startOf("M");
      }
      return dateTime2;
    case "Q":
      if (roundUp) {
        roundToFiscal(fyStartMonth, dateTime2, unit, false).add(2, "M").endOf("M");
      } else {
        dateTime2.subtract((dateTime2.month() - fyStartMonth + 3) % 3, "M").startOf("M");
      }
      return dateTime2;
    default:
      return void 0;
  }
}

export { isMathString, isValid, parse, parseDateMath, roundToFiscal };
//# sourceMappingURL=datemath.js.map
