import { FunctionalVector } from '../vector/FunctionalVector.js';
import { vectorToArray } from '../vector/vectorToArray.js';
import { guessFieldTypeFromNameAndValue, toDataFrameDTO } from './processDataFrame.js';

const NOOP = (v) => v;
class ArrayPropertyVector {
  constructor(source, prop) {
    this.source = source;
    this.prop = prop;
    this.converter = NOOP;
  }
  get length() {
    return this.source.length;
  }
  get(index) {
    return this.converter(this.source[index][this.prop]);
  }
  toArray() {
    return vectorToArray(this);
  }
  toJSON() {
    return vectorToArray(this);
  }
}
class ArrayDataFrame extends FunctionalVector {
  constructor(source, names) {
    super();
    this.source = source;
    this.fields = [];
    this.length = 0;
    this.length = source.length;
    const first = source.length ? source[0] : {};
    if (names) {
      this.fields = names.map((name) => {
        return {
          name,
          type: guessFieldTypeFromNameAndValue(name, first[name]),
          config: {},
          values: new ArrayPropertyVector(source, name)
        };
      });
    } else {
      this.setFieldsFromObject(first);
    }
  }
  /**
   * Add a field for each property in the object.  This will guess the type
   */
  setFieldsFromObject(obj) {
    this.fields = Object.keys(obj).map((name) => {
      return {
        name,
        type: guessFieldTypeFromNameAndValue(name, obj[name]),
        config: {},
        values: new ArrayPropertyVector(this.source, name)
      };
    });
  }
  /**
   * Configure how the object property is passed to the data frame
   */
  setFieldType(name, type, converter) {
    let field = this.fields.find((f) => f.name === name);
    if (field) {
      field.type = type;
    } else {
      field = {
        name,
        type,
        config: {},
        values: new ArrayPropertyVector(this.source, name)
      };
      this.fields.push(field);
    }
    field.values.converter = converter != null ? converter : NOOP;
    return field;
  }
  /**
   * Get an object with a property for each field in the DataFrame
   */
  get(idx) {
    return this.source[idx];
  }
  /**
   * The simplified JSON values used in JSON.stringify()
   */
  toJSON() {
    return toDataFrameDTO(this);
  }
}

export { ArrayDataFrame };
//# sourceMappingURL=ArrayDataFrame.js.map
