import { cx, css } from '@emotion/css';
import React__default from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { InlineList } from '../List/InlineList.js';
import { List } from '../List/List.js';
import { VizLegendListItem } from './VizLegendListItem.js';

const VizLegendList = ({
  items,
  itemRenderer,
  onLabelMouseOver,
  onLabelMouseOut,
  onLabelClick,
  placement,
  className,
  readonly
}) => {
  const styles = useStyles2(getStyles);
  if (!itemRenderer) {
    itemRenderer = (item) => /* @__PURE__ */ React__default.createElement(
      VizLegendListItem,
      {
        item,
        onLabelClick,
        onLabelMouseOver,
        onLabelMouseOut,
        readonly
      }
    );
  }
  const getItemKey = (item) => `${item.getItemKey ? item.getItemKey() : item.label}`;
  switch (placement) {
    case "right": {
      const renderItem = (item, index) => {
        return /* @__PURE__ */ React__default.createElement("span", { className: styles.itemRight }, itemRenderer(item, index));
      };
      return /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.rightWrapper, className) }, /* @__PURE__ */ React__default.createElement(List, { items, renderItem, getItemKey }));
    }
    case "bottom":
    default: {
      const renderItem = (item, index) => {
        return /* @__PURE__ */ React__default.createElement("span", { className: styles.itemBottom }, itemRenderer(item, index));
      };
      return /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.bottomWrapper, className) }, /* @__PURE__ */ React__default.createElement("div", { className: styles.section }, /* @__PURE__ */ React__default.createElement(
        InlineList,
        {
          items: items.filter((item) => item.yAxis === 1),
          renderItem,
          getItemKey
        }
      )), /* @__PURE__ */ React__default.createElement("div", { className: cx(styles.section, styles.sectionRight) }, /* @__PURE__ */ React__default.createElement(
        InlineList,
        {
          items: items.filter((item) => item.yAxis !== 1),
          renderItem,
          getItemKey
        }
      )));
    }
  }
};
VizLegendList.displayName = "VizLegendList";
const getStyles = (theme) => {
  const itemStyles = css`
    padding-right: 10px;
    display: flex;
    font-size: ${theme.typography.bodySmall.fontSize};
    white-space: nowrap;
  `;
  return {
    itemBottom: itemStyles,
    itemRight: cx(
      itemStyles,
      css`
        margin-bottom: ${theme.spacing(0.5)};
      `
    ),
    rightWrapper: css`
      padding-left: ${theme.spacing(0.5)};
    `,
    bottomWrapper: css`
      display: flex;
      flex-wrap: wrap;
      justify-content: space-between;
      width: 100%;
      padding-left: ${theme.spacing(0.5)};
    `,
    section: css`
      display: flex;
    `,
    sectionRight: css`
      justify-content: flex-end;
      flex-grow: 1;
    `
  };
};

export { VizLegendList };
//# sourceMappingURL=VizLegendList.js.map
