import React__default, { useEffect } from 'react';
import { usePopperTooltip } from 'react-popper-tooltip';
import { useStyles2 } from '../../themes/ThemeContext.js';
import { buildTooltipTheme } from '../../utils/tooltipUtils.js';
import { Portal } from '../Portal/Portal.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const Tooltip = React__default.memo(({ children, theme, interactive, show, placement, content }) => {
  const [controlledVisible, setControlledVisible] = React__default.useState(show);
  useEffect(() => {
    if (controlledVisible !== false) {
      const handleKeyDown = (enterKey) => {
        if (enterKey.key === "Escape") {
          setControlledVisible(false);
        }
      };
      document.addEventListener("keydown", handleKeyDown);
      return () => {
        document.removeEventListener("keydown", handleKeyDown);
      };
    } else {
      return;
    }
  }, [controlledVisible]);
  const { getArrowProps, getTooltipProps, setTooltipRef, setTriggerRef, visible, update } = usePopperTooltip({
    visible: controlledVisible,
    placement,
    interactive,
    delayHide: interactive ? 100 : 0,
    delayShow: 150,
    offset: [0, 8],
    trigger: ["hover", "focus"],
    onVisibleChange: setControlledVisible
  });
  const styles = useStyles2(getStyles);
  const style = styles[theme != null ? theme : "info"];
  return /* @__PURE__ */ React__default.createElement(React__default.Fragment, null, React__default.cloneElement(children, {
    ref: setTriggerRef,
    tabIndex: 0
    // tooltip should be keyboard focusable
  }), visible && /* @__PURE__ */ React__default.createElement(Portal, null, /* @__PURE__ */ React__default.createElement("div", __spreadValues({ ref: setTooltipRef }, getTooltipProps({ className: style.container })), /* @__PURE__ */ React__default.createElement("div", __spreadValues({}, getArrowProps({ className: style.arrow }))), typeof content === "string" && content, React__default.isValidElement(content) && React__default.cloneElement(content), typeof content === "function" && update && content({
    updatePopperPosition: update
  }))));
});
Tooltip.displayName = "Tooltip";
const getStyles = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.components.tooltip.background,
    theme.components.tooltip.background,
    theme.components.tooltip.text,
    { topBottom: 0.5, rightLeft: 1 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 0.5, rightLeft: 1 }
  );
  return {
    info,
    ["info-alt"]: info,
    error
  };
};

export { Tooltip, getStyles };
//# sourceMappingURL=Tooltip.js.map
