import { cx, css } from '@emotion/css';
import React__default, { memo, forwardRef } from 'react';
import { useTheme2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { Tag } from './Tag.js';

const TagList = memo(
  forwardRef(({ displayMax, tags, icon, onClick, className, getAriaLabel }, ref) => {
    const theme = useTheme2();
    const styles = getStyles(theme, Boolean(displayMax && displayMax > 0));
    const numTags = tags.length;
    const tagsToDisplay = displayMax ? tags.slice(0, displayMax) : tags;
    return /* @__PURE__ */ React__default.createElement("ul", { className: cx(styles.wrapper, className), "aria-label": "Tags", ref }, tagsToDisplay.map((tag, i) => /* @__PURE__ */ React__default.createElement("li", { className: styles.li, key: tag }, /* @__PURE__ */ React__default.createElement(Tag, { name: tag, icon, onClick, "aria-label": getAriaLabel == null ? void 0 : getAriaLabel(tag, i), "data-tag-id": i }))), displayMax && displayMax > 0 && numTags - displayMax > 0 && /* @__PURE__ */ React__default.createElement("span", { className: styles.moreTagsLabel }, "+ ", numTags - displayMax));
  })
);
TagList.displayName = "TagList";
const getStyles = (theme, isTruncated) => {
  return {
    wrapper: css`
      position: relative;
      align-items: ${isTruncated ? "center" : "unset"};
      display: flex;
      flex: 1 1 auto;
      flex-wrap: wrap;
      flex-shrink: ${isTruncated ? 0 : 1};
      justify-content: flex-end;
      gap: 6px;
    `,
    moreTagsLabel: css`
      color: ${theme.colors.text.secondary};
      font-size: ${theme.typography.size.sm};
    `,
    li: css({
      listStyle: "none"
    })
  };
};

export { TagList };
//# sourceMappingURL=TagList.js.map
