import { css } from '@emotion/css';
import React__default from 'react';
import { locale } from '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';

const getStyles = stylesFactory((theme) => {
  return {
    counter: css`
      label: counter;
      margin-left: ${theme.spacing(1)};
      border-radius: ${theme.spacing(3)};
      background-color: ${theme.colors.action.hover};
      padding: ${theme.spacing(0.25, 1)};
      color: ${theme.colors.text.secondary};
      font-weight: ${theme.typography.fontWeightMedium};
      font-size: ${theme.typography.size.sm};
    `
  };
});
const Counter = ({ value }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ React__default.createElement("span", { className: styles.counter }, locale(value, 0).text);
};

export { Counter };
//# sourceMappingURL=Counter.js.map
