import { css, cx } from '@emotion/css';
import React__default from 'react';
import '../../themes/ThemeContext.js';
import '@grafana/data';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import { Icon } from '../Icon/Icon.js';

const getStyles = stylesFactory((size, inline) => {
  return {
    wrapper: css`
      font-size: ${size}px;
      ${inline ? css`
            display: inline-block;
          ` : ""}
    `
  };
});
const Spinner = ({ className, inline = false, iconClassName, style, size = 16 }) => {
  const styles = getStyles(size, inline);
  return /* @__PURE__ */ React__default.createElement("div", { "data-testid": "Spinner", style, className: cx(styles.wrapper, className) }, /* @__PURE__ */ React__default.createElement(Icon, { className: cx("fa-spin", iconClassName), name: "fa fa-spinner" }));
};

export { Spinner };
//# sourceMappingURL=Spinner.js.map
