import { css } from '@emotion/css';
import React__default from 'react';
import { useStyles2 } from '../../themes/ThemeContext.js';
import '@grafana/data';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { ToolbarButton } from '../ToolbarButton/ToolbarButton.js';

function PanelStatus({ message, onClick, ariaLabel = "status" }) {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ React__default.createElement(
    ToolbarButton,
    {
      className: styles.buttonStyles,
      onClick,
      variant: "destructive",
      icon: "exclamation-triangle",
      iconSize: "md",
      tooltip: message || "",
      "aria-label": ariaLabel
    }
  );
}
const getStyles = (theme) => {
  const { headerHeight, padding } = theme.components.panel;
  return {
    buttonStyles: css({
      label: "panel-header-state-button",
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      padding: theme.spacing(padding),
      width: theme.spacing(headerHeight),
      height: theme.spacing(headerHeight),
      borderRadius: theme.shape.radius.default
    })
  };
};

export { PanelStatus };
//# sourceMappingURL=PanelStatus.js.map
