import { css } from '@emotion/css';
import React__default, { PureComponent } from 'react';
import { monacoLanguageRegistry } from '@grafana/data';
import { selectors } from '@grafana/e2e-selectors';
import { withTheme2 } from '../../themes/ThemeContext.js';
import 'memoize-one';
import '@emotion/react';
import 'tinycolor2';
import { ReactMonacoEditorLazy } from './ReactMonacoEditorLazy.js';
import { registerSuggestions } from './suggestions.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
class UnthemedCodeEditor extends PureComponent {
  constructor(props) {
    super(props);
    this.loadCustomLanguage = () => {
      const { language } = this.props;
      const customLanguage = monacoLanguageRegistry.getIfExists(language);
      if (customLanguage) {
        return customLanguage.init();
      }
      return Promise.resolve();
    };
    // This is replaced with a real function when the actual editor mounts
    this.getEditorValue = () => "";
    this.onBlur = () => {
      const { onBlur } = this.props;
      if (onBlur) {
        onBlur(this.getEditorValue());
      }
    };
    this.onSave = () => {
      const { onSave } = this.props;
      if (onSave) {
        onSave(this.getEditorValue());
      }
    };
    this.handleBeforeMount = (monaco) => {
      this.monaco = monaco;
      const { language, getSuggestions, onBeforeEditorMount } = this.props;
      if (getSuggestions) {
        this.completionCancel = registerSuggestions(monaco, language, getSuggestions);
      }
      onBeforeEditorMount == null ? void 0 : onBeforeEditorMount(monaco);
    };
    this.handleOnMount = (editor, monaco) => {
      var _a;
      const { onChange, onEditorDidMount } = this.props;
      this.getEditorValue = () => editor.getValue();
      editor.addCommand(monaco.KeyMod.CtrlCmd | monaco.KeyCode.KeyS, this.onSave);
      const languagePromise = this.loadCustomLanguage();
      if (onEditorDidMount) {
        languagePromise.then(() => onEditorDidMount(editor, monaco));
        (_a = editor.getModel()) == null ? void 0 : _a.onDidChangeContent(() => onChange == null ? void 0 : onChange(editor.getValue()));
      }
    };
  }
  componentWillUnmount() {
    if (this.completionCancel) {
      this.completionCancel.dispose();
    }
  }
  componentDidUpdate(oldProps) {
    const { getSuggestions, language } = this.props;
    const newLanguage = oldProps.language !== language;
    const newGetSuggestions = oldProps.getSuggestions !== getSuggestions;
    if (newGetSuggestions || newLanguage) {
      if (this.completionCancel) {
        this.completionCancel.dispose();
      }
      if (!this.monaco) {
        console.warn("Monaco instance not loaded yet");
        return;
      }
      if (getSuggestions) {
        this.completionCancel = registerSuggestions(this.monaco, language, getSuggestions);
      }
    }
    if (newLanguage) {
      this.loadCustomLanguage();
    }
  }
  render() {
    var _a, _b;
    const { theme, language, width, height, showMiniMap, showLineNumbers, readOnly, monacoOptions } = this.props;
    const value = (_a = this.props.value) != null ? _a : "";
    const longText = value.length > 100;
    const containerStyles = (_b = this.props.containerStyles) != null ? _b : getStyles(theme).container;
    const options = {
      wordWrap: "off",
      tabSize: 2,
      codeLens: false,
      contextmenu: false,
      minimap: {
        enabled: longText && showMiniMap,
        renderCharacters: false
      },
      readOnly,
      lineNumbersMinChars: 4,
      lineDecorationsWidth: 1 * theme.spacing.gridSize,
      overviewRulerBorder: false,
      automaticLayout: true,
      padding: {
        top: 0.5 * theme.spacing.gridSize,
        bottom: 0.5 * theme.spacing.gridSize
      },
      fixedOverflowWidgets: true
      // Ensures suggestions menu is drawn on top
    };
    if (!showLineNumbers) {
      options.glyphMargin = false;
      options.folding = false;
      options.lineNumbers = "off";
      options.lineNumbersMinChars = 0;
    }
    return /* @__PURE__ */ React__default.createElement("div", { className: containerStyles, onBlur: this.onBlur, "aria-label": selectors.components.CodeEditor.container }, /* @__PURE__ */ React__default.createElement(
      ReactMonacoEditorLazy,
      {
        width,
        height,
        language,
        value,
        options: __spreadValues(__spreadValues({}, options), monacoOptions != null ? monacoOptions : {}),
        beforeMount: this.handleBeforeMount,
        onMount: this.handleOnMount
      }
    ));
  }
}
const CodeEditor = withTheme2(UnthemedCodeEditor);
const getStyles = (theme) => {
  return {
    container: css`
      border-radius: ${theme.shape.borderRadius()};
      border: 1px solid ${theme.components.input.borderColor};
    `
  };
};

export { CodeEditor };
//# sourceMappingURL=CodeEditor.js.map
